/* vdisk.h
 *   structures for virtual disk management 
 */


#define NVDISK 8		/* number of virtual disks */


typedef struct {
	byte	sec_lo, sec_hi;		/* sector with error */
	byte	cstat;			/* communication status */
	byte	hstat; 			/* hardware status */
	byte	resv[4];		/* reserved */
} errormap;

typedef struct emaplist {
	errormap emap;			/* errormap structure */
	struct emaplist *next;		/* next entry */
} emaplist;	


struct vdisk {
	enum { 		NONE,			/* not mounted */
			RAMDISK,		/* ramdisk */
			SIO2PC,			/* SIO2PC image file */
			ESIO2PC,		/* Extended SIO2PC image */
			XFD,			/* Xformer image file */
			DCM,			/* DiskComm'ed file */
			PSIO,			/* Parallel SIO adapter */
			RSIO			/* RS-232 SIO adapter */
	      }	type;		/* type of disk */
	int	nsec;		/* number of sectors */
	int	secsize;	/* number of bytes per sector */
	FILE	*file;		/* file for disk image */
	char	fname[80];	/* filename for image */
	byte	*ram;		/* memory for ramdisk */
	int	writeable;	/* True if disk can be written */
	int	timeout;	/* timeout in milliseconds */
	byte	cstat;		/* communication status */
	byte	hstat;		/* hardware status */
	byte	dev;		/* device ID for real devices */
	emaplist *elist;	/* list of errormap entries */
	int	nerr;		/* number of bad sectors */
};


#ifndef VDISK_GLOBAL
#define VDISK_GLOBAL extern
#endif

VDISK_GLOBAL struct vdisk vdisk[NVDISK+1];


int vdisk_mount_file(int drive, char *fname);
int vdisk_mount_ram(int drive, int nsec, int secsize);
int vdisk_load_ram(int drive, char *fname);
int vdisk_save_ram(int drive, char *fname);
int vdisk_unmount(int drive);
char *vdisk_info(int drive);
int vdisk_read_sec(int drive, int sec, byte *buf);
int vdisk_write_sec(int drive, int sec, byte *buf);
int vdisk_write_bad_sec(int drive, int sec, byte *buf);
int vdisk_get_size(int drive, int *nsec, int *secsize);
int vdisk_get_secsize(int drive, int sec);
int vdisk_status(int drive, byte *buf);
int vdisk_init(int argc, char **argv);
void vdisk_end(void);
int vdisk_mounted(int drive);

