/*
Copyright (c) 1998 Richard Lawrence

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// CGraphicsDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Atari800Win.h"
#include "CGraphicsDlg.h"
#include "winatari.h"
#include "registry.h"
#include "GraphicsDesc.h"
#include "CWarnDlg.h"
#include "resource.h"
#include "ddraw.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern "C" LPDIRECTDRAW		lpDirectDrawObject;

extern "C" void WriteRegDWORD( HKEY hkInput, char *item, DWORD value);
static ULONG unNewDDrawMode;
extern "C" ULONG	ulScreenMode;
extern "C" int Init_Graphics( void );
extern "C" ULONG *atari_screen;

extern "C" ULONG	ulDontShowFlags;
extern "C" unsigned long ulModesAvail;
/////////////////////////////////////////////////////////////////////////////
// CGraphicsDlg dialog


CGraphicsDlg::CGraphicsDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGraphicsDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGraphicsDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CGraphicsDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGraphicsDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGraphicsDlg, CDialog)
	//{{AFX_MSG_MAP(CGraphicsDlg)
	ON_BN_CLICKED(IDC_MODE_320X200_CLIP, OnMode320x200Clip)
	ON_BN_CLICKED(IDC_MODE_320X240_PARTCLIP, OnMode320x240Partclip)
	ON_BN_CLICKED(IDC_MODE_640x400_CLIP, OnMODE640x400CLIP)
	ON_BN_CLICKED(IDC_MODE_640X480_PARTCLIP, OnMode640x480Partclip)
	ON_BN_CLICKED(IDC_MODE_800X600, OnMode800x600)
	ON_BN_CLICKED(IDC_NODIRECTDRAW, OnNodirectdraw)
	ON_BN_CLICKED(IDC_DDRAW_WINDOWED, OnDdrawWindowed)
	ON_BN_CLICKED(IDC_384X240_WINDOWED, On384x240Windowed)
	ON_BN_CLICKED(IDC_768x480_WINDOWED, On768x480WINDOWED)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGraphicsDlg message handlers

void CGraphicsDlg::SetGraphicsDesc( void )
{
	CButton *cbButton = NULL;
	HANDLE	icon = NULL;
	CStatic* iconDisp = (CStatic *)GetDlgItem( IDC_SIZE_ICON );
	char	message[LOADSTRING_STRING_SIZE];
	int i;
	static int	iDlgItems[ 5 ] = { 
		IDC_MODE_320X200_CLIP, 
		IDC_MODE_320X240_PARTCLIP,
		IDC_MODE_640x400_CLIP,
		IDC_MODE_640X480_PARTCLIP,
		IDC_MODE_800X600 };

	if( !(unNewDDrawMode & DDRAW_FULL) && ((unNewDDrawMode & DDRAW_NONE) || (unNewDDrawMode & DDRAW_WIND)) )
	{
		//If we're in a windowed mode, disable the full screen res buttons
		for( i=0; i < 5; i++ )
		{
			cbButton = (CButton *)GetDlgItem( iDlgItems[i] );
			if( cbButton )
				cbButton->EnableWindow( FALSE );
		}

		//Enable the window res buttons (they may be disabled from previous selections)
		cbButton = (CButton *)GetDlgItem( IDC_384X240_WINDOWED );
		if( cbButton )
			cbButton->EnableWindow( TRUE );

		cbButton = (CButton *)GetDlgItem( IDC_768x480_WINDOWED );
		if( cbButton )
			cbButton->EnableWindow( TRUE );

		if( unNewDDrawMode & WINDOWED_384_240 )
			CheckRadioButton( IDC_384X240_WINDOWED, IDC_768x480_WINDOWED, IDC_384X240_WINDOWED );			
		else
			CheckRadioButton( IDC_384X240_WINDOWED, IDC_768x480_WINDOWED, IDC_768x480_WINDOWED );			

		//Windowed modes are always full overscan
		icon = AfxGetApp()->LoadIcon( IDI_FULL_OVERSCAN );
		if( icon && iconDisp )
			iconDisp->SetIcon( (HICON)icon );

		//Check the appropriate button, fill in appropriate description
		if( unNewDDrawMode & DDRAW_NONE )
		{
			cbButton = (CButton *)GetDlgItem( IDC_DDRAW_WINDOWED );
			if( cbButton )
				cbButton->SetCheck( 0 );
			cbButton = (CButton *)GetDlgItem( IDC_NODIRECTDRAW );
			if( cbButton )
				cbButton->SetCheck( 1 );
			LoadString( NULL, IDS_MODE_NODIRECTDRAW_DESC, message, LOADSTRING_STRING_SIZE );
			SetDlgItemText( IDC_DESCRIPTION, message );
		}
		else
		{
			cbButton = (CButton *)GetDlgItem( IDC_DDRAW_WINDOWED );
			if( cbButton )
				cbButton->SetCheck( 1 );
			cbButton = (CButton *)GetDlgItem( IDC_NODIRECTDRAW );
			if( cbButton )
				cbButton->SetCheck( 0 );

			LoadString( NULL, IDS_MODE_DIRECTDRAW_WINDOWED, message, LOADSTRING_STRING_SIZE );
			SetDlgItemText( IDC_DESCRIPTION, message );
		}
		return;
	}

	if( !(unNewDDrawMode & DDRAW_FULL_RES_MASK) )
		unNewDDrawMode = DDRAW_800_600;

	cbButton = (CButton *)GetDlgItem( IDC_MODE_800X600 );
	if( cbButton )
	{
		if( ulModesAvail & MODE_800_600 )
			cbButton->EnableWindow( TRUE );
		else
			cbButton->EnableWindow( FALSE );
	}

	cbButton = (CButton *)GetDlgItem( IDC_MODE_640X480_PARTCLIP );
	if( cbButton )
	{
		if( ulModesAvail & MODE_640_480 )
			cbButton->EnableWindow( TRUE );
		else
			cbButton->EnableWindow( FALSE );
	}

	cbButton = (CButton *)GetDlgItem( IDC_MODE_640x400_CLIP );
	if( cbButton )
	{
		if( ulModesAvail & MODE_640_400 )
			cbButton->EnableWindow( TRUE );
		else
			cbButton->EnableWindow( FALSE );
	}

	cbButton = (CButton *)GetDlgItem( IDC_MODE_320X240_PARTCLIP );
	if( cbButton )
	{
		if( ulModesAvail & MODE_320_240 )
			cbButton->EnableWindow( TRUE );
		else
			cbButton->EnableWindow( FALSE );
	}

	cbButton = (CButton *)GetDlgItem( IDC_MODE_320X200_CLIP );
	if( cbButton )
	{
		if( ulModesAvail & MODE_320_200 )
			cbButton->EnableWindow( TRUE );
		else
			cbButton->EnableWindow( FALSE );
	}

	//Disable thw windowed res buttons
	cbButton = (CButton *)GetDlgItem( IDC_384X240_WINDOWED );
	if( cbButton )
		cbButton->EnableWindow( FALSE );

	cbButton = (CButton *)GetDlgItem( IDC_768x480_WINDOWED );
	if( cbButton )
		cbButton->EnableWindow( FALSE );

	//Load the appropriate overscan icon indicator, description, and check the right button
	if( unNewDDrawMode & DDRAW_320_200 )
	{
		icon = AfxGetApp()->LoadIcon( IDI_NO_OVERSCAN );
		LoadString( NULL, IDS_MODE_320_200_DESC, message, LOADSTRING_STRING_SIZE );
		CheckRadioButton( IDC_MODE_320X200_CLIP, IDC_MODE_800X600, IDC_MODE_320X200_CLIP );
	}

	if( unNewDDrawMode & DDRAW_320_240 )
	{
		icon = AfxGetApp()->LoadIcon( IDI_VERT_OVERSCAN );
		LoadString( NULL, IDS_MODE_320_240_DESC, message, LOADSTRING_STRING_SIZE );
		CheckRadioButton( IDC_MODE_320X200_CLIP, IDC_MODE_800X600, IDC_MODE_320X240_PARTCLIP );
	}

	if( unNewDDrawMode & DDRAW_640_400 )
	{
		icon = AfxGetApp()->LoadIcon( IDI_NO_OVERSCAN );
		LoadString( NULL, IDS_MODE_640_400_DESC, message, LOADSTRING_STRING_SIZE );
		CheckRadioButton( IDC_MODE_320X200_CLIP, IDC_MODE_800X600, IDC_MODE_640x400_CLIP );
	}

	if( unNewDDrawMode & DDRAW_640_480 )
	{
		icon = AfxGetApp()->LoadIcon( IDI_VERT_OVERSCAN );
		LoadString( NULL, IDS_MODE_640_480_DESC, message, LOADSTRING_STRING_SIZE );
		CheckRadioButton( IDC_MODE_320X200_CLIP, IDC_MODE_800X600, IDC_MODE_640X480_PARTCLIP );
	}

	if( unNewDDrawMode & DDRAW_800_600 )
	{
		icon = AfxGetApp()->LoadIcon( IDI_FULL_OVERSCAN );
		LoadString( NULL, IDS_MODE_800_600_DESC, message, LOADSTRING_STRING_SIZE );
		CheckRadioButton( IDC_MODE_320X200_CLIP, IDC_MODE_800X600, IDC_MODE_800X600 );
	}
	
	SetDlgItemText( IDC_DESCRIPTION, message );	

	if( icon && iconDisp )
		iconDisp->SetIcon( (HICON)icon );
}

BOOL CGraphicsDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	unNewDDrawMode = ulScreenMode;

	SetGraphicsDesc	();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CGraphicsDlg::OnMode320x200Clip() 
{
	CWarnDlg	Warning;

	if( !(ulDontShowFlags & DONT_SHOW_MENU_WARN) )
	{
		char	message[LOADSTRING_STRING_SIZE];
		LoadString( NULL, IDS_WARNING_NO_MENU, message, LOADSTRING_STRING_SIZE );
		Warning.csWarnText = message;
		Warning.iWarnBit = DONT_SHOW_MENU_WARN;
		Warning.DoModal();
	}

	unNewDDrawMode &= ~DDRAW_FULL_RES_MASK;
	unNewDDrawMode |= DDRAW_320_200;
	SetGraphicsDesc	();
}


void CGraphicsDlg::OnMode320x240Partclip() 
{
	unNewDDrawMode &= ~DDRAW_FULL_RES_MASK;
	unNewDDrawMode |= DDRAW_320_240;
	SetGraphicsDesc	();
}

void CGraphicsDlg::OnMODE640x400CLIP() 
{
	CWarnDlg	Warning;

	if( !(ulDontShowFlags & DONT_SHOW_MENU_WARN) )
	{
		char	message[LOADSTRING_STRING_SIZE];
		LoadString( NULL, IDS_WARNING_NO_MENU, message, LOADSTRING_STRING_SIZE );
		Warning.csWarnText = message;
		Warning.iWarnBit = DONT_SHOW_MENU_WARN;
		Warning.DoModal();
	}

	unNewDDrawMode &= ~DDRAW_FULL_RES_MASK;
	unNewDDrawMode |= DDRAW_640_400;
	SetGraphicsDesc	();
}

void CGraphicsDlg::OnMode640x480Partclip() 
{
	unNewDDrawMode &= ~DDRAW_FULL_RES_MASK;
	unNewDDrawMode |= DDRAW_640_480;
	SetGraphicsDesc	();
}

void CGraphicsDlg::OnMode800x600() 
{
	unNewDDrawMode &= ~DDRAW_FULL_RES_MASK;
	unNewDDrawMode |= DDRAW_800_600;
	SetGraphicsDesc	();
}

void CGraphicsDlg::On384x240Windowed() 
{
	unNewDDrawMode &= ~DDRAW_WIND_RES_MASK;
	unNewDDrawMode |= WINDOWED_384_240;	
	SetGraphicsDesc ();
}

void CGraphicsDlg::On768x480WINDOWED() 
{
	int result = IDOK;

	if( !(ulDontShowFlags & DONT_SHOW_GRAPHICS_WARN ) )
	{
		CWarnDlg	Warning;
		char	message[LOADSTRING_STRING_SIZE];

		LoadString( NULL, IDS_WARNING_GRAPHICS_WINDOW, message, LOADSTRING_STRING_SIZE );
		Warning.csWarnText = message;
		Warning.iWarnBit = DONT_SHOW_GRAPHICS_WARN;
		result = Warning.DoModal();
	}

	if( result == IDOK )
	{
		unNewDDrawMode &= ~DDRAW_WIND_RES_MASK;
		unNewDDrawMode |= WINDOWED_768_480;	
	}
	SetGraphicsDesc ();
}

void CGraphicsDlg::OnNodirectdraw() 
{
	CButton *cbButton = (CButton *)GetDlgItem( IDC_NODIRECTDRAW );
	
	if( cbButton && cbButton->GetCheck() )
	{
		unNewDDrawMode &= ~DDRAW_MODE_MASK;
		unNewDDrawMode &= ~DDRAW_WIND;
		unNewDDrawMode &= ~DDRAW_FULL;
		unNewDDrawMode |= DDRAW_NONE;
	}
	else
	{
		unNewDDrawMode &= ~DDRAW_WIND;
		unNewDDrawMode &= ~DDRAW_MODE_MASK;
		unNewDDrawMode |= DDRAW_FULL;
	}
	SetGraphicsDesc ();
}

void CGraphicsDlg::OnDdrawWindowed() 
{
	CButton	*cbButton;

	unNewDDrawMode &= ~DDRAW_NONE;

	cbButton = (CButton *)GetDlgItem( IDC_DDRAW_WINDOWED );
	if( cbButton && cbButton->GetCheck() )
	{
		unNewDDrawMode &= ~DDRAW_MODE_MASK;
		unNewDDrawMode &= ~DDRAW_NONE;
		unNewDDrawMode &= ~DDRAW_FULL;
		unNewDDrawMode |= DDRAW_WIND;
	}
	else
	{
		unNewDDrawMode &= ~DDRAW_NONE;
		unNewDDrawMode &= ~DDRAW_MODE_MASK;
		unNewDDrawMode |= DDRAW_FULL;
	}
	SetGraphicsDesc ();
}

void CGraphicsDlg::OnOK() 
{
	if( unNewDDrawMode != ulScreenMode )
	{
		ULONG	savedmode = ulScreenMode;

		ulScreenMode = unNewDDrawMode;
		if( !Init_Graphics() )
		{
			ulScreenMode = savedmode;
			Init_Graphics();
		}
		WriteRegDWORD( NULL, REG_DDRAW_MODE, ulScreenMode );
	}
	
	CDialog::OnOK();
}

