/*
Copyright (c) 1998 Richard Lawrence

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// CGraphicsSmallDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Atari800Win.h"
#include "CGraphicsSmallDlg.h"
#include "winatari.h"
#include "registry.h"
#include "CWarnDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern "C" void WriteRegDWORD( HKEY hkInput, char *item, DWORD value);
static ULONG unNewDDrawMode;
extern "C" ULONG	ulScreenMode;
extern "C" int Init_Graphics( void );
extern "C" ULONG *atari_screen;
extern "C" ULONG	ulDontShowFlags;
extern "C" ULONG	ulModesAvail;

/////////////////////////////////////////////////////////////////////////////
// CGraphicsSmallDlg dialog


CGraphicsSmallDlg::CGraphicsSmallDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGraphicsSmallDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGraphicsSmallDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CGraphicsSmallDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGraphicsSmallDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGraphicsSmallDlg, CDialog)
	//{{AFX_MSG_MAP(CGraphicsSmallDlg)
	ON_BN_CLICKED(IDC_DDRAW_WIND_SMALL, OnDdrawWindSmall)
	ON_BN_CLICKED(IDC_NODDRAW_SMALL, OnNoddrawSmall)
	ON_CBN_SELCHANGE(IDC_GRAPHICS_COMBO_SMALL, OnSelchangeGraphicsComboSmall)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGraphicsSmallDlg message handlers

void CGraphicsSmallDlg::SetDlgState( void )
{
	int iSelect = 0;
	HANDLE	icon = NULL;
	CStatic* iconDisp = (CStatic *)GetDlgItem( IDC_ICON_GRAPHICS_SMALL );

	ComboBox->ResetContent( );
	if( !(unNewDDrawMode & DDRAW_FULL) )
	{
		ComboBox->AddString( "336x240 Windowed" );
		ComboBox->AddString( "672x480 Windowed" );
		if( unNewDDrawMode & WINDOWED_384_240 )
		{
			icon = AfxGetApp()->LoadIcon( IDI_FULL_OVERSCAN );
			iSelect = 0;
		}
		if( unNewDDrawMode & WINDOWED_768_480 )
		{
			icon = AfxGetApp()->LoadIcon( IDI_FULL_OVERSCAN );
			iSelect = 1;
		}
	}
	else
	{
		ComboBox->AddString( "320x200x256" );
		ComboBox->AddString( "320x240x256" );
		ComboBox->AddString( "640x400x256" );
		ComboBox->AddString( "640x480x256" );
		ComboBox->AddString( "800x600x256" );
		if( unNewDDrawMode & DDRAW_320_200 )
		{
			icon = AfxGetApp()->LoadIcon( IDI_NO_OVERSCAN );
			iSelect = 0;
		}
		if( unNewDDrawMode & DDRAW_320_240 )
		{
			icon = AfxGetApp()->LoadIcon( IDI_VERT_OVERSCAN );
			iSelect = 1;
		}
		if( unNewDDrawMode & DDRAW_640_400 )
		{
			icon = AfxGetApp()->LoadIcon( IDI_NO_OVERSCAN );
			iSelect = 2;
		}
		if( unNewDDrawMode & DDRAW_640_480 )
		{
			icon = AfxGetApp()->LoadIcon( IDI_VERT_OVERSCAN );
			//iSelect = 5;
			iSelect = 3;
		}
		if( unNewDDrawMode & DDRAW_800_600 )
		{
			icon = AfxGetApp()->LoadIcon( IDI_FULL_OVERSCAN );
			//iSelect = 8;
			iSelect = 4;
		}
	}

	cbCheckBox = (CButton *)GetDlgItem( IDC_DDRAW_WIND_SMALL );
	if( !cbCheckBox )
		return;
	if( !(unNewDDrawMode & DDRAW_FULL) && unNewDDrawMode & DDRAW_WIND )
		cbCheckBox->SetCheck( 1 );
	else
		cbCheckBox->SetCheck( 0 );

	cbCheckBox = (CButton *)GetDlgItem( IDC_NODDRAW_SMALL );
	if( !cbCheckBox )
		return;
	if( !(unNewDDrawMode & DDRAW_FULL) && unNewDDrawMode & DDRAW_NONE )
		cbCheckBox->SetCheck( 1 );
	else
		cbCheckBox->SetCheck( 0 );


	ComboBox->SetCurSel( iSelect );
	if( icon && iconDisp )
		iconDisp->SetIcon( (HICON)icon );
}

BOOL CGraphicsSmallDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	unNewDDrawMode = ulScreenMode;

	ComboBox = (CComboBox *)GetDlgItem( IDC_GRAPHICS_COMBO_SMALL );
	
	if( !ComboBox )
		return FALSE;

	SetDlgState();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CGraphicsSmallDlg::OnSelchangeGraphicsComboSmall() 
{
	if( !(unNewDDrawMode & DDRAW_FULL) )
	{
		if( ComboBox->GetCurSel() )
		{
			if( !(ulDontShowFlags & DONT_SHOW_GRAPHICS_WARN) )
			{
				CWarnDlg	Warning;
				char		message[LOADSTRING_STRING_SIZE];
				LoadString( NULL, IDS_WARNING_GRAPHICS_WINDOW, message, LOADSTRING_STRING_SIZE );
				Warning.csWarnText = message;
				Warning.iWarnBit = DONT_SHOW_GRAPHICS_WARN;
				Warning.DoModal();
			}
			else
			{
				unNewDDrawMode &= ~WINDOWED_384_240;
				unNewDDrawMode |= WINDOWED_768_480;
			}
		}
		else
		{
			unNewDDrawMode &= ~WINDOWED_768_480;
			unNewDDrawMode |= WINDOWED_384_240;
		}
		SetDlgState();
		return;
	}

	unNewDDrawMode &= ~DDRAW_FULL_RES_MASK;
	unNewDDrawMode &= ~DDRAW_BPP_MASK;
	
	switch( ComboBox->GetCurSel() )
	{
		case	0:
			{
				int result = IDOK;
				if( !(ulDontShowFlags & DONT_SHOW_MENU_WARN) )
				{
					CWarnDlg Warning;
					char	message[LOADSTRING_STRING_SIZE];
					LoadString( NULL, IDS_WARNING_NO_MENU, message, LOADSTRING_STRING_SIZE );
					Warning.csWarnText = message;
					Warning.iWarnBit = DONT_SHOW_MENU_WARN;
					result = Warning.DoModal();
				}
				if( result == IDOK )
					unNewDDrawMode |= DDRAW_320_200 | DDRAW_8BPP | DDRAW_FULL;
				break;
			}
		case	1:
			unNewDDrawMode |= DDRAW_320_240 | DDRAW_8BPP | DDRAW_FULL;
			break;

		case	2:
			{
				int result = IDOK;
				if( !(ulDontShowFlags & DONT_SHOW_MENU_WARN) )
				{
					CWarnDlg Warning;
					char	message[LOADSTRING_STRING_SIZE];
					LoadString( NULL, IDS_WARNING_NO_MENU, message, LOADSTRING_STRING_SIZE );
					Warning.csWarnText = message;
					Warning.iWarnBit = DONT_SHOW_MENU_WARN;
					Warning.DoModal();
				}
				if( result == IDOK )
					unNewDDrawMode |= DDRAW_640_400 | DDRAW_8BPP | DDRAW_FULL;
				break;
			}
		case	3:
			unNewDDrawMode |= DDRAW_640_480 | DDRAW_8BPP | DDRAW_FULL;
			break;

		case	4:
			unNewDDrawMode |= DDRAW_800_600 | DDRAW_8BPP | DDRAW_FULL;
			break;

		default:
			unNewDDrawMode |= DDRAW_800_600 | DDRAW_8BPP | DDRAW_FULL;
			break;
	}
	SetDlgState();
}

void CGraphicsSmallDlg::OnDdrawWindSmall() 
{
	cbCheckBox = (CButton *)GetDlgItem( IDC_DDRAW_WIND_SMALL );

	if( cbCheckBox )
	{
		if( cbCheckBox->GetCheck() )
		{
			unNewDDrawMode &= ~DDRAW_MODE_MASK;
			unNewDDrawMode &= ~DDRAW_NONE;
			unNewDDrawMode &= ~DDRAW_FULL;
			unNewDDrawMode |= DDRAW_WIND;
		}
		else
		{
			unNewDDrawMode &= ~DDRAW_MODE_MASK;
			unNewDDrawMode &= ~DDRAW_NONE;
			unNewDDrawMode |= DDRAW_FULL;
		}
	}
	SetDlgState();
}

void CGraphicsSmallDlg::OnNoddrawSmall() 
{
	cbCheckBox = (CButton *)GetDlgItem( IDC_NODDRAW_SMALL );
	if( cbCheckBox )
	{
		if( cbCheckBox->GetCheck() )
		{
			unNewDDrawMode &= ~DDRAW_MODE_MASK;
			unNewDDrawMode &= ~DDRAW_WIND;
			unNewDDrawMode &= ~DDRAW_FULL;
			unNewDDrawMode |= DDRAW_NONE;
		}
		else
		{
			unNewDDrawMode &= ~DDRAW_MODE_MASK;
			unNewDDrawMode &= ~DDRAW_WIND;
			unNewDDrawMode |= DDRAW_FULL;
		}
	}
	SetDlgState();
}

void CGraphicsSmallDlg::OnOK() 
{
	if( unNewDDrawMode != ulScreenMode )
	{
		ULONG	savedmode = ulScreenMode;
		atari_screen = NULL;

		ulScreenMode = unNewDDrawMode;
		if( !Init_Graphics() )
		{
			if( !(ulScreenMode & DDRAW_NONE) )
				atari_screen = NULL;
			ulScreenMode = savedmode;
			Init_Graphics();
		}
		WriteRegDWORD( NULL, REG_DDRAW_MODE, ulScreenMode );
	}
	
	CDialog::OnOK();
}
