/*
Copyright (c) 1998 Richard Lawrence

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// CHardwareDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Atari800Win.h"
#include "CHardwareDlg.h"
#include "CWarnDlg.h"
#include "winatari.h"
#include "registry.h"
#include "crc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define MACHINE_TYPES	6

extern "C" void Coldstart( void );
extern "C" int	default_system;
extern "C" HWND				hWnd;
extern "C" char atari_osa_filename[];
extern "C" char atari_osb_filename[];
extern "C" char atari_xlxe_filename[];
extern "C" char atari_5200_filename[];
extern "C" int	refresh_rate;
extern "C" int	default_tv_mode;
extern "C" ULONG	ulAtariState;
extern "C" int	enable_c000_ram;
extern "C" int	enable_sio_patch;
extern "C" int main (int argc, char **argv);
extern "C" int test_val;
extern "C" int global_artif_mode;
extern "C" ULONG ulMiscStates;
extern "C" void WriteRegDWORD( HKEY hkInput, char *item, DWORD value);
extern "C" void WriteRegString( HKEY hkInput, char *item, char *data );
extern "C" void art_main_init(int init_flag, int mode);
extern "C" void RestoreSIO( void );
extern "C" void SetSIOEsc( void );

extern unsigned long CheckFile( char *fn, int *result );
extern "C" ULONG	ulDontShowFlags;

static char BASED_CODE szFilter[] = "ROM Images (*.rom)|*.rom|All Files (*.*)|*.*||";
static unsigned long ulFileCRC[MACHINE_TYPES] = { 0L, 3252116993L, 3764596111L, 3764596111L, 3764596111L, 3182898204L };
static unsigned int unWarnBits[MACHINE_TYPES] = { DONT_SHOW_OSA_WARN, DONT_SHOW_OSB_WARN, DONT_SHOW_XL_WARN, DONT_SHOW_XL_WARN, DONT_SHOW_XL_WARN, DONT_SHOW_5200_WARN };
static char *pszRomNames[MACHINE_TYPES] = { atari_osa_filename, atari_osb_filename, atari_xlxe_filename, atari_xlxe_filename, atari_xlxe_filename, atari_5200_filename };
static char szNewRomNames[MACHINE_TYPES][MAX_PATH];
static int	nNewSystem, nNewArtif;
/////////////////////////////////////////////////////////////////////////////
// CHardwareDlg dialog


CHardwareDlg::CHardwareDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CHardwareDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CHardwareDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CHardwareDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHardwareDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CHardwareDlg, CDialog)
	//{{AFX_MSG_MAP(CHardwareDlg)
	ON_NOTIFY(UDN_DELTAPOS, IDC_REFRESH_SPIN, OnDeltaposRefreshSpin)
	ON_BN_CLICKED(IDC_NTSC, OnNtsc)
	ON_BN_CLICKED(IDC_PAL, OnPal)
	ON_EN_KILLFOCUS(IDC_REFRESH_RATE, OnKillfocusRefreshRate)
	ON_BN_CLICKED(IDC_ROMFILE, OnRomfile)
	ON_EN_KILLFOCUS(IDC_ROM_EDIT, OnKillfocusRomEdit)
	ON_CBN_SELCHANGE(IDC_MACHINE_SELECTOR, OnSelchangeMachineSelector)
	ON_CBN_SELCHANGE(IDC_ARTIFACT_MODE, OnSelchangeArtifactMode)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHardwareDlg message handlers

void CHardwareDlg::SetDisplay()
{
	char	cDigits[64];
	CComboBox	*pCombo = NULL;

	pCombo = (CComboBox *)GetDlgItem( IDC_ARTIFACT_MODE );
	if( pCombo )
		pCombo->SetCurSel( nNewArtif );

	if( nNewSystem >= 0 && nNewSystem <= MACHINE_TYPES  )
	{
		pCombo = (CComboBox *)GetDlgItem( IDC_MACHINE_SELECTOR );
		pCombo->SetCurSel( nNewSystem - 1 );
		SetDlgItemText( IDC_ROM_EDIT, szNewRomNames[ nNewSystem - 1 ] );
	}
	else
		SetDlgItemText( IDC_ROM_EDIT, "Bad machine type, please reselect" );

	if( default_tv_mode == 1 )
		CheckRadioButton( IDC_NTSC, IDC_PAL, IDC_PAL );
	else
		CheckRadioButton( IDC_NTSC, IDC_PAL, IDC_NTSC );

	ntemp_tv_mode = default_tv_mode;
	ntemp_refresh_rate = refresh_rate;

	itoa( ntemp_refresh_rate, cDigits, 10 );
	SetDlgItemText( IDC_REFRESH_RATE, cDigits );

	if( ulMiscStates & ATARI_FULL_SPEED )
	{
		CButton	*cbSpeed = (CButton *)GetDlgItem( IDC_FULL_SPEED );
		if( cbSpeed )
			cbSpeed->SetCheck( 1 );
	}

	if( enable_sio_patch )
	{
		CButton	*cbSIO = (CButton *)GetDlgItem( IDC_ENABLE_SIO );
		if( cbSIO )
			cbSIO->SetCheck( 1 );
	}

	if( enable_c000_ram )
	{
		CButton *cbC000 = (CButton *)GetDlgItem( IDC_C000_RAM );
		if( cbC000 )
			cbC000->SetCheck( 1 );
	}
}

BOOL CHardwareDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	int		i;
	CComboBox	*pCombo = NULL;

	if( default_system < 1 || default_system > MACHINE_TYPES )
		default_system = 2;

	nNewSystem = default_system;

	nNewArtif = global_artif_mode;

	if( default_tv_mode < 1 || default_tv_mode > 2 )
		default_tv_mode = 1;

	for( i = 0; i < MACHINE_TYPES; i++ )
		strcpy( szNewRomNames[i], pszRomNames[i] );

	SetDisplay();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

int CHardwareDlg::SetRomImage( int idnum, unsigned long expectedCrc, unsigned long dontshowbit, char *warningtext )
{
	CString	name;
	CFileDialog	cfRomImage( TRUE, NULL, NULL, OFN_EXPLORER | OFN_FILEMUSTEXIST, szFilter, this );
	char	szDlgBuf[ MAX_PATH ];
	int	nBtn;

	nBtn = cfRomImage.DoModal();
	if( nBtn == IDOK )
	{
		name = cfRomImage.GetPathName();
		GetDlgItemText( idnum, szDlgBuf, MAX_PATH );
		SetDlgItemText( idnum, name.GetBuffer(0) );
		nBtn = OnKillfocusRomEdit();
		if( nBtn != IDOK )
			SetDlgItemText( idnum, szDlgBuf );
	}
	return nBtn;
}

void CHardwareDlg::OnSelchangeArtifactMode() 
{
	CComboBox	*pCombo = NULL;
		
	pCombo = (CComboBox *)GetDlgItem( IDC_ARTIFACT_MODE );
	ASSERT( pCombo );
	if( !pCombo )
		return;
	
	nNewArtif = pCombo->GetCurSel();
}

void CHardwareDlg::OnSelchangeMachineSelector() 
{
	CComboBox	*pCombo = NULL;
		
	pCombo = (CComboBox *)GetDlgItem( IDC_MACHINE_SELECTOR );
	ASSERT( pCombo );
	if( !pCombo )
		return;
	nNewSystem = pCombo->GetCurSel( ) + 1;
	SetDisplay();
}

int CHardwareDlg::OnKillfocusRomEdit() 
{
	char	szDlgBuf[ MAX_PATH ];
	int		nresult, nBtn = IDOK;
	unsigned long	ulCRC;

	GetDlgItemText( IDC_ROM_EDIT, szDlgBuf, MAX_PATH );
	ulCRC = CheckFile( szDlgBuf, &nresult);

	if( ulCRC && !nresult && (ulCRC != ulFileCRC[ nNewSystem - 1] ) && !(ulDontShowFlags & unWarnBits[nNewSystem - 1] ) )
	{
		CWarnDlg	Warning;
		char	message[LOADSTRING_STRING_SIZE];		
		LoadString( NULL, IDS_WARNING_ROM_CORRUPT, message, LOADSTRING_STRING_SIZE );
		Warning.csWarnText = message;
		Warning.iWarnBit = unWarnBits[nNewSystem - 1];
		nBtn = Warning.DoModal();
	}

	if( nBtn == IDOK )
	{
		strcpy( szNewRomNames[ nNewSystem - 1], szDlgBuf );
		if( nNewSystem > 2 && nNewSystem < 6 )
		{
			strcpy( szNewRomNames[2], szDlgBuf );
			strcpy( szNewRomNames[3], szDlgBuf );
			strcpy( szNewRomNames[4], szDlgBuf );
		}
	}

	SetDisplay();
	return nBtn;
}

void CHardwareDlg::OnRomfile() 
{
	char	message[LOADSTRING_STRING_SIZE];		

	ASSERT( nNewSystem >= 0 && nNewSystem <= MACHINE_TYPES  );

	LoadString( NULL, IDS_WARNING_ROM_CORRUPT, message, LOADSTRING_STRING_SIZE );
	SetRomImage( IDC_ROM_EDIT, ulFileCRC[ nNewSystem - 1 ], unWarnBits[ nNewSystem -1 ], message );
}

void CHardwareDlg::OnDeltaposRefreshSpin(NMHDR* pNMHDR, LRESULT* pResult) 
{
	char	cDigits[64];
	NM_UPDOWN* pNMUpDown = (NM_UPDOWN*)pNMHDR;

	ntemp_refresh_rate -= pNMUpDown->iDelta;
	if( ntemp_refresh_rate < 1 )
		ntemp_refresh_rate = 1;
	if( ntemp_refresh_rate > 99 )
		ntemp_refresh_rate = 99;

	itoa( ntemp_refresh_rate, cDigits, 10 );
	SetDlgItemText( IDC_REFRESH_RATE, cDigits );

	test_val = 0;
	*pResult = 0;
}

void CHardwareDlg::OnKillfocusRefreshRate() 
{
	char	cDigits[64];
	int		iTemp;

	GetDlgItemText( IDC_REFRESH_RATE, cDigits, 64 );
	iTemp = atoi( cDigits );

	if( iTemp < 1 || iTemp > 99 )
	{
		itoa( ntemp_refresh_rate, cDigits, 10 );
		SetDlgItemText( IDC_REFRESH_RATE, cDigits );
	}
	else
		ntemp_refresh_rate = iTemp;
}

void CHardwareDlg::OnNtsc() 
{
	ntemp_tv_mode = 2;
}

void CHardwareDlg::OnPal() 
{
	ntemp_tv_mode = 1;
}

void CHardwareDlg::OnOK() 
{
	int		i;
	BOOL	bReboot = FALSE, bSaveOS = FALSE;
	CButton	*cbButton = (CButton *)GetDlgItem( IDC_FULL_SPEED );

	if( nNewArtif != global_artif_mode )
	{
		global_artif_mode = nNewArtif;
		art_main_init( 0, global_artif_mode );
		WriteRegDWORD( NULL, REG_ARTIF_MODE, global_artif_mode );
	}

	if( ulAtariState & ATARI_LOAD_FAILED )
		bReboot = TRUE;

	if( cbButton )
	{
		ULONG	temp = ulMiscStates;

		if( cbButton->GetCheck() )
			ulMiscStates |= ATARI_FULL_SPEED;
		else
			ulMiscStates &= ~ATARI_FULL_SPEED;
		if( temp != ulMiscStates )
			WriteRegDWORD( NULL, REG_MISC_STATES, ulMiscStates);
	}

	cbButton = (CButton *)GetDlgItem( IDC_C000_RAM );
	if( cbButton )
	{
		if( cbButton->GetCheck()!=enable_c000_ram )
		{
			enable_c000_ram = cbButton->GetCheck();
			bReboot = TRUE;
			WriteRegDWORD( NULL, REG_ENABLE_C000_RAM, enable_c000_ram );
		}
	}

	cbButton = (CButton *)GetDlgItem( IDC_ENABLE_SIO );
	if( cbButton )
	{
		if( cbButton->GetCheck()!=enable_sio_patch )
		{
			enable_sio_patch = cbButton->GetCheck();
			if( enable_sio_patch )
				SetSIOEsc();
			else
				RestoreSIO();
			WriteRegDWORD( NULL, REG_ENABLE_SIO_PATCH, enable_sio_patch );
		}
	}

	for( i = 0 ; i < MACHINE_TYPES; i ++ )
	{
		if( strcmp( pszRomNames[i], szNewRomNames[i] ) )
			bSaveOS = TRUE;
		strcpy( pszRomNames[i], szNewRomNames[i] );
	}

	if( bSaveOS )
	{
		WriteRegString( NULL, REG_OSA_ROM, atari_osa_filename );
		WriteRegString( NULL, REG_OSB_ROM, atari_osb_filename );
		WriteRegString( NULL, REG_XLXE_ROM, atari_xlxe_filename );
		WriteRegString( NULL, REG_5200_ROM, atari_5200_filename );
	}

	if( nNewSystem != default_system )
	{
		default_system = nNewSystem;
		bReboot = TRUE;
		WriteRegDWORD( NULL, REG_DEFAULT_SYSTEM, default_system );
	}

	if( ntemp_refresh_rate != refresh_rate )
	{
		refresh_rate = ntemp_refresh_rate;
		WriteRegDWORD( NULL, REG_REFRESH_RATE, ntemp_refresh_rate);
	}

	if( ntemp_tv_mode != default_tv_mode )
	{
		default_tv_mode = ntemp_tv_mode;
		//iKbBuffer[ nKbBufferChars++ ] = -3; /* AKEY_COLDSTART */
		bReboot = TRUE;
		WriteRegDWORD( NULL, REG_DEFAULT_TV_MODE, ntemp_tv_mode);
	}

	//If the atari load failed, we just reset hWnd to NULL and the Atari will
	//be rebooted when the screen is refreshed in OnDraw
	if( bReboot )
	{
		ulAtariState = ATARI_UNINITIALIZED | ATARI_PAUSED;
		main( 1, NULL );
		hWnd = NULL;
	}
	CDialog::OnOK();
}

