/*
Copyright (c) 1998 Richard Lawrence

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// CJoyStickDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Atari800Win.h"
#include "CJoyStickDlg.h"
#include "winatari.h"
#include "registry.h"
#include "resource.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern "C" char	cInputDevNames[MAX_INPUT_DEVICES][INPUT_DEV_NAMELEN];
extern "C" int	gNumDIDevs, gSelectedInputDevice[];
extern "C" void	PickJoystick( int sticknum, int joystick );
extern "C" int	nJoyRepeat, nJoySkip;
extern "C" ULONG	ulMiscStates;
extern "C" void WriteRegDWORD( HKEY hkInput, char *item, DWORD value);
extern "C" TCHAR	gcErrorString[];

/////////////////////////////////////////////////////////////////////////////
// CJoyStickDlg dialog


CJoyStickDlg::CJoyStickDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CJoyStickDlg::IDD, pParent)
{
	int i;
	//{{AFX_DATA_INIT(CJoyStickDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	for( i = 0; i < MAX_ATARI_JOYPORTS; i++ )
		nNewSelectedDev[i] = gSelectedInputDevice[i];
}


void CJoyStickDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CJoyStickDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CJoyStickDlg, CDialog)
	//{{AFX_MSG_MAP(CJoyStickDlg)
	ON_CBN_SELCHANGE(IDC_PORT_NAMES, OnSelchangePortNames)
	ON_CBN_SELCHANGE(IDC_JOYSTICK_NAMES, OnSelchangeJoystickNames)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CJoyStickDlg message handlers

BOOL CJoyStickDlg::OnInitDialog() 
{
	CComboBox	*comboBox = NULL;
	CSliderCtrl	*cSlider = NULL;
	CButton	*pTemp;
	int		nCheck, i;

	CDialog::OnInitDialog();

	if( ulMiscStates & ATARI_STICK_RELEASE )
		nCheck = 1;
	else
		nCheck = 0;
	pTemp = (CButton *)GetDlgItem( IDC_JOYSTICK_RECENTER );
	if( pTemp )
		pTemp->SetCheck( nCheck );

	comboBox = (CComboBox *)GetDlgItem( IDC_JOYSTICK_NAMES );
	if( !comboBox )
		return FALSE;

	comboBox->AddString( "Keypad" );
	for( i = 0; i < gNumDIDevs; i++ )
	{
		comboBox->AddString( cInputDevNames[i] );
	}
	comboBox->AddString( "None" );

	if( nNewSelectedDev[0] == KEYPAD_JOYSTICK )
		comboBox->SetCurSel( 0 );
	else if( nNewSelectedDev[0] == NO_JOYSTICK )
		comboBox->SetCurSel( gNumDIDevs + 1 );
	else
		comboBox->SetCurSel( nNewSelectedDev[0] + 1 );

	comboBox = (CComboBox *)GetDlgItem( IDC_PORT_NAMES );
	if( !comboBox )
		return FALSE;
	comboBox->SetCurSel( 0 );

	cSlider = (CSliderCtrl *)GetDlgItem( IDC_REPEAT_FRAMES );
	if( !cSlider )
		return FALSE;
	cSlider->SetRange( 0, 10, TRUE );
	cSlider->SetPos( nJoyRepeat );
	cSlider = (CSliderCtrl *)GetDlgItem( IDC_SKIP_FRAMES );
	if( !cSlider )
		return FALSE;
	cSlider->SetRange( 0, 10, TRUE );
	cSlider->SetPos( nJoySkip );
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CJoyStickDlg::OnSelchangePortNames() 
{
	CComboBox	*comboBox = NULL, *pPortSel = NULL;
	int	nPort;

	comboBox = (CComboBox *)GetDlgItem( IDC_JOYSTICK_NAMES );
	pPortSel = (CComboBox *)GetDlgItem( IDC_PORT_NAMES );
	if( !comboBox || !pPortSel )
		return;

	if( (nPort = pPortSel->GetCurSel()) == CB_ERR )
	{
		pPortSel->SetCurSel( 0 );
		nPort = 0;
	}

	if( nNewSelectedDev[nPort] == KEYPAD_JOYSTICK )
		comboBox->SetCurSel( 0 );
	else if( nNewSelectedDev[nPort] == NO_JOYSTICK )
		comboBox->SetCurSel( gNumDIDevs + 1 );
	else
		comboBox->SetCurSel( nNewSelectedDev[nPort] + 1 );
}

void CJoyStickDlg::OnSelchangeJoystickNames() 
{
	CComboBox	*pStickSel = NULL, *pPortSel = NULL;
	int	nPort, nSelect, nPrevSelect, i, nConflict = -1;

	pStickSel = (CComboBox *)GetDlgItem( IDC_JOYSTICK_NAMES );
	pPortSel = (CComboBox *)GetDlgItem( IDC_PORT_NAMES );
	if( !pStickSel || !pPortSel )
		return;

	if( (nPort = pPortSel->GetCurSel()) == CB_ERR )
		return;

	if( (nSelect = pStickSel->GetCurSel()) == CB_ERR )
		return;

	if( nSelect > gNumDIDevs )
		nSelect = NO_JOYSTICK;
	else
		nSelect--;

	nPrevSelect = nNewSelectedDev[ nPort ];

	if( nSelect != NO_JOYSTICK )
	{
		for( i = 0; i < MAX_ATARI_JOYPORTS; i++ )
		{
			if( (nSelect == nNewSelectedDev[ i ] ) && i != nPort )
				nConflict = i + 1;
		}
	}

	if( nConflict > -1 )
	{
		TCHAR	szError[LOADSTRING_STRING_SIZE];

		LoadString( NULL, IDS_STICK_CONFLICT, gcErrorString, LOADSTRING_STRING_SIZE );
		sprintf( szError, gcErrorString, nConflict );
		MessageBox( szError, "Atari800Win", MB_ICONSTOP );
		nSelect = nPrevSelect;
	}

	nNewSelectedDev[ nPort ] = nSelect;
	if( nSelect == NO_JOYSTICK )
		pStickSel->SetCurSel( gNumDIDevs + 1 );
	else
		pStickSel->SetCurSel( nSelect + 1 );
}

void CJoyStickDlg::OnOK() 
{
	CComboBox	*pStickSel = NULL;
	CSliderCtrl	*cSlider = NULL;
	CButton	*pTemp;
	int	nCheck, i;
	BOOL	bChanged = FALSE;

	for( i = 0; i < MAX_ATARI_JOYPORTS; i++ )
	{
		if( nNewSelectedDev[ i ] != gSelectedInputDevice[i] )
			PickJoystick( i, nNewSelectedDev[i] );
	}

	cSlider = (CSliderCtrl *)GetDlgItem( IDC_REPEAT_FRAMES );
	if( cSlider )
		nJoyRepeat = cSlider->GetPos( );

	cSlider = (CSliderCtrl *)GetDlgItem( IDC_SKIP_FRAMES );
	if( cSlider )
		nJoySkip = cSlider->GetPos( );

	if( ulMiscStates & ATARI_STICK_RELEASE )
		nCheck = 1;
	else
		nCheck = 0;

	pTemp = (CButton *)GetDlgItem( IDC_JOYSTICK_RECENTER );
	if( pTemp )
	{
		if( pTemp->GetCheck() != nCheck )
		{
			bChanged = TRUE;
			if( pTemp->GetCheck() )
				ulMiscStates = ulMiscStates | ATARI_STICK_RELEASE;
			else
				ulMiscStates = ulMiscStates & ~ATARI_STICK_RELEASE;
		}
	}

	if( bChanged )
	{
		WriteRegDWORD( NULL, REG_MISC_STATES, ulMiscStates);
	}

	CDialog::OnOK();
}


