/*
Copyright (c) 1998 Richard Lawrence

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "Atari800Win.h"

#include "MainFrm.h"
#include "CDriveDialog.h"
#include "CHardwareDlg.h"
#include "CCartridgeDlg.h"
#include "CGraphicsDlg.h"
#include "CDriveSmallDlg.h"
#include "CGraphicsSmallDlg.h"
#include "CSoundDlg.h"
#include "CGraphicsInfoDlg.h"
#include "CFileSmallDlg.h"
#include "CHardDiskDlg.h"
#include "CJoyStickDlg.h"
#include "CErrorLogDlg.h"
#include "CWarnDlg.h"
#include "resource.h"
#include "graphics.h"

#include "atari.h"
#include "winatari.h"
#include "registry.h"
#include "mmsystem.h"
#include "ddraw.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern "C" {
extern int	nStatusSize;
extern int				iKbBuffer[];
extern int				nKbBufferChars;
extern int	nStartX, nStartY;
extern ULONG *atari_screen;
extern void Screen_Paused( UBYTE *screen );
extern void (*Atari_DisplayScreen)(UBYTE *screen);
extern void Screen_Paused( UBYTE *screen );
extern void	HandleRegistry( void );
extern void WriteInitialReg( HKEY hkInitKey );
extern void WriteRegDWORD( HKEY hkInput, char *item, DWORD value);
extern void WriteRegString( HKEY hkInput, char *item, char *data );
extern int ReadJoystickInput( int sticknum, BOOL bButton );
extern void Restart_Sound( void );
extern void Toggle_FullSpeed( void );
extern void Toggle_Pause( void );
extern void Toggle_SIO_Patch( void );
extern void ComputeClipArea( void );
extern ULONG	ulDontShowFlags;
extern int	default_tv_mode;
extern int SIO_Mount (int diskno, char *filename);
extern void SIO_Dismount (int diskno);
extern char sio_filename[8][MAX_PATH];
extern FILE *sndoutput;
extern int	ulMiscStates;
extern int ulSoundState, nSoundRate;
extern void Pokey_process (unsigned char *buffer, int n);
extern TCHAR	gcErrorString[];
extern HWND				hWnd, MainhWnd;
extern int keystick;
extern void DeleteAllRegKeys( HKEY hkInput, char *name );
extern int main (int argc, char **argv);
extern  ULONG	ulAtariState;
extern void WinAtari800_Hardware( void );
extern int	nSoundRate;
extern int Init_Graphics( void );
extern ULONG ulScreenMode;
}
extern void BuildCRCTable(void);
//Mainframe needs this to pause/restart the Atari thread with F9

#ifdef ATARI_UI
extern BOOL	startThread( void );
#endif

CWnd	*statusWnd;

int		argc;
char	*argv[40];
char	szCmdLine[ 8192 ];

#include "win_keycodes.h"
/////////////////////////////////////////////////////////////////////////////
// CMainFrame


IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_COMMAND(ID_ATARI_DISK, OnSystemDisk)
	ON_COMMAND(ID_ATARI_HARDWARE, OnAtariHardware)
	ON_COMMAND(ID_ATARI_CARTRIDGE, OnAtariCartridge)
	ON_WM_CLOSE()
	ON_COMMAND(ID_INFO_BENCHMARK, OnInfoBenchmark)
	ON_COMMAND(ID_OPTIONS_GRAPHICS, OnOptionsGraphics)
	ON_COMMAND(ID_OPTIONS_SOUND, OnOptionsSound)
	ON_COMMAND(ID_INFO_SOUND_POKEY_SPEED, OnInfoSoundPokeySpeed)
	ON_COMMAND(ID_ATARI_HARDDISK, OnAtariHarddisk)
	ON_COMMAND(ID_OPTIONS_JOYSTICK, OnOptionsJoystick)
	ON_COMMAND(ID_OPTIONS_LOG, OnOptionsLog)
	ON_COMMAND(ID_OPTIONS_SOUNDFILE, OnOptionsSoundfile)
	ON_WM_MOVE()
	ON_COMMAND(ID_MISC_CLEARALL, OnMiscClearall)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
	// Global help commands
	ON_COMMAND(ID_HELP_FINDER, CFrameWnd::OnHelpFinder)
	ON_COMMAND(ID_HELP, CFrameWnd::OnHelp)
	ON_COMMAND(ID_CONTEXT_HELP, CFrameWnd::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CFrameWnd::OnHelpFinder)
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR//,           // status line indicator
//	ID_INDICATOR_SPEED,
//	ID_INDICATOR_CAPS,
//	ID_INDICATOR_NUM,
//	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
	iToolBar = 30;

	HandleRegistry();
	if( ulMiscStates & ATARI_LAST_BOOT_FAILED )
	{
		int result;

		LoadString( NULL, IDS_LOCKUP_WARNING, gcErrorString, LOADSTRING_STRING_SIZE );
		result = MessageBox( gcErrorString, "Atari800Win", MB_YESNO );
		if( result == IDYES )
		{
			ulScreenMode = DISPLAY_MODE_DEFAULT | DDRAW_NONE;
			ulSoundState = SOUND_NOSOUND;
			WriteInitialReg( NULL );
		}
		ulMiscStates &= ~ATARI_LAST_BOOT_FAILED;
	}
	main( argc, &argv[0] );
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
#ifdef USE_PERF_COUNTER
	LARGE_INTEGER	lnTimerRes;

	QueryPerformanceFrequency( &lnTimerRes ); 
	ASSERT( lnTimerRes.HighPart == 0 );
	if( lnTimerRes.LowPart == 0 )
	{
		LoadString( NULL, IDS_NO_HIRES_TIMER, gcErrorString, LOADSTRING_STRING_SIZE );
		MessageBox( NULL, gcErrorString, MB_OK );
		return FALSE;
	}
#endif

	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	statusWnd = (CWnd *)&m_wndStatusBar;
	
	CClientDC	cdcStatus( statusWnd );
	CSize		size;
	size = cdcStatus.GetTextExtent( "Test" );
	nStatusSize =size.cy + GetSystemMetrics( SM_CYBORDER )*2;

	// TODO: Remove this if you don't want tool tips or a resizeable toolbar
//	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
//		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);

	// TODO: Delete these three lines if you don't want the toolbar to
	//  be dockable
//	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
//	EnableDocking(CBRS_ALIGN_ANY);
//	DockControlBar(&m_wndToolBar);

	BuildCRCTable();
	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	cs.x = nStartX;
	cs.y = nStartY;

//	cs.style |= FWS_ADDTOTITLE;
//	cs.style |= CS_CLASSDC;
//	cs.style |= CS_PARENTDC;
//	cs.style |= CS_BYTEALIGNCLIENT;
	cs.style &= ~WS_THICKFRAME;
	//cs.style |= CS_BYTEALIGNWINDOW;
	cs.style |= CS_OWNDC;

	return CFrameWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

void CMainFrame::DriveInsert( int drivenum )
{
	CString	name = "";
	char	szCurDir[ MAX_PATH ];

	GetCurrentDirectory( MAX_PATH, szCurDir );
	if( strcmp( sio_filename[ drivenum-1 ], "Empty" ) && strcmp( sio_filename[ drivenum-1 ], "None" ) &&
		strcmp( sio_filename[ drivenum-1 ], "Off" ) )
	{
		char	szNewDir[ MAX_PATH ];
		int i;

		strcpy( szNewDir, sio_filename[ drivenum-1 ] );
		for( i=strlen( szNewDir ); i > 0 && szNewDir[i]!='\\'; i--);
		if( i > 0 )
			szNewDir[i] = 0;
		SetCurrentDirectory( szNewDir );
	}

	if( !(ulScreenMode & DDRAW_WIND) && !(ulScreenMode & DDRAW_NONE) && ((ulScreenMode & DDRAW_320_200) || (ulScreenMode & DDRAW_320_240)) )
	{
		CFileSmallDlg fileDlg;
		if( fileDlg.DoModal() == IDOK )
		{
			name = fileDlg.GetPathName();	
			SIO_Dismount( drivenum );
			SIO_Mount( drivenum, name.GetBuffer( 0 ) );
			name.ReleaseBuffer();
		}
	}
	else
	{
		char BASED_CODE szFilter[] = "Atari disk images (*.atr,*.xfd)|*.atr;*.xfd|ATR Images only (*.atr)|*.atr|XFD Images only (*.xfd)|*.xfd|All Files (*.*)|*.*||";
		CFileDialog	cfDiskImage( TRUE, NULL, NULL, OFN_EXPLORER | OFN_FILEMUSTEXIST, szFilter, this );

		if( cfDiskImage.DoModal() == IDOK )
		{
			name = cfDiskImage.GetPathName();
			SIO_Dismount( drivenum );
			SIO_Mount( drivenum, name.GetBuffer( 0 ) );
			name.ReleaseBuffer();
		}
	}
	SetCurrentDirectory( szCurDir );
	WriteRegString( NULL, REG_DRIVE1, sio_filename[0] );
	WriteRegString( NULL, REG_DRIVE2, sio_filename[1] );
	WriteRegString( NULL, REG_DRIVE3, sio_filename[2] );
	WriteRegString( NULL, REG_DRIVE4, sio_filename[3] );
	WriteRegString( NULL, REG_DRIVE5, sio_filename[4] );
	WriteRegString( NULL, REG_DRIVE6, sio_filename[5] );
	WriteRegString( NULL, REG_DRIVE7, sio_filename[6] );
	WriteRegString( NULL, REG_DRIVE8, sio_filename[7] );
}

BOOL CMainFrame::PreTranslateMessage(MSG* pMsg) 
{
	switch( pMsg->message )
	{
		//This needs to be handled here instead of a OnXXX message because
		//we want to intercept control keys before they are parsed as accelerators
		case	WM_KEYDOWN:
		{
			WPARAM wp = pMsg->wParam;
			
//			if( pMsg->wParam != 17 )
//				wp = pMsg->wParam;
			if( GetAsyncKeyState( VK_CONTROL ) < 0 )
			{
				if( wp >= VK_F1 && wp <= VK_F8 )
				{
					DriveInsert( wp - VK_F1 + 1);
					return TRUE;
				}
#ifdef ATARI_UI
				if( m_iCtrlKeys[ wp ]==AKEY_UI )
				{
					if( ulAtariState & ATARI_RUNNING )
					{
						startThread();
						return TRUE;
					}
				}
#endif
				if( m_iCtrlKeys[ wp ]!=AKEY_NONE )
				{
					if( GetAsyncKeyState( VK_SHIFT ) < 0 )
						iKbBuffer[nKbBufferChars++] = m_iCtrlKeys[ wp ] | AKEY_SHFTCTRL;
					else
						iKbBuffer[nKbBufferChars++] = m_iCtrlKeys[ wp ];
					if( nKbBufferChars == KEYBOARD_BUFFER_SIZE )
					{
						iKbBuffer[0]=0;
						nKbBufferChars = 0;
					}
					return TRUE;
				}
			}
			
			if( m_iSpecialKeys[ wp] != AKEY_NONE )
			{
				if( wp == VK_F8 )
				{
					Toggle_Pause();
					Screen_Paused( (UBYTE *)atari_screen );
					return TRUE;
				}

				if( wp == VK_F9 )
				{
					Toggle_FullSpeed();
					if( ulAtariState & ATARI_PAUSED )
						Screen_Paused( (UBYTE *)atari_screen );
					return TRUE;
				}

				if( wp == VK_F11 )
				{
					Toggle_SIO_Patch();
					return TRUE;
				}

				iKbBuffer[nKbBufferChars++] = m_iSpecialKeys[ wp ];
				if( wp == VK_F5 && (GetAsyncKeyState( VK_SHIFT ) < 0) )
					iKbBuffer[ nKbBufferChars - 1] = AKEY_COLDSTART;

				if( nKbBufferChars == KEYBOARD_BUFFER_SIZE )
				{
					iKbBuffer[0]==0;
					nKbBufferChars = 0;
				}
				return TRUE;
			}

			return CFrameWnd::PreTranslateMessage(pMsg);
			break;
		}

		case	WM_SYSKEYDOWN:
		{
			if( pMsg->wParam == '\r' )
			{
				if( ulScreenMode & DDRAW_FULL )
				{
					ulScreenMode &= ~DDRAW_FULL;
					if( !(ulScreenMode & DDRAW_WIND) && !(ulScreenMode & DDRAW_NONE) )
						ulScreenMode |= DDRAW_NONE;
				}
				else
					ulScreenMode |= DDRAW_FULL;

				WriteRegDWORD( NULL, REG_DDRAW_MODE, ulScreenMode );
				Init_Graphics();
				return TRUE;
			}
			break;
		}

		case	WM_CHAR:
		{
//			WPARAM wp = pMsg->wParam;
			iKbBuffer[nKbBufferChars++] = m_iNormKeys[pMsg->wParam];
			if( nKbBufferChars == KEYBOARD_BUFFER_SIZE )
			{
				ZeroMemory( iKbBuffer, KEYBOARD_BUFFER_SIZE * sizeof( int ) );
				nKbBufferChars = 0;
			}
			return TRUE;
			break;
		}

		case	WM_KEYUP:
		{
			if( ulMiscStates & ATARI_STICK_RELEASE )
			{
				if( m_iSpecialKeys[ pMsg->wParam ] != AKEY_NONE )
				{
					if( m_iSpecialKeys[ pMsg->wParam ] != KEYPAD0 )
						keystick = STICK_CENTRE;
				}
			}
			return CFrameWnd::PreTranslateMessage(pMsg);
		}
		
		default:
			return CFrameWnd::PreTranslateMessage(pMsg);
			break;
	}
	return CFrameWnd::PreTranslateMessage(pMsg);
}


void CMainFrame::OnSystemDisk() 
{
	if( (ulScreenMode & DDRAW_FULL) && ((ulScreenMode & DDRAW_320_200) || (ulScreenMode & DDRAW_320_240)) )
	{
		CDriveSmallDlg	DriveSmallDlg( this );
		DriveSmallDlg.DoModal();
	}
	else
	{
		CDriveDialog	DriveDialog( this );
		DriveDialog.DoModal();
	}
}

void CMainFrame::OnAtariHarddisk() 
{
	CHardDiskDlg	hardDisk;
	hardDisk.DoModal();
}

void CMainFrame::OnAtariHardware() 
{
	CHardwareDlg	HardwareDlg( this );

	HardwareDlg.DoModal();
	Invalidate();
}

void CMainFrame::OnAtariCartridge() 
{
	CCartridgeDlg	CartridgeDlg( this );

	CartridgeDlg.DoModal();
}

void CMainFrame::OnClose() 
{
	RECT	rc;

	if( sndoutput )
	{
		unsigned int	unPos = 0;

		//Sound file is finished, so modify header and close it.
		unPos = ftell( sndoutput ) - 8;
		fseek( sndoutput, 4, SEEK_SET );	//Seek past RIFF
		fwrite( &unPos, 4, 1, sndoutput );	//Write out size of entire data chunk
		fseek( sndoutput, 40, SEEK_SET );
		unPos -= 36;						
		fwrite( &unPos, 4, 1, sndoutput );	//Write out size of just sample data
		fclose( sndoutput );
	}
	sndoutput = NULL;

	GetWindowRect( &rc );

	if( (rc.left!=0) && (nStartX != rc.left) )
		WriteRegDWORD( NULL, REG_START_XPOS, (DWORD)rc.left );

	if( (rc.top!=0) && (nStartY != rc.top ) )
		WriteRegDWORD( NULL, REG_START_YPOS, (DWORD)rc.top );
	
	CFrameWnd::OnClose();
}

void CMainFrame::OnInfoBenchmark() 
{
	char	szReport[LOADSTRING_STRING_SIZE];
	ULONG	starttime, rendertime, i;
	double	result;

	LoadString( NULL, IDS_HIT_RETURN, gcErrorString, LOADSTRING_STRING_SIZE );
	MessageBox( gcErrorString, MB_OK );
	starttime = timeGetTime();
	for( i=0; i  < 30; i++ )
		Atari_DisplayScreen( (UBYTE *)atari_screen );
	rendertime = timeGetTime() - starttime;
	result = (double)rendertime/30.0;
	LoadString( NULL, IDS_REPORT_FORMAT, gcErrorString, LOADSTRING_STRING_SIZE );
	sprintf( szReport, gcErrorString, rendertime, result );
	if( result >  20.0 )
	{
		LoadString( NULL, IDS_SPEED_WARNING, gcErrorString, LOADSTRING_STRING_SIZE );
		strcat( szReport, gcErrorString );
	}
	LoadString( NULL, IDS_BENCHMARK_RESULTS, gcErrorString, LOADSTRING_STRING_SIZE );
	MessageBox( szReport, gcErrorString, MB_OK );
}

void CMainFrame::OnOptionsGraphics() 
{
	int	iReturn;


	if( ulScreenMode & DDRAW_FULL && ((ulScreenMode & DDRAW_320_200) || (ulScreenMode & DDRAW_320_240)) )
	{
		CGraphicsSmallDlg	GraphicsSmallDlg( this );
		iReturn = GraphicsSmallDlg.DoModal();
	}
	else
	{
		CGraphicsDlg	GraphicsDlg( this );
		iReturn = GraphicsDlg.DoModal();
	}
	//Show the window because if we changed DDraw modes the frame will be missing 
	//until forced to redraw here
	if( iReturn == IDOK )
		ShowWindow( SW_SHOWNORMAL );
}

void CMainFrame::OnOptionsSound() 
{
	SoundDlg	Sound;
	Sound.DoModal();
}

void CMainFrame::OnInfoSoundPokeySpeed() 
{
	int i, unSampleSize;
	ULONG	starttime, totaltime;
	char	*cTmp = NULL;

	if( default_tv_mode == 1 )
		unSampleSize = nSoundRate / 50;
	else
		unSampleSize = nSoundRate / 60;
	cTmp = (char *)calloc( 1, unSampleSize + 1 );
	if( !cTmp )
		return;
	if( !(ulAtariState & ATARI_RUNNING) || (ulSoundState & SOUND_NOSOUND) )
	{
		LoadString( NULL, IDS_SOUND_TEST_WARNING, gcErrorString, LOADSTRING_STRING_SIZE );
		MessageBox( gcErrorString, MB_OK );
		free( cTmp );
		return;
	}
	LoadString( NULL, IDS_SOUND_TEST_BEGIN, gcErrorString, LOADSTRING_STRING_SIZE );
	MessageBox( gcErrorString, MB_OK );
	starttime = timeGetTime();
	for( i=0; i < 60; i++ )
		Pokey_process( (unsigned char *)cTmp, unSampleSize );
	totaltime = timeGetTime() - starttime;
	LoadString( NULL, IDS_SOUND_TEST_RESULT, gcErrorString, LOADSTRING_STRING_SIZE );
	sprintf( cTmp, gcErrorString, unSampleSize, totaltime, (double)totaltime/60.0 );
	MessageBox( cTmp, MB_OK );
	free( cTmp );
}


void CMainFrame::OnOptionsJoystick() 
{
	CJoyStickDlg	joyDlg;
	CWarnDlg	Warning;
	int	result = IDOK;

	if( !(ulAtariState & ATARI_JOYSTICK_FOUND) && !(ulDontShowFlags & DONT_SHOW_JOYSTICK_WARN) )
	{
		char	message[LOADSTRING_STRING_SIZE];
		LoadString( NULL, IDS_WARNING_NO_JOYSTICK, message, LOADSTRING_STRING_SIZE );
		Warning.csWarnText = message;
		Warning.iWarnBit = DONT_SHOW_JOYSTICK_WARN;
		result = Warning.DoModal();
	}
	joyDlg.DoModal();
}

void CMainFrame::OnOptionsLog() 
{
	CErrorLogDlg	ErrorLog;
	ErrorLog.DoModal();
}

void CMainFrame::OnOptionsSoundfile() 
{
	CWarnDlg	Warning;
	int			result = IDOK;

	if( sndoutput )
	{
		unsigned int	unPos = 0;

		//Sound file is finished, so modify header and close it.
		unPos = ftell( sndoutput ) - 8;
		fseek( sndoutput, 4, SEEK_SET );	//Seek past RIFF
		fwrite( &unPos, 4, 1, sndoutput );	//Write out size of entire data chunk
		fseek( sndoutput, 40, SEEK_SET );
		unPos -= 36;						
		fwrite( &unPos, 4, 1, sndoutput );	//Write out size of just sample data
		fclose( sndoutput );
		sndoutput = NULL;
		LoadString( NULL, IDS_SOUND_FILE_CLOSED, gcErrorString, LOADSTRING_STRING_SIZE );
		MessageBox( gcErrorString, MB_OK );
		return;
	}

	if( ulSoundState & SOUND_NOSOUND )
	{
		LoadString( NULL, IDS_SOUND_RECORD, gcErrorString, LOADSTRING_STRING_SIZE );
		MessageBox( gcErrorString, MB_OK );
	}

	if( !(ulDontShowFlags & DONT_SHOW_SOUNDFILE_WARN ) )
	{
		char	message[LOADSTRING_STRING_SIZE];
		LoadString( NULL, IDS_WARNING_SOUNDFILE, message, LOADSTRING_STRING_SIZE );
		Warning.csWarnText = message;
		Warning.iWarnBit = DONT_SHOW_SOUNDFILE_WARN;
		result = Warning.DoModal();
	}

	if( result==IDOK )
	{
		CString		name;

		name.GetBuffer(MAX_PATH);
		name.Format("%s", "atarisnd" );

		CFileDialog	cfdTransScript( FALSE, "wav", name, OFN_NOCHANGEDIR | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT | OFN_PATHMUSTEXIST, NULL, this );
		if( cfdTransScript.DoModal()==IDOK )
		{
			name = cfdTransScript.GetPathName();
			sndoutput = fopen( name.GetBuffer(0), "wb" );
			/*
			The RIFF header: 

			  Offset  Length   Contents
			  0       4 bytes  'RIFF'
			  4       4 bytes  <file length - 8>
			  8       4 bytes  'WAVE'
			
			The fmt chunk: 

			  12      4 bytes  'fmt '
			  16      4 bytes  0x00000010     // Length of the fmt data (16 bytes)
			  20      2 bytes  0x0001         // Format tag: 1 = PCM
			  22      2 bytes  <channels>     // Channels: 1 = mono, 2 = stereo
			  24      4 bytes  <sample rate>  // Samples per second: e.g., 44100
			  28      4 bytes  <bytes/second> // sample rate * block align
			  32      2 bytes  <block align>  // channels * bits/sample / 8
			  34      2 bytes  <bits/sample>  // 8 or 16

			The data chunk: 

			  36      4 bytes  'data'
			  40      4 bytes  <length of the data block>
			  44        bytes  <sample data>
			*/
			fwrite( "RIFF\000\000\000\000WAVEfmt\040\020\000\000\000\001\000\001\000", 24, 1, sndoutput );
			fwrite( &nSoundRate, 4, 1, sndoutput );
			fwrite( &nSoundRate, 4, 1, sndoutput );
			fwrite( "\001\000\010\000data\000\000\000\000", 8, 1, sndoutput );
		}
	}
}

void CMainFrame::OnMiscClearall() 
{
	int result;

	LoadString( NULL, IDS_CLEAR_AFFIRM, gcErrorString, LOADSTRING_STRING_SIZE );
	result = MessageBox( gcErrorString, "Atari800Win", MB_YESNO );

	if( result == IDYES )
	{
		DeleteAllRegKeys( NULL, REGNAME );
		HandleRegistry();
	}
}

void CMainFrame::OnTimer(UINT nIDEvent) 
{
	if( nIDEvent == TIMER_READ_JOYSTICK )
	{
		ReadJoystickInput( 0, 0 );
		if( !(ulAtariState & ATARI_PAUSED) )
			::KillTimer( MainhWnd, TIMER_READ_JOYSTICK );
	}

	CFrameWnd::OnTimer(nIDEvent);
}

void CMainFrame::OnMove(int x, int y) 
{
	CFrameWnd::OnMove(x, y);

	if( hWnd )
		ComputeClipArea();
}

