// AtariServer.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "common.h"

#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAtariServerApp

BEGIN_MESSAGE_MAP(CAtariServerApp, CWinApp)
	//{{AFX_MSG_MAP(CAtariServerApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAtariServerApp construction

CAtariServerApp::CAtariServerApp()
{
	m_iconTaskbar = 0;
}


/////////////////////////////////////////////////////////////////////////////
// The one and only CAtariServerApp object

CAtariServerApp theApp;


/////////////////////////////////////////////////////////////////////////////
// CAtariServerApp initialization

BOOL CAtariServerApp::InitInstance()
{
	m_wndClassInvisibleParent = AfxRegisterWndClass( CS_OWNDC );
	m_wndInvisibleParent.CreateEx(0,(LPCTSTR)m_wndClassInvisibleParent,"",WS_DLGFRAME,CRect(0,0,10,10),NULL,0,NULL);

	CreateToolbarIcon();

	AfxEnableControlContainer();

	// Standard initialization

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// Change the registry key under which our settings are stored.
	SetRegistryKey(AFX_IDS_APP_TITLE);

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	m_cstrDiskFileDirectory = GetProfileString( "Settings", "DiskPath" ); 

	// Register document templates

	CSingleDocTemplate* pDocTemplate;

	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CAtariServerDoc),
		RUNTIME_CLASS(CMainFrame),       // main SDI frame window
		RUNTIME_CLASS(CAtariServerView));

	AddDocTemplate(pDocTemplate);

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// Dispatch commands specified on the command line

	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	m_pMainWnd->ShowWindow(SW_SHOW);
	m_pMainWnd->UpdateWindow();

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CEdit	m_txtReadme;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Control(pDX, IDC_README, m_txtReadme);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()





BOOL CAboutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	

	CString		cstrTemp;
	HMODULE		hmodMe;
	HRSRC		resReadmeText;
	LPBYTE		mbufReadmeText, p1;
	int			nBytes;

	hmodMe = GetModuleHandle(NULL);

	resReadmeText = FindResource(hmodMe,MAKEINTRESOURCE(IDR_README), RT_RCDATA);

#ifdef _DEBUG
	if( !resReadmeText )
	{
		DWORD ecode = GetLastError();
		CString	cstrGetError((TCHAR)0,256);
		FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM+20, NULL, ecode, 0, (char *)(LPCTSTR)cstrGetError, cstrGetError.GetLength(), NULL ); 

		cstrTemp.Format("Readme didn't load;   result: %i    txt: %s", ecode, (LPCTSTR)cstrGetError );

		m_txtReadme.SetWindowText(cstrTemp);
	}
	else
	{
#endif

	mbufReadmeText = (LPBYTE)LoadResource( hmodMe, resReadmeText );

	ASSERT( mbufReadmeText );

	p1 = (LPBYTE)strstr( (const char *)mbufReadmeText,"**");

	ASSERT( p1 );

	nBytes = (p1-mbufReadmeText);

	cstrTemp = CString( (LPCTSTR)mbufReadmeText, nBytes );

	m_txtReadme.SetWindowText(cstrTemp);

#ifdef _DEBUG
	}
#endif
	
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}







// App command to run the dialog
void CAtariServerApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CAtariServerApp commands

int CAtariServerApp::ExitInstance() 
{
	
	m_wndInvisibleParent.DestroyWindow();

	if( m_iconTaskbar ) DestroyIcon( m_iconTaskbar );
	
	return CWinApp::ExitInstance();
}






void CAtariServerApp::CreateToolbarIcon()
{
	CBitmap		bmpMask, bmpColor;
	ICONINFO	ici;

	ici.fIcon = TRUE;
	ici.xHotspot = 0;
	ici.yHotspot = 0;
	
	bmpMask.LoadBitmap( IDB_TBMASKBITS );
	ici.hbmMask = (HBITMAP)bmpMask;

	bmpColor.LoadBitmap( IDB_TBCOLORBITS );
	ici.hbmColor = (HBITMAP)bmpColor;

	m_iconTaskbar = CreateIconIndirect( &ici );

	ASSERT( m_iconTaskbar );

}
