// DeviceSet.cpp: implementation of the CDeviceSet class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "common.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////



CDeviceSet::CDeviceSet( CAtariServerDoc *pDoc )
{
	m_arrayDiskDevices.SetSize(4);
	for(int i=0; i<4; i++) m_arrayDiskDevices.SetAt(i,NULL);

	m_portWindow	= NULL;
	m_isOpen		= FALSE;

	m_myDoc			= pDoc;

	m_nbpsRecv = m_nbpsSend = 0;
}



CDeviceSet::~CDeviceSet()
{
	for(int i=1; i<=4; i++) diskDismount(i);

	POSITION	pos = m_myDoc->m_listDeviceSets.Find( (CObject *)this );
	if( pos ) m_myDoc->m_listDeviceSets.RemoveAt( pos );


	if( m_isOpen )
	{
		m_TerminateFlag = TRUE;
		while( !m_IsTerminated ) Sleep(10);
		CloseHandle( m_hComm );
	}
	if( m_portWindow )
	{
		m_portWindow->m_devSet = NULL;
		delete m_portWindow;
	}
}









void CDeviceSet::Serialize(CArchive& ar)
{
	int				nDiskNum;
	BOOL			flag;
	CDiskDevice		*cdd;

	if (ar.IsStoring())
	{
		for(nDiskNum=1; nDiskNum<=4; nDiskNum++)
		{
			if( (cdd = (CDiskDevice *)m_arrayDiskDevices.GetAt(nDiskNum-1)) )
			{
				flag = TRUE;	ar << flag;
				ar << cdd->fileGetDiskFileName();
				ar << cdd->fileGetDiskPathName();
			}
			else
			{
				flag = FALSE;	ar << flag;
			}
		}
	}
	else
	{
		CString		cstrFileName, cstrPathName, cstrErr;

		for(nDiskNum=1; nDiskNum<=4; nDiskNum++)
		{
			ar >> flag;
			if( flag )
			{
				CDiskData	*diskData = new CDiskData(m_myDoc);

				ar >> cstrFileName;
				ar >> cstrPathName;

				ASSERT( cstrFileName.GetLength() );
				ASSERT( cstrPathName.GetLength() );

				if( diskData->diskOpen( cstrFileName, cstrPathName ) )
				{
					diskMount( nDiskNum, diskData );
				}
				else
				{
					delete diskData;
					cstrPathName.MakeUpper();
					cstrErr.Format( IDS_MSG_CANTOPENDISK, cstrPathName );
					AfxMessageBox(cstrErr, MB_ICONERROR + MB_OK );
				}
			}
		}
	}
}










static UINT serverEntry( LPVOID pParam )
{
	CDeviceSet	*thdService = (CDeviceSet *)pParam;
	thdService->ServicePort();
	return 0;
}





BOOL	CDeviceSet::OpenPort( CString cstrPort, CString cstrDescription )
{
	BOOL			fSuccess;
	DCB				dcb;
	COMMTIMEOUTS	ctime;

	ASSERT( !m_isOpen );

	m_cstrPort = cstrPort;
	m_cstrDescription = cstrDescription;


	if( (m_hComm = CreateFile( (LPCTSTR)m_cstrPort,
								GENERIC_READ | GENERIC_WRITE, 
								0, 
								NULL, 
								OPEN_EXISTING,
								0,
								NULL )) ==  INVALID_HANDLE_VALUE )
	{
		m_hComm = NULL;
		return FALSE;
	}


	dcb.DCBlength	=	sizeof(DCB);
	dcb.BaudRate	=	CBR_19200;
	dcb.fBinary		=	TRUE;
	dcb.fParity		=   FALSE;

	dcb.fOutxCtsFlow	= FALSE;
	dcb.fOutxDsrFlow	= FALSE;
	dcb.fDtrControl		= DTR_CONTROL_DISABLE;
	dcb.fDsrSensitivity = FALSE;

	dcb.fTXContinueOnXoff	= FALSE;
	dcb.fOutX				= FALSE;
	dcb.fInX				= FALSE;

	dcb.fErrorChar	= 0;
	dcb.fNull		= FALSE;

	dcb.fRtsControl = RTS_CONTROL_DISABLE;

	dcb.fAbortOnError = FALSE;
	dcb.XonLim = dcb.XoffLim = 0;
	dcb.XonChar = dcb.XoffChar = 0;
	dcb.EofChar = dcb.EvtChar = 0;

	dcb.ErrorChar = 0;

	dcb.ByteSize	= 8;
	dcb.Parity		= NOPARITY;
	dcb.StopBits	= ONESTOPBIT;

	if( !(fSuccess= SetCommState( m_hComm, &dcb )) )
	{
		CloseHandle( m_hComm );
		return FALSE;
	}




	ctime.ReadIntervalTimeout			= 0;
	ctime.ReadTotalTimeoutMultiplier	= 0;
	ctime.ReadTotalTimeoutConstant		= 250;
	ctime.WriteTotalTimeoutMultiplier	= 0;
	ctime.WriteTotalTimeoutConstant		= 0;

	if( !(fSuccess= SetCommTimeouts( m_hComm, &ctime )) )
	{
		CloseHandle( m_hComm );
		return FALSE;
	}






	m_dwEvtMask = EV_RXCHAR | EV_TXEMPTY;

	if( !(fSuccess = SetCommMask( m_hComm, m_dwEvtMask )) )
	{
		CloseHandle( m_hComm );
		return FALSE;
	}



	m_IsTerminated = m_TerminateFlag = FALSE;

	m_SvrThread = AfxBeginThread( (AFX_THREADPROC)serverEntry, (LPVOID)this, 0, 0, 0, NULL );
	m_SvrThread->m_bAutoDelete = TRUE;

	SetPriorityClass( m_SvrThread->m_hThread, REALTIME_PRIORITY_CLASS );
	SetThreadPriority( m_SvrThread->m_hThread, THREAD_PRIORITY_TIME_CRITICAL );

	m_isOpen = TRUE;

	return TRUE;
}














CDiskDevice	 * CDeviceSet::diskMount( int nDiskNum, CDiskData *diskData )
{
	ASSERT( nDiskNum>=1 && nDiskNum<=4 );

	CDiskDevice		*newDisk = new CDiskDevice(m_myDoc);

	m_arrayDiskDevices.SetAt( nDiskNum-1, newDisk);

	newDisk->diskSetData( nDiskNum, diskData );
	return newDisk;
}




void CDeviceSet::diskDismount( int nDrive )
{
	CDiskDevice	*cdd;

	if( (cdd = (CDiskDevice *)m_arrayDiskDevices.GetAt( nDrive-1 )) )
	{
		m_arrayDiskDevices.SetAt( nDrive-1, NULL);

		cdd->diskClose();
		delete cdd;
	}
}







CDiskDevice	*	CDeviceSet::GetDiskDevice( int nDiskNum )
{
	ASSERT( nDiskNum>=1 && nDiskNum<=4 );

	return (CDiskDevice *)m_arrayDiskDevices.GetAt(nDiskNum-1);
}











void	CDeviceSet::UpdateStats(void)
{
	CString		cstr;
	CDiskDevice	*cdd;
	int			i;

	cstr.Format(IDS_FMT_IOSTAT, m_nbpsRecv, m_nbpsSend );

	m_nbpsRecv = m_nbpsSend = 0;

	(m_portWindow->m_staticIOStats).SetWindowText(cstr);

	for(i=0; i<4; i++)
	{
		if( (cdd = (CDiskDevice *)m_arrayDiskDevices.GetAt(i)) )
			cdd->UpdateStats();
	}
}







void mySleep( int nMils )
{
	DWORD	tmark = GetTickCount() + nMils;
	while( GetTickCount() < tmark );
	return;
}



#define  CMD_GETSTATUS  0x53
#define  CMD_PUTSECTOR  0x57
#define  CMD_PUTSECTORV 0x50
#define  CMD_GETSECTOR  0x52
#define  CMD_FORMAT     0x21




void	CDeviceSet::ServicePort(void)
{
	CDiskDevice		*cdd;
	CMDFRAME		cmdFrame;
	BYTE			dataBuff[512];
	DWORD			dwNumBytes, dwBytesProcessed;
	int				devID,sectNumber;

	while( !m_TerminateFlag )
	{
		ReadFile( m_hComm, (LPVOID)&cmdFrame, sizeof(CMDFRAME), &dwBytesProcessed, NULL );

		if( dwBytesProcessed == sizeof(CMDFRAME) )
		{
			if( calcChecksum( (LPBYTE)&cmdFrame, sizeof(CMDFRAME)-1 ) == cmdFrame.chksum )
			{
				devID = cmdFrame.devID - '0';

				if( devID >= 1 && devID <= 4 )
				{
					if( (cdd = GetDiskDevice(devID)) )
					{
						switch( cmdFrame.cmd )
						{

						case CMD_GETSTATUS:
							m_nbpsRecv += sizeof(CMDFRAME);

							mySleep(2);
							m_nbpsSend += WriteFile( m_hComm, (LPCTSTR)"A", 1, &dwBytesProcessed, NULL );

							mySleep(2);
							WriteFile( m_hComm, (LPCTSTR)"C", 1, &dwBytesProcessed, NULL );
							m_nbpsSend += dwBytesProcessed;

							dwNumBytes = cdd->cmdGetStatus( dataBuff );

							mySleep(2);
							WriteFile( m_hComm, dataBuff, dwNumBytes, &dwBytesProcessed, NULL );
							m_nbpsSend += dwBytesProcessed;
							break;







						case CMD_GETSECTOR:
							m_nbpsRecv += sizeof(CMDFRAME);

							mySleep(1);
							WriteFile( m_hComm, (LPCTSTR)"A", 1, &dwBytesProcessed, NULL );
							m_nbpsSend += dwBytesProcessed;

							sectNumber = ((int)cmdFrame.aux1 + (((int)cmdFrame.aux2)<<8) ) -1;

							if( (dwNumBytes = cdd->cmdGetSector( sectNumber, dataBuff )) > 0 )
							{
								mySleep(4);
								WriteFile( m_hComm, (LPCTSTR)"C", 1, &dwBytesProcessed, NULL );
								m_nbpsSend += dwBytesProcessed;

								mySleep(1);
								WriteFile( m_hComm, dataBuff, dwNumBytes, &dwBytesProcessed, NULL );
								m_nbpsSend += dwBytesProcessed;
							}
							else
							{
								mySleep(2);
								WriteFile( m_hComm, (LPCTSTR)"E", 1, &dwBytesProcessed, NULL );
								m_nbpsSend += dwBytesProcessed;
							}

							break;






						case CMD_PUTSECTOR:
						case CMD_PUTSECTORV:
							m_nbpsRecv += sizeof(CMDFRAME);

							if( !cdd->isWriteProtect() )
							{
								mySleep(2);
								m_nbpsSend += WriteFile( m_hComm, (LPCTSTR)"A", 1, &dwBytesProcessed, NULL );

								sectNumber = ((int)cmdFrame.aux1 + (((int)cmdFrame.aux2)<<8) ) -1;

								dwNumBytes = cdd->cmdGetEffectiveSectorSizeFromNumber( sectNumber );

								ReadFile( m_hComm, dataBuff, dwNumBytes, &dwBytesProcessed, NULL );
								m_nbpsRecv += dwBytesProcessed;

								if( dwBytesProcessed == dwNumBytes )
								{
									mySleep(2);
									m_nbpsSend += WriteFile( m_hComm, (LPCTSTR)"A", 1, &dwBytesProcessed, NULL );

									if( cdd->cmdPutSector(sectNumber, dataBuff) )
									{
										mySleep(2);
										WriteFile( m_hComm, (LPCTSTR)"C", 1, &dwBytesProcessed, NULL );
										m_nbpsSend += dwBytesProcessed;
									}
									else
									{
										mySleep(2);
										WriteFile( m_hComm, (LPCTSTR)"E", 1, &dwBytesProcessed, NULL );
										m_nbpsSend += dwBytesProcessed;
									}
								}
								else
								{
									mySleep(2);
									WriteFile( m_hComm, (LPCTSTR)"N", 1, &dwBytesProcessed, NULL );
									m_nbpsSend += dwBytesProcessed;
								}
							}
							else
							{
								mySleep(2);
								WriteFile( m_hComm, (LPCTSTR)"E", 1, &dwBytesProcessed, NULL );
								m_nbpsSend += dwBytesProcessed;
							}

							break;






						case CMD_FORMAT:
							m_nbpsRecv += sizeof(CMDFRAME);

							if( (dwNumBytes = cdd->cmdFormatDisk( dataBuff )) > 0 )
							{
								mySleep(2);
								WriteFile( m_hComm, (LPCTSTR)"C", 1, &dwBytesProcessed, NULL );
								m_nbpsSend += dwBytesProcessed;

								mySleep(2);
								WriteFile( m_hComm, dataBuff, dwNumBytes, &dwBytesProcessed, NULL );
								m_nbpsSend += dwBytesProcessed;
							}
							else
							{
								mySleep(2);
								WriteFile( m_hComm, (LPCTSTR)"E", 1, &dwBytesProcessed, NULL );
								m_nbpsSend += dwBytesProcessed;
							}
							break;
						}
					}
				}
			}
		}
	}
	m_IsTerminated= TRUE;
}




