// DeviceSet.h: interface for the CDeviceSet class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_DEVICESET_H__88C45E73_01F8_11D2_85C2_00609755C47F__INCLUDED_)
#define AFX_DEVICESET_H__88C45E73_01F8_11D2_85C2_00609755C47F__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class CDeviceSet : public CObject  
{
public:
	CDeviceSet( CAtariServerDoc *pDoc );
	virtual ~CDeviceSet();

	void Serialize(CArchive& ar);

	BOOL	OpenPort( CString cstrPort, CString cstrDescription );
	void	UpdateStats(void);

	CDiskDevice	 *	diskMount( int nDiskNum, CDiskData	*diskData );
	void	diskDismount( int nDrive );

	inline	CString	GetPortName(){ return m_cstrPort; }
	inline	CString	GetDescription(){ return m_cstrDescription; }
	inline	void	SetDescription( CString txt ){ m_cstrDescription = txt; }

	CDiskDevice	* GetDiskDevice( int nDiskNum );

	void	ServicePort();

	class CPortWindow	*m_portWindow;

private:
	volatile int m_nbpsRecv;
	volatile int m_nbpsSend;

	volatile BOOL m_IsTerminated;
	volatile BOOL m_TerminateFlag;

	CString		m_cstrPort, m_cstrDescription;

	CObArray	m_arrayDiskDevices;

	BOOL		m_isOpen;
	HANDLE		m_hComm;
	DWORD		m_dwEvtMask, m_opts;

	CWinThread		*m_SvrThread;
	CAtariServerDoc	*m_myDoc;
};

#endif // !defined(AFX_DEVICESET_H__88C45E73_01F8_11D2_85C2_00609755C47F__INCLUDED_)
