// DiskData.h: interface for the CDiskData class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_DISKDATA_H__99F06360_0772_11D2_834B_00A024B91B45__INCLUDED_)
#define AFX_DISKDATA_H__99F06360_0772_11D2_834B_00A024B91B45__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class CDiskData : public CObject  
{
private:
	void	GetDiskGeometry( int dtype, int &nBytesPerSector, int &nNumSectors );

	CString		m_cstrFileName, m_cstrPathName;

	BOOL		m_isDirty;
	LPBYTE		m_dskDataBytes;

	int			m_dskSizeBytes;
	int			m_dskType;
	int			m_dskBytesPerSector;
	int			m_dskNumberSectors;
	BOOL		m_dskWriteProtect;
	CString		m_dskDesc;

	FILE		*m_hFile;

	int			nRefCount;

	CAtariServerDoc		*m_myDoc;

public:
	int		m_nSectorsRead, m_nSectorsWritten;


	CDiskData( CAtariServerDoc *pDoc );
	virtual ~CDiskData();

	inline  void AddReference(){ nRefCount++; };
	inline  BOOL DropReference(){ return (--nRefCount == 0)?TRUE:FALSE; } 

	BOOL	diskCreate( CString cstrFileName, CString cstrPathName, CString desc, int dtype );
	BOOL	diskOpen( CString cstrFileName, CString cstrPathName );
	void	diskFlush(void);

	void	diskSetWriteProtect( BOOL state );
	void	diskSetNewDesc( CString desc );

	inline CString		diskGetDiskDesc(){ return m_dskDesc; }
	inline BOOL			diskGetWriteProtect(){ return m_dskWriteProtect; }
	inline int			diskGetBytesPerSector(){ return m_dskBytesPerSector; }
	inline int			diskGetNumberSectors(){ return m_dskNumberSectors; }

	inline int			diskGetDiskType(){ return m_dskType; }
	CString				diskGetDiskTypeName();

	inline void			diskSetDirty(){ m_isDirty = TRUE; }

	inline LPBYTE		GetDiskData(){ return m_dskDataBytes; }

	inline CString		fileGetDiskFileName(){ return m_cstrFileName; }
	inline CString		fileGetDiskPathName(){ return m_cstrPathName; }
};

#endif // !defined(AFX_DISKDATA_H__99F06360_0772_11D2_834B_00A024B91B45__INCLUDED_)
