// DiskDevice.h: interface for the CDiskDevice class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_DISKDEVICE_H__88C45E72_01F8_11D2_85C2_00609755C47F__INCLUDED_)
#define AFX_DISKDEVICE_H__88C45E72_01F8_11D2_85C2_00609755C47F__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class CDiskDevice : public CObject  
{
public:
	CDiskDevice( CAtariServerDoc *pDoc );
	virtual ~CDiskDevice();

	void		scrCtlSet( CPortWindow *cpw );
	void		scrCtlClear();

	void		diskSetData( int nDiskNum, CDiskData *myDisk );
	void		diskClose();

	void		diskSetWriteProtect( BOOL state );
	void		diskSetNewDesc( CString desc );

	void		UpdateStats();
	void		RefreshControls(void);

	DWORD		cmdGetStatus( LPBYTE buff );
	DWORD		cmdGetSector( int sectorNum, LPBYTE buff);
	BOOL		cmdPutSector( int sectorNum, LPBYTE buff );
	DWORD		cmdFormatDisk( LPBYTE buff );

	int			cmdGetEffectiveSectorSizeFromNumber( int sectorNum );

	inline BOOL isWriteProtect(){ return m_diskData->diskGetWriteProtect(); }

	inline CString fileGetDiskPathName(){ return m_diskData->fileGetDiskPathName(); }
	inline CString fileGetDiskFileName(){ return m_diskData->fileGetDiskFileName(); }

private:

	CButton		*m_chkWriteProt;
	CStatic		*m_staticDriveNum;
	CStatic		*m_staticDriveType;
	CStatic		*m_staticDriveStat;
	CEdit		*m_txtDriveDesc;
	CButton		*m_cmdAction;

	BOOL		m_SettingControls;

	CDiskData	*m_diskData;
	int			m_nDiskNum;

	CAtariServerDoc	*m_myDoc;
};

#endif // !defined(AFX_DISKDEVICE_H__88C45E72_01F8_11D2_85C2_00609755C47F__INCLUDED_)
