// DlgOpenPort.cpp : implementation file
//

#include "stdafx.h"
#include "common.h"

#include "DlgOpenPort.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgOpenPort dialog


CDlgOpenPort::CDlgOpenPort(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgOpenPort::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgOpenPort)
	m_cstrDeviceDescription = _T("");
	//}}AFX_DATA_INIT
}


void CDlgOpenPort::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgOpenPort)
	DDX_Control(pDX, IDC_COMMPORTLIST, m_cmbCommPortList);
	DDX_Text(pDX, IDC_DEVICEDESCRIPTION, m_cstrDeviceDescription);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDlgOpenPort, CDialog)
	//{{AFX_MSG_MAP(CDlgOpenPort)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgOpenPort message handlers


BOOL CDlgOpenPort::OnInitDialog() 
{
	CDialog::OnInitDialog();

	int			i;
	CString		cstrTemp;

	for(i=1; i<=10; i++)
	{
		cstrTemp.Format(IDS_FMT_COMPORT,i);
		m_cmbCommPortList.AddString( cstrTemp );
	}
	m_cmbCommPortList.SetCurSel(0);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}





void CDlgOpenPort::OnOK() 
{
	CString		cstrTemp;

	UpdateData(TRUE);

	CMainFrame		*mainWnd = (CMainFrame *)AfxGetMainWnd();
	CAtariServerDoc	*pDoc = (CAtariServerDoc *)mainWnd->GetActiveDocument();

	m_devSet = new CDeviceSet(pDoc);

	m_cmbCommPortList.GetWindowText( cstrTemp );

	if( !m_devSet->OpenPort( cstrTemp, m_cstrDeviceDescription ) )
	{
		delete m_devSet;
		return;
	}

	CDialog::OnOK();
}

