#if !defined(AFX_DLGSELECTDISK_H__88C45E75_01F8_11D2_85C2_00609755C47F__INCLUDED_)
#define AFX_DLGSELECTDISK_H__88C45E75_01F8_11D2_85C2_00609755C47F__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
// DlgSelectDisk.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CDlgSelectDisk dialog


class CDiskRecord : public CObject
{
public:

	CString			m_cstrFileName;
	CDiskData		*m_diskData;

	CStringList		m_listDiskFiles;
	int				m_SectorsFree;

	inline CDiskRecord( CDiskData *diskData)
	{
		m_diskData = diskData;
	}
	inline ~CDiskRecord()
	{
		if( m_diskData )
		{
			if( m_diskData->DropReference() ) delete m_diskData;
		}
	}
};







class CDlgSelectDisk : public CDialog
{
private:
	BOOL	ShowListItem();
	void	SelectListItem();
	void	LoadFilenames();
	void	ReadDiskDirectory( CDiskRecord *dskRec );

	CObList		m_listDiskRecords;

// Construction
public:
	CDlgSelectDisk(CWnd* pParent = NULL);   // standard constructor

	~CDlgSelectDisk();

	CDiskData	*m_cstrSelectedDisk;

// Dialog Data
	//{{AFX_DATA(CDlgSelectDisk)
	enum { IDD = IDD_DLG_SELECTDISK };
	CEdit	m_txtSectorsFree;
	CEdit	m_txtWriteProt;
	CButton	m_cmdShowByFileScan;
	CButton	m_cmdShowByFilename;
	CButton	m_cmdShowByDescription;
	CStatic	m_staticShowSortBy;
	CListBox	m_lbDiskFiles;
	CListBox	m_lbItems;
	CEdit	m_txtDiskFileName;
	CEdit	m_txtDiskType;
	CEdit	m_txtDiskDesc;
	CStatic	m_staticListHeader;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDlgSelectDisk)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CDlgSelectDisk)
	afx_msg void OnCreatenew();
	virtual BOOL OnInitDialog();
	afx_msg void OnButDescription();
	afx_msg void OnButFilename();
	afx_msg void OnButFilescan();
	afx_msg void OnDblclkItemlist();
	afx_msg void OnSelchangeItemlist();
	virtual void OnOK();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_DLGSELECTDISK_H__88C45E75_01F8_11D2_85C2_00609755C47F__INCLUDED_)
