// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "AtariServer.h"

#include "MainFrm.h"
#include "DlgSettings.h"

#include "AtariServerDoc.h"
#include "AtariServerView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif




#define WM_TASKBARACTION	WM_USER+1



/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_WM_SIZE()
	ON_COMMAND(ID_SETTINGS, OnSettings)
	ON_WM_GETMINMAXINFO()
	ON_WM_SIZING()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
}

CMainFrame::~CMainFrame()
{
}


int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	if (!m_wndToolBar.Create(this) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);

	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);




	NOTIFYICONDATA	tbIcon;

	tbIcon.cbSize	= sizeof(NOTIFYICONDATA);
	tbIcon.hWnd		= ((CWnd *)this)->m_hWnd;
	tbIcon.uID		= 0;
	tbIcon.uFlags	= NIF_ICON | NIF_MESSAGE | NIF_TIP;

	tbIcon.uCallbackMessage = WM_TASKBARACTION;

	tbIcon.hIcon = theApp.m_iconTaskbar;

	CString	cstrTip;
	cstrTip.LoadString( IDS_ICONTIP );
	strcpy( (char *)tbIcon.szTip , (LPCTSTR)cstrTip );

	Shell_NotifyIcon(NIM_ADD, &tbIcon); 

	return 0;
}




BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	cs.hwndParent = theApp.m_wndInvisibleParent.m_hWnd;
	return CFrameWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

void CMainFrame::OnSettings() 
{
	CDlgSettings	dlgSettings;

	if( dlgSettings.DoModal() == IDOK )
	{
		theApp.WriteProfileString( "Settings", "DiskPath", (theApp.m_cstrDiskFileDirectory= dlgSettings.m_cstrDiskFileDirectory)); 
	}
}





LRESULT CMainFrame::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	if( message == WM_TASKBARACTION )
	{
		if( lParam == WM_LBUTTONDBLCLK )
		{
			CRect	rectTemp;

			ActivateFrame();
			SetForegroundWindow();	// beat on the window until it pops up

			GetWindowRect(rectTemp);
			rectTemp.right++;
			MoveWindow(rectTemp);
		}

		return TRUE;
	}

	return CFrameWnd::WindowProc(message, wParam, lParam);
}





void CMainFrame::OnDestroy() 
{
    NOTIFYICONDATA tnid; 
 
    tnid.cbSize = sizeof(NOTIFYICONDATA); 
    tnid.hWnd = ((CWnd *)this)->m_hWnd; 
    tnid.uID = 0; 
         
    Shell_NotifyIcon(NIM_DELETE, &tnid); 

	CFrameWnd::OnDestroy();
}





void CMainFrame::CookWindowSize( CRect &winSize )
{
	CRect	rectWin;
	
	winSize = CRect(0,0, m_rectWindowSize.Width(), m_rectWindowSize.Height() );

	GetWindowRect( rectWin );

	if( rectWin.Height() < winSize.Height() )
		winSize.right = winSize.left + winSize.Width() + m_vscrollWidth;

	return;
}







void CMainFrame::OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI) 
{
	CAtariServerView	*cv;

	CFrameWnd::OnGetMinMaxInfo(lpMMI);

	if( (cv= (CAtariServerView *)GetActiveView()) != NULL )
	{
		CAtariServerDoc	 *pDoc = cv->GetMyDocument();

		if( pDoc->m_listDeviceSets.GetCount() )
		{
			CRect	winSize;

			CookWindowSize(winSize);

			lpMMI->ptMaxSize.x = lpMMI->ptMinTrackSize.x = lpMMI->ptMaxTrackSize.x = winSize.Width();
			lpMMI->ptMaxSize.y = lpMMI->ptMaxTrackSize.y = winSize.Height();
		}
	}
}





void CMainFrame::OnSize(UINT nType, int cx, int cy) 
{
	if( nType==SIZE_MINIMIZED )
		ShowWindow( SW_HIDE );
	else
		CFrameWnd::OnSize(nType, cx, cy);
}



void CMainFrame::OnSizing(UINT fwSide, LPRECT pRect) 
{
	CAtariServerView	*cv;

	CFrameWnd::OnSizing(fwSide, pRect);

	if( (cv= (CAtariServerView *)GetActiveView()) != NULL )
	{
		CAtariServerDoc	 *pDoc = cv->GetMyDocument();

		if( pDoc->m_listDeviceSets.GetCount() )
		{
			CRect	winSize;

			CookWindowSize(winSize);

			pRect->right = pRect->left + winSize.Width();
		}
	}
}

