// PortWindow.cpp : implementation file
//

#include "stdafx.h"
#include "common.h"

#include "DlgSelectDisk.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPortWindow dialog



CPortWindow::CPortWindow(CWnd* pParent /*=NULL*/)
	: CDialog(CPortWindow::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPortWindow)
	//}}AFX_DATA_INIT

	isSettingControls = FALSE;

	m_devSet = NULL;
	m_parentView = NULL;

	m_disablechkWriteProt1 = m_disablechkWriteProt2 = FALSE;
	m_disablechkWriteProt3 = m_disablechkWriteProt4 = FALSE;
}






void CPortWindow::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPortWindow)
	DDX_Control(pDX, IDC_CMD_CHANGER4, m_cmdAction4);
	DDX_Control(pDX, IDC_CMD_CHANGER3, m_cmdAction3);
	DDX_Control(pDX, IDC_CMD_CHANGER2, m_cmdAction2);
	DDX_Control(pDX, IDC_CMD_CHANGER, m_cmdAction1);
	DDX_Control(pDX, IDC_STATIC_IOSTATS, m_staticIOStats);
	DDX_Control(pDX, IDC_CHK_WRITEPROT4, m_chkWriteProt4);
	DDX_Control(pDX, IDC_CHK_WRITEPROT3, m_chkWriteProt3);
	DDX_Control(pDX, IDC_CHK_WRITEPROT2, m_chkWriteProt2);
	DDX_Control(pDX, IDC_CHK_WRITEPROT1, m_chkWriteProt1);
	DDX_Control(pDX, IDC_STATIC_DRIVENUM4, m_staticDriveNum4);
	DDX_Control(pDX, IDC_STATIC_DRIVENUM3, m_staticDriveNum3);
	DDX_Control(pDX, IDC_STATIC_DRIVENUM2, m_staticDriveNum2);
	DDX_Control(pDX, IDC_STATIC_DRIVENUM1, m_staticDriveNum1);
	DDX_Control(pDX, IDC_DRVSTATS4, m_staticDriveStat4);
	DDX_Control(pDX, IDC_TXT_PORTDESCRIPTION, m_txtPortDescription);
	DDX_Control(pDX, IDC_PORTNAME, m_staticPortName);
	DDX_Control(pDX, IDC_DRVTYPE4, m_staticDriveType4);
	DDX_Control(pDX, IDC_DRVTYPE3, m_staticDriveType3);
	DDX_Control(pDX, IDC_DRVTYPE2, m_staticDriveType2);
	DDX_Control(pDX, IDC_DRVTYPE, m_staticDriveType1);
	DDX_Control(pDX, IDC_DRVSTATS3, m_staticDriveStat3);
	DDX_Control(pDX, IDC_DRVSTATS2, m_staticDriveStat2);
	DDX_Control(pDX, IDC_DRVSTATS, m_staticDriveStat1);
	DDX_Control(pDX, IDC_TXT_DRVDESCRIPTION4, m_txtDriveDesc4);
	DDX_Control(pDX, IDC_TXT_DRVDESCRIPTION3, m_txtDriveDesc3);
	DDX_Control(pDX, IDC_TXT_DRVDESCRIPTION2, m_txtDriveDesc2);
	DDX_Control(pDX, IDC_TXT_DRVDESCRIPTION, m_txtDriveDesc1);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPortWindow, CDialog)
	//{{AFX_MSG_MAP(CPortWindow)
	ON_EN_CHANGE(IDC_TXT_DRVDESCRIPTION, OnChangeTxtDrvdescription)
	ON_EN_CHANGE(IDC_TXT_DRVDESCRIPTION2, OnChangeTxtDrvdescription2)
	ON_EN_CHANGE(IDC_TXT_DRVDESCRIPTION3, OnChangeTxtDrvdescription3)
	ON_EN_CHANGE(IDC_TXT_DRVDESCRIPTION4, OnChangeTxtDrvdescription4)
	ON_BN_CLICKED(IDC_CHK_WRITEPROT1, OnChkWriteprot1)
	ON_BN_CLICKED(IDC_CHK_WRITEPROT2, OnChkWriteprot2)
	ON_BN_CLICKED(IDC_CHK_WRITEPROT3, OnChkWriteprot3)
	ON_BN_CLICKED(IDC_CHK_WRITEPROT4, OnChkWriteprot4)
	ON_BN_CLICKED(IDC_CMD_CLOSEPORT, OnCmdCloseport)
	ON_EN_CHANGE(IDC_TXT_PORTDESCRIPTION, OnChangeTxtPortdescription)
	ON_BN_CLICKED(IDC_CMD_CHANGER, OnCmdChanger)
	ON_BN_CLICKED(IDC_CMD_CHANGER2, OnCmdChanger2)
	ON_BN_CLICKED(IDC_CMD_CHANGER3, OnCmdChanger3)
	ON_BN_CLICKED(IDC_CMD_CHANGER4, OnCmdChanger4)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPortWindow message handlers

BOOL CPortWindow::OnInitDialog() 
{
	isSettingControls = TRUE;

	CDialog::OnInitDialog();

	ASSERT( m_parentView );
	ASSERT( m_devSet );
	ASSERT( m_devSet->m_portWindow );
	
	m_staticPortName.SetWindowText( m_devSet->GetPortName() );
	m_txtPortDescription.SetWindowText( m_devSet->GetDescription() );

	CString	cstr;
	cstr.LoadString( IDS_MSG_MOUNT );

	m_cmdAction1.SetWindowText( cstr );
	m_txtDriveDesc1.EnableWindow(FALSE);
	m_chkWriteProt1.EnableWindow(FALSE);

	m_cmdAction2.SetWindowText( cstr );
	m_txtDriveDesc2.EnableWindow(FALSE);
	m_chkWriteProt2.EnableWindow(FALSE);

	m_cmdAction3.SetWindowText( cstr );
	m_txtDriveDesc3.EnableWindow(FALSE);
	m_chkWriteProt3.EnableWindow(FALSE);

	m_cmdAction4.SetWindowText( cstr );
	m_txtDriveDesc4.EnableWindow(FALSE);
	m_chkWriteProt4.EnableWindow(FALSE);

	UpdateWindow();
	isSettingControls = FALSE;

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}







CPortWindow::~CPortWindow()
{
	if( m_devSet )
	{
		m_devSet->m_portWindow = NULL;
		delete m_devSet;
	}
	return;
}






void CPortWindow::OnCmdCloseport() 
{
	EnableWindow(FALSE);

	m_parentView->PostMessage( WM_CLOSEPORTWIN, 0, (LPARAM)this );
}





void CPortWindow::TimerTick( BOOL updateStats )
{
	if( m_disablechkWriteProt1 ) { m_disablechkWriteProt1 = FALSE; m_chkWriteProt1.EnableWindow(FALSE); }
	if( m_disablechkWriteProt2 ) { m_disablechkWriteProt2 = FALSE; m_chkWriteProt2.EnableWindow(FALSE); }
	if( m_disablechkWriteProt3 ) { m_disablechkWriteProt3 = FALSE; m_chkWriteProt3.EnableWindow(FALSE); }
	if( m_disablechkWriteProt4 ) { m_disablechkWriteProt4 = FALSE; m_chkWriteProt4.EnableWindow(FALSE); }
	

	if( updateStats ) m_devSet->UpdateStats();
}








void CPortWindow::OnCmdChanger() 
{
	HitCmdChanger(1);
}
void CPortWindow::OnCmdChanger2() 
{
	HitCmdChanger(2);
}
void CPortWindow::OnCmdChanger3() 
{
	HitCmdChanger(3);
}
void CPortWindow::OnCmdChanger4() 
{
	HitCmdChanger(4);
}

void CPortWindow::HitCmdChanger( int nDiskNum )
{
	CDiskDevice	*cdd = m_devSet->GetDiskDevice(nDiskNum);

	if( cdd )
	{
		if( AfxMessageBox( IDS_MSG_ASKDISMOUNT, MB_YESNO ) == IDYES )
		{
			cdd->scrCtlClear();
			m_devSet->diskDismount( nDiskNum );
		}
	}
	else
	{
		CDlgSelectDisk		dlgSelect;

		if( dlgSelect.DoModal() == IDOK )
		{
			CDiskData *diskData = dlgSelect.m_cstrSelectedDisk;

			m_devSet->diskMount( nDiskNum, diskData );

			AttachDiskDeviceToControls(nDiskNum);
		}
	}
}










void CPortWindow::OnChkWriteprot1() 
{
	HitWriteProt(1, &m_chkWriteProt1);
}

void CPortWindow::OnChkWriteprot2() 
{
	HitWriteProt(2, &m_chkWriteProt2);
}

void CPortWindow::OnChkWriteprot3() 
{
	HitWriteProt(3, &m_chkWriteProt3);
}

void CPortWindow::OnChkWriteprot4() 
{
	HitWriteProt(4, &m_chkWriteProt4);
}


void CPortWindow::HitWriteProt( int nDiskNum, CButton *chkbox )
{
	CDiskDevice	*cdd = m_devSet->GetDiskDevice( nDiskNum );

	if( chkbox->GetCheck() == 0 )
	{
		cdd->diskSetWriteProtect(FALSE);
		cdd->RefreshControls();
	}
	else if( chkbox->GetCheck() == 1 )
	{
		cdd->diskSetWriteProtect(TRUE);
		cdd->RefreshControls();
	}
}











void CPortWindow::OnChangeTxtDrvdescription() 
{
	HitDescriptionChange(1, &m_txtDriveDesc1);
}

void CPortWindow::OnChangeTxtDrvdescription2() 
{
	HitDescriptionChange(2, &m_txtDriveDesc2);
}

void CPortWindow::OnChangeTxtDrvdescription3() 
{
	HitDescriptionChange(3, &m_txtDriveDesc3);
}

void CPortWindow::OnChangeTxtDrvdescription4() 
{
	HitDescriptionChange(4, &m_txtDriveDesc4);
}

void CPortWindow::HitDescriptionChange( int nDiskNum, CEdit *editbox )
{
	CDiskDevice	*cdd = m_devSet->GetDiskDevice( nDiskNum );

	if( cdd )
	{
		CString	cstr;

		editbox->GetWindowText(cstr);

		cdd->diskSetNewDesc(cstr);
	}
}







void CPortWindow::OnChangeTxtPortdescription() 
{
	if( !isSettingControls )
	{
		CString		cstr;

		m_txtPortDescription.GetWindowText( cstr );
		m_devSet->SetDescription(cstr);

		CAtariServerDoc	*pDoc = m_parentView->GetMyDocument();
		pDoc->SetModifiedFlag(TRUE);
	}
}





void CPortWindow::AttachDiskDeviceToControls( int nDiskNum )
{
	ASSERT( nDiskNum>=1 && nDiskNum<=4 );

	CDiskDevice		*cdd = (CDiskDevice *)m_devSet->GetDiskDevice(nDiskNum);

	if( cdd ) cdd->scrCtlSet( this );
	return;
}



void CPortWindow::OnCancel() 
{
}
