;;;Stub loader for cartridges
;;;Inspired by filed cart images
;;;Assembles using XA65 by Andre Fachat
;;;If CART8 is set, makes loader for 8KB carts, 16KB otherwise
;;;
;;;Jindrich Kubec <kubecj@asw.cz>
;;;http://www.asw.cz/~kubecj

CASINI = $02
BOOT = $09
RAMTOP = $6A

#ifdef CART8
CART_START = $A0
#else
CART_START = $80
#endif

MAIN_START	= $0600
STK_START	= $0100

		.WORD $FFFF

	* = MAIN_START - 4

		.WORD MAIN_START
		.WORD MAIN_END - 1

		;set RAMTOP
		LDA	RAMTOP		
		CMP	#(CART_START - $10)
		BCC	DONT_CHANGE			
		LDA	#(CART_START - $10)
		STA	RAMTOP		
		JSR	$F3F6			

DONT_CHANGE:
		;set PTRs
		LDA	#$00			
		STA	CASINI		
		LDA	#CART_START
		STA	CASINI+1	

		LDA	#$03			
		STA	BOOT		
		JMP	STK_START
MAIN_END:

	* = STK_START - 4
		.WORD	STK_START
		.WORD	STK_END - 1

		;clean up the memory. Must be in stack, because all of memory
		;must be cleaned
LP2:		LDA	#$00
		TAX
LP1:		STA	$0400,X
		INX
		BNE	LP1
		INC	LP1 + 2
		LDA	#CART_START
		CMP	LP1 + 2
		BNE	LP2

		;and do init now
		JSR	DO_CART_INIT			
		JMP	($BFFA)			
DO_CART_INIT:	JMP	($BFFE)			

STK_END:
		;start
		.WORD $02E0
		.WORD $02E1
		.WORD MAIN_START

		;for next block
		.BYTE $00
		.BYTE CART_START
		.WORD $BFFF
