/*
 *************************************************************************
 *
 *  a2ibm.c -- convert from ATASCII to ASCII, with IBM-PC graphics
 *
 *  by Bob Hardy, Feb. 1993
 *
 **************************************************************************
 */

/*
     Mat*Rat brought many useful and interesting programs to Atari BASIC,
     and he also wrote some simple C programs for text processing, to convert
     from/to the Atari EOL character to/from the IBM-PC CR/LF combination, in
     the tradition of UNIX2DOS/DOS2UNIX.  While this code doesn't borrow much
     from Mat*Rat, we take this opportunity to thank him for the good stuff
     he brought us, particularly in the early '80's, and to admit that while
     this program is more elaborate than his comparable programs, he was here
     first.  Thanks Matt, and long may you Rat!
 */      

/*
     This program made necessary some unusual design decisions.  They
     revolved around how to deal with the fact that ATASCII has character
     "box" graphics, but has no double-line box characters, like the
     IBM-PC character set.  In the end, I took the only reasonable course
     that occurred to me -- since the PC has no inverse video box chars,
     let's swap inverse video chars for double-line box chars!
 */

#include <stdio.h>

int main (int argc, char **argv[])
{
  FILE *infile, *outfile;
  int c;

  puts("A2IBM - Convert ATASCII to ASCII, with IBM-PC Graphics");
  puts("by Bob Hardy, with acknowledgements to Mat*Rat\n");

  if (argc < 3) {
    printf("Usage: %s infile outfile\n", argv[0]);
    exit(1);
  }
  if ((infile=fopen(argv[1], "rb")) == NULL) {
    printf("%s: Could not open %s for read.\n", argv[0], argv[1]);
    exit(1);
  }
  if ((outfile=fopen(argv[2], "wb")) == NULL) {
    printf("%s: Could not open %s for write.\n", argv[0], argv[2]);
    exit(1);
  }
  printf("Converting %s...\n", argv[1]);
    while ((c=getc(infile)) != EOF) {
    switch(c) {
      case '\0'  : putc('\3', outfile); /* heart */
                   break;
      case '\1'  : putc('\303', outfile); /* left T-junction */
                   break;
      case '\2'  : putc('\336', outfile); /* right vertical bar */
                   break;
      case '\3'  : putc('\331', outfile); /* lower right box char */
                   break;
      case '\4'  : putc('\264', outfile); /* right T-junction char */
                   break;
      case '\5'  : putc('\277', outfile); /* upper right box char */
                   break;
      case '\15' : putc('\337', outfile); /* horizontal bar */
                   break;
      case '\16' : putc('\334', outfile); /* low horizontal bar */
                   break;
      case '\20' : putc('\5', outfile); /* club */
                   break;
      case '\21' : putc('\332', outfile); /* upper left box char */
                   break;
      case '\22' : putc('\304', outfile); /* horizontal line */
                   break;
      case '\23' : putc('\305', outfile); /* 4-way junction char */
                   break;
      case '\24' : putc('\7', outfile); /* dot */
                   break;
      case '\26' : putc('\335', outfile); /* left vertical bar */
                   break;
      case '\27' : putc('\302', outfile); /* vertical T-junction */
                   break;
      case '\30' : putc('\301', outfile); /* inverted T-junction */
                   break;
      case '\32' : putc('\300', outfile); /* lower left box char */
                   break;
      case '\140': putc('\4', outfile); /* diamond */
                   break;
      case '\157': putc('\t', outfile); /* tab */
                   break;
      case '\173': putc('\173', outfile); /* spade */
                   break;
      case '\201': putc('\314', outfile); /* inverse left T-junction */
                   break;
      case '\203': putc('\274', outfile); /* inverse lower right box */
                   break;
      case '\204': putc('\271', outfile); /* inverse right T-junction */
                   break;
      case '\205': putc('\273', outfile); /* inverse upper right box */
                   break;
      case '\221': putc('\311', outfile); /* inverse upper left box */
                   break;
      case '\222': putc('\315', outfile); /* inverse horizontal line */
                   break;
      case '\223': putc('\316', outfile); /* inverse 4-way junction */
                   break;
      case '\224': putc('\10', outfile); /* inverse dot */
                   break;
      case '\227': putc('\313', outfile); /* inverse vertical T-junction */
                   break;
      case '\230': putc('\312', outfile); /* inverse inverted T-junction */
                   break;
      case '\232': putc('\310', outfile); /* inverse lower left box */
                   break;
      case '\233': putc('\r', outfile); /* EOL -- use CR/LF combination */
                   putc('\n', outfile);
                   break;
      case '\263': putc('\174', outfile); /* vertical line (use pipe) */
                   break;
      case '\374': putc('\272', outfile); /* inverse vertical line */
                   break;
      default    : if (c > 127) c=(c - 128); /* un-invert other chars */
                   putc(c, outfile);
                   break;
     }
   }
   fclose(outfile);
   printf("%s: End-of-file encountered.\n", argv[1]);
   exit(0);
}

/*

The mapping for conversion has been necessarily simplified.
IBM graphics feature double-line box characters; ATASCII features
inverse box characters instead.  Since we are going from ATASCII
to IBM, we don't have to worry about deciding when to use double
lines in a mixed graphic (partly single and partly double lines)
as we might have to do going from IBM to ATASCII.  Inverse box
characters are rendered as double, and non-inverse are single.

A few thorny issues have been sidestepped, as what to do in ticklish
cases like thick lower block, which IBM doesn't have, or arrows, which
the Atari is likely to interpret as directives rather than literal
graphics characters.  The PC graphics character for a vertical line
is not used, because Atari has none, and uses the pipe character.
Since the pipe character may be needed as itself (as in C code!), no
conversion is done on it.

*/
