	Page	58,132
	Title	DATA.ASM	Emulator (65C02 Processor)
;******************************************************************************
;
;   Name:	DATA.ASM	Emulator (65C02 Processor)
;
;   Group:	Emulator
;
;   Revision:	1.00
;
;   Date:	January 30, 1988
;
;   Author:	Randy W. Spurlock (modifeid for atari by Michael Munoz)
;
;******************************************************************************
;
;  Module Functional Description:
;
;		This module contains some of the data areas for the
;	Atari emulator. (All data is in the code segment)
;
;******************************************************************************
;
;  Changes:
;
;    DATE     REVISION				DESCRIPTION
;  --------   --------	-------------------------------------------------------
;   1/30/88	1.00	Original
;
;******************************************************************************
	Page
;
;  Public Declarations
;
	Public	Error_Table		; Error string table
	Public	Flag_Encode		; CPU flag encoding table
	Public	Flag_Decode		; CPU flag decoding table
	Public	System_ROM		; Atari system ROM data file name
	Public	Emulate_Flag		; Emulator system flag byte
	Public	System_Flag		; Apple system flag byte
	Public	Original_Int_3		; Original interrupt 3 vector storage
	Public	Original_Int_8		; Original interrupt 8 vector storage
	Public	Original_Int_9		; Original interrupt 9 vector storage
	Public	RAM_Space		; RAM space segment value
	Public	ALT_Space		; Alternate RAM space segment value
	Public	Video_Segment		; Video segment value

;  External Declarations
;
	Extrn	STD_Mem_Read:Near	; Standard memory read routine (MEMORY)
	Extrn	STD_Mem_Write:Near	; Standard memory write routine(MEMORY)
	Extrn	ROM_Mem_Read:Near	; ROM memory read routine      (MEMORY)
	Extrn	ROM_Mem_Write:Near	; ROM memory write routine     (MEMORY)
	Page
;
;  Define any include files needed
;
	Include 	Macros.inc	; Include the macro definitions
	Include 	Equates.inc	; Include the equate definitions
	Include 	Strucs.inc	; Include the structure definitions

	.286c				; Include 80286 instructions
	Page
;
;  Define the emulator code segment
;
Emulate Segment Word Public 'EMULATE'   ; Emulator code segment
	Assume	cs:Emulate, ds:Nothing, es:Nothing

;******************************************************************************
;
;	Define the Error Strings and Error Table
;
;******************************************************************************
_Err_Cnt	=	0		; Start error code number at zero
		Err_Str NO_MEMORY,<"Not enough memory for emulator">
		Err_Str NO_SYSTEM_FILE,<"Missing system ROM file">
		Err_Str BAD_SYSTEM_FILE,<"Bad system ROM file">
		Err_Str BAD_SYSTEM_IMAGE,<"Bad system ROM image">
		Err_Str BAD_ADAPTER,<"Color graphics adapter required">
		Err_Str CONFIG_FILE,<"Configuration file error">
		Err_Str PLACE_ERROR,<"Parameter outside of section error">
		Err_Str SECTION_ERROR,<"Invalid section error">
		Err_Str PARAMETER_ERROR,<"Invalid parameter error">
		Err_Str ASSIGN_ERROR,<"Parameter assignment error">
		Err_Str NO_PARAMETER,<"No parameters allowed">
		Err_Str CPU_TYPE,<"Invalid CPU type value">
		Err_Str CPU_MODE,<"Invalid CPU mode value">
		Err_Str DEVICE_TYPE,<"Invalid device type">
		Err_Str TYPE_ERROR,<"Slot type must be defined">
		Err_Str SLOT_ERROR,<"Invalid slot number">
		Err_Str FILE_ERROR,<"Missing file name">
		Err_Str NO_FLOPPY_FILE,<"Missing floppy controller ROM file">
		Err_Str BAD_FLOPPY_FILE,<"Bad floppy controller ROM file">
		Err_Str BAD_FLOPPY_IMAGE,<"Bad floppy controller ROM image">
		Err_Str NO_SERIAL_FILE,<"Missing serial controller ROM file">
		Err_Str BAD_SERIAL_FILE,<"Bad serial controller ROM file">
		Err_Str BAD_SERIAL_IMAGE,<"Bad serial controller ROM image">
		Err_Str NO_SERIAL_PORT,<"No serial port present">
		Err_Str SERIAL_PORT,<"Invalid serial port value">
		Err_Str BAUD_RATE,<"Invalid serial baud rate value">
		Err_Str STOP_BITS,<"Invalid serial stop bits value">
		Err_Str DATA_LENGTH,<"Invalid serial data length value">
		Err_Str PARITY,<"Invalid parity value">
		Err_Str PULLUP,<"Invalid pullup signal value">
		Err_Str COLOR,<"Illegal color value">
		Err_Str SCHEME,<"Bad or missing color scheme file">
		Err_Tbl 		; Generate the error code table

;******************************************************************************
;
;	Define the Flag Encoding Table
;
;******************************************************************************
		Even			; Force table to even address
Flag_Encode	Equ	This Byte	; CPU flag encoding table
		Encode	<00000000b>	; Flag value 00000000b encoded
		Encode	<00000001b>	; Flag value 00000001b encoded
		Encode	<00000010b>	; Flag value 00000010b encoded
		Encode	<00000011b>	; Flag value 00000011b encoded
		Encode	<00000100b>	; Flag value 00000100b encoded
		Encode	<00000101b>	; Flag value 00000101b encoded
		Encode	<00000110b>	; Flag value 00000110b encoded
		Encode	<00000111b>	; Flag value 00000111b encoded
		Encode	<00001000b>	; Flag value 00001000b encoded
		Encode	<00001001b>	; Flag value 00001001b encoded
		Encode	<00001010b>	; Flag value 00001010b encoded
		Encode	<00001011b>	; Flag value 00001011b encoded
		Encode	<00001100b>	; Flag value 00001100b encoded
		Encode	<00001101b>	; Flag value 00001101b encoded
		Encode	<00001110b>	; Flag value 00001110b encoded
		Encode	<00001111b>	; Flag value 00001111b encoded
		Encode	<00010000b>	; Flag value 00010000b encoded
		Encode	<00010001b>	; Flag value 00010001b encoded
		Encode	<00010010b>	; Flag value 00010010b encoded
		Encode	<00010011b>	; Flag value 00010011b encoded
		Encode	<00010100b>	; Flag value 00010100b encoded
		Encode	<00010101b>	; Flag value 00010101b encoded
		Encode	<00010110b>	; Flag value 00010110b encoded
		Encode	<00010111b>	; Flag value 00010111b encoded
		Encode	<00011000b>	; Flag value 00011000b encoded
		Encode	<00011001b>	; Flag value 00011001b encoded
		Encode	<00011010b>	; Flag value 00011010b encoded
		Encode	<00011011b>	; Flag value 00011011b encoded
		Encode	<00011100b>	; Flag value 00011100b encoded
		Encode	<00011101b>	; Flag value 00011101b encoded
		Encode	<00011110b>	; Flag value 00011110b encoded
		Encode	<00011111b>	; Flag value 00011111b encoded
		Encode	<00100000b>	; Flag value 00100000b encoded
		Encode	<00100001b>	; Flag value 00100001b encoded
		Encode	<00100010b>	; Flag value 00100010b encoded
		Encode	<00100011b>	; Flag value 00100011b encoded
		Encode	<00100100b>	; Flag value 00100100b encoded
		Encode	<00100101b>	; Flag value 00100101b encoded
		Encode	<00100110b>	; Flag value 00100110b encoded
		Encode	<00100111b>	; Flag value 00100111b encoded
		Encode	<00101000b>	; Flag value 00101000b encoded
		Encode	<00101001b>	; Flag value 00101001b encoded
		Encode	<00101010b>	; Flag value 00101010b encoded
		Encode	<00101011b>	; Flag value 00101011b encoded
		Encode	<00101100b>	; Flag value 00101100b encoded
		Encode	<00101101b>	; Flag value 00101101b encoded
		Encode	<00101110b>	; Flag value 00101110b encoded
		Encode	<00101111b>	; Flag value 00101111b encoded
		Encode	<00110000b>	; Flag value 00110000b encoded
		Encode	<00110001b>	; Flag value 00110001b encoded
		Encode	<00110010b>	; Flag value 00110010b encoded
		Encode	<00110011b>	; Flag value 00110011b encoded
		Encode	<00110100b>	; Flag value 00110100b encoded
		Encode	<00110101b>	; Flag value 00110101b encoded
		Encode	<00110110b>	; Flag value 00110110b encoded
		Encode	<00110111b>	; Flag value 00110111b encoded
		Encode	<00111000b>	; Flag value 00111000b encoded
		Encode	<00111001b>	; Flag value 00111001b encoded
		Encode	<00111010b>	; Flag value 00111010b encoded
		Encode	<00111011b>	; Flag value 00111011b encoded
		Encode	<00111100b>	; Flag value 00111100b encoded
		Encode	<00111101b>	; Flag value 00111101b encoded
		Encode	<00111110b>	; Flag value 00111110b encoded
		Encode	<00111111b>	; Flag value 00111111b encoded
		Encode	<01000000b>	; Flag value 01000000b encoded
		Encode	<01000001b>	; Flag value 01000001b encoded
		Encode	<01000010b>	; Flag value 01000010b encoded
		Encode	<01000011b>	; Flag value 01000011b encoded
		Encode	<01000100b>	; Flag value 01000100b encoded
		Encode	<01000101b>	; Flag value 01000101b encoded
		Encode	<01000110b>	; Flag value 01000110b encoded
		Encode	<01000111b>	; Flag value 01000111b encoded
		Encode	<01001000b>	; Flag value 01001000b encoded
		Encode	<01001001b>	; Flag value 01001001b encoded
		Encode	<01001010b>	; Flag value 01001010b encoded
		Encode	<01001011b>	; Flag value 01001011b encoded
		Encode	<01001100b>	; Flag value 01001100b encoded
		Encode	<01001101b>	; Flag value 01001101b encoded
		Encode	<01001110b>	; Flag value 01001110b encoded
		Encode	<01001111b>	; Flag value 01001111b encoded
		Encode	<01010000b>	; Flag value 01010000b encoded
		Encode	<01010001b>	; Flag value 01010001b encoded
		Encode	<01010010b>	; Flag value 01010010b encoded
		Encode	<01010011b>	; Flag value 01010011b encoded
		Encode	<01010100b>	; Flag value 01010100b encoded
		Encode	<01010101b>	; Flag value 01010101b encoded
		Encode	<01010110b>	; Flag value 01010110b encoded
		Encode	<01010111b>	; Flag value 01010111b encoded
		Encode	<01011000b>	; Flag value 01011000b encoded
		Encode	<01011001b>	; Flag value 01011001b encoded
		Encode	<01011010b>	; Flag value 01011010b encoded
		Encode	<01011011b>	; Flag value 01011011b encoded
		Encode	<01011100b>	; Flag value 01011100b encoded
		Encode	<01011101b>	; Flag value 01011101b encoded
		Encode	<01011110b>	; Flag value 01011110b encoded
		Encode	<01011111b>	; Flag value 01011111b encoded
		Encode	<01100000b>	; Flag value 01100000b encoded
		Encode	<01100001b>	; Flag value 01100001b encoded
		Encode	<01100010b>	; Flag value 01100010b encoded
		Encode	<01100011b>	; Flag value 01100011b encoded
		Encode	<01100100b>	; Flag value 01100100b encoded
		Encode	<01100101b>	; Flag value 01100101b encoded
		Encode	<01100110b>	; Flag value 01100110b encoded
		Encode	<01100111b>	; Flag value 01100111b encoded
		Encode	<01101000b>	; Flag value 01101000b encoded
		Encode	<01101001b>	; Flag value 01101001b encoded
		Encode	<01101010b>	; Flag value 01101010b encoded
		Encode	<01101011b>	; Flag value 01101011b encoded
		Encode	<01101100b>	; Flag value 01101100b encoded
		Encode	<01101101b>	; Flag value 01101101b encoded
		Encode	<01101110b>	; Flag value 01101110b encoded
		Encode	<01101111b>	; Flag value 01101111b encoded
		Encode	<01110000b>	; Flag value 01110000b encoded
		Encode	<01110001b>	; Flag value 01110001b encoded
		Encode	<01110010b>	; Flag value 01110010b encoded
		Encode	<01110011b>	; Flag value 01110011b encoded
		Encode	<01110100b>	; Flag value 01110100b encoded
		Encode	<01110101b>	; Flag value 01110101b encoded
		Encode	<01110110b>	; Flag value 01110110b encoded
		Encode	<01110111b>	; Flag value 01110111b encoded
		Encode	<01111000b>	; Flag value 01111000b encoded
		Encode	<01111001b>	; Flag value 01111001b encoded
		Encode	<01111010b>	; Flag value 01111010b encoded
		Encode	<01111011b>	; Flag value 01111011b encoded
		Encode	<01111100b>	; Flag value 01111100b encoded
		Encode	<01111101b>	; Flag value 01111101b encoded
		Encode	<01111110b>	; Flag value 01111110b encoded
		Encode	<01111111b>	; Flag value 01111111b encoded
		Encode	<10000000b>	; Flag value 10000000b encoded
		Encode	<10000001b>	; Flag value 10000001b encoded
		Encode	<10000010b>	; Flag value 10000010b encoded
		Encode	<10000011b>	; Flag value 10000011b encoded
		Encode	<10000100b>	; Flag value 10000100b encoded
		Encode	<10000101b>	; Flag value 10000101b encoded
		Encode	<10000110b>	; Flag value 10000110b encoded
		Encode	<10000111b>	; Flag value 10000111b encoded
		Encode	<10001000b>	; Flag value 10001000b encoded
		Encode	<10001001b>	; Flag value 10001001b encoded
		Encode	<10001010b>	; Flag value 10001010b encoded
		Encode	<10001011b>	; Flag value 10001011b encoded
		Encode	<10001100b>	; Flag value 10001100b encoded
		Encode	<10001101b>	; Flag value 10001101b encoded
		Encode	<10001110b>	; Flag value 10001110b encoded
		Encode	<10001111b>	; Flag value 10001111b encoded
		Encode	<10010000b>	; Flag value 10010000b encoded
		Encode	<10010001b>	; Flag value 10010001b encoded
		Encode	<10010010b>	; Flag value 10010010b encoded
		Encode	<10010011b>	; Flag value 10010011b encoded
		Encode	<10010100b>	; Flag value 10010100b encoded
		Encode	<10010101b>	; Flag value 10010101b encoded
		Encode	<10010110b>	; Flag value 10010110b encoded
		Encode	<10010111b>	; Flag value 10010111b encoded
		Encode	<10011000b>	; Flag value 10011000b encoded
		Encode	<10011001b>	; Flag value 10011001b encoded
		Encode	<10011010b>	; Flag value 10011010b encoded
		Encode	<10011011b>	; Flag value 10011011b encoded
		Encode	<10011100b>	; Flag value 10011100b encoded
		Encode	<10011101b>	; Flag value 10011101b encoded
		Encode	<10011110b>	; Flag value 10011110b encoded
		Encode	<10011111b>	; Flag value 10011111b encoded
		Encode	<10100000b>	; Flag value 10100000b encoded
		Encode	<10100001b>	; Flag value 10100001b encoded
		Encode	<10100010b>	; Flag value 10100010b encoded
		Encode	<10100011b>	; Flag value 10100011b encoded
		Encode	<10100100b>	; Flag value 10100100b encoded
		Encode	<10100101b>	; Flag value 10100101b encoded
		Encode	<10100110b>	; Flag value 10100110b encoded
		Encode	<10100111b>	; Flag value 10100111b encoded
		Encode	<10101000b>	; Flag value 10101000b encoded
		Encode	<10101001b>	; Flag value 10101001b encoded
		Encode	<10101010b>	; Flag value 10101010b encoded
		Encode	<10101011b>	; Flag value 10101011b encoded
		Encode	<10101100b>	; Flag value 10101100b encoded
		Encode	<10101101b>	; Flag value 10101101b encoded
		Encode	<10101110b>	; Flag value 10101110b encoded
		Encode	<10101111b>	; Flag value 10101111b encoded
		Encode	<10110000b>	; Flag value 10110000b encoded
		Encode	<10110001b>	; Flag value 10110001b encoded
		Encode	<10110010b>	; Flag value 10110010b encoded
		Encode	<10110011b>	; Flag value 10110011b encoded
		Encode	<10110100b>	; Flag value 10110100b encoded
		Encode	<10110101b>	; Flag value 10110101b encoded
		Encode	<10110110b>	; Flag value 10110110b encoded
		Encode	<10110111b>	; Flag value 10110111b encoded
		Encode	<10111000b>	; Flag value 10111000b encoded
		Encode	<10111001b>	; Flag value 10111001b encoded
		Encode	<10111010b>	; Flag value 10111010b encoded
		Encode	<10111011b>	; Flag value 10111011b encoded
		Encode	<10111100b>	; Flag value 10111100b encoded
		Encode	<10111101b>	; Flag value 10111101b encoded
		Encode	<10111110b>	; Flag value 10111110b encoded
		Encode	<10111111b>	; Flag value 10111111b encoded
		Encode	<11000000b>	; Flag value 11000000b encoded
		Encode	<11000001b>	; Flag value 11000001b encoded
		Encode	<11000010b>	; Flag value 11000010b encoded
		Encode	<11000011b>	; Flag value 11000011b encoded
		Encode	<11000100b>	; Flag value 11000100b encoded
		Encode	<11000101b>	; Flag value 11000101b encoded
		Encode	<11000110b>	; Flag value 11000110b encoded
		Encode	<11000111b>	; Flag value 11000111b encoded
		Encode	<11001000b>	; Flag value 11001000b encoded
		Encode	<11001001b>	; Flag value 11001001b encoded
		Encode	<11001010b>	; Flag value 11001010b encoded
		Encode	<11001011b>	; Flag value 11001011b encoded
		Encode	<11001100b>	; Flag value 11001100b encoded
		Encode	<11001101b>	; Flag value 11001101b encoded
		Encode	<11001110b>	; Flag value 11001110b encoded
		Encode	<11001111b>	; Flag value 11001111b encoded
		Encode	<11010000b>	; Flag value 11010000b encoded
		Encode	<11010001b>	; Flag value 11010001b encoded
		Encode	<11010010b>	; Flag value 11010010b encoded
		Encode	<11010011b>	; Flag value 11010011b encoded
		Encode	<11010100b>	; Flag value 11010100b encoded
		Encode	<11010101b>	; Flag value 11010101b encoded
		Encode	<11010110b>	; Flag value 11010110b encoded
		Encode	<11010111b>	; Flag value 11010111b encoded
		Encode	<11011000b>	; Flag value 11011000b encoded
		Encode	<11011001b>	; Flag value 11011001b encoded
		Encode	<11011010b>	; Flag value 11011010b encoded
		Encode	<11011011b>	; Flag value 11011011b encoded
		Encode	<11011100b>	; Flag value 11011100b encoded
		Encode	<11011101b>	; Flag value 11011101b encoded
		Encode	<11011110b>	; Flag value 11011110b encoded
		Encode	<11011111b>	; Flag value 11011111b encoded
		Encode	<11100000b>	; Flag value 11100000b encoded
		Encode	<11100001b>	; Flag value 11100001b encoded
		Encode	<11100010b>	; Flag value 11100010b encoded
		Encode	<11100011b>	; Flag value 11100011b encoded
		Encode	<11100100b>	; Flag value 11100100b encoded
		Encode	<11100101b>	; Flag value 11100101b encoded
		Encode	<11100110b>	; Flag value 11100110b encoded
		Encode	<11100111b>	; Flag value 11100111b encoded
		Encode	<11101000b>	; Flag value 11101000b encoded
		Encode	<11101001b>	; Flag value 11101001b encoded
		Encode	<11101010b>	; Flag value 11101010b encoded
		Encode	<11101011b>	; Flag value 11101011b encoded
		Encode	<11101100b>	; Flag value 11101100b encoded
		Encode	<11101101b>	; Flag value 11101101b encoded
		Encode	<11101110b>	; Flag value 11101110b encoded
		Encode	<11101111b>	; Flag value 11101111b encoded
		Encode	<11110000b>	; Flag value 11110000b encoded
		Encode	<11110001b>	; Flag value 11110001b encoded
		Encode	<11110010b>	; Flag value 11110010b encoded
		Encode	<11110011b>	; Flag value 11110011b encoded
		Encode	<11110100b>	; Flag value 11110100b encoded
		Encode	<11110101b>	; Flag value 11110101b encoded
		Encode	<11110110b>	; Flag value 11110110b encoded
		Encode	<11110111b>	; Flag value 11110111b encoded
		Encode	<11111000b>	; Flag value 11111000b encoded
		Encode	<11111001b>	; Flag value 11111001b encoded
		Encode	<11111010b>	; Flag value 11111010b encoded
		Encode	<11111011b>	; Flag value 11111011b encoded
		Encode	<11111100b>	; Flag value 11111100b encoded
		Encode	<11111101b>	; Flag value 11111101b encoded
		Encode	<11111110b>	; Flag value 11111110b encoded
		Encode	<11111111b>	; Flag value 11111111b encoded
;******************************************************************************
;
;	Define the Flag Decoding Table
;
;******************************************************************************
		Even			; Force table to even address
Flag_Decode	Equ	This Byte	; CPU flag decoding table
		Decode	<00000000b>	; Flag value 00000000b decoded
		Decode	<00000001b>	; Flag value 00000001b decoded
		Decode	<00000010b>	; Flag value 00000010b decoded
		Decode	<00000011b>	; Flag value 00000011b decoded
		Decode	<00000100b>	; Flag value 00000100b decoded
		Decode	<00000101b>	; Flag value 00000101b decoded
		Decode	<00000110b>	; Flag value 00000110b decoded
		Decode	<00000111b>	; Flag value 00000111b decoded
		Decode	<00001000b>	; Flag value 00001000b decoded
		Decode	<00001001b>	; Flag value 00001001b decoded
		Decode	<00001010b>	; Flag value 00001010b decoded
		Decode	<00001011b>	; Flag value 00001011b decoded
		Decode	<00001100b>	; Flag value 00001100b decoded
		Decode	<00001101b>	; Flag value 00001101b decoded
		Decode	<00001110b>	; Flag value 00001110b decoded
		Decode	<00001111b>	; Flag value 00001111b decoded
		Decode	<00010000b>	; Flag value 00010000b decoded
		Decode	<00010001b>	; Flag value 00010001b decoded
		Decode	<00010010b>	; Flag value 00010010b decoded
		Decode	<00010011b>	; Flag value 00010011b decoded
		Decode	<00010100b>	; Flag value 00010100b decoded
		Decode	<00010101b>	; Flag value 00010101b decoded
		Decode	<00010110b>	; Flag value 00010110b decoded
		Decode	<00010111b>	; Flag value 00010111b decoded
		Decode	<00011000b>	; Flag value 00011000b decoded
		Decode	<00011001b>	; Flag value 00011001b decoded
		Decode	<00011010b>	; Flag value 00011010b decoded
		Decode	<00011011b>	; Flag value 00011011b decoded
		Decode	<00011100b>	; Flag value 00011100b decoded
		Decode	<00011101b>	; Flag value 00011101b decoded
		Decode	<00011110b>	; Flag value 00011110b decoded
		Decode	<00011111b>	; Flag value 00011111b decoded
		Decode	<00100000b>	; Flag value 00100000b decoded
		Decode	<00100001b>	; Flag value 00100001b decoded
		Decode	<00100010b>	; Flag value 00100010b decoded
		Decode	<00100011b>	; Flag value 00100011b decoded
		Decode	<00100100b>	; Flag value 00100100b decoded
		Decode	<00100101b>	; Flag value 00100101b decoded
		Decode	<00100110b>	; Flag value 00100110b decoded
		Decode	<00100111b>	; Flag value 00100111b decoded
		Decode	<00101000b>	; Flag value 00101000b decoded
		Decode	<00101001b>	; Flag value 00101001b decoded
		Decode	<00101010b>	; Flag value 00101010b decoded
		Decode	<00101011b>	; Flag value 00101011b decoded
		Decode	<00101100b>	; Flag value 00101100b decoded
		Decode	<00101101b>	; Flag value 00101101b decoded
		Decode	<00101110b>	; Flag value 00101110b decoded
		Decode	<00101111b>	; Flag value 00101111b decoded
		Decode	<00110000b>	; Flag value 00110000b decoded
		Decode	<00110001b>	; Flag value 00110001b decoded
		Decode	<00110010b>	; Flag value 00110010b decoded
		Decode	<00110011b>	; Flag value 00110011b decoded
		Decode	<00110100b>	; Flag value 00110100b decoded
		Decode	<00110101b>	; Flag value 00110101b decoded
		Decode	<00110110b>	; Flag value 00110110b decoded
		Decode	<00110111b>	; Flag value 00110111b decoded
		Decode	<00111000b>	; Flag value 00111000b decoded
		Decode	<00111001b>	; Flag value 00111001b decoded
		Decode	<00111010b>	; Flag value 00111010b decoded
		Decode	<00111011b>	; Flag value 00111011b decoded
		Decode	<00111100b>	; Flag value 00111100b decoded
		Decode	<00111101b>	; Flag value 00111101b decoded
		Decode	<00111110b>	; Flag value 00111110b decoded
		Decode	<00111111b>	; Flag value 00111111b decoded
		Decode	<01000000b>	; Flag value 01000000b decoded
		Decode	<01000001b>	; Flag value 01000001b decoded
		Decode	<01000010b>	; Flag value 01000010b decoded
		Decode	<01000011b>	; Flag value 01000011b decoded
		Decode	<01000100b>	; Flag value 01000100b decoded
		Decode	<01000101b>	; Flag value 01000101b decoded
		Decode	<01000110b>	; Flag value 01000110b decoded
		Decode	<01000111b>	; Flag value 01000111b decoded
		Decode	<01001000b>	; Flag value 01001000b decoded
		Decode	<01001001b>	; Flag value 01001001b decoded
		Decode	<01001010b>	; Flag value 01001010b decoded
		Decode	<01001011b>	; Flag value 01001011b decoded
		Decode	<01001100b>	; Flag value 01001100b decoded
		Decode	<01001101b>	; Flag value 01001101b decoded
		Decode	<01001110b>	; Flag value 01001110b decoded
		Decode	<01001111b>	; Flag value 01001111b decoded
		Decode	<01010000b>	; Flag value 01010000b decoded
		Decode	<01010001b>	; Flag value 01010001b decoded
		Decode	<01010010b>	; Flag value 01010010b decoded
		Decode	<01010011b>	; Flag value 01010011b decoded
		Decode	<01010100b>	; Flag value 01010100b decoded
		Decode	<01010101b>	; Flag value 01010101b decoded
		Decode	<01010110b>	; Flag value 01010110b decoded
		Decode	<01010111b>	; Flag value 01010111b decoded
		Decode	<01011000b>	; Flag value 01011000b decoded
		Decode	<01011001b>	; Flag value 01011001b decoded
		Decode	<01011010b>	; Flag value 01011010b decoded
		Decode	<01011011b>	; Flag value 01011011b decoded
		Decode	<01011100b>	; Flag value 01011100b decoded
		Decode	<01011101b>	; Flag value 01011101b decoded
		Decode	<01011110b>	; Flag value 01011110b decoded
		Decode	<01011111b>	; Flag value 01011111b decoded
		Decode	<01100000b>	; Flag value 01100000b decoded
		Decode	<01100001b>	; Flag value 01100001b decoded
		Decode	<01100010b>	; Flag value 01100010b decoded
		Decode	<01100011b>	; Flag value 01100011b decoded
		Decode	<01100100b>	; Flag value 01100100b decoded
		Decode	<01100101b>	; Flag value 01100101b decoded
		Decode	<01100110b>	; Flag value 01100110b decoded
		Decode	<01100111b>	; Flag value 01100111b decoded
		Decode	<01101000b>	; Flag value 01101000b decoded
		Decode	<01101001b>	; Flag value 01101001b decoded
		Decode	<01101010b>	; Flag value 01101010b decoded
		Decode	<01101011b>	; Flag value 01101011b decoded
		Decode	<01101100b>	; Flag value 01101100b decoded
		Decode	<01101101b>	; Flag value 01101101b decoded
		Decode	<01101110b>	; Flag value 01101110b decoded
		Decode	<01101111b>	; Flag value 01101111b decoded
		Decode	<01110000b>	; Flag value 01110000b decoded
		Decode	<01110001b>	; Flag value 01110001b decoded
		Decode	<01110010b>	; Flag value 01110010b decoded
		Decode	<01110011b>	; Flag value 01110011b decoded
		Decode	<01110100b>	; Flag value 01110100b decoded
		Decode	<01110101b>	; Flag value 01110101b decoded
		Decode	<01110110b>	; Flag value 01110110b decoded
		Decode	<01110111b>	; Flag value 01110111b decoded
		Decode	<01111000b>	; Flag value 01111000b decoded
		Decode	<01111001b>	; Flag value 01111001b decoded
		Decode	<01111010b>	; Flag value 01111010b decoded
		Decode	<01111011b>	; Flag value 01111011b decoded
		Decode	<01111100b>	; Flag value 01111100b decoded
		Decode	<01111101b>	; Flag value 01111101b decoded
		Decode	<01111110b>	; Flag value 01111110b decoded
		Decode	<01111111b>	; Flag value 01111111b decoded
		Decode	<10000000b>	; Flag value 10000000b decoded
		Decode	<10000001b>	; Flag value 10000001b decoded
		Decode	<10000010b>	; Flag value 10000010b decoded
		Decode	<10000011b>	; Flag value 10000011b decoded
		Decode	<10000100b>	; Flag value 10000100b decoded
		Decode	<10000101b>	; Flag value 10000101b decoded
		Decode	<10000110b>	; Flag value 10000110b decoded
		Decode	<10000111b>	; Flag value 10000111b decoded
		Decode	<10001000b>	; Flag value 10001000b decoded
		Decode	<10001001b>	; Flag value 10001001b decoded
		Decode	<10001010b>	; Flag value 10001010b decoded
		Decode	<10001011b>	; Flag value 10001011b decoded
		Decode	<10001100b>	; Flag value 10001100b decoded
		Decode	<10001101b>	; Flag value 10001101b decoded
		Decode	<10001110b>	; Flag value 10001110b decoded
		Decode	<10001111b>	; Flag value 10001111b decoded
		Decode	<10010000b>	; Flag value 10010000b decoded
		Decode	<10010001b>	; Flag value 10010001b decoded
		Decode	<10010010b>	; Flag value 10010010b decoded
		Decode	<10010011b>	; Flag value 10010011b decoded
		Decode	<10010100b>	; Flag value 10010100b decoded
		Decode	<10010101b>	; Flag value 10010101b decoded
		Decode	<10010110b>	; Flag value 10010110b decoded
		Decode	<10010111b>	; Flag value 10010111b decoded
		Decode	<10011000b>	; Flag value 10011000b decoded
		Decode	<10011001b>	; Flag value 10011001b decoded
		Decode	<10011010b>	; Flag value 10011010b decoded
		Decode	<10011011b>	; Flag value 10011011b decoded
		Decode	<10011100b>	; Flag value 10011100b decoded
		Decode	<10011101b>	; Flag value 10011101b decoded
		Decode	<10011110b>	; Flag value 10011110b decoded
		Decode	<10011111b>	; Flag value 10011111b decoded
		Decode	<10100000b>	; Flag value 10100000b decoded
		Decode	<10100001b>	; Flag value 10100001b decoded
		Decode	<10100010b>	; Flag value 10100010b decoded
		Decode	<10100011b>	; Flag value 10100011b decoded
		Decode	<10100100b>	; Flag value 10100100b decoded
		Decode	<10100101b>	; Flag value 10100101b decoded
		Decode	<10100110b>	; Flag value 10100110b decoded
		Decode	<10100111b>	; Flag value 10100111b decoded
		Decode	<10101000b>	; Flag value 10101000b decoded
		Decode	<10101001b>	; Flag value 10101001b decoded
		Decode	<10101010b>	; Flag value 10101010b decoded
		Decode	<10101011b>	; Flag value 10101011b decoded
		Decode	<10101100b>	; Flag value 10101100b decoded
		Decode	<10101101b>	; Flag value 10101101b decoded
		Decode	<10101110b>	; Flag value 10101110b decoded
		Decode	<10101111b>	; Flag value 10101111b decoded
		Decode	<10110000b>	; Flag value 10110000b decoded
		Decode	<10110001b>	; Flag value 10110001b decoded
		Decode	<10110010b>	; Flag value 10110010b decoded
		Decode	<10110011b>	; Flag value 10110011b decoded
		Decode	<10110100b>	; Flag value 10110100b decoded
		Decode	<10110101b>	; Flag value 10110101b decoded
		Decode	<10110110b>	; Flag value 10110110b decoded
		Decode	<10110111b>	; Flag value 10110111b decoded
		Decode	<10111000b>	; Flag value 10111000b decoded
		Decode	<10111001b>	; Flag value 10111001b decoded
		Decode	<10111010b>	; Flag value 10111010b decoded
		Decode	<10111011b>	; Flag value 10111011b decoded
		Decode	<10111100b>	; Flag value 10111100b decoded
		Decode	<10111101b>	; Flag value 10111101b decoded
		Decode	<10111110b>	; Flag value 10111110b decoded
		Decode	<10111111b>	; Flag value 10111111b decoded
		Decode	<11000000b>	; Flag value 11000000b decoded
		Decode	<11000001b>	; Flag value 11000001b decoded
		Decode	<11000010b>	; Flag value 11000010b decoded
		Decode	<11000011b>	; Flag value 11000011b decoded
		Decode	<11000100b>	; Flag value 11000100b decoded
		Decode	<11000101b>	; Flag value 11000101b decoded
		Decode	<11000110b>	; Flag value 11000110b decoded
		Decode	<11000111b>	; Flag value 11000111b decoded
		Decode	<11001000b>	; Flag value 11001000b decoded
		Decode	<11001001b>	; Flag value 11001001b decoded
		Decode	<11001010b>	; Flag value 11001010b decoded
		Decode	<11001011b>	; Flag value 11001011b decoded
		Decode	<11001100b>	; Flag value 11001100b decoded
		Decode	<11001101b>	; Flag value 11001101b decoded
		Decode	<11001110b>	; Flag value 11001110b decoded
		Decode	<11001111b>	; Flag value 11001111b decoded
		Decode	<11010000b>	; Flag value 11010000b decoded
		Decode	<11010001b>	; Flag value 11010001b decoded
		Decode	<11010010b>	; Flag value 11010010b decoded
		Decode	<11010011b>	; Flag value 11010011b decoded
		Decode	<11010100b>	; Flag value 11010100b decoded
		Decode	<11010101b>	; Flag value 11010101b decoded
		Decode	<11010110b>	; Flag value 11010110b decoded
		Decode	<11010111b>	; Flag value 11010111b decoded
		Decode	<11011000b>	; Flag value 11011000b decoded
		Decode	<11011001b>	; Flag value 11011001b decoded
		Decode	<11011010b>	; Flag value 11011010b decoded
		Decode	<11011011b>	; Flag value 11011011b decoded
		Decode	<11011100b>	; Flag value 11011100b decoded
		Decode	<11011101b>	; Flag value 11011101b decoded
		Decode	<11011110b>	; Flag value 11011110b decoded
		Decode	<11011111b>	; Flag value 11011111b decoded
		Decode	<11100000b>	; Flag value 11100000b decoded
		Decode	<11100001b>	; Flag value 11100001b decoded
		Decode	<11100010b>	; Flag value 11100010b decoded
		Decode	<11100011b>	; Flag value 11100011b decoded
		Decode	<11100100b>	; Flag value 11100100b decoded
		Decode	<11100101b>	; Flag value 11100101b decoded
		Decode	<11100110b>	; Flag value 11100110b decoded
		Decode	<11100111b>	; Flag value 11100111b decoded
		Decode	<11101000b>	; Flag value 11101000b decoded
		Decode	<11101001b>	; Flag value 11101001b decoded
		Decode	<11101010b>	; Flag value 11101010b decoded
		Decode	<11101011b>	; Flag value 11101011b decoded
		Decode	<11101100b>	; Flag value 11101100b decoded
		Decode	<11101101b>	; Flag value 11101101b decoded
		Decode	<11101110b>	; Flag value 11101110b decoded
		Decode	<11101111b>	; Flag value 11101111b decoded
		Decode	<11110000b>	; Flag value 11110000b decoded
		Decode	<11110001b>	; Flag value 11110001b decoded
		Decode	<11110010b>	; Flag value 11110010b decoded
		Decode	<11110011b>	; Flag value 11110011b decoded
		Decode	<11110100b>	; Flag value 11110100b decoded
		Decode	<11110101b>	; Flag value 11110101b decoded
		Decode	<11110110b>	; Flag value 11110110b decoded
		Decode	<11110111b>	; Flag value 11110111b decoded
		Decode	<11111000b>	; Flag value 11111000b decoded
		Decode	<11111001b>	; Flag value 11111001b decoded
		Decode	<11111010b>	; Flag value 11111010b decoded
		Decode	<11111011b>	; Flag value 11111011b decoded
		Decode	<11111100b>	; Flag value 11111100b decoded
		Decode	<11111101b>	; Flag value 11111101b decoded
		Decode	<11111110b>	; Flag value 11111110b decoded
		Decode	<11111111b>	; Flag value 11111111b decoded
;******************************************************************************
;
;	Define the Apple ROM Data File Names
;
;******************************************************************************
System_ROM	Db	"ATARI.ROM",0   ; ATARI system ROM data file

;******************************************************************************
;
;	Define the Apple system flag byte
;
;	-----------------
;	|7|6|5|4|3|2|1|0|
;	-----------------
;	 | | | | | | | |
;	 | | | | | | | -------> Video type (0 = CGA, 1 = EGA)
;	 | | | | | | ---------> Display type (0 = CGA, 1 = EGA)
;	 | | | | | -----------> Interrupt status (0 = Normal, 1 = Patched)
;	 | | | | -------------> Video status (0 = Normal, 1 = Initialized)
;	 | | | ---------------> Keyboard status (0 = Normal, 1 = Input)
;	 | | -----------------> Mixed CPU status (0 = Normal, 1 = Mixed)
;	 | -------------------> Enhanced CPU status (0 = Normal, 1 = Enhanced)
;	 ---------------------> Configuration data (0 = None, 1 = Present)
;
;******************************************************************************
		Even			; Force byte to even address
System_Flag	Db	00h		; System flag byte
;******************************************************************************
;
;	Define the Emulator system flag byte
;
;	-----------------
;	|7|6|5|4|3|2|1|0|
;	-----------------
;	 | | | | | | | |
;	 | | | | | | | -------> System Break Interrupt has Occurred
;	 | | | | | | ---------> System Trace Interrupt has Occurred
;	 | | | | | -----------> System Debug Interrupt has Occurred
;	 | | | | -------------> ***** Reserved ***** (Dummy interrupt)
;	 | | | ---------------> ***** Reserved ***** (Dummy interrupt)
;	 | | -----------------> ***** Reserved ***** (Dummy interrupt)
;	 | -------------------> System Reset Interrupt has Occurred
;	 ---------------------> System Request Interrupt has Occurred
;
;******************************************************************************
		Even			; Force byte to even address
Emulate_Flag	Db	00h		; Emulator flag byte
;******************************************************************************
;
;	Define the interrupt vector save area
;
;******************************************************************************
;		Even			; Force dwords to even address
Original_Int_3	Dd	?		; Original interrupt 3 (Debug) vector
Original_Int_8	Dd	?		; Original interrupt 8 (Timer) vector
Original_Int_9	Dd	?		; Original interrupt 9 (Keyboard) vector
;******************************************************************************
;
;	Define all other needed data values
;
;******************************************************************************
		Even			; Force byte to even address
RAM_Space	Dw	?		; RAM space segment save area
ALT_Space	Dw	?		; alternate RAM space segment save area
Video_Segment	Dw	?		; Video segment value
;******************************************************************************
;
;	Define the end of the Emulator Code Segment
;
;******************************************************************************
Emulate Ends
	End				; End of the data module
