	Page	58,132
	Title	HARDWARE.ASM	Hardware Page Access Routines
;******************************************************************************
;
;   Name:	HARDWARE.ASM	Hardware Routines
;
;   Group:	Emulator
;
;   Revision:	0.00
;
;   Date:
;
;   Author: Michael Munoz
;
;******************************************************************************
;
;  Module Functional Description:
;
;
;******************************************************************************
;
;  Changes:
;
;    DATE     REVISION				DESCRIPTION
;  --------   --------	-------------------------------------------------------
;
;******************************************************************************
	Page
;
;  Public Declarations
;
	Public Write_Hardware
	Public Hardware_Update
	Public Jsr_Steal
	Public	exit_flag
	Public	Astack
;  External Declarations
;
	Extrn	my_siov:Far
	Extrn	Antic_Update:Near
	Extrn	Gita_Update:Near
	Extrn	Antic_Blank:Near
	Extrn	Antic_Jmp:Near
	Extrn	Antic_mode2:Near
	Extrn	Antic_mode3:Near
	Extrn	Antic_mode4:Near
	Extrn	Antic_mode5:Near
	Extrn	Antic_mode6:Near
	Extrn	Antic_mode7:Near
	Extrn	Antic_mode8:Near
	Extrn	Antic_mode9:Near
	Extrn	Antic_modeA:Near
	Extrn	Antic_modeB:Near
	Extrn	Antic_modeC:Near
	Extrn	Antic_modeD:Near
	Extrn	Antic_modeE:Near
	Extrn	Antic_modeF:Near
	Extrn	Access:Near
	Extrn	Exit:Near
	Extrn	Player_Missle:Near

	Extrn	instr_count:Word
	Extrn	Gita_nmiflag:Byte
	Extrn	COUNT_Table:Byte
	Extrn	Flag_Encode:Byte
	Extrn	Antic_evcount:Word
	Extrn	Antic_wait:Byte
	Extrn	Antic_dlist:Word
	Extrn	Antic_dinstr:Byte
	Extrn	Antic_pc:Word
	Extrn	int_flag:Byte
	Extrn	nmi_flag:Byte
	Extrn	Access_flag:Byte
	Extrn	Video_Pntr_Cur:Word
	Extrn	Video_Pntr_Old:Word
;

;  LOCAL Equates
;
	LB	equ	01FH
	F1_Key	equ	03bh
;
;  Define any include files needed
;
	Include 	Macros.inc	; Include the macro definitions
	Include 	Equates.inc	; Include the equate definitions
	Include		Atari.inc	; Atari equates
	.286c				; Include 80286 instructions
	Page
;
;  Define the emulator code segment
;
Emulate Segment Word Public 'EMULATE'   ; Emulator code segment
	Assume	cs:Emulate, ds:Nothing, es:Nothing
	even
Astack		DB	0
exit_flag	DB 	0

;Jmp table for hardware write to handle special cases
		even
HWARE_Table	Equ	This Word
		Dw	Gita_Update             ;0
		Dw	Do_Nothing              ;1
		Dw	Pokey_Update            ;2
		Dw	Pia_Update              ;3
		Dw	Antic_Update            ;4
		Dw	Do_Nothing              ;5
		Dw	Do_Nothing		;6
		Dw	Do_Nothing		;7

		even
Antic_table	Equ	This Word	; DL instruction jump table
		DW Antic_Blank		;x0h
		DW Antic_Jmp		;x1h
		DW Antic_mode2		;x2h
		DW Antic_mode3		;x3h
		DW Antic_mode4		;x4h
		DW Antic_mode5		;x5h
		DW Antic_mode6		;x6h
		DW Antic_mode7		;x7h
		DW Antic_mode8		;x8h
		DW Antic_mode9		;x9h
		DW Antic_modeA		;xah
		DW Antic_modeB		;xbh
		DW Antic_modeC		;xch
		DW Antic_modeD		;xdh
		DW Antic_modeE		;xeh
		DW Antic_modeF		;xfh

	Subttl	Hardware_Update	Update Hardware
	Page	+
;******************************************************************************
;
;	Hardware_Update
;
;	Registers on Entry:
;
;		DS points to Atari ram
;
;	Registers on Exit:
;
;		BP    - Destroyed
;
;******************************************************************************
		Even			; Force procedure to even address
Hardware_Update	Proc	Near		; Hardware page read procedure
	test	cs:exit_flag,1		; see if user wants to quit
	je	No_Exit                 ; this flag set wehn user pushes
	call	Exit			; ctrl-f5 (keyboard.asm)
No_Exit:
	test	cs:Access_flag,1	; see if we need to to some command
	je	No_Access		; this flag set when user pushes
	call 	Access			; f12 (keyboard.asm)
No_Access:
	mov	di,cs:Antic_pc		; Get current instruction pointer (20)
	cmp	cs:Antic_evcount,8	; screens starts at vcount=8 (18)
	jne 	No_VBLANK		; jmp if not in vblank (4,16)
	mov	cs:Antic_wait,0		; reset wait for vblank flag (20)
	mov	di,cs:Antic_dlist	; (20)
	mov     cs:Antic_pc,di		; (20)
No_VBLANK:
; check for valid display list pointer (i.e. non zero)
	cmp	di,0			; Valid display address? (3)
	je	Skip_Wait		; jmp if not valid (4,16)
; get next display list instruction
	mov 	al,[di]	        	; get the next display instr. (19)
	mov	cs:Antic_dinstr,al	; save next instruction (20)
; See if a JVB was issued
	cmp	cs:Antic_wait,0		; is JVB wait = 1? (20)
	jne	Skip_Wait               ; jmp if no
	and	ax,000fh		; get lower 4 bits of dinstr
	shl	ax,1                    ; shift to account for words
	mov	di,ax			; di contains the table offset
	call	cs:[cs:Antic_table + di] ; call to antic display mode
	mov	di,LB_DMACTL		;
	mov	al,Antic_ram[di]	;
	test	al,0ch			; player/missle dma enabled?
	je	Check_Evcount		; no PM
	call 	Player_Missle		; display PM graphics
	jmp 	Check_Evcount		; cs:Antic_evcount already updated
Skip_Wait:
	inc 	cs:Antic_evcount	; increment counter
Check_Evcount:
; update number of instructions till next hardware update
	mov	ax,cs:instr_count		; get instr_count
	mov	bp,ax			; reset cs:Antic_count (20)
; Any NMI interrupt s need to be done?
	test	cs:[nmi_flag],1
	jne	Call_NMI

	mov	ax,0262d
	cmp	cs:Antic_evcount,ax	 	; cs:Antic_evcount >= 262
	jnge	Check_Atari_Int
	mov	cs:Antic_evcount,0		; reset counter
	mov	di,LB_NMIEN		; read nmi enable bits
	mov	al,Antic_ram[di]		; get value
	test	al,B6			; nmi enabled?
	jnz	No_Update_Vcount           ; no
	jmp	Update_Vcount
No_Update_Vcount:
	mov	di,NMIST                ; yes, set status bit
	mov	Byte Ptr [di],B6
Call_NMI:
	mov	cs:[nmi_flag],0
	Atari_Interrupt NMI_VECTOR	; set up nmi interrupt
	jmp	Update_Vcount
Check_Atari_Int:
	test	dh,CPU_I		; see if interrupt enabled
	jne	Update_Vcount		; no interrupt enabled
	mov	di,IRQST
	mov	al,ds:[di]		; see if interrupt has occured
	not	al
	test	cs:[int_flag],1
	je	Update_Vcount		; no interrupt
	mov	cs:[int_flag],0
	Atari_Interrupt	IRQ_VECTOR
Update_Vcount:

	mov	di,VCOUNT		; write to atari ram
	mov 	ax,cs:Antic_evcount	; get vcount long
	shr	ax,1			; divde by 2
	mov	[di],al			; ram[VCOUNT] = cs:Antic_evcount>>1
	; get random
	mov	di,RANDOM
	push	ds
	mov	ax,0
	mov	ds,ax
	mov	bx,046ch
	mov	al,ds:[bx]
	pop	ds
	mov	Byte Ptr ds:[di],al
	ret
Hardware_Update	Endp			; End of the Hardware_Read procedure
	Subttl	Write_Hardware	Hardware Write
	Page	+
;******************************************************************************
;
;	Write_Hardware
;
;	Registers on Entry:
;
;		DS points to Atari ram
;
;	Registers on Exit:
;
;		BP    - Destroyed
;
;******************************************************************************
		Even			; Force procedure to even address
Write_Hardware	Proc	Near		; Hardware page read procedure
	mov	bx,di
	shr	bx,7
	and     bx,0eh			; get page
	jmp	cs:[HWARE_Table+bx] 	; Jump to correct routine to write
	ret				; never gets here
Write_Hardware	Endp			; End of the Hardware_Read procedure
	Subttl	Jsr_Steal
	Page	+
;******************************************************************************
;
;	Jsr_Steal
;
;	Registers on Entry:
;
;		si  - Jump subroutine address
;
;	Registers on Exit:
;
;		ax  - Destroyed
;
;******************************************************************************
		Even			; Force procedure to even address
Jsr_Steal	Proc	Near		; Intercept a jsr
	cmp	si,SIOV			; steal sio vector
	je	Steal_SIOV		; finish the jsr
	ret
Steal_SIOV:
	call	my_siov			; call my routine
	Pop_16				; Pop return address from the stack
	inc	ax			; Increment the return address value
	mov	si,ax			; Update the program counter
	ret
Jsr_Steal	Endp			; End of the jsr steal routine

;******************************************************************************
;
;	No hardware to update
;
;******************************************************************************
 Do_Nothing	Proc	Near
	ret
 Do_Nothing	Endp


;******************************************************************************
;
;	Update Pokey pseudo registers
;
;******************************************************************************
 Pokey_Update	Proc	Near
	push 	di
	and	di,01fh			; store data
	mov	Pokey_ram[di],al		;
;   if (addr==IRQEN) cpu.ram[IRQEN] |= ~data;
	pop 	di
	cmp	di,IRQST
	jne	Check_Serial
	Not	al
	or	[di],al
Check_Serial:
;   if (addr==SKRES) cpu.ram[SKSTAT] |= 0x70;
	cmp	di,SKRES
	jne	Done_Pokey
	or	Byte Ptr [di],070h
Done_Pokey:
	ret

 Pokey_Update	Endp

;******************************************************************************
;
;	Update Pia pseudo registers
;
;******************************************************************************
 Pia_Update	Proc	Near
	and	di,01fh			;update Pia ram space..
	mov	Pia_ram[di],al		;save in pseudo register
	ret
 Pia_Update	Endp


Key_Table	EQU This	Byte
       DB      0A0h    ;00      ^,
       DB      0BFh    ;01      ^A
       DB      095h    ;02      ^B
       DB      092h    ;03      ^C
       DB      0BAh    ;04      ^D
       DB      0AAh    ;05      ^E
       DB      0B8h    ;06      ^F
       DB      0BDh    ;07      ^G
       DB      034h    ;08      ^H
       DB      08Dh    ;09      ^I
       DB      081h    ;0A      ^J
       DB      085h    ;0B      ^K
       DB      080h    ;0C      ^L
       DB      00Ch    ;0D      ^MRET
       DB      0A3h    ;0E      ^N
       DB      088h    ;0F      ^O
       DB      08Ah    ;10      ^P
       DB      0AFh    ;11      ^Q
       DB      0A8h    ;12      ^R
       DB      0BEh    ;13      ^S
       DB      0ADh    ;14      ^T
       DB      08Bh    ;15      ^U
       DB      090h    ;16      ^V
       DB      0AEh    ;17      ^W
       DB      096h    ;18      ^X
       DB      0ABh    ;19      ^Y
       DB      097h    ;1A      ^Z
       DB      09Ch    ;1B      ESC
       DB      08Eh    ;1C      ^-
       DB      08Fh    ;1D      ^=
       DB      086h    ;1E      ^+
       DB      087h    ;1F      ^*
       DB      0A1h    ;20      SPC
       DB      05Fh    ;21      _1
       DB      05Eh    ;22      _2
       DB      05Ah    ;23      _3
       DB      058h    ;24      _4
       DB      05Dh    ;25      _5
       DB      05Bh    ;26      _6
       DB      073h    ;27      _7
       DB      070h    ;28      _9
       DB      072h    ;29      _0
       DB      007h    ;2A      *
       DB      006h    ;2B      +
       DB      020h    ;2C      ,
       DB      00Eh    ;2D      -
       DB      022h    ;2E      .
       DB      026h    ;2F      /
       DB      032h    ;30      0
       DB      01Fh    ;31      1
       DB      01Eh    ;32      2
       DB      01Ah    ;33      3
       DB      018h    ;34      4
       DB      01Dh    ;35      5
       DB      01Bh    ;36      6
       DB      013h    ;37      7
       DB      035h    ;38      8
       DB      030h    ;39      9
       DB      042h    ;3A      _;
       DB      002h    ;3B      ;
       DB      036h    ;3C      <
       DB      00Fh    ;3D      =
       DB      037h    ;3E      >
       DB      066h    ;3F      _/
       DB      075h    ;40      _8
       DB      07Fh    ;41      _A
       DB      055h    ;42      _B
       DB      052h    ;43      _C
       DB      07Ah    ;44      _D
       DB      06Ah    ;45      _E
       DB      078h    ;46      _F
       DB      07Dh    ;47      _G
       DB      079h    ;48      _H
       DB      04Dh    ;49      _I
       DB      041h    ;4A      _J
       DB      045h    ;4B      _K
       DB      040h    ;4C      _L
       DB      065h    ;4D      _M
       DB      063h    ;4E      _N
       DB      048h    ;4F      _O
       DB      04Ah    ;50      _P
       DB      06Fh    ;51      _Q
       DB      068h    ;52      _R
       DB      07Eh    ;53      _S
       DB      06Dh    ;54      _T
       DB      04Bh    ;55      _U
       DB      050h    ;56      _V
       DB      06Eh    ;57      _W
       DB      056h    ;58      _X
       DB      06Bh    ;59      _Y
       DB      057h    ;5A      _Z
       DB      060h    ;5B      _,
       DB      046h    ;5C      _+
       DB      062h    ;5D      _.
       DB      047h    ;5E      _*
       DB      04Eh    ;5F      _-
       DB      000h    ;60
       DB      03Fh    ;61      A
       DB      015h    ;62      B
       DB      012h    ;63      C
       DB      03Ah    ;64      D
       DB      02Ah    ;65      E
       DB      038h    ;66      F
       DB      03Dh    ;67      G
       DB      039h    ;68      H
       DB      00Dh    ;69      I
       DB      001h    ;6A      J
       DB      005h    ;6B      K
       DB      000h    ;6C      L
       DB      025h    ;6D      M
       DB      023h    ;6E      N
       DB      008h    ;6F      O
       DB      00Ah    ;70      P
       DB      02Fh    ;71      Q
       DB      028h    ;72      R
       DB      03Eh    ;73      S
       DB      02Dh    ;74      T
       DB      00Bh    ;75      U
       DB      010h    ;76      V
       DB      02Eh    ;77      W
       DB      016h    ;78      X
       DB      02Bh    ;79      Y
       DB      017h    ;7A      Z
       DB      082h    ;7B      ^;
       DB      04Fh    ;7C      _=
       DB      076h    ;7D      ^<
       DB      034h    ;7E      BSP
       DB      02Ch    ;7F      TAB
       DB      0A0h    ;80      ^,
       DB      0BFh    ;81      ^A
       DB      095h    ;82      ^B
       DB      092h    ;83      ^C
       DB      0BAh    ;84      ^D
       DB      0AAh    ;85      ^E
       DB      0B8h    ;86      ^F
       DB      0BDh    ;87      ^G
       DB      0B9h    ;88      ^H
       DB      08Dh    ;89      ^I
       DB      081h    ;8A      ^J
       DB      085h    ;8B      ^K
       DB      080h    ;8C      ^L
       DB      0A5h    ;8D      ^M
       DB      0A3h    ;8E      ^N
       DB      088h    ;8F      ^O
       DB      08Ah    ;90      ^P
       DB      0AFh    ;91      ^Q
       DB      0A8h    ;92      ^R
       DB      0BEh    ;93      ^S
       DB      0ADh    ;94      ^T
       DB      08Bh    ;95      ^U
       DB      090h    ;96      ^V
       DB      0AEh    ;97      ^W
       DB      096h    ;98      ^X
       DB      0ABh    ;99      ^Y
       DB      097h    ;9A      ^Z
       DB      00Ch    ;9B      RET
       DB      074h    ;9C      _BSP
       DB      077h    ;9D      _>
       DB      0ACh    ;9E      ^TAB
       DB      06Ch    ;9F      _TAB
       DB      0A1h    ;A0      SPC
       DB      05Fh    ;A1      _1
       DB      05Eh    ;A2      _2
       DB      05Ah    ;A3      _3
       DB      058h    ;A4      _4
       DB      05Dh    ;A5      _5
       DB      05Bh    ;A6      _6
       DB      073h    ;A7      _7
       DB      070h    ;A8      _9
       DB      072h    ;A9      _0
       DB      007h    ;AA      *
       DB      006h    ;AB      +
       DB      020h    ;AC      ,
       DB      00Eh    ;AD      -
       DB      022h    ;AE      .
       DB      026h    ;AF      /
       DB      032h    ;B0      0
       DB      01Fh    ;B1      1
       DB      01Eh    ;B2      2
       DB      01Ah    ;B3      3
       DB      018h    ;B4      4
       DB      01Dh    ;B5      5
       DB      01Bh    ;B6      6
       DB      013h    ;B7      7
       DB      035h    ;B8      8
       DB      030h    ;B9      9
       DB      042h    ;BA      _;
       DB      002h    ;BB      ;
       DB      036h    ;BC      <
       DB      00Fh    ;BD      =
       DB      037h    ;BE      >
       DB      066h    ;BF      _/
       DB      075h    ;C0      _8
       DB      07Fh    ;C1      _A
       DB      055h    ;C2      _B
       DB      052h    ;C3      _C
       DB      07Ah    ;C4      _D
       DB      06Ah    ;C5      _E
       DB      078h    ;C6      _F
       DB      07Dh    ;C7      _G
       DB      079h    ;C8      _H
       DB      04Dh    ;C9      _I
       DB      041h    ;CA      _J
       DB      045h    ;CB      _K
       DB      040h    ;CC      _L
       DB      065h    ;CD      _M
       DB      063h    ;CE      _N
       DB      048h    ;CF      _O
       DB      04Ah    ;D0      _P
       DB      06Fh    ;D1      _Q
       DB      068h    ;D2      _R
       DB      07Eh    ;D3      _S
       DB      06Dh    ;D4      _T
       DB      04Bh    ;D5      _U
       DB      050h    ;D6      _V
       DB      06Eh    ;D7      _W
       DB      056h    ;D8      _X
       DB      06Bh    ;D9      _Y
       DB      057h    ;DA      _Z
       DB      060h    ;DB      _,
       DB      046h    ;DC      _+
       DB      062h    ;DD      _.
       DB      047h    ;DE      _*
       DB      04Eh    ;DF      _-
       DB      000h    ;E0
       DB      03Fh    ;E1      A
       DB      015h    ;E2      B
       DB      012h    ;E3      C
       DB      03Ah    ;E4      D
       DB      02Ah    ;E5      E
       DB      038h    ;E6      F
       DB      03Dh    ;E7      G
       DB      039h    ;E8      H
       DB      00Dh    ;E9      I
       DB      001h    ;EA      J
       DB      005h    ;EB      K
       DB      000h    ;EC      L
       DB      025h    ;ED      M
       DB      023h    ;EE      N
       DB      008h    ;EF      O
       DB      00Ah    ;F0      P
       DB      02Fh    ;F1      Q
       DB      028h    ;F2      R
       DB      03Eh    ;F3      S
       DB      02Dh    ;F4      T
       DB      03Bh    ;F5      U
       DB      010h    ;F6      V
       DB      02Eh    ;F7      W
       DB      016h    ;F8      X
       DB      02Bh    ;F9      Y
       DB      017h    ;FA      Z
       DB      082h    ;FB      ^;
       DB      04Fh    ;FC      _=
       DB      08Eh    ;FD      ^2
       DB      0B4h    ;FE      ^BSP
       DB      0B7h    ;FF      ^>

;******** *********************************************************************
;
;	Define the end of the Emulator Code Segment
;
;******************************************************************************
Emulate Ends
	End				; End of the Hardware module
