%TITLE          "APPEND   - Glue 2 strings together - CHiPS bv 1998"
;**********************************************************************
;**                                                                  **
;**  Program   : APPEND                                              **
;**  Purpose   : Glue 2 strings together                             **
;**                                                                  **
;**  Author    : B.F. Schreurs                                       **
;**              Computer High Performance Software (CHiPS) bv       **
;**  Date      : August 27th, 1998                                   **
;**                                                                  **
;**  Calls     : [None]                                              **
;**                                                                  **
;**  Language  : Turbo Assembler                                     **
;**                                                                  **
;**  Returncode: 0 - Append Successful                               **
;**                                                                  **
;**********************************************************************
        IDEAL
        JUMPS

;----------------------------------------------------------------------
;--  Functions which can be called                                   --
;----------------------------------------------------------------------
        PUBLIC  APPEND

;----------------------------------------------------------------------
;--  Equates                                                         --
;----------------------------------------------------------------------
include ".\equ\sysdep.equ"

;**********************************************************************
SEGMENT SSeg Para Stack 'STACK'
;**********************************************************************

        db        64 dup (0)            ; Stack

ENDS    SSeg



;**********************************************************************
SEGMENT DSeg Word Public 'DATA'
;**********************************************************************

;----------------------------------------------------------------------
;--  Working Storage                                                 --
;----------------------------------------------------------------------
GLOBAL Return_Code:Byte:1

Parm_Append_Field_ptr_ds        DW    1 dup (NULL)
Parm_Append_Field_ptr_si        DW    1 dup (NULL)

ENDS    DSeg



;**********************************************************************
SEGMENT CSeg Word Public 'CODE'
;**********************************************************************

;**********************************************************************
PROC    APPEND
;**********************************************************************
        ASSUME  cs:CSeg
        ASSUME  ds:DSeg
        mov     ax, DSeg                    ; Initialize DS to address
        mov     ds, ax                      ; of data segment

        mov     bx, sp

;
; Append to this field
;
        mov     di, [ss:bx+12]
        mov     es, [ss:bx+14]

;
; Size of that field
;
        mov     cx, [ss:bx+10]

;
; Append field
;
        mov     dx, [ss:bx+6]
        mov     ax, [ss:bx+8]

        mov     [Parm_Append_Field_ptr_ds], ax
        mov     [Parm_Append_Field_ptr_si], dx

;
; Append size
;
        mov     dx, [ss:bx+4]

;
; Spaces between fields
;
        mov     bx, [ss:bx+2]

;
; Search last nonspace character
;
        dec     cx                              ; Because of null terminator
        add     di, cx                          ; Go to end of path
        std                                     ; Search direction is down
        xor     ax, ax                          ; Reset ax
        mov     al, SPACE                       ; Search for the nonspace character
        repe    scasb                           ; Search uses es:di
        cld                                     ; Cancel the std setting
        inc     di                              ; Pointer adjustment after search
        inc     di                              ; Point to after the "\"
        add     di ,bx                          ; Spaces to add

        mov     cx, dx                          ; Nr of bytes to append

        push    ds si

        mov     si, [Parm_Append_Field_ptr_si]
        mov     ds, [Parm_Append_Field_ptr_ds]

        rep     movsb

        pop     si ds

;
; Init return code
;
        mov     al, NULL
        mov     [Return_Code], al

        ret

ENDP    Append



ENDS    CSeg                                ; End of Code segment

END                                         ; End of Program
