%TITLE          "DIR2ATR - Convert pc directory into Atari XL/XE ATR disk image(s) - CHiPS bv 1998"
;**********************************************************************
;**                                                                  **
;**  Program   : DIR2ATR v05.07.00                                   **
;**  Purpose   : Convert pc directory into                           **
;**              Atari XL/XE ATR disk image(s)                       **
;**                                                                  **
;**  Author    : B.F. Schreurs                                       **
;**              Computer High Performance Software (CHiPS) bv       **
;**  Date      : May 19th, 1998                                      **
;**                                                                  **
;**  Calls     : DC_DIRS  - Determine Current Directories            **
;**              DC_DRV   - Determine Current Drives                 **
;**              DC_FILES - Determine Current Files                  **
;**              D_FILDSK - Add current dir files to XL/XE ATR image **
;**              FMSIO    - File Management System Handler           **
;**              HEX2DIGI - Convert Hex Data To Digits (Text)        **
;**              TO_UPPER - Convert a string to uppercase            **
;**              WSIO     - Screen Handler                           **
;**                                                                  **
;**  Language  : Turbo Assembler                                     **
;**  Version   : 3.00.00, added drive selection support in config.   **
;**              4.00.00, FMSIO added.                               **
;**              5.00.00, Subdirectories support added.              **
;**                                                                  **
;**  CLI syntax: DIR2ATR Indir Outdisk Medium Atrxfd Type Incldirs   **
;**              i.e.                                                **
;**              DIR2ATR C:\TEST\*.* C:\020.ATR S A S Y              **
;**              i.e.                                                **
;**              Indir   = C:\TEST\*.*                               **
;**              Outdisk = C:\020.ATR                                **
;**              Medium  = S = Single density disk                   **
;**                        M = Medium                                **
;**                        D = Double                                **
;**                        Q = Quad                                  **
;**                        7 = 720 KB                                **
;**                        1 = 1.44 MB                               **
;**                        H = 16 MB                                 **
;**              Atrxfd  = A = ATR disk image                        **
;**                        X = XFD                                   **
;**              Type    = D = Dos 2.5 disk type                     **
;**                        M = MyDos 4.53                            **
;**                        S = SpartaDos 3.3a                        **
;**                        X = SpartaDos/X                           **
;**                        B = BeweDos 1.30                          **
;**                        O = Your own Dos                          **
;**                        Y = Your own SpartaDos                    **
;**              Incldirs= Y = Include subdirectories                **
;**                        N = Do NOT include subdirectories         **
;**                                                                  **
;**********************************************************************
        IDEAL
        JUMPS

;----------------------------------------------------------------------
;--  Equates                                                         --
;----------------------------------------------------------------------
include ".\equ\attrib.equ"
include ".\equ\dos.equ"
include ".\equ\equipmnt.equ"
include ".\equ\fmsio.equ"
include ".\equ\keyboard.equ"
include ".\equ\sysdep.equ"
include ".\equ\video.equ"
include ".\equ\wsio.equ"

EXTRA_TABLE_FIELDS                      EQU     16
DIR_MAP_LENGTH                          EQU (MAX_DIRS_AND_FILES + EXTRA_TABLE_FIELDS) * DIR_ENTRY_LENGTH
COMMENT_ROW                             EQU    "#"
CONFIG_PARAMETERS                       EQU      9      ; Max 9 parameters
CONFIG_FILE_ROW_COUNT                   EQU     80
CONFIG_FILE_LINE_SIZE                   EQU    256
CLI_OFFSET_COMMAND_TAIL                 EQU    130

DISK_MEDIA_TYPE_SINGLE                  EQU     "S"
DISK_MEDIA_TYPE_MEDIUM                  EQU     "M"
DISK_MEDIA_TYPE_DOUBLE                  EQU     "D"
DISK_MEDIA_TYPE_QUAD                    EQU     "Q"
DISK_MEDIA_TYPE_720KB                   EQU     "7"
DISK_MEDIA_TYPE_1440KB                  EQU     "1"
DISK_MEDIA_TYPE_HARDDISK                EQU     "H"

DISK_FORMAT_TYPE_DOS25                  EQU     "D"
DISK_FORMAT_TYPE_MYDOS                  EQU     "M"
DISK_FORMAT_TYPE_MYOWNDOS_MYDOS         EQU     "O"
DISK_FORMAT_TYPE_BEWEDOS                EQU     "B"
DISK_FORMAT_TYPE_SPARTADOS              EQU     "S"
DISK_FORMAT_TYPE_SPARTADOSX             EQU     "X"
DISK_FORMAT_TYPE_MYOWNDOS_SPARTADOS     EQU     "Y"

DISK_IMAGE_TYPE_ATR                     EQU     "A"
DISK_IMAGE_TYPE_XFD                     EQU     "X"

INCLUDE_SUBDIRS_YES                     EQU     "Y"
INCLUDE_SUBDIRS_NO                      EQU     "N"

;**********************************************************************
SEGMENT SSeg Para Stack 'STACK'
;**********************************************************************

        db       128 dup (0)            ; Stack

ENDS    SSeg

;**********************************************************************
SEGMENT DSeg Word Public 'DATA'
;**********************************************************************

;----------------------------------------------------------------------
;--  Structures                                                      --
;----------------------------------------------------------------------
include ".\str\dta.str"
include ".\str\fmsio.str"
include ".\str\position.str"
include ".\str\psp.str"
include ".\str\wsio.str"

;----------------------------------------------------------------------
;--  SELECT and FD                                                   --
;----------------------------------------------------------------------
;
; Configuration File
;
CONFIG___File                   FMS_Area <>
CONFIG___Pathname               DB  "C:\DIR2ATR.CFG"
                                DB  PATH_LENGTH - 14   dup (SPACE)
                                DB    1 dup (0)
CONFIG___Data_Buffer            DB  CONFIG_FILE_LINE_SIZE + 2  dup (NULL)

;----------------------------------------------------------------------
;--  Working Storage                                                 --
;----------------------------------------------------------------------
GLOBAL Return_Code:Byte:1

Return_Code                     DB    0
Allocation_Strategy_Old         DW    NULL
Allocation_Strategy_New         DW    NULL

;------------------------------
; Command Line Interface fields
;------------------------------
CLI_Used                        DB    LOGIC_NO          ; CLI interface not active
CLI_Command_Tail_Size           DW    0
CLI_Command_Tail                DB    PATH_LENGTH       dup (SPACE)
                                DB    NULL
CLI_Indir                       DB    PATH_LENGTH       dup (SPACE)
                                DB    NULL
CLI_Outdisk                     DB    PATH_LENGTH       dup (SPACE)
                                DB    NULL
CLI_Disk_Density                DB    DISK_MEDIA_TYPE_SINGLE
CLI_Atr_Or_Xfd                  DB    DISK_IMAGE_TYPE_ATR
CLI_Disk_Format                 DB    DISK_FORMAT_TYPE_DOS25  
CLI_Include_Subdirs             DB    INCLUDE_SUBDIRS_NO
CLI_Error                       DB    LOGIC_NO          ; 0=No Error
                                                        ; 1=Error Encountered

Requested_Format_Drives         DB   "1"                ; 1 = "ABCDEFGHIJKL    " etc.
                                                        ; 2 = "A: [Floppy     ]"
                                                        ;     "C: [HARD_DRIVE ]" etc.
Requested_Format_LibFil         DB   "1"                ; 1 = DIRENTRY format    etc.
                                                        ; 2 = "..           <DIR>      "
                                                        ;     "ATARI        <DIR>      "
Hex2digi_Requested_Format       DB  "2"                 ; "1" = With thousand seperator
                                                        ; "2" = Mo thousand seperator
Media_Id_Buffer                 DB   25 dup (NULL)
Available_Drives                DB  MAX_DRIVES          dup (SPACE)
                                DB  SPACE
Directories_File_Mask           DB   "*.*         "
Search_Files_Path               DB  PATH_LENGTH         dup (SPACE)
                                DB  NULL                ; To satisfy DOS find file
Search_Dirs_Path                DB  PATH_LENGTH         dup (SPACE)
                                DB  NULL
Search_Filemask                 DB  FILE_NAME_LENGTH    dup (SPACE)

Buffer_Sense_Media_Type         DW    1 dup (NULL)
Save_cx                         DW    ?
Dir_Memo_Occur_Curr             DW  MAX_DIRS dup (NULL) ; Remember from which dir we came
Dir_Memo_Occur_W_Curr           DW  MAX_DIRS dup (NULL) ; Remember from which dir we came
Dir_Memo_Pointer                DB    0
Dir_Up                          DB    0                 ; 0=Stay current
                                                        ; 1=Go dir up
                                                        ; 2=Go dir down
Disk_Present                    DB  LOGIC_NO
Mouse_Pressed                   DB  LOGIC_NO
Attrib_Non_modifiable           DB  ATTRIB_GREEN_WHITE
Parm_Being_Processed            DB    0
Config_File_Bytes_Reserved      DW    0

Old_Dta_Seg                     DW    ?                 ; Old Dta Segment Address
Old_Dta_Ofs                     DW    ?                 ; Old Dta Segment Offset
Own_Dta                         Dta <>

;----------------------------------------------------------------------
;--                                                                  --
;--  C O N F I G U R A T I O N   F I L E   F O R   D I R 2 A T R     --
;--                                                                  --
;----------------------------------------------------------------------
Config_Field_Filemask           DB    "*.*         "
Default_Startup_Path            DB  "C:\"
                                DB  PATH_LENGTH - 3   dup (SPACE)
                                DB  NULL
Config_Startup_Path             DB  PATH_LENGTH  dup (SPACE)
                                DB  NULL
                                DB  NULL
Config_Include_DOSFILES_YN      DB   1            dup (LOGIC_YES)
Config_Include_DUP_SYS_YN       DB   1            dup (LOGIC_YES)
Config_MAIN_YN                  DB   1            dup (LOGIC_YES)



;--------------
; Config Fields
;--------------
Config_Field_Read_From          DB  "*"
                                DB  MAX_DRIVES  - 1   dup (SPACE)
                                DB   1            dup (0)
Config_Field_Write_To           DB  "*"
                                DB  PATH_LENGTH - 1   dup (SPACE)
                                DB  NULL
Config_Field_Disk_Density       DB   "M"
                                DB   1            dup (0)
Config_Field_ATR_Or_XFD         DB   "A"
                                DB   1            dup (0)
Config_Field_DOS_Path           DB  "C:\DIR2ATR\"
                                DB  PATH_LENGTH - 11  dup (SPACE)
                                DB  NULL
Config_Field_Disk_Format        DB   "D"
                                DB   1            dup (0)
Config_Field_Include_DOS        DB   "Y"
                                DB   1            dup (0)
Config_Field_Include_DUP_SYS    DB   "Y"
                                DB   1            dup (0)
Config_Field_MAIN               DB   "Y"
                                DB   1            dup (0)



;----------------------------------------------------------------------
;--                                                                  --
;--  S C R E E N S   S E C T I O N                                   --
;--                                                                  --
;----------------------------------------------------------------------
Filler                  DB   64 dup (" ")

;**********************************************************************
; B a c k G r o u n d                                                 *
;**********************************************************************
Ws_BG                   DB    WSIO_OPEN
                        DB    1                 ; Start of screen ROW
                        DB    1                 ; Start of screen COLUMN
                        DB   25                 ; End of screen ROW
                        DB   80                 ; End of screen COLUMN
                        DB    ATTRIB_BLUE_WHITE ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Input attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Enter Keys  Address HIGH
                        DW    ?                 ; Enter Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_BG_Name              DB    "BG      "
Ws_BG_Keys              DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_BG_Text              DB    "ͻ"
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "ͼ"
                        DB    NULL

;**********************************************************************
; F r e e W a r e                                                     *
;**********************************************************************
Ws_FW                   DB    WSIO_DISPLAY_ONLY
                        DB    3                 ; Start of screen ROW
                        DB   28                 ; Start of screen COLUMN
                        DB   24                 ; End of screen ROW
                        DB   79                 ; End of screen COLUMN
                        DB    ATTRIB_CYAN_WHITE ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Input attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Enter Keys  Address HIGH
                        DW    ?                 ; Enter Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_FW_Name              DB    "FREEWARE"
Ws_FW_Keys              DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_FW_Text              DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "   DIR2ATR - Convert pc dir into .ATRs - v05.07.00  "
                        DB                               "                                                    "
                        DB                               "   by B.F. Schreurs, February 22nd, 1999, CHiPS bv  "
                        DB                               "   Computer High Performance Software - Freeware    "
                        DB                               "   Email: stack@xs4all.nl                           "
                        DB                               "   Homepage: http:\\www.xs4all.nl\~stack            "
                        DB                               "                                                    "
                        DB                               "   Please select the appropiate Directory           "
                        DB                               "   (and Drive) to be converted into .ATR disks.     "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB    NULL

;**********************************************************************
; P A t h                                                             *
;**********************************************************************
Ws_PA                   DB    WSIO_DISPLAY_ONLY
                        DB    2                 ; Start of screen ROW
                        DB    2                 ; Start of screen COLUMN
                        DB    2                 ; End of screen ROW
                        DB   79                 ; End of screen COLUMN
                        DB    ATTRIB_BLUE_WHITE ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Input attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Enter Keys  Address HIGH
                        DW    ?                 ; Enter Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_PA_Name              DB    "PATH    "
Ws_PA_Keys              DB    KEY_ESC, KEY_ENTER, KEY_ARROW_LEFT, KEY_ARROW_RIGHT
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_PA_Text              DB    "Path:                                                                          "
                        DB    NULL
;------------
; F I E L D S
;------------
;
; Path Specification
;
Ws_PA_F_Path            DB    1                 ; Relative ROW, NULL=End
                        DB    7                 ; Relative COLUMN 
                        DB   72                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Protected
                        DB    0                 ; <Mouse Sensitive>
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_PA_No_More_Fields    DB    NULL

;--------
; D A T A
;--------
; See Search Files Path

;**********************************************************************
; D R i v e   S e l e c t i o n                                       *
;**********************************************************************
Ws_DR                   DB    WSIO_DISPLAY_ONLY
                        DB    3                 ; Start of screen ROW
                        DB    2                 ; Start of screen COLUMN
                        DB   24                 ; End of screen ROW
                        DB   27                 ; End of screen COLUMN
                        DB    ATTRIB_BLUE_WHITE ; Screen attribute
                        DB    ATTRIB_BLUE_WHITE ; Field attribute
                        DB    ATTRIB_GREEN_WHITE  ; Select attribute
                        DB    0                 ; Error attribute
                        DB    1                 ; Mouse support
                        DB    1                 ; Locate cursor at field
                        DB    1                 ; Locate cursor at occurrence
                        DB    1                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Enter Keys  Address HIGH
                        DW    ?                 ; Enter Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_DR_Name              DB    "DRIVES  "
Ws_DR_Keys              DB    KEY_ESC,      KEY_ENTER
                        DB    KEY_HELP,                     KEY_F4
                        DB    KEY_ARROW_UP, KEY_ARROW_DOWN
                        DB    KEY_PAGE_UP,  KEY_PAGE_DOWN
                        DB    KEY_HOME,     KEY_END
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_DR_Text              DB     "[Select Drive]ͻ"
                        DB     "    A: [FLOPPYDRIVE]    "
                        DB     "    C: [MY_VOLUME  ]    "
                        DB     "    D: [MY_CDROM   ]    "
                        DB     "    E: [NET_DRIVE  ]    "
                        DB     "    Z: [RAM_DISK   ]    "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "ENTER=Select Esc=Cancel "
                        DB     "F1=Help F4=Cfg          "
                        DB     "ͼ"
                        DB    NULL
;------------
; F I E L D S
;------------
;
; Drive Table
;
Ws_DR_F_Drive           DB    2                 ; Relative ROW, NULL=End
                        DB    6                 ; Relative COLUMN 
                        DB   16                 ; Field Size
                        DB   17                 ; Nr of occurrences
                        DW    0                 ; This is a table, not part of a table
                        DB    0                 ; Protected
                        DB    KEY_ENTER         ; Mouse sensitive
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DR_F_Key_Enter       DB   20                 ; Relative ROW, NULL=End
                        DB    2                 ; Relative COLUMN 
                        DB   12                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    KEY_ENTER         ; Emulate Key Esc
                        DB    0                 ; Edit External
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DR_F_Key_Esc         DB   20                 ; Relative ROW, NULL=End
                        DB   15                 ; Relative COLUMN 
                        DB   10                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    KEY_ESC           ; Emulate Key Esc
                        DB    0                 ; Edit External
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DR_F_Key_Help        DB   21                 ; Relative ROW, NULL=End
                        DB    2                 ; Relative COLUMN 
                        DB    7                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    KEY_HELP          ; Emulate Key F1
                        DB    0                 ; Edit External
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DR_F_Key_Cfg         DB   21                 ; Relative ROW, NULL=End
                        DB   11                 ; Relative COLUMN 
                        DB    6                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    KEY_F4            ; Emulate Key F4
                        DB    0                 ; Edit External
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DR_No_More_Fields    DB    NULL

;--------
; D A T A
;--------
;
; Drive Table
;
Ws_DR_D_Drive           DB    MAX_DRIVES + EXTRA_TABLE_FIELDS dup ("                ")

;--------------------
; W O R K F I E L D S
;--------------------
Ws_DR_Occur_Curr        DW    ?
Ws_DR_Occur_Max         DW    ?                 ; Maximum nr of drives present
Ws_DR_Occur_W_Curr      DW    ?
WS_DR_OCCUR_W_CURR_MAX  DW   17                 ; Maximum occurrences per window

Ws_DR_D_Key_Enter       DB   "Enter=Select"
Ws_DR_D_Key_Esc         DB   "Esc=Cancel"
Ws_DR_D_Key_Help        DB   "F1=Help"
Ws_DR_D_Key_Cfg         DB   "F4=Cfg"



;**********************************************************************
; D r i v e   H e l p   S c r e e n                                   *
;**********************************************************************
Ws_DH                   DB    WSIO_DISPLAY_ONLY
                        DB    3                 ; Start of screen ROW
                        DB    2                 ; Start of screen COLUMN
                        DB   24                 ; End of screen ROW
                        DB   27                 ; End of screen COLUMN
                        DB    ATTRIB_GREEN_WHITE ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Select attribute
                        DB    0                 ; Error attribute
                        DB    1                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Enter Keys  Address HIGH
                        DW    ?                 ; Enter Keys  Address LOW
                        DW    NULL              ; Field Area  Address HIGH
                        DW    NULL              ; Field Area  Address LOW
Ws_DH_Name              DB    "DRIVEHLP"
Ws_DH_Keys              DB    KEY_ANY
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_DH_Text              DB     "[Drive Help]ͻ"
                        DB     "                        "
                        DB     "ENTER = Select drive    "
                        DB     "", ARROW_UP, "     = Previous drive  "
                        DB     "", ARROW_DOWN, "     = Next drive      "
                        DB     "Home  = First drive     "
                        DB     "End   = Last drive      "
                        DB     "Pg Up = Previous drives "
                        DB     "Pg Dn = Next drives     "
                        DB     "F1    = This screen     "
                        DB     "F4    = Config setup    "
                        DB     "Esc   = Cancel          "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "Press any key to exit   "
                        DB     "ͼ"
                        DB    NULL

;**********************************************************************
; L i b r a r y   F i l e   S e l e c t i o n                         *
;**********************************************************************
Ws_LF                   DB    WSIO_DISPLAY_ONLY
                        DB    3                 ; Start of screen ROW
                        DB    2                 ; Start of screen COLUMN
                        DB   24                 ; End of screen ROW
                        DB   27                 ; End of screen COLUMN
                        DB    ATTRIB_BLUE_WHITE ; Screen attribute
                        DB    ATTRIB_BLUE_WHITE ; Field attribute
                        DB    ATTRIB_GREEN_WHITE  ; Select attribute
                        DB    0                 ; Error attribute
                        DB    1                 ; Mouse support
                        DB    1                 ; Locate cursor at field
                        DB    1                 ; Locate cursor at occurrence
                        DB    1                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Enter Keys  Address HIGH
                        DW    ?                 ; Enter Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_LF_Name              DB    "LIBFILES"
Ws_LF_Keys              DB    KEY_ESC,      KEY_ENTER
                        DB    KEY_HELP,     KEY_F2,        KEY_F3,      KEY_F4
                        DB    KEY_ARROW_UP, KEY_ARROW_DOWN
                        DB    KEY_PAGE_UP,  KEY_PAGE_DOWN
                        DB    KEY_HOME,     KEY_END
                        DB    KEY_CTL_A_Z
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_LF_Text              DB     "[Select Dir/Image]", ARROW_UP, ARROW_DOWN, ""
                        DB     "..           <DIR>      "
                        DB     "ASM          <DIR>      "
                        DB     "EQUAL        <DIR>      "
                        DB     "MYDIR        <DIR>      "
                        DB     "PROJECT .TOO <DIR>      "
                        DB     "ATARI   .ATR 123,456,789"
                        DB     "MY      .ATR  12,345,678"
                        DB     "YOUR    .ATR   1,234,567"
                        DB     "ZZZZZZZZ.ATR     123,456"
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "ENTER=Select Esc=Cancel "
                        DB     "F1=Help F2=CurDir F3=Drv"
                        DB     "ͼ"
                        DB    NULL
;------------
; F I E L D S
;------------
;
; Directories/Images Table
;
Ws_LF_F_Dir_Fil         DB    2                 ; Relative ROW, NULL=End
                        DB    2                 ; Relative COLUMN 
                        DB   24                 ; Field Size
                        DB   17                 ; Nr of occurrences
                        DW    0                 ; This is a table, not part of a table
                        DB    0                 ; Protected
                        DB    KEY_ENTER         ; Mouse sensitive
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_LF_F_Page_Up         DB    1                 ; Relative ROW, NULL=End
                        DB   24                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is a table, not part of a table
                        DB    0                 ; Protected
                        DB    KEY_PAGE_UP       ; Mouse sensitive
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    NULL              ; Source Hi
                        DW    NULL              ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_LF_F_Page_Down       DB    1                 ; Relative ROW, NULL=End
                        DB   25                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is a table, not part of a table
                        DB    0                 ; Protected
                        DB    KEY_PAGE_DOWN     ; Mouse sensitive
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    NULL              ; Source Hi
                        DW    NULL              ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_LF_F_Key_Enter       DB   20                 ; Relative ROW, NULL=End
                        DB   02                 ; Relative COLUMN 
                        DB   12                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    KEY_ENTER         ; Emulate Enter
                        DB    0                 ; Edit External
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_LF_F_Key_Esc         DB   20                 ; Relative ROW, NULL=End
                        DB   15                 ; Relative COLUMN 
                        DB   10                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    KEY_ESC           ; Emulate Enter
                        DB    0                 ; Edit External
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_LF_F_Key_Help        DB   21                 ; Relative ROW, NULL=End
                        DB    2                 ; Relative COLUMN 
                        DB    7                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    KEY_HELP          ; Emulate Key F1
                        DB    0                 ; Edit External
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_LF_F_Key_CurDir      DB   21                 ; Relative ROW, NULL=End
                        DB   10                 ; Relative COLUMN 
                        DB    9                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    KEY_F2            ; Emulate Key F2
                        DB    0                 ; Edit External
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_LF_F_Key_Drv         DB   21                 ; Relative ROW, NULL=End
                        DB   20                 ; Relative COLUMN 
                        DB    6                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    KEY_F3            ; Emulate Key F3
                        DB    0                 ; Edit External
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_LF_No_More_Fields    DB    NULL

;--------
; D A T A
;--------
;
; Dir / Fil Table
;
Dir_Map_ptr_es          DW    1 dup (NULL)      ; Segment 1
Dir_Map_ptr_di          DW    1 dup (NULL)

Ws_LF_D_Key_Enter       DB   "Enter=Select"
Ws_LF_D_Key_Esc         DB   "Esc=Cancel"
Ws_LF_D_Key_Help        DB   "F1=Help"
Ws_LF_D_Key_CurDir      DB   "F2=CurDir"
Ws_LF_D_Key_Drv         DB   "F3=Drv"

;--------------------
; W O R K F I E L D S
;--------------------
Ws_LF_Occur_Curr        DW    ?
Ws_LF_Occur_Max         DW    ?                 ; Maximum nr of entries present
Ws_LF_Occur_W_Curr      DW    ?
WS_LF_OCCUR_W_CURR_MAX  DW   17                 ; Maximum occurrences per window

;**********************************************************************
; L i b r a r y   F i l e   H e l p   S c r e e n                     *
;**********************************************************************
Ws_LH                   DB    WSIO_DISPLAY_ONLY
                        DB    3                 ; Start of screen ROW
                        DB    2                 ; Start of screen COLUMN
                        DB   24                 ; End of screen ROW
                        DB   27                 ; End of screen COLUMN
                        DB    ATTRIB_GREEN_WHITE ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Select attribute
                        DB    0                 ; Error attribute
                        DB    1                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Enter Keys  Address HIGH
                        DW    ?                 ; Enter Keys  Address LOW
                        DW    NULL              ; Field Area  Address HIGH
                        DW    NULL              ; Field Area  Address LOW
Ws_LH_Name              DB    "LIBHELP "
Ws_LH_Keys              DB    KEY_ANY
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_LH_Text              DB     "[Dir/Image Help]ͻ"
                        DB     "                        "
                        DB     "ENTER = Select Dir/Image"
                        DB     "", ARROW_UP, "     = Prev Dir/Image  "
                        DB     "", ARROW_DOWN, "     = Next Dir/Image  "
                        DB     "Home  = First Dir/Image "
                        DB     "End   = Last Dir/Image  "
                        DB     "Pg Up = Prev Dirs/Images"
                        DB     "Pg Dn = Next Dirs/Images"
                        DB     "F1    = This screen     "
                        DB     "F2    = Select Curr Dir "
                        DB     "F3    = Go to drive scrn"
                        DB     "F4    = Config setup    "
                        DB     "Esc   = Exit Program    "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "Press any key to exit   "
                        DB     "ͼ"
                        DB    NULL

;**********************************************************************
; C o n f i g u r a t i o n   F I l e   S p e c i f i c a t i o n     *
;**********************************************************************
Ws_CF                   DB    WSIO_DISPLAY_AND_READ
                        DB    1                 ; Start of screen ROW
                        DB    1                 ; Start of screen COLUMN
                        DB   25                 ; End of screen ROW
                        DB   80                 ; End of screen COLUMN
                        DB    ATTRIB_CYAN_WHITE ; Screen attribute
                        DB    ATTRIB_BLUE_WHITE ; Field attribute
                        DB    ATTRIB_BLUE_WHITE ; Input attribute
                        DB    0                 ; Error attribute
                        DB    1                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    0                 ; Go to first          
                        DB    0                 ; modifiable field
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Enter Keys  Address HIGH
                        DW    ?                 ; Enter Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_CF_Name              DB    "CONFIG  "
Ws_CF_Keys_No_Config    DB    KEY_F2
                        DB    NULL
Ws_CF_Keys              DB    KEY_ESC, KEY_ENTER,   KEY_F2
                        DB    NULL
Ws_CF_Enter_Keys        DB    KEY_F2
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_CF_Text              DB    "[Configuration Setup]ͻ"
                        DB    "Startup Drives       : xxxxxxxxxxxxxxxxxxxxxxxxxx                             "
                        DB    "                       Use a '*' to scan all available drives,                "
                        DB    "                       or specify the dirve letters to scan, i.e. 'CDE'.      "
                        DB    "Currently Active     : xxxxxxxxxxxxxxxxxxxxxxxxxx                             "
                        DB    "                       Shows the drives who are currently available,          "
                        DB    "                       and is always a subset of the Startup Drives specified."
                        DB    "Disk Images Location : xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx "
                        DB    "                       Use a '*' to use the current drive/directory,          "
                        DB    "                       or specify the drive/directory, i.e. 'C:\MYDIR\'.      "
                        DB    "Disk Density to use  : x                                                      "
                        DB    "                       S=Single, M=Medium, D=Double, Q=Quad,                  "
                        DB    "                       7=720 KB disk, 1=1.44 MB disk, H=16 MB harddisk        "
                        DB    "Create ATR/XFD disks : x  [A=.ATR disks, X=.XFD disks]                        "
                        DB    "Specify DOS File path: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx "
                        DB    "                       I.e 'C:\DIR2ATR\', the program will add 'DOS25\' etc.  "
                        DB    "Disk Format to use   : x                                                      "
                        DB    "                       D=DOS 2.5, M=MYDOS 4.53, B=BEWEDOS, O=MY OWN DOS (DOS),"
                        DB    "                       S=SPARTADOS 3.3a, X=SPARTADOS/X, Y=MY OWN DOS (SPARTA) "
                        DB    "Write DOS Files      : x  [Y=Yes, N=No]                                       "
                        DB    "                       Write DUP.SYS file: x  [Y=Yes, N=No]                   "
                        DB    "Use SpartaDos 'MAIN' : x  [Y=Yes, N=No, use Pc directory name]                "
                        DB    "                                                                              "
                        DB    "ENTER=Save   F2=Update Configuration File C:\DIR2ATR.CFG   Esc=Cancel         "
                        DB    "ͼ"
                        DB    NULL
;------------
; F I E L D S
;------------
;
; Startup Drives
;
Ws_CF_F_Read_From       DB    2                 ; Relative ROW, NULL=End
                        DB   25                 ; Relative COLUMN 
                        DB   26                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    0                 ; Not mouse sensitive
                        DB    0                 ; Edit External
                        DB    1                 ; Blanks Trailing
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>
;
; Actives Drives
;
Ws_CF_F_Active          DB    5                 ; Relative ROW, NULL=End
                        DB   25                 ; Relative COLUMN 
                        DB   26                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Non-modifiable
                        DB    0                 ; Not mouse sensitive
                        DB    3                 ; Edit Letters
                        DB    1                 ; Blanks Trailing
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>
;
; Source Path
;
Ws_CF_F_Write_To        DB    8                 ; Relative ROW, NULL=End
                        DB   25                 ; Relative COLUMN 
                        DB   54                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    0                 ; Not mouse sensitive
                        DB    6                 ; Edit Filemask
                        DB    1                 ; Blanks Trailing
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

;
; Disk density to use
;
Ws_CF_F_Disk_Density    DB   11                 ; Relative ROW, NULL=End
                        DB   25                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    0                 ; Not mouse sensitive
                        DB    0                 ; Edit External
                        DB    1                 ; Blanks Trailing
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

;
; Create .ATR or XFD disk images
;
Ws_CF_F_ATR_Or_XFD      DB   14                 ; Relative ROW, NULL=End
                        DB   25                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    0                 ; Not mouse sensitive
                        DB    0                 ; Edit External
                        DB    1                 ; Blanks Trailing
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

;
; DOS path location, i.e. C:\DIR2ATR\
;
Ws_CF_F_DOS_Path        DB   15                 ; Relative ROW, NULL=End
                        DB   25                 ; Relative COLUMN 
                        DB   54                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    0                 ; Not mouse sensitive
                        DB    6                 ; Edit Filemask
                        DB    1                 ; Blanks Trailing
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

;
; Disk Format?
;
Ws_CF_F_Disk_Format     DB   17                 ; Relative ROW, NULL=End
                        DB   25                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    0                 ; Not mouse sensitive
                        DB    0                 ; Edit External
                        DB    1                 ; Blanks Trailing
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

;
; Include DOS?
;
Ws_CF_F_Include_DOS     DB   20                 ; Relative ROW, NULL=End
                        DB   25                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    0                 ; Not mouse sensitive
                        DB    0                 ; Edit External
                        DB    1                 ; Blanks Trailing
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

;
; Include DUP.SYS file?
;
Ws_CF_F_Include_DUP_SYS DB   21                 ; Relative ROW, NULL=End
                        DB   45                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    0                 ; Not mouse sensitive
                        DB    0                 ; Edit External
                        DB    1                 ; Blanks Trailing
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

;
; Use SpartaDos "MAIN" dir
;
Ws_CF_F_MAIN            DB   22                 ; Relative ROW, NULL=End
                        DB   25                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    0                 ; Not mouse sensitive
                        DB    0                 ; Edit External
                        DB    1                 ; Blanks Trailing
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_CF_F_Key_Enter       DB   24                 ; Relative ROW, NULL=End
                        DB    2                 ; Relative COLUMN 
                        DB   10                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    KEY_ENTER         ; Emulate Enter
                        DB    0                 ; Edit External
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_CF_F_Key_Update      DB   24                 ; Relative ROW, NULL=End
                        DB   15                 ; Relative COLUMN 
                        DB   43                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    KEY_F2            ; Emulate Key F2
                        DB    0                 ; Edit External
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_CF_F_Key_Esc         DB   24                 ; Relative ROW, NULL=End
                        DB   61                 ; Relative COLUMN 
                        DB   10                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    KEY_ESC           ; Emulate Enter
                        DB    0                 ; Edit External
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_CF_No_More_Fields    DB    NULL

;--------
; D A T A
;--------
; See Configuration File Fields
Disk_Density_Field      DB   "SMDQ71H"
                        DB  NULL
Disk_Format_Field       DB   "DMBOSXY"
                        DB  NULL
ATR_Or_XFD_Field        DB   "AX"
                        DB  NULL
Yes_No_Field            DB   "YN"
                        DB  NULL
Drives_Field            DB   "*ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                        DB  NULL

Ws_CF_D_Key_Enter       DB   "ENTER=Save"
Ws_CF_D_Key_Esc         DB   "Esc=Cancel"
Ws_CF_D_Key_Update      DB   "F2=Update Configuration File C:\DIR2ATR.CFG"



;**********************************************************************
; E R R O R - D R I V E   N O T   R E A D Y                           *
;**********************************************************************
Ws_E1                   DB    WSIO_DISPLAY_ONLY
                        DB   10                 ; Start of screen ROW
                        DB   41                 ; Start of screen COLUMN
                        DB   16                 ; End of screen ROW
                        DB   66                 ; End of screen COLUMN
                        DB    ATTRIB_RED_WHITE  ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Select attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Enter Keys  Address HIGH
                        DW    ?                 ; Enter Keys  Address LOW
                        DW    NULL              ; Field Area  Address HIGH
                        DW    NULL              ; Field Area  Address LOW
Ws_E1_Name              DB    "ERROR1  "
Ws_E1_Keys              DB    KEY_ANY
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_E1_Text              DB                                             "[Drive Not Ready]ͻ"
                        DB                                             "                        "
                        DB                                             "  There is NO media in  "
                        DB                                             "  the requested drive!  "
                        DB                                             "                        "
                        DB                                             "Press any key to confirm"
                        DB                                             "ͼ"
                        DB    NULL



;**********************************************************************
; E R R O R - N O   V A L I D   D R I V E   P R E S E N T             *
;**********************************************************************
Ws_E2                   DB    WSIO_DISPLAY_ONLY
                        DB   10                 ; Start of screen ROW
                        DB   41                 ; Start of screen COLUMN
                        DB   16                 ; End of screen ROW
                        DB   66                 ; End of screen COLUMN
                        DB    ATTRIB_RED_WHITE  ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Select attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Enter Keys  Address HIGH
                        DW    ?                 ; Enter Keys  Address LOW
                        DW    NULL              ; Field Area  Address HIGH
                        DW    NULL              ; Field Area  Address LOW
Ws_E2_Name              DB    "ERROR2  "
Ws_E2_Keys              DB    KEY_ANY
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_E2_Text              DB                                             "[Drive Not Present]ͻ"
                        DB                                             "                        "
                        DB                                             "  There is NO valid     "
                        DB                                             "  disk drive present!   "
                        DB                                             "                        "
                        DB                                             "Press any key to confirm"
                        DB                                             "ͼ"
                        DB    NULL

;**********************************************************************
; E R R O R - C O M M A N D   L I N E   I N T E R F A C E   E R R O R *
;**********************************************************************
Ws_E3                   DB    WSIO_OPEN
                        DB    9                 ; Start of screen ROW
                        DB   18                 ; Start of screen COLUMN
                        DB   17                 ; End of screen ROW
                        DB   63                 ; End of screen COLUMN
                        DB    ATTRIB_RED_WHITE  ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Select attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Enter Keys  Address HIGH
                        DW    ?                 ; Enter Keys  Address LOW
                        DW    NULL              ; Field Area  Address HIGH
                        DW    NULL              ; Field Area  Address LOW
Ws_E3_Name              DB    "ERROR3  "
Ws_E3_Keys              DB    KEY_ANY
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_E3_Text              DB                     "[Command Line Interface Error]ͻ"
                        DB                     "                                            "
                        DB                     "  The number of specified CLI parameters is "
                        DB                     "  incorrect, or the parameters themselves   "
                        DB                     "  are incorrectly specified. Please refer   "
                        DB                     "  to the documentation file DIR2ATR.TXT.    "
                        DB                     "                                            "
                        DB                     "Press any key to confirm                    "
                        DB                     "ͼ"
                        DB    NULL



ENDS    DSeg



;**********************************************************************
;               Extended Segments
;**********************************************************************
SEGMENT DSeg1 Word Public 'LIBFILES'
Dir_Map                 DB   DIR_MAP_LENGTH dup ("E")

ENDS    DSeg1

;**********************************************************************
SEGMENT CSeg Word Public 'CODE'
;**********************************************************************
;----------------------------------------------------------------------
;--  External Variables                                              --
;----------------------------------------------------------------------
        EXTRN   DC_DIRS:proc            ; Determine Current Directories
        EXTRN   DC_DRV:proc             ; Determine Current Drives
        EXTRN   DC_FILES:proc           ; Determine Current Files
        EXTRN   D_FILDSK:proc           ; Add current directory files to XL/XE ATR image
        EXTRN   FMSIO:proc              ; File Management System Handler
        EXTRN   HEX2DIGI:proc           ; Convert Hex Data To Digits (Text)
        EXTRN   TO_UPPER:proc           ; Convert string to uppercase
        EXTRN   WSIO:proc               ; Screen Handler



;**********************************************************************
Main:   
;**********************************************************************
        ASSUME  cs:CSeg
        ASSUME  ds:DSeg
        mov     ax, DSeg                                ; Initialize DS to address
        mov     ds, ax                                  ; of data segment

        call    Init_Program
        call    Init_Files
        call    Init_Screens
        call    CLI_Check
        cmp     [CLI_Error], LOGIC_YES                  ; Error encounterd?
        je      @@99                                    ; Yes
                                                        ; No, so
        call    Read_Dir2atr_Config_File
        call    Parameter_Processing

        cmp     [CLI_Used], LOGIC_YES                   ; Command Line Interface used?
        je      @@30                                    ; Yes
                                                        ; No, so
        call    Read_VTOC_Drives
        cmp     [Ws_DR_Occur_Max], 0                    ; Any valid drive present?
        je      @@99                                    ; No
                                                        ; Yes, so
        call    Open_Ws_BG
        call    Display_Ws_BG                           ; Display background
        call    Display_Ws_FW                           ; Display freeware message

@@20:
        call    Display_and_Read_Ws_LF                  ; Let user select library
        call    Close_Ws_BG
        jmp     @@99

@@30:
        call    Add_DirFiles_To_ATR_Image

@@99:
        call    Exit_Program



;**********************************************************************
PROC    Init_Program
;**********************************************************************
        push    es                                      ; Save Psp

        xor     ax, ax
        mov	ah, DOS_SET_MEMORY_BLOCK_SIZE           ; resize the psp memory
        xor     bx, bx
        int	DOS_SERVICE

        pop     es                                      ; Restore Psp

        mov     di, CLI_OFFSET_COMMAND_TAIL
        xor     cx, cx                                  ; Reset cx
        mov     cl, [es:Psp.LengthByte]                 ; Check if command line is empty
        mov     [CLI_Command_Tail_Size], cx             ; Save size of command tail
        cmp     cx, NULL                                ; Parameter(s) specified?
        je      @@10                                    ; No
                                                        ; Yes, so
;
; Copy Command Line To File Specification Buffer
;
        push    ds si                                   ; Save program entry

        push    es di                                   ; Save cli data

        mov     si, offset CLI_Command_Tail
        push    ds si
        pop     di es

        pop     si ds                                   ; Restore cli data
        rep     movsb                                   ; Copy Command_Tail

        pop     si ds                                   ; Restore program entry

@@10:
;
; Segment Addressing
;
        ASSUME  ds:DSeg1
        mov     ax, DSeg1                               ; Initialize ds to address
        mov     ds, ax                                  ; of data segment
 
        mov     si, offset Dir_Map
        push    ds si
        pop     di es

        ASSUME  ds:DSeg
        mov     ax, DSeg                                ; Initialize ds to address
        mov     ds, ax                                  ; of data segment

        mov     [Dir_Map_ptr_es], es
        mov     [Dir_Map_ptr_di], di
 
@@99:
        ret

ENDP    Init_Program



;**********************************************************************
PROC    Init_Files
;**********************************************************************
        mov     si, offset CONFIG___File
        push    ds si
        pop     di es
        mov     si, offset CONFIG___Pathname
        mov     [(FMS_Area ptr di).Path_Address_Hi], ds
        mov     [(FMS_Area ptr di).Path_Address_Lo], si

        ret

ENDP    Init_Files



;**********************************************************************
PROC    Init_Screens
;**********************************************************************
;
; Init screen BG=Background
;
        mov     si, offset Ws_BG
        push    ds si
        pop     di es

        mov     si, offset Ws_BG_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_BG_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_BG_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

;
; Init screen FW=FreeWare
;
        mov     si, offset Ws_FW
        push    ds si
        pop     di es

        mov     si, offset Ws_FW_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_FW_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_FW_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

;
; Init screen PA=Path
;
        mov     si, offset Ws_PA
        push    ds si
        pop     di es

        mov     si, offset Ws_PA_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_PA_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_PA_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

        mov     si, offset Ws_PA_F_Path
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        mov     si, offset Search_Files_Path
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Init screen DR=Drives
;
        mov     si, offset Ws_DR
        push    ds si
        pop     di es

        mov     si, offset Ws_DR_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_DR_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_DR_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

        mov     si, offset Ws_DR_F_Drive
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        mov     si, offset Ws_DR_D_Drive
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DR_F_Key_Enter

        push    ds si
        pop     di es

        mov     si, offset Ws_DR_D_Key_Enter
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DR_F_Key_Esc

        push    ds si
        pop     di es

        mov     si, offset Ws_DR_D_Key_Esc
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DR_F_Key_Help

        push    ds si
        pop     di es

        mov     si, offset Ws_DR_D_Key_Help
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DR_F_Key_Cfg

        push    ds si
        pop     di es

        mov     si, offset Ws_DR_D_Key_Cfg
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Init screen DH=Drive Help Screen
;
        mov     si, offset Ws_DH
        push    ds si
        pop     di es

        mov     si, offset Ws_DH_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_DH_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_DH_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

;
; Init screen LF=Directories/Images
;
        mov     si, offset Ws_LF
        push    ds si
        pop     di es

        mov     si, offset Ws_LF_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_LF_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_LF_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

        mov     si, offset Ws_LF_F_Dir_Fil
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        mov     si, offset Ws_LF_F_Dir_Fil
        push    ds si
        pop     di es

        mov     ax, [Dir_Map_ptr_es]
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ax
        mov     ax, [Dir_Map_ptr_di]
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], ax

        mov     si, offset Ws_LF_F_Key_Enter

        push    ds si
        pop     di es

        mov     si, offset Ws_LF_D_Key_Enter
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_LF_F_Key_Esc

        push    ds si
        pop     di es

        mov     si, offset Ws_LF_D_Key_Esc
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_LF_F_Key_Help

        push    ds si
        pop     di es

        mov     si, offset Ws_LF_D_Key_Help
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_LF_F_Key_CurDir

        push    ds si
        pop     di es

        mov     si, offset Ws_LF_D_Key_CurDir
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_LF_F_Key_Drv

        push    ds si
        pop     di es

        mov     si, offset Ws_LF_D_Key_Drv
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Init screen LH=Directory/Image Help Screen
;
        mov     si, offset Ws_LH
        push    ds si
        pop     di es

        mov     si, offset Ws_LH_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_LH_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_LH_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

;
; Init screen CF=Configuration File
;
        mov     si, offset Ws_CF
        push    ds si
        pop     di es

        mov     si, offset Ws_CF_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_CF_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_CF_Enter_Keys
        mov     [(Wsio_Area ptr di).Enter_Address_Hi], ds
        mov     [(WSio_Area ptr di).Enter_Address_Lo], si

        mov     si, offset Ws_CF_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

        mov     si, offset Ws_CF_F_Read_From
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es
        mov     si, offset Config_Field_Read_From
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si
        mov     si, offset Drives_Field
        mov     [(Wsio_Field ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Field ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_CF_F_Active
        push    ds si
        pop     di es
        mov     si, offset Available_Drives
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si
        mov     si, offset Attrib_Non_Modifiable
        mov     [(Wsio_Field ptr di).Attrib_Address_Hi], ds
        mov     [(WSio_Field ptr di).Attrib_Address_Lo], si

        mov     si, offset Ws_CF_F_Write_To
        push    ds si
        pop     di es
        mov     si, offset Config_Field_Write_To
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_CF_F_Disk_Density
        push    ds si
        pop     di es
        mov     si, offset Config_Field_Disk_Density
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si
        mov     si, offset Disk_Density_Field
        mov     [(Wsio_Field ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Field ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_CF_F_ATR_Or_XFD
        push    ds si
        pop     di es
        mov     si, offset Config_Field_ATR_Or_XFD
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si
        mov     si, offset ATR_Or_XFD_Field
        mov     [(Wsio_Field ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Field ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_CF_F_DOS_Path
        push    ds si
        pop     di es
        mov     si, offset Config_Field_DOS_Path
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_CF_F_Disk_Format
        push    ds si
        pop     di es
        mov     si, offset Config_Field_Disk_Format
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si
        mov     si, offset Disk_Format_Field
        mov     [(Wsio_Field ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Field ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_CF_F_Include_DOS
        push    ds si
        pop     di es
        mov     si, offset Config_Field_Include_DOS
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si
        mov     si, offset Yes_No_Field
        mov     [(Wsio_Field ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Field ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_CF_F_Include_DUP_SYS
        push    ds si
        pop     di es
        mov     si, offset Config_Field_Include_DUP_SYS
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si
        mov     si, offset Yes_No_Field
        mov     [(Wsio_Field ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Field ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_CF_F_MAIN
        push    ds si
        pop     di es
        mov     si, offset Config_Field_MAIN
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si
        mov     si, offset Yes_No_Field
        mov     [(Wsio_Field ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Field ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_CF_F_Key_Enter

        push    ds si
        pop     di es

        mov     si, offset Ws_CF_D_Key_Enter
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_CF_F_Key_Update

        push    ds si
        pop     di es

        mov     si, offset Ws_CF_D_Key_Update
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_CF_F_Key_Esc

        push    ds si
        pop     di es

        mov     si, offset Ws_CF_D_Key_Esc
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Init screen E1=Error Screen - Drive Not Ready
;
        mov     si, offset Ws_E1
        push    ds si
        pop     di es

        mov     si, offset Ws_E1_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_E1_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_E1_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

;
; Init screen E2=Error Screen - No valid drives present
;
        mov     si, offset Ws_E2
        push    ds si
        pop     di es

        mov     si, offset Ws_E2_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_E2_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_E2_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

;
; Init screen E3=Error Screen - Command Line Interface Error
;
        mov     si, offset Ws_E3
        push    ds si
        pop     di es

        mov     si, offset Ws_E3_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_E3_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_E3_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

@@99:
        ret

ENDP    Init_Screens



;**********************************************************************
PROC    CLI_Check
;**********************************************************************
        mov     [CLI_Used], LOGIC_NO                    ; Assume interactive usage

        mov     cx, [CLI_Command_Tail_Size]             ; Check if command line is empty
        cmp     cx, NULL                                ; Parameter(s) specified?
        je      @@99                                    ; No
                                                        ; Yes, so
;
; Use CLI interface
;
        mov     [CLI_Used], LOGIC_YES

        mov     si, offset CLI_Command_Tail
        push    ds si
        call    TO_UPPER                                ; Make it uppercase
        pop     si ds

        mov     si, offset CLI_Command_Tail
        push    ds si
        pop     di es
        xor     ax, ax                                  ; Reset ax
        mov     al, CR                                  ; Search for Carriage Return
        repne   scasb                                   ; Search equal CR, uses es:di
        dec     di                                      ; Adjust start position after scan
        mov     [byte es:di], SPACE                     ; Remove return character here
        mov     [byte es:di + 1], CR                    ; Place it here

@@10:
        mov     [CLI_Error], LOGIC_NO

;-----------------------------------------------------
; Split Command Tail into the different CLI parameters
;-----------------------------------------------------
        mov     cx, [CLI_Command_Tail_Size]
        inc     cx                                      ; Because of CR replacement by space
        mov     si, offset CLI_Command_Tail
        push    ds si
        pop     di es

        mov     si, offset CLI_Indir                    ; CLI Indir
        call    CLI_Process_Parameter

        mov     si, offset CLI_Outdisk                  ; CLI Outdisk
        call    CLI_Process_Parameter

        mov     si, offset CLI_Disk_Density             ; CLI Disk Density
        call    CLI_Process_Parameter

        mov     si, offset CLI_Atr_Or_Xfd               ; CLI Atrxfd
        call    CLI_Process_Parameter

        mov     si, offset CLI_Disk_Format              ; CLI Disk Format
        call    CLI_Process_Parameter

        mov     si, offset CLI_Include_Subdirs          ; CLI Include subdirs
        call    CLI_Process_Parameter

@@20:
        cmp     [CLI_Error], LOGIC_NO                   ; CLI specs ok?
        je      @@99                                    ; Yes
                                                        ; No, so
;-------------------------------------
; ERROR - COMMAND LINE INTERFACE ERROR
;-------------------------------------
        mov     si, offset Ws_E3
        mov     [byte ds:si], WSIO_OPEN
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_E3
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_E3
        mov     [byte ds:si], WSIO_CLOSE
        push    ds si
        call    WSIO
        pop     si ds

@@99:
        ret

ENDP    CLI_Check



;**********************************************************************
PROC    CLI_Process_Parameter
;**********************************************************************
        cmp     [CLI_Error], LOGIC_YES                  ; Already error encounterd?
        je      @@99                                    ; Yes
                                                        ; No, so
@@00:
        mov     al, [byte es:di]                        ; Get character
        cmp     al, SPACE                               ; End of parameter?
        je      @@90                                    ; Yes
                                                        ; No, so
        mov     [byte ds:si], al                        ; Move character
        inc     si
        inc     di
        dec     cx                                      ; Byte count of Command Tail
        jnz     @@00                                    ; Next character
        mov     [CLI_Error], LOGIC_YES
        jmp     @@99

@@90:
        cmp     [byte es:di], SPACE                     ; Still SPACE?
        jne     @@99                                    ; No
                                                        ; Yes, so
        inc     di
        dec     cx
        jnz     @@90                                    ; Next character
        mov     [CLI_Error], LOGIC_YES

@@99:
        ret

ENDP    CLI_Process_Parameter



;**********************************************************************
PROC    Read_Dir2atr_Config_File
;**********************************************************************
        mov     si, offset CONFIG___File
        push    ds si
        pop     di es

        mov     si, offset CONFIG___Data_Buffer
        mov     [(FMS_Area ptr di).Data_Address_Hi], ds
        mov     [(FMS_Area ptr di).Data_Address_Lo], si
        mov     [(FMS_Area ptr di).Request], CMD_OPEN_INPUT
        push    es di
        call    FMSIO
        pop     di es

        cmp     [(FMS_Area ptr di).Status], STATUS_OK
        jne     @@99                                    ; Error!

        mov     [(FMS_Area ptr di).Request], CMD_ACCESS_GET

; Retrieve READ from
        call    Get_Parameter_From_Config_File

        mov     si, offset Config_Field_Read_From
        push    ds si
        pop     di es
        mov     si, offset CONFIG___Data_Buffer
        mov     cx, MAX_DRIVES
        rep     movsb

; Retrieve WRITE to
        call    Get_Parameter_From_Config_File

        mov     si, offset Config_Field_Write_To
        push    ds si
        pop     di es
        mov     si, offset CONFIG___Data_Buffer
        mov     cx, PATH_LENGTH
        rep     movsb

; Retrieve Disk Density
        call    Get_Parameter_From_Config_File

        mov     si, offset Config_Field_Disk_Density
        push    ds si
        pop     di es
        mov     si, offset CONFIG___Data_Buffer
        mov     cx, 1
        rep     movsb

; Retrieve Disk Creation Type ATR Or XFD
        call    Get_Parameter_From_Config_File

        mov     si, offset Config_Field_ATR_Or_XFD
        push    ds si
        pop     di es
        mov     si, offset CONFIG___Data_Buffer
        mov     cx, 1
        rep     movsb

; Retrieve DOS Path
        call    Get_Parameter_From_Config_File

        mov     si, offset Config_Field_DOS_Path
        push    ds si
        pop     di es
        mov     si, offset CONFIG___Data_Buffer
        mov     cx, PATH_LENGTH
        rep     movsb

; Retrieve Disk Format
        call    Get_Parameter_From_Config_File

        mov     si, offset Config_Field_Disk_Format
        push    ds si
        pop     di es
        mov     si, offset CONFIG___Data_Buffer
        mov     cx, 1
        rep     movsb

; Retrieve Include DOS
        call    Get_Parameter_From_Config_File

        mov     si, offset Config_Field_Include_DOS
        push    ds si
        pop     di es
        mov     si, offset CONFIG___Data_Buffer
        mov     cx, 1
        rep     movsb

        mov     [Config_Include_DOSFILES_YN], LOGIC_NO

        mov     si, offset CONFIG___Data_Buffer
        cmp     [byte ds:si], "N"                       ; Check if No is specified
        je      @@80                                    ; No is specified
                                                        ; Include DUP_SYS
        mov     [Config_Include_DOSFILES_YN], LOGIC_YES

@@80:
; Retrieve Include DUP_SYS
        call    Get_Parameter_From_Config_File

        mov     si, offset Config_Field_Include_DUP_SYS
        push    ds si
        pop     di es
        mov     si, offset CONFIG___Data_Buffer
        mov     cx, 1
        rep     movsb

        mov     [Config_Include_DUP_SYS_YN], LOGIC_NO

        mov     si, offset CONFIG___Data_Buffer
        cmp     [byte ds:si], "N"                       ; Check if No is specified
        je      @@85                                    ; No is specified
                                                        ; Include DUP_SYS
        mov     [Config_Include_DUP_SYS_YN], LOGIC_YES

@@85:
; Retrieve Use MAIN dir for spartaDos
        call    Get_Parameter_From_Config_File

        mov     si, offset Config_Field_MAIN
        push    ds si
        pop     di es
        mov     si, offset CONFIG___Data_Buffer
        mov     cx, 1
        rep     movsb

        mov     [Config_MAIN_YN], LOGIC_NO

        mov     si, offset CONFIG___Data_Buffer
        cmp     [byte ds:si], "N"                       ; Check if No is specified
        je      @@90                                    ; No is specified
                                                        ; Use MAIN dir
        mov     [Config_MAIN_YN], LOGIC_YES

@@90:
; Close config file
        mov     si, offset CONFIG___File
        push    ds si
        pop     di es

        mov     [(FMS_Area ptr di).Request], CMD_OPEN_CLOSE
        push    es di
        call    FMSIO
        pop     di es

@@99:
        ret

ENDP    Read_Dir2atr_Config_File



;**********************************************************************
PROC    Get_Parameter_From_Config_File
;**********************************************************************
@@00:
; Clear parameter
        mov     si, offset CONFIG___Data_Buffer
        push    ds si
        pop     di es
        mov     cx, CONFIG_FILE_LINE_SIZE
        xor     ax, ax                                  ; Reset ax
        mov     al, SPACE
        rep     stosb                                   ; Clear parameter

; Get line from config file
        mov     si, offset CONFIG___File
        push    ds si
        call    FMSIO
        pop     di es

        cmp     [(FMS_Area ptr di).Status], STATUS_OK
        jne     @@99                                    ; Error!

        mov     si, offset CONFIG___Data_Buffer
        cmp     [byte ds:si], COMMENT_ROW               ; Comment "line"?
        je      @@00                                    ; Yes
                                                        ; No, so
        cmp     [byte ds:si], SPACE                     ; Empty "line"?
        je      @@00                                    ; Yes
                                                        ; No, so
        cmp     [byte ds:si], NULL                      ; "line" starts with space?
        je      @@00                                    ; Yes
                                                        ; No, so
@@99:
        ret

ENDP    Get_Parameter_From_Config_File



;**********************************************************************
PROC    Parameter_Processing
;**********************************************************************
;----------------------
; Use current directory
;----------------------
@@10:
        mov     si, offset Config_Startup_Path
        push    ds si
        pop     di es
        mov     cx, PATH_LENGTH
        xor     ax, ax                                  ; Reset ax
        mov     al, SPACE
        rep     stosb                                   ; Clear parameter

; Get default drive
        xor     ax, ax                                  ; Reset ax
        mov     ah, DOS_GET_DEFAULT_DRIVE               ; Get Default Drive
        int     DOS_SERVICE 
        add     al, 041h                                ; Because of 0-based stuff

; Process Drive
        mov     si, offset Config_Startup_Path
        mov     [byte ds:si], al                        ; Process Drive letter
        mov     [byte ds:si + 1], COLON
        mov     [byte ds:si + 2], BACKSLASH
        add     si, 3                                   ; Locating at directory stuff

; Get current directory
        xor     ax, ax                                  ; Reset ax
        mov     ah, DOS_GET_CURRENT_DIRECTORY
        xor     dx, dx                                  ; Reset dx
        mov     dl, DOS_DEFAULT_DRIVE
        int     DOS_SERVICE

; Terminate it with a backslash "\"
        mov     si, offset Config_Startup_Path
        push    ds si
        pop     di es
        mov     cx, PATH_LENGTH
        dec     cx                                      ; To go to the last character
        add     di, cx                                  ; Go to end of path
        std                                             ; Search direction is down
        mov     ax, SPACE                               ; Search for non space
        repe    scasb                                   ; Search uses es:di
        cld                                             ; Cancel the std setting

        mov     cl, BACKSLASH                           ; Assume adding a backslash
        cmp     [byte es:di], BACKSLASH                 ; Are we in the root?
        jne     @@15                                    ; No
                                                        ; Yes, so
        mov     cl, SPACE                               ; Replace 000h by SPACE

@@15:
        inc     di                                      ; Pointer adjustment after search
        mov     [byte es:di], cl

;---------------------------------
; Copy Startup path to search path
;---------------------------------
@@20:
        mov     si, offset Search_Dirs_Path
        push    ds si
        pop     di es

        mov     si, offset Config_Startup_Path
        mov     cx, PATH_LENGTH
        rep     movsb

;----------------------------------------
; Copy Config Filemask to Search Filemask
;----------------------------------------
        mov     si, offset Search_Filemask
        push    ds si
        pop     di es
        mov     si, offset Config_Field_Filemask
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

@@99:
        ret

ENDP    Parameter_Processing



;**********************************************************************
PROC    Read_VTOC_Drives
;**********************************************************************
;
; Get drives in format: ACDE etc.
;
        mov     si, offset Config_Field_Read_From
        cmp     [byte ds:si], ASTERISK                  ; Use available drives?
        je      @@20                                    ; Yes
                                                        ; No, so
        mov     si, offset Available_Drives
        push    ds si
        pop     di es
        mov     si, offset Config_Field_Read_From
        mov     cx, MAX_DRIVES
        rep     movsb

        mov     si, offset Available_Drives
        mov     cx, MAX_DRIVES

;
; Check existence of specified drives
;
@@00:
        cmp     [byte ds:si], SPACE                     ; End of drive list?
        je      @@10                                    ; Yes
                                                        ; No, so
        cmp     [byte ds:si], "A"                       ; A drive?
        je      @@01                                    ; Yes
                                                        ; No, so
        cmp     [byte ds:si], "B"                       ; B drive?
        je      @@01                                    ; Yes
                                                        ; No, so
        jmp     @@04

@@01:
;
; Check available diskette drives A and B
;
        push    ds si cx
        int     EQUIPMENT_SERVICE                       ; Get equipment info
        mov     cx, ax
        and     cx, 00001h                              ; Check nr of floppy drives
        cmp     cl, 001h                                ; Floppy drives present?
        jne     @@06                                    ; No
                                                        ; Yes, so
        and     ax, 000C0h                              ; Check nr of floppy drives present
        cmp     al, 000h                                ; 1 floppy drive present?
        jne     @@08                                    ; No
                                                        ; Yes, so
;
; Just 1 floppy drive present
;
        push    es di
        mov     ax, 00050h
        mov     es, ax
        mov     di, 00004h
        mov     al, [byte es:di]                        ; 0050:0004 shows which drive is
                                                        ; emulated with 1 floppy drive
                                                        ; 000h = drive A   0001h = drive B
        pop     di es

;
; Determine which floppy drive is being emulated, assume drive A
;
        cmp     al, 000h                                ; Emulating drive A?
        je      @@02                                    ; Yes
                                                        ; No, so
                                                        ; Emulating drive B
        cmp     [byte ds:si], "B"                       ; B drive?
        je      @@08                                    ; Yes
                                                        ; No, so
        jmp     @@06

@@02:
        cmp     [byte ds:si], "A"                       ; A drive?
        je      @@08                                    ; Yes
                                                        ; No, so
        jmp     @@06

;
; Check drive presence
;
@@04:
        mov     bl, [ds:si]

        push    ds si cx

        mov     ax, DOS_SENSE_MEDIA_TYPE
        mov     cx, DOS_SENSE_MEDIA_TYPE_CX
        sub     bl, 64                                  ; Turn drive into DOS drive
        mov     si, offset Buffer_Sense_Media_Type
        mov     dx, si
        int     DOS_SERVICE                             ; Check Drive Presence
        cmp     ax, DOS_DRIVE_NOT_AVAILABLE             ; Drive available?
        jne     @@08                                    ; Yes
                                                        ; No, so
@@06:
        pop     cx si ds
        dec     si
        push    ds si cx

        inc     si
        push    ds si
        pop     di es

        inc     si
        rep     movsb
        
@@08:
        pop     cx si ds
        inc     si
        loop    @@00

@@10:
        mov     si, offset Ws_DR_D_Drive
        push    ds si
        pop     di es

;
; Init Drives descriptions
;
        push    es di
        mov     cx,  ((MAX_DRIVES + EXTRA_TABLE_FIELDS) * 16)
        mov     ax, SPACE
        rep     stosb
        pop     di es

        mov     si, offset Available_Drives
        mov     cx, MAX_DRIVES
        rep     movsb

        mov     [Requested_Format_Drives], "3"          ; Format [A: Myvolume   ]
        mov     si, offset Requested_Format_Drives      ; Parameter 1
        push    ds si

        mov     si, offset Ws_DR_D_Drive                ; Parameter 2
        push    ds si
 
        call    DC_DRV

        pop     ax ax ax ax

        jmp     @@30

@@20:
        mov     [Requested_Format_Drives], "1"          ; Format ABCDE
        mov     si, offset Requested_Format_Drives      ; Parameter 1
        push    ds si

        mov     si, offset Available_Drives             ; Parameter 2
        push    ds si
 
        call    DC_DRV

        pop     ax ax ax ax

;
; Get drives in format: [A: Myvolume   ]
;                       [C: Yourvolume ] etc.
;
        mov     [Requested_Format_Drives], "2"          ; Format [A: Myvolume   ]
        mov     si, offset Requested_Format_Drives      ; Parameter 1
        push    ds si

        mov     si, offset Ws_DR_D_Drive                ; Parameter 2
        push    ds si

        call    DC_DRV

        pop     ax ax ax ax

@@30:
;-----------------------
; Specify start of table
;-----------------------
        mov     [Ws_DR_Occur_Curr], 0

@@40:
;-----------------------------------
; Determine which drive to highlight
;-----------------------------------
        mov     [Ws_DR_Occur_W_Curr], 0

        mov     si, offset Search_Dirs_Path
        mov     bl, [byte ds:si]                        ; Config path drive

;-------------------------------------------
; Determine maximum number of drives present
;-------------------------------------------
        mov     si, offset Ws_DR_F_Drive
        push    ds si
        pop     di es

        xor     ax, ax
        mov     al, [(Wsio_Field ptr di).Size]

        mov     cx, MAX_DRIVES

        mov     [Ws_DR_Occur_Max], 0
        mov     si, offset Ws_DR_D_Drive

@@50:
        cmp     [byte ds:si], SPACE
        je      @@80

        inc     [Ws_DR_Occur_Max]
        cmp     [byte ds:si], bl                        ; Selected drive found?
        jne     @@70                                    ; No
                                                        ; Yes, so
        mov     dx, [Ws_DR_Occur_Max]
        mov     [Ws_DR_Occur_Curr], dx

@@60:
        mov     [Ws_DR_Occur_W_Curr], dx
        cmp     dx, [WS_DR_OCCUR_W_CURR_MAX]            ; dx > Max occur of window?
        jle     @@70                                    ; No
                                                        ; Yes, so
        sub     dx, [WS_DR_OCCUR_W_CURR_MAX]            ; Move 1 window up
        jmp     @@60

@@70:
        add     si, ax
        loop    @@50

@@80:
        cmp     [Ws_DR_Occur_Max], 0                    ; Any valid drive present?
        je      @@95                                    ; No
                                                        ; Yes, so
        cmp     [Ws_DR_Occur_W_Curr], 0                 ; Invalid drive specified?
        jne     @@90                                    ; No
                                                        ; Yes, so
        mov     [Ws_DR_Occur_Curr], 1                   ; Assume first drive
        mov     [Ws_DR_Occur_W_Curr], 1                 ; Assume first drive

        mov     si, offset Config_Startup_Path
        push    ds si
        pop     di es
        mov     si, offset Default_Startup_Path
        mov     cx, PATH_LENGTH
        rep     movsb
        mov     si, offset Config_Startup_Path
        push    ds si
        pop     di es
        mov     si, offset Ws_DR_D_Drive
        mov     cx, 1
        rep     movsb

;---------------------------------
; Copy Startup path to search path
;---------------------------------
        mov     si, offset Search_Dirs_Path
        push    ds si
        pop     di es

        mov     si, offset Config_Startup_Path
        mov     cx, PATH_LENGTH
        rep     movsb

;----------------------------------------
; Copy Config Filemask to Search Filemask
;----------------------------------------
        mov     si, offset Search_Filemask
        push    ds si
        pop     di es
        mov     si, offset Config_Field_Filemask
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

;----------------------------------------
; Retrieve files from new drive/directory
;----------------------------------------
        mov     [Dir_Up], 0                             ; We stay in the current dir
        call    Read_VTOC_Directories_Files             ; Retrieve directories/files

        jmp     @@30

@@90:
;------------------------------------
; Pass offset address of drives table
;------------------------------------
        mov     si, offset Ws_DR_D_Drive
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si
        jmp     @@99

@@95:
;---------------------------------------------------
; ERROR - NO DRIVE FROM SPECIFIED DRIVE LIST PRESENT
;---------------------------------------------------
        mov     si, offset Ws_E2
        mov     [byte ds:si], WSIO_OPEN
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_E2
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_E2
        mov     [byte ds:si], WSIO_CLOSE
        push    ds si
        call    WSIO
        pop     si ds

@@99:
        ret

ENDP    Read_VTOC_Drives



;**********************************************************************
PROC    Open_Ws_BG
;**********************************************************************
        mov     si, offset Ws_BG
        mov     [byte ds:si], WSIO_OPEN
        push    ds si
        call    WSIO
        pop     si ds

        cmp     ax, NULL                                ; Error?
        jz      @@99                                    ; No
                                                        ; Yes, so
;
; Error
;

@@99:        
        ret

ENDP    Open_Ws_BG



;**********************************************************************
PROC    Display_Ws_BG
;**********************************************************************
        mov     si, offset Ws_BG
        mov     [byte ds:si], WSIO_DISPLAY_ONLY
        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_BG



;**********************************************************************
PROC    Display_Ws_FW
;**********************************************************************
        mov     si, offset Ws_FW

        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_FW



;**********************************************************************
PROC    Display_Ws_PA
;**********************************************************************
        mov     si, offset Ws_PA
        mov     [byte ds:si], WSIO_DISPLAY_ONLY

        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_PA



;**********************************************************************
PROC    Display_Ws_DR
;**********************************************************************
        mov     si, offset Ws_DR
        mov     [byte ds:si], WSIO_DISPLAY_ONLY

        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_DR



;**********************************************************************
PROC    Display_and_Read_Ws_DR
;**********************************************************************
;----------
; Init Path
;----------
;
; Reset Search Dirs Path
;
        mov     si, offset Search_Dirs_Path             ; Clear path
        push    ds si
        pop     di es
        inc     di
        mov     cx, PATH_LENGTH - 1
        mov     ax, SPACE
        rep     stosb

        call    Display_Ws_DR
        jmp     @@10

;---------------------------------
; Show fields only of Drives Table
;---------------------------------
@@05:
        mov     si, offset Ws_DR
        mov     [byte ds:si], WSIO_DISPLAY_FIELDS_ONLY

        push    ds si
        call    WSIO
        pop     si ds

@@10:
;
; Make current occurrence Green/White
;
        mov     si, offset Ws_DR
        push    ds si
        pop     di es

        mov     cl, ATTRIB_GREEN_WHITE
        mov     [(Wsio_Area ptr di).Input_Select_Attrib], cl

        mov     [(Wsio_Area ptr di).Select_Field_Nr], 1
        mov     cx, [Ws_DR_Occur_W_Curr]
        mov     [(Wsio_Area ptr di).Select_Field_Occur_Nr], cl

        mov     [(Wsio_Area ptr di).Cursor_Position_Row], CURSOR_OFF_SCREEN
        mov     [(Wsio_Area ptr di).Cursor_Position_Col], CURSOR_OFF_SCREEN

;
; Display current occurrence
;
        mov     si, offset Ws_DR
        mov     [byte ds:si], WSIO_SELECT_DESELECT

        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_DR
        mov     [byte ds:si], WSIO_READ_ONLY

        push    ds si
        call    WSIO
        pop     si ds

;
; Save pressed key
;
        push    ax

;
; Reset current occurrence
;
        mov     si, offset Ws_DR
        push    ds si
        pop     di es

        mov     cl, [(Wsio_Area ptr di).Field_Attrib]
        mov     [(Wsio_Area ptr di).Input_Select_Attrib], cl

        mov     [(Wsio_Area ptr di).Select_Field_Nr], 1
        mov     cx, [Ws_DR_Occur_W_Curr]
        mov     [(Wsio_Area ptr di).Select_Field_Occur_Nr], cl

        mov     si, offset Ws_DR
        mov     [byte ds:si], WSIO_SELECT_DESELECT

        push    ds si
        call    WSIO
        pop     si ds

;
; Restore pressed key
;
        pop     ax

;--------------------------------
; Determine which key was pressed
;--------------------------------
        cmp     al, KEY_ARROW_UP
        je      @@20
        cmp     al, KEY_ARROW_DOWN
        je      @@25
        cmp     al, KEY_PAGE_UP
        je      @@30
        cmp     al, KEY_PAGE_DOWN
        je      @@35
        cmp     al, KEY_HOME
        je      @@40
        cmp     al, KEY_END
        je      @@45
        cmp     al, KEY_ENTER
        je      @@60
        cmp     al, KEY_F4                              ; Configuration setup
        je      @@80
        cmp     al, KEY_HELP
        je      @@90
;
; Assume the Esc(ape) key
;
        jmp     @@99

;-------------
; KEY ARROW UP
;-------------
@@20:
        cmp     [Ws_DR_Occur_Curr], 1                   ; Can we go "up" anyhow?
        je      @@10                                    ; No
                                                        ; Yes, so
;
; Move "up" to previous occurrence
;
        dec     [Ws_DR_Occur_Curr]

;
; Are we still in the current "window"?
;
        cmp     [Ws_DR_Occur_W_Curr], 1
        je      @@21

        dec     [Ws_DR_Occur_W_Curr]
        jmp     @@10

@@21:
;
; Move occurrence down
;
        mov     cx, [Ws_DR_Occur_Curr]                  ; Get current occurrence
        jmp     @@50

;---------------
; KEY ARROW DOWN
;---------------
@@25:
        mov     dx, [Ws_DR_Occur_Max]                   ; Max nr of available occurrences
        cmp     dx, [Ws_DR_Occur_Curr]                  ; Current occurr = max?
        je      @@10                                    ; Yes
                                                        ; No, so
;
; Move "down" to next occurrence
;
        inc     [Ws_DR_Occur_Curr]

;
; Are we still in the current "window"?
;
        mov     dx, [WS_DR_OCCUR_W_CURR_MAX]            ; Max occurrence of window
        cmp     [Ws_DR_Occur_W_Curr], dx                ; Current occurr = max window?
        je      @@26                                    ; Yes
                                                        ; No, so
        inc     [Ws_DR_Occur_W_Curr]
        jmp     @@10

@@26:
;
; Move occurrences up
;
        mov     cx, [Ws_DR_Occur_Curr]                  ; Get current occurrence
        sub     cx, [WS_DR_OCCUR_W_CURR_MAX]            ; Calculate window size
        inc     cx
        jmp     @@50

;------------
; KEY PAGE UP
;------------
@@30:
        cmp     [Ws_DR_Occur_Curr], 1                   ; Can we go "up" anyhow?
        je      @@10                                    ; No
                                                        ; Yes, so
;
; Move up to previous window
;
        mov     cx, [Ws_DR_Occur_Curr]                  ; Current occurrence
        sub     cx, [Ws_DR_Occur_W_Curr]                ; Determine begin of window
        inc     cx                                      ; Which is done now
        cmp     cx, [WS_DR_OCCUR_W_CURR_MAX]            ; Can we subtract 1 page?
        jl      @@31                                    ; No
                                                        ; Yes, so
        sub     cx, [WS_DR_OCCUR_W_CURR_MAX]            ; Subtract size of 1 page
        jmp     @@32

@@31:
        mov     cx, 1                                   ; Go to beginning of occur

@@32:
;
; Determine Window occurrence
;
        mov     dx, cx
        add     dx, [Ws_DR_Occur_W_Curr]
        dec     dx
        mov     [Ws_DR_Occur_Curr], dx
        jmp     @@50

;--------------
; KEY PAGE DOWN
;--------------
@@35:
        mov     cx, [Ws_DR_Occur_Curr]                  ; Current occurrence
        sub     cx, [Ws_DR_Occur_W_Curr]                ; Determine begin of window
        inc     cx                                      ; Which is done now
        add     cx, [WS_DR_OCCUR_W_CURR_MAX]            ; Add size of 1 page
        cmp     cx, [Ws_DR_Occur_Max]                   ; Is there a next window?
        jnle    @@10                                    ; No
                                                        ; Yes, so
;
; Determine window occurrence
;
        mov     dx, cx
        add     dx, [Ws_DR_Occur_W_Curr]                ; Go to same window occurrence
        dec     dx                                      ; Which is done now
        cmp     dx, [Ws_DR_Occur_Max]                   ; Does it exist?
        jle     @@36                                    ; Yes
                                                        ; No, so
        mov     bx, dx                                  ; bx = dx
        sub     bx, [Ws_DR_Occur_Max]                   ; Determine difference
        sub     [Ws_DR_Occur_W_Curr], bx                ; Go to last occurrence
        mov     dx, [Ws_DR_Occur_Max]

@@36:
        mov     [Ws_DR_Occur_Curr], dx
        jmp     @@50

;---------
; KEY HOME
;---------
@@40:
        cmp     [Ws_DR_Occur_Curr], 1                   ; Can we go "up" anyhow?
        je      @@10                                    ; No
                                                        ; Yes, so
        mov     cx, [Ws_DR_Occur_Curr]                  ; Current occurrence
        sub     cx, [Ws_DR_Occur_W_Curr]                ; Determine begin of window
        inc     cx                                      ; Which is done now
        cmp     cx, 1                                   ; Showing from 1st already?
        jne     @@41                                    ; No
                                                        ; Yes, so
        cmp     [Ws_DR_Occur_W_Curr], 1                 ; At top of window?
        je      @@10                                    ; Yes
                                                        ; No, so
@@41:
        mov     cx, 1                                   ; Go to beginning of screen
        mov     [Ws_DR_Occur_W_Curr], 1
        mov     [Ws_DR_Occur_Curr], 1
        jmp     @@50

;--------
; KEY END
;--------
@@45:
        mov     cx, [Ws_DR_Occur_Curr]                  ; Current occurrence
        cmp     cx, [Ws_DR_Occur_Max]                   ; Can we go "down" anyhow?
        je      @@10                                    ; No
                                                        ; Yes, so
        mov     cx, [Ws_DR_Occur_Max]                   ; Go to last occurrence
        mov     [Ws_DR_Occur_Curr], cx                  ; Go to last occurrence in table
        cmp     cx, [WS_DR_OCCUR_W_CURR_MAX]            ; Does it all fit in 1 window?
        jnle    @@46                                    ; No
                                                        ; Yes, so
        mov     [Ws_DR_Occur_W_Curr], cx                ; Go  to  last entry in window
        jmp     @@50

@@46:
;
; Determine window occurrence
;
        sub     cx, [WS_DR_OCCUR_W_CURR_MAX]            ; Subtract 1 page
        inc     cx                                      ; We are at the last page now
        mov     dx, [WS_DR_OCCUR_W_CURR_MAX]            ; Get last window occurrence
        mov     [Ws_DR_Occur_W_Curr], dx                ; Move to last window occurrence
        jmp     @@50

;----------------------------------------
; Set up drive window data and attributes
;----------------------------------------
@@50:
        mov     si, offset Ws_DR_F_Drive
        push    ds si
        pop     di es

        xor     ax, ax
        mov     al, [(Wsio_Field ptr di).Size]

        mov     si, offset Ws_DR_D_Drive

        jmp     @@52

@@51:
        add     si, ax

@@52:
        loop    @@51

        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        jmp     @@05

;----------
; KEY ENTER
;----------
@@60:
        mov     si, offset Ws_DR
        push    ds si
        pop     di es

        xor     bx, bx
        mov     bl, [(Wsio_Area ptr di).Select_Field_Occur_Nr]

        mov     [Mouse_Pressed], LOGIC_NO

        xor     cx, cx
        mov     cl, [(Wsio_Area ptr di).Cursor_Position_Row]
        cmp     cl, CURSOR_OFF_SCREEN                   ; Enter by mouse press?
        je      @@61                                    ; No
                                                        ; Yes, so
        mov     [Mouse_Pressed], LOGIC_YES

;
; Mouse pressed Enter, is it valid?
;
        cmp     cl, 22                                  ; Enter pressed?
        je      @@61                                    ; Yes
                                                        ; No, so
        cmp     cl, 4                                   ; Valid occurrence?
        jl      @@10                                    ; No
                                                        ; Maybe
        cmp     cl, 20                                  ; Valid occurrence?
        jnle    @@10                                    ; No
                                                        ; Maybe
        sub     cl, 3                                   ; Determine occurrence
        mov     dx, [Ws_DR_Occur_Curr]                  ; Current occurrence
        sub     dx, bx
        add     dx, cx
        cmp     dx, [Ws_DR_Occur_Max]                   ; Valid occurrence?
        jnle    @@10                                    ; No
                                                        ; Yes, so
        mov     [Ws_DR_Occur_Curr], dx                  ; Set occurrence
        mov     [Ws_DR_Occur_W_Curr], cx

@@61:
;
; Copy selected drive to path
;
        mov     si, offset Search_Dirs_Path             ; 73 chars for Path
        push    ds si
        pop     di es
        mov     si, offset Available_Drives
        add     si, [Ws_DR_Occur_Curr]
        dec     si
        movsb
        mov     [byte es:di], COLON
        mov     [byte es:di + 1], BACKSLASH

;
; Show new path to user
;
        mov     si, offset Ws_PA
        mov     [byte ds:si], WSIO_DISPLAY_FIELDS_ONLY

        push    ds si
        call    WSIO
        pop     si ds

        mov     [Dir_Memo_Pointer], 0                   ; Reset directory memo pointer
        jmp     @@99

;----------------------
; KEY F4 - Config setup
;----------------------
@@80:
        call    Display_and_Read_Ws_CF
        jmp     @@05

;---------
; KEY HELP
;---------
@@90:
        call    Display_Ws_DH
        jmp     @@10

;-------
; Return
;-------
@@99:
        ret

ENDP    Display_and_Read_Ws_DR



;**********************************************************************
PROC    Display_Ws_DH
;**********************************************************************
        mov     si, offset Ws_DH
        mov     [byte ds:si], WSIO_OPEN
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_DH
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_DH
        mov     [byte ds:si], WSIO_CLOSE
        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_DH



;**********************************************************************
PROC    Read_VTOC_Directories_Files
;**********************************************************************
        cmp     [Dir_Up], 2                             ; Do we have to remember from which directory we came from?
        jne     @@05                                    ; No
                                                        ; Yes, so
        mov     cx, [Ws_LF_Occur_Curr]
        mov     dx, [Ws_LF_Occur_W_Curr]
        xor     ax, ax
        mov     al, [Dir_Memo_Pointer]                  ; Get current occurrence
        rol     ax, 1                                   ; Multiply by 2

        mov     si, offset Dir_Memo_Occur_Curr
        add     si, ax                                  ; Move to empty spot
        mov     [ds:si], cx
        mov     si, offset Dir_Memo_Occur_W_Curr
        add     si, ax                                  ; Move to empty spot
        mov     [ds:si], dx
        inc     [Dir_Memo_Pointer]

@@05:
        mov     [Ws_LF_Occur_Max], 0

;---------------------------------------------
; Get field size of Libraries/Files Table item
;---------------------------------------------
        mov     si, offset Ws_LF_F_Dir_Fil
        push    ds si
        pop     di es

        mov     ax, MAX_DIRS_AND_FILES + EXTRA_TABLE_FIELDS
        xor     bx, bx
        xor     cx, cx
        mov     cl, [byte (Wsio_Field ptr di).Size]
        xor     dx, dx
        mul     cx

;----------------------------
; Clear Libraries/Files Table
;----------------------------
        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]
        mov     cx, ax
        xor     ax, ax                                  ; Reset ax
        mov     al, NULL                                ; Fill character
        rep     stosb

;----------------------------------------------
; Check if drive we have to access drive A or B
;----------------------------------------------
        call    Verify_Disk_Presence_Drive_A_Or_B       ; If were reading drive A or B

        cmp     [Disk_Present], LOGIC_YES               ; Diskette present
        jne     @@99                                    ; No
                                                        ; Yes, so
@@20:        
;-------------------------------
; Set up Search path - Libraries
;-------------------------------
;
; Copy shown path to search path first
;
        mov     si, offset Search_Files_Path
        push    ds si
        pop     di es
        mov     si, offset Search_Dirs_Path
        mov     cx, PATH_LENGTH
        rep     movsb

;
; Find first non blank character in the Search path
;
        mov     si, offset Search_Files_Path
        push    ds si
        pop     di es
        xor     ax, ax
        mov     al, SPACE                               ; Search the first space
        mov     cx, PATH_LENGTH
        repne   scasb                                   ; Search
        dec     di                                      ; Pointer correction after search

;
; Add "*.*" to the Search path
;
        mov     si, offset Directories_File_Mask
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

;
; Terminate it with a null
;
        mov     [byte es:di], NULL

;
; Set up parameters for Directory search
;
        mov     [Requested_Format_LibFil], "2"          ; Format "..           <DIR>      "
                                                        ;        "ATARI        <DIR>      "
        mov     si, offset Requested_Format_LibFil      ; Parameter 1
        push    ds si

        mov     si, offset Search_Files_Path            ; Parameter 2
        push    ds si

        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]                    ; Parameter 3
        push    es di
 
;-----------------------------------------
; Now retrieve Directory Map - Directories
;-----------------------------------------
        call    DC_DIRS

        pop     ax ax ax ax ax ax

;---------------------------
; Set up Search path - Files
;---------------------------

;
; Copy shown path to search path first
;
        mov     si, offset Search_Files_Path
        push    ds si
        pop     di es
        mov     si, offset Search_Dirs_Path
        mov     cx, PATH_LENGTH
        rep     movsb

;
; Find first non blank character in the Search path
;
        mov     si, offset Search_Files_Path
        push    ds si
        pop     di es
        xor     ax, ax
        mov     al, SPACE                               ; Search the first space
        mov     cx, PATH_LENGTH
        repne   scasb                                   ; Search
        dec     di                                      ; Pointer correction after search

;
; Add FileMask to the Search path
;
        mov     si, offset Search_Filemask
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

;
; Terminate it with a null
;
        mov     [byte es:di], NULL

;
; Set up parameters for Directory search
;
        mov     [Requested_Format_LibFil], "2"          ; Format "..           <DIR>      "
                                                        ;        "ATARI        <DIR>      "
        mov     si, offset Requested_Format_LibFil      ; Parameter 1
        push    ds si

        mov     si, offset Search_Files_Path            ; Parameter 2
        push    ds si

        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]                    ; Parameter 3

;
; Search null terminator
;
        xor     ax, ax
        mov     al, NULL                                ; Search the first null
        mov     cx, DIR_MAP_LENGTH
        repne   scasb                                   ; Search
        dec     di                                      ; Pointer correction after search

        push    es di
 
;-----------------------------------
; Now retrieve Directory Map - Files
;-----------------------------------
        call    DC_FILES

        pop     ax ax ax ax ax ax

;------------------------------------------------------
; After reading the VTOC we are at the first occurrence
;------------------------------------------------------
        mov     cx, 1                                   ; To satisfy loop condition
        mov     [Ws_LF_Occur_Curr], 1
        mov     [Ws_LF_Occur_W_Curr], 1

        cmp     [Dir_Up], 1                             ; Did we go up a dir?
        jne     @@50                                    ; No
                                                        ; Yes, so
        cmp     [Dir_Memo_Pointer], 0                   ; Did we have save info of previous dirs?
        je      @@50                                    ; No
                                                        ; Yes, so
        dec     [Dir_Memo_Pointer]

        xor     ax, ax
        mov     al, [Dir_Memo_Pointer]                  ; Get current occurrence
        rol     ax, 1                                   ; Multiply by 2

        mov     si, offset Dir_Memo_Occur_Curr
        add     si, ax                                  ; Move to occupied spot
        mov     cx, [ds:si]
        mov     si, offset Dir_Memo_Occur_W_Curr
        add     si, ax                                  ; Move to occupied spot
        mov     dx, [ds:si]

        mov     [Ws_LF_Occur_Curr], cx
        mov     [Ws_LF_Occur_W_Curr], dx

        sub     cx, [Ws_LF_Occur_W_Curr]                ; Determine begin of window
        inc     cx                                      ; Which is done now

@@50:
        mov     si, offset Ws_LF_F_Dir_Fil

        push    ds si
        pop     di es

        xor     ax, ax
        mov     al, [(Wsio_Field ptr di).Size]

        push    es di

        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]

        jmp     @@52

@@51:
        add     di, ax

@@52:
        loop    @@51

        mov     ax, es
        mov     bx, di

        pop     di es

        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ax
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], bx

;------------------------------------
; Determine MAXimum nr of occurrences
;------------------------------------
        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]
        mov     cx, DIR_MAP_LENGTH                      ; Search length
        xor     ax, ax                                  ; Search for null character
        repne   scasb                                   ; Search uses es:di

        mov     ax, DIR_MAP_LENGTH
        sub     ax, cx                                  ; Nr of entries in size determined
        xor     dx, dx
        xor     cx, cx
        mov     bx, DIR_ENTRY_LENGTH                    ; Determine nr of occurs
        div     bx

        mov     [Ws_LF_Occur_Max], ax

@@99:
        call    Display_Ws_PA                           ; Display path

        ret

ENDP    Read_VTOC_Directories_Files



;**********************************************************************
PROC    Verify_Disk_Presence_Drive_A_Or_B
;**********************************************************************
        mov     [Disk_Present], LOGIC_YES

;----------------------------------------------
; Check if drive we have to access drive A or B
;----------------------------------------------
        mov     si, offset Search_Dirs_Path
        cmp     [byte ds:si], "A"                       ; Access drive A?
        je      @@10                                    ; Yes
                                                        ; No, so
        cmp     [byte ds:si], "B"                       ; Access drive B?
        jne     @@99                                    ; No
                                                        ; Yes, so
@@10:
        xor     bx, bx                                  ; Reset dx
        mov     bl, [byte ds:si]                        ; Copy selected drive to path
        sub     bl, 64                                  ; Turn drive into DOS drive
        mov     ax, DOS_SENSE_MEDIA_TYPE
        mov     al, 00Dh                                ; subfunction code
        mov     cx, DOS_GET_MEDIA_ID_CX
        mov     dx, offset Media_ID_Buffer
        int     DOS_SERVICE                             ; Check Drive Presence
        cmp     ax, DOS_DRIVE_NOT_READY                 ; Drive ready?
        jne     @@99                                    ; Yes
                                                        ; No, so
        mov     [Disk_Present], LOGIC_NO

;------------------------
; ERROR - DRIVE NOT READY
;------------------------
        mov     si, offset Ws_E1
        mov     [byte ds:si], WSIO_OPEN
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_E1
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_E1
        mov     [byte ds:si], WSIO_CLOSE
        push    ds si
        call    WSIO
        pop     si ds

@@99:
        ret

ENDP    Verify_Disk_Presence_Drive_A_Or_B



;**********************************************************************
PROC    Display_and_Read_Ws_LF
;**********************************************************************
        jmp     @@61                                    ; Because of startup path

;------------------------------------------
; Show fields only of Libraries/Files Table
;------------------------------------------
@@00:
        mov     si, offset Ws_LF
        mov     [byte ds:si], WSIO_DISPLAY_FIELDS_ONLY

        push    ds si
        call    WSIO
        pop     si ds

@@05:
;------------------------------------------
; Show Freeware Text or Disk Image contents
;------------------------------------------
        call    Display_Ws_FW                           ; Show Freeware Text

;------------------------------------
; Make current occurrence Green/White
;------------------------------------
@@10:
        mov     si, offset Ws_LF
        push    ds si
        pop     di es

        mov     cl, ATTRIB_GREEN_WHITE
        mov     [(Wsio_Area ptr di).Input_Select_Attrib], cl

        mov     [(Wsio_Area ptr di).Select_Field_Nr], 1
        mov     cx, [Ws_LF_Occur_W_Curr]
        mov     [(Wsio_Area ptr di).Select_Field_Occur_Nr], cl

        mov     [(Wsio_Area ptr di).Cursor_Position_Row], CURSOR_OFF_SCREEN
        mov     [(Wsio_Area ptr di).Cursor_Position_Col], CURSOR_OFF_SCREEN

;
; Display current occurrence
;
        mov     si, offset Ws_LF
        mov     [byte ds:si], WSIO_SELECT_DESELECT

        push    ds si
        call    WSIO
        pop     si ds

;----------
; Get input
;----------
        mov     si, offset Ws_LF
        mov     [byte ds:si], WSIO_READ_ONLY

        push    ds si
        call    WSIO
        pop     si ds

;
; Save pressed key
;
        push    ax

;
; Reset current occurrence
;
        mov     si, offset Ws_LF
        push    ds si
        pop     di es

        mov     cl, [(Wsio_Area ptr di).Field_Attrib]
        mov     [(Wsio_Area ptr di).Input_Select_Attrib], cl

        mov     [(Wsio_Area ptr di).Select_Field_Nr], 1
        mov     cx, [Ws_LF_Occur_W_Curr]
        mov     [(Wsio_Area ptr di).Select_Field_Occur_Nr], cl

        mov     si, offset Ws_LF
        mov     [byte ds:si], WSIO_SELECT_DESELECT

        push    ds si
        call    WSIO
        pop     si ds

;
; Restore pressed key
;
        pop     ax

;--------------------------------
; Determine which key was pressed
;--------------------------------
        cmp     al, KEY_ARROW_UP
        je      @@15
        cmp     al, KEY_ARROW_DOWN
        je      @@20
        cmp     al, KEY_PAGE_UP
        je      @@25
        cmp     al, KEY_PAGE_DOWN
        je      @@30
        cmp     al, KEY_HOME
        je      @@35
        cmp     al, KEY_END
        je      @@40
        cmp     al, KEY_ENTER
        je      @@50
        cmp     al, KEY_F2                              ; Select current directory
        je      @@55
        cmp     al, KEY_F3                              ; Back to drives
        je      @@60
        cmp     al, KEY_F4                              ; Configuration setup
        je      @@65
;
; Check for control key + drive letter
;
        mov     cx, MAX_DRIVES                          ; Drive A thru Z
        mov     bx, 1                                   ; Start at drive A

@@11:
        cmp     al, bl
        je      @@70
        inc     bx                                      ; Try next drive
        loop    @@11

        cmp     al, KEY_HELP
        je      @@90

;
; Assume the Esc(ape) key
;
        jmp     @@99

;-------------
; KEY ARROW UP
;-------------
@@15:
        cmp     [Ws_LF_Occur_Curr], 1                   ; Can we go "up" anyhow?
        je      @@10                                    ; No
                                                        ; Yes, so
;
; Move "up" to previous occurrence
;
        dec     [Ws_LF_Occur_Curr]

;
; Are we still in the current "window"?
;
        cmp     [Ws_LF_Occur_W_Curr], 1
        je      @@16

        dec     [Ws_LF_Occur_W_Curr]
        jmp     @@05

@@16:
;
; Move occurrence down
;
        mov     cx, [Ws_LF_Occur_Curr]                  ; Get current occurrence
        jmp     @@45

;---------------
; KEY ARROW DOWN
;---------------
@@20:
        mov     dx, [Ws_LF_Occur_Max]                   ; Max nr of available occurrences
        cmp     dx, [Ws_LF_Occur_Curr]                  ; Current occurr = max?
        je      @@10                                    ; Yes
                                                        ; No, so
;
; Move "down" to next occurrence
;
        inc     [Ws_LF_Occur_Curr]

;
; Are we still in the current "window"?
;
        mov     dx, [WS_LF_OCCUR_W_CURR_MAX]            ; Max occurrence of window
        cmp     [Ws_LF_Occur_W_Curr], dx                ; Current occurr = max window?
        je      @@21                                    ; Yes
                                                        ; No, so
        inc     [Ws_LF_Occur_W_Curr]
        jmp     @@05

@@21:
;
; Move occurrences up
;
        mov     cx, [Ws_LF_Occur_Curr]                  ; Get current occurrence
        sub     cx, [WS_LF_OCCUR_W_CURR_MAX]            ; Calculate window size
        inc     cx
        jmp     @@45

;------------
; KEY PAGE UP
;------------
@@25:
        cmp     [Ws_LF_Occur_Curr], 1                   ; Can we go "up" anyhow?
        je      @@10                                    ; No
                                                        ; Yes, so
;
; Move up to previous window
;
        mov     cx, [Ws_LF_Occur_Curr]                  ; Current occurrence
        sub     cx, [Ws_LF_Occur_W_Curr]                ; Determine begin of window
        inc     cx                                      ; Which is done now
        cmp     cx, [WS_LF_OCCUR_W_CURR_MAX]            ; Can we subtract 1 page?
        jl      @@26                                    ; No
                                                        ; Yes, so
        sub     cx, [WS_LF_OCCUR_W_CURR_MAX]            ; Subtract size of 1 page
        jmp     @@27

@@26:
        mov     cx, 1                                   ; Go to beginning of occur

@@27:
;
; Determine Window occurrence
;
        mov     dx, cx
        add     dx, [Ws_LF_Occur_W_Curr]
        dec     dx
        mov     [Ws_LF_Occur_Curr], dx
        jmp     @@45

;--------------
; KEY PAGE DOWN
;--------------
@@30:
        mov     cx, [Ws_LF_Occur_Curr]                  ; Can we go "down" anyhow?
        sub     cx, [Ws_LF_Occur_W_Curr]                ; Determine begin of window
        inc     cx                                      ; Which is done now
        add     cx, [WS_LF_OCCUR_W_CURR_MAX]            ; Add size of 1 page
        cmp     cx, [Ws_LF_Occur_Max]                   ; Is there a next window?
        jnle    @@10                                    ; No
                                                        ; Yes, so
;
; Determine window occurrence
;
        mov     dx, cx
        add     dx, [Ws_LF_Occur_W_Curr]                ; Go to same window occurrence
        dec     dx                                      ; Which is done now
        cmp     dx, [Ws_LF_Occur_Max]                   ; Does it exist?
        jle     @@31                                    ; Yes
                                                        ; No, so
        mov     bx, dx                                  ; bx = dx
        sub     bx, [Ws_LF_Occur_Max]                   ; Determine difference
        sub     [Ws_LF_Occur_W_Curr], bx                ; Go to last occurrence
        mov     dx, [Ws_LF_Occur_Max]

@@31:
        mov     [Ws_LF_Occur_Curr], dx
        jmp     @@45

;---------
; KEY HOME
;---------
@@35:
        cmp     [Ws_LF_Occur_Curr], 1                   ; Can we go "up" anyhow?
        je      @@10                                    ; No
                                                        ; Yes, so
        mov     cx, [Ws_LF_Occur_Curr]                  ; Current occurrence
        sub     cx, [Ws_LF_Occur_W_Curr]                ; Determine begin of window
        inc     cx                                      ; Which is done now
        cmp     cx, 1                                   ; Showing from 1st already?
        jne     @@36                                    ; No
                                                        ; Yes, so
        cmp     [Ws_LF_Occur_W_Curr], 1                 ; At top of window?
        je      @@10                                    ; Yes
                                                        ; No, so
@@36:
        mov     cx, 1                                   ; Go to beginning of screen
        mov     [Ws_LF_Occur_W_Curr], 1
        mov     [Ws_LF_Occur_Curr], 1
        jmp     @@45

;--------
; KEY END
;--------
@@40:
        mov     cx, [Ws_LF_Occur_Curr]                  ; Current occurrence
        cmp     cx, [Ws_LF_Occur_Max]                   ; Can we go "down" anyhow?
        je      @@10                                    ; No
                                                        ; Yes, so
        mov     cx, [Ws_LF_Occur_Max]                   ; Go to last occurrence
        mov     [Ws_LF_Occur_Curr], cx                  ; Go to last occurrence in table
        cmp     cx, [WS_LF_OCCUR_W_CURR_MAX]            ; Does it all fit in 1 window?
        jnle    @@41                                    ; No
                                                        ; Yes, so
        mov     [Ws_LF_Occur_W_Curr], cx                ; Go  to  last entry in window
        mov     cx, 1                                   ; Start from first occurrence
        jmp     @@45

@@41:
;
; Determine window occurrence
;
        sub     cx, [WS_LF_OCCUR_W_CURR_MAX]            ; Subtract 1 page
        inc     cx                                      ; We are at the last page now
        mov     dx, [WS_LF_OCCUR_W_CURR_MAX]            ; Get last window occurrence
        mov     [Ws_LF_Occur_W_Curr], dx                ; Move to last window occurrence
        jmp     @@45

;--------------------------------------------
; Set up dir/image window data and attributes
;--------------------------------------------
@@45:
        mov     si, offset Ws_LF_F_Dir_Fil

        push    ds si
        pop     di es

        xor     ax, ax
        mov     al, [(Wsio_Field ptr di).Size]

        push    es di

        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]

        jmp     @@47

@@46:
        add     di, ax

@@47:
        loop    @@46

        mov     ax, es
        mov     bx, di

        pop     di es

        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ax
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], bx

        jmp     @@00

;----------
; KEY ENTER
;----------
@@50:
        mov     si, offset Ws_LF
        push    ds si
        pop     di es

        xor     bx, bx
        mov     bl, [(Wsio_Area ptr di).Select_Field_Occur_Nr]

        mov     [Mouse_Pressed], LOGIC_NO

        xor     cx, cx
        mov     cl, [(Wsio_Area ptr di).Cursor_Position_Row]
        cmp     cl, CURSOR_OFF_SCREEN                   ; Enter by mouse press?
        je      @@51                                    ; No
                                                        ; Yes, so
        mov     [Mouse_Pressed], LOGIC_YES

;
; Mouse pressed Enter, is it valid?
;
        cmp     cl, 22                                  ; ENTER pressed?
        je      @@51                                    ; Yes
                                                        ; No, so
        cmp     cl, 4                                   ; Valid occurrence?
        jl      @@10                                    ; No
                                                        ; Maybe
        cmp     cl, 20                                  ; Valid occurrence?
        jnle    @@10                                    ; No
                                                        ; Maybe
        sub     cl, 3                                   ; Determine occurrence
        mov     dx, [Ws_LF_Occur_Curr]                  ; Current occurrence
        sub     dx, bx
        add     dx, cx
        cmp     dx, [Ws_LF_Occur_Max]                   ; Valid occurrence?
        jnle    @@10                                    ; No
                                                        ; Yes, so
        mov     [Ws_LF_Occur_Curr], dx                  ; Set occurrence
        mov     [Ws_LF_Occur_W_Curr], cx

@@51:
        push    ds si

;
; Go to end of path
;
        mov     si, offset Search_Dirs_Path             ; 73 chars for Path
        push    ds si
        pop     di es
        mov     cx, PATH_LENGTH
        dec     cx                                      ; To go to the last character
        add     di, cx                                  ; Go to end of path
        std                                             ; Search direction is down
        mov     ax, BACKSLASH                           ; Search for "\"
        repne   scasb                                   ; Search uses es:di
        cld                                             ; Cancel the std setting
        inc     di                                      ; Pointer adjustment after search
        inc     di                                      ; To postion after the "\"

;
; Determine selected directory/file
;
        mov     ax, [Ws_LF_Occur_Curr]
        dec     ax                                      ; Because of offset reasons
        xor     bx, bx
        mov     cx, DIR_ENTRY_LENGTH
        xor     dx, dx
        mul     cx

;
; Go to drive selection or dirs?
;        
        push    es di

        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]
        add     di, ax
        cmp     [byte es:di], DOT                       ; Go to drive selection/dirs?
        jne     @@63                                    ; No
                                                        ; Yes, so
        pop     di es                                   ; Check path
        pop     si ds
        cmp     [byte es:di - 2], COLON                 ; Go to drive selection?
        jne     @@62                                    ; No
                                                        ; Yes, so
        jmp     @@60                                    ; Go to drive selection

;---------------------------------------------------
; KEY F2 - Acceptance current directory to be ATR-ed
;---------------------------------------------------
@@55:
        call    Add_DirFiles_To_ATR_Image
        jmp     @@00

;------------------------------
; KEY F3 - Select another drive
;------------------------------
@@60:
;
; Select another drive
;

;
; Reset Search Files Path
;
        mov     si, offset Search_Files_Path
        push    ds si
        pop     di es
        mov     cx, PATH_LENGTH
        mov     ax, SPACE
        rep     stosb                                   ; Clear path

        call    Display_Ws_PA                           ; Display path
        call    Display_and_Read_Ws_DR                  ; Let user select drive

        cmp     al, KEY_ESC                             ; Cancel pressed?
        je      @@99                                    ; Yes
                                                        ; No, so
@@61:
        mov     [Dir_Up], 0                             ; We stay in the current dir
        call    Read_VTOC_Directories_Files             ; Retrieve directories/files

        cmp     [Ws_LF_Occur_Max], 0                    ; Drive not ready?
        je      @@60                                    ; Yes
                                                        ; No, so
        mov     si, offset Ws_LF
        mov     [byte ds:si], WSIO_DISPLAY_ONLY

        push    ds si
        call    WSIO
        pop     si ds

        jmp     @@05

@@62:
;
; Go to previous dir
;
        dec     di                                      ; Position on the "\"
        dec     di                                      ; Position before the "\"
        std                                             ; Search direction is down
        mov     cx, DIR_NAME_LENGTH + 1
        mov     ax, BACKSLASH                           ; Search for "\"
        repne   scasb                                   ; Search uses es:di
        cld                                             ; Cancel the std setting
        inc     di                                      ; Pointer adjustment after search
        inc     di                                      ; To postion after the "\"

        mov     cx, DIR_NAME_LENGTH + 1                 ; Because of "\"
        add     cx, FILE_NAME_LENGTH                    ; Because of *.ATR
        mov     ax, SPACE
        rep     stosb

        mov     [Dir_Up], 1                             ; We go to previous dir
        call    Read_VTOC_Directories_Files             ; Retrieve directories/files
        cmp     [Ws_LF_Occur_Max], 0                    ; Drive ready?
        je      @@60                                    ; No
                                                        ; Yes, so
        jmp     @@00

@@63:
;
; Go to subdir OR do nothing
;
        push    es di
        add     di, FILE_NAME_LENGTH + 1                ; Go to file size
        cmp     [byte es:di], "<"                       ; Directory indicator
        pop     si ds                                   ; From -> Dir/File table

        pop     di es                                   ; To   -> Path
        jne     @@64                                    ; It's a file!
                                                        ; It's a directory, so
        mov     cx, DIR_NAME_LENGTH
        rep     movsb

        pop     si ds

        dec     di
        std                                             ; Search direction is down
        mov     cx, DIR_NAME_LENGTH + 1
        mov     ax, SPACE                               ; Search for not equal " "
        repe    scasb                                   ; Search uses es:di
        cld                                             ; Cancel the std setting
        inc     di                                      ; Pointer adjustment after search
        inc     di                                      ; To position after the " "

        mov     [byte es:di], BACKSLASH

        mov     [Dir_Up], 2                             ; We go to a subdir
        call    Read_VTOC_Directories_Files             ; Retrieve directories/files

        cmp     [Ws_LF_Occur_Max], 0                    ; Drive not ready?
        je      @@60                                    ; Yes
                                                        ; No, so
        jmp     @@00

@@64:
        pop     si ds

        jmp     @@10

;----------------------
; KEY F4 - Config setup
;----------------------
@@65:
        call    Display_and_Read_Ws_CF
        jmp     @@00

;---------------------------
; Control Key + Drive Letter
;---------------------------
@@70:
        add     ax, 040h                                ; Turn drive into letter
        mov     cx, MAX_DRIVES                          ; Drives A thru Z
        mov     si, offset Available_Drives             ; Available drives

@@71:
        cmp     al, [byte ds:si]                        ; Selected drive present in table?
        je      @@72                                    ; Yes
                                                        ; No, so
        inc     si                                      ; Next drive from table
        loop    @@71                                    ; Check next drive
        jmp     @@60                                    ; Invalid drive, let user choose correct one

@@72:
        push    ax                                      ; Save drive letter

        mov     si, offset Search_Files_Path            ; Reset Search Files Path
        push    ds si
        pop     di es
        mov     cx, PATH_LENGTH
        mov     ax, SPACE
        rep     stosb

        mov     si, offset Search_Dirs_Path             ; Reset Search Dirs Path
        push    ds si
        pop     di es
        inc     di
        mov     cx, PATH_LENGTH - 1
        mov     ax, SPACE
        rep     stosb

        mov     si, offset Search_Dirs_Path             ; Copy selected drive to path
        push    ds si
        pop     di es

        pop     ax                                      ; Restore drive letter

        mov     [byte es:di], al
        mov     [byte es:di + 1], COLON
        mov     [byte es:di + 2], BACKSLASH

        jmp     @@61                                    ; Retrieve directories/files of selected drive

;---------
; KEY HELP
;---------
@@90:
        call    Display_Ws_LH
        jmp     @@05

;-------
; Return
;-------
@@99:
        ret

ENDP    Display_and_Read_Ws_LF



;**********************************************************************
PROC    Display_Ws_LH
;**********************************************************************
        mov     si, offset Ws_LH
        mov     [byte ds:si], WSIO_OPEN
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_LH
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_LH
        mov     [byte ds:si], WSIO_CLOSE
        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_LH



;**********************************************************************
PROC    Display_and_Read_Ws_CF
;**********************************************************************
        mov     si, offset Ws_CF
        mov     [byte ds:si], WSIO_OPEN
        push    ds si
        call    WSIO
        pop     si ds

@@00:
        mov     si, offset Ws_CF
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ
        push    ds si
        call    WSIO
        pop     si ds

        cmp     al, KEY_ESC                             ; Cancel pressed?
        je      @@99                                    ; Yes
                                                        ; No, so
;
; Filemask
;
        mov     si, offset Search_Filemask
        push    ds si
        pop     di es
        mov     si, offset Config_Field_Filemask
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

;
; Include DOS Files
;
        mov     [Config_Include_DOSFILES_YN], LOGIC_NO

        mov     si, offset Config_Field_Include_DOS
        cmp     [byte ds:si], "N"                       ; Check if No is specified
        je      @@01                                    ; No is specified
                                                        ; Include DOS_SYS
        mov     [Config_Include_DOSFILES_YN], LOGIC_YES

@@01:
;
; Include DOS Files
;
        mov     [Config_Include_DUP_SYS_YN], LOGIC_NO

        mov     si, offset Config_Field_Include_DUP_SYS
        cmp     [byte ds:si], "N"                       ; Check if No is specified
        je      @@02                                    ; No is specified
                                                        ; Include DUP_SYS
        mov     [Config_Include_DUP_SYS_YN], LOGIC_YES

@@02:
;
; Include MAIN       
;
        mov     [Config_MAIN_YN], LOGIC_NO

        mov     si, offset Config_Field_MAIN
        cmp     [byte ds:si], "N"                       ; Check if No is specified
        je      @@03                                    ; No is specified
                                                        ; Use MAIN
        mov     [Config_MAIN_YN], LOGIC_YES

@@03:
;
; Get "new" list of drives
;
        push    ax                                      ; Save pressed key

        call    Read_VTOC_Drives

        pop     ax                                      ; Restore pressed key
        cmp     [Ws_DR_Occur_Max], 0                    ; Any valid drive present?
        je      @@00                                    ; No
                                                        ; Yes, so
;
; Check for update of configuration file
;
        cmp     al, KEY_F2                              ; Update config file
        jne     @@99                                    ; No
                                                        ; Yes, so
;
; Update DIR2ATR.CFG configuration file
;
@@05:
;
; Allocate Memory (15KB) to store old configuration file information
;
        mov     ax, DOS_GET_ALLOCATION_STRATEGY
        int     DOS_SERVICE

        mov     [Allocation_Strategy_Old], ax
        mov     [Allocation_Strategy_New], ax

        mov     bx, [Allocation_Strategy_New]
        or      bx, DOS_STRATEGY_MEM_UMB_CONV
        or      bx, DOS_STRATEGY_MEM_BEST_FIT
        mov     [Allocation_Strategy_New], bx

        mov     ax, DOS_SET_ALLOCATION_STRATEGY
        mov     bx, [Allocation_Strategy_New]
        int     DOS_SERVICE                             ; Set new strategy
        jnc     @@10                                    ; Failed?
                                                        ; Yes, so
        mov     ax, DOS_SET_ALLOCATION_STRATEGY
        mov     bx, [Allocation_Strategy_Old]
        int     DOS_SERVICE                             ; Reset to old strategy

@@10:
;
; Allocate Memory now for 80 rows of config file data
;
        mov     ax, CONFIG_FILE_ROW_COUNT               ; 80 lines of data
        xor     bx, bx
        mov     cx, CONFIG_FILE_LINE_SIZE               ; 128 bytes line size
        xor     dx, dx
        mul     cx                                      ; 80 x 128 bytes

        mov     [Config_File_Bytes_Reserved], ax

        xor     ax, ax                                  ; Reset ax
        mov     ah, DOS_ALLOCATE_MEMORY
        mov     bx, [Config_File_Bytes_Reserved]        ; Reserve 10 KB
        xor     cx, cx                                  ; Reset cx
        xor     dx, dx                                  ; Reset dx
        int     DOS_SERVICE                             ; Allocate Memory in paragraphs (= 16 bytes)
        mov     cx, ax
        jnc     @@15

;
; Error, Memory Allocation
;
        mov     ax, DOS_SET_ALLOCATION_STRATEGY
        mov     bx, [Allocation_Strategy_Old]
        int     DOS_SERVICE                             ; Reset to old strategy

        jmp     @@99

@@15:
        mov     ax, DOS_SET_ALLOCATION_STRATEGY
        mov     bx, [Allocation_Strategy_Old]
        int     DOS_SERVICE                             ; Reset to old strategy

        push    cx                                      ; Determine address of allocated memory block
        pop     es
        xor     di, di
        push    es di                                   ; Save address of memory block

;
; Clear memory block
;
        mov     cx, [Config_File_Bytes_Reserved]
        xor     ax, ax
        mov     al, SPACE                               ; Fill character
        rep     stosb                                   ; Initialize

;
; Read Dir2atr.cfg configuration file
;
        pop     bx ax
        push    ax bx

        mov     si, offset CONFIG___File
        push    ds si
        pop     di es

        mov     [(FMS_Area ptr di).Data_Address_Hi], ax
        mov     [(FMS_Area ptr di).Data_Address_Lo], bx
        mov     [(FMS_Area ptr di).Request], CMD_OPEN_INPUT
        push    es di
        call    FMSIO
        pop     di es

        cmp     [(FMS_Area ptr di).Status], STATUS_OK
        jne     @@40                                    ; Error!

        mov     [(FMS_Area ptr di).Request], CMD_ACCESS_GET

;
; Read Dir2atr.cfg file into allocated memory block
;

@@20:
;
; Get line from config file
;
        mov     si, offset CONFIG___File
        push    ds si
        call    FMSIO
        pop     di es

        cmp     [(FMS_Area ptr di).Status], STATUS_OK
        jne     @@30                                    ; No
                                                        ; Yes, so
        adc     [(FMS_Area ptr di).Data_Address_Lo], CONFIG_FILE_LINE_SIZE
        jnc     @@20
        inc     [(FMS_Area ptr di).Data_Address_Hi]
        jmp     @@20

@@30:
;
; Indicate input termination in memory file
;
        cmp     [(FMS_Area ptr di).Record_Size], 0      ; EOF found at end of line?
        je      @@35                                    ; No
                                                        ; Yes, so

        adc     [(FMS_Area ptr di).Data_Address_Lo], CONFIG_FILE_LINE_SIZE
        jnc     @@35
        inc     [(FMS_Area ptr di).Data_Address_Hi]

@@35:
        push    es di

        mov     ax, [(FMS_Area ptr di).Data_Address_Hi]
        mov     di, [(FMS_Area ptr di).Data_Address_Lo]
        mov     es, ax
        mov     [byte es:di], NULL

        pop     di es

;
; Close configuration file
;
        mov     [(FMS_Area ptr di).Request], CMD_OPEN_CLOSE
        push    es di
        call    FMSIO
        pop     di es

        jmp     @@45

@@40:
        pop     di es
        push    es di
        mov     cx, CONFIG_PARAMETERS + 1

@@41:
        mov     [byte es:di], NULL
        add     di, CONFIG_FILE_LINE_SIZE
        loop    @@41

        mov     si, offset CONFIG___File
        push    ds si
        pop     di es

;
; Create Dir2atr.cfg configuration file
;
@@45:
        pop     bx ax
        push    ax bx

        mov     [(FMS_Area ptr di).Data_Address_Hi], ax
        mov     [(FMS_Area ptr di).Data_Address_Lo], bx
        mov     [(FMS_Area ptr di).Request], CMD_OPEN_OUTPUT
        push    es di
        call    FMSIO
        pop     di es

        cmp     [(FMS_Area ptr di).Status], STATUS_OK
        jne     @@90                                    ; Error!

        mov     [(FMS_Area ptr di).Request], CMD_ACCESS_PUT

        mov     [Parm_Being_Processed], 0

@@50:
;
; Prepare config "line" to be written
;
        push    es di
        mov     [(FMS_Area ptr di).Record_Size], CONFIG_FILE_LINE_SIZE
        mov     ax, [(FMS_Area ptr di).Data_Address_Hi]
        mov     di, [(FMS_Area ptr di).Data_Address_Lo]
        mov     es, ax
        mov     al, [byte es:di]
        pop     di es

        cmp     al, NULL                                ; Last line processed
        je      @@70                                    ; Yes
                                                        ; No, so
        cmp     al, COMMENT_ROW                         ; Comment "line"?
        je      @@60                                    ; Yes
                                                        ; No, so
        cmp     al, SPACE                               ; Empty "line"?
        jne     @@70                                    ; No
                                                        ; Yes, so
@@60:
;
; Write config "line" (comment, etc.)
;
        push    es di
        call    FMSIO
        pop     di es

        cmp     [(FMS_Area ptr di).Status], STATUS_OK
        jne     @@80                                    ; Error!

        adc     [(FMS_Area ptr di).Data_Address_Lo], CONFIG_FILE_LINE_SIZE
        jnc     @@50
        inc     [(FMS_Area ptr di).Data_Address_Hi]
        jmp     @@50

@@70:
;
; Write config "line" (parameter)
;
        push    es di
        mov     bx, [(FMS_Area ptr di).Data_Address_Hi]
        mov     di, [(FMS_Area ptr di).Data_Address_Lo]
        mov     es, bx
        inc     [Parm_Being_Processed]

;
; Which parameter to process?
;
        mov     bx, MAX_DRIVES                          ; Field Size
        mov     si, offset Config_Field_Read_From
        cmp     [Parm_Being_Processed], 1               ; Parm Drives?
        je      @@75                                    ; Yes
                                                        ; No, so
        mov     bx, PATH_LENGTH                         ; Field Size
        mov     si, offset Config_Field_Write_To
        cmp     [Parm_Being_Processed], 2               ; Parm Filemask?
        je      @@75                                    ; Yes
                                                        ; No, so
        mov     bx, 1                                   ; Field Size
        mov     si, offset Config_Field_DIsk_Density
        cmp     [Parm_Being_Processed], 3               ; Disk Density?
        je      @@75                                    ; Yes
                                                        ; No, so
        mov     bx, 1                                   ; Field Size
        mov     si, offset Config_Field_ATR_Or_XFD
        cmp     [Parm_Being_Processed], 4               ; ATR or XFD?
        je      @@75                                    ; Yes
                                                        ; No, so
        mov     bx, PATH_LENGTH                         ; Field Size
        mov     si, offset Config_Field_DOS_Path
        cmp     [Parm_Being_Processed], 5               ; DOS Path?
        je      @@75                                    ; Yes
                                                        ; No, so
        mov     bx, 1                                   ; Field Size
        mov     si, offset Config_Field_Disk_Format
        cmp     [Parm_Being_Processed], 6               ; Disk Format?
        je      @@75                                    ; Yes
                                                        ; No, so
        mov     bx, 1                                   ; Field Size
        mov     si, offset Config_Field_Include_DOS
        cmp     [Parm_Being_Processed], 7               ; Include DOS?
        je      @@75                                    ; Yes
                                                        ; No, so
        mov     bx, 1                                   ; Field Size
        mov     si, offset Config_Field_Include_DUP_SYS
        cmp     [Parm_Being_Processed], 8               ; Include DUP.SYS?
        je      @@75                                    ; Yes
                                                        ; No, so
        mov     bx, 1                                   ; Field Size
        mov     si, offset Config_Field_MAIN
        cmp     [Parm_Being_Processed], 9               ; Use MAIN SpartaDos dir?
        je      @@75                                    ; Yes
                                                        ; No, so
        pop     di es

        cmp     al, NULL                                ; Last line processed
        jne     @@50                                    ; No
                                                        ; Yes, so
        jmp     @@80

@@75:
        mov     cx, CONFIG_FILE_LINE_SIZE
        rep     movsb

        pop     di es
        mov     [(FMS_Area ptr di).Record_Size], bx
        jmp     @@60

@@80:
;
; Close config file
;
        mov     [(FMS_Area ptr di).Request], CMD_OPEN_CLOSE
        push    es di
        call    FMSIO
        pop     di es

@@90:
;
; Release Allocated Memory
;
        pop     di es
        xor     ax, ax
        mov     ah, DOS_FREE_ALLOCATED_MEMORY
        int     DOS_SERVICE                         ; Release Allocated Memory

@@99:
        mov     si, offset Ws_CF
        mov     [byte ds:si], WSIO_CLOSE
        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_and_Read_Ws_CF



;**********************************************************************
PROC    Add_DirFiles_To_ATR_Image
;**********************************************************************
        cmp     [CLI_Used], LOGIC_YES                   ; Command Line Interface used?
        je      @@10                                    ; Yes
                                                        ; No, so
;--------
; Use GUI
;--------
        mov     si, offset Search_Files_Path            ; Parameter 1
        push    ds si

        mov     si, offset Config_Field_Write_To        ; Parameter 2
        push    ds si

        mov     si, offset Config_Field_Disk_Density    ; Parameter 3
        push    ds si

        mov     si, offset Config_Field_ATR_Or_XFD      ; Parameter 4
        push    ds si

        mov     si, offset Config_Field_DOS_Path        ; Parameter 5
        push    ds si

        mov     si, offset Config_Field_Disk_Format     ; Parameter 6
        push    ds si

        mov     si, offset Config_Include_DOSFILES_YN   ; Parameter 7
        push    ds si

        mov     si, offset Config_Include_DUP_SYS_YN    ; Parameter 8
        push    ds si

        mov     si, offset Config_MAIN_YN               ; Parameter 9
        push    ds si

        mov     si, offset Available_Drives             ; Parameter 10
        push    ds si

        mov     si, offset Ws_DR_D_Drive                ; Parameter 11
        push    ds si

        mov     si, offset CLI_used                     ; Parameter 12
        push    ds si

        jmp     @@20

@@10:
;--------
; Use CLI
;--------
        mov     si, offset CLI_Indir                    ; Parameter 1
        push    ds si

        mov     si, offset CLI_Outdisk                  ; Parameter 2
        push    ds si

        mov     si, offset CLI_Disk_Density             ; Parameter 3
        push    ds si

        mov     si, offset CLI_Atr_Or_Xfd               ; Parameter 4
        push    ds si

        mov     si, offset Config_Field_DOS_Path        ; Parameter 5
        push    ds si

        mov     si, offset CLI_Disk_Format              ; Parameter 6
        push    ds si

        mov     si, offset Config_Include_DOSFILES_YN   ; Parameter 7
        push    ds si

        mov     si, offset Config_Include_DUP_SYS_YN    ; Parameter 8
        push    ds si

        mov     si, offset Config_MAIN_YN               ; Parameter 9
        push    ds si

        mov     si, offset CLI_Include_Subdirs          ; Parameter 10
        push    ds si

        mov     si, offset CLI_Include_Subdirs          ; Parameter 11
        push    ds si

        mov     si, offset CLI_used                     ; Parameter 12
        push    ds si

@@20:
        call    D_FILDSK

        mov     cx, 24                                  ; Pop 12 parameters

@@30:
        pop     ax
        loop    @@30

        ret

ENDP    Add_DirFiles_To_ATR_Image



;**********************************************************************
PROC    Close_Ws_BG
;**********************************************************************
        mov     si, offset Ws_BG
        mov     [byte ds:si], WSIO_CLOSE
        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Close_Ws_BG



;**********************************************************************
PROC    Exit_Program
;**********************************************************************
        mov     ah, DOS_TERMINATE_EXE
        mov     al, [Return_Code]                   ; Return code value
        int     DOS_SERVICE

ENDP    Exit_Program



ENDS    CSeg                                        ; End of Code segment

END     Main
