%TITLE          "Pc Directory to XL/XE .ATR Disk Image File Creator - CHiPS bv 1998"
;**********************************************************************
;**                                                                  **
;**  Program   : D_FILDSK                                            **
;**  Purpose   : Pc Directory to XL/XE .ATR Disk Image Creator       **
;**                                                                  **
;**  Author    : B.F. Schreurs                                       **
;**              Computer High Performance Software (CHiPS) bv       **
;**  Date      : May 15, 1998                                        **
;**                                                                  **
;**  Calls     : APPEND   - Glue 2 strings together                  **
;**              DC_DIRS  - Determine Current Directories            **
;**              DC_FILES - Determine Current Files                  **
;**              FMSIO    - File Management System Handler           **
;**              D_SPARTA - Create a SpartaDos disk                  **
;**              HEX2DIGI - Convert Hex Data To Digits (Text)        **
;**              WSIO     - Screen Handler                           **
;**                                                                  **
;**  Parameter : 1. Pass the address of the directory path where the **
;**                 files reside to be placed on an ATR disk image.  **
;**                 Size is PATH_LENGTH.                             **
;**  Parameter : 2. Pass the address of the directory path where the **
;**                 ATR disk image(s) will be stored.                **
;**                 Size is PATH_LENGTH.                             **
;**  Parameter : 3. Pass the address of the Disk density to use      **
;**                 Size is 1                                        **
;**  Parameter : 4. Pass the address of the Create ATR or XFD disk   **
;**                 Size is 1                                        **
;**  Parameter : 5. Pass the address of the DOS path                 **
;**                 Size is PATH_LENGTH.                             **
;**  Parameter : 6. Pass the address of the Disk Format DOS or MYDOS **
;**                 Size is 1                                        **
;**  Parameter : 7. Pass the address of the DOS included YN field    **
;**                 Size is 1                                        **
;**  Parameter : 8. Pass the address of the DUP.SYS included YN field**
;**                 Size is 1                                        **
;**  Parameter : 9. Pass the address of the use of MAIN dir YN field **
;**                 Size is 1                                        **
;**  Parameter :10. Pass the address of the available drives         **
;**                 in the format ABCDE etc.                         **
;**                 Size is MAX_DRIVES                               **
;**                 In case of a CLI, this address contains:         **
;**                 Include Subdirectories Logic Yes or No.          **
;**                 Size is 1                                        **
;**  Parameter :11. Pass the address of the available drives         **
;**                 in the format [A: Mydiskette ]                   **
;**                               [C: Harddisk_C ] etc.              **
;**                 Size is MAX_DRIVES * DRIVE_AREA_STRUCTURE_SIZE   **
;**                 In case of a CLI, this address is irrelevant     **
;**  Parameter :12. Pass the address of the usage of a CLI           **
;**                 Size is 1                                        **
;**                                                                  **
;**  Language  : Turbo Assembler                                     **
;**                                                                  **
;**********************************************************************
        IDEAL
        JUMPS

;----------------------------------------------------------------------
;--  Functions which can be called                                   --
;----------------------------------------------------------------------
        PUBLIC  D_FILDSK

;----------------------------------------------------------------------
;--  Equates                                                         --
;----------------------------------------------------------------------
include ".\equ\attrib.equ"
include ".\equ\dos.equ"
include ".\equ\fmsio.equ"
include ".\equ\keyboard.equ"
include ".\equ\sysdep.equ"
include ".\equ\video.equ"
include ".\equ\wsio.equ"

EXTRA_TABLE_FIELDS                      EQU     16
DIR_MAP_LENGTH                          EQU (MAX_DIRS_AND_FILES + EXTRA_TABLE_FIELDS) * DIR_ENTRY_LENGTH
CONFIG_FILE_LINE_SIZE                   EQU    256
WS_DR_D_DRIVE_SIZE                      EQU    672
WS_E2_ERROR_MESSAGE_SIZE                EQU     40

ATR_HEADER_SIZE                         EQU     16

EIGHTBIT_VTOC_DISPLACEMENT_DOUBLE       EQU      8
EIGHTBIT_VTOC_SLOT_DOUBLE               EQU     16
EIGHTBIT_VTOC_FILES                     EQU     64
EIGHTBIT_VTOC_SIZE                      EQU   1024
EIGHTBIT_VTOC_SIZE_DOUBLE               EQU   2048

EIGHTBIT_FILE_ENTRY_SIZE                EQU     16
EIGHTBIT_FILE_NAME_LENGTH               EQU     11

EIGHTBIT_SECTOR_PHANTOM                 EQU    720
EIGHTBIT_SECTOR_FREE_SPACE              EQU   1040

EIGHTBIT_SECTOR_SIZE                    EQU    128
EIGHTBIT_SECTOR_DATA_SIZE               EQU    125

EIGHTBIT_SECTOR_BITMAP_EXTENDED_MYDOS   EQU    359
EIGHTBIT_SECTOR_BITMAP                  EQU    360
EIGHTBIT_SECTOR_VTOC_START              EQU    361
EIGHTBIT_SECTOR_VTOC_END                EQU    368
EIGHTBIT_SECTOR_ADDRESSABLE             EQU   1023
EIGHTBIT_SECTOR_BITMAP_EXTENDED_DOS25   EQU   1024

EIGHTBIT_SECTOR_SIZE_DOUBLE             EQU    256
EIGHTBIT_SECTOR_DATA_SIZE_DOUBLE        EQU    253

DISK_SECTOR_BEG                         EQU      4
DISK_BOOTCODE_SIZE                      EQU    384
DISK_BOOTCODE_SECTOR_SIZE               EQU      3
;---------------------------
DISK_MEDIA_TYPE_SINGLE                  EQU     "S"
DISK_SECTORS_SINGLE                     EQU    720
DISK_SECTORS_SINGLE_USABLE              EQU    706
;---------------------------
DISK_MEDIA_TYPE_MEDIUM                  EQU     "M"
DISK_SECTORS_MEDIUM                     EQU   1040
DISK_SECTORS_MEDIUM_USABLE              EQU   1009
;---------------------------
DISK_MEDIA_TYPE_DOUBLE                  EQU     "D"
DISK_SECTORS_DOUBLE                     EQU    720
DISK_SECTORS_DOUBLE_USABLE              EQU    706
;---------------------------
DISK_MEDIA_TYPE_QUAD                    EQU     "Q"
DISK_SECTORS_QUAD                       EQU   1440
DISK_SECTORS_QUAD_USABLE                EQU   1427
;---------------------------
DISK_MEDIA_TYPE_720KB                   EQU     "7"
DISK_SECTORS_720KB                      EQU   2880
DISK_SECTORS_720KB_USABLE               EQU   2867
;---------------------------
DISK_MEDIA_TYPE_1440KB                  EQU     "1"
DISK_SECTORS_1440KB                     EQU   5760
DISK_SECTORS_1440KB_USABLE              EQU   5747
;---------------------------
DISK_MEDIA_TYPE_HARDDISK                EQU     "H"
DISK_SECTORS_HARDDISK                   EQU  65535
DISK_SECTORS_HARDDISK_USABLE            EQU  65522
;---------------------------

DOS25_FORMAT                            EQU     "D"
MYDOS_FORMAT                            EQU     "M"
MYOWNDOS_MYDOS_FORMAT                   EQU     "O"
BEWEDOS_FORMAT                          EQU     "B"
SPARTADOS_FORMAT                        EQU     "S"
SPARTADOSX_FORMAT                       EQU     "X"
MYOWNDOS_SPARTADOS_FORMAT               EQU     "Y"

LAST_SECTOR_IN_BITMAP_DOS25             EQU    719
LAST_SECTOR_IN_BITMAP_MYDOS             EQU    943



;**********************************************************************
SEGMENT SSeg Para Stack 'STACK'
;**********************************************************************

        db       256 dup (0)            ; Stack

ENDS    SSeg

;**********************************************************************
SEGMENT DSeg Word Public 'DATA'
;**********************************************************************

;----------------------------------------------------------------------
;--  Structures                                                      --
;----------------------------------------------------------------------
include ".\str\direntry.str"
include ".\str\dta.str"
include ".\str\fmsio.str"
include ".\str\position.str"
include ".\str\wsio.str"

;----------------------------------------------------------------------
;--  SELECT and FD                                                   --
;----------------------------------------------------------------------
;
; Atari Disk Image
;
ATARI____File                   FMS_Area <>
ATARI____Pathname               DB  PATH_LENGTH        dup (SPACE)
                                DB    1 dup (0)

;
; Extracted Atari Disk Image (pc) File
;
PC_ATARI_File                   FMS_Area <>
PC_ATARI_Pathname               DB  PATH_LENGTH        dup (SPACE)
                                DB    1 dup (0)

;----------------------------------------------------------------------
;--  Working Storage                                                 --
;----------------------------------------------------------------------
GLOBAL Return_Code:Byte:1

Parm_Files_ptr_es               DW    1 dup (NULL)
Parm_Files_ptr_di               DW    1 dup (NULL)

Parm_Location_ptr_es            DW    1 dup (NULL)
Parm_Location_ptr_di            DW    1 dup (NULL)

Parm_Density_ptr_es             DW    1 dup (NULL)
Parm_Density_ptr_di             DW    1 dup (NULL)

Parm_ATR_Or_XFD_ptr_es          DW    1 dup (NULL)
Parm_ATR_Or_XFD_ptr_di          DW    1 dup (NULL)

Parm_DOS_Path_ptr_es            DW    1 dup (NULL)
Parm_DOS_Path_ptr_di            DW    1 dup (NULL)

Parm_DISK_FORMAT_ptr_es         DW    1 dup (NULL)
Parm_DISK_FORMAT_ptr_di         DW    1 dup (NULL)

Parm_INCLUDE_DOS_ptr_es         DW    1 dup (NULL)
Parm_INCLUDE_DOS_ptr_di         DW    1 dup (NULL)

Parm_DUP_SYS_ptr_es             DW    1 dup (NULL)
Parm_DUP_SYS_ptr_di             DW    1 dup (NULL)

Parm_MAIN_Dir_ptr_es            DW    1 dup (NULL)
Parm_MAIN_Dir_ptr_di            DW    1 dup (NULL)

Parm_Drives_ptr_es              DW    1 dup (NULL)
Parm_Drives_ptr_di              DW    1 dup (NULL)

Parm_Drives_Txt_ptr_es          DW    1 dup (NULL)
Parm_Drives_Txt_ptr_di          DW    1 dup (NULL)

Parm_CLI_Used_ptr_es            DW    1 dup (NULL)
Parm_CLI_Used_ptr_di            DW    1 dup (NULL)

Parm_InclDirs_ptr_es            DW    1 dup (NULL)
Parm_InclDirs_ptr_di            DW    1 dup (NULL)

CLI_Used                        DB    LOGIC_NO
CLI_Include_Subdirs             DB    "N"

D_FilDsk_Initialize             DB    LOGIC_NO
Disk_Media_Type                 DB    DISK_MEDIA_TYPE_SINGLE

Requested_Format_Drives         DB   "1"        ; 1 = "ABCDEFGHIJKL    " etc.
                                                ; 2 = "A: [Floppy     ]"
                                                ;     "C: [HARD_DRIVE ]" etc.
Requested_Format_LibFil         DB   "1"        ; 1 = DIRENTRY format    etc.
                                                ; 2 = "..           <DIR>      "
                                                ;     "ATARI        <DIR>      "
Hex2digi_Requested_Format       DB  "2"         ; "1" = With thousand seperator
                                                ; "2" = No thousand seperator

Media_Id_Buffer                 DB   25                 dup (NULL)
Available_Drives                DB  MAX_DRIVES          dup (SPACE)
Directories_File_Mask           DB   "*.*         "
Search_Files_Path               DB  PATH_LENGTH         dup (SPACE)
                                DB  NULL                ; To satisfy DOS find file
Search_Dirs_Path                DB  PATH_LENGTH         dup (SPACE)
Search_Filemask                 DB  FILE_NAME_LENGTH    dup (SPACE)
PC_ATARI_DOS_Pathname           DB  PATH_LENGTH         dup (SPACE)
                                DB  NULL

Dir_DOS25                       DB   "DOS25\       "
Dir_MYDOS                       DB   "MYDOS\       "
Dir_SPARTADOS                   DB   "SPARTA\      "
Dir_SPARTADOSX                  DB   "SPARTAX\     "
Dir_BEWEDOS                     DB   "BEWEDOS\     "
Dir_MYOWNDOS                    DB   "MYOWNDOS\    "

File_Name_BOOTCODE              DB   "BOOTCODE     "
File_Name_DOS_SYS               DB   "DOS.SYS      "
File_Name_DUP_SYS               DB   "DUP.SYS      "

Save_cx                         DW    ?
Sectors_Per_Progress_Bar        DW    ? 

Dir_Memo_Occur_Curr             DW  MAX_DIRS dup (NULL) ; Remember from which dir we came
Dir_Memo_Occur_W_Curr           DW  MAX_DIRS dup (NULL) ; Remember from which dir we came
Dir_Memo_Pointer                DB    0
Dir_Up                          DB    0                 ; 0=Stay current
                                                        ; 1=Go dir up
                                                        ; 2=Go dir down
Disk_Present                    DB  LOGIC_NO
Dir2atr_Error                   DB  LOGIC_NO            ; 0=No Error
                                                        ; 1=Error Encountered
Atari_File_Name_Invalid_Char    DB    KEY_VALID_DOS     ; Translate to "_"
                                DB    NULL

Path_Spec                       DB   PATH_LENGTH dup (SPACE)
File_Map_Entry                  Dir_Entry <>

Dir_Entry_Files                 DW    0
Dir_Entry_Files_Processed       DW    0
Dir_Entry_File_Size             DW    0
Dir_Entry_ptr_es                DW    1 dup (NULL)
Dir_Entry_ptr_di                DW    1 dup (NULL)
Dir_Entry_Fits_On_Image         DB    LOGIC_NO

Ws_CF_Progress_Bar_Cnt_Prev             DB    0
Ws_CF_Progress_Bar_Cnt_Max              DB   32
Ws_CF_Progress_Bar_Cnt_Sectors_Hi       DW    0
Ws_CF_Progress_Bar_Cnt_Sectors_Lo       DW    0
Ws_CF_Progress_Bar_Sectors_Hi           DW    0
Ws_CF_Progress_Bar_Sectors_Lo           DW    0

Ws_FF_Progress_Bar_Cnt_Prev     DB    0
Ws_FF_Progress_Bar_Cnt_Max      DB   34
Ws_FF_Progress_Bar_Cnt_Sectors  DW    0
Ws_FF_Progress_Bar_Sectors      DW    0

Disk_Sector_Size                DW    ?
Disk_Sector_Data_Size           DW    ?

ATR_Header                      DB   096h,002h,080h,020h,080h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
ATR_Header_Single               DB   096h,002h,080h,016h,080h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
ATR_Header_Medium               DB   096h,002h,080h,020h,080h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
ATR_Header_Double               DB   096h,002h,0E8h,02Ch,000h,001h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
ATR_Header_Quad                 DB   096h,002h,0E8h,059h,000h,001h,000h,000h,000h,000h,000h,000h,000h,000h,000h,001h
ATR_Header_720KB                DB   096h,002h,000h,0B4h,000h,001h,000h,000h,000h,000h,000h,000h,000h,000h,000h,001h
ATR_Header_1440KB               DB   096h,002h,000h,068h,000h,001h,001h,000h,000h,000h,000h,000h,000h,000h,000h,001h
ATR_Header_Harddisk             DB   096h,002h,0F0h,0FFh,000h,001h,00Fh,000h,000h,000h,000h,000h,000h,000h,000h,001h

Bitmap_DOS25                    DB   002h,0F2h,003h,0F2h,003h,000h,000h,000h,000h,000h,00Fh,0FFh,0FFh,0FFh,0FFh,0FFh
                                DB   0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
                                DB   0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
                                DB   0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FEh,000h,07Fh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
                                DB   0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
                                DB   0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
                                DB   0FFh,0FFh,0FFh,0FFh,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
                                DB   000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h

Bitmap_Extended_DOS25           DB   0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
                                DB   0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
                                DB   0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,000h,07Fh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
                                DB   0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
                                DB   0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
                                DB   0FFh,0FFh,0FFh,0FFh,07Fh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
                                DB   0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
                                DB   0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,02Fh,001h,000h,000h,000h,000h

Bitmap_MYDOS                    DB   003h,003h,004h,003h,004h,000h,000h,000h,000h,000h,00Fh,0FFh,0FFh,0FFh,0FFh,0FFh
                                DB   0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
                                DB   0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
                                DB   0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FEh,000h,07Fh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
                                DB   0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
                                DB   0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
                                DB   0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
                                DB   0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh

Bitmap_Extended_MYDOS           DB   0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,080h,0FFh,0FFh,0FFh
                                DB   000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
                                DB   000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
                                DB   000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
                                DB   000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
                                DB   000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
                                DB   000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
                                DB   000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h

Last_Sector_In_Bitmap           DW    0

Disk_Name                       DB  "000"
                                DB  ".ATR     "
Disk_Seq_Nr                     DW    0
Disk_Seq_Nr_Present             DW    0

Passed_Parameters               DB  PATH_LENGTH dup (0)

Disk_Path                       DB  PATH_LENGTH dup (0) ; C:\TO
                                DB  NULL
File_Path                       DB  PATH_LENGTH dup (0) ; C:\FROM
                                DB  NULL
Temp_File_Name                  DB  "            "

Disk_Mask_ATR                   DB   "*.ATR       "
Disk_Mask_XFD                   DB   "*.XFD       "
File_Mask                       DB   "*.*         "
ATR_Disk_Image_Open             DB    1 dup (FALSE)
Atari_Files_Processed           DB    64
File_Size_In_Bytes_Hi           DW     0
File_Size_In_Bytes_Lo           DW     0
File_Size_In_Sectors            DW     0
Max_File_Size_In_Sectors        DW     0
Disk_Sector_Start               DW     4
Disk_Sector_Current             DW     4
Disk_Sector_Next                DW     5
Disk_Sector_Bitmap_Ext          DW  EIGHTBIT_SECTOR_BITMAP_EXTENDED_DOS25

Disk_Sectors                    DW     0
Disk_Sectors_Usable             DW     0
Disk_Sectors_Left               DW     0
Disk_Sectors_Available          DW     0

Vtoc_Size                       DW     0

Bytes_In_Sector                 DB     0

Old_Dta_Seg                     DW    ?                 ; Old Dta Segment Address
Old_Dta_Ofs                     DW    ?                 ; Old Dta Segment Offset
Own_Dta                         Dta <>

VTOC_I_O_Buffer                 DB  EIGHTBIT_VTOC_SIZE_DOUBLE   dup (0)
VTOC_I_O_Bitmap                 DB  EIGHTBIT_SECTOR_SIZE_DOUBLE dup (0)
VTOC_I_O_Bitmap_Extend          DB  EIGHTBIT_SECTOR_SIZE_DOUBLE dup (0)
Disk_I_O_Buffer                 DB  EIGHTBIT_SECTOR_SIZE_DOUBLE dup (0)
Disk_File_ID                    DB      0
Remainder_Bytes                 DB      0

; Supported DOS format types: "D"=DOS 2.5, "M"=MYDOS 4.53, "B"=BEWEDOS,
;                             "S"=SPARTADOS 3.3a, "X"=SPARTADOS/X
;                             "O"=User's DOS - MYDOS format
;                             "Y"=User's DOS - SPARTADOS format
Disk_Format                     DB  "D"

; Continue adding disks after highest disk number found? N=NO Y=YES
Disk_Adding                     DB  "N"

;
;   Atari Disk sector layout
;    Byte 1      Byte 125           Byte 126                 Byte 127                 Byte 128
; +----------//------------+------------------------+------------------------+------------------------+
;                          6 bits File ID    10 bits for Next Sector Addr  Byte Count per Sector  
; +----------//------------+------------------------+------------------------+------------------------+
;
;
;   MyDos Disk sector layout
;    Byte 1      Byte 125           Byte 126                 Byte 127                 Byte 128
; +----------//------------+------------------------+------------------------+------------------------+
;                                             16 bits for Next Sector Addr  Byte Count per Sector  
; +----------//------------+------------------------+------------------------+------------------------+
;
Bootcode_Data           DB  EIGHTBIT_SECTOR_SIZE dup (0)
                        DB  EIGHTBIT_SECTOR_SIZE dup (0)
                        DB  EIGHTBIT_SECTOR_SIZE dup (0)

;----------------------------------------------------------------------
;--                                                                  --
;--  C O N F I G U R A T I O N   F I L E                             --
;--                                                                  --
;----------------------------------------------------------------------
Config_Field_Filemask           DB    "*.*         "
Default_Startup_Path            DB  "C:\"
                                DB  PATH_LENGTH - 3   dup (SPACE)
                                DB  NULL
Config_Startup_Path             DB   PATH_LENGTH  dup (SPACE)
                                DB   1            dup (0)
                                DB   1            dup (0)



;----------------------------------------------------------------------
;--                                                                  --
;--  S C R E E N S   S E C T I O N                                   --
;--                                                                  --
;----------------------------------------------------------------------
Filler                  DB   16 dup (" ")

;**********************************************************************
; B a c k G r o u n d                                                 *
;**********************************************************************
Ws_BG                   DB    WSIO_OPEN
                        DB    1                 ; Start of screen ROW
                        DB    1                 ; Start of screen COLUMN
                        DB   25                 ; End of screen ROW
                        DB   80                 ; End of screen COLUMN
                        DB    ATTRIB_BLUE_WHITE ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Input attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Enter Keys  Address HIGH
                        DW    ?                 ; Enter Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_BG_Name              DB    "BG2     "
Ws_BG_Keys              DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_BG_Text              DB    "ͻ"
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "ͼ"
                        DB    NULL
Ws_BG_Fields            DB    NULL

;**********************************************************************
; F r e e W a r e                                                     *
;**********************************************************************
Ws_FW                   DB    WSIO_DISPLAY_ONLY
                        DB    3                 ; Start of screen ROW
                        DB   28                 ; Start of screen COLUMN
                        DB   24                 ; End of screen ROW
                        DB   79                 ; End of screen COLUMN
                        DB    ATTRIB_CYAN_WHITE ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Input attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Enter Keys  Address HIGH
                        DW    ?                 ; Enter Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_FW_Name              DB    "FREEWARE"
Ws_FW_Keys              DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_FW_Text              DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "   DIR2ATR - Convert pc dir into .ATRs - v05.07.00  "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "   Please select the appropiate Directory           "
                        DB                               "   (and Drive) to store the .ATR disk images.       "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB    NULL
Ws_FW_Fields            DB    NULL

;**********************************************************************
; P A t h                                                             *
;**********************************************************************
Ws_PA                   DB    WSIO_DISPLAY_ONLY
                        DB    2                 ; Start of screen ROW
                        DB    2                 ; Start of screen COLUMN
                        DB    2                 ; End of screen ROW
                        DB   79                 ; End of screen COLUMN
                        DB    ATTRIB_BLUE_WHITE ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Input attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Enter Keys  Address HIGH
                        DW    ?                 ; Enter Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_PA_Name              DB    "PATH    "
Ws_PA_Keys              DB    KEY_ESC, KEY_ENTER, KEY_ARROW_LEFT, KEY_ARROW_RIGHT
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_PA_Text              DB    "Path:                                                                          "
                        DB    NULL
;------------
; F I E L D S
;------------
;
; Path Specification
;
Ws_PA_F_Path            DB    1                 ; Relative ROW, NULL=End
                        DB    7                 ; Relative COLUMN 
                        DB   72                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Protected
                        DB    0                 ; <Mouse Sensitive>
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_PA_No_More_Fields    DB    NULL

;--------
; D A T A
;--------
; See Search Files Path

;**********************************************************************
; D R i v e   S e l e c t i o n                                       *
;**********************************************************************
Ws_DR                   DB    WSIO_DISPLAY_ONLY
                        DB    3                 ; Start of screen ROW
                        DB    2                 ; Start of screen COLUMN
                        DB   24                 ; End of screen ROW
                        DB   27                 ; End of screen COLUMN
                        DB    ATTRIB_BLUE_WHITE ; Screen attribute
                        DB    ATTRIB_BLUE_WHITE ; Field attribute
                        DB    ATTRIB_GREEN_WHITE  ; Select attribute
                        DB    0                 ; Error attribute
                        DB    1                 ; Mouse support
                        DB    1                 ; Locate cursor at field
                        DB    1                 ; Locate cursor at occurrence
                        DB    1                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Enter Keys  Address HIGH
                        DW    ?                 ; Enter Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_DR_Name              DB    "DRIVES  "
Ws_DR_Keys              DB    KEY_ESC,      KEY_ENTER
                        DB    KEY_HELP
                        DB    KEY_ARROW_UP, KEY_ARROW_DOWN
                        DB    KEY_PAGE_UP,  KEY_PAGE_DOWN
                        DB    KEY_HOME,     KEY_END
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_DR_Text              DB     "[Select Drive]ͻ"
                        DB     "    A: [FLOPPYDRIVE]    "
                        DB     "    C: [MY_VOLUME  ]    "
                        DB     "    D: [MY_CDROM   ]    "
                        DB     "    E: [NET_DRIVE  ]    "
                        DB     "    Z: [RAM_DISK   ]    "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "ENTER=Select Esc=Cancel "
                        DB     "F1=Help                 "
                        DB     "ͼ"
                        DB    NULL
;------------
; F I E L D S
;------------
;
; Drive Table
;
Ws_DR_F_Drive           DB    2                 ; Relative ROW, NULL=End
                        DB    6                 ; Relative COLUMN 
                        DB   16                 ; Field Size
                        DB   17                 ; Nr of occurrences
                        DW    0                 ; This is a table, not part of a table
                        DB    0                 ; Protected
                        DB    KEY_ENTER         ; Mouse sensitive
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DR_F_Key_Esc         DB   20                 ; Relative ROW, NULL=End
                        DB   15                 ; Relative COLUMN 
                        DB   10                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    KEY_ESC           ; Emulate Key Esc
                        DB    0                 ; Edit External
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DR_F_Key_Help        DB   21                 ; Relative ROW, NULL=End
                        DB    2                 ; Relative COLUMN 
                        DB    7                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    KEY_HELP          ; Emulate Key F1
                        DB    0                 ; Edit External
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DR_No_More_Fields    DB    NULL

;--------
; D A T A
;--------
;
; Drive Table
;
Ws_DR_D_Drive           DB    MAX_DRIVES + EXTRA_TABLE_FIELDS dup ("                ")

;--------------------
; W O R K F I E L D S
;--------------------
Ws_DR_Occur_Curr        DW    ?
Ws_DR_Occur_Max         DW    ?                 ; Maximum nr of drives present
Ws_DR_Occur_W_Curr      DW    ?
WS_DR_OCCUR_W_CURR_MAX  DW   17                 ; Maximum occurrences per window

Ws_DR_D_Key_Esc         DB   "Esc=Cancel"
Ws_DR_D_Key_Help        DB   "F1=Help"



;**********************************************************************
; D r i v e   H e l p   S c r e e n                                   *
;**********************************************************************
Ws_DH                   DB    WSIO_DISPLAY_ONLY
                        DB    3                 ; Start of screen ROW
                        DB    2                 ; Start of screen COLUMN
                        DB   24                 ; End of screen ROW
                        DB   27                 ; End of screen COLUMN
                        DB    ATTRIB_GREEN_WHITE ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Select attribute
                        DB    0                 ; Error attribute
                        DB    1                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Enter Keys  Address HIGH
                        DW    ?                 ; Enter Keys  Address LOW
                        DW    NULL              ; Field Area  Address HIGH
                        DW    NULL              ; Field Area  Address LOW
Ws_DH_Name              DB    "DRIVEHLP"
Ws_DH_Keys              DB    KEY_ANY
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_DH_Text              DB     "[Drive Help]ͻ"
                        DB     "                        "
                        DB     "ENTER = Select drive    "
                        DB     "", ARROW_UP, "     = Previous drive  "
                        DB     "", ARROW_DOWN, "     = Next drive      "
                        DB     "Home  = First drive     "
                        DB     "End   = Last drive      "
                        DB     "Pg Up = Previous drives "
                        DB     "Pg Dn = Next drives     "
                        DB     "F1    = This screen     "
                        DB     "Esc   = Cancel          "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "Press any key to exit   "
                        DB     "ͼ"
                        DB    NULL

;**********************************************************************
; L i b r a r y   F i l e   S e l e c t i o n                         *
;**********************************************************************
Ws_LF                   DB    WSIO_DISPLAY_ONLY
                        DB    3                 ; Start of screen ROW
                        DB    2                 ; Start of screen COLUMN
                        DB   24                 ; End of screen ROW
                        DB   27                 ; End of screen COLUMN
                        DB    ATTRIB_BLUE_WHITE ; Screen attribute
                        DB    ATTRIB_BLUE_WHITE ; Field attribute
                        DB    ATTRIB_GREEN_WHITE  ; Select attribute
                        DB    0                 ; Error attribute
                        DB    1                 ; Mouse support
                        DB    1                 ; Locate cursor at field
                        DB    1                 ; Locate cursor at occurrence
                        DB    1                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Enter Keys  Address HIGH
                        DW    ?                 ; Enter Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_LF_Name              DB    "LIBFILES"
Ws_LF_Keys              DB    KEY_ESC,      KEY_ENTER
                        DB    KEY_HELP,     KEY_F2,        KEY_F3
                        DB    KEY_ARROW_UP, KEY_ARROW_DOWN
                        DB    KEY_PAGE_UP,  KEY_PAGE_DOWN
                        DB    KEY_HOME,     KEY_END
                        DB    KEY_CTL_A_Z
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_LF_Text              DB     "[Select Dir/Image]", ARROW_UP, ARROW_DOWN, ""
                        DB     "..           <DIR>      "
                        DB     "ASM          <DIR>      "
                        DB     "EQUAL        <DIR>      "
                        DB     "MYDIR        <DIR>      "
                        DB     "PROJECT .TOO <DIR>      "
                        DB     "ATARI   .ATR 123,456,789"
                        DB     "MY      .ATR  12,345,678"
                        DB     "YOUR    .ATR   1,234,567"
                        DB     "ZZZZZZZZ.ATR     123,456"
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "ENTER=Select Esc=Cancel "
                        DB     "F1=Help F2=CurDir F3=Drv"
                        DB     "ͼ"
                        DB    NULL
;------------
; F I E L D S
;------------
;
; Directories/Images Table
;
Ws_LF_F_Dir_Fil         DB    2                 ; Relative ROW, NULL=End
                        DB    2                 ; Relative COLUMN 
                        DB   24                 ; Field Size
                        DB   17                 ; Nr of occurrences
                        DW    0                 ; This is a table, not part of a table
                        DB    0                 ; Protected
                        DB    KEY_ENTER         ; Mouse sensitive
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_LF_F_Page_Up         DB    1                 ; Relative ROW, NULL=End
                        DB   24                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is a table, not part of a table
                        DB    0                 ; Protected
                        DB    KEY_PAGE_UP       ; Mouse sensitive
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    NULL              ; Source Hi
                        DW    NULL              ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_LF_F_Page_Down       DB    1                 ; Relative ROW, NULL=End
                        DB   25                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is a table, not part of a table
                        DB    0                 ; Protected
                        DB    KEY_PAGE_DOWN     ; Mouse sensitive
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    NULL              ; Source Hi
                        DW    NULL              ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_LF_F_Key_Enter       DB   20                 ; Relative ROW, NULL=End
                        DB    2                 ; Relative COLUMN 
                        DB   12                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    KEY_ENTER         ; Emulate Enter
                        DB    0                 ; Edit External
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_LF_F_Key_Esc         DB   20                 ; Relative ROW, NULL=End
                        DB   15                 ; Relative COLUMN 
                        DB   10                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    KEY_ESC           ; Emulate Enter
                        DB    0                 ; Edit External
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_LF_F_Key_Help        DB   21                 ; Relative ROW, NULL=End
                        DB    2                 ; Relative COLUMN 
                        DB    7                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    KEY_HELP          ; Emulate Key F1
                        DB    0                 ; Edit External
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_LF_F_Key_CurDir      DB   21                 ; Relative ROW, NULL=End
                        DB   10                 ; Relative COLUMN 
                        DB    9                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    KEY_F2            ; Emulate Key F2
                        DB    0                 ; Edit External
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_LF_F_Key_Drv         DB   21                 ; Relative ROW, NULL=End
                        DB   20                 ; Relative COLUMN 
                        DB    6                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    KEY_F3            ; Emulate Key F3
                        DB    0                 ; Edit External
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_LF_No_More_Fields    DB    NULL

;--------
; D A T A
;--------
;
; Dir / Fil Table
;
Dir_Map_ptr_es          DW    1 dup (NULL)      ; Segment 1
Dir_Map_ptr_di          DW    1 dup (NULL)

Ws_LF_D_Key_Enter       DB   "Enter=Select"
Ws_LF_D_Key_Esc         DB   "Esc=Cancel"
Ws_LF_D_Key_Help        DB   "F1=Help"
Ws_LF_D_Key_CurDir      DB   "F2=CurDir"
Ws_LF_D_Key_Drv         DB   "F3=Drv"

;--------------------
; W O R K F I E L D S
;--------------------
Ws_LF_Occur_Curr        DW    ?
Ws_LF_Occur_Max         DW    ?                 ; Maximum nr of entries present
Ws_LF_Occur_W_Curr      DW    ?
WS_LF_OCCUR_W_CURR_MAX  DW   17                 ; Maximum occurrences per window

;**********************************************************************
; L i b r a r y   F i l e   H e l p   S c r e e n                     *
;**********************************************************************
Ws_LH                   DB    WSIO_DISPLAY_ONLY
                        DB    3                 ; Start of screen ROW
                        DB    2                 ; Start of screen COLUMN
                        DB   24                 ; End of screen ROW
                        DB   27                 ; End of screen COLUMN
                        DB    ATTRIB_GREEN_WHITE ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Select attribute
                        DB    0                 ; Error attribute
                        DB    1                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Enter Keys  Address HIGH
                        DW    ?                 ; Enter Keys  Address LOW
                        DW    NULL              ; Field Area  Address HIGH
                        DW    NULL              ; Field Area  Address LOW
Ws_LH_Name              DB    "LIBHELP "
Ws_LH_Keys              DB    KEY_ANY
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_LH_Text              DB     "[Dir/Image Help]ͻ"
                        DB     "                        "
                        DB     "ENTER = Select Dir/Image"
                        DB     "", ARROW_UP, "     = Prev Dir/Image  "
                        DB     "", ARROW_DOWN, "     = Next Dir/Image  "
                        DB     "Home  = First Dir/Image "
                        DB     "End   = Last Dir/Image  "
                        DB     "Pg Up = Prev Dirs/Images"
                        DB     "Pg Dn = Next Dirs/Images"
                        DB     "F1    = This screen     "
                        DB     "F2    = Select Curr Dir "
                        DB     "F3    = Go to drive scrn"
                        DB     "Esc   = Exit Program    "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "Press any key to exit   "
                        DB     "ͼ"
                        DB    NULL

;**********************************************************************
; E R R O R - D R I V E   N O T   R E A D Y                           *
;**********************************************************************
Ws_E1                   DB    WSIO_DISPLAY_ONLY
                        DB   10                 ; Start of screen ROW
                        DB   42                 ; Start of screen COLUMN
                        DB   16                 ; End of screen ROW
                        DB   65                 ; End of screen COLUMN
                        DB    ATTRIB_RED_WHITE  ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Select attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Enter Keys  Address HIGH
                        DW    ?                 ; Enter Keys  Address LOW
                        DW    NULL              ; Field Area  Address HIGH
                        DW    NULL              ; Field Area  Address LOW
Ws_E1_Name              DB    "ERROR1  "
Ws_E1_Keys              DB    KEY_ANY
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_E1_Text              DB                                             "[Drive Not Ready]ͻ"
                        DB                                             "                      "
                        DB                                             " There is NO media in "
                        DB                                             " the requested drive! "
                        DB                                             "                      "
                        DB                                             "Esc or Any key=Confirm"
                        DB                                             "ͼ"
                        DB    NULL

;**********************************************************************
; E R R O R - G E N E R A L   I / O   E R R O R                       *
;**********************************************************************
Ws_E2                   DB    WSIO_DISPLAY_ONLY
                        DB    9                 ; Start of screen ROW
                        DB   32                 ; Start of screen COLUMN
                        DB   16                 ; End of screen ROW
                        DB   75                 ; End of screen COLUMN
                        DB    ATTRIB_RED_WHITE  ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Select attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Enter Keys  Address HIGH
                        DW    ?                 ; Enter Keys  Address LOW
                        DW    NULL              ; Field Area  Address HIGH
                        DW    NULL              ; Field Area  Address LOW
Ws_E2_Name              DB    "ERROR2  "
Ws_E2_Keys              DB    KEY_ANY
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_E2_Text              DB                                   "[I / O   E r r o r]ͻ"
                        DB                                   "                                          "
                        DB                                   "                                          "
                        DB                                   " xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx "
                        DB                                   "                                          "
                        DB                                   "                                          "
                        DB                                   " Enter=Acknowledge Error                  "
                        DB                                   "ͼ"
                        DB    NULL
;------------
; F I E L D S
;------------
;
; Error message
;
Ws_E2_F_Error_Message   DB    4                 ; Relative ROW, NULL=End
                        DB    3                 ; Relative COLUMN 
                        DB   40                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    0                 ; <Mouse Sensitive>
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_E2_No_More_Fields    DB    NULL

;--------
; D A T A
;--------
Ws_E2_Error_Message             DB   "                                        "
Ws_E2_D_General_I_O_Error       DB   "I/O ERROR - Reason Unknown!             "
Ws_E2_D_BOOTCODE_Not_Found      DB   "BOOTCODE file not found!                "
Ws_E2_D_DOS_SYS_Not_Found       DB   "DOS.SYS file not found!                 "
Ws_E2_D_DUP_SYS_Not_Found       DB   "DUP.SYS file not found!                 "
Ws_E2_D_Disk_Full               DB   "The destination drive is full!          "
Ws_E2_D_Opening_File            DB   "Opening                                 "
Ws_E2_D_Reading_File            DB   "Reading                                 "
Ws_E2_D_Opening_Image           DB   "ATR disk image could not be opened!     "
Ws_E2_D_Positioning_Image       DB   "ATR disk image sector positioning error!"
Ws_E2_D_Sector_Allocation       DB   "ATR disk image sector allocation error! "
Ws_E2_D_Writing_Image           DB   "ATR disk image sector writing error!    "

;**********************************************************************
; Please select an option                                             *
;**********************************************************************
Ws_E3                   DB    WSIO_DISPLAY_ONLY
                        DB   10                 ; Start of screen ROW
                        DB   42                 ; Start of screen COLUMN
                        DB   16                 ; End of screen ROW
                        DB   65                 ; End of screen COLUMN
                        DB    ATTRIB_RED_WHITE  ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Select attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Enter Keys  Address HIGH
                        DW    ?                 ; Enter Keys  Address LOW
                        DW    NULL              ; Field Area  Address HIGH
                        DW    NULL              ; Field Area  Address LOW
Ws_E3_Name              DB    "ERROR3  "
Ws_E3_Keys              DB    KEY_ANY
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_E3_Text              DB                                             "[Option Selection]ͻ"
                        DB                                             "                      "
                        DB                                             " No option selected!  "
                        DB                                             " Please select one.   "
                        DB                                             "                      "
                        DB                                             "Esc or Any key=Confirm"
                        DB                                             "ͼ"
                        DB    NULL

;**********************************************************************
; Too many options selected                                           *
;**********************************************************************
Ws_E4                   DB    WSIO_DISPLAY_ONLY
                        DB   10                 ; Start of screen ROW
                        DB   42                 ; Start of screen COLUMN
                        DB   16                 ; End of screen ROW
                        DB   65                 ; End of screen COLUMN
                        DB    ATTRIB_RED_WHITE  ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Select attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Enter Keys  Address HIGH
                        DW    ?                 ; Enter Keys  Address LOW
                        DW    NULL              ; Field Area  Address HIGH
                        DW    NULL              ; Field Area  Address LOW
Ws_E4_Name              DB    "ERROR4  "
Ws_E4_Keys              DB    KEY_ANY
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_E4_Text              DB                                             "[Option Selection]ͻ"
                        DB                                             "                      "
                        DB                                             " Too many selections! "
                        DB                                             " Select 1 option only."
                        DB                                             "                      "
                        DB                                             "Esc or Any key=Confirm"
                        DB                                             "ͼ"
                        DB    NULL

;**********************************************************************
; D i s k   M e d i a   s p e c i f i c a t i o n                     *
;**********************************************************************
Ws_DM                   DB    WSIO_OPEN
                        DB    5                 ; Start of screen ROW
                        DB   40                 ; Start of screen COLUMN
                        DB   21                 ; End of screen ROW
                        DB   67                 ; End of screen COLUMN
                        DB    ATTRIB_GREEN_WHITE ; Screen attribute
                        DB    ATTRIB_BLUE_WHITE ; Field attribute
                        DB    ATTRIB_BLUE_WHITE ; Input attribute
                        DB    0                 ; Error attribute
                        DB    1                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    0                 ; Go to first          
                        DB    0                 ; modifiable field
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Enter Keys  Address HIGH
                        DW    ?                 ; Enter Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_DM_Name              DB    "MEDIUM  "
Ws_DM_Keys              DB    KEY_ESC, KEY_ENTER
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_DM_Text              DB                                           "[Medium specification]ͻ"
                        DB                                           "                          "
                        DB                                           "  [ ] SINGLE   density    "
                        DB                                           "  [ ] MEDIUM   density    "
                        DB                                           "  [ ] DOUBLE   density    "
                        DB                                           "  [ ] QUAD     density    "
                        DB                                           "  [ ] 720  KB  disk(ette) "
                        DB                                           "  [ ] 1.44 MB  disk(ette) "
                        DB                                           "  [ ] HARDDISK 16 MB disk "
                        DB                                           "                          "
                        DB                                           "  [ ] Disk Type Creation  "
                        DB                                           "      A=ATR, X=XFD        "
                        DB                                           "  [ ] Put as many files on"
                        DB                                           "      a disk as possible  "
                        DB                                           "                          "
                        DB                                           "ENTER=Specify   Esc=Cancel"
                        DB                                           "ͼ"
                        DB    NULL
;------------
; F I E L D S
;------------
;
; Disk Medium to use
;
Ws_DM_F_Single          DB    3                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    KEY_ENTER         ; Mouse pressed
                        DB    3                 ; Edit Letters
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DM_F_Medium          DB    4                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    KEY_ENTER         ; Emulate Enter
                        DB    3                 ; Edit Letters
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DM_F_Double          DB    5                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    KEY_ENTER         ; Emulate Enter
                        DB    3                 ; Edit Letters
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DM_F_Quad            DB    6                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    KEY_ENTER         ; Emulate Enter
                        DB    3                 ; Edit Letters
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DM_F_720KB           DB    7                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    KEY_ENTER         ; Emulate Enter
                        DB    3                 ; Edit Letters
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DM_F_1440KB          DB    8                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    KEY_ENTER         ; Emulate Enter
                        DB    3                 ; Edit Letters
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DM_F_Harddisk        DB    9                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    KEY_ENTER         ; Emulate Enter
                        DB    3                 ; Edit Letters
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DM_F_ATR_Or_XFD      DB   11                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    KEY_ENTER         ; Not mouse sensitive
                        DB    0                 ; Edit External
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DM_F_Optimize        DB   13                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    KEY_ENTER         ; Not mouse sensitive
                        DB    0                 ; Edit External
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DM_F_Key_Enter       DB   16                 ; Relative ROW, NULL=End
                        DB    2                 ; Relative COLUMN 
                        DB   13                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    KEY_ENTER         ; Emulate Enter
                        DB    0                 ; Edit External
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DM_F_Key_Esc         DB   16                 ; Relative ROW, NULL=End
                        DB   18                 ; Relative COLUMN 
                        DB   10                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    KEY_ESC           ; Emulate Enter
                        DB    0                 ; Edit External
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DM_No_More_Fields    DB    NULL

;--------
; D A T A
;--------
Ws_DM_D_Single          DB    SPACE
Ws_DM_D_Medium          DB    SPACE
Ws_DM_D_Double          DB    SPACE
Ws_DM_D_Quad            DB    SPACE
Ws_DM_D_720KB           DB    SPACE
Ws_DM_D_1440KB          DB    SPACE
Ws_DM_D_Harddisk        DB    SPACE

Ws_DM_D_Key_Enter       DB   "Enter=Specify"
Ws_DM_D_Key_Esc         DB   "Esc=Cancel"

Ws_DM_D_Optimize        DB    SPACE

ATR_Or_XFD_Field        DB   "AX"
                        DB  NULL


;**********************************************************************
; D O S   M e d i a   s p e c i f i c a t i o n                       *
;**********************************************************************
Ws_DS                   DB    WSIO_OPEN
                        DB    5                 ; Start of screen ROW
                        DB   38                 ; Start of screen COLUMN
                        DB   21                 ; End of screen ROW
                        DB   70                 ; End of screen COLUMN
                        DB    ATTRIB_GREEN_WHITE ; Screen attribute
                        DB    ATTRIB_BLUE_WHITE ; Field attribute
                        DB    ATTRIB_BLUE_WHITE ; Input attribute
                        DB    0                 ; Error attribute
                        DB    1                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    0                 ; Go to first          
                        DB    0                 ; modifiable field
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Enter Keys  Address HIGH
                        DW    ?                 ; Enter Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_DS_Name              DB    "DOSMASK "
Ws_DS_Keys              DB    KEY_ESC, KEY_ENTER
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_DS_Text              DB                                         "[Include which DOS]ͻ"
                        DB                                         "                               "
                        DB                                         "  [ ] Disk type DOS 2.5        "
                        DB                                         "  [ ] Disk type MYDOS 4.53     "
                        DB                                         "  [ ] Disk type Your Own MYDOS "
                        DB                                         "  [ ] Disk type BeWe DOS       "
                        DB                                         "  [ ] Disk type SPARTADOS 3.3a "
                        DB                                         "  [ ] Disk type SPARTADOS/X    "
                        DB                                         "  [ ] Disk type Your Own SPARTA"
                        DB                                         "                               "
                        DB                                         "  [ ] Write DOS Files          "
                        DB                                         "      If DOS is written,       "
                        DB                                         "  [ ] Include DUP.SYS          "
                        DB                                         "  [ ] Use MAIN dir in SpartaDos"
                        DB                                         "                               "
                        DB                                         "ENTER=Specify        Esc=Cancel"
                        DB                                         "ͼ"
                        DB    NULL
;------------
; F I E L D S
;------------
;
; DOS to include
;
Ws_DS_F_DOS25           DB    3                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    KEY_ENTER         ; Emulate Enter
                        DB    3                 ; Edit Letters
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DS_F_MYDOS           DB    4                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    KEY_ENTER         ; Emulate Enter
                        DB    3                 ; Edit Letters
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DS_F_MYOWNDOS_MYDOS  DB    5                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    KEY_ENTER         ; Emulate Enter
                        DB    3                 ; Edit Letters
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DS_F_BEWEDOS         DB    6                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    KEY_ENTER         ; Emulate Enter
                        DB    3                 ; Edit Letters
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DS_F_SPARTADOS       DB    7                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    KEY_ENTER         ; Emulate Enter
                        DB    3                 ; Edit Letters
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DS_F_SPARTADOSX      DB    8                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    KEY_ENTER         ; Emulate Enter
                        DB    3                 ; Edit Letters
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DS_F_MYOWNDOS_SPARTA DB    9                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    KEY_ENTER         ; Emulate Enter
                        DB    3                 ; Edit Letters
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DS_F_INCLUDE_DOS     DB   11                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    KEY_ENTER         ; Emulate Enter
                        DB    3                 ; Edit Letters
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DS_F_DUPSYS          DB   13                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    KEY_ENTER         ; Emulate Enter
                        DB    3                 ; Edit Letters
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DS_F_MAIN            DB   14                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    KEY_ENTER         ; Emulate Enter
                        DB    3                 ; Edit Letters
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DS_F_Key_Enter       DB   16                 ; Relative ROW, NULL=End
                        DB    2                 ; Relative COLUMN 
                        DB   13                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    KEY_ENTER         ; Emulate Enter
                        DB    0                 ; Edit External
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DS_F_Key_Esc         DB   16                 ; Relative ROW, NULL=End
                        DB   23                 ; Relative COLUMN 
                        DB   10                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    KEY_ESC           ; Emulate Enter
                        DB    0                 ; Edit External
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DS_No_More_Fields    DB    NULL

;--------
; D A T A
;--------
Ws_DS_D_DOS25           DB    SPACE
Ws_DS_D_MYDOS           DB    SPACE
Ws_DS_D_MYOWNDOS_MYDOS  DB    SPACE
Ws_DS_D_BEWEDOS         DB    SPACE
Ws_DS_D_SPARTADOS       DB    SPACE
Ws_DS_D_SPARTADOSX      DB    SPACE
Ws_DS_D_MYOWNDOS_SPARTA DB    SPACE
Ws_DS_D_INCLUDE_DOS     DB    SPACE
Ws_DS_D_DUPSYS          DB    SPACE
Ws_DS_D_MAIN_DIR        DB    SPACE

Ws_DS_D_Key_Enter       DB   "Enter=Specify"
Ws_DS_D_Key_Esc         DB   "Esc=Cancel"



;**********************************************************************
; A d d   D i s k n u m b e r s   a f t e r   l a s t   d i s k n r   *
;**********************************************************************
Ws_AD                   DB    WSIO_OPEN
                        DB   10                 ; Start of screen ROW
                        DB   40                 ; Start of screen COLUMN
                        DB   16                 ; End of screen ROW
                        DB   68                 ; End of screen COLUMN
                        DB    ATTRIB_GREEN_WHITE ; Screen attribute
                        DB    ATTRIB_BLUE_WHITE ; Field attribute
                        DB    ATTRIB_BLUE_WHITE ; Input attribute
                        DB    0                 ; Error attribute
                        DB    1                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    0                 ; Go to first          
                        DB    0                 ; modifiable field
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Enter Keys  Address HIGH
                        DW    ?                 ; Enter Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_AD_Name              DB    "ADDDISKS"
Ws_AD_Keys              DB    KEY_ESC, KEY_ENTER
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_AD_Text              DB                                           "[Add from where]ͻ"
                        DB                                           "                           "
                        DB                                           "  [ ] E=Add at end         "
                        DB                                           "      B=Add from begin     "
                        DB                                           "                           "
                        DB                                           "ENTER=Specify    Esc=Cancel"
                        DB                                           "ͼ"
                        DB    NULL
;------------
; F I E L D S
;------------
;
; DOS to include
;
Ws_AD_F_Add_Where       DB    3                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    KEY_ENTER         ; Emulate Enter
                        DB    0                 ; Edit External
                        DB    1                 ; Blanks Trailing
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_AD_F_Key_Enter       DB    6                 ; Relative ROW, NULL=End
                        DB    2                 ; Relative COLUMN 
                        DB   13                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    KEY_ENTER         ; Emulate Enter
                        DB    0                 ; Edit External
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_AD_F_Key_Esc         DB    6                 ; Relative ROW, NULL=End
                        DB   19                 ; Relative COLUMN 
                        DB   10                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    KEY_ESC           ; Emulate Enter
                        DB    0                 ; Edit External
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_AD_No_More_Fields    DB    NULL

;--------
; D A T A
;--------
Ws_AD_D_Add_Where       DB    "E"

End_Begin_Field         DB    "EB"
                        DB    NULL

Ws_AD_D_Key_Enter       DB   "Enter=Specify"
Ws_AD_D_Key_Esc         DB   "Esc=Cancel"



;**********************************************************************
; C r e a t i n g   x l   d i s k   F i l e s                         *
;**********************************************************************
Ws_CF                   DB    WSIO_DISPLAY_ONLY
                        DB   10                 ; Start of screen ROW
                        DB   36                 ; Start of screen COLUMN
                        DB   16                 ; End of screen ROW
                        DB   71                 ; End of screen COLUMN
                        DB    ATTRIB_GREEN_WHITE ; Screen attribute
                        DB    ATTRIB_GREEN_WHITE ; Field attribute
                        DB    0                 ; Input attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; No cursor
                        DB    CURSOR_OFF_SCREEN ; to display
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    NULL              ; Valid Keys  Address HIGH
                        DW    NULL              ; Valid Keys  Address LOW
                        DW    NULL              ; Enter Keys  Address HIGH
                        DW    NULL              ; Enter Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_CF_Name              DB    "CFILES  "

;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_CF_Text              DB                                       "[Adding files to disk images]ͻ"
                        DB                                       "                                  "
                        DB                                       " xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx "
                        DB                                       "                                  "
                        DB                                       " Processing disk: xxxxxxxxxxxx    "
                        DB                                       " xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx "
                        DB                                       "ͼ"
                        DB    NULL
;------------
; F I E L D S
;------------
;
; Progress bar
;
Ws_CF_F_Progress_Bar    DB    3                 ; Relative ROW, NULL=End
                        DB    3                 ; Relative COLUMN 
                        DB   32                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    0                 ; <Mouse Sensitive>
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

;
; Process disk
;
Ws_CF_F_Add_Disk        DB    5                 ; Relative ROW, NULL=End
                        DB   20                 ; Relative COLUMN 
                        DB   12                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    0                 ; <Mouse Sensitive>
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

;
; Process file
;
Ws_CF_F_Add_File        DB    6                 ; Relative ROW, NULL=End
                        DB    3                 ; Relative COLUMN 
                        DB   32                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    0                 ; <Mouse Sensitive>
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_CF_No_More_Fields    DB    NULL

;--------
; D A T A
;--------
Ws_CF_D_Progress_Bar            DB   32 dup (0B0h)
Ws_CF_D_Progress_Bar_Attr       DB   ATTRIB_CYAN_WHITE
Ws_CF_D_Add_Disk                DB   12 dup (SPACE)
Ws_CF_D_Add_File                DB   "Processing file: "
Ws_CF_D_Add_File_File           DB   12 dup (SPACE)
                                DB   "   "
Ws_CF_D_No_Message              DB   32 dup (SPACE)
Ws_CF_D_Formatting_Disk         DB   "Formatting disk, please wait... "

;**********************************************************************
; F o r m a t t i n g   x l   d i s k   F i l e s                     *
;**********************************************************************
Ws_FF                   DB    WSIO_DISPLAY_ONLY
                        DB   11                 ; Start of screen ROW
                        DB   36                 ; Start of screen COLUMN
                        DB   13                 ; End of screen ROW
                        DB   71                 ; End of screen COLUMN
                        DB    ATTRIB_BLUE_WHITE ; Screen attribute
                        DB    ATTRIB_BLUE_WHITE ; Field attribute
                        DB    0                 ; Input attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; No cursor
                        DB    CURSOR_OFF_SCREEN ; to display
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    NULL              ; Valid Keys  Address HIGH
                        DW    NULL              ; Valid Keys  Address LOW
                        DW    NULL              ; Enter Keys  Address HIGH
                        DW    NULL              ; Enter Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_FF_Name              DB    "FORMAT  "

;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_FF_Text              DB                                       "[Formatting Disk Image]ͻ"
                        DB                                       "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"
                        DB                                       "ͼ"
                        DB    NULL
;------------
; F I E L D S
;------------
;
; Progress bar
;
Ws_FF_F_Progress_Bar    DB    2                 ; Relative ROW, NULL=End
                        DB    2                 ; Relative COLUMN 
                        DB   34                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    0                 ; <Mouse Sensitive>
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_FF_No_More_Fields    DB    NULL

;--------
; D A T A
;--------
Ws_FF_D_Progress_Bar            DB   34 dup (0B0h)
Ws_FF_D_Progress_Bar_Attr       DB   ATTRIB_CYAN_WHITE

ENDS    DSeg



;**********************************************************************
;               Extended Segments
;**********************************************************************
SEGMENT DSeg2 Word Public 'LIBFILES'
Dir_Map                 DB   DIR_MAP_LENGTH dup ("E")

ENDS    DSeg2



;**********************************************************************
SEGMENT CSeg Word Public 'CODE'
;**********************************************************************
;----------------------------------------------------------------------
;--  External Variables                                              --
;----------------------------------------------------------------------
        EXTRN   APPEND:proc             ; Glue 2 strings together
        EXTRN   DC_DIRS:proc            ; Determine Current Directories
        EXTRN   DC_FILES:proc           ; Determine Current Files
        EXTRN   D_SPARTA:proc           ; Create a SpartaDos disk
        EXTRN   FMSIO:proc              ; File Management System Handler
        EXTRN   HEX2DIGI:proc           ; Convert Hex Data To Digits (Text)
        EXTRN   WSIO:proc               ; Screen Handler



;**********************************************************************
PROC    D_FILDSK
;**********************************************************************
        ASSUME  cs:CSeg
        ASSUME  ds:DSeg
        mov     ax, DSeg                        ; Initialize DS to address
        mov     ds, ax                          ; of data segment

        mov     bx, sp

;
; Parameter Files
;
        mov     di, [ss:bx+46]
        mov     es, [ss:bx+48]

        mov     [Parm_Files_ptr_es], es
        mov     [Parm_Files_ptr_di], di

;
; Parameter To Location
;
        mov     di, [ss:bx+42]
        mov     es, [ss:bx+44]

        mov     [Parm_Location_ptr_es], es
        mov     [Parm_Location_ptr_di], di

;
; Parameter To Disk Density
;
        mov     di, [ss:bx+38]
        mov     es, [ss:bx+40]

        mov     [Parm_Density_ptr_es], es
        mov     [Parm_Density_ptr_di], di

;
; Parameter To ATR or XFD
;
        mov     di, [ss:bx+34]
        mov     es, [ss:bx+36]

        mov     [Parm_ATR_Or_XFD_ptr_es], es
        mov     [Parm_ATR_Or_XFD_ptr_di], di

;
; Parameter To DOS Path
;
        mov     di, [ss:bx+30]
        mov     es, [ss:bx+32]

        mov     [Parm_DOS_Path_ptr_es], es
        mov     [Parm_DOS_Path_ptr_di], di

;
; Parameter Disk Format
;
        mov     di, [ss:bx+26]
        mov     es, [ss:bx+28]

        mov     [Parm_DISK_FORMAT_ptr_es], es
        mov     [Parm_DISK_FORMAT_ptr_di], di

;
; Parameter To Include DOS
;
        mov     di, [ss:bx+22]
        mov     es, [ss:bx+24]

        mov     [Parm_INCLUDE_DOS_ptr_es], es
        mov     [Parm_INCLUDE_DOS_ptr_di], di

;
; Parameter To Include DUP.SYS
;
        mov     di, [ss:bx+18]
        mov     es, [ss:bx+20]

        mov     [Parm_DUP_SYS_ptr_es], es
        mov     [Parm_DUP_SYS_ptr_di], di

;
; Parameter To Use MAIN SpartaDos Dir
;
        mov     di, [ss:bx+14]
        mov     es, [ss:bx+16]

        mov     [Parm_MAIN_Dir_ptr_es], es
        mov     [Parm_MAIN_Dir_ptr_di], di

;
; Parameter To Drives (or to Include Subdirectories in case of CLI)
;
        mov     di, [ss:bx+10]
        mov     es, [ss:bx+12]

        mov     [Parm_Drives_ptr_es], es
        mov     [Parm_Drives_ptr_di], di

        mov     [Parm_InclDirs_ptr_es], es
        mov     [Parm_InclDirs_ptr_di], di
        mov     cl, [byte es:di]
        mov     [CLI_Include_Subdirs], cl

;
; Parameter To Drives in Text format
;
        mov     di, [ss:bx+6]
        mov     es, [ss:bx+8]

        mov     [Parm_Drives_Txt_ptr_es], es
        mov     [Parm_Drives_Txt_ptr_di], di

;
; Parameter To CLI Used Yes or No
;
        mov     di, [ss:bx+2]
        mov     es, [ss:bx+4]

        mov     [Parm_CLI_Used_ptr_es], es
        mov     [Parm_CLI_Used_ptr_di], di
        mov     cl, [byte es:di]
        mov     [CLI_Used], cl

;
; Parameter Files
;
        push    ds si

        mov     es, [Parm_Files_ptr_es]
        mov     di, [Parm_Files_ptr_di]
        push    es di

        mov     si, offset File_Path
        push    ds si
        pop     di es

        pop     si ds
        mov     cx, PATH_LENGTH
        rep     movsb

        pop     si ds

        call    Init_Program
        call    Init_Files
        call    Init_Screens

        cmp     [CLI_Used], LOGIC_YES                   ; Command Line Interface used?
        je      @@30                                    ; Yes
                                                        ; No, so
        call    Parameter_Processing
        call    Read_VTOC_Drives
        call    Open_Ws_BG
        call    Display_Ws_BG                           ; Display background
        call    Display_Ws_FW                           ; Display freeware message

@@20:
        call    Display_and_Read_Ws_LF                  ; Let user select library
        call    Close_Ws_BG
        jmp     @@99

@@30:
        call    Add_DirFiles_To_ATR_Image

@@99:
        ret

ENDP    D_FILDSK



;**********************************************************************
PROC    Init_Program
;**********************************************************************
        xor     ax, ax
        mov	ah, DOS_SET_MEMORY_BLOCK_SIZE   ; resize the psp memory
        xor     bx, bx
        int	DOS_SERVICE

;
; Segment Addressing
;
        ASSUME  ds:DSeg2
        mov     ax, DSeg2                       ; Initialize ds to address
        mov     ds, ax                          ; of data segment
 
        mov     si, offset Dir_Map
        push    ds si
        pop     di es

        ASSUME  ds:DSeg
        mov     ax, DSeg                        ; Initialize ds to address
        mov     ds, ax                          ; of data segment

        mov     [Dir_Map_ptr_es], es
        mov     [Dir_Map_ptr_di], di

@@99:
        ret

ENDP    Init_Program



;**********************************************************************
PROC    Init_Screens
;**********************************************************************
;
; Init screen BG=Background
;
        mov     si, offset Ws_BG
        push    ds si
        pop     di es

        mov     si, offset Ws_BG_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_BG_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_BG_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

;
; Init screen FW=FreeWare
;
        mov     si, offset Ws_FW
        push    ds si
        pop     di es

        mov     si, offset Ws_FW_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_FW_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_FW_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

;
; Init screen PA=Path
;
        mov     si, offset Ws_PA
        push    ds si
        pop     di es

        mov     si, offset Ws_PA_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_PA_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_PA_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

        mov     si, offset Ws_PA_F_Path
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        mov     si, offset Search_Files_Path
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Init screen DR=Drives
;
        mov     si, offset Ws_DR
        push    ds si
        pop     di es

        mov     si, offset Ws_DR_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_DR_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_DR_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

        mov     si, offset Ws_DR_F_Drive
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        mov     si, offset Ws_DR_D_Drive
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DR_F_Key_Esc

        push    ds si
        pop     di es

        mov     si, offset Ws_DR_D_Key_Esc
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DR_F_Key_Help

        push    ds si
        pop     di es

        mov     si, offset Ws_DR_D_Key_Help
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Init screen DH=Drive Help Screen
;
        mov     si, offset Ws_DH
        push    ds si
        pop     di es

        mov     si, offset Ws_DH_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_DH_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_DH_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

;
; Init screen LF=Directories/Images
;
        mov     si, offset Ws_LF
        push    ds si
        pop     di es

        mov     si, offset Ws_LF_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_LF_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_LF_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

        mov     si, offset Ws_LF_F_Dir_Fil
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        mov     si, offset Ws_LF_F_Dir_Fil
        push    ds si
        pop     di es

        mov     ax, [Dir_Map_ptr_es]
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ax
        mov     ax, [Dir_Map_ptr_di]
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], ax

        mov     si, offset Ws_LF_F_Key_Enter

        push    ds si
        pop     di es

        mov     si, offset Ws_LF_D_Key_Enter
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_LF_F_Key_Esc

        push    ds si
        pop     di es

        mov     si, offset Ws_LF_D_Key_Esc
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_LF_F_Key_Help

        push    ds si
        pop     di es

        mov     si, offset Ws_LF_D_Key_Help
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_LF_F_Key_CurDir

        push    ds si
        pop     di es

        mov     si, offset Ws_LF_D_Key_CurDir
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_LF_F_Key_Drv

        push    ds si
        pop     di es

        mov     si, offset Ws_LF_D_Key_Drv
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Init screen LH=Directory/Image Help Screen
;
        mov     si, offset Ws_LH
        push    ds si
        pop     di es

        mov     si, offset Ws_LH_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_LH_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_LH_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

;
; Init screen E1=Error Screen - Drive Not Ready
;
        mov     si, offset Ws_E1
        push    ds si
        pop     di es

        mov     si, offset Ws_E1_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_E1_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_E1_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

;
; Init screen E2=Error Screen - I/O ERROR
;
        mov     si, offset Ws_E2
        push    ds si
        pop     di es

        mov     si, offset Ws_E2_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_E2_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_E2_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

        mov     si, offset Ws_E2_F_Error_Message
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        mov     si, offset Ws_E2_D_General_I_O_Error
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Init screen E3=Error Screen - No option selected
;
        mov     si, offset Ws_E3
        push    ds si
        pop     di es

        mov     si, offset Ws_E3_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_E3_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_E3_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

;
; Init screen E4=Error Screen - Too many options selected
;
        mov     si, offset Ws_E4
        push    ds si
        pop     di es

        mov     si, offset Ws_E4_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_E4_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_E4_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

;
; Init screen DM=DiskMedium
;
        mov     si, offset Ws_DM
        push    ds si
        pop     di es

        mov     si, offset Ws_DM_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_DM_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_DM_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

        mov     si, offset Ws_DM_F_Single
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        mov     si, offset Ws_DM_D_Single
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DM_F_Medium

        push    ds si
        pop     di es

        mov     si, offset Ws_DM_D_Medium
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DM_F_Double

        push    ds si
        pop     di es

        mov     si, offset Ws_DM_D_Double
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DM_F_Quad

        push    ds si
        pop     di es

        mov     si, offset Ws_DM_D_Quad
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DM_F_720KB

        push    ds si
        pop     di es

        mov     si, offset Ws_DM_D_720KB
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DM_F_1440KB

        push    ds si
        pop     di es

        mov     si, offset Ws_DM_D_1440KB
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DM_F_Harddisk

        push    ds si
        pop     di es

        mov     si, offset Ws_DM_D_Harddisk
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DM_F_ATR_Or_XFD

        push    ds si
        pop     di es

        mov     ax, [Parm_ATR_Or_XFD_ptr_es]
        mov     bx, [Parm_ATR_Or_XFD_ptr_di]
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ax
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], bx

        mov     si, offset ATR_Or_XFD_Field
        mov     [(Wsio_Field ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Field ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_DM_F_Optimize

        push    ds si
        pop     di es

        mov     si, offset Ws_DM_D_Optimize
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DM_F_Key_Enter

        push    ds si
        pop     di es

        mov     si, offset Ws_DM_D_Key_Enter
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DM_F_Key_Esc

        push    ds si
        pop     di es

        mov     si, offset Ws_DM_D_Key_Esc
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Init screen DS=DosSpecification
;
        mov     si, offset Ws_DS
        push    ds si
        pop     di es

        mov     si, offset Ws_DS_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_DS_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_DS_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

        mov     si, offset Ws_DS_F_DOS25
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        mov     si, offset Ws_DS_D_DOS25
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DS_F_MYDOS

        push    ds si
        pop     di es

        mov     si, offset Ws_DS_D_MYDOS
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DS_F_MYOWNDOS_MYDOS

        push    ds si
        pop     di es

        mov     si, offset Ws_DS_D_MYOWNDOS_MYDOS
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DS_F_BEWEDOS

        push    ds si
        pop     di es

        mov     si, offset Ws_DS_D_BEWEDOS
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DS_F_SPARTADOS

        push    ds si
        pop     di es

        mov     si, offset Ws_DS_D_SPARTADOS
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DS_F_SPARTADOSX

        push    ds si
        pop     di es

        mov     si, offset Ws_DS_D_SPARTADOSX
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DS_F_MYOWNDOS_SPARTA

        push    ds si
        pop     di es

        mov     si, offset Ws_DS_D_MYOWNDOS_SPARTA
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DS_F_INCLUDE_DOS

        push    ds si
        pop     di es

        mov     si, offset Ws_DS_D_INCLUDE_DOS
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DS_F_DUPSYS

        push    ds si
        pop     di es

        mov     si, offset Ws_DS_D_DUPSYS
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DS_F_MAIN

        push    ds si
        pop     di es

        mov     si, offset Ws_DS_D_MAIN_DIR
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DS_F_Key_Enter

        push    ds si
        pop     di es

        mov     si, offset Ws_DS_D_Key_Enter
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DS_F_Key_Esc

        push    ds si
        pop     di es

        mov     si, offset Ws_DS_D_Key_Esc
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Init screen AD=AddDisks
;
        mov     si, offset Ws_AD
        push    ds si
        pop     di es

        mov     si, offset Ws_AD_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_AD_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_AD_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

        mov     si, offset Ws_AD_F_Add_Where
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        mov     si, offset Ws_AD_D_Add_Where
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si
        mov     si, offset End_Begin_Field
        mov     [(Wsio_Field ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Field ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_AD_F_Key_Enter

        push    ds si
        pop     di es

        mov     si, offset Ws_AD_D_Key_Enter
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_AD_F_Key_Esc

        push    ds si
        pop     di es

        mov     si, offset Ws_AD_D_Key_Esc
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Init screen CF=Create ATR Disk Image containing pc Files
;
        mov     si, offset Ws_CF
        push    ds si
        pop     di es

        mov     si, offset Ws_CF_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_CF_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

; Field 1
        mov     si, offset Ws_CF_F_Progress_Bar
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        mov     si, offset Ws_CF_D_Progress_Bar
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_CF_D_Progress_Bar_Attr
        mov     [(Wsio_Field ptr di).Attrib_Address_Hi], ds
        mov     [(WSio_Field ptr di).Attrib_Address_Lo], si

; Field 2
        mov     si, offset Ws_CF_F_Add_Disk
        push    ds si
        pop     di es

        mov     si, offset Ws_CF_D_Add_Disk
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

; Field 3
        mov     si, offset Ws_CF_F_Add_File
        push    ds si
        pop     di es

        mov     si, offset Ws_CF_D_Add_File
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Init screen FF=Format ATR Disk Image
;
        mov     si, offset Ws_FF
        push    ds si
        pop     di es

        mov     si, offset Ws_FF_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_FF_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

; Field 1
        mov     si, offset Ws_FF_F_Progress_Bar
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        mov     si, offset Ws_FF_D_Progress_Bar
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_FF_D_Progress_Bar_Attr
        mov     [(Wsio_Field ptr di).Attrib_Address_Hi], ds
        mov     [(WSio_Field ptr di).Attrib_Address_Lo], si

        ret

ENDP    Init_Screens



;**********************************************************************
PROC    Init_Files
;**********************************************************************
        mov     si, offset ATARI____File
        push    ds si
        pop     di es
        mov     si, offset ATARI____Pathname
        mov     [(FMS_Area ptr di).Path_Address_Hi], ds
        mov     [(FMS_Area ptr di).Path_Address_Lo], si
        mov     si, offset Disk_I_O_Buffer
        mov     [(FMS_Area ptr di).Data_Address_Hi], ds
        mov     [(FMS_Area ptr di).Data_Address_Lo], si
        mov     [(FMS_Area ptr di).Offset], ATR_HEADER_SIZE
        add     [(FMS_Area ptr di).Offset], DISK_BOOTCODE_SIZE

        mov     si, offset PC_ATARI_File
        push    ds si
        pop     di es
        mov     si, offset PC_ATARI_Pathname
        mov     [(FMS_Area ptr di).Path_Address_Hi], ds
        mov     [(FMS_Area ptr di).Path_Address_Lo], si
        ret

ENDP    Init_Files



;**********************************************************************
PROC    Parameter_Processing
;**********************************************************************
;----------------------
; Use current directory
;----------------------
        mov     si, offset Config_Startup_Path
        push    ds si
        pop     di es
        mov     cx, PATH_LENGTH
        xor     ax, ax                          ; Reset ax
        mov     al, SPACE
        rep     stosb                           ; Clear parameter

; Check parameter of where to write to
        mov     es, [Parm_Location_ptr_es]
        mov     di, [Parm_Location_ptr_di]
        cmp     [byte es:di], "*"               ; Use current directory?
        je      @@10

        push    ds si

        push    es di
        mov     si, offset Config_Startup_Path
        push    ds si
        pop     di es
        mov     cx, PATH_LENGTH
        pop     si ds
        rep     movsb

        pop     si ds

        jmp     @@20

@@10:
; Get default drive
        xor     ax, ax                          ; Reset ax
        mov     ah, DOS_GET_DEFAULT_DRIVE       ; Get Default Drive
        int     DOS_SERVICE 
        add     al, 041h                        ; Because of 0-based stuff

; Process Drive
        mov     si, offset Config_Startup_Path
        mov     [byte ds:si], al                ; Process Drive letter
        mov     [byte ds:si + 1], COLON
        mov     [byte ds:si + 2], BACKSLASH
        add     si, 3                           ; Locating at directory stuff

; Get current directory
        xor     ax, ax                          ; Reset ax
        mov     ah, DOS_GET_CURRENT_DIRECTORY
        xor     dx, dx                          ; Reset dx
        mov     dl, DOS_DEFAULT_DRIVE
        int     DOS_SERVICE

; Terminate it with a backslash "\"
        mov     si, offset Config_Startup_Path
        push    ds si
        pop     di es
        mov     cx, PATH_LENGTH
        dec     cx                              ; To go to the last character
        add     di, cx                          ; Go to end of path
        std                                     ; Searh direction is down
        mov     ax, SPACE                       ; Search for non space
        repe    scasb                           ; Search uses es:di
        cld                                     ; Cancel the std setting

        mov     cl, BACKSLASH                   ; Assume adding a backslash
        cmp     [byte es:di], BACKSLASH         ; Are we in the root?
        jne     @@15                            ; No
                                                ; Yes, so
        mov     cl, SPACE                       ; Replace 000h by SPACE

@@15:
        inc     di                              ; Pointer adjustment after search
        mov     [byte es:di], cl

;---------------------------------
; Copy Startup path to search path
;---------------------------------
@@20:
        mov     si, offset Search_Dirs_Path
        push    ds si
        pop     di es

        mov     si, offset Config_Startup_Path
        mov     cx, PATH_LENGTH
        rep     movsb

;----------------------------------------
; Copy Config Filemask to Search Filemask
;----------------------------------------
        mov     si, offset Search_Filemask
        push    ds si
        pop     di es
        mov     si, offset Config_Field_Filemask
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

@@99:
        ret

ENDP    Parameter_Processing



;**********************************************************************
PROC    Read_VTOC_Drives
;**********************************************************************
;
; Get drives in format: ACDE etc.
;
        push    ds si

        mov     es, [Parm_Drives_ptr_es]
        mov     di, [Parm_Drives_ptr_di]
        push    es di

        mov     si, offset Available_Drives
        push    ds si
        pop     di es

        mov     cx, MAX_DRIVES
        pop     si ds
        rep     movsb

        pop     si ds

;
; Get drives in format: [A: Myvolume   ]
;                       [C: Yourvolume ] etc.
;
        push    ds si

        mov     es, [Parm_Drives_Txt_ptr_es]
        mov     di, [Parm_Drives_Txt_ptr_di]
        push    es di

        mov     si, offset Ws_DR_D_Drive
        push    ds si
        pop     di es

        mov     cx, WS_DR_D_DRIVE_SIZE
        pop     si ds
        rep     movsb

        pop     si ds

;-----------------------
; Specify start of table
;-----------------------
        mov     [Ws_DR_Occur_Curr], 0

@@00:
;-----------------------------------
; Determine which drive to highlight
;-----------------------------------
        mov     [Ws_DR_Occur_W_Curr], 0

        mov     si, offset Search_Dirs_Path
        mov     bl, [byte ds:si]                ; Config path drive

;-------------------------------------------
; Determine maximum number of drives present
;-------------------------------------------
        mov     si, offset Ws_DR_F_Drive
        push    ds si
        pop     di es

        xor     ax, ax
        mov     al, [(Wsio_Field ptr di).Size]

        mov     cx, MAX_DRIVES

        mov     [Ws_DR_Occur_Max], 0
        mov     si, offset Ws_DR_D_Drive

@@10:
        cmp     [byte ds:si], SPACE
        je      @@30

        inc     [Ws_DR_Occur_Max]
        cmp     [byte ds:si], bl                ; Selected drive found?
        jne     @@20                            ; No
                                                ; Yes, so
        mov     dx, [Ws_DR_Occur_Max]
        mov     [Ws_DR_Occur_Curr], dx

@@15:
        mov     [Ws_DR_Occur_W_Curr], dx
        cmp     dx, [WS_DR_OCCUR_W_CURR_MAX]    ; dx > Max occur of window?
        jle     @@20                            ; No
                                                ; Yes, so
        sub     dx, [WS_DR_OCCUR_W_CURR_MAX]    ; Move 1 window up
        jmp     @@15

@@20:
        add     si, ax
        loop    @@10

@@30:
        cmp     [Ws_DR_Occur_W_Curr], 0         ; Invalid drive specified?
        jne     @@40                            ; No
                                                ; Yes, so
        mov     si, offset Config_Startup_Path
        push    ds si
        pop     di es
        mov     si, offset Default_Startup_Path
        mov     cx, PATH_LENGTH
        rep     movsb
        mov     si, offset Config_Startup_Path
        push    ds si
        pop     di es
        mov     si, offset Ws_DR_D_Drive
        mov     cx, 1
        rep     movsb

;---------------------------------
; Copy Startup path to search path
;---------------------------------
        mov     si, offset Search_Dirs_Path
        push    ds si
        pop     di es

        mov     si, offset Config_Startup_Path
        mov     cx, PATH_LENGTH
        rep     movsb

;----------------------------------------
; Copy Config Filemask to Search Filemask
;----------------------------------------
        mov     si, offset Search_Filemask
        push    ds si
        pop     di es
        mov     si, offset Config_Field_Filemask
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

@@40:
;------------------------------------
; Pass offset address of drives table
;------------------------------------
        mov     si, offset Ws_DR_D_Drive
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

@@99:
        ret

ENDP    Read_VTOC_Drives



;**********************************************************************
PROC    Open_Ws_BG
;**********************************************************************
        mov     si, offset Ws_BG
        mov     [byte ds:si], WSIO_OPEN
        push    ds si
        call    WSIO
        pop     si ds

        cmp     ax, NULL                        ; Error?
        jz      @@99                            ; No
                                                ; Yes, so
;
; Error
;

@@99:        
        ret

ENDP    Open_Ws_BG



;**********************************************************************
PROC    Display_Ws_BG
;**********************************************************************
        mov     si, offset Ws_BG
        mov     [byte ds:si], WSIO_DISPLAY_ONLY
        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_BG



;**********************************************************************
PROC    Display_Ws_FW
;**********************************************************************
        mov     si, offset Ws_FW

        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_FW



;**********************************************************************
PROC    Display_Ws_PA
;**********************************************************************
        mov     si, offset Ws_PA
        mov     [byte ds:si], WSIO_DISPLAY_ONLY

        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_PA



;**********************************************************************
PROC    Display_Ws_DR
;**********************************************************************
        mov     si, offset Ws_DR
        mov     [byte ds:si], WSIO_DISPLAY_ONLY

        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_DR



;**********************************************************************
PROC    Display_and_Read_Ws_DR
;**********************************************************************
;----------
; Init Path
;----------
;
; Reset Search Dirs Path
;
        mov     si, offset Search_Dirs_Path     ; Clear path
        push    ds si
        pop     di es
        mov     cx, PATH_LENGTH
        mov     ax, SPACE
        rep     stosb

        call    Display_Ws_DR
        jmp     @@10

;---------------------------------
; Show fields only of Drives Table
;---------------------------------
@@05:
        mov     si, offset Ws_DR
        mov     [byte ds:si], WSIO_DISPLAY_FIELDS_ONLY

        push    ds si
        call    WSIO
        pop     si ds

@@10:
;
; Make current occurrence Green/White
;
        mov     si, offset Ws_DR
        push    ds si
        pop     di es

        mov     cl, ATTRIB_GREEN_WHITE
        mov     [(Wsio_Area ptr di).Input_Select_Attrib], cl

        mov     [(Wsio_Area ptr di).Select_Field_Nr], 1
        mov     cx, [Ws_DR_Occur_W_Curr]
        mov     [(Wsio_Area ptr di).Select_Field_Occur_Nr], cl

        mov     [(Wsio_Area ptr di).Cursor_Position_Row], CURSOR_OFF_SCREEN
        mov     [(Wsio_Area ptr di).Cursor_Position_Col], CURSOR_OFF_SCREEN

;
; Display current occurrence
;
        mov     si, offset Ws_DR
        mov     [byte ds:si], WSIO_SELECT_DESELECT

        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_DR
        mov     [byte ds:si], WSIO_READ_ONLY

        push    ds si
        call    WSIO
        pop     si ds

;
; Save pressed key
;
        push    ax

;
; Reset current occurrence
;
        mov     si, offset Ws_DR
        push    ds si
        pop     di es

        mov     cl, [(Wsio_Area ptr di).Field_Attrib]
        mov     [(Wsio_Area ptr di).Input_Select_Attrib], cl

        mov     [(Wsio_Area ptr di).Select_Field_Nr], 1
        mov     cx, [Ws_DR_Occur_W_Curr]
        mov     [(Wsio_Area ptr di).Select_Field_Occur_Nr], cl

        mov     si, offset Ws_DR
        mov     [byte ds:si], WSIO_SELECT_DESELECT

        push    ds si
        call    WSIO
        pop     si ds

;
; Restore pressed key
;
        pop     ax

;--------------------------------
; Determine which key was pressed
;--------------------------------
        cmp     al, KEY_ARROW_UP
        je      @@20
        cmp     al, KEY_ARROW_DOWN
        je      @@25
        cmp     al, KEY_PAGE_UP
        je      @@30
        cmp     al, KEY_PAGE_DOWN
        je      @@35
        cmp     al, KEY_HOME
        je      @@40
        cmp     al, KEY_END
        je      @@45
        cmp     al, KEY_ENTER
        je      @@60
        cmp     al, KEY_HELP
        je      @@90
;
; Assume the Esc(ape) key
;
        jmp     @@99

;-------------
; KEY ARROW UP
;-------------
@@20:
        cmp     [Ws_DR_Occur_Curr], 1           ; Can we go "up" anyhow?
        je      @@10                            ; No
                                                ; Yes, so
;
; Move "up" to previous occurrence
;
        dec     [Ws_DR_Occur_Curr]

;
; Are we still in the current "window"?
;
        cmp     [Ws_DR_Occur_W_Curr], 1
        je      @@21

        dec     [Ws_DR_Occur_W_Curr]
        jmp     @@10

@@21:
;
; Move occurrence down
;
        mov     cx, [Ws_DR_Occur_Curr]          ; Get current occurrence
        jmp     @@50

;---------------
; KEY ARROW DOWN
;---------------
@@25:
        mov     dx, [Ws_DR_Occur_Max]           ; Max nr of available occurrences
        cmp     dx, [Ws_DR_Occur_Curr]          ; Current occurr = max?
        je      @@10                            ; Yes
                                                ; No, so
;
; Move "down" to next occurrence
;
        inc     [Ws_DR_Occur_Curr]

;
; Are we still in the current "window"?
;
        mov     dx, [WS_DR_OCCUR_W_CURR_MAX]    ; Max occurrence of window
        cmp     [Ws_DR_Occur_W_Curr], dx        ; Current occurr = max window?
        je      @@26                            ; Yes
                                                ; No, so
        inc     [Ws_DR_Occur_W_Curr]
        jmp     @@10

@@26:
;
; Move occurrences up
;
        mov     cx, [Ws_DR_Occur_Curr]          ; Get current occurrence
        sub     cx, [WS_DR_OCCUR_W_CURR_MAX]    ; Calculate window size
        inc     cx
        jmp     @@50

;------------
; KEY PAGE UP
;------------
@@30:
        cmp     [Ws_DR_Occur_Curr], 1           ; Can we go "up" anyhow?
        je      @@10                            ; No
                                                ; Yes, so
;
; Move up to previous window
;
        mov     cx, [Ws_DR_Occur_Curr]          ; Current occurrence
        sub     cx, [Ws_DR_Occur_W_Curr]        ; Determine begin of window
        inc     cx                              ; Which is done now
        cmp     cx, [WS_DR_OCCUR_W_CURR_MAX]    ; Can we subtract 1 page?
        jl      @@31                            ; No
                                                ; Yes, so
        sub     cx, [WS_DR_OCCUR_W_CURR_MAX]    ; Subtract size of 1 page
        jmp     @@32

@@31:
        mov     cx, 1                           ; Go to beginning of occur

@@32:
;
; Determine Window occurrence
;
        mov     dx, cx
        add     dx, [Ws_DR_Occur_W_Curr]
        dec     dx
        mov     [Ws_DR_Occur_Curr], dx
        jmp     @@50

;--------------
; KEY PAGE DOWN
;--------------
@@35:
        mov     cx, [Ws_DR_Occur_Curr]          ; Current occurrence
        sub     cx, [Ws_DR_Occur_W_Curr]        ; Determine begin of window
        inc     cx                              ; Which is done now
        add     cx, [WS_DR_OCCUR_W_CURR_MAX]    ; Add size of 1 page
        cmp     cx, [Ws_DR_Occur_Max]           ; Is there a next window?
        jnle    @@10                            ; No
                                                ; Yes, so
;
; Determine window occurrence
;
        mov     dx, cx
        add     dx, [Ws_DR_Occur_W_Curr]        ; Go to same window occurrence
        dec     dx                              ; Which is done now
        cmp     dx, [Ws_DR_Occur_Max]           ; Does it exist?
        jle     @@36                            ; Yes
                                                ; No, so
        mov     bx, dx                          ; bx = dx
        sub     bx, [Ws_DR_Occur_Max]           ; Determine difference
        sub     [Ws_DR_Occur_W_Curr], bx        ; Go to last occurrence
        mov     dx, [Ws_DR_Occur_Max]

@@36:
        mov     [Ws_DR_Occur_Curr], dx
        jmp     @@50

;---------
; KEY HOME
;---------
@@40:
        cmp     [Ws_DR_Occur_Curr], 1           ; Can we go "up" anyhow?
        je      @@10                            ; No
                                                ; Yes, so
        mov     cx, [Ws_DR_Occur_Curr]          ; Current occurrence
        sub     cx, [Ws_DR_Occur_W_Curr]        ; Determine begin of window
        inc     cx                              ; Which is done now
        cmp     cx, 1                           ; Showing from 1st already?
        jne     @@41                            ; No
                                                ; Yes, so
        cmp     [Ws_DR_Occur_W_Curr], 1         ; At top of window?
        je      @@10                            ; Yes
                                                ; No, so
@@41:
        mov     cx, 1                           ; Go to beginning of screen
        mov     [Ws_DR_Occur_W_Curr], 1
        mov     [Ws_DR_Occur_Curr], 1
        jmp     @@50

;--------
; KEY END
;--------
@@45:
        mov     cx, [Ws_DR_Occur_Curr]          ; Current occurrence
        cmp     cx, [Ws_DR_Occur_Max]           ; Can we go "down" anyhow?
        je      @@10                            ; No
                                                ; Yes, so
        mov     cx, [Ws_DR_Occur_Max]           ; Go to last occurrence
        mov     [Ws_DR_Occur_Curr], cx          ; Go to last occurrence in table
        cmp     cx, [WS_DR_OCCUR_W_CURR_MAX]    ; Does it all fit in 1 window?
        jnle    @@46                            ; No
                                                ; Yes, so
        mov     [Ws_DR_Occur_W_Curr], cx        ; Go  to  last entry in window
        jmp     @@50

@@46:
;
; Determine window occurrence
;
        sub     cx, [WS_DR_OCCUR_W_CURR_MAX]    ; Subtract 1 page
        inc     cx                              ; We are at the last page now
        mov     dx, [WS_DR_OCCUR_W_CURR_MAX]    ; Get last window occurrence
        mov     [Ws_DR_Occur_W_Curr], dx        ; Move to last window occurrence
        jmp     @@50

;----------------------------------------
; Set up drive window data and attributes
;----------------------------------------
@@50:
        mov     si, offset Ws_DR_F_Drive
        push    ds si
        pop     di es

        xor     ax, ax
        mov     al, [(Wsio_Field ptr di).Size]

        mov     si, offset Ws_DR_D_Drive

        jmp     @@52

@@51:
        add     si, ax

@@52:
        loop    @@51

        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        jmp     @@05

;----------
; KEY ENTER
;----------
@@60:
        mov     si, offset Ws_DR
        push    ds si
        pop     di es

        xor     bx, bx
        mov     bl, [(Wsio_Area ptr di).Select_Field_Occur_Nr]

        cmp     ah, WSIO_MOUSE_PRESSED          ; Mouse pressed Enter?
        jne     @@61                            ; No
                                                ; Yes, so
        xor     cx, cx
        mov     cl, [(Wsio_Area ptr di).Cursor_Position_Row]

;
; Mouse pressed Enter, is it valid?
;
        cmp     cl, 4                           ; Valid occurrence?
        jl      @@10                            ; No
                                                ; Maybe
        cmp     cl, 20                          ; Valid occurrence?
        jnle    @@10                            ; No
                                                ; Maybe
        sub     cl, 3                           ; Determine occurrence
        mov     dx, [Ws_DR_Occur_Curr]          ; Current occurrence
        sub     dx, bx
        add     dx, cx
        cmp     dx, [Ws_DR_Occur_Max]           ; Valid occurrence?
        jnle    @@10                            ; No
                                                ; Yes, so
        mov     [Ws_DR_Occur_Curr], dx          ; Set occurrence
        mov     [Ws_DR_Occur_W_Curr], cx

@@61:
;
; Copy selected drive to path
;
        mov     si, offset Search_Dirs_Path     ; 73 chars for Path
        push    ds si
        pop     di es

        mov     si, offset Available_Drives
        add     si, [Ws_DR_Occur_Curr]
        dec     si
        movsb
        mov     [byte es:di], COLON
        mov     [byte es:di + 1], BACKSLASH

;
; Show new path to user
;
        mov     si, offset Ws_PA
        mov     [byte ds:si], WSIO_DISPLAY_FIELDS_ONLY

        push    ds si
        call    WSIO
        pop     si ds

        mov     [Dir_Memo_Pointer], 0           ; Reset directory memo pointer
        jmp     @@99

;---------
; KEY HELP
;---------
@@90:
        call    Display_Ws_DH
        jmp     @@10

;-------
; Return
;-------
@@99:
        ret

ENDP    Display_and_Read_Ws_DR



;**********************************************************************
PROC    Display_Ws_DH
;**********************************************************************
        mov     si, offset Ws_DH
        mov     [byte ds:si], WSIO_OPEN
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_DH
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_DH
        mov     [byte ds:si], WSIO_CLOSE
        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_DH



;**********************************************************************
PROC    Read_VTOC_Directories_Files
;**********************************************************************
        cmp     [Dir_Up], 2                     ; Do we have to remember from which directory we came from?
        jne     @@05                            ; No
                                                ; Yes, so
        mov     cx, [Ws_LF_Occur_Curr]
        mov     dx, [Ws_LF_Occur_W_Curr]
        xor     ax, ax
        mov     al, [Dir_Memo_Pointer]          ; Get current occurrence
        rol     ax, 1                           ; Multiply by 2

        mov     si, offset Dir_Memo_Occur_Curr
        add     si, ax                          ; Move to empty spot
        mov     [ds:si], cx
        mov     si, offset Dir_Memo_Occur_W_Curr
        add     si, ax                          ; Move to empty spot
        mov     [ds:si], dx
        inc     [Dir_Memo_Pointer]

@@05:
        mov     [Ws_LF_Occur_Max], 0

;---------------------------------------------
; Get field size of Libraries/Files Table item
;---------------------------------------------
        mov     si, offset Ws_LF_F_Dir_Fil
        push    ds si
        pop     di es

        mov     ax, MAX_DIRS_AND_FILES + EXTRA_TABLE_FIELDS
        xor     bx, bx
        xor     cx, cx
        mov     cl, [byte (Wsio_Field ptr di).Size]
        xor     dx, dx
        mul     cx

;----------------------------
; Clear Libraries/Files Table
;----------------------------
        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]
        mov     cx, ax
        xor     ax, ax                          ; Reset ax
        mov     al, NULL                        ; Fill character
        rep     stosb

;----------------------------------------------
; Check if drive we have to access drive A or B
;----------------------------------------------
        call    Verify_Disk_Presence_Drive_A_Or_B       ; If were reading drive A or B

        cmp     [Disk_Present], LOGIC_YES       ; Diskette present
        jne     @@99                            ; No
                                                ; Yes, so
@@20:        
;-------------------------------
; Set up Search path - Libraries
;-------------------------------
;
; Copy shown path to search path first
;
        mov     si, offset Search_Files_Path
        push    ds si
        pop     di es
        mov     si, offset Search_Dirs_Path
        mov     cx, PATH_LENGTH
        rep     movsb

;
; Find first non blank character in the Search path
;
        mov     si, offset Search_Files_Path
        push    ds si
        pop     di es
        xor     ax, ax
        mov     al, SPACE                       ; Search the first space
        mov     cx, PATH_LENGTH
        repne   scasb                           ; Search
        dec     di                              ; Pointer correction after search

;
; Add "*.*" to the Search path
;
        mov     si, offset Directories_File_Mask
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

;
; Terminate it with a null
;
        mov     [byte es:di], NULL

;
; Set up parameters for Directory search
;
        mov     [Requested_Format_LibFil], "2"          ; Format "..           <DIR>      "
                                                        ;        "ATARI        <DIR>      "
        mov     si, offset Requested_Format_LibFil      ; Parameter 1
        push    ds si

        mov     si, offset Search_Files_Path            ; Parameter 2
        push    ds si

        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]                    ; Parameter 3
        push    es di
 
;-----------------------------------------
; Now retrieve Directory Map - Directories
;-----------------------------------------
        call    DC_DIRS

        pop     ax ax ax ax ax ax

;---------------------------
; Set up Search path - Files
;---------------------------

;
; Copy shown path to search path first
;
        mov     si, offset Search_Files_Path
        push    ds si
        pop     di es
        mov     si, offset Search_Dirs_Path
        mov     cx, PATH_LENGTH
        rep     movsb

;
; Find first non blank character in the Search path
;
        mov     si, offset Search_Files_Path
        push    ds si
        pop     di es
        xor     ax, ax
        mov     al, SPACE                               ; Search the first space
        mov     cx, PATH_LENGTH
        repne   scasb                                   ; Search
        dec     di                                      ; Pointer correction after search

;
; Add FileMask to the Search path
;
        mov     si, offset Disk_Mask_ATR

        push    es di

        mov     es, [Parm_ATR_Or_XFD_ptr_es]
        mov     di, [Parm_ATR_Or_XFD_ptr_di]
        mov     cl, [byte es:di]

        pop     di es

        cmp     cl, "A"                                 ; ATR disk?
        je      @@30                                    ; Yes
                                                        ; No, so
        mov     si, offset Disk_Mask_XFD

@@30:
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

;
; Terminate it with a null
;
        mov     [byte es:di], NULL

;
; Set up parameters for Directory search
;
        mov     [Requested_Format_LibFil], "2"          ; Format "..           <DIR>      "
                                                        ;        "ATARI        <DIR>      "
        mov     si, offset Requested_Format_LibFil      ; Parameter 1
        push    ds si

        mov     si, offset Search_Files_Path            ; Parameter 2
        push    ds si

        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]                    ; Parameter 3

;
; Search null terminator
;
        xor     ax, ax
        mov     al, NULL                        ; Search the first null
        mov     cx, DIR_MAP_LENGTH
        repne   scasb                           ; Search
        dec     di                              ; Pointer correction after search

        push    es di
 
;-----------------------------------
; Now retrieve Directory Map - Files
;-----------------------------------
        call    DC_FILES

        pop     ax ax ax ax ax ax

;------------------------------------------------------
; After reading the VTOC we are at the first occurrence
;------------------------------------------------------
        mov     cx, 1                           ; To satisfy loop condition
        mov     [Ws_LF_Occur_Curr], 1
        mov     [Ws_LF_Occur_W_Curr], 1

        cmp     [Dir_Up], 1                     ; Did we go up a dir?
        jne     @@50                            ; No
                                                ; Yes, so
        cmp     [Dir_Memo_Pointer], 0           ; Did we have save info of previous dirs?
        je      @@50                            ; No
                                                ; Yes, so
        dec     [Dir_Memo_Pointer]

        xor     ax, ax
        mov     al, [Dir_Memo_Pointer]          ; Get current occurrence
        rol     ax, 1                           ; Multiply by 2

        mov     si, offset Dir_Memo_Occur_Curr
        add     si, ax                          ; Move to occupied spot
        mov     cx, [ds:si]
        mov     si, offset Dir_Memo_Occur_W_Curr
        add     si, ax                          ; Move to occupied spot
        mov     dx, [ds:si]

        mov     [Ws_LF_Occur_Curr], cx
        mov     [Ws_LF_Occur_W_Curr], dx

        sub     cx, [Ws_LF_Occur_W_Curr]        ; Determine begin of window
        inc     cx                              ; Which is done now

@@50:
        mov     si, offset Ws_LF_F_Dir_Fil

        push    ds si
        pop     di es

        xor     ax, ax
        mov     al, [(Wsio_Field ptr di).Size]

        push    es di

        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]

        jmp     @@52

@@51:
        add     di, ax

@@52:
        loop    @@51

        mov     ax, es
        mov     bx, di

        pop     di es

        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ax
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], bx

;------------------------------------
; Determine MAXimum nr of occurrences
;------------------------------------
        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]
        mov     cx, DIR_MAP_LENGTH              ; Search length
        xor     ax, ax                          ; Search for null character
        repne   scasb                           ; Search uses es:di

        mov     ax, DIR_MAP_LENGTH
        sub     ax, cx                          ; Nr of entries in size determined
        xor     dx, dx
        xor     cx, cx
        mov     bx, DIR_ENTRY_LENGTH            ; Determine nr of occurs
        div     bx

        mov     [Ws_LF_Occur_Max], ax

@@99:
        call    Display_Ws_PA                   ; Display path

        ret

ENDP    Read_VTOC_Directories_Files



;**********************************************************************
PROC    Verify_Disk_Presence_Drive_A_Or_B
;**********************************************************************
        mov     [Disk_Present], LOGIC_YES

;----------------------------------------------
; Check if drive we have to access drive A or B
;----------------------------------------------
        mov     si, offset Search_Dirs_Path
        cmp     [byte ds:si], "A"               ; Access drive A?
        je      @@10                            ; Yes
                                                ; No, so
        cmp     [byte ds:si], "B"               ; Access drive B?
        jne     @@99                            ; No
                                                ; Yes, so
@@10:
        xor     bx, bx                          ; Reset dx
        mov     bl, [byte ds:si]                ; Copy selected drive to path
        sub     bl, 64                          ; Turn drive into DOS drive
        mov     ax, DOS_SENSE_MEDIA_TYPE
        mov     al, 00Dh                        ; subfunction code
        mov     cx, DOS_GET_MEDIA_ID_CX
        mov     dx, offset Media_ID_Buffer
        int     DOS_SERVICE                     ; Check Drive Presence
        cmp     ax, DOS_DRIVE_NOT_READY         ; Drive ready?
        jne     @@99                            ; Yes
                                                ; No, so
        mov     [Disk_Present], LOGIC_NO

;------------------------
; ERROR - DRIVE NOT READY
;------------------------
        mov     si, offset Ws_E1
        mov     [byte ds:si], WSIO_OPEN
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_E1
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_E1
        mov     [byte ds:si], WSIO_CLOSE
        push    ds si
        call    WSIO
        pop     si ds

@@99:
        ret

ENDP    Verify_Disk_Presence_Drive_A_Or_B



;**********************************************************************
PROC    Display_and_Read_Ws_LF
;**********************************************************************
        jmp     @@61                                    ; Because of startup path

;------------------------------------------
; Show fields only of Libraries/Files Table
;------------------------------------------
@@00:
        mov     si, offset Ws_LF
        mov     [byte ds:si], WSIO_DISPLAY_FIELDS_ONLY

        push    ds si
        call    WSIO
        pop     si ds

@@05:
;------------------------------------------
; Show Freeware Text or Disk Image contents
;------------------------------------------
        call    Display_Ws_FW                           ; Show Freeware Text

;------------------------------------
; Make current occurrence Green/White
;------------------------------------
@@10:
        mov     si, offset Ws_LF
        push    ds si
        pop     di es

        mov     cl, ATTRIB_GREEN_WHITE
        mov     [(Wsio_Area ptr di).Input_Select_Attrib], cl

        mov     [(Wsio_Area ptr di).Select_Field_Nr], 1
        mov     cx, [Ws_LF_Occur_W_Curr]
        mov     [(Wsio_Area ptr di).Select_Field_Occur_Nr], cl

        mov     [(Wsio_Area ptr di).Cursor_Position_Row], CURSOR_OFF_SCREEN
        mov     [(Wsio_Area ptr di).Cursor_Position_Col], CURSOR_OFF_SCREEN

;
; Display current occurrence
;
        mov     si, offset Ws_LF
        mov     [byte ds:si], WSIO_SELECT_DESELECT

        push    ds si
        call    WSIO
        pop     si ds

;----------
; Get input
;----------
        mov     si, offset Ws_LF
        mov     [byte ds:si], WSIO_READ_ONLY

        push    ds si
        call    WSIO
        pop     si ds

;
; Save pressed key
;
        push    ax

;
; Reset current occurrence
;
        mov     si, offset Ws_LF
        push    ds si
        pop     di es

        mov     cl, [(Wsio_Area ptr di).Field_Attrib]
        mov     [(Wsio_Area ptr di).Input_Select_Attrib], cl

        mov     [(Wsio_Area ptr di).Select_Field_Nr], 1
        mov     cx, [Ws_LF_Occur_W_Curr]
        mov     [(Wsio_Area ptr di).Select_Field_Occur_Nr], cl

        mov     si, offset Ws_LF
        mov     [byte ds:si], WSIO_SELECT_DESELECT

        push    ds si
        call    WSIO
        pop     si ds

;
; Restore pressed key
;
        pop     ax

;--------------------------------
; Determine which key was pressed
;--------------------------------
        cmp     al, KEY_ARROW_UP
        je      @@15
        cmp     al, KEY_ARROW_DOWN
        je      @@20
        cmp     al, KEY_PAGE_UP
        je      @@25
        cmp     al, KEY_PAGE_DOWN
        je      @@30
        cmp     al, KEY_HOME
        je      @@35
        cmp     al, KEY_END
        je      @@40
        cmp     al, KEY_ENTER
        je      @@50
        cmp     al, KEY_F2                              ; Do it! Convert all files to .ATR imagaes
        je      @@55
        cmp     al, KEY_F3                              ; Back to drives
        je      @@60
;
; Check for control key + drive letter
;
        mov     cx, MAX_DRIVES                          ; Drive A thru Z
        mov     bx, 1                                   ; Start at drive A

@@11:
        cmp     al, bl
        je      @@70
        inc     bx                                      ; Try next drive
        loop    @@11

        cmp     al, KEY_HELP
        je      @@90
;
; Assume the Esc(ape) key
;
        jmp     @@99

;-------------
; KEY ARROW UP
;-------------
@@15:
        cmp     [Ws_LF_Occur_Curr], 1                   ; Can we go "up" anyhow?
        je      @@10                                    ; No
                                                        ; Yes, so
;
; Move "up" to previous occurrence
;
        dec     [Ws_LF_Occur_Curr]

;
; Are we still in the current "window"?
;
        cmp     [Ws_LF_Occur_W_Curr], 1
        je      @@16

        dec     [Ws_LF_Occur_W_Curr]
        jmp     @@05

@@16:
;
; Move occurrence down
;
        mov     cx, [Ws_LF_Occur_Curr]                  ; Get current occurrence
        jmp     @@45

;---------------
; KEY ARROW DOWN
;---------------
@@20:
        mov     dx, [Ws_LF_Occur_Max]                   ; Max nr of available occurrences
        cmp     dx, [Ws_LF_Occur_Curr]                  ; Current occurr = max?
        je      @@10                                    ; Yes
                                                        ; No, so
;
; Move "down" to next occurrence
;
        inc     [Ws_LF_Occur_Curr]

;
; Are we still in the current "window"?
;
        mov     dx, [WS_LF_OCCUR_W_CURR_MAX]            ; Max occurrence of window
        cmp     [Ws_LF_Occur_W_Curr], dx                ; Current occurr = max window?
        je      @@21                                    ; Yes
                                                        ; No, so
        inc     [Ws_LF_Occur_W_Curr]
        jmp     @@05

@@21:
;
; Move occurrences up
;
        mov     cx, [Ws_LF_Occur_Curr]                  ; Get current occurrence
        sub     cx, [WS_LF_OCCUR_W_CURR_MAX]            ; Calculate window size
        inc     cx
        jmp     @@45

;------------
; KEY PAGE UP
;------------
@@25:
        cmp     [Ws_LF_Occur_Curr], 1                   ; Can we go "up" anyhow?
        je      @@10                                    ; No
                                                        ; Yes, so
;
; Move up to previous window
;
        mov     cx, [Ws_LF_Occur_Curr]                  ; Current occurrence
        sub     cx, [Ws_LF_Occur_W_Curr]                ; Determine begin of window
        inc     cx                                      ; Which is done now
        cmp     cx, [WS_LF_OCCUR_W_CURR_MAX]            ; Can we subtract 1 page?
        jl      @@26                                    ; No
                                                        ; Yes, so
        sub     cx, [WS_LF_OCCUR_W_CURR_MAX]            ; Subtract size of 1 page
        jmp     @@27

@@26:
        mov     cx, 1                                   ; Go to beginning of occur

@@27:
;
; Determine Window occurrence
;
        mov     dx, cx
        add     dx, [Ws_LF_Occur_W_Curr]
        dec     dx
        mov     [Ws_LF_Occur_Curr], dx
        jmp     @@45

;--------------
; KEY PAGE DOWN
;--------------
@@30:
        mov     cx, [Ws_LF_Occur_Curr]                  ; Can we go "down" anyhow?
        sub     cx, [Ws_LF_Occur_W_Curr]                ; Determine begin of window
        inc     cx                                      ; Which is done now
        add     cx, [WS_LF_OCCUR_W_CURR_MAX]            ; Add size of 1 page
        cmp     cx, [Ws_LF_Occur_Max]                   ; Is there a next window?
        jnle    @@10                                    ; No
                                                        ; Yes, so
;
; Determine window occurrence
;
        mov     dx, cx
        add     dx, [Ws_LF_Occur_W_Curr]                ; Go to same window occurrence
        dec     dx                                      ; Which is done now
        cmp     dx, [Ws_LF_Occur_Max]                   ; Does it exist?
        jle     @@31                                    ; Yes
                                                        ; No, so
        mov     bx, dx                                  ; bx = dx
        sub     bx, [Ws_LF_Occur_Max]                   ; Determine difference
        sub     [Ws_LF_Occur_W_Curr], bx                ; Go to last occurrence
        mov     dx, [Ws_LF_Occur_Max]

@@31:
        mov     [Ws_LF_Occur_Curr], dx
        jmp     @@45

;---------
; KEY HOME
;---------
@@35:
        cmp     [Ws_LF_Occur_Curr], 1                   ; Can we go "up" anyhow?
        je      @@10                                    ; No
                                                        ; Yes, so
        mov     cx, [Ws_LF_Occur_Curr]                  ; Current occurrence
        sub     cx, [Ws_LF_Occur_W_Curr]                ; Determine begin of window
        inc     cx                                      ; Which is done now
        cmp     cx, 1                                   ; Showing from 1st already?
        jne     @@36                                    ; No
                                                        ; Yes, so
        cmp     [Ws_LF_Occur_W_Curr], 1                 ; At top of window?
        je      @@10                                    ; Yes
                                                        ; No, so
@@36:
        mov     cx, 1                                   ; Go to beginning of screen
        mov     [Ws_LF_Occur_W_Curr], 1
        mov     [Ws_LF_Occur_Curr], 1
        jmp     @@45

;--------
; KEY END
;--------
@@40:
        mov     cx, [Ws_LF_Occur_Curr]                  ; Current occurrence
        cmp     cx, [Ws_LF_Occur_Max]                   ; Can we go "down" anyhow?
        je      @@10                                    ; No
                                                        ; Yes, so
        mov     cx, [Ws_LF_Occur_Max]                   ; Go to last occurrence
        mov     [Ws_LF_Occur_Curr], cx                  ; Go to last occurrence in table
        cmp     cx, [WS_LF_OCCUR_W_CURR_MAX]            ; Does it all fit in 1 window?
        jnle    @@41                                    ; No
                                                        ; Yes, so
        mov     [Ws_LF_Occur_W_Curr], cx                ; Go  to  last entry in window
        mov     cx, 1                                   ; Start from first occurrence
        jmp     @@45

@@41:
;
; Determine window occurrence
;
        sub     cx, [WS_LF_OCCUR_W_CURR_MAX]            ; Subtract 1 page
        inc     cx                                      ; We are at the last page now
        mov     dx, [WS_LF_OCCUR_W_CURR_MAX]            ; Get last window occurrence
        mov     [Ws_LF_Occur_W_Curr], dx                ; Move to last window occurrence
        jmp     @@45

;--------------------------------------------
; Set up dir/image window data and attributes
;--------------------------------------------
@@45:
        mov     si, offset Ws_LF_F_Dir_Fil

        push    ds si
        pop     di es

        xor     ax, ax
        mov     al, [(Wsio_Field ptr di).Size]

        push    es di

        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]

        jmp     @@47

@@46:
        add     di, ax

@@47:
        loop    @@46

        mov     ax, es
        mov     bx, di

        pop     di es

        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ax
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], bx

        jmp     @@00

;----------
; KEY ENTER
;----------
@@50:
        mov     si, offset Ws_LF
        push    ds si
        pop     di es

        xor     bx, bx
        mov     bl, [(Wsio_Area ptr di).Select_Field_Occur_Nr]
        cmp     ah, WSIO_MOUSE_PRESSED                  ; Mouse pressed Enter?
        jne     @@51                                    ; No
                                                        ; Yes, so
        xor     cx, cx
        mov     cl, [(Wsio_Area ptr di).Cursor_Position_Row]

;
; Mouse pressed Enter, is it valid?
;
        cmp     cl, 22                                  ; Enter pressed?
        je      @@51                                    ; Yes
                                                        ; No, so
        cmp     cl, 4                                   ; Valid occurrence?
        jl      @@10                                    ; No
                                                        ; Maybe
        cmp     cl, 20                                  ; Valid occurrence?
        jnle    @@10                                    ; No
                                                        ; Maybe
        sub     cl, 3                                   ; Determine occurrence
        mov     dx, [Ws_LF_Occur_Curr]                  ; Current occurrence
        sub     dx, bx
        add     dx, cx
        cmp     dx, [Ws_LF_Occur_Max]                   ; Valid occurrence?
        jnle    @@10                                    ; No
                                                        ; Yes, so
        mov     [Ws_LF_Occur_Curr], dx                  ; Set occurrence
        mov     [Ws_LF_Occur_W_Curr], cx

@@51:
        push    ds si

;
; Go to end of path
;
        mov     si, offset Search_Dirs_Path             ; 73 chars for Path
        push    ds si
        pop     di es
        mov     cx, PATH_LENGTH
        dec     cx                                      ; To go to the last character
        add     di, cx                                  ; Go to end of path
        std                                             ; Searh direction is down
        mov     ax, BACKSLASH                           ; Search for "\"
        repne   scasb                                   ; Search uses es:di
        cld                                             ; Cancel the std setting
        inc     di                                      ; Pointer adjustment after search
        inc     di                                      ; To postion after the "\"

;
; Determine selected directory/file
;
        mov     ax, [Ws_LF_Occur_Curr]
        dec     ax                                      ; Because of offset reasons
        xor     bx, bx
        mov     cx, DIR_ENTRY_LENGTH
        xor     dx, dx
        mul     cx

;
; Go to drive selection or dirs?
;        
        push    es di

        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]
        add     di, ax
        cmp     [byte es:di], DOT                       ; Go to drive selection/dirs?
        jne     @@63                                    ; No
                                                        ; Yes, so
        pop     di es                                   ; Check path
        pop     si ds
        cmp     [byte es:di - 2], COLON                 ; Go to drive selection?
        jne     @@62                                    ; No
                                                        ; Yes, so
        jmp     @@60                                    ; Go to drive selection

;-------------------------------------
; KEY F2 - CONVERT FILES TO ATR IMAGES
;-------------------------------------
@@55:
        call    Add_DirFiles_To_ATR_Image

        cmp     al, KEY_ESC                             ; Return to dir where ATR's should be stored?
        je      @@10                                    ; Yes
                                                        ; No, so
        jmp     @@99                                    ; Return to Files to ATR

;------------------------------
; KEY F3 - Select another drive
;------------------------------
@@60:
;
; Select another drive
;

;
; Reset Search Files Path
;
        mov     si, offset Search_Files_Path
        push    ds si
        pop     di es
        mov     cx, PATH_LENGTH
        mov     ax, SPACE
        rep     stosb                                   ; Clear path

        call    Display_Ws_PA                           ; Display path
        call    Display_and_Read_Ws_DR                  ; Let user select drive

        cmp     al, KEY_ESC                             ; Cancel pressed?
        je      @@99                                    ; Yes
                                                        ; No, so
@@61:
        mov     [Dir_Up], 0                             ; We stay in the current dir
        call    Read_VTOC_Directories_Files             ; Retrieve directories/files

        cmp     [Ws_LF_Occur_Max], 0                    ; Drive not ready?
        je      @@60                                    ; Yes
                                                        ; No, so
        mov     si, offset Ws_LF
        mov     [byte ds:si], WSIO_DISPLAY_ONLY

        push    ds si
        call    WSIO
        pop     si ds

        jmp     @@05

@@62:
;
; Go to previous dir
;
        dec     di                                      ; Position on the "\"
        dec     di                                      ; Position before the "\"
        std                                             ; Searh direction is down
        mov     cx, DIR_NAME_LENGTH + 1
        mov     ax, BACKSLASH                           ; Search for "\"
        repne   scasb                                   ; Search uses es:di
        cld                                             ; Cancel the std setting
        inc     di                                      ; Pointer adjustment after search
        inc     di                                      ; To postion after the "\"

        mov     cx, DIR_NAME_LENGTH + 1                 ; Because of "\"
        add     cx, FILE_NAME_LENGTH                    ; Because of *.ATR
        mov     ax, SPACE
        rep     stosb

        mov     [Dir_Up], 1                             ; We go to previous dir
        call    Read_VTOC_Directories_Files             ; Retrieve directories/files
        cmp     [Ws_LF_Occur_Max], 0                    ; Drive ready?
        je      @@60                                    ; No
                                                        ; Yes, so
        jmp     @@00

@@63:
;
; Go to subdir OR do nothing
;
        push    es di
        add     di, FILE_NAME_LENGTH + 1                ; Go to file size
        cmp     [byte es:di], "<"                       ; Directory indicator
        pop     si ds                                   ; From -> Dir/File table

        pop     di es                                   ; To   -> Path
        jne     @@64                                    ; It's a file!
                                                        ; It's a directory, so
        mov     cx, DIR_NAME_LENGTH
        rep     movsb

        pop     si ds

        std                                             ; Searh direction is down
        mov     cx, DIR_NAME_LENGTH + 1
        mov     ax, SPACE                               ; Search for not equal " "
        repe    scasb                                   ; Search uses es:di
        cld                                             ; Cancel the std setting
        inc     di                                      ; Pointer adjustment after search
        inc     di                                      ; To position after the " "

        mov     [byte es:di], BACKSLASH

        mov     [Dir_Up], 2                             ; We go to a subdir
        call    Read_VTOC_Directories_Files             ; Retrieve directories/files

        cmp     [Ws_LF_Occur_Max], 0                    ; Drive not ready?
        je      @@60                                    ; Yes
                                                        ; No, so

        jmp     @@00

@@64:
        pop     si ds

        jmp     @@10

;---------------------------
; Control Key + Drive Letter
;---------------------------
@@70:
        add     ax, 040h                                ; Turn drive into letter
        mov     cx, MAX_DRIVES                          ; Drives A thru Z
        mov     si, offset Available_Drives             ; Available drives

@@71:
        cmp     al, [byte ds:si]                        ; Selected drive present in table?
        je      @@72                                    ; Yes
                                                        ; No, so
        inc     si                                      ; Next drive from table
        loop    @@71                                    ; Check next drive
        jmp     @@60                                    ; Invalid drive, let user choose correct one

@@72:
        push    ax                                      ; Save drive letter

        mov     si, offset Search_Files_Path            ; Reset Search Files Path
        push    ds si
        pop     di es
        mov     cx, PATH_LENGTH
        mov     ax, SPACE
        rep     stosb

        mov     si, offset Search_Dirs_Path             ; Reset Search Dirs Path
        push    ds si
        pop     di es
        inc     di
        mov     cx, PATH_LENGTH - 1
        mov     ax, SPACE
        rep     stosb

        mov     si, offset Search_Dirs_Path             ; Copy selected drive to path
        push    ds si
        pop     di es

        pop     ax                                      ; Restore drive letter

        mov     [byte es:di], al
        mov     [byte es:di + 1], COLON
        mov     [byte es:di + 2], BACKSLASH

        jmp     @@61                                    ; Retrieve directories/files of selected drive

;---------
; KEY HELP
;---------
@@90:
        call    Display_Ws_LH
        jmp     @@05

;-------
; Return
;-------
@@99:
        ret

ENDP    Display_and_Read_Ws_LF



;**********************************************************************
PROC    Display_Ws_LH
;**********************************************************************
        mov     si, offset Ws_LH
        mov     [byte ds:si], WSIO_OPEN
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_LH
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_LH
        mov     [byte ds:si], WSIO_CLOSE
        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_LH



;**********************************************************************
PROC    Add_DirFiles_To_ATR_Image
;**********************************************************************
        mov     [Dir2atr_Error], LOGIC_NO

        cmp     [D_FilDsk_Initialize], LOGIC_YES        ; Initialize executed?
        je      @@60                                    ; Yes
                                                        ; No, so
        mov     [D_FilDsk_Initialize], LOGIC_YES

;
; Process initial DOS to use
;
        mov     [Ws_DS_D_DOS25], SPACE
        mov     [Ws_DS_D_MYDOS], SPACE
        mov     [Ws_DS_D_MYOWNDOS_MYDOS], SPACE
        mov     [Ws_DS_D_BEWEDOS], SPACE
        mov     [Ws_DS_D_SPARTADOS], SPACE
        mov     [Ws_DS_D_SPARTADOSX], SPACE
        mov     [Ws_DS_D_MYOWNDOS_SPARTA], SPACE

        mov     si, offset Ws_DS_F_DOS25
        push    ds si
        pop     di es
        mov     [(Wsio_Field ptr di).Modifiable], LOGIC_YES

        mov     es, [Parm_DISK_FORMAT_ptr_es]
        mov     di, [Parm_DISK_FORMAT_ptr_di]

        mov     [Ws_DS_D_DOS25], "X"
        cmp     [byte es:di], "D"                       ; Disk format DOS 2.5?
        je      @@10                                    ; Yes
                                                        ; No, so
        mov     [Ws_DS_D_DOS25], SPACE
        mov     [Ws_DS_D_MYDOS], "X"
        cmp     [byte es:di], "M"                       ; Disk format MYDOS 4.53?
        je      @@10                                    ; Yes
                                                        ; No, so
        mov     [Ws_DS_D_MYDOS], SPACE
        mov     [Ws_DS_D_MYOWNDOS_MYDOS], "X"
        cmp     [byte es:di], "O"                       ; Disk format Your Own DOS DOS format?
        je      @@10                                    ; Yes
                                                        ; No, so
        mov     [Ws_DS_D_MYOWNDOS_MYDOS], SPACE
        mov     [Ws_DS_D_BEWEDOS], "X"
        cmp     [byte es:di], "B"                       ; Disk format BeWeDOS?
        je      @@10                                    ; Yes
                                                        ; No, so
        mov     [Ws_DS_D_BEWEDOS], SPACE
        mov     [Ws_DS_D_SPARTADOS], "X"
        cmp     [byte es:di], "S"                       ; Disk format SPARTADOS 3.3a?
        je      @@10                                    ; Yes
                                                        ; No, so
        mov     [Ws_DS_D_SPARTADOS], SPACE
        mov     [Ws_DS_D_SPARTADOSX], "X"
        cmp     [byte es:di], "X"                       ; Disk format SPARTADOS/X?
        je      @@10                                    ; Yes
                                                        ; No, so
        mov     [Ws_DS_D_SPARTADOSX], SPACE
        mov     [Ws_DS_D_MYOWNDOS_SPARTA], "X"
        cmp     [byte es:di], "Y"                       ; Disk format Your Own DOS SPARTA format?
        je      @@10                                    ; Yes
                                                        ; No, so
        mov     [Ws_DS_D_MYOWNDOS_SPARTA], SPACE

@@10:
;
; Assume standard file creation (no optimize)
;
        mov     [Ws_DM_D_Optimize], SPACE

;
; Process initial disk format to use
;
        mov     [Ws_DM_D_Single],   SPACE
        mov     [Ws_DM_D_Medium],   SPACE
        mov     [Ws_DM_D_Double],   SPACE
        mov     [Ws_DM_D_Quad],     SPACE
        mov     [Ws_DM_D_720KB],    SPACE
        mov     [Ws_DM_D_1440KB],   SPACE
        mov     [Ws_DM_D_Harddisk], SPACE

        mov     es, [Parm_Density_ptr_es]
        mov     di, [Parm_Density_ptr_di]

;
; Check Single
;
        mov     [Ws_DM_D_Single], "X"
        cmp     [byte es:di], DISK_MEDIA_TYPE_SINGLE    ; Use Single Density?
        je      @@20                                    ; Yes
                                                        ; No, so
        mov     [Ws_DM_D_Single], SPACE

;
; Check Medium
;
        mov     [Ws_DM_D_Medium], "X"
        cmp     [byte es:di], DISK_MEDIA_TYPE_MEDIUM    ; Use Medium Density?
        je      @@20                                    ; Yes
                                                        ; No, so
        mov     [Ws_DM_D_Medium], SPACE

;
; Check Double
;
        mov     [Ws_DM_D_Double], "X"
        cmp     [byte es:di], DISK_MEDIA_TYPE_DOUBLE    ; Use Double Density?
        je      @@20                                    ; Yes
                                                        ; No, so
        mov     [Ws_DM_D_Double], SPACE

;
; Check Quad
;
        mov     [Ws_DM_D_Quad], "X"
        cmp     [byte es:di], DISK_MEDIA_TYPE_QUAD      ; Use Quad Density?
        je      @@15                                    ; Yes
                                                        ; No, so
        mov     [Ws_DM_D_Quad], SPACE

;
; Check 720KB
;
        mov     [Ws_DM_D_720KB], "X"
        cmp     [byte es:di], DISK_MEDIA_TYPE_720KB     ; Use 720 KB diskette?
        je      @@15                                    ; Yes
                                                        ; No, so
        mov     [Ws_DM_D_720KB], SPACE

;
; Check 1440KB
;
        mov     [Ws_DM_D_1440KB], "X"
        cmp     [byte es:di], DISK_MEDIA_TYPE_1440KB    ; Use 1.44 MB diskette?
        je      @@15                                    ; Yes
                                                        ; No, so
        mov     [Ws_DM_D_1440KB], SPACE

;
; Check Harddisk
;
        mov     [Ws_DM_D_Harddisk], "X"
        cmp     [byte es:di], DISK_MEDIA_TYPE_HARDDISK  ; Use Harddisk?
        je      @@15                                    ; Yes
                                                        ; No, so
        mov     [Ws_DM_D_Harddisk], SPACE

;
; Assume Medium disk
;
        mov     [Ws_DM_D_Medium], "X"
        jmp     @@20

@@15:
        mov     [Ws_DS_D_DOS25], SPACE

@@20:
        mov     [Ws_DS_D_INCLUDE_DOS], SPACE
        mov     [Ws_DS_D_DUPSYS], SPACE
        mov     [Ws_DS_D_MAIN_DIR], SPACE

        mov     es, [Parm_MAIN_Dir_ptr_es]
        mov     di, [Parm_MAIN_Dir_ptr_di]

        cmp     [byte es:di], LOGIC_YES                 ; Use SpartaDos Main Dir?
        jne     @@21                                    ; No
                                                        ; Yes, so
        mov     [Ws_DS_D_MAIN_DIR], "X"

@@21:
        mov     es, [Parm_INCLUDE_DOS_ptr_es]
        mov     di, [Parm_INCLUDE_DOS_ptr_di]

        cmp     [byte es:di], LOGIC_YES                 ; Include DOS?
        jne     @@30                                    ; No
                                                        ; Yes, so
        mov     [Ws_DS_D_INCLUDE_DOS], "X"

@@25:
        mov     es, [Parm_DUP_SYS_ptr_es]
        mov     di, [Parm_DUP_SYS_ptr_di]

        cmp     [byte es:di], LOGIC_YES                 ; Include DUP_SYS?
        jne     @@30                                    ; No
                                                        ; Yes, so
        mov     [Ws_DS_D_DUPSYS], "X"

@@30:
;-------------------------------
; Check presence of DOS.SYS file
;-------------------------------
        call    Setup_Pathname_ATARI_DOS_SYS_File

        mov     si, offset PC_ATARI_File
        push    ds si
        pop     di es
        mov     [(FMS_Area ptr di).Request], CMD_OPEN_EXIST

        push    es di
        call    FMSIO
        pop     di es

        cmp     [(FMS_Area ptr di).Status], STATUS_OK
        je      @@50                                    ; File exists
                                                        ; No, so
        mov     [Ws_DS_D_DOS25], SPACE
        mov     [Ws_DS_D_MYDOS], SPACE
        mov     [Ws_DS_D_MYOWNDOS_MYDOS], SPACE
        mov     [Ws_DS_D_BEWEDOS], SPACE
        mov     [Ws_DS_D_SPARTADOS], SPACE
        mov     [Ws_DS_D_SPARTADOSX], SPACE
        mov     [Ws_DS_D_MYOWNDOS_SPARTA], SPACE

@@50:
        mov     [Ws_AD_D_Add_Where], "B"

@@60:
;----------------------------
; Retrieve DISK MEDIUM Format
;----------------------------
        call    Process_Disk_Media_Format
        cmp     al, KEY_ESC
        je      @@99

@@70:
;--------------------
; Retrieve Disk Format
;--------------------
        call    Process_Disk_Format
        cmp     al, KEY_ESC
        je      @@60

;-----------------------------
; Check "SpartaDos" processing
;-----------------------------
        cmp     [Disk_Format], BEWEDOS_FORMAT
        je      @@75

        cmp     [Disk_Format], SPARTADOS_FORMAT
        je      @@75

        cmp     [Disk_Format], SPARTADOSX_FORMAT
        je      @@75

        cmp     [Disk_Format], MYOWNDOS_SPARTADOS_FORMAT
        jne     @@80

@@75:
;------------------------------------
; Create "SpartaDos" look-a-like disk
;------------------------------------
        cmp     [CLI_Used], LOGIC_YES                   ; Command Line Interface used?
        je      @@76                                    ; Yes
                                                        ; No, so
;---------
; From GUI
;---------
        mov     si, offset File_Path                    ; Parameter 1
        push    ds si

        mov     si, offset Search_Files_Path            ; Parameter 2
        push    ds si

        jmp     @@77

@@76:
;---------
; From CLI
;---------
        mov     si, offset File_Path                    ; Parameter 1
        push    ds si

        mov     es, [Parm_Location_ptr_es]              ; Parameter 2
        mov     di, [Parm_Location_ptr_di]
        push    es di

@@77:
;----------------------
; Create SpartaDos disk
;----------------------
        mov     si, offset Disk_Format                  ; Parameter 3
        push    ds si

        mov     ax, [Parm_Density_ptr_es]               ; Parameter 4
        mov     bx, [Parm_Density_ptr_di]
        push    ax bx

        mov     ax, [Parm_ATR_Or_XFD_ptr_es]            ; Parameter 5
        mov     bx, [Parm_ATR_Or_XFD_ptr_di]
        push    ax bx

        mov     ax, [Parm_DOS_Path_ptr_es]              ; Parameter 6
        mov     bx, [Parm_DOS_Path_ptr_di]
        push    ax bx

        mov     si, offset Ws_DS_D_INCLUDE_DOS          ; Parameter 7
        push    ds si

        mov     si, offset Ws_DS_D_MAIN_DIR             ; Parameter 8
        push    ds si

        mov     ax, [Dir_Map_ptr_es]                    ; Parameter 9
        mov     bx, [Dir_Map_ptr_di]
        push    ax bx

        mov     si, offset CLI_Used                     ; Parameter 10
        push    ds si

        mov     si, offset CLI_Include_Subdirs          ; Parameter 11
        push    ds si

        call    D_SPARTA

        mov     cx, 22                                  ; Remove 11 parameters

@@78:
        pop     bx
        loop    @@78

        cmp     al, KEY_ESC                             ; Cancel pressed?
        je      @@60                                    ; Yes
                                                        ; No, so
        jmp     @@99

@@80:
        cmp     [CLI_Used], LOGIC_NO                    ; Command Line Interface used?
        je      @@85                                    ; No
                                                        ; Yes, so

        push    ds si                                   ; Save program entry
        mov     es, [Parm_Location_ptr_es]
        mov     di, [Parm_Location_ptr_di]
        push    es di

        mov     si, offset Disk_Path
        push    ds si
        pop     di es
        pop     si ds
        mov     cx, PATH_LENGTH
        rep     movsb

        pop     si ds                                   ; Restore proram entry
        jmp     @@90

@@85:
;-----------------------
; Retrieve ADDING option
;-----------------------
        call    Process_Disk_Adding
        cmp     al, KEY_ESC
        je      @@70

        mov     si, offset Disk_Path
        push    ds si
        pop     di es
        mov     si, offset Search_Files_Path
        mov     cx, PATH_LENGTH
        rep     movsb

        cmp     [Disk_Adding], "N"
        je      @@90

        mov     ax, [Disk_Seq_Nr_Present]
        mov     [Disk_Seq_Nr], ax

@@90:
;---------------------------------------------
; Get field size of Libraries/Files Table item
;---------------------------------------------
        mov     si, offset Ws_LF_F_Dir_Fil
        push    ds si
        pop     di es

        mov     ax, MAX_DIRS_AND_FILES + EXTRA_TABLE_FIELDS
        xor     bx, bx
        xor     cx, cx
        mov     cl, [byte (Wsio_Field ptr di).Size]
        xor     dx, dx
        mul     cx

;----------------------------
; Clear Libraries/Files Table
;----------------------------
        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]
        mov     cx, ax
        xor     ax, ax                          ; Reset ax
        mov     al, NULL                        ; Fill character
        rep     stosb

;-------------------------------------------
; Retrieve files to put on the disk image(s)
;-------------------------------------------
        mov     [Requested_Format_LibFil], "1"          ; See DIRENTRY.STR specification
        mov     si, offset Requested_Format_LibFil      ; Parameter 1
        push    ds si

        mov     si, offset File_Path                    ; Parameter 2
        push    ds si

        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]                    ; Parameter 3

        push    es di
 
;------------------------
; Determine Current Files
;------------------------
        call    DC_FILES

        pop     ax ax ax ax ax ax

;----------------------
; Process "Atari" Files
;----------------------
        call    Process_Atari_Files

@@99:
        ret

ENDP    Add_DirFiles_To_ATR_Image



;**********************************************************************
PROC    Process_Disk_Media_Format
;**********************************************************************
        mov     [Disk_Sector_Size], EIGHTBIT_SECTOR_SIZE_DOUBLE
        mov     [Disk_Sector_Data_Size], EIGHTBIT_SECTOR_DATA_SIZE_DOUBLE
        mov     [Vtoc_Size], EIGHTBIT_VTOC_SIZE_DOUBLE

        cmp     [CLI_Used], LOGIC_YES                   ; Command Line Interface used?
        je      @@15                                    ; Yes
                                                        ; No, so
        mov     si, offset Ws_DM
        mov     [byte ds:si], WSIO_OPEN

        push    ds si
        call    WSIO
        pop     di es

        mov     [(Wsio_Area ptr di).Cursor_Position_Row], NULL
        mov     [(WSio_Area ptr di).Cursor_Position_Col], NULL
        jmp     @@10

@@05:
;
; Too many options selected
;
        call    Display_Too_Many_Options_Selected

@@10:
        mov     si, offset Ws_DM
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ

        push    ds si
        call    WSIO
        pop     si ds

;--------------------------------
; Determine which key was pressed
;--------------------------------
        cmp     al, KEY_ESC
        je      @@98

;------------------
; ENTER was pressed
;------------------
        cmp     ah, WSIO_MOUSE_PRESSED          ; Mouse pressed Enter?
        jne     @@15                            ; No
                                                ; Yes, so
;--------------------
; Mouse pressed ENTER
;--------------------
        push    ds si
        pop     di es
        xor     cx, cx
        mov     cl, [(Wsio_Area ptr di).Cursor_Position_Row]

;
; Check if a the Key Enter field was pressed
;
        cmp     cx, 20                          ; Enter key selected?
        je      @@15                            ; Yes
                                                ; No, so
;
; Check if the ATR or XFD option was selected
;
        cmp     cx, 15                          ; ATR or XFD toggle?
        jne     @@12                            ; No
                                                ; Yes, so
;
; Toggle ATR/XFD
;
        mov     es, [Parm_ATR_Or_XFD_ptr_es]
        mov     di, [Parm_ATR_Or_XFD_ptr_di]
        cmp     [byte es:di], "A"               ; Was ATR?
        jne     @@11                            ; No
                                                ; Yes, so
        mov     [byte es:di], "X"               ; Toggle to XFD
        jmp     @@10

@@11:
        mov     [byte es:di], "A"               ; Toggle to ATR
        jmp     @@10

@@12:
;
; Check if a the ATR or XFD option was selected
;
        cmp     cx, 17                          ; Optimize disk usage?
        jne     @@14                            ; No
                                                ; Yes, so
        mov     si, offset Ws_DM_D_Optimize     ; Assume first field as selected
        cmp     [byte ds:si], SPACE             ; Was unselected?
        jne     @@13                            ; No
                                                ; Yes, so
        mov     [byte ds:si], "X"               ; Toggle to selected
        jmp     @@10

@@13:
        mov     [byte ds:si], SPACE             ; Toggle to unselected
        jmp     @@10

@@14:
;
; Select disk image with mouse
;
        mov     [Ws_DM_D_Single], SPACE
        mov     [Ws_DM_D_Medium], SPACE
        mov     [Ws_DM_D_Double], SPACE
        mov     [Ws_DM_D_Quad], SPACE
        mov     [Ws_DM_D_720KB], SPACE
        mov     [Ws_DM_D_1440KB], SPACE
        mov     [Ws_DM_D_Harddisk], SPACE

        sub     cx, 7                           ; Subtract cursor row
        mov     si, offset Ws_DM_D_Single       ; Assume first field as selected
        add     si, cx                          ; Move to selected field
        mov     [byte ds:si], "X"               ; Mark it
        jmp     @@10

@@15:
        mov     si, offset Ws_DS_F_DOS25
        push    ds si
        pop     di es
        mov     [(Wsio_Field ptr di).Modifiable], LOGIC_YES

        mov     si, offset Ws_DS_F_MYDOS
        push    ds si
        pop     di es
        mov     [(Wsio_Field ptr di).Modifiable], LOGIC_YES

        mov     si, offset Ws_DS_F_BEWEDOS
        push    ds si
        pop     di es
        mov     [(Wsio_Field ptr di).Modifiable], LOGIC_YES

        mov     si, offset Ws_DS_F_SPARTADOS
        push    ds si
        pop     di es
        mov     [(Wsio_Field ptr di).Modifiable], LOGIC_YES

        mov     si, offset Ws_DS_F_SPARTADOSX
        push    ds si
        pop     di es
        mov     [(Wsio_Field ptr di).Modifiable], LOGIC_YES

        cmp     [Ws_DM_D_Single], SPACE
        jne     @@20

        cmp     [Ws_DM_D_Medium], SPACE
        jne     @@30

        cmp     [Ws_DM_D_Double], SPACE
        jne     @@40

        cmp     [Ws_DM_D_Quad], SPACE
        jne     @@50

        cmp     [Ws_DM_D_720KB], SPACE
        jne     @@60

        cmp     [Ws_DM_D_1440KB], SPACE
        jne     @@70

        cmp     [Ws_DM_D_Harddisk], SPACE
        jne     @@80

;
; No option selected
;
        call    Display_No_Option_Selected
        jmp     @@10

@@20:
;------------------------------------------------------
; Check if Disk Medium Single is the only one specified
;------------------------------------------------------
        cmp     [Ws_DM_D_Medium], SPACE
        jne     @@05

        cmp     [Ws_DM_D_Double], SPACE
        jne     @@05

        cmp     [Ws_DM_D_Quad], SPACE
        jne     @@05

        cmp     [Ws_DM_D_720KB], SPACE
        jne     @@05

        cmp     [Ws_DM_D_1440KB], SPACE
        jne     @@05

        cmp     [Ws_DM_D_Harddisk], SPACE
        jne     @@05

        mov     [Disk_Sector_Size], EIGHTBIT_SECTOR_SIZE
        mov     [Disk_Sector_Data_Size], EIGHTBIT_SECTOR_DATA_SIZE
        mov     [Vtoc_Size], EIGHTBIT_VTOC_SIZE

        mov     [Disk_Media_Type], DISK_MEDIA_TYPE_SINGLE
        mov     [Disk_Sectors], DISK_SECTORS_SINGLE
        mov     [Disk_Sectors_Usable], DISK_SECTORS_SINGLE_USABLE
        mov     si, offset ATR_Header_Single

        jmp     @@97

@@30:
;------------------------------------------------------
; Check if Disk Medium Medium is the only one specified
;------------------------------------------------------
        cmp     [Ws_DM_D_Double], SPACE
        jne     @@05

        cmp     [Ws_DM_D_Quad], SPACE
        jne     @@05

        cmp     [Ws_DM_D_720KB], SPACE
        jne     @@05

        cmp     [Ws_DM_D_1440KB], SPACE
        jne     @@05

        cmp     [Ws_DM_D_Harddisk], SPACE
        jne     @@05

        mov     [Disk_Sector_Size], EIGHTBIT_SECTOR_SIZE
        mov     [Disk_Sector_Data_Size], EIGHTBIT_SECTOR_DATA_SIZE
        mov     [Vtoc_Size], EIGHTBIT_VTOC_SIZE

        mov     [Disk_Media_Type], DISK_MEDIA_TYPE_MEDIUM
        mov     [Disk_Sectors], DISK_SECTORS_MEDIUM
        mov     [Disk_Sectors_Usable], DISK_SECTORS_MEDIUM_USABLE
        mov     si, offset ATR_Header_Medium

        jmp     @@97

@@40:
;------------------------------------------------------
; Check if Disk Medium Double is the only one specified
;------------------------------------------------------
        cmp     [Ws_DM_D_Quad], SPACE
        jne     @@05

        cmp     [Ws_DM_D_720KB], SPACE
        jne     @@05

        cmp     [Ws_DM_D_1440KB], SPACE
        jne     @@05

        cmp     [Ws_DM_D_Harddisk], SPACE
        jne     @@05

        mov     [Disk_Media_Type], DISK_MEDIA_TYPE_DOUBLE
        mov     [Disk_Sectors], DISK_SECTORS_DOUBLE
        mov     [Disk_Sectors_Usable], DISK_SECTORS_DOUBLE_USABLE
        mov     si, offset ATR_Header_Double

        jmp     @@95

@@50:
;--------------------------------------------------------
; Check if Disk Medium Quad is the only one specified
;--------------------------------------------------------
        cmp     [Ws_DM_D_720KB], SPACE
        jne     @@05

        cmp     [Ws_DM_D_1440KB], SPACE
        jne     @@05

        cmp     [Ws_DM_D_Harddisk], SPACE
        jne     @@05

        mov     [Disk_Media_Type], DISK_MEDIA_TYPE_QUAD
        mov     [Disk_Sectors], DISK_SECTORS_QUAD
        mov     [Disk_Sectors_Usable], DISK_SECTORS_QUAD_USABLE
        mov     si, offset ATR_Header_Quad

        jmp     @@95

@@60:
;-----------------------------------------------------
; Check if Disk Medium 720KB is the only one specified
;-----------------------------------------------------
        cmp     [Ws_DM_D_1440KB], SPACE
        jne     @@05

        cmp     [Ws_DM_D_Harddisk], SPACE
        jne     @@05

        mov     [Disk_Media_Type], DISK_MEDIA_TYPE_720KB
        mov     [Disk_Sectors], DISK_SECTORS_720KB
        mov     [Disk_Sectors_Usable], DISK_SECTORS_720KB_USABLE
        mov     si, offset ATR_Header_720KB

        jmp     @@95

@@70:
;------------------------------------------------------
; Check if Disk Medium 1440KB is the only one specified
;------------------------------------------------------
        cmp     [Ws_DM_D_Harddisk], SPACE
        jne     @@05

        mov     [Disk_Media_Type], DISK_MEDIA_TYPE_1440KB
        mov     [Disk_Sectors], DISK_SECTORS_1440KB
        mov     [Disk_Sectors_Usable], DISK_SECTORS_1440KB_USABLE
        mov     si, offset ATR_Header_1440KB

        jmp     @@95

@@80:
;---------------------------------------------------------
; Check if Disk Medium Harddisk is the only one specified
;---------------------------------------------------------
        mov     [Disk_Media_Type], DISK_MEDIA_TYPE_HARDDISK
        mov     [Disk_Sectors], DISK_SECTORS_HARDDISK
        mov     [Disk_Sectors_Usable], DISK_SECTORS_HARDDISK_USABLE
        mov     si, offset ATR_Header_Harddisk

@@95:
        push    ds si

        mov     [Ws_DS_D_DOS25], SPACE
        mov     si, offset Ws_DS_F_DOS25
        push    ds si
        pop     di es
        mov     [(Wsio_Field ptr di).Modifiable], LOGIC_NO

        pop     si ds

@@97:
        push    ds si

        mov     si, offset ATR_Header
        push    ds si
        pop     di es

        pop     si ds

        mov     cx, ATR_HEADER_SIZE
        rep     movsb

@@98:
        cmp     [CLI_Used], LOGIC_YES                   ; Command Line Interface used?
        je      @@99                                    ; Yes
                                                        ; No, so
        push    ax

        mov     si, offset Ws_DM
        mov     [byte ds:si], WSIO_CLOSE

        push    ds si
        call    WSIO
        pop     si ds

        pop     ax

        mov     cl, [Disk_Media_Type]
        mov     es, [Parm_Density_ptr_es]
        mov     di, [Parm_Density_ptr_di]
        mov     [byte es:di], cl

@@99:
        ret

ENDP    Process_Disk_Media_Format



;**********************************************************************
PROC    Process_Disk_Format
;**********************************************************************
        cmp     [CLI_Used], LOGIC_YES                   ; Command Line Interface used?
        je      @@70                                    ; Yes
                                                        ; No, so
        mov     si, offset Ws_DS
        mov     [byte ds:si], WSIO_OPEN

        push    ds si
        call    WSIO
        pop     di es

        mov     [(Wsio_Area ptr di).Cursor_Position_Row], NULL
        mov     [(WSio_Area ptr di).Cursor_Position_Col], NULL

        jmp     @@10

@@05:
;
; Too many options selected
;
        call    Display_Too_Many_Options_Selected

@@10:
        mov     si, offset Ws_DS
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ

        push    ds si
        call    WSIO
        pop     si ds

;--------------------------------
; Determine which key was pressed
;--------------------------------
        cmp     al, KEY_ESC
        je      @@95

;------------------
; ENTER was pressed
;------------------
        cmp     ah, WSIO_MOUSE_PRESSED          ; Mouse pressed Enter?
        jne     @@70                            ; No
                                                ; Yes, so
;--------------------
; Mouse pressed ENTER
;--------------------
        push    ds si
        pop     di es
        xor     cx, cx
        mov     cl, [(Wsio_Area ptr di).Cursor_Position_Row]

;
; Check if the Key Enter field was pressed
;
        cmp     cx, 20                          ; Enter key selected?
        je      @@70                            ; Yes
                                                ; No, so
;
; Determine which field was selected
;
        cmp     cx, 7                           ; DOS 2.5 Field selected?
        je      @@15                            ; Yes
                                                ; No, so
        cmp     cx, 8                           ; MYDOS 4.53 Field selected?
        je      @@20                            ; Yes
                                                ; No, so
        cmp     cx, 9                           ; User's DOS (Dos) Field selected?
        je      @@25                            ; Yes
                                                ; No, so
        cmp     cx, 10                          ; BeWeDOS Field selected?
        je      @@30                            ; Yes
                                                ; No, so
        cmp     cx, 11                          ; SPARTADOS 3.3a Field selected?
        je      @@35                            ; Yes
                                                ; No, so
        cmp     cx, 12                          ; SPARTADOS/X Field selected?
        je      @@40                            ; Yes
                                                ; No, so
        cmp     cx, 13                          ; User's DOS (SpartaDos) Field selected?
        je      @@45                            ; Yes
                                                ; No, so
        cmp     cx, 15                          ; Include DOS.SYS selected?
        je      @@50                            ; Yes
                                                ; No, so
        cmp     cx, 17                          ; Include DUP.SYS selected?
        je      @@60                            ; Yes
                                                ; No, so
        cmp     cx, 18                          ; Use SpartaDos MAIN dir selected?
        je      @@67                            ; Yes
                                                ; No, so
        jmp     @@10

@@15:
;-----------------
; DOS 2.5 selected
;-----------------
        mov     si, offset Ws_DS_F_DOS25
        push    ds si
        pop     di es
        cmp     [(Wsio_Field ptr di).Modifiable], LOGIC_NO
        je      @@10                                    ; Yes
                                                        ; No, so
        call    Disk_Format_Toggle_To_Deselect

        mov     si, offset Ws_DS_D_DOS25
        mov     [byte ds:si], "X"                       ; Toggle to select
        jmp     @@10

@@20:
;--------------------
; MYDOS 4.53 selected
;--------------------
        call    Disk_Format_Toggle_To_Deselect

        mov     si, offset Ws_DS_D_MYDOS
        mov     [byte ds:si], "X"               ; Toggle to select
        jmp     @@10

@@25:
;------------------------
; User's DOS - DOS format
;------------------------
        call    Disk_Format_Toggle_To_Deselect

        mov     si, offset Ws_DS_D_MYOWNDOS_MYDOS
        mov     [byte ds:si], "X"               ; Toggle to select
        jmp     @@10

@@30:
;-----------------
; BeWeDOS selected
;-----------------
        call    Disk_Format_Toggle_To_Deselect

        mov     si, offset Ws_DS_D_BEWEDOS
        mov     [byte ds:si], "X"               ; Toggle to select
        jmp     @@10

@@35:
;------------------------
; SPARTADOS 3.3a selected
;------------------------
        call    Disk_Format_Toggle_To_Deselect

        mov     si, offset Ws_DS_D_SPARTADOS
        mov     [byte ds:si], "X"               ; Toggle to select
        jmp     @@10

@@40:
;---------------------
; SPARTADOS/X selected
;---------------------
        call    Disk_Format_Toggle_To_Deselect

        mov     si, offset Ws_DS_D_SPARTADOSX
        mov     [byte ds:si], "X"               ; Toggle to select
        jmp     @@10

@@45:
;------------------------------
; User's DOS - SPARTADOS format
;------------------------------
        call    Disk_Format_Toggle_To_Deselect

        mov     si, offset Ws_DS_D_MYOWNDOS_SPARTA
        mov     [byte ds:si], "X"               ; Toggle to select
        jmp     @@10

@@50:
;-----------------
; DOS.SYS selected
;-----------------
        mov     si, offset Ws_DS_D_INCLUDE_DOS
        cmp     [byte ds:si], SPACE             ; Was unselected?
        jne     @@55                            ; No
                                                ; Yes, so
        mov     [byte ds:si], "X"               ; Toggle to select
        jmp     @@10

@@55:
        mov     [byte ds:si], SPACE             ; Toggle to deselect
        mov     si, offset Ws_DS_D_DUPSYS
        mov     [byte ds:si], SPACE             ; Toggle to deselect
        jmp     @@10

@@60:
;-----------------
; DUP.SYS selected
;-----------------
        mov     si, offset Ws_DS_D_DUPSYS
        cmp     [byte ds:si], SPACE             ; Was unselected?
        jne     @@65                            ; No
                                                ; Yes, so
        mov     [byte ds:si], "X"               ; Toggle to select
        mov     si, offset Ws_DS_D_INCLUDE_DOS
        mov     [byte ds:si], "X"               ; Toggle to select
        jmp     @@10

@@65:
        mov     [byte ds:si], SPACE             ; Toggle to deselect
        jmp     @@10

@@67:
;--------------------------------
; Use SpartaDos MAIN Dir selected
;--------------------------------
        mov     si, offset Ws_DS_D_MAIN_DIR
        cmp     [byte ds:si], SPACE             ; Was unselected?
        jne     @@69                            ; No
                                                ; Yes, so
        mov     [byte ds:si], "X"               ; Toggle to select
        jmp     @@10

@@69:
        mov     [byte ds:si], SPACE             ; Toggle to deselect
        jmp     @@10

@@70:
;----------------
; Check selection
;----------------
        mov     [Disk_Format], "D"
        cmp     [Ws_DS_D_DOS25], SPACE
        jne     @@80

        mov     [Disk_Format], "M"
        cmp     [Ws_DS_D_MYDOS], SPACE
        jne     @@82

        mov     [Disk_Format], "O"
        cmp     [Ws_DS_D_MYOWNDOS_MYDOS], SPACE
        jne     @@84

        mov     [Disk_Format], "B"
        cmp     [Ws_DS_D_BEWEDOS], SPACE
        jne     @@86

        mov     [Disk_Format], "S"
        cmp     [Ws_DS_D_SPARTADOS], SPACE
        jne     @@88

        mov     [Disk_Format], "X"
        cmp     [Ws_DS_D_SPARTADOSX], SPACE
        jne     @@90

        mov     [Disk_Format], "Y"
        cmp     [Ws_DS_D_MYOWNDOS_SPARTA], SPACE
        jne     @@95

;
; No option selected
;
        call    Display_No_Option_Selected
        jmp     @@10

@@80:
;---------------------------------------------------
; Check if selected format is the only one specified
;---------------------------------------------------
        cmp     [Ws_DS_D_MYDOS], SPACE
        jne     @@05

@@82:
        cmp     [Ws_DS_D_MYOWNDOS_MYDOS], SPACE
        jne     @@05

@@84:
        cmp     [Ws_DS_D_BEWEDOS], SPACE
        jne     @@05

@@86:
        cmp     [Ws_DS_D_SPARTADOS], SPACE
        jne     @@05

@@88:
        cmp     [Ws_DS_D_SPARTADOSX], SPACE
        jne     @@05

@@90:
        cmp     [Ws_DS_D_MYOWNDOS_SPARTA], SPACE
        jne     @@05

@@95:
;-------------------------
; Close Disk format screen
;-------------------------
        cmp     [CLI_Used], LOGIC_YES                   ; Command Line Interface used?
        je      @@99                                    ; Yes
                                                        ; No, so
;
; Save pressed Wsio key
;
        push    ax

        mov     si, offset Ws_DS
        mov     [byte ds:si], WSIO_CLOSE

        push    ds si
        call    WSIO
        pop     si ds

;
; Restore pressed Wsio key
;
        pop     ax

@@99:
        ret

ENDP    Process_Disk_Format



;**********************************************************************
PROC    Disk_Format_Toggle_To_Deselect
;**********************************************************************
        mov     si, offset Ws_DS_D_DOS25
        mov     [byte ds:si], SPACE
        mov     si, offset Ws_DS_D_MYDOS
        mov     [byte ds:si], SPACE
        mov     si, offset Ws_DS_D_MYOWNDOS_MYDOS
        mov     [byte ds:si], SPACE
        mov     si, offset Ws_DS_D_BEWEDOS
        mov     [byte ds:si], SPACE
        mov     si, offset Ws_DS_D_SPARTADOS
        mov     [byte ds:si], SPACE
        mov     si, offset Ws_DS_D_SPARTADOSX
        mov     [byte ds:si], SPACE
        mov     si, offset Ws_DS_D_MYOWNDOS_SPARTA
        mov     [byte ds:si], SPACE

        ret

ENDP    Disk_Format_Toggle_To_Deselect



;**********************************************************************
PROC    Process_Disk_Adding
;**********************************************************************
        mov     [Disk_Seq_Nr], 0
        mov     [Disk_Seq_Nr_Present], 0

;-------------------------------------------------
; Are there already disk images in this directory?
;-------------------------------------------------
        mov     [Disk_Adding], "N"              ; Add disks from beginning
        mov     [Ws_AD_D_Add_Where], "B"        ; Assume add from begin

        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]            ; Dir Map
        mov     cx, 999                         ; Maximum nr of disks

@@10:
        cmp     [byte es:di], NULL              ; End of table reached?
        je      @@99                            ; Yes
                                                ; No, so
        cmp     [byte es:di + 13], "<"          ; Subdirectory?
        jne     @@20                            ; No
                                                ; Yes, so
        add     di, DIR_ENTRY_LENGTH
        jmp     @@10

@@20:
        cmp     [byte es:di], NULL              ; More files?
        je      @@40                            ; No
                                                ; Yes, so
;
; Check for valid disk name
;
        cmp     [byte es:di], "0"
        jl      @@30
        cmp     [byte es:di], "9"
        jnle    @@30
        cmp     [byte es:di + 1], "0"
        jl      @@30
        cmp     [byte es:di + 1], "9"
        jnle    @@30
        cmp     [byte es:di + 2], "0"
        jl      @@30
        cmp     [byte es:di + 2], "9"
        jnle    @@30
        cmp     [byte es:di + 3], DOT
        jne     @@30

        xor     ax, ax
        xor     bx, bx
        xor     dx, dx
        mov     bl, [byte es:di + 2]
        sub     bl, ZERO
        mov     al, [byte es:di + 1]
        sub     al, ZERO
        mov     cx, 10
        mul     cx
        add     bx, ax
        xor     ax, ax
        mov     al, [byte es:di]
        sub     al, ZERO
        mov     cx, 100
        mul     cx
        add     bx, ax
        cmp     bx, [Disk_Seq_Nr_Present]
        jle     @@30
        
        mov     [Disk_Seq_Nr_Present], bx

@@30:
        add     di, DIR_ENTRY_LENGTH
        loop    @@20

@@40:
        cmp     [Disk_Seq_Nr_Present], 0        ; Already disk nrs present?
        je      @@99                            ; No
                                                ; Yes, so
        mov     [Ws_AD_D_Add_Where], "E"        ; Assume add at end

;-----------------------
; Add disknumber to end?
;-----------------------
        mov     si, offset Ws_AD
        mov     [byte ds:si], WSIO_OPEN

        push    ds si
        call    WSIO
        pop     di es

        mov     [(Wsio_Area ptr di).Cursor_Position_Row], NULL
        mov     [(WSio_Area ptr di).Cursor_Position_Col], NULL

@@50:
        mov     si, offset Ws_AD
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ

        push    ds si
        call    WSIO
        pop     si ds

;--------------------
; Was Cancel pressed?
;--------------------
        cmp     al, KEY_ESC
        je      @@80

;------------------
; ENTER was pressed
;------------------
        cmp     ah, WSIO_MOUSE_PRESSED          ; Mouse pressed Enter?
        jne     @@70                            ; No
                                                ; Yes, so
;--------------------
; Mouse pressed ENTER
;--------------------
        push    ds si
        pop     di es
        xor     cx, cx
        mov     cl, [(Wsio_Area ptr di).Cursor_Position_Row]

;
; Check if a the Key Enter field was pressed
;
        cmp     cx, 15                          ; Enter key selected?
        je      @@70                            ; Yes
                                                ; No, so
;
; At End/From Begin field was selected
;
        cmp     [Ws_AD_D_Add_Where], "E"        ; Was it "add at end"?
        jne     @@60                            ; No
                                                ; Yes, so
        mov     [Ws_AD_D_Add_Where], "B"
        jmp     @@50

@@60:
        mov     [Ws_AD_D_Add_Where], "E"
        jmp     @@50

@@70:
;-----------------------------------
; Should we start adding at the end?
;-----------------------------------
        cmp     [Ws_AD_D_Add_Where], "E"        ; Add disks at end?
        jne     @@80                            ; No
                                                ; Yes, so
        mov     [Disk_Adding], "Y"              ; Add disks at end

@@80:
        push    ax

        mov     si, offset Ws_AD
        mov     [byte ds:si], WSIO_CLOSE

        push    ds si
        call    WSIO
        pop     si ds

        pop     ax

@@99:
        ret

ENDP    Process_Disk_Adding



;**********************************************************************
PROC    Display_No_Option_Selected
;**********************************************************************
        mov     si, offset Ws_E3
        mov     [byte ds:si], WSIO_OPEN
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_E3
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_E3
        mov     [byte ds:si], WSIO_CLOSE
        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_No_Option_Selected



;**********************************************************************
PROC    Display_Too_Many_Options_Selected
;**********************************************************************
        mov     si, offset Ws_E4
        mov     [byte ds:si], WSIO_OPEN
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_E4
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_E4
        mov     [byte ds:si], WSIO_CLOSE
        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Too_Many_Options_Selected



;**********************************************************************
PROC    Process_Atari_Files
;**********************************************************************
        cmp     [CLI_Used], LOGIC_YES                   ; Command Line Interface used?
        je      @@05                                    ; Yes
                                                        ; No, so
        mov     si, offset Ws_CF
        mov     [byte ds:si], WSIO_OPEN

        push    ds si
        call    WSIO
        pop     si ds

@@05:
;------------------------------
; Set up progress bar variables
;------------------------------
        call    Set_Up_Progress_Bar

;---------------------------
; Initialize disk image name
;---------------------------
        mov     si, offset Ws_CF_D_Add_Disk
        push    ds si
        pop     di es
        mov     cx, FILE_NAME_LENGTH
        xor     ax, ax
        mov     al, SPACE
        rep     stosb

;---------------
; Message "None"
;---------------
        mov     si, offset Ws_CF_F_Add_File
        push    ds si
        pop     di es

        mov     si, offset Ws_CF_D_No_Message
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        cmp     [CLI_Used], LOGIC_YES                   ; Command Line Interface used?
        je      @@06                                    ; Yes
                                                        ; No, so
;----------------------------
; Display progress bar screen
;----------------------------
        mov     si, offset Ws_CF
        mov     [byte ds:si], WSIO_DISPLAY_ONLY

        push    ds si
        call    WSIO
        pop     si ds

@@06:
;------------------------------
; Process found directory files
;------------------------------
        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]

        cmp     [byte es:di], NULL              ; Anything to process at all?
        je      @@98                            ; No
                                                ; Yes, so
        push    es di

        call    Process_Open_ATR_Image_Disk

        pop     di es

        cmp     [Dir2atr_Error], LOGIC_YES              ; Error encountered?
        je      @@98                                    ; Yes
                                                        ; No, so
@@10:
;-------------------------------------------------------
; Process a file using (or without) optimized disk usage
;-------------------------------------------------------
        cmp     [Ws_DM_D_Optimize], SPACE               ; Optimize disk usage?
        je      @@13                                    ; No
                                                        ; Yes, so
        mov     cx, [Dir_Entry_Files]                   ; Nr of files in directory
        cmp     cx, [Dir_Entry_Files_Processed]         ; All files processed?
        je      @@90                                    ; Yes
                                                        ; No, so
        call    Optimize_Disk_Usage
        cmp     [Dir_Entry_File_Size], 0                ; Something left to process?
        jne     @@12                                    ; Yes
                                                        ; No, so
        call    Process_Write_8bit_Bitmap_And_VTOC

        cmp     [Dir2atr_Error], LOGIC_YES              ; Error encountered?
        je      @@98                                    ; Yes
                                                        ; No, so
        call    Process_Close_ATR_Image_Disk
        call    Process_Open_ATR_Image_Disk

        cmp     [Dir2atr_Error], LOGIC_YES              ; Error encountered?
        je      @@98                                    ; Yes
                                                        ; No, so
        jmp     @@10

@@12:
        mov     es, [Dir_Entry_ptr_es]                  ; Pointer to file to process
        mov     di, [Dir_Entry_ptr_di]
        jmp     @@14

@@13:
        cmp     [byte es:di], NULL                      ; Something left to process?
        je      @@90                                    ; No
                                                        ; Yes, so
@@14:
        push    es di                                   ; Save Dir_Map pointer

        call    Check_If_File_Fits_On_Image

        cmp     [Dir_Entry_Fits_On_Image], LOGIC_YES    ; Does file fit?
        jne     @@80                                    ; No
                                                        ; Yes, so
;
; File Size in sectors > remaining nr of sectors left?
;
        mov     cx, [Disk_Sectors_Left]
        clc                                             ; Clear carry
        sub     cx, [File_Size_In_Sectors]
        jc      @@20

;
; Nr of files processed > nr of files in 8bit vtoc?
;
        cmp     [byte Atari_Files_Processed], EIGHTBIT_VTOC_FILES
        jl      @@30

@@20:
        call    Process_Write_8bit_Bitmap_And_VTOC

        cmp     [Dir2atr_Error], LOGIC_YES      ; Error encountered?
        je      @@98                            ; Yes
                                                ; No, so
        call    Process_Close_ATR_Image_Disk
        call    Process_Open_ATR_Image_Disk

        cmp     [Dir2atr_Error], LOGIC_YES      ; Error encountered?
        je      @@98                            ; Yes
                                                ; No, so
@@30:
;
; Determine Filename path
;
        mov     si, offset PC_ATARI_Pathname
        push    ds si
        pop     di es
        mov     si, offset File_Path
        mov     cx, PATH_LENGTH             ; Copy length
        rep     movsb                       ; Copy path to search path

        call    Setup_PC_ATARI_Pathname

;-------------------
; Process 8 bit File
;-------------------
        call    Process_Open_8bit_File

        cmp     [Dir2atr_Error], LOGIC_YES      ; Error encountered?
        je      @@98                            ; Yes
                                                ; No, so
        call    Process_Move_File_To_Image

        cmp     [Dir2atr_Error], LOGIC_YES      ; Error encountered?
        jne     @@40                            ; No
                                                ; Yes, so
        call    Process_Close_8bit_File
        pop     di es
        jmp     @@98

@@40:
        call    Process_Close_8bit_File
        call    Process_Update_8bit_VTOC

@@80:
;
; Go to next entry
;
        inc     [Dir_Entry_Files_Processed]
        pop     di es
        mov     [byte es:di], NULL              ; Indicate file processed
        add     di, FILE_ENTRY_LENGTH

        jmp     @@10

@@90:
        pop     ax ax

;------------------------------------
; Make sure the complete bar is drawn
;------------------------------------
        xor     bx, bx
        mov     ax, [Sectors_Per_Progress_Bar]
        xor     dx, dx
        xor     cx, cx
        mov     cl, [Ws_CF_Progress_Bar_Cnt_Max]
        mul     cx                                      ; multiply bx:ax by dx:cx

        mov     [Ws_CF_Progress_Bar_Cnt_Sectors_Hi], bx
        mov     [Ws_CF_Progress_Bar_Cnt_Sectors_Lo], ax

        call    Show_Progress_Bar

;-----------------------
; Update bitmap and VTOC
;-----------------------
        call    Process_Write_8bit_Bitmap_And_VTOC

@@95:
        call    Process_Close_ATR_Image_Disk

@@98:
        cmp     [CLI_Used], LOGIC_YES                   ; Command Line Interface used?
        je      @@99                                    ; Yes
                                                        ; No, so
        mov     si, offset Ws_CF
        mov     [byte ds:si], WSIO_CLOSE

        push    ds si
        call    WSIO
        pop     si ds

@@99:
        ret

ENDP    Process_Atari_Files



;**********************************************************************
PROC    Set_Up_Progress_Bar
;**********************************************************************
;------------------------
; Initialize progress bar
;------------------------
        mov     si, offset Ws_CF_D_Progress_Bar
        push    ds si
        pop     di es
        xor     ax, ax
        mov     al, 0B0h
        xor     cx, cx
        mov     cl, [Ws_CF_Progress_Bar_Cnt_Max]
        rep     stosb

        mov     [Ws_CF_Progress_Bar_Cnt_Prev], 0
        mov     [Ws_CF_Progress_Bar_Cnt_Sectors_Hi], 0
        mov     [Ws_CF_Progress_Bar_Cnt_Sectors_Lo], 0

;----------------------------------------------------------
; Save maximum file size which will fit on this disk medium
;----------------------------------------------------------
        mov     ax, [Disk_Sectors_Usable]
        mov     [Max_File_Size_In_Sectors], ax

        cmp     [Ws_DS_D_INCLUDE_DOS], SPACE            ; Include DOS files?
        je      @@60                                    ; No
                                                        ; Yes, so
;-----------------------------
; Open Atari 8bit DOS.SYS file
;-----------------------------
        call    Setup_Pathname_ATARI_DOS_SYS_File
        call    Process_Open_8bit_File
        cmp     [Dir2atr_Error], LOGIC_YES              ; Error encountered?
        je      @@60                                    ; Yes
                                                        ; No, so
;-----------------------------
; Determine File Size in bytes
;-----------------------------
        call    Determine_Pc_File_Size_In_Bytes

;--------------------------------------------------------
; Determine File Size in sectors (and remainder of bytes)
;--------------------------------------------------------
        mov     dx, [File_Size_In_Bytes_Hi]
        mov     ax, [File_Size_In_Bytes_Lo]
        xor     cx, cx
        mov     bx, [Disk_Sector_Data_Size]
        mov     [Remainder_Bytes], bl
        div     bx
        cmp     dx, NULL                                ; Remainder?
        jz      @@20                                    ; No
                                                        ; Yes, so
        inc     ax                                      ; We need another sector
        mov     [Remainder_Bytes], dl                   ; Save remainder

@@20:
        sub     [Max_File_Size_In_Sectors], ax

        call    Process_Close_8bit_File

;--------------------
; Write DUP.SYS file?
;--------------------
        cmp     [Ws_DS_D_DUPSYS], SPACE                 ; Include DUP.SYS file?
        je      @@60                                    ; No
                                                        ; Yes, so
;-----------------------------
; Open Atari 8bit DUP.SYS file
;-----------------------------
        call    Setup_Pathname_ATARI_DUP_SYS_File
        call    Process_Open_8bit_File
        cmp     [Dir2atr_Error], LOGIC_YES              ; Error encountered?
        je      @@60                                    ; Yes
                                                        ; No, so
;-----------------------------
; Determine File Size in bytes
;-----------------------------
        call    Determine_Pc_File_Size_In_Bytes

;--------------------------------------------------------
; Determine File Size in sectors (and remainder of bytes)
;--------------------------------------------------------
        mov     dx, [File_Size_In_Bytes_Hi]
        mov     ax, [File_Size_In_Bytes_Lo]
        xor     cx, cx
        mov     bx, [Disk_Sector_Data_Size]
        mov     [Remainder_Bytes], bl
        div     bx
        cmp     dx, NULL                                ; Remainder?
        jz      @@40                                    ; No
                                                        ; Yes, so
        inc     ax                                      ; We need another sector
        mov     [Remainder_Bytes], dl                   ; Save remainder

@@40:
        sub     [Max_File_Size_In_Sectors], ax

        call    Process_Close_8bit_File

@@60:
;
; Determine number of files in this directory to process
;
        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]

        mov     [Ws_CF_Progress_Bar_Sectors_Hi], 0
        mov     [Ws_CF_Progress_Bar_Sectors_Lo], 0
        mov     [Dir_Entry_Files], 0
        mov     [Dir_Entry_Files_Processed], 0

@@70:
        cmp     [byte es:di], NULL                      ; More files?
        je      @@90                                    ; No
                                                        ; Yes, so
        push    es di                                   ; Save Dir_Map pointer

        call    Check_If_File_Fits_On_Image

        pop     di es                                   ; Restore Dir_Map pointer

        cmp     [Dir_Entry_Fits_On_Image], LOGIC_YES    ; Does file fit?
        jne     @@80                                    ; No
                                                        ; Yes, so
        mov     ax, [File_Size_In_Sectors]
        clc                                             ; Clear carry
        add     [Ws_CF_Progress_Bar_Sectors_Lo], ax
        jnc     @@80
        inc     [Ws_CF_Progress_Bar_Sectors_Hi]

@@80:
        inc     [Dir_Entry_Files]

        add     di, FILE_ENTRY_LENGTH

        jmp     @@70

@@90:
        call    Determine_Sectors_Per_Progress_Bar

@@99:
        ret

ENDP    Set_Up_Progress_Bar



;**********************************************************************
PROC    Determine_Sectors_Per_Progress_Bar
;**********************************************************************
        mov     dx, [Ws_CF_Progress_Bar_Sectors_Hi]
        mov     ax, [Ws_CF_Progress_Bar_Sectors_Lo]
        xor     cx, cx
        xor     bx, bx
        mov     bl, [Ws_CF_Progress_Bar_Cnt_Max]
        div     bx                                      ; ax contains nr of sectors per bar
        cmp     dx, NULL                                ; Remainder?
        je      @@10                                    ; No
                                                        ; Yes, si
        inc     ax

@@10:
        mov     [Sectors_Per_Progress_Bar], ax

@@99:
        ret

ENDP    Determine_Sectors_Per_Progress_Bar



;**********************************************************************
PROC    Optimize_Disk_Usage
;**********************************************************************
        mov     es, [Dir_Map_ptr_es]                    ; Check files in directory
        mov     di, [Dir_Map_ptr_di]
        mov     cx, [Dir_Entry_Files]                   ; Nr of files in directory
        mov     [Dir_Entry_File_Size], 0                ; Size of file which fits on disk
        mov     [Dir_Entry_ptr_es], NULL                ; Pointer to file to process
        mov     [Dir_Entry_ptr_di], NULL

@@10:
        push    cx                                      ; Save file count
        push    es di                                   ; Save Dir_Map pointer

        cmp     [byte es:di], NULL                      ; File already processed?
        je      @@90                                    ; Yes
                                                        ; No, so
        call    Check_If_File_Fits_On_Image

        cmp     [Dir_Entry_Fits_On_Image], LOGIC_YES    ; Does file fit?
        jne     @@80                                    ; No
                                                        ; Yes, so
;
; File Size in sectors > remaining nr of sectors left?
;
        mov     cx, [Disk_Sectors_Left]
        clc                                             ; Clear carry
        sub     cx, [File_Size_In_Sectors]
        jc      @@90

;
; File Size in sectors > file already selected to be processed?
;
        cmp     [Dir_Entry_ptr_es], NULL                ; Already a file selected?
        je      @@20                                    ; No
                                                        ; Yes, so
        mov     cx, [Dir_Entry_File_Size]
        clc                                             ; Clear carry
        sub     cx, [File_Size_In_Sectors]
        jnc     @@90

@@20:
        mov     ax, [File_Size_In_Sectors]
        mov     [Dir_Entry_File_Size], ax               ; Save file size
        pop     di es
        mov     [Dir_Entry_ptr_es], es                  ; Save entry
        mov     [Dir_Entry_ptr_di], di
        push    es di
        jmp     @@90
    
@@80:
;
; Calculate progress bar size, and show it if necessary
;
        inc     [Dir_Entry_Files_Processed]
        pop     di es
        pop     cx
        mov     [byte es:di], NULL              ; Indicate file processed
        add     di, FILE_ENTRY_LENGTH
        loop    @@10                            ; Check next file
        jmp     @@95                            ; When no files left

@@90:
;
; Go to next entry
;
        pop     di es
        pop     cx
        add     di, FILE_ENTRY_LENGTH
        loop    @@10                            ; Check next file

@@95:
        ret

ENDP    Optimize_Disk_Usage



;**********************************************************************
PROC    Check_If_File_Fits_On_Image
;**********************************************************************
        mov     [Dir_Entry_Fits_On_Image], LOGIC_NO

        push    ds si                                   ; Save Data pointer

        call    Copy_Entry_From_Dir_Map_To_File_Map

        pop     si ds                                   ; Restore Data pointer

;
; Determine File Size in Sectors
;
        call    Determine_File_Size_In_Sectors

        mov     ax, [File_Size_In_Sectors]
        cmp     ax, HIGH_VALUES                         ; File too large?
        je      @@99                                    ; Yes
                                                        ; No, so
;
; Does file fit on the selected disk medium?
;
        mov     cx, [Max_File_Size_In_Sectors]
        clc                                             ; Clear carry
        sub     cx, ax
        jc      @@99

        mov     [Dir_Entry_Fits_On_Image], LOGIC_YES

@@99:
        ret

ENDP    Check_If_File_Fits_On_Image



;**********************************************************************
PROC    Copy_Entry_From_Dir_Map_To_File_Map
;**********************************************************************
        push    es di                                   ; Save entry position

        mov     si, offset File_Map_Entry
        push    ds si
        pop     di es

        pop     si ds                                   ; Restore entry position

        mov     cx, FILE_ENTRY_LENGTH
        rep     movsb

        ret

ENDP    Copy_Entry_From_Dir_Map_To_File_Map



;**********************************************************************
PROC    Show_Progress_Bar
;**********************************************************************
        mov     dx, [Ws_CF_Progress_Bar_Cnt_Sectors_Hi]
        mov     ax, [Ws_CF_Progress_Bar_Cnt_Sectors_Lo]
        xor     cx, cx
        mov     bx, [Sectors_Per_Progress_Bar]
        div     bx                                      ; Divide dx:ax by cx:bx (Nr of bars we've had)

        cmp     al, [Ws_CF_Progress_Bar_Cnt_Prev]
        je      @@99

@@20:
;---------------------------------
; Update progress bar, and show it
;---------------------------------
        mov     [Ws_CF_Progress_Bar_Cnt_Prev], al
        xor     cx, cx
        mov     cl, al

        mov     si, offset Ws_CF_D_Progress_Bar
        push    ds si
        pop     di es
        xor     ax, ax
        mov     al, 0DBh
        rep     stosb

        cmp     [CLI_Used], LOGIC_YES                   ; Command Line Interface used?
        je      @@99                                    ; Yes
                                                        ; No, so
        mov     si, offset Ws_CF
        mov     [byte ds:si], WSIO_DISPLAY_FIELDS_ONLY
        push    ds si
        call    WSIO
        pop     si ds

@@99:
        ret

ENDP    Show_Progress_Bar



;**********************************************************************
PROC    Process_Open_ATR_Image_Disk
;**********************************************************************
        mov     ax, [Disk_Sectors_Usable]
        mov     [Disk_Sectors_Available], ax
        mov     [Disk_Sectors_Left], ax

        mov     [Atari_Files_Processed], 0
        mov     [Disk_Sector_Current], DISK_SECTOR_BEG
        mov     [ATR_Disk_Image_Open], FALSE
        inc     [Disk_Seq_Nr]

;
; Determine Diskname
;
        mov     si, offset Disk_Name
        push    ds si
        pop     di es
        add     di, 2
        mov     ax, [Disk_Seq_Nr]
        mov     bx, 10                      ; Extract digits

; Convert hexadecimal size to textual digits
        call    Extract_Digit               ; Convert value below 10000
        call    Extract_Digit
        call    Extract_Digit

;
; Show which disk we are working on
;
        mov     si, offset Ws_CF_D_Add_Disk
        push    ds si
        pop     di es
        mov     si, offset Disk_Name
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

;
; Determine path of disk image file
;
        mov     si, offset ATARI____Pathname
        push    ds si
        pop     di es
        mov     si, offset Disk_Path
        mov     cx, PATH_LENGTH                         ; Copy length
        rep     movsb                                   ; Copy path to search path

        cmp     [CLI_Used], LOGIC_YES                   ; Command Line Interface used?
        je      @@02                                    ; Yes
                                                        ; No, so
        call    Setup_ATARI____Pathname

@@02:
;
; Create ATR Disk Image
;
        mov     si, offset ATARI____File
        push    ds si
        pop     di es
        mov     [(FMS_Area ptr di).Request], CMD_OPEN_OUTPUT

        push    es di
        call    FMSIO
        pop     di es

        cmp     [(FMS_Area ptr di).Status], STATUS_OK
        jne     @@90                            ; Error!

        mov     [(FMS_Area ptr di).Request], CMD_ACCESS_WRITENEXT

;
; Reset I/O buffer
;
        mov     si, offset Disk_I_O_Buffer
        push    ds si
        pop     di es
        xor     ax, ax
        mov     cx, [Disk_Sector_Size]
        rep     stosb

;
; Reset VTOC bitmap - Assume DOS 2.5
;
        mov     si, offset VTOC_I_O_Bitmap
        push    ds si
        pop     di es
        mov     si, offset Bitmap_DOS25
        mov     cx, EIGHTBIT_SECTOR_SIZE
        rep     movsb

;
; Reset VTOC bitmap extended - Assume DOS 2.5
;
        mov     si, offset VTOC_I_O_Bitmap_Extend
        push    ds si
        pop     di es
        mov     si, offset Bitmap_Extended_DOS25
        mov     cx, EIGHTBIT_SECTOR_SIZE
        rep     movsb

;
; Assume extended bitmap sector DOS 2.5
;
        mov     [Disk_Sector_Bitmap_Ext], EIGHTBIT_SECTOR_BITMAP_EXTENDED_DOS25
        mov     [Last_Sector_In_Bitmap], LAST_SECTOR_IN_BITMAP_DOS25

        cmp     [Disk_Format], DOS25_FORMAT
        je      @@05

;
; Reset VTOC bitmap - MYDOS
;
        mov     si, offset VTOC_I_O_Bitmap
        push    ds si
        pop     di es
        mov     si, offset Bitmap_MYDOS
        mov     cx, EIGHTBIT_SECTOR_SIZE
        rep     movsb

;
; Reset VTOC bitmap extended - MYDOS
;
        mov     si, offset VTOC_I_O_Bitmap_Extend
        push    ds si
        pop     di es
        mov     si, offset Bitmap_Extended_MYDOS
        mov     cx, EIGHTBIT_SECTOR_SIZE
        rep     movsb

;
; Extended bitmap sector MYDOS
;
        mov     [Disk_Sector_Bitmap_Ext], EIGHTBIT_SECTOR_BITMAP_EXTENDED_MYDOS
        mov     [Last_Sector_In_Bitmap], LAST_SECTOR_IN_BITMAP_MYDOS

@@05:
;
; Message "Formatting Disk, please wait"
;
        mov     si, offset Ws_CF_F_Add_File
        push    ds si
        pop     di es

        mov     si, offset Ws_CF_D_Formatting_Disk
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        cmp     [CLI_Used], LOGIC_YES                   ; Command Line Interface used?
        je      @@06                                    ; Yes
                                                        ; No, so
;
; Display progress screen
;
        mov     si, offset Ws_CF
        mov     [byte ds:si], WSIO_DISPLAY_FIELDS_ONLY

        push    ds si
        call    WSIO
        pop     si ds

@@06:
;
; Initialize formatting progress bar
;
        mov     si, offset Ws_FF_D_Progress_Bar
        push    ds si
        pop     di es
        xor     ax, ax
        mov     al, 0B0h
        xor     cx, cx
        mov     cl, [Ws_FF_Progress_Bar_Cnt_Max]
        rep     stosb

        mov     [Ws_FF_Progress_Bar_Cnt_Prev], 0
        mov     [Ws_FF_Progress_Bar_Cnt_Sectors], 0

;
; "Format" ATR Disk Image
;
        mov     es, [Parm_ATR_Or_XFD_ptr_es]
        mov     di, [Parm_ATR_Or_XFD_ptr_di]
        mov     al, [byte es:di]

        mov     si, offset ATARI____File
        push    ds si
        pop     di es

        mov     [(FMS_Area ptr di).Offset], DISK_BOOTCODE_SIZE

        cmp     al, "X"                         ; XFD format?
        je      @@10                            ; Yes
                                                ; No, so
;
; Header information
;
        add     [(FMS_Area ptr di).Offset], ATR_HEADER_SIZE

        mov     si, offset ATR_Header
        mov     [(FMS_Area ptr di).Data_Address_Hi], ds
        mov     [(FMS_Area ptr di).Data_Address_Lo], si
        mov     [(FMS_Area ptr di).Record_Size], ATR_HEADER_SIZE

        push    es di
        call    FMSIO
        pop     di es

        cmp     [(FMS_Area ptr di).Status], STATUS_OK
        jne     @@91                            ; Error!

@@10:
;
; Bootcode sectors
;
        mov     [(FMS_Area ptr di).Record_Size], DISK_BOOTCODE_SIZE
        mov     si, offset Bootcode_Data
        mov     [(FMS_Area ptr di).Data_Address_Hi], ds
        mov     [(FMS_Area ptr di).Data_Address_Lo], si

;
; Init bootcode sectors
;
        mov     si, offset Bootcode_Data
        push    ds si
        pop     di es
        xor     ax, ax
        mov     cx, DISK_BOOTCODE_SIZE
        rep     stosb

;
; Read bootcode from disk, if neccessary
;
        mov     si, offset PC_ATARI_File
        push    ds si
        pop     di es

        mov     [(FMS_Area ptr di).Record_Size], DISK_BOOTCODE_SIZE
        mov     si, offset Bootcode_Data
        mov     [(FMS_Area ptr di).Data_Address_Hi], ds
        mov     [(FMS_Area ptr di).Data_Address_Lo], si
        mov     [(FMS_Area ptr di).Request], CMD_OPEN_INPUT

;------------------------
; Bootcode from disk file
;------------------------
        call    Setup_Pathname_ATARI_Bootcode_File

;------------------------
; Open 8bit bootcode file
;------------------------
        mov     si, offset PC_ATARI_File
        push    ds si
        call    FMSIO
        pop     di es

        mov     [(FMS_Area ptr di).Request], CMD_ACCESS_READNEXT

        cmp     [(FMS_Area ptr di).Status], STATUS_OK
        je      @@25                            ; Yes
                                                ; No, so
;
; If no DOS files are to be included, we write empty bootsectors,
; else, the bootcode file must be present!
;     
        cmp     [Ws_DS_D_INCLUDE_DOS], SPACE
        je      @@30                            ; No
                                                ; Yes, so
        call    Process_Open_8bit_File          ; Show Bootcode File not found error
        jmp     @@95                            ; Show error

@@25:
;
; Read 8bit bootcode file
;
        push    es di
        call    FMSIO
        pop     di es

;
; Close 8bit bootcode file
;
        mov     [(FMS_Area ptr di).Request], CMD_OPEN_CLOSE

        push    es di
        call    FMSIO
        pop     di es

        cmp     [(FMS_Area ptr di).Status], STATUS_OK
        jne     @@95                            ; File read
                                                ; Yes, so
@@30:
        mov     si, offset ATARI____File
        push    ds si
        call    FMSIO
        pop     di es

        cmp     [(FMS_Area ptr di).Status], STATUS_OK
        jne     @@93                            ; Error!

@@40:
        cmp     [CLI_Used], LOGIC_YES                   ; Command Line Interface used?
        je      @@45                                    ; Yes
                                                        ; No, so
        push    es di

;
; Display format screen
;
        mov     si, offset Ws_FF
        mov     [byte ds:si], WSIO_OPEN

        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_FF
        mov     [byte ds:si], WSIO_DISPLAY_ONLY

        push    ds si
        call    WSIO
        pop     si ds

        pop     di es

@@45:
;
; Number of sectors to format after bootcode
;
        mov     cx, [Disk_Sector_Size]
        mov     [(FMS_Area ptr di).Record_Size], cx

        mov     si, offset Disk_I_O_Buffer
        mov     [(FMS_Area ptr di).Data_Address_Hi], ds
        mov     [(FMS_Area ptr di).Data_Address_Lo], si

        mov     cx, [Disk_Sectors]
        sub     cx, DISK_BOOTCODE_SECTOR_SIZE
        mov     [Ws_FF_Progress_Bar_Sectors], cx

@@50:
        push    cx

;------------------------------------------------------
; Calculate progress bar size, and show it if necessary
;------------------------------------------------------
        mov     ax, [Ws_FF_Progress_Bar_Cnt_Sectors]
        xor     bx, bx
        xor     cx, cx
        mov     cl, [Ws_FF_Progress_Bar_Cnt_Max]
        xor     dx, dx
        mul     cx

        xor     cx, cx
        mov     bx, [Ws_FF_Progress_Bar_Sectors]
        div     bx

        cmp     al, [Ws_FF_Progress_Bar_Cnt_Prev]
        je      @@60

;---------------------------------
; Update progress bar, and show it
;---------------------------------
        mov     [Ws_FF_Progress_Bar_Cnt_Prev], al
        mov     cx, ax

        mov     si, offset Ws_FF_D_Progress_Bar
        push    ds si
        pop     di es
        xor     ax, ax
        mov     al, 0DBh
        rep     stosb

        cmp     [CLI_Used], LOGIC_YES                   ; Command Line Interface used?
        je      @@60                                    ; Yes
                                                        ; No, so
        mov     si, offset Ws_FF
        mov     [byte ds:si], WSIO_DISPLAY_FIELDS_ONLY
        push    ds si
        call    WSIO
        pop     si ds

@@60:
        pop     cx
        push    cx

        mov     si, offset ATARI____File
        push    ds si
        call    FMSIO
        pop     di es

        cmp     [(FMS_Area ptr di).Status], STATUS_OK
        je      @@70                                    ; Yes
                                                        ; No, so
        cmp     [CLI_Used], LOGIC_YES                   ; Command Line Interface used?
        je      @@93                                    ; Yes
                                                        ; No, so
        mov     si, offset Ws_FF
        mov     [byte ds:si], WSIO_CLOSE

        push    ds si
        call    WSIO
        pop     si ds

        jmp     @@93

@@70:
        inc     [Ws_FF_Progress_Bar_Cnt_Sectors]

        pop     cx
        loop    @@50

        cmp     [CLI_Used], LOGIC_YES                   ; Command Line Interface used?
        je      @@80                                    ; Yes
                                                        ; No, so
        push    es di

        mov     si, offset Ws_FF
        mov     [byte ds:si], WSIO_CLOSE

        push    ds si
        call    WSIO
        pop     si ds

        pop     di es

@@80:
;
; Close ATR Disk Image
;
        mov     [(FMS_Area ptr di).Request], CMD_OPEN_CLOSE
        push    es di
        call    FMSIO
        pop     di es

;
; Refer to files being added now
;
        mov     si, offset Ws_CF_F_Add_File
        push    ds si
        pop     di es

        mov     si, offset Ws_CF_D_Add_File
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Open ATR Disk Image for update
;
        mov     si, offset ATARI____File
        push    ds si
        pop     di es
        mov     [(FMS_Area ptr di).Request], CMD_OPEN_I_O

        push    es di
        call    FMSIO
        pop     di es

        cmp     [(FMS_Area ptr di).Status], STATUS_OK
        jne     @@94                            ; Error!

        mov     [(FMS_Area ptr di).Request], CMD_ACCESS_WRITE

;
; Include DOS (files)?
;
        cmp     [Ws_DS_D_INCLUDE_DOS], SPACE
        je      @@89                            ; No
                                                ; Yes, so

        call    Process_Include_DOS_Files
        cmp     [Dir2atr_Error], LOGIC_YES      ; Error encountered?
        je      @@99                            ; Yes
                                                ; No, so
@@89:
;
; Update status
;
        mov     [ATR_Disk_Image_Open], TRUE

        jmp     @@99

@@90:
;
; E R R O R S
;
        mov     si, offset Ws_E2_D_Disk_Full
        push    ds si
        jmp     @@97

@@91:
;       mov     si, offset Msg_Err_ATR_Header
        mov     si, offset Ws_E2_D_Disk_Full
        push    ds si
        jmp     @@97

@@93:
        pop     cx
        mov     si, offset Ws_E2_D_Disk_Full
        push    ds si
        jmp     @@97

@@94:
        mov     si, offset Ws_E2_D_Opening_Image
        push    ds si
        jmp     @@97

@@95:
        mov     si, offset Ws_E2_D_BOOTCODE_Not_Found
        push    ds si

@@97:
        mov     si, offset Ws_E2_F_Error_Message
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        pop     si ds
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        call    General_I_O_Error

@@99:
        ret

ENDP    Process_Open_ATR_Image_Disk



;**********************************************************************
PROC    Process_Include_DOS_Files
;**********************************************************************
;-----------------------------------------------------------------------
; Save current values of PC_ATARI file to be written to ATARI disk image
;-----------------------------------------------------------------------
        mov     cx, [File_Size_In_Sectors]
        push    cx
        xor     cx, cx
        mov     cl, [Remainder_Bytes]
        push    cx

        mov     si, offset Temp_File_Name
        push    ds si
        pop     di es
        mov     si, offset File_Map_Entry.File_Name
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

;-------------------
; Write DOS.SYS file
;-------------------
        mov     si, offset File_Map_Entry.File_Name
        push    ds si
        pop     di es
        mov     si, offset File_Name_DOS_SYS
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

;-----------------------------
; Open Atari 8bit DOS.SYS file
;-----------------------------
        call    Setup_Pathname_ATARI_DOS_SYS_File
        call    Process_Open_8bit_File
        cmp     [Dir2atr_Error], LOGIC_YES              ; Error encountered?
        je      @@90                                    ; Yes
                                                        ; No, so
;-----------------------------
; Determine File Size in bytes
;-----------------------------
        call    Determine_Pc_File_Size_In_Bytes

;--------------------------------------------------------
; Determine File Size in sectors (and remainder of bytes)
;--------------------------------------------------------
        mov     dx, [File_Size_In_Bytes_Hi]
        mov     ax, [File_Size_In_Bytes_Lo]
        xor     cx, cx
        mov     bx, [Disk_Sector_Data_Size]
        mov     [Remainder_Bytes], bl
        div     bx
        cmp     dx, NULL                                ; Remainder?
        jz      @@20                                    ; No
                                                        ; Yes, so
        inc     ax                                      ; We need another sector
        mov     [Remainder_Bytes], dl                   ; Save remainder

@@20:
        sub     [Disk_Sectors_Available], ax
        mov     [File_Size_In_Sectors], ax

        clc                                             ; Clear carry
        add     [Ws_CF_Progress_Bar_Sectors_Lo], ax
        jnc     @@21
        inc     [Ws_CF_Progress_Bar_Sectors_Hi]

@@21:
        call    Determine_Sectors_Per_Progress_Bar

;------------------------------
; Move file to Atari disk image
;------------------------------
        call    Process_Move_File_To_Image
        call    Process_Close_8bit_File

        cmp     [Dir2atr_Error], LOGIC_YES      ; Error encountered?
        je      @@98                            ; Yes
                                                ; No, so
        call    Process_Update_8bit_VTOC

;--------------------
; Write DUP.SYS file?
;--------------------
        cmp     [Ws_DS_D_DUPSYS], SPACE         ; Include DUP.SYS file?
        je      @@50                            ; No
                                                ; Yes, so
;-------------------
; Write DUP.SYS file
;-------------------
        mov     si, offset File_Map_Entry.File_Name
        push    ds si
        pop     di es
        mov     si, offset File_Name_DUP_SYS
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

;-----------------------------
; Open Atari 8bit DUP.SYS file
;-----------------------------
        call    Setup_Pathname_ATARI_DUP_SYS_File
        call    Process_Open_8bit_File
        cmp     [Dir2atr_Error], LOGIC_YES              ; Error encountered?
        je      @@92                                    ; Yes
                                                        ; No, so
;-----------------------------
; Determine File Size in bytes
;-----------------------------
        call    Determine_Pc_File_Size_In_Bytes

;--------------------------------------------------------
; Determine File Size in sectors (and remainder of bytes)
;--------------------------------------------------------
        mov     dx, [File_Size_In_Bytes_Hi]
        mov     ax, [File_Size_In_Bytes_Lo]
        xor     cx, cx
        mov     bx, [Disk_Sector_Data_Size]
        mov     [Remainder_Bytes], bl
        div     bx
        cmp     dx, NULL                                ; Remainder?
        jz      @@40                                    ; No
                                                        ; Yes, so
        inc     ax                                      ; We need another sector
        mov     [Remainder_Bytes], dl                   ; Save remainder

@@40:
        sub     [Disk_Sectors_Available], ax
        mov     [File_Size_In_Sectors], ax

        clc                                             ; Clear carry
        add     [Ws_CF_Progress_Bar_Sectors_Lo], ax
        jnc     @@41
        inc     [Ws_CF_Progress_Bar_Sectors_Hi]

@@41:
        call    Determine_Sectors_Per_Progress_Bar

;------------------------------
; Move file to Atari disk image
;------------------------------
        call    Process_Move_File_To_Image
        call    Process_Close_8bit_File

        cmp     [Dir2atr_Error], LOGIC_YES      ; Error encountered?
        je      @@98                            ; Yes
                                                ; No, so
        call    Process_Update_8bit_VTOC

@@50:
;--------------------------------------------------------------------------
; Restore current values of PC_ATARI file to be written to ATARI disk image
;--------------------------------------------------------------------------
        mov     si, offset File_Map_Entry.File_Name
        push    ds si
        pop     di es
        mov     si, offset Temp_File_Name
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

        pop     cx
        mov     [Remainder_Bytes], cl
        pop     cx
        mov     [File_Size_In_Sectors], cx

        jmp     @@99

@@90:
;---------------
; Error routines
;---------------
        mov     si, offset Ws_E2_D_DOS_SYS_Not_Found
        push    ds si
        jmp     @@97

@@92:
        mov     si, offset Ws_E2_D_DUP_SYS_Not_Found
        push    ds si

@@97:
        mov     si, offset Ws_E2_F_Error_Message
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        pop     si ds
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        call    General_I_O_Error

@@98:
        pop     cx
        pop     cx

@@99:
        ret

ENDP    Process_Include_DOS_Files



;**********************************************************************
PROC    Determine_Pc_File_Size_In_Bytes
;**********************************************************************
        mov     si, offset PC_ATARI_File
        push    ds si
        pop     di es

;------------------
; Go to end of file
;------------------
        push    es di

        mov     ax, DOS_MOVE_FILE_POINTER_END
        mov     bx, [(FMS_Area ptr di).Disk_Handler]
        xor     cx, cx                                  ; Use offset 0000:0000
        xor     dx, dx
        int     DOS_SERVICE

        pop     di es

        mov     [File_Size_In_Bytes_Hi], dx
        mov     [File_Size_In_Bytes_Lo], ax

;--------------------
; Go to begin of file
;--------------------
        mov     ax, DOS_MOVE_FILE_POINTER_BEGIN
        mov     bx, [(FMS_Area ptr di).Disk_Handler]
        xor     cx, cx                                  ; Use offset 0000:0000
        xor     dx, dx
        int     DOS_SERVICE

        ret

ENDP    Determine_Pc_File_Size_In_Bytes



;**********************************************************************
PROC    Determine_File_Size_In_Sectors
;**********************************************************************
        mov     [File_Size_In_Sectors], HIGH_VALUES

        mov     bx, [Disk_Sector_Data_Size]
        mov     [Remainder_Bytes], bl

        mov     si, offset File_Map_Entry.File_Size
        mov     dh, [byte ds:si + 3]
        mov     dl, [byte ds:si + 2]
        mov     ah, [byte ds:si + 1]
        mov     al, [byte ds:si]
        xor     cx, cx                                  ; Reset cx

        cmp     dx, 07Bh                                ; Extremely large file?
        jnl     @@99                                    ; Yes
                                                        ; No, so
        div     bx                                      ; Determine nr of sectors
        cmp     dx, NULL                                ; Remainder?
        je      @@10                                    ; No
                                                        ; Yes, so
        inc     ax                                      ; We need another sector
        mov     [Remainder_Bytes], dl                   ; Save remainder
        xor     dx, dx                                  ; Reset dx

@@10:
        mov     [File_Size_In_Sectors], ax

@@99:
        ret

ENDP    Determine_File_Size_In_Sectors



;**********************************************************************
PROC    Process_Move_File_To_Image
;**********************************************************************
        mov     si, offset Ws_CF_D_Add_File_File
        push    ds si
        pop     di es
        mov     si, offset File_Map_Entry.File_Name
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

        mov     si, offset Ws_CF_D_Add_File_File
        mov     cx, FILE_NAME_LENGTH

@@05:
        cmp     [byte ds:si], NULL
        jne     @@06
        mov     [byte ds:si], SPACE

@@06:
        inc     si
        loop    @@05

        cmp     [CLI_Used], LOGIC_YES                   ; Command Line Interface used?
        je      @@07                                    ; Yes
                                                        ; No, so
;
; Display progress screen
;
        mov     si, offset Ws_CF
        mov     [byte ds:si], WSIO_DISPLAY_FIELDS_ONLY

        push    ds si
        call    WSIO
        pop     si ds

@@07:
        mov     cx, [Disk_Sector_Current]
        mov     [Disk_Sector_Start], cx

        mov     cx, [File_Size_In_Sectors]

@@10:
;
; Read 8bit file
;
        push    cx

        mov     si, offset PC_ATARI_File
        push    ds si
        pop     di es

;
; Init data buffer
;
        push    es di

        mov     si, offset Disk_I_O_Buffer
        push    ds si
        pop     di es
        xor     ax, ax
        mov     cx, [Disk_Sector_Size]
        rep     stosb

        pop     di es

;
; Are we processing the "last" sector?
;
        pop     cx
        push    cx

        cmp     cx, 1
        jne     @@20

;
; Process the "remainder" bytes
;
        xor     cx, cx
        mov     cl, [Remainder_Bytes]
        mov     [(FMS_Area ptr di).Record_Size], cx
        
@@20:
;
; Process 8bit file data bytes
;
        push    es di
        call    FMSIO
        pop     di es

        cmp     [(FMS_Area ptr di).Status], STATUS_OK
        jne     @@90                                    ; Error!

;
; Calculate progress bar size, and show it if necessary
;
        clc                                             ; Clear carry
        inc     [Ws_CF_Progress_Bar_Cnt_Sectors_Lo]
        jnc     @@21
        inc     [Ws_CF_Progress_Bar_Cnt_Sectors_Hi]

@@21:
        push    es di

        call    Show_Progress_Bar

        pop     di es

;
; Setup number of data bytes in current sector
;
        mov     cx, [(FMS_Area ptr di).Record_Size]
        mov     si, offset DISK_I_O_Buffer
        add     si, [Disk_Sector_Data_Size]
        mov     [byte ds:si + 2], cl

;
; Determine Next Disk Sector
;
        mov     [Disk_Sector_Next], 0

        pop     cx
        push    cx

        cmp     cx, 1                   ; Is there a next sector?
        je      @@30                    ; No
                                        ; Yes, so
        call    Process_Find_Free_Sector

        cmp     [Dir2atr_Error], LOGIC_YES      ; Error encountered?
        jne     @@30                            ; No
                                                ; Yes, so
        pop     cx
        jmp     @@99

@@30:
;
; Setup Sector File ID
;
        xor     ax, ax
        mov     al, [Atari_Files_Processed]
        mov     cx, 10

@@35:
        shl     ax, 1
        loop    @@35

;
; Setup Next Sector Number
;
        mov     bx, [Disk_Sector_Next]

;
; Combine File ID and Next Sector Number
;
        or      ax, bx

;
; Store information at end of current sector
;
        cmp     [Disk_Media_Type], DISK_MEDIA_TYPE_SINGLE
        je      @@37                            ; Yes
                                                ; No so
        cmp     [Disk_Media_Type], DISK_MEDIA_TYPE_MEDIUM
        je      @@37                            ; Yes
                                                ; No so
        cmp     [Disk_Media_Type], DISK_MEDIA_TYPE_DOUBLE
        je      @@37                            ; Yes
                                                ; No so
;
; Store information at end of current sector (Quad/720KB/1440KB/Harddisk)
; Use 16 bits for sector addressing, and skip file numbering
;
        mov     [byte ds:si], bh
        mov     [byte ds:si + 1], bl

        jmp     @@40

@@37:
;
; Store information at end of current sector (Single/Medium/Double)
; Use 10 bits for sector addressing, and use 6 bits file numbering
;
        mov     [byte ds:si], ah
        mov     [byte ds:si + 1], al

@@40:
;
; Determine sector to write to
;
        mov     si, offset ATARI____File
        push    ds si
        pop     di es

        mov     cx, [Disk_Sector_Current]
        sub     cx, DISK_BOOTCODE_SECTOR_SIZE
        mov     [(FMS_Area ptr di).Record_Nr], cx

        push    es di
        call    FMSIO
        pop     di es

        cmp     [(FMS_Area ptr di).Status], STATUS_OK
        jne     @@91                            ; Error!

        call    Process_Update_8bit_Bitmap

        dec     [Disk_Sectors_Left]

        mov     cx, [Disk_Sector_Next]
        cmp     cx, 0
        je      @@50
        mov     [Disk_Sector_Current], cx

@@50:
        pop     cx
        loop    @@10

@@89:
        mov     cx, [Disk_Sectors_Left]
        cmp     cx, 0                           ; Disk sectors left?
        je      @@99                            ; No
                                                ; Yes, so
        call    Process_Find_Free_Sector

        cmp     [Dir2atr_Error], LOGIC_YES      ; Error encountered?
        je      @@99                            ; Yes
                                                ; No, so
        mov     cx, [Disk_Sector_Next]
        mov     [Disk_Sector_Current], cx

        jmp     @@99

@@90:
;
; E R R O R S
;
        pop     cx

        mov     si, offset Ws_E2_Error_Message
        push    ds si
        pop     di es
        mov     si, offset Ws_E2_D_Reading_File
        mov     cx, WS_E2_ERROR_MESSAGE_SIZE
        rep     movsb

        mov     si, offset Ws_E2_Error_Message
        push    ds si
        mov     cx, WS_E2_ERROR_MESSAGE_SIZE
        push    cx
        mov     si, offset PC_ATARI_Pathname
        push    ds si
        mov     cx, WS_E2_ERROR_MESSAGE_SIZE - 7
        push    cx
        mov     cx, 1                           ; Append spaces
        push    cx

        call    APPEND
        pop     ax ax ax ax ax ax ax

        mov     si, offset Ws_E2_Error_Message
        push    ds si
        jmp     @@97

@@91:
        pop     cx
        mov     si, offset Ws_E2_D_Writing_Image
        push    ds si
        jmp     @@97

@@97:
        mov     si, offset Ws_E2_F_Error_Message
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        pop     si ds
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        call    General_I_O_Error
@@99:
        ret

ENDP    Process_Move_File_To_Image



;**********************************************************************
PROC    Process_Find_Free_Sector
;**********************************************************************
;
; The following sectors cannot be used:
; Sector 1 thru 3       (boot sectors)
; Sector 359            (bitmap sector extended for MYDOS)
; Sector 360            (bitmap sector)
; Sector 361 thru 368   (vtoc sectors)
; Sector 720            (to be compatible with DOS 2.0S)
; Sector 1024           (extended bitmap sector DOS 2.5)
; Sector 1025 thru 1040 (cannot be addressed with 10 bits data address
;                        and hence it is Free Space)
;
        mov     cx, [Disk_Sector_Current]
        inc     cx

        xor     ax, ax
        mov     al, ch                                  ; Check sector
        cmp     ax, 00005h                              ; Sector beyond 1040?
        jnl     @@30                                    ; Yes
                                                        ; No, so
        cmp     cx, EIGHTBIT_SECTOR_BITMAP - 1          ; < 359?
        jl      @@20
        cmp     cx, EIGHTBIT_SECTOR_VTOC_END            ; > 368?
        jnle    @@20
        mov     cx, EIGHTBIT_SECTOR_VTOC_END            ; Assume 368

@@10:
        inc     cx                                      ; + 1

@@20:
;
; Sector = 720?
;
        cmp     cx, EIGHTBIT_SECTOR_PHANTOM
        je      @@10

;
; Is this a MYDOS disk?
;
        cmp     [Disk_Format], DOS25_FORMAT
        jne     @@30

;
; Sector < 1024?
;
        cmp     cx, EIGHTBIT_SECTOR_BITMAP_EXTENDED_DOS25
        jl      @@30

;
; Sector <= 1040?
;
        cmp     cx, EIGHTBIT_SECTOR_FREE_SPACE
        jle     @@10

@@30:
;---------------------------
; Sector <= Disk Sector End?
;---------------------------
        xor     bx, bx
        mov     bl, ch
        mov     ax, [Disk_Sectors]
        xor     dx, dx
        mov     dl, ah
        cmp     bx, dx
        jl      @@89
        cmp     bx, dx
        jne     @@90
        mov     bl, cl
        mov     dl, al
        cmp     bx, dx
        jnle    @@90

@@89:
        mov     [Disk_Sector_Next], cx
        jmp     @@99

@@90:
;
; E R R O R S
;
        mov     si, offset Ws_E2_D_Sector_Allocation
        push    ds si
        jmp     @@97

@@97:
        mov     si, offset Ws_E2_F_Error_Message
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        pop     si ds
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        call    General_I_O_Error

@@99:
        ret

ENDP    Process_Find_Free_Sector



;**********************************************************************
PROC    Process_Update_8bit_Bitmap
;**********************************************************************
        mov     ax, [Disk_Sector_Current]       ; Which sector was processed

        xor     cx, cx
        mov     cl, ah                          ; Check sector
        cmp     cx, 00005h                      ; Sector beyond 1040?
        jnl     @@99                            ; Yes
                                                ; No, so
        cmp     ax, EIGHTBIT_SECTOR_ADDRESSABLE ; Fits in bitmap sectors?
        jnle    @@99                            ; No
                                                ; Yes, so
        cmp     ax, [Last_Sector_In_Bitmap]     ; Fits in regular bitmap?
        jnle    @@10                            ; No
                                                ; Yes, so
;
; Regular bitmap sector
;
        mov     si, offset VTOC_I_O_Bitmap
        add     ax, 80                          ; First 10 bytes are reserved
        jmp     @@20

@@10:
;
; Extended bitmap sector
;
        mov     si, offset VTOC_I_O_Bitmap_Extend
        sub     ax, [Last_Sector_In_Bitmap]

@@20:
        xor     dx, dx
        xor     cx, cx
        mov     bx, 8                           ; Nr of sector per bitmap byte
        div     bx                              ; Divide dx:ax by cx:bx
                                                ; ax=result dx=remainder
        add     si, ax                          ; To move to correct bitmap byte in the bitmap sector
        xor     ax, ax
        mov     al, [byte ds:si]                ; Load bitmap byte

        mov     bx, 0100h                       ; To determine sector <-> bit relation
        mov     cx, dx                          ; To determine the bit position
        inc     cx                              ; the bit within the bitmap byte
        ror     bx, cl                          ; Go to correct bit
        mov     cx, ax                          ; Check if sector is used
        and     cx, bx
        cmp     cx, NULL                        ; Sector used?
        je      @@99                            ; Yes
                                                ; No, so
        xor     ax, bx                          ; Set bit to in use
        mov     [byte ds:si], al                ; Save bitmap byte

@@99:
        ret

ENDP    Process_Update_8bit_Bitmap



;**********************************************************************
PROC    Process_Update_8bit_VTOC
;**********************************************************************
;
; Determine the "slot" in the vtoc, to place the file information
;
        mov     si, offset VTOC_I_O_Buffer
        xor     cx, cx
        mov     cl, [Atari_Files_Processed]
        cmp     cx, 0                                   ; Entries in the vtoc?
        je      @@20                                    ; No
                                                        ; Yes, so
        mov     bx, EIGHTBIT_VTOC_DISPLACEMENT_DOUBLE   ; bx = 8

@@10:
;
; The VTOC for a Double Density disk is a little weird, so check for it
;
        cmp     [Vtoc_Size], EIGHTBIT_VTOC_SIZE_DOUBLE  ; 256 byte sectos?
        jne     @@15                                    ; No
                                                        ; Yes, so
        dec     bx
        jnz     @@15
                                                        ; cx = nr of files
        add     cx, EIGHTBIT_VTOC_DISPLACEMENT_DOUBLE   ; cx = cx + 8
        mov     bx, EIGHTBIT_VTOC_SLOT_DOUBLE           ; bx = 16

@@15:
        add     si, EIGHTBIT_FILE_ENTRY_SIZE            ; si = si + 16
        loop    @@10

@@20:
;
; File is unlocked and active
;
        mov     [byte ds:si], 042h
        inc     si

;
; File Size in Sectors
;
        mov     cx, [File_Size_In_Sectors]
        mov     [byte ds:si], cl
        inc     si
        mov     [byte ds:si], ch
        inc     si

;
; Starting Sector
;
        mov     cx, [Disk_Sector_Start]
        mov     [byte ds:si], cl
        inc     si
        mov     [byte ds:si], ch
        inc     si

        push    ds si

;
; "Initialize" filename area
;
        push    ds si
        pop     di es
        xor     ax, ax
        mov     al, SPACE
        mov     cx, EIGHTBIT_FILE_NAME_LENGTH
        rep     stosb

;
; Move filename
;
        pop     di es
        mov     si, offset File_Map_Entry.File_Name
        mov     cx, 8

@@30:
        mov     al, [byte ds:si]
        cmp     al, NULL                            ; End of file?
        je      @@99                                ; Yes
                                                    ; No, so
        cmp     al, DOT                             ; "." found?
        je      @@40                                ; Yes
                                                    ; No, so
        call    W9x_Atari_File_Name_Correction
        mov     [byte es:di], al
        inc     si
        inc     di
        loop    @@30

@@40:
        inc     di
        loop    @@40
        inc     si
        mov     cx, 3

@@50:
        mov     al, [byte ds:si]
        cmp     al, NULL                            ; End of file?
        je      @@99                                ; Yes
                                                    ; No, so
        call    W9x_Atari_File_Name_Correction
        mov     [byte es:di], al
        inc     si
        inc     di
        loop    @@50

@@99:
        inc     [Atari_Files_Processed]

        ret

ENDP    Process_Update_8bit_VTOC



;**********************************************************************
PROC    Process_Write_8bit_Bitmap_And_VTOC
;**********************************************************************
        cmp     [ATR_Disk_Image_Open], TRUE
        jne     @@99

;
; Update "sectors usable after format" (byte 2 and 3) and
;        "sectors left counter"        (byte 4 and 5) in bitmap sector
;
        mov     si, offset VTOC_I_O_Bitmap
        mov     cx, [Disk_Sectors_Usable]
        mov     [ds:si + 1], cx
        mov     cx, [Disk_Sectors_Left]
        mov     [ds:si + 3], cx

;
; Atari disk image
;
        mov     si, offset ATARI____File
        push    ds si
        pop     di es

;
; VTOC bitmap (sector 360 for all disk types)
;
        mov     cx, EIGHTBIT_SECTOR_BITMAP
        sub     cx, DISK_BOOTCODE_SECTOR_SIZE
        mov     [(FMS_Area ptr di).Record_Nr], cx

        mov     si, offset VTOC_I_O_Bitmap
        mov     [(FMS_Area ptr di).Data_Address_Hi], ds
        mov     [(FMS_Area ptr di).Data_Address_Lo], si

        mov     cx, [Disk_Sector_Size]
        mov     [(FMS_Area ptr di).Record_Size], cx
        mov     [(FMS_Area ptr di).Request], CMD_ACCESS_WRITE

        push    es di
        call    FMSIO
        pop     di es

        cmp     [(FMS_Area ptr di).Status], STATUS_OK
        jne     @@90                            ; Error!

;
; VTOC (sector 361 thru 368 for all disk types)
;
        mov     cx, EIGHTBIT_SECTOR_VTOC_START
        sub     cx, DISK_BOOTCODE_SECTOR_SIZE
        mov     [(FMS_Area ptr di).Record_Nr], cx

        mov     si, offset VTOC_I_O_Buffer
        mov     [(FMS_Area ptr di).Data_Address_Hi], ds
        mov     [(FMS_Area ptr di).Data_Address_Lo], si

        mov     cx, [Vtoc_Size]
        mov     [(FMS_Area ptr di).Record_Size], cx
        mov     [(FMS_Area ptr di).Request], CMD_ACCESS_WRITENEXT

        push    es di
        call    FMSIO
        pop     di es

        cmp     [(FMS_Area ptr di).Status], STATUS_OK
        jne     @@90                            ; Error!

;
; Medium density disk?
;
        cmp     [Disk_Media_Type], DISK_MEDIA_TYPE_MEDIUM
        jne     @@10                            ; No
                                                ; Yes so
;
; VTOC bitmap extended (sector 1024 for DOS 2.5 and 359 for MYDOS 4.53)
;
        mov     cx, [Disk_Sector_Bitmap_Ext]
        sub     cx, DISK_BOOTCODE_SECTOR_SIZE
        mov     [(FMS_Area ptr di).Record_Nr], cx

        mov     si, offset VTOC_I_O_Bitmap_Extend
        mov     [(FMS_Area ptr di).Data_Address_Hi], ds
        mov     [(FMS_Area ptr di).Data_Address_Lo], si

        mov     cx, [Disk_Sector_Size]
        mov     [(FMS_Area ptr di).Record_Size], cx
        mov     [(FMS_Area ptr di).Request], CMD_ACCESS_WRITE

        push    es di
        call    FMSIO
        pop     di es

        cmp     [(FMS_Area ptr di).Status], STATUS_OK
        jne     @@90                            ; Error!

@@10:
;
; After writing the VTOC map to disk, we initialize VTOC map
;        
        mov     si, offset VTOC_I_O_Buffer
        push    ds si
        pop     di es
        xor     ax, ax
        mov     cx, EIGHTBIT_VTOC_SIZE_DOUBLE
        rep     stosb

        jmp     @@99

@@90:
;
; E R R O R S
;
        mov     si, offset Ws_E2_D_Writing_Image
        push    ds si

        mov     si, offset Ws_E2_F_Error_Message
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        pop     si ds
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        call    General_I_O_Error

@@99:
        ret

ENDP    Process_Write_8bit_Bitmap_And_VTOC



;**********************************************************************
PROC    Process_Close_ATR_Image_Disk
;**********************************************************************
        cmp     [ATR_Disk_Image_Open], TRUE
        jne     @@99

;
; Close ATR Disk Image
;
        mov     si, offset ATARI____File
        push    ds si
        pop     di es

        mov     [(FMS_Area ptr di).Request], CMD_OPEN_CLOSE
        push    es di
        call    FMSIO
        pop     di es

;
; Update status
;
        mov     [ATR_Disk_Image_Open], FALSE

@@99:
        ret

ENDP    Process_Close_ATR_Image_Disk



;**********************************************************************
PROC    Process_Open_8bit_File
;**********************************************************************
;
; Open 8bit file
;
        mov     si, offset PC_ATARI_File
        push    ds si
        pop     di es

        mov     si, offset Disk_I_O_Buffer
        mov     [(FMS_Area ptr di).Data_Address_Hi], ds
        mov     [(FMS_Area ptr di).Data_Address_Lo], si

        mov     [(FMS_Area ptr di).Request], CMD_OPEN_INPUT

        push    es di
        call    FMSIO
        pop     di es

        mov     [(FMS_Area ptr di).Request], CMD_ACCESS_READNEXT
        mov     cx, [Disk_Sector_Data_Size]
        mov     [(FMS_Area ptr di).Record_Size], cx

        cmp     [(FMS_Area ptr di).Status], STATUS_OK
        je      @@99                            ; File opened
                                                ; No, so
;
; E R R O R S
;
        mov     si, offset Ws_E2_Error_Message
        push    ds si
        pop     di es
        mov     si, offset Ws_E2_D_Opening_File
        mov     cx, WS_E2_ERROR_MESSAGE_SIZE
        rep     movsb

        mov     si, offset Ws_E2_Error_Message
        push    ds si
        mov     cx, WS_E2_ERROR_MESSAGE_SIZE
        push    cx
        mov     si, offset PC_ATARI_Pathname
        push    ds si
        mov     cx, WS_E2_ERROR_MESSAGE_SIZE - 8
        push    cx
        mov     cx, 1                           ; Append spaces
        push    cx

        call    APPEND
        pop     ax ax ax ax ax ax ax

        mov     si, offset Ws_E2_Error_Message
        push    ds si

        mov     si, offset Ws_E2_F_Error_Message
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        pop     si ds
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        call    General_I_O_Error

@@99:
        ret

ENDP    Process_Open_8bit_File



;**********************************************************************
PROC    Process_Close_8bit_File
;**********************************************************************
        mov     si, offset PC_ATARI_File
        push    ds si
        pop     di es
        mov     [(FMS_Area ptr di).Request], CMD_OPEN_CLOSE

        push    es di
        call    FMSIO
        pop     di es

@@99:
        ret

ENDP    Process_Close_8bit_File



;**********************************************************************
PROC    Setup_Pathname_ATARI_Bootcode_File
;**********************************************************************
        mov     si, offset PC_ATARI_Pathname
        push    ds si
        pop     di es
        mov     si, offset PC_ATARI_DOS_Pathname
        mov     cx, PATH_LENGTH
        rep     movsb

;
; Filename BOOTCODE
;
        mov     si, offset PC_ATARI_Pathname            ; Append field 1
        push    ds si
        mov     cx, PATH_LENGTH                         ; Append field 1 size
        push    cx
        mov     si, offset File_Name_BOOTCODE           ; Append field 2
        push    ds si
        mov     cx, FILE_NAME_LENGTH                    ; Append field 2 size
        push    cx
        mov     cx, 0                                   ; Append spaces
        push    cx

        call    APPEND
        pop     ax ax ax ax ax ax ax

        ret

ENDP    Setup_Pathname_ATARI_Bootcode_File



;**********************************************************************
PROC    Setup_Pathname_ATARI_DOS_SYS_File
;**********************************************************************
        call    Setup_Pathname_ATARI_DOS

        mov     si, offset PC_ATARI_Pathname
        push    ds si
        pop     di es
        mov     si, offset PC_ATARI_DOS_Pathname
        mov     cx, PATH_LENGTH
        rep     movsb

;
; Append DOS.SYS filename
;
        mov     si, offset PC_ATARI_Pathname    ; Append field 1
        push    ds si
        mov     cx, PATH_LENGTH                 ; Append field 1 size
        push    cx
        mov     si, offset File_Name_DOS_SYS    ; Append field 2
        push    ds si
        mov     cx, FILE_NAME_LENGTH            ; Append field 2 size
        push    cx
        mov     cx, 0                           ; Append spaces
        push    cx

        call    APPEND
        pop     ax ax ax ax ax ax ax

        ret

ENDP    Setup_Pathname_ATARI_DOS_SYS_File



;**********************************************************************
PROC    Setup_Pathname_ATARI_DUP_SYS_File
;**********************************************************************
        mov     si, offset PC_ATARI_Pathname
        push    ds si
        pop     di es
        mov     si, offset PC_ATARI_DOS_Pathname
        mov     cx, PATH_LENGTH
        rep     movsb

;
; Append DOS.SYS filename
;
        mov     si, offset PC_ATARI_Pathname            ; Append field 1
        push    ds si
        mov     cx, PATH_LENGTH                         ; Append field 1 size
        push    cx
        mov     si, offset File_Name_DUP_SYS            ; Append field 2
        push    ds si
        mov     cx, FILE_NAME_LENGTH                    ; Append field 2 size
        push    cx
        mov     cx, 0                                   ; Append spaces
        push    cx

        call    APPEND
        pop     ax ax ax ax ax ax ax

        ret

ENDP    Setup_Pathname_ATARI_DUP_SYS_File



;**********************************************************************
PROC    Setup_Pathname_ATARI_DOS
;**********************************************************************
        push    ds si                                   ; Save program entry

        mov     si, offset PC_ATARI_DOS_Pathname
        push    ds si
        pop     di es
        mov     si, [Parm_DOS_Path_ptr_di]
        mov     ds, [Parm_DOS_Path_ptr_es]
        mov     cx, CONFIG_FILE_LINE_SIZE               ; Copy length
        rep     movsb                                   ; Copy path to search path

        pop     si ds                                   ; Restore program entry

        mov     si, offset Dir_DOS25                    ; Assume DOS 2.5
        cmp     [Ws_DS_D_DOS25], "X"
        je      @@10

        mov     si, offset Dir_MYDOS                    ; Assume MYDOS 4.53
        cmp     [Ws_DS_D_MYDOS], "X"
        je      @@10

        mov     si, offset Dir_SPARTADOS                ; Assume SPARTADOS 3.3a
        cmp     [Ws_DS_D_SPARTADOS], "X"
        je      @@10

        mov     si, offset Dir_SPARTADOSX               ; Assume SPARTADOS/X
        cmp     [Ws_DS_D_SPARTADOSX], "X"
        je      @@10

        mov     si, offset Dir_BEWEDOS                  ; Assume BEWEDOS 1.30
        cmp     [Ws_DS_D_BEWEDOS], "X"
        je      @@10

        mov     si, offset Dir_MYOWNDOS                 ; Assume User's DOS

@@10:
;
; Append DOS 2.5, MYDOS 4.53, BeWeDOS, SPARTADOS 3.3a, SPARTADOS/X or MYOWNDOS directory filename
;
        push    ds si
        pop     bx ax

        mov     si, offset PC_ATARI_DOS_Pathname        ; Append field 1
        push    ds si
        mov     cx, PATH_LENGTH                         ; Append field 1 size
        push    cx
        push    ax bx                                   ; Append field 2
        mov     cx, FILE_NAME_LENGTH                    ; Append field 2 size
        push    cx
        mov     cx, 0                                   ; Append spaces
        push    cx

        call    APPEND
        pop     ax ax ax ax ax ax ax

        ret

ENDP    Setup_Pathname_ATARI_DOS



;**********************************************************************
PROC    Setup_ATARI____Pathname
;**********************************************************************
        mov     di, offset ATARI____Pathname
        mov     cx, PATH_LENGTH                 ; Search length
        dec     cx                              ; To go to the last character
        add     di, cx                          ; Go to end of path
        std                                     ; Searh direction is down
        xor     ax, ax
        mov     al, BACKSLASH                   ; Search for the last "\"
        repne   scasb                           ; Search uses es:di
        cld                                     ; Cancel the std setting
        inc     di                              ; Pointer correction after search
        inc     di                              ; Location after the "\"

;
; Add Disk Specification
;
        mov     si, offset Disk_Name
        mov     cx, FILE_NAME_LENGTH        ; Copy length
        rep     movsb                       ; Copy path to search path

        ret

ENDP    Setup_ATARI____Pathname



;**********************************************************************
PROC    Setup_PC_ATARI_Pathname
;**********************************************************************
        mov     di, offset PC_ATARI_Pathname
        mov     cx, PATH_LENGTH                 ; Search length
        dec     cx                              ; To go to the last character
        add     di, cx                          ; Go to end of path
        std                                     ; Search direction is down
        xor     ax, ax
        mov     al, BACKSLASH                   ; Search for the last "\"
        repne   scasb                           ; Search uses es:di
        cld                                     ; Cancel the std setting
        inc     di                              ; Pointer correction after search
        inc     di                              ; Location after the "\"

;
; Add File Specification
;
        mov     si, offset File_Map_Entry.File_Name
        mov     cx, FILE_NAME_LENGTH        ; Copy length
        rep     movsb                       ; Copy path to search path

        ret

ENDP    Setup_PC_ATARI_Pathname



;**********************************************************************
PROC    W9x_Atari_File_Name_Correction
;**********************************************************************
        push    ds si es di
        mov     si, offset Atari_File_Name_Invalid_Char

@@10:
        cmp     [byte ds:si], NULL                      ; End of table reached?
        je      @@99                                    ; Yes
                                                        ; No, so
        cmp     [byte ds:si], al                        ; Invalid Atari 8bit character?
        je      @@20                                    ; Yes
                                                        ; No, so
        inc     si                                      ; Check next character from table
        jmp     @@10

@@20:
        mov     al, KEY_UNDERSCORE

@@99:
        pop     di es si ds
        ret

ENDP    W9x_Atari_File_Name_Correction



;**********************************************************************
PROC    Extract_Digit
;**********************************************************************
        xor     dx, dx                      ; Reset result
        div     bx                          ; Extract digit
        add     dx, 030h                    ; Turn digit into character
        cmp     [byte es:di], DECIMAL_SEPERATOR ; Character is decimal?
        jne     @@10                        ; No
                                            ; Yes, so
        dec     di                          ; Move to previous character

@@10:
        mov     [byte es:di], dl            ; Move character to text
        dec     di                          ; Move to previous character
        ret

ENDP    Extract_Digit



;**********************************************************************
PROC    Close_Ws_BG
;**********************************************************************
        mov     si, offset Ws_BG
        mov     [byte ds:si], WSIO_CLOSE
        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Close_Ws_BG



;**********************************************************************
PROC    General_I_O_Error
;**********************************************************************
        mov     si, offset Ws_E2
        mov     [byte ds:si], WSIO_OPEN

        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_E2
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ

        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_E2
        mov     [byte ds:si], WSIO_CLOSE

        push    ds si
        call    WSIO
        pop     si ds

;
; Error encountered
;
        mov     [Dir2atr_Error], LOGIC_YES

        ret

ENDP    General_I_O_Error



ENDS    CSeg                                ; End of Code segment

END
