%TITLE          "Determine Current Files - CHiPS bv 1997"
;**********************************************************************
;**                                                                  **
;**  Program   : DC_FILES                                            **
;**  Purpose   : Determine Current Files                             **
;**                                                                  **
;**  Author    : B.F. Schreurs                                       **
;**              Computer High Performance Software (CHiPS) bv       **
;**  Date      : October 29th, 1997                                  **
;**                                                                  **
;**  Calls     : HEX2DIGI       - Convert Hex Data To Digits (Text)  **
;**              MEMSORT        - Sort A (Memory) File               **
;**                                                                  **
;**  Parameter : 1. Pass the address of the requested format.        **
;**                 The format specified how the data of the         **
;**                 available directories will be passed back.       **
;**                 Requested format size is 1 byte and may contain: **
;**                 "1" = Return data in format as specified in      **
;**                       DIRENTRY.STR with size FILE_ENTRY_LENGTH.  **
;**                 "2" = Return data in format                      **
;**                       "ATARI.FIL      3,123,123"                 **
;**                       "ATARITXT.INF      23,444"                 **
;**                       "MYFILE               512"                 **
;**                       "YOURFILE     123,456,789"                 **
;**                       "                        "                 **
;**                       "                        "                 **
;**                       "                        "                 **
;**                       etc. with size FILE_ENTRY_LENGTH           **
;**  Parameter : 2. Pass the address of the data which contains the  **
;**                 path to be searched for the directories to be    **
;**                 retrieved. Path size is PATH_LENGTH.             **
;**  Parameter : 3. Pass the address of the table where the data     **
;**                 containing the file information will be stored.  **
;**                 Format "1": Table size: FILE_ENTRY_LENGTH *      **
;**                             number of expected files.            **
;**                 Format "2": Table size: FILE_ENTRY_LENGTH        **
;**                             number of expected files.            **
;**                                                                  **
;**  Language  : Turbo Assembler                                     **
;**                                                                  **
;**  Returncode: 0 - All is ok                                       **
;**              1 - Drive was not ready                             **
;**                                                                  **
;**********************************************************************
        IDEAL
        JUMPS

;----------------------------------------------------------------------
;--  Functions which can be called                                   --
;----------------------------------------------------------------------
        PUBLIC  DC_FILES

;----------------------------------------------------------------------
;--  Equates                                                         --
;----------------------------------------------------------------------
include ".\equ\attrib.equ"
include ".\equ\dos.equ"
include ".\equ\equipmnt.equ"
include ".\equ\sysdep.equ"

;**********************************************************************
SEGMENT SSeg Para Stack 'STACK'
;**********************************************************************

        db        64 dup (0)            ; Stack

ENDS    SSeg



;**********************************************************************
SEGMENT DSeg Word Public 'DATA'
;**********************************************************************

;----------------------------------------------------------------------
;--  Structures                                                      --
;----------------------------------------------------------------------
include ".\str\direntry.str"
include ".\str\dta.str"
include ".\str\sortkeys.str"

;----------------------------------------------------------------------
;--  Working Storage                                                 --
;----------------------------------------------------------------------
GLOBAL Return_Code:Byte:1

Parm_Format_ptr_es      DW    1 dup (NULL)      ; 1 = "DIRENTRY format ..      "
                                                ;     "DIRENTRY format ATARI   "
Parm_Format_ptr_di      DW    1 dup (NULL)      ; 2 = "MYFILE               123"
                                                ;     "YOURFILE.TXT 123,456,789"
Parm_Path_Spec_ptr_es   DW    1 dup (NULL)
Parm_Path_Spec_ptr_di   DW    1 dup (NULL)

Parm_File_Map_ptr_es    DW    1 dup (NULL)
Parm_File_Map_ptr_di    DW    1 dup (NULL)

Parm_SortKeys           SortKeys<>

Hex2digi_Requested_Format       DB  "1"         ; "1" = With thousand seperator
                                                ; "2" = Mo thousand seperator
DOS_Find_Files_Or_Dirs  DW    1 dup (DOS_FIND_FILES)

Requested_Format        DB    1 dup (?)
File_Map_Entry          Dir_Entry <>
Files_In_File_Table     DW    0

Old_Dta_Seg             DW    ?                 ; Old Dta Segment Address
Old_Dta_Ofs             DW    ?                 ; Old Dta Segment Offset
Own_Dta                 Dta <>


ENDS    DSeg



;**********************************************************************
SEGMENT CSeg Word Public 'CODE'
;**********************************************************************
;----------------------------------------------------------------------
;--  External Variables                                              --
;----------------------------------------------------------------------
        EXTRN   HEX2DIGI:proc               ; Convert Hex Data To Digits (Text)
        EXTRN   MEMSORT:proc                ; Sort A (Memory) File

;**********************************************************************
PROC    DC_FILES
;**********************************************************************
        ASSUME  cs:CSeg
        ASSUME  ds:DSeg
        mov     ax, DSeg                    ; Initialize DS to address
        mov     ds, ax                      ; of data segment

        mov     bx, sp

;
; Parameter Files
;
        mov     di, [ss:bx+2]
        mov     es, [ss:bx+4]

        mov     [Parm_File_Map_ptr_es], es
        mov     [Parm_File_Map_ptr_di], di

;
; Parameter Path
;
        mov     di, [ss:bx+6]
        mov     es, [ss:bx+8]

        mov     [Parm_Path_Spec_ptr_es], es
        mov     [Parm_Path_Spec_ptr_di], di

;
; Parameter Requested Format
;
        mov     di, [ss:bx+10]
        mov     es, [ss:bx+12]


        mov     [Parm_Format_ptr_es], es
        mov     [Parm_Format_ptr_di], di
        mov     al, [byte es:di]
        mov     [Requested_Format], al

; Init return code
        mov     al, NULL
        mov     [Return_Code], al

; Save Current Dta
        mov     ah, DOS_GET_DTA             ; Get Disk Transfer Area address
        int     DOS_SERVICE 
        mov     [Old_Dta_Seg], es           ; Save old Dta Segment Address
        mov     [Old_Dta_Ofs], bx           ; Save old Dta Segment Offset

; Specify Own Dta
        mov     dx, offset Own_Dta          ; Address of Own Dta

        mov     ah, DOS_SET_DTA
        int     DOS_SERVICE 

;
; The directory search is split up in 2 parts
; Skip the Directories,
; Retrieve ALL Files
;
        mov     [Files_In_File_Table], 0

        mov     ds, [Parm_Path_Spec_ptr_es]     ; Use specified search path
        mov     dx, [Parm_Path_Spec_ptr_di]

        mov     cx, [DOS_Find_Files_Or_Dirs]    ; Is one or the other
        xor     ax, ax                      ; Reset ax
        mov     ah, DOS_FIND_FIRST_FILE     ; Find First File
        jmp     @@20

; Retrieve file entries
@@10:
        mov     cx, [DOS_Find_Files_Or_Dirs]    ; Is one or the other
        xor     ax, ax                      ; Reset ax
        mov     ah, DOS_FIND_NEXT_FILE      ; Find Next File

; Read VTOC
@@20:
        int     DOS_SERVICE                 ; Find First/Next Entry
        jc      @@50                        ; No more Entries?

; Check for "." or ".." entry
        mov     si, offset Own_Dta.File_Name
                                            ; Load address of filename
        cmp     [byte ds:si], DOT           ; Is this a ". " Entry?
        je      @@10                        ; Retrieve next Entry

; Check Entry for being a directory entry
        mov     si, offset Own_Dta.File_Attribute
                                            ; Load address of attribute
        xor     ax, ax                      ; Reset ax
        mov     al, [byte ds:si]            ; Load attribute
        and     al, ATTRIB_FILE_DIRECTORY
        cmp     al, ATTRIB_FILE_DIRECTORY   ; Entry is a directory?
        je      @@10                        ; Yes
                                            ; No, so
;
; Move entry to our file entry
;

; Init file entry first
        mov     si, offset File_Map_Entry
        push    ds si
        pop     di es
        mov     cx, FILE_ENTRY_LENGTH
        xor     ax, ax
        rep     stosb

; Search the null terminator
        mov     si, offset Own_Dta.File_Name
        push    ds si
        pop     di es
        mov     cx, FILE_NAME_LENGTH        ; Search length
        inc     cx
        xor     ax, ax                      ; Search for null character
        repne   scasb                       ; Search uses es:di
        mov     bx, cx

; File_Name
        mov     si, offset File_Map_Entry.File_Name
        push    ds si
        pop     di es
        mov     si, offset Own_Dta.File_Name
        mov     cx, FILE_NAME_LENGTH
        sub     cx, bx
        rep     movsb

        cmp     [Requested_Format], "1"         ; DIRENTRY format?
        je      @@30                            ; Yes
                                                ; No, so
;
; Replace remaining nulls from VTOC read by spaces
;
        mov     cx, bx
        inc     cx                              ; Space between filename and size
        mov     al, SPACE
        rep     stosb

;
; Format is "MYFILE               123"
;           "YOURFILE.TXT 123,456,789"
;           etc.
;
        mov     si, offset Hex2digi_Requested_Format
        push    ds si                           ; Parameter 1

        mov     si, offset Own_Dta.File_Size
        mov     cl, [byte ds:si]
        mov     [byte es:di + 3], cl
        mov     cl, [byte ds:si + 1]
        mov     [byte es:di + 2], cl
        mov     cl, [byte ds:si + 2]
        mov     [byte es:di + 1], cl
        mov     cl, [byte ds:si + 3]
        mov     [byte es:di], cl

        push    es di                           ; Parameter 2

        call    HEX2DIGI
        pop     ax ax ax ax

        jmp     @@40

@@30:
; File_Size
        mov     si, offset File_Map_Entry.File_Size
        push    ds si
        pop     di es
        mov     si, offset Own_Dta.File_Size
        mov     cx, 4
        rep     movsb

; File_Date
        mov     si, offset File_Map_Entry.File_Date
        push    ds si
        pop     di es
        mov     si, offset Own_Dta.File_Date
        mov     cx, 2
        rep     movsb

; File_Time
        mov     si, offset File_Map_Entry.File_Time
        push    ds si
        pop     di es
        mov     si, offset Own_Dta.File_Time
        mov     cx, 2
        rep     movsb

; File_Attribute
        mov     al, offset Own_Dta.File_Attribute
        mov     [offset File_Map_Entry.File_Attribute], al

@@40:
; Calculate location where to store the entry
        mov     ax, FILE_ENTRY_LENGTH
        xor     bx, bx
        mov     cx, [Files_In_File_Table]
        xor     dx, dx
        mul     cx
 
; Store Entry
        mov     cx, ax

        mov     es, [Parm_File_Map_ptr_es]
        mov     di, [Parm_File_Map_ptr_di]
        add     di, cx

        mov     si, offset File_Map_Entry
        mov     cx, FILE_ENTRY_LENGTH
        rep     movsb

; Increase Entry count
        inc     [Files_In_File_Table]

        cmp     [Files_In_File_Table], MAX_FILES
                                            ; Max nr of Entries reached?
        jne     @@10                        ; No
                                            ; Yes, so
@@50:
        mov     es, [Old_Dta_Seg]           ; Restore old Dta Address
        mov     dx, [Old_Dta_Ofs]
        mov     ah, DOS_SET_DTA
        int     DOS_SERVICE 

        cmp     [Files_In_File_Table], 0    ; Files found?
        je      @@90                        ; No
                                            ; Yes, so
        cmp     [Files_In_File_Table], 1    ; Do we need to sort?
        je      @@99                        ; No
                                            ; Yes, so
;
; Set up sort keys
;
        mov     si, offset Parm_SortKeys
        push    ds si
        pop     di es

        mov     ax, [Parm_File_Map_ptr_es]
        mov     bx, [Parm_File_Map_ptr_di]

        mov     [(SortKeys ptr di).Memory_Address_Hi], ax
        mov     [(SortKeys ptr di).Memory_Address_Lo], bx
        mov     ax, [Files_In_File_Table]
        mov     [(SortKeys ptr di).Record_Count], ax
        mov     [(SortKeys ptr di).Record_Size], FILE_ENTRY_LENGTH
        mov     [(SortKeys ptr di).Key_Count], 1
        mov     [(SortKeys ptr di).Key_1_Position], 1
        mov     [(SortKeys ptr di).Key_1_Size], FILE_NAME_LENGTH
        mov     [(SortKeys ptr di).Key_1_A_D], SORT_ASCENDING

;
; Bubble Sort Files in alphabetic order
;
        push    es di

        call    MEMSORT

        pop     bx bx

@@90:
        mov     al, 1
        mov     [Return_Code], al

@@99:
        ret

ENDP    DC_FILES



ENDS    CSeg                                ; End of Code segment

END                                         ; End of Program
