%TITLE          "TO_UPPER - Convert text to Upper Case - CHiPS bv 1997"
;**********************************************************************
;**                                                                  **
;**  Program   : TO_UPPER                                            **
;**  Purpose   : Convert text to Upper Case.                         **
;**                                                                  **
;**  Author    : B.F. Schreurs - CHiPS bv                            **
;**  Date      : October 30th, 19975                                 **
;**                                                                  **
;**  Calls     : [None]                                              **
;**                                                                  **
;**  Stack     :    ax -> Field to be upper case-d                   **
;**                                                                  **
;**  Syntax    :    CALL "APPEND" USING ax                           **
;**                                                                  **
;**********************************************************************
        IDEAL
        MODEL   Small
        JUMPS
        CODESEG

;**********************************************************************
;**  Externals : PUBLIC                                              **
;**********************************************************************
        PUBLIC  TO_UPPER

;----------------------------------------------------------------------
;--  Equates                                                         --
;----------------------------------------------------------------------
include ".\equ\sysdep.equ"

;**********************************************************************
;**  Subroutine: To_Upper                                            **
;**********************************************************************
PROC    TO_UPPER

@@00:
        push    ax                      ; push registers
        push    cx                      ;       which are destroyed
        push    es                      ;       during this program
        push    di                      ;       and which will be
        push    si                      ;       restored at the end

        mov     bp, sp                  ; address the stack
        mov     es, [WORD bp + 14]      ; get segment of Field_1_Ptr
        mov     di, [WORD bp + 12]      ; get offset  of Field_1_Ptr
        mov     cx, MAX_FIELD_SIZE      ; search length

@@10:
        cmp     [byte es:di], NULL
        je      @@99
        cmp     [byte es:di], 'a'
        jb      @@20
        cmp     [byte es:di], 'z'
        ja      @@20
        sub     [byte es:di], 'a' - 'A'

@@20:
        inc     di
        dec     cx
        jnz     @@10
        
@@99:
        pop     si                      ; pop registers
        pop     di                      ;       which are destroyed
        pop     es                      ;       during the append
        pop     cx                      ;       and which will be
        pop     ax                      ;       restored at the end

        ret

ENDP    To_Upper

        END                             ; End of Subroutine
