#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "sapGlobals.h"

void cpuInit( void )
{
	cpuReg_PC = 0xFFFF;
	cpuReg_S = 0xFF;
	cpuReg_A = 0x00;
	cpuReg_X = 0x00;
	cpuReg_Y = 0x00;
	cpuSetFlags( 0x20 );
}


void cpuSetFlags( BYTE flags )
{
	cpuFlag_N = flags;
	cpuFlag_V = (flags>>6)&1;
	cpuFlag_B = (flags>>4)&1;
	cpuFlag_D = (flags>>3)&1;
	cpuFlag_I = (flags>>2)&1;
	cpuFlag_Z = (flags&2)==0 ? 1:0;
	cpuFlag_C = flags&1;
}


BYTE cpuGetFlags( void )
{
BYTE flags;

	flags = (cpuFlag_N&0x80) | ((cpuFlag_V&1)<<6) | 0x20 | ((cpuFlag_B&1)<<4) | ((cpuFlag_D&1)<<3) | ((cpuFlag_I&1)<<2) | (cpuFlag_Z==0 ? 2:0) | (cpuFlag_C&1);
	return flags;
}

#define	AND		{ cpuReg_A &= cB; cpuFlag_N = cpuFlag_Z = cpuReg_A; }
#define	ASL		{ cpuFlag_C = cB>>7; cB<<=1; cpuFlag_N = cpuFlag_Z = cB; }
#define	EOR		{ cpuReg_A ^= cB; cpuFlag_N = cpuFlag_Z = cpuReg_A; }
#define	ORA		{ cpuReg_A |= cB; cpuFlag_N = cpuFlag_Z = cpuReg_A; }

#define ROL		{ BYTE cFlag; cFlag = cB>>7; cB = (cB<<1) + (cpuFlag_C&1); cpuFlag_C = cFlag; cpuFlag_N = cpuFlag_Z = cB; }

#define	ASLORA	{ cpuFlag_C = cB>>7; cB<<=1; cpuReg_A |= cB; cpuFlag_N = cpuFlag_Z = cpuReg_A; }
#define	ROLAND	{ BYTE cFlag; cFlag = cB>>7; cB = (cB<<1) + (cpuFlag_C&1); cpuFlag_C = cFlag; cpuReg_A &= cB; cpuFlag_N = cpuFlag_Z = cpuReg_A; }

#define CondJump( a ) cpuReg_PC += (a) ? (WORD)(signed short int)(signed char)freddieCPUReadByte(cpuReg_PC+1)+2:2;

#define Load_IMD(a)		BYTE cB; { cB=freddieCPUReadByte(cpuReg_PC+1); cpuReg_PC+=2; a; }
#define Load_ZP(a)		BYTE cB; { BYTE cA=freddieCPUReadByte(cpuReg_PC+1); cB = atariMem[cA]; cpuReg_PC+=2; a; }
#define Load_ZPX(a)		BYTE cB; { BYTE cA=freddieCPUReadByte(cpuReg_PC+1)+cpuReg_X; cB = atariMem[cA]; cpuReg_PC+=2; a; }
#define Load_ZPY(a)		BYTE cB; { BYTE cA=freddieCPUReadByte(cpuReg_PC+1)+cpuReg_X; cB = atariMem[cA]; cpuReg_PC+=2; a; }
#define Load_ABS(a)		BYTE cB; { WORD cWA = ((WORD)freddieCPUReadByte(cpuReg_PC+1)) + ((WORD)freddieCPUReadByte(cpuReg_PC+2))*256; cB = freddieReadByte(cWA); cpuReg_PC+=3; a; }
//#define Load_ABSX(a)	BYTE cB; { WORD cWA = ((WORD)freddieCPUReadByte(cpuReg_PC+1)) + ((WORD)freddieCPUReadByte(cpuReg_PC+2))*256 + (WORD)cpuReg_X; cB = freddieReadByte(cWA); cpuReg_PC+=3; a; }
#define Load_ABSX(a)	BYTE cB; { WORD cWA = ((WORD*)&atariMem[cpuReg_PC+1])[0] + (WORD)cpuReg_X; cB = freddieReadByte(cWA); cpuReg_PC+=3; a; }
//#define Load_ABSY(a)	BYTE cB; { WORD cWA = ((WORD)freddieCPUReadByte(cpuReg_PC+1)) + ((WORD)freddieCPUReadByte(cpuReg_PC+2))*256 + (WORD)cpuReg_Y; cB = freddieReadByte(cWA); cpuReg_PC+=3; a; }
#define Load_ABSY(a)	BYTE cB; { WORD cWA = ((WORD*)&atariMem[cpuReg_PC+1])[0] + (WORD)cpuReg_Y; cB = freddieReadByte(cWA); cpuReg_PC+=3; a; }
#define Load_PreX(a)	BYTE cB; { BYTE cA=freddieCPUReadByte(cpuReg_PC+1)+cpuReg_X; cB = freddieReadByte( ((WORD)atariMem[cA]) + ((WORD)atariMem[cA+1])*256 ); cpuReg_PC+=2; a; }
#define Load_PostY(a)	BYTE cB; { BYTE cA=freddieCPUReadByte(cpuReg_PC+1); cB = freddieReadByte( ((WORD)atariMem[cA]) + ((WORD)atariMem[cA+1])*256 + (WORD)cpuReg_Y ); cpuReg_PC+=2; a; }

#define Modify_ZP(a)	BYTE cB; { BYTE cA=freddieCPUReadByte(cpuReg_PC+1); cB = atariMem[ cA ]; cpuReg_PC+=2; a; atariMem[cA] = cB; }
#define Modify_ZPX(a)	BYTE cB; { BYTE cA=freddieCPUReadByte(cpuReg_PC+1)+cpuReg_X; cB = atariMem[ cA ]; cpuReg_PC+=2; a; atariMem[cA] = cB; }
#define Modify_ABS(a)	BYTE cB; { WORD cWA = ((WORD)freddieCPUReadByte(cpuReg_PC+1)) + ((WORD)freddieCPUReadByte(cpuReg_PC+2))*256; cB = freddieReadByte( cWA ); a; freddieWriteByte(cWA,cB); cpuReg_PC+=3; }
//#define Modify_ABSX(a)	BYTE cB; { WORD cWA = ((WORD)freddieCPUReadByte(cpuReg_PC+1)) + ((WORD)freddieCPUReadByte(cpuReg_PC+2))*256 + (WORD)cpuReg_X; cB = freddieReadByte( cWA ); a; freddieWriteByte(cWA,cB); cpuReg_PC+=3; }
#define Modify_ABSX(a)	BYTE cB; { WORD cWA = ((WORD*)&atariMem[cpuReg_PC+1])[0] + (WORD)cpuReg_X; cB = freddieReadByte( cWA ); a; freddieWriteByte(cWA,cB); cpuReg_PC+=3; }
//#define Modify_ABSY(a)	BYTE cB; { WORD cWA = ((WORD)freddieCPUReadByte(cpuReg_PC+1)) + ((WORD)freddieCPUReadByte(cpuReg_PC+2))*256 + (WORD)cpuReg_Y; cB = freddieReadByte( cWA ); a; freddieWriteByte(cWA,cB); cpuReg_PC+=3; }
#define Modify_ABSY(a)	BYTE cB; { WORD cWA = ((WORD*)&atariMem[cpuReg_PC+1])[0] + (WORD)cpuReg_Y; cB = freddieReadByte( cWA ); a; freddieWriteByte(cWA,cB); cpuReg_PC+=3; }
#define Modify_PreX(a)	BYTE cB; { WORD cWA; BYTE cA=freddieCPUReadByte(cpuReg_PC+1)+cpuReg_X; cWA = ((WORD)atariMem[cA]) + ((WORD)atariMem[cA+1])*256; cB = freddieReadByte( cWA ); cpuReg_PC+=2; a; freddieWriteByte(cWA,cB); }
#define Modify_PostY(a)	BYTE cB; { WORD cWA; BYTE cA=freddieCPUReadByte(cpuReg_PC+1); cWA = ((WORD)atariMem[cA]) + ((WORD)atariMem[cA+1])*256 + (WORD)cpuReg_Y; cB = freddieReadByte( cWA ); cpuReg_PC+=2; a; freddieWriteByte(cWA,cB); }

int opcode_0x00(void)	/* 0x00 - BRK				7 cycles	*/
{
	cpuReg_PC++;
	return 20;
}
int opcode_0x01(void)	/* 0x01 - ORA (,X)			6 cycles	*/
{
	Load_PreX( ORA );
	return 6;
}
int opcode_0x02(void)	/* 0x02 - ...				hang		*/
{
	return 20;
}
int opcode_0x03(void)	/* 0x03 - ASL:ORA (,X)		8 cycles	*/
{
	Modify_PreX( ASLORA );
	return 8;
}
int opcode_0x04(void)	/* 0x04 - NOP2				3 cycles	*/
{
	cpuReg_PC+=2;
	return 3;
}
int opcode_0x05(void)	/* 0x05 - ORA ZP			3 cycles	*/
{
	Load_ZP( ORA );
	return 3;
}
int opcode_0x06(void)	/* 0x06 - ASL ZP			5 cycles	*/
{
	Modify_ZP( ASL )
	return 5;
}
int opcode_0x07(void)	/* 0x07 - ASL:ORA ZP		5 cycles	*/
{
	Modify_ZP( ASLORA )
	return 5;
}
int opcode_0x08(void)	/* 0x08 - PHP				3 cycles	*/
{
BYTE te;
	cpuReg_PC++;
	te = (cpuFlag_N&0x80) | ((cpuFlag_V&1)<<6) | 0x20 | ((cpuFlag_B&1)<<4) | ((cpuFlag_D&1)<<3) | ((cpuFlag_I&1)<<2) | (cpuFlag_Z==0 ? 2:0) | (cpuFlag_C&1);
	atariMem[0x100 + cpuReg_S] = te; cpuReg_S--;
	return 3;
}
int opcode_0x09(void)	/* 0x09 - ORA #				2 cycles	*/
{
	Load_IMD( ORA );
	return 2;
}
int opcode_0x0A(void)	/* 0x0A - ASL @				2 cycles	*/
{
	cpuReg_PC++;
	cpuFlag_C = cpuReg_A>>7; cpuReg_A<<=1; cpuFlag_N = cpuFlag_Z = cpuReg_A;
	return 2;
}
int opcode_0x0B(void)	/* 0x0B - ????							*/
{
	return 20;
}
int opcode_0x0C(void)	/* 0x0C - NOP3				4 cycles	*/
{
	cpuReg_PC+=3;
	return 4;
}
int opcode_0x0D(void)	/* 0x0D - ORA ABS			4 cycles	*/
{
	Load_ABS( ORA );
	return 4;
}
int opcode_0x0E(void)	/* 0x0E - ASL ABS			6 cycles	*/
{
	Modify_ABS( ASL );
	return 6;
}
int opcode_0x0F(void)	/* 0x0F - ASL:ORA ABS		6 cycles	*/
{
	Modify_ABS( ASLORA );
	return 6;
}
int opcode_0x10(void)	/* 0x10 - BPL				2-4 cycles	*/
{
	CondJump( (cpuFlag_N&0x80)==0 );
	return 3;
}
int opcode_0x11(void)	/* 0x11 - ORA (),Y			5,6 cycles	*/
{
	Load_PostY( ORA );
	return 5;
}
int opcode_0x12(void)	/* 0x12 - ...				hang		*/
{
	return 20;
}
int opcode_0x13(void)	/* 0x13 - ASL:ORA (),Y		8 cycles	*/
{
	Modify_PostY( ASLORA );
	return 8;
}
int opcode_0x14(void)	/* 0x14 - NOP2							*/
{
	cpuReg_PC+=2;
	return 3;
}
int opcode_0x15(void)	/* 0x15 - ORA ZP,X			4 cycles	*/
{
	Load_ZPX( ORA );
	return 4;
}
int opcode_0x16(void)	/* 0x16 - ASL ZP,X			6 cycles	*/
{
	Modify_ZPX( ASL );
	return 6;
}
int opcode_0x17(void)	/* 0x17 - ASL:ORA ZP,X		6 cycles	*/
{
	Modify_ZPX( ASLORA );
	return 6;
}
int opcode_0x18(void)	/* 0x18 - CLC				2 cycles	*/
{
	cpuReg_PC++;
	cpuFlag_C = 0;
	return 2;
}
int opcode_0x19(void)	/* 0x19 - ORA ABS,Y			4,5 cycles	*/
{
	Load_ABSY( ORA );
	return 4;
}
int opcode_0x1A(void)	/* 0x1A - NOP1				2 cycles	*/
{
	cpuReg_PC++;
	return 2;
}
int opcode_0x1B(void)	/* 0x1B - ASL:ORA ABS,Y		7 cycles	*/
{
	Modify_ABSY( ASLORA );
	return 7;
}
int opcode_0x1C(void)	/* 0x1C - NOP3				7 cycles	*/
{
	cpuReg_PC+=3;
	return 7;
}
int opcode_0x1D(void)	/* 0x1D - ORA ABS,X			4,5 cycles	*/
{
	Load_ABSX( ORA );
	return 4;
}
int opcode_0x1E(void)	/* 0x1E - ASL ABS,X			7 cycles	*/
{
	Modify_ABSX( ASL );
	return 7;
}
int opcode_0x1F(void)	/* 0x1F - ASL:ORA ABS,X		7 cycles	*/
{
	Modify_ABSX( ASLORA );
	return 7;
}
int opcode_0x20(void)	/* 0x20 - JSR ABS			6 cycles	*/
{
	cpuReg_PC+=2;
	atariMem[0x100 + cpuReg_S] = (cpuReg_PC>>8)&0xFF; cpuReg_S--;
	atariMem[0x100 + cpuReg_S] = cpuReg_PC&0xFF; cpuReg_S--;
	cpuReg_PC = dword_u.valW;
	return 6;
}
int opcode_0x21(void)	/* 0x21 - AND (,X)			6 cycles	*/
{
	Load_PreX( AND );
	return 6;
}
int opcode_0x22(void)	/* 0x22 - ...				hang		*/
{
	return 20;
}
int opcode_0x23(void)	/* 0x23 - ROL:AND (,X)		8 cycles	*/
{
	Modify_PreX( ROLAND );
	return 8;
}
int opcode_0x24(void)	/* 0x24 - BIT ZP			3 cycles	*/
{
BYTE cb; cpuReg_PC+=2;
	cb = atariMem[dword_u.vb1];
	cpuFlag_Z = cb&cpuReg_A; cpuFlag_N = cb; cpuFlag_V = cb>>6;
	return 3;
}
int opcode_0x25(void)	/* 0x25 - AND ZP			3 cycles	*/
{
	Load_ZP( AND );
	return 3;
}
int opcode_0x26(void)	/* 0x26 - ROL ZP			5 cycles	*/
{
	Modify_ZP( ROL );
	return 5;
}
int opcode_0x27(void)	/* 0x27 - ROL:AND ZP		5 cycles	*/
{
	Modify_ZP( ROLAND );
	return 5;
}





int opcode_0x28(void)	/* 0x28 - PLP				4 cycles	*/
{
BYTE te;
	cpuReg_PC++; cpuReg_S++; te = atariMem[0x100 + cpuReg_S];
	cpuFlag_N = te; cpuFlag_V = (te>>6)&1; cpuFlag_B = (te>>4)&1; cpuFlag_D = (te>>3)&1; cpuFlag_I = (te>>2)&1; cpuFlag_Z = (te&2)^2; cpuFlag_C = te&1;
	return 4;
}
int opcode_0x29(void)	/* 0x29 - AND #				2 cycles	*/
{
	cpuReg_PC+=2;
	cpuReg_A &= dword_u.vb1;
	cpuFlag_N = cpuFlag_Z = cpuReg_A;
	return 2;
}
int opcode_0x2A(void)	/* 0x2A - ROL @				2 cycles	*/
{
BYTE cC;
	cpuReg_PC++;
	cC = cpuReg_A>>7; cpuReg_A = (cpuReg_A<<1) + (cpuFlag_C&1); cpuFlag_C = cC; cpuFlag_N = cpuFlag_Z = cpuReg_A;
	return 2;
}
int opcode_0x2B(void)	/* 0x2B - ????							*/
{
	return 20;
}
int opcode_0x2C(void)	/* 0x2C - BIT ABS			4 cycles	*/
{
BYTE cb;
	cpuReg_PC+=3;
	cb = freddieReadByte( dword_u.valW );
	cpuFlag_Z = cb&cpuReg_A; cpuFlag_N = cb; cpuFlag_V = cb>>6;
	return 4;
}
int opcode_0x2D(void)	/* 0x2D - AND ABS			4 cycles	*/
{
	cpuReg_PC+=3;
	cpuReg_A &= freddieReadByte( dword_u.valW );
	cpuFlag_N = cpuFlag_Z = cpuReg_A;
	return 4;
}
int opcode_0x2E(void)	/* 0x2E - ROL ABS			6 cycles	*/
{
BYTE cC;
	cpuReg_PC+=3;
	cpuWorkAddress = dword_u.valW;
	cpuVal = freddieReadByte( cpuWorkAddress );
	cC = cpuVal>>7; cpuNewVal = (cpuVal<<1) + (cpuFlag_C&1); cpuFlag_C = cC; cpuFlag_N = cpuFlag_Z = cpuNewVal;
	doWrite = 2;
	return 6;
}
int opcode_0x2F(void)	/* 0x2F - ROL:AND ABS		6 cycles	*/
{
BYTE cC;
	cpuReg_PC+=3;
	cpuWorkAddress = dword_u.valW;
	cpuVal = freddieReadByte( cpuWorkAddress );
	cC = cpuVal>>7; cpuVal = (cpuVal<<1) + (cpuFlag_C&1); cpuFlag_C = cC;
	cpuReg_A &= cpuVal; cpuFlag_N = cpuFlag_Z = cpuReg_A;
	doWrite = 2;
	return 6;
}
int opcode_0x30(void)	/* 0x30 - BMI				2-4 cycles	*/
{
WORD oldPC;

	cpuReg_PC+=2;
	oldPC = cpuReg_PC;
	cpuReg_PC = cpuReg_PC+(WORD)(signed short int)(signed char)((((cpuFlag_N^0x80)>>7)-1)&dword_u.vb1);
	oldPC = oldPC ^ cpuReg_PC;
	return 2+((oldPC>>8)&1)+((((cpuFlag_N^0x80)>>7)&1)^1);
}
int opcode_0x31(void)	/* 0x31 - AND (),Y			5,6 cycles	*/
{
WORD w1;

	cpuReg_PC+=2;
	w1 = ((WORD)atariMem[dword_u.vb1]) + ((WORD)cpuReg_Y);
	cpuReg_A &= freddieReadByte( w1+((WORD)atariMem[dword_u.vb1+1])*256 );
	cpuFlag_N = cpuFlag_Z = cpuReg_A;
	return 5+(w1>>8);
}
int opcode_0x32(void)	/* 0x32 - ...				hang		*/
{
	return 20;
}
int opcode_0x33(void)	/* 0x33 - ROL:AND (),Y		8 cycles	*/
{
BYTE cC;
	cpuReg_PC+=2;
	cpuWorkAddress = ((WORD)atariMem[dword_u.vb1]) + ((WORD)atariMem[dword_u.vb1+1])*256 + ((WORD)cpuReg_Y);
	cC = cpuVal>>7; cpuNewVal = (cpuVal<<1) + (cpuFlag_C&1); cpuFlag_C = cC;
	cpuReg_A &= cpuNewVal; cpuFlag_N = cpuFlag_Z = cpuReg_A;
	doWrite = 2;
	return 8;
}
int opcode_0x34(void)	/* 0x34 - NOP2						*/
{
	cpuReg_PC+=2;
	return 8;
}
int opcode_0x35(void)	/* 0x35 - AND ZP,X			4 cycles	*/
{
	cpuReg_PC+=2;
	cpuReg_A &= atariMem[((WORD)dword_u.vb1) + cpuReg_X];
	cpuFlag_N = cpuFlag_Z = cpuReg_A;
	return 4;
}
int opcode_0x36(void)	/* 0x36 - ROL ZP,X			6 cycles	*/
{
BYTE cb,cC; WORD wA;
	cpuReg_PC+=2;
	wA = (WORD)(dword_u.vb1 + cpuReg_X)&0xFF;
	cb = atariMem[wA];
	cC = cb>>7; cb = (cb<<1) + (cpuFlag_C&1); cpuFlag_C = cC; cpuFlag_N = cpuFlag_Z = cb;
	atariMem[wA] = cb;
	return 6;
}
int opcode_0x37(void)	/* 0x37 - ROL:AND ZP,X		6 cycles	*/
{
BYTE cb,cC; WORD wA;
	cpuReg_PC+=2;
	wA = (WORD)(dword_u.vb1 + cpuReg_X)&0xFF;
	cb = atariMem[wA];
	cC = cb>>7; cb = (cb<<1) | (cpuFlag_C&1); cpuFlag_C = cC; cpuReg_A &= cb; cpuFlag_N = cpuFlag_Z = cpuReg_A;
	atariMem[wA] = cb;
	return 6;
}
int opcode_0x38(void)	/* 0x38 - SEC				2 cycles	*/
{
	cpuReg_PC++;
	cpuFlag_C = 1;
	return 2;
}
int opcode_0x39(void)	/* 0x39 - AND ABS,Y			4,5 cycles	*/
{
WORD wA;
	cpuReg_PC+=3;
	wA = dword_u.valW + ((WORD)cpuReg_Y);
	cpuReg_A &= freddieReadByte( wA );
	cpuFlag_N = cpuFlag_Z = cpuReg_A;
	wA = dword_u.valW ^ wA;
	return 4+((wA>>8)&1);
}
int opcode_0x3A(void)	/* 0x3A - NOP1						*/
{
	cpuReg_PC++;
	return 2;
}
int opcode_0x3B(void)	/* 0x3B - ROL:AND ABS,Y		7 cycles	*/
{
BYTE cC;
	cpuReg_PC+=3;
	cpuWorkAddress = dword_u.valW + ((WORD)cpuReg_Y);
	cpuVal = freddieReadByte( cpuWorkAddress );
	cC = cpuVal>>7; cpuNewVal = (cpuVal<<1) | (cpuFlag_C&1); cpuFlag_C = cC; cpuReg_A &= cpuNewVal; cpuFlag_N = cpuFlag_Z = cpuReg_A;
	doWrite = 2;
	return 7;
}
int opcode_0x3C(void)	/* 0x3C - NOP3						*/
{
	cpuReg_PC+=3;
	return 4;
}
int opcode_0x3D(void)	/* 0x3D - AND ABS,X			4,5 cycles	*/
{
WORD wA;
	cpuReg_PC+=3;
	wA = dword_u.valW + ((WORD)cpuReg_X);
	cpuReg_A &= freddieReadByte( wA );
	cpuFlag_N = cpuFlag_Z = cpuReg_A;
	wA = dword_u.valW ^ wA;
	return 4+((wA>>8)&1);
}
int opcode_0x3E(void)	/* 0x3E - ROL ABS,X			7 cycles	*/
{
BYTE cC;
	cpuReg_PC+=3;
	cpuWorkAddress = dword_u.valW + ((WORD)cpuReg_X);
	cpuVal = freddieReadByte( cpuWorkAddress );
	cC = cpuVal>>7; cpuNewVal = (cpuVal<<1) | (cpuFlag_C&1); cpuFlag_C = cC; cpuFlag_N = cpuFlag_Z = cpuNewVal;
	doWrite = 2;
	return 7;
}
int opcode_0x3F(void)	/* 0x3F - ROL:AND ABS,X		7 cycles	*/
{
BYTE cC;
	cpuReg_PC+=3;
	cpuWorkAddress = dword_u.valW + ((WORD)cpuReg_X);
	cpuVal = freddieReadByte( cpuWorkAddress );
	cC = cpuVal>>7; cpuNewVal = (cpuVal<<1) | (cpuFlag_C&1); cpuFlag_C = cC; cpuReg_A &= cpuNewVal; cpuFlag_N = cpuFlag_Z = cpuReg_A;
	doWrite = 2;
	return 7;
}
int opcode_0x40(void)	/* 0x40 - RTI				6 cycles	*/
{
BYTE te;
	cpuReg_PC++;
	cpuReg_S++; te = atariMem[0x100 + cpuReg_S];
	cpuFlag_N = te; cpuFlag_V = (te>>6)&1; cpuFlag_B = (te>>4)&1; cpuFlag_D = (te>>3)&1; cpuFlag_I = (te>>2)&1; cpuFlag_Z = (te&2)^2; cpuFlag_C = te&1;
	cpuReg_S++; cpuReg_PC =  (WORD)atariMem[0x100 + cpuReg_S];
	cpuReg_S++; cpuReg_PC+= ((WORD)atariMem[0x100 + cpuReg_S])*256;
	return 6;
}
int opcode_0x41(void)	/* 0x41 - EOR (,X)			6 cycles	*/
{
BYTE cpuLSB;
WORD cW;
	cpuReg_PC+=2;
	cpuLSB = dword_u.vb1 + cpuReg_X;
	cW = ((WORD)atariMem[ cpuLSB ]) + ((WORD)atariMem[ cpuLSB+1 ])*256;
	cpuReg_A ^= freddieReadByte( cW );
	cpuFlag_N = cpuFlag_Z = cpuReg_A;
	return 6;
}
int opcode_0x42(void)	/* 0x42 - ...				hang		*/
{
	return 20;
}
int opcode_0x43(void)	/* 0x43 - LSR:EOR (,X)		8 cycles	*/
{
BYTE cpuLSB;
	cpuReg_PC+=2;
	cpuLSB = dword_u.vb1 + cpuReg_X;
	cpuWorkAddress = ((WORD)atariMem[ cpuLSB ]) + ((WORD)atariMem[ cpuLSB+1 ])*256;
	cpuVal = freddieReadByte( cpuWorkAddress );
	cpuFlag_C = cpuVal; cpuNewVal = cpuVal >> 1;
	cpuReg_A ^= cpuNewVal; cpuFlag_N = cpuFlag_Z = cpuReg_A;
	doWrite = 2;
	return 8;
}
int opcode_0x44(void)	/* 0x44 - NOP2				3 cycles	*/
{
	cpuReg_PC+=2;
	return 3;
}
int opcode_0x45(void)	/* 0x45 - EOR ZP			3 cycles	*/
{
	cpuReg_PC+=2;
	cpuReg_A ^= atariMem[dword_u.vb1]; cpuFlag_N = cpuFlag_Z = cpuReg_A;
	return 3;
}
int opcode_0x46(void)	/* 0x46 - LSR ZP			5 cycles	*/
{
BYTE cV;
	cpuReg_PC+=2;
	cV = atariMem[dword_u.vb1];
	cpuFlag_C = cV; cV>>=1; cpuFlag_N = cpuFlag_Z = cV;
	atariMem[dword_u.vb1] = cV;
	return 5;
}
int opcode_0x47(void)	/* 0x47 - LSR:EOR ZP		5 cycles	*/
{
BYTE cV;
	cpuReg_PC+=2;
	cV = atariMem[dword_u.vb1];
	cpuFlag_C = cV; cV>>=1; cpuReg_A ^= cV; cpuFlag_N = cpuFlag_Z = cpuReg_A;
	atariMem[dword_u.vb1] = cV;
	return 5;
}
int opcode_0x48(void)	/* 0x48 - PHA				3 cycles	*/
{
	cpuReg_PC++;
	atariMem[0x100 + cpuReg_S] = cpuReg_A; cpuReg_S--;
	return 3;
}
int opcode_0x49(void)	/* 0x49 - EOR #				2 cycles	*/
{
	cpuReg_PC+=2;
	cpuReg_A ^= dword_u.vb1; cpuFlag_N = cpuFlag_Z = cpuReg_A;
	return 2;
}
int opcode_0x4A(void)	/* 0x4A - LSR @				2 cycles	*/
{
	cpuReg_PC++;
	cpuFlag_C = cpuReg_A; cpuReg_A>>=1; cpuFlag_N = cpuFlag_Z = cpuReg_A;
	return 2;
}
int opcode_0x4B(void)	/* 0x4B - ????							*/
{
	cpuReg_PC--;
	return 20;
}
int opcode_0x4C(void)	/* 0x4C - JMP				3 cycles	*/
{
	cpuReg_PC = dword_u.valW;
	return 3;
}
int opcode_0x4D(void)	/* 0x4D - EOR ABS			4 cycles	*/
{
	cpuReg_PC+=3;
	cpuReg_A ^= freddieReadByte( dword_u.valW ); cpuFlag_N = cpuFlag_Z = cpuReg_A;
	return 4;
}
int opcode_0x4E(void)	/* 0x4E - LSR ABS			6 cycles	*/
{
	cpuReg_PC+=3;
	cpuWorkAddress = dword_u.valW;
	cpuVal = freddieReadByte( cpuWorkAddress );
	cpuFlag_C = cpuVal; cpuNewVal = cpuVal >> 1; cpuFlag_N = cpuFlag_Z = cpuNewVal;
	doWrite = 2;
	return 6;
}
int opcode_0x4F(void)	/* 0x4F - LSR:EOR ABS		6 cycles	*/
{
	cpuReg_PC+=3;
	cpuWorkAddress = dword_u.valW;
	cpuVal = freddieReadByte( cpuWorkAddress );
	cpuFlag_C = cpuVal; cpuNewVal = cpuVal >> 1; cpuReg_A ^= cpuNewVal; cpuFlag_N = cpuFlag_Z = cpuReg_A;
	doWrite = 2;
	return 6;
}

int opcode_0x50(void)	/* 0x50 - BVC				2-4 cycles	*/
{
WORD oldPC;

	cpuReg_PC+=2;
	oldPC = cpuReg_PC;
	cpuReg_PC = cpuReg_PC+(WORD)(signed short int)(signed char)(((cpuFlag_V&1)-1)&dword_u.vb1);
	oldPC = oldPC ^ cpuReg_PC;
	return 2+((oldPC>>8)&1)+((cpuFlag_V&1)^1);
}

int opcode_0x51(void)	/* 0x51 - EOR (),Y			5 cycles	*/
{
WORD w1;

	cpuReg_PC+=2;
	w1 = ((WORD)atariMem[dword_u.vb1]) + ((WORD)cpuReg_Y);
	cpuReg_A ^= freddieReadByte( w1+((WORD)atariMem[dword_u.vb1+1])*256 );
	cpuFlag_N = cpuFlag_Z = cpuReg_A;
	return 5+(w1>>8);
}
int opcode_0x52(void)	/* 0x52 - ...				hang		*/
{
	return 20;
}
int opcode_0x53(void)	/* 0x53 - LSR:EOR (),Y		8 cycles	*/
{
	cpuReg_PC+=2;
	cpuWorkAddress = ((WORD)atariMem[dword_u.vb1]) + ((WORD)atariMem[dword_u.vb1+1])*256 + ((WORD)cpuReg_Y);
	cpuVal = freddieReadByte( cpuWorkAddress );
	cpuFlag_C = cpuVal; cpuNewVal = cpuVal>>1; cpuReg_A ^= cpuNewVal; cpuFlag_N = cpuFlag_Z = cpuReg_A;
	doWrite = 2;
	return 8;
}
int opcode_0x54(void)	/* 0x54 - NOP2							*/
{
	cpuReg_PC+=2;
	return 3;
}
int opcode_0x55(void)	/* 0x55 - EOR ZP,X			4 cycles	*/
{
	cpuReg_PC+=2;
	cpuReg_A ^= atariMem[(dword_u.vb1+cpuReg_X)&0xFF]; cpuFlag_N = cpuFlag_Z = cpuReg_A;
	return 4;
}
int opcode_0x56(void)	/* 0x56 - LSR ZP,X			6 cycles	*/
{
BYTE cB; WORD wA;
	cpuReg_PC+=2;
	wA = (dword_u.vb1+cpuReg_X)&0xFF;
	cB = atariMem[wA]; cpuFlag_C = cB; cB>>=1; cpuFlag_N = cpuFlag_Z = cB;
	atariMem[wA] = cB;
	return 6;
}
int opcode_0x57(void)	/* 0x57 - LSR:EOR ZP,X			6 cycles	*/
{
BYTE cB; WORD wA;
	cpuReg_PC+=2;
	wA = (dword_u.vb1+cpuReg_X)&0xFF;
	cB = atariMem[wA]; cpuFlag_C = cB; cB>>=1; cpuReg_A^=cB; cpuFlag_N = cpuFlag_Z = cpuReg_A;
	atariMem[wA] = cB;
	return 6;
}
int opcode_0x58(void)	/* 0x58 - CLI				2 cycles	*/
{
	cpuReg_PC++;
	cpuFlag_I = 0;
	return 2;
}
int opcode_0x59(void)	/* 0x59 - EOR ABS,Y			4,5 cycles	*/
{
WORD wA;
	cpuReg_PC+=3;
	wA = dword_u.valW + ((WORD)cpuReg_Y);
	cpuReg_A ^= freddieReadByte( wA );
	cpuFlag_N = cpuFlag_Z = cpuReg_A;
	wA = dword_u.valW ^ wA;
	return 4+((wA>>8)&1);
}
int opcode_0x5A(void)	/* 0x5A - NOP1				2 cycles	*/
{
	cpuReg_PC++;
	return 2;
}
int opcode_0x5B(void)	/* 0x5B - LSR:EOR ABS,Y		7 cycles	*/
{
	cpuReg_PC+=3;
	cpuWorkAddress = dword_u.valW + ((WORD)cpuReg_Y);
	cpuVal = freddieReadByte( cpuWorkAddress );
	cpuFlag_C = cpuVal; cpuNewVal = cpuVal>>1; cpuReg_A ^= cpuNewVal; cpuFlag_N = cpuFlag_Z = cpuReg_A;
	doWrite = 2;
	return 7;
}
int opcode_0x5C(void)	/* 0x5C - NOP3				7 cycles	*/
{
	cpuReg_PC+=3;
	return 7;
}
int opcode_0x5D(void)	/* 0x5D - EOR ABS,X			4,5 cycles	*/
{
WORD wA;
	cpuReg_PC+=3;
	wA = dword_u.valW + ((WORD)cpuReg_X);
	cpuReg_A ^= freddieReadByte( wA );
	cpuFlag_N = cpuFlag_Z = cpuReg_A;
	wA = dword_u.valW ^ wA;
	return 4+((wA>>8)&1);
}
int opcode_0x5E(void)	/* 0x5E - LSR ABS,X			7 cycles	*/
{
	cpuReg_PC+=3;
	cpuWorkAddress = dword_u.valW + ((WORD)cpuReg_X);
	cpuVal = freddieReadByte( cpuWorkAddress );
	cpuFlag_C = cpuVal; cpuNewVal = cpuVal>>1; cpuFlag_N = cpuFlag_Z = cpuNewVal;
	doWrite = 2;
	return 7;
}
int opcode_0x5F(void)	/* 0x5F - LSR:EOR ABS,X		7 cycles	*/
{
	cpuReg_PC+=3;
	cpuWorkAddress = dword_u.valW + ((WORD)cpuReg_X);
	cpuVal = freddieReadByte( cpuWorkAddress );
	cpuFlag_C = cpuVal; cpuNewVal = cpuVal>>1; cpuReg_A ^= cpuNewVal; cpuFlag_N = cpuFlag_Z = cpuReg_A;
	doWrite = 2;
	return 7;
}

int opcode_0x60(void)	/* 0x60 - RTS				6 cycles	*/
{
	cpuReg_S++; cpuReg_PC =  (WORD)atariMem[0x100 + cpuReg_S];
	cpuReg_S++; cpuReg_PC+= ((WORD)atariMem[0x100 + cpuReg_S])*256 + 1;
	return 6;
}
int opcode_0x61(void)	/* 0x61 - ADC (,X)			6 cycles	*/
{
BYTE cpuLSB;
	cpuReg_PC+=2;
	cpuLSB = dword_u.vb1 + cpuReg_X;
	cpuVal = freddieReadByte( ((WORD)atariMem[ cpuLSB ]) + ((WORD)atariMem[ cpuLSB+1 ])*256 );
	if( cpuFlag_D&1 )
	{
		BYTE al,ah;
		al = (cpuReg_A & 0x0f) + (cpuVal & 0x0f) + (cpuFlag_C&1);
		if (al > 9) al += 6;
		ah = ((cpuReg_A >> 4)&0x0F) + ((cpuVal >> 4)&0x0F); if (al > 0x0f) ah++;
		cpuFlag_N = cpuFlag_Z =  cpuReg_A + cpuVal + (cpuFlag_C&1);
		cpuFlag_V = (((ah << 4) ^ cpuReg_A) & 0x80) && !((cpuReg_A ^ cpuVal) & 0x80) ? 1:0;
		if (ah > 9) ah += 6; cpuFlag_C = (ah > 0x0f) ? 1:0; cpuReg_A = (ah << 4) | (al & 0x0f);
		return 6;
	}
	{ WORD te;
	te = cpuReg_A + cpuVal + (cpuFlag_C&1);
	cpuFlag_C = (BYTE)(te>>8);
	cpuFlag_V = (( ((cpuReg_A^cpuVal)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te; }
	return 6;
}
int opcode_0x62(void)	/* 0x62 - ...				hang		*/
{
	return 20;
}
int opcode_0x63(void)	/* 0x63 - ROR:ADC (,X)		8 cycles	*/
{
BYTE cpuLSB,cC;
	cpuReg_PC+=2;
	cpuLSB = dword_u.vb1 + cpuReg_X;
	cpuWorkAddress = ((WORD)atariMem[ cpuLSB ]) + ((WORD)atariMem[ cpuLSB+1 ])*256;
	cpuVal = freddieReadByte( cpuWorkAddress );
	cC = cpuVal; cpuNewVal = (cpuVal>>1) + (cpuFlag_C<<7); cpuFlag_C = cC;
	doWrite = 2;
	WORD te;
	if( cpuFlag_D&1 )
	{
		BYTE al,ah;
		al = (cpuReg_A & 0x0f) + (cpuNewVal & 0x0f) + (cpuFlag_C&1);
		if (al > 9) al += 6;
		ah = ((cpuReg_A >> 4)&0x0F) + ((cpuNewVal >> 4)&0x0F); if (al > 0x0f) ah++;
		cpuFlag_N = cpuFlag_Z =  cpuReg_A + cpuNewVal + (cpuFlag_C&1);
		cpuFlag_V = (((ah << 4) ^ cpuReg_A) & 0x80) && !((cpuReg_A ^ cpuNewVal) & 0x80) ? 1:0;
		if (ah > 9) ah += 6; cpuFlag_C = (ah > 0x0f) ? 1:0; cpuReg_A = (ah << 4) | (al & 0x0f);
		return 8;
	}
	te = cpuReg_A + cpuNewVal + (cpuFlag_C&1); cpuFlag_C = (BYTE)(te>>8);
	cpuFlag_V = (( ((cpuReg_A^cpuNewVal)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0; cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te;
	return 8;
}
int opcode_0x64(void)	/* 0x64 - NOP2				3 cycles	*/
{
	cpuReg_PC+=2;
	return 3;
}
int opcode_0x65(void)	/* 0x65 - ADC ZP			3 cycles	*/
{
	cpuReg_PC+=2;
	cpuVal = atariMem[dword_u.vb1];
	if( cpuFlag_D&1 )
	{
		BYTE al,ah;
		al = (cpuReg_A & 0x0f) + (cpuVal & 0x0f) + (cpuFlag_C&1);
		if (al > 9) al += 6;
		ah = ((cpuReg_A >> 4)&0x0F) + ((cpuVal >> 4)&0x0F); if (al > 0x0f) ah++;
		cpuFlag_N = cpuFlag_Z =  cpuReg_A + cpuVal + (cpuFlag_C&1);
		cpuFlag_V = (((ah << 4) ^ cpuReg_A) & 0x80) && !((cpuReg_A ^ cpuVal) & 0x80) ? 1:0;
		if (ah > 9) ah += 6; cpuFlag_C = (ah > 0x0f) ? 1:0; cpuReg_A = (ah << 4) | (al & 0x0f);
		return 3;
	}
	{ WORD te;
	te = cpuReg_A + cpuVal + (cpuFlag_C&1);
	cpuFlag_C = (BYTE)(te>>8);
	cpuFlag_V = (( ((cpuReg_A^cpuVal)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te; }
	return 3;
}
int opcode_0x66(void)	/* 0x66 - ROR ZP			5 cycles	*/
{
BYTE cB,cC;
	cpuReg_PC+=2;
	cB = atariMem[dword_u.vb1];
	cC = cB; cB = (cB>>1) + (cpuFlag_C<<7); cpuFlag_C = cC; cpuFlag_N = cpuFlag_Z = cB;
	atariMem[dword_u.vb1] = cB;
	return 5;
}
int opcode_0x67(void)	/* 0x67 - ROR:ADC ZP		5 cycles	*/
{
BYTE cC;
	cpuReg_PC+=2;
	cpuVal = atariMem[dword_u.vb1];
	cC = cpuVal; cpuNewVal = (cpuVal>>1) + (cpuFlag_C<<7); cpuFlag_C = cC;
	atariMem[dword_u.vb1] = cpuVal;
	{ WORD te;
		if( cpuFlag_D&1 )
		{
			BYTE al,ah;
			al = (cpuReg_A & 0x0f) + (cpuNewVal & 0x0f) + (cpuFlag_C&1);
			if (al > 9) al += 6;
			ah = ((cpuReg_A >> 4)&0x0F) + ((cpuNewVal >> 4)&0x0F); if (al > 0x0f) ah++;
			cpuFlag_N = cpuFlag_Z =  cpuReg_A + cpuNewVal + (cpuFlag_C&1);
			cpuFlag_V = (((ah << 4) ^ cpuReg_A) & 0x80) && !((cpuReg_A ^ cpuNewVal) & 0x80) ? 1:0;
			if (ah > 9) ah += 6; cpuFlag_C = (ah > 0x0f) ? 1:0; cpuReg_A = (ah << 4) | (al & 0x0f);
			return 5;
		}
		te = cpuReg_A + cpuNewVal + (cpuFlag_C&1); cpuFlag_C = (BYTE)(te>>8);
		cpuFlag_V = (( ((cpuReg_A^cpuNewVal)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0; cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te;
	}
	return 5;
}
int opcode_0x68(void)	/* 0x68 - PLA				4 cycles	*/
{			
	cpuReg_PC++;
	cpuReg_S++; cpuFlag_N = cpuFlag_Z = cpuReg_A = atariMem[0x100 + cpuReg_S];
	return 4;
}
int opcode_0x69(void)	/* 0x69 - ADC #				2 cycles	*/
{
	cpuReg_PC+=2;
	cpuVal = dword_u.vb1;
	if( cpuFlag_D&1 )
	{
		BYTE al,ah;
		al = (cpuReg_A & 0x0f) + (cpuVal & 0x0f) + (cpuFlag_C&1);
		if (al > 9) al += 6;
		ah = ((cpuReg_A >> 4)&0x0F) + ((cpuVal >> 4)&0x0F); if (al > 0x0f) ah++;
		cpuFlag_N = cpuFlag_Z =  cpuReg_A + cpuVal + (cpuFlag_C&1);
		cpuFlag_V = (((ah << 4) ^ cpuReg_A) & 0x80) && !((cpuReg_A ^ cpuVal) & 0x80) ? 1:0;
		if (ah > 9) ah += 6; cpuFlag_C = (ah > 0x0f) ? 1:0; cpuReg_A = (ah << 4) | (al & 0x0f);
		return 2;
	}
	{ WORD te;
	te = cpuReg_A + cpuVal + (cpuFlag_C&1);
	cpuFlag_C = (BYTE)(te>>8);
	cpuFlag_V = (( ((cpuReg_A^cpuVal)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te; }
	return 2;
}
int opcode_0x6A(void)	/* 0x6A - ROR @				2 cycles	*/
{
BYTE cC;
	cpuReg_PC++;
	cC = cpuReg_A; cpuReg_A = (cpuReg_A>>1) + (cpuFlag_C<<7); cpuFlag_C = cC; cpuFlag_N = cpuFlag_Z = cpuReg_A;
	return 2;
}
int opcode_0x6B(void)	/* 0x6B - ????							*/
{
	return 20;
}
int opcode_0x6C(void)	/* 0x6C - JMP ( )			6 cycles	*/
{
BYTE cpuLSB,cpuMSB;
	cpuLSB = freddieReadByte( dword_u.valW );
	cpuMSB = freddieReadByte( (WORD)((dword_u.vb1+1)&0xFF) + ((WORD)dword_u.vb2)*256 );
	cpuWorkAddress = ((WORD)cpuLSB) + ((WORD)cpuMSB)*256;
	cpuReg_PC = cpuWorkAddress;
	return 6;
}
int opcode_0x6D(void)	/* 0x6D - ADC ABS			4 cycles	*/
{
	cpuReg_PC+=3;
	cpuVal = freddieReadByte( dword_u.valW );
	if( cpuFlag_D&1 )
	{
		BYTE al,ah;
		al = (cpuReg_A & 0x0f) + (cpuVal & 0x0f) + (cpuFlag_C&1);
		if (al > 9) al += 6;
		ah = ((cpuReg_A >> 4)&0x0F) + ((cpuVal >> 4)&0x0F); if (al > 0x0f) ah++;
		cpuFlag_N = cpuFlag_Z =  cpuReg_A + cpuVal + (cpuFlag_C&1);
		cpuFlag_V = (((ah << 4) ^ cpuReg_A) & 0x80) && !((cpuReg_A ^ cpuVal) & 0x80) ? 1:0;
		if (ah > 9) ah += 6; cpuFlag_C = (ah > 0x0f) ? 1:0; cpuReg_A = (ah << 4) | (al & 0x0f);
		return 4;
	}
	{ WORD te;
	te = cpuReg_A + cpuVal + (cpuFlag_C&1);
	cpuFlag_C = (BYTE)(te>>8);
	cpuFlag_V = (( ((cpuReg_A^cpuVal)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te; }
	return 4;
}
int opcode_0x6E(void)	/* 0x6E - ROR ABS			6 cycles	*/
{
BYTE cC;
	cpuReg_PC+=3;
	cpuWorkAddress = dword_u.valW;
	cpuVal = freddieReadByte( cpuWorkAddress );
	cC = cpuVal; cpuNewVal = (cpuVal>>1) + (cpuFlag_C<<7); cpuFlag_C = cC; cpuFlag_N = cpuFlag_Z = cpuNewVal;
	doWrite = 2;
	return 6;
}
int opcode_0x6F(void)	/* 0x6F - ROR:ADC ABS		6 cycles	*/
{
BYTE cC;
	cpuReg_PC+=3;
	cpuWorkAddress = dword_u.valW;
	cpuVal = freddieReadByte( cpuWorkAddress );
	cC = cpuVal; cpuNewVal = (cpuVal>>1) + (cpuFlag_C<<7); cpuFlag_C = cC;
	{ WORD te;
		if( cpuFlag_D&1 )
		{
			BYTE al,ah;
			al = (cpuReg_A & 0x0f) + (cpuNewVal & 0x0f) + (cpuFlag_C&1);
			if (al > 9) al += 6;
			ah = ((cpuReg_A >> 4)&0x0F) + ((cpuNewVal >> 4)&0x0F); if (al > 0x0f) ah++;
			cpuFlag_N = cpuFlag_Z =  cpuReg_A + cpuNewVal + (cpuFlag_C&1);
			cpuFlag_V = (((ah << 4) ^ cpuReg_A) & 0x80) && !((cpuReg_A ^ cpuNewVal) & 0x80) ? 1:0;
			if (ah > 9) ah += 6; cpuFlag_C = (ah > 0x0f) ? 1:0; cpuReg_A = (ah << 4) | (al & 0x0f);
			doWrite = 2;
			return 6;
		}
		te = cpuReg_A + cpuNewVal + (cpuFlag_C&1); cpuFlag_C = (BYTE)(te>>8);
		cpuFlag_V = (( ((cpuReg_A^cpuNewVal)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0; cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te;
	}
	doWrite = 2;
	return 6;
}
int opcode_0x70(void)	/* 0x70 - BVS				2-4 cycles	*/
{
WORD oldPC;
	cpuReg_PC+=2;
	oldPC = cpuReg_PC;
	cpuReg_PC = cpuReg_PC+(WORD)(signed short int)(signed char)((((cpuFlag_V&1)^1)-1)&dword_u.vb1);
	oldPC = oldPC ^ cpuReg_PC;
	return 2+((oldPC>>8)&1)+(cpuFlag_V&1);
}
int opcode_0x71(void)	/* 0x71 - ADC ( ),Y			5,6 cycles	*/
{
WORD w1;

	cpuReg_PC+=2;
	w1 = ((WORD)atariMem[dword_u.vb1]) + ((WORD)cpuReg_Y);
	cpuVal = freddieReadByte( w1+((WORD)atariMem[dword_u.vb1+1])*256 );
	if( cpuFlag_D&1 )
	{
		BYTE al,ah;
		al = (cpuReg_A & 0x0f) + (cpuVal & 0x0f) + (cpuFlag_C&1);
		if (al > 9) al += 6;
		ah = ((cpuReg_A >> 4)&0x0F) + ((cpuVal >> 4)&0x0F); if (al > 0x0f) ah++;
		cpuFlag_N = cpuFlag_Z =  cpuReg_A + cpuVal + (cpuFlag_C&1);
		cpuFlag_V = (((ah << 4) ^ cpuReg_A) & 0x80) && !((cpuReg_A ^ cpuVal) & 0x80) ? 1:0;
		if (ah > 9) ah += 6; cpuFlag_C = (ah > 0x0f) ? 1:0; cpuReg_A = (ah << 4) | (al & 0x0f);
		return 5+(w1>>8);
	}
	{ WORD te;
	te = cpuReg_A + cpuVal + (cpuFlag_C&1);
	cpuFlag_C = (BYTE)(te>>8);
	cpuFlag_V = (( ((cpuReg_A^cpuVal)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te; }
	return 5+(w1>>8);
}
int opcode_0x72(void)	/* 0x72 - ...				hang		*/
{
	return 20;
}
int opcode_0x73(void)	/* 0x73 - ROR:ADC ( ),Y		8 cycles	*/
{
BYTE cC;
	cpuReg_PC+=2;
	cpuWorkAddress = ((WORD)atariMem[dword_u.vb1]) + ((WORD)cpuReg_Y) +((WORD)atariMem[(dword_u.vb1+1)&0xFF])*256;
	cpuVal = freddieReadByte( cpuWorkAddress );
	cC = cpuVal; cpuNewVal = (cpuVal>>1) + (cpuFlag_C<<7); cpuFlag_C = cC;
	doWrite = 2;
	if( cpuFlag_D&1 )
	{
		BYTE al,ah;
		al = (cpuReg_A & 0x0f) + (cpuVal & 0x0f) + (cpuFlag_C&1);
		if (al > 9) al += 6;
		ah = ((cpuReg_A >> 4)&0x0F) + ((cpuVal >> 4)&0x0F); if (al > 0x0f) ah++;
		cpuFlag_N = cpuFlag_Z =  cpuReg_A + cpuVal + (cpuFlag_C&1);
		cpuFlag_V = (((ah << 4) ^ cpuReg_A) & 0x80) && !((cpuReg_A ^ cpuVal) & 0x80) ? 1:0;
		if (ah > 9) ah += 6; cpuFlag_C = (ah > 0x0f) ? 1:0; cpuReg_A = (ah << 4) | (al & 0x0f);
		return 8;
	}
	{ WORD te;
	te = cpuReg_A + cpuVal + (cpuFlag_C&1);
	cpuFlag_C = (BYTE)(te>>8);
	cpuFlag_V = (( ((cpuReg_A^cpuVal)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te; }
	return 8;
}
int opcode_0x74(void)	/* 0x74 - NOP2				4 cycles	*/
{
	return 4;
}
int opcode_0x75(void)	/* 0x75 - ADC ZP,X			4 cycles	*/
{
WORD wA;
	cpuReg_PC+=2;
	wA = (WORD)(dword_u.vb1 + cpuReg_X)&0xFF;
	cpuVal = atariMem[wA];
	if( cpuFlag_D&1 )
	{
		BYTE al,ah;
		al = (cpuReg_A & 0x0f) + (cpuVal & 0x0f) + (cpuFlag_C&1);
		if (al > 9) al += 6;
		ah = ((cpuReg_A >> 4)&0x0F) + ((cpuVal >> 4)&0x0F); if (al > 0x0f) ah++;
		cpuFlag_N = cpuFlag_Z =  cpuReg_A + cpuVal + (cpuFlag_C&1);
		cpuFlag_V = (((ah << 4) ^ cpuReg_A) & 0x80) && !((cpuReg_A ^ cpuVal) & 0x80) ? 1:0;
		if (ah > 9) ah += 6; cpuFlag_C = (ah > 0x0f) ? 1:0; cpuReg_A = (ah << 4) | (al & 0x0f);
		return 4;
	}
	{ WORD te;
	te = cpuReg_A + cpuVal + (cpuFlag_C&1);
	cpuFlag_C = (BYTE)(te>>8);
	cpuFlag_V = (( ((cpuReg_A^cpuVal)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te; }
	return 4;
}
int opcode_0x76(void)	/* 0x76 - ROR ZP,X			6 cycles	*/
{
WORD wA;
BYTE cC,cV;
	cpuReg_PC+=2;
	wA = (WORD)(dword_u.vb1 + cpuReg_X)&0xFF;
	cV = atariMem[wA];
	cC = cV; cV = (cV>>1) + (cpuFlag_C<<7); cpuFlag_C = cC; cpuFlag_N = cpuFlag_Z = cV;
	atariMem[wA] = cV;
	return 6;
}
int opcode_0x77(void)	/* 0x77 - ROR:ADC ZP,X		6 cycles	*/
{
WORD wA;
BYTE cC;
	cpuReg_PC+=2;
	wA = (WORD)(dword_u.vb1 + cpuReg_X)&0xFF;
	cpuVal = atariMem[wA];
	cC = cpuVal; cpuNewVal = (cpuVal>>1) + (cpuFlag_C<<7); cpuFlag_C = cC;
	atariMem[wA] = cpuVal;
	if( cpuFlag_D&1 )
	{
		BYTE al,ah;
		al = (cpuReg_A & 0x0f) + (cpuVal & 0x0f) + (cpuFlag_C&1);
		if (al > 9) al += 6;
		ah = ((cpuReg_A >> 4)&0x0F) + ((cpuVal >> 4)&0x0F); if (al > 0x0f) ah++;
		cpuFlag_N = cpuFlag_Z =  cpuReg_A + cpuVal + (cpuFlag_C&1);
		cpuFlag_V = (((ah << 4) ^ cpuReg_A) & 0x80) && !((cpuReg_A ^ cpuVal) & 0x80) ? 1:0;
		if (ah > 9) ah += 6; cpuFlag_C = (ah > 0x0f) ? 1:0; cpuReg_A = (ah << 4) | (al & 0x0f);
		return 6;
	}
	{ WORD te;
	te = cpuReg_A + cpuVal + (cpuFlag_C&1);
	cpuFlag_C = (BYTE)(te>>8);
	cpuFlag_V = (( ((cpuReg_A^cpuVal)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te; }
	return 6;
}
int opcode_0x78(void)	/* 0x78 - SEI				2 cycles	*/
{
	cpuReg_PC++;
	cpuFlag_I = 1;
	return 2;
}
int opcode_0x79(void)	/* 0x79 - ADC ABS,Y			4,5 cycles	*/
{
WORD wA;
	cpuReg_PC+=3;
	wA = ((WORD)dword_u.vb1) + ((WORD)cpuReg_Y);
	cpuVal = freddieReadByte( wA + ((WORD)dword_u.vb2)*256);
	if( cpuFlag_D&1 )
	{
		BYTE al,ah;
		al = (cpuReg_A & 0x0f) + (cpuVal & 0x0f) + (cpuFlag_C&1);
		if (al > 9) al += 6;
		ah = ((cpuReg_A >> 4)&0x0F) + ((cpuVal >> 4)&0x0F); if (al > 0x0f) ah++;
		cpuFlag_N = cpuFlag_Z =  cpuReg_A + cpuVal + (cpuFlag_C&1);
		cpuFlag_V = (((ah << 4) ^ cpuReg_A) & 0x80) && !((cpuReg_A ^ cpuVal) & 0x80) ? 1:0;
		if (ah > 9) ah += 6; cpuFlag_C = (ah > 0x0f) ? 1:0; cpuReg_A = (ah << 4) | (al & 0x0f);
		return 4+(wA>>8);
	}
	{ WORD te;
	te = cpuReg_A + cpuVal + (cpuFlag_C&1);
	cpuFlag_C = (BYTE)(te>>8);
	cpuFlag_V = (( ((cpuReg_A^cpuVal)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te; }
	return 4+(wA>>8);
}
int opcode_0x7A(void)	/* 0x7A - NOP1				2 cycles	*/
{
	cpuReg_PC++;
	return 2;
}
int opcode_0x7B(void)	/* 0x7B - ROR:ADC ABS,Y		6 cycles	*/
{
BYTE cC;
	cpuReg_PC+=3;
	cpuWorkAddress = ((WORD)dword_u.valW) + ((WORD)cpuReg_X);
	cpuVal = freddieReadByte( cpuWorkAddress );
	cC = cpuVal; cpuNewVal = (cpuVal>>1) + (cpuFlag_C<<7); cpuFlag_C = cC;
	doWrite = 2;
	if( cpuFlag_D&1 )
	{
		BYTE al,ah;
		al = (cpuReg_A & 0x0f) + (cpuVal & 0x0f) + (cpuFlag_C&1);
		if (al > 9) al += 6;
		ah = ((cpuReg_A >> 4)&0x0F) + ((cpuVal >> 4)&0x0F); if (al > 0x0f) ah++;
		cpuFlag_N = cpuFlag_Z =  cpuReg_A + cpuVal + (cpuFlag_C&1);
		cpuFlag_V = (((ah << 4) ^ cpuReg_A) & 0x80) && !((cpuReg_A ^ cpuVal) & 0x80) ? 1:0;
		if (ah > 9) ah += 6; cpuFlag_C = (ah > 0x0f) ? 1:0; cpuReg_A = (ah << 4) | (al & 0x0f);
		doWrite = 2;
		return 6;
	}
	{ WORD te;
	te = cpuReg_A + cpuVal + (cpuFlag_C&1);
	cpuFlag_C = (BYTE)(te>>8);
	cpuFlag_V = (( ((cpuReg_A^cpuVal)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te; }
	doWrite = 2;
	return 6;
}
int opcode_0x7C(void)	/* 0x7C - NOP3				7 cycles	*/
{
	cpuReg_PC+=3;
	return 7;
}
int opcode_0x7D(void)	/* 0x7D - ADC ABS,X			4,5 cycles	*/
{
WORD wA;
	cpuReg_PC+=3;
	wA = ((WORD)dword_u.vb1) + ((WORD)cpuReg_X);
	cpuVal = freddieReadByte( wA + ((WORD)dword_u.vb2)*256);
	if( cpuFlag_D&1 )
	{
		BYTE al,ah;
		al = (cpuReg_A & 0x0f) + (cpuVal & 0x0f) + (cpuFlag_C&1);
		if (al > 9) al += 6;
		ah = ((cpuReg_A >> 4)&0x0F) + ((cpuVal >> 4)&0x0F); if (al > 0x0f) ah++;
		cpuFlag_N = cpuFlag_Z =  cpuReg_A + cpuVal + (cpuFlag_C&1);
		cpuFlag_V = (((ah << 4) ^ cpuReg_A) & 0x80) && !((cpuReg_A ^ cpuVal) & 0x80) ? 1:0;
		if (ah > 9) ah += 6; cpuFlag_C = (ah > 0x0f) ? 1:0; cpuReg_A = (ah << 4) | (al & 0x0f);
		return 4+(wA>>8);
	}
	{ WORD te;
	te = cpuReg_A + cpuVal + (cpuFlag_C&1);
	cpuFlag_C = (BYTE)(te>>8);
	cpuFlag_V = (( ((cpuReg_A^cpuVal)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te; }
	return 4+(wA>>8);
}
int opcode_0x7E(void)	/* 0x7E - ROR ABS,X			7 cycles	*/
{
BYTE cC;
	cpuReg_PC+=3;
	cpuWorkAddress = ((WORD)dword_u.valW) + ((WORD)cpuReg_X);
	cpuVal = freddieReadByte( cpuWorkAddress );
	cC = cpuVal; cpuNewVal = (cpuVal>>1) + (cpuFlag_C<<7); cpuFlag_C = cC; cpuFlag_N = cpuFlag_Z = cpuNewVal;
	doWrite = 2;
	return 7;
}
int opcode_0x7F(void)	/* 0x7F - ROR:ADC ABS,X		7 cycles	*/
{
BYTE cC;
	cpuReg_PC+=3;
	cpuWorkAddress = ((WORD)dword_u.valW) + ((WORD)cpuReg_X);
	cpuVal = freddieReadByte( cpuWorkAddress );
	cC = cpuVal; cpuNewVal = (cpuVal>>1) + (cpuFlag_C<<7); cpuFlag_C = cC;
	doWrite = 2;
	{ WORD te;
		if( cpuFlag_D&1 )
		{
			BYTE al,ah;
			al = (cpuReg_A & 0x0f) + (cpuNewVal & 0x0f) + (cpuFlag_C&1);
			if (al > 9) al += 6;
			ah = ((cpuReg_A >> 4)&0x0F) + ((cpuNewVal >> 4)&0x0F); if (al > 0x0f) ah++;
			cpuFlag_N = cpuFlag_Z =  cpuReg_A + cpuNewVal + (cpuFlag_C&1);
			cpuFlag_V = (((ah << 4) ^ cpuReg_A) & 0x80) && !((cpuReg_A ^ cpuNewVal) & 0x80) ? 1:0;
			if (ah > 9) ah += 6; cpuFlag_C = (ah > 0x0f) ? 1:0; cpuReg_A = (ah << 4) | (al & 0x0f);
			return 7;
		}
		te = cpuReg_A + cpuNewVal + (cpuFlag_C&1); cpuFlag_C = (BYTE)(te>>8);
		cpuFlag_V = (( ((cpuReg_A^cpuNewVal)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0; cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te;
	}
	return 7;
}

int opcode_0x80(void)	/* 0x80 - NOP2				2 cycles	*/
{
	cpuReg_PC+=2;
	return 2;
}
int opcode_0x81(void)	/* 0x81 - STA ( ,X)			6 cycles	*/
{
BYTE cpuLSB;
	cpuReg_PC+=2;
	cpuLSB = (dword_u.vb1 + cpuReg_X)&0xFF;
	cpuWorkAddress = ((WORD)atariMem[ cpuLSB ]) + ((WORD)atariMem[ (cpuLSB+1)&0xFF ])*256;
	cpuNewVal = cpuReg_A;
	doWrite = 1;
	return 6;
}
int opcode_0x82(void)	/* 0x82 - NOP2				2 cycles	*/
{
	cpuReg_PC+=2;
	return 2;
}
int opcode_0x83(void)	/* 0x83 - STORE(A&X)	(,X)	6 cycles	*/
{
BYTE cpuLSB;
	cpuReg_PC+=2;
	cpuLSB = (dword_u.vb1 + cpuReg_X)&0xFF;
	cpuWorkAddress = ((WORD)atariMem[ cpuLSB ]) + ((WORD)atariMem[ (cpuLSB+1)&0xFF ])*256;
	cpuNewVal = cpuReg_A&cpuReg_X;
	doWrite = 1;
	return 6;
}
int opcode_0x84(void)	/* 0x84 - STY ZP				3 cycles	*/
{
	cpuReg_PC+=2;
	atariMem[dword_u.vb1] = cpuReg_Y;
	return 3;
}
int opcode_0x85(void)	/* 0x85 - STA ZP				3 cycles	*/
{
	cpuReg_PC+=2;
	atariMem[dword_u.vb1] = cpuReg_A;
	return 3;
}
int opcode_0x86(void)	/* 0x86 - STX ZP				3 cycles	*/
{
	cpuReg_PC+=2;
	atariMem[dword_u.vb1] = cpuReg_X;
	return 3;
}
int opcode_0x87(void)	/* 0x87 - STORE(A&X)	ZP		3 cycles	*/
{
	cpuReg_PC+=2;
	atariMem[dword_u.vb1] = cpuReg_A&cpuReg_X;
	return 3;
}
int opcode_0x88(void)	/* 0x88 - DEY				2 cycles	*/
{
	cpuReg_PC++;
	cpuReg_Y--;
	cpuFlag_N = cpuFlag_Z = cpuReg_Y;
	return 2;
}
int opcode_0x89(void)	/* 0x89 - NOP2				2 cycles	*/
{
	cpuReg_PC+=2;
	return 2;
}
int opcode_0x8A(void)	/* 0x8A - TXA				2 cycles	*/
{
	cpuReg_PC+=1;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = cpuReg_X;
	return 2;
}
int opcode_0x8B(void)	/* 0x8B - TXA:AND #			2 cycles	*/
{
	cpuReg_PC+=2;
	cpuReg_A = cpuReg_X;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = cpuReg_A & dword_u.vb1;
	return 2;
}
int opcode_0x8C(void)	/* 0x8C - STY ABS			4 cycles	*/
{
	cpuReg_PC+=3;
	cpuWorkAddress = dword_u.valW;
	cpuNewVal = cpuReg_Y;
	doWrite = 1;
	return 4;
}
int opcode_0x8D(void)	/* 0x8D - STA ABS			4 cycles	*/
{
	cpuReg_PC+=3;
	cpuWorkAddress = dword_u.valW;
	cpuNewVal = cpuReg_A;
	doWrite = 1;
	return 4;
}
int opcode_0x8E(void)	/* 0x8E - STX ABS			4 cycles	*/
{
	cpuReg_PC+=3;
	cpuWorkAddress = dword_u.valW;
	cpuNewVal = cpuReg_X;
	doWrite = 1;
	return 4;
}
int opcode_0x8F(void)	/* 0x8F - STORE(A&X)	ABS		4 cycles	*/
{
	cpuReg_PC+=3;
	cpuWorkAddress = dword_u.valW;
	cpuNewVal = cpuReg_A&cpuReg_X;
	doWrite = 1;
	return 4;
}
int opcode_0x90(void)	/* 0x90 - BCC				2-4 cycles	*/
{
WORD oldPC;
	cpuReg_PC+=2;
	oldPC = cpuReg_PC;
	cpuReg_PC = cpuReg_PC+(WORD)(signed short int)(signed char)((((cpuFlag_C&1))-1)&dword_u.vb1);
	oldPC = oldPC ^ cpuReg_PC;
	return 2+((oldPC>>8)&1)+((cpuFlag_C&1)^1);
}
int opcode_0x91(void)	/* 0x91 - STA ( ),Y			6 cycles	*/
{
	cpuReg_PC+=2;
	cpuWorkAddress = ((WORD)atariMem[ dword_u.vb1 ]) + ((WORD)atariMem[ (dword_u.vb1+1)&0xFF ])*256 + ((WORD)cpuReg_Y);
	cpuNewVal = cpuReg_A;
	doWrite = 1;
	return 6;
}
int opcode_0x92(void)	/* 0x92 - ...				hang		*/
{
	return 20;
}
int opcode_0x93(void)	/* 0x93 - STORE(A&X)	(),Y	4,5 cycles	*/
{
	cpuReg_PC+=2;
	cpuWorkAddress = ((WORD)atariMem[ dword_u.vb1 ]) + ((WORD)atariMem[ (dword_u.vb1+1)&0xFF ])*256 + ((WORD)cpuReg_Y);
	cpuNewVal = cpuReg_A&cpuReg_X;
	doWrite = 1;
	return 6;
}
int opcode_0x94(void)	/* 0x94 - STY ZP,X			4 cycles	*/
{
	cpuReg_PC+=2;
	atariMem[(dword_u.vb1+cpuReg_X)&0xFF] = cpuReg_Y;
	return 4;
}
int opcode_0x95(void)	/* 0x95 - STA ZP,X			4 cycles	*/
{
	cpuReg_PC+=2;
	atariMem[(dword_u.vb1+cpuReg_X)&0xFF] = cpuReg_A;
	return 4;
}
int opcode_0x96(void)	/* 0x96 - STX ZP,Y			4 cycles	*/
{
	cpuReg_PC+=2;
	atariMem[(dword_u.vb1+cpuReg_Y)&0xFF] = cpuReg_X;
	return 4;
}
int opcode_0x97(void)	/* 0x97 - STORE(A&X)	ZP,Y	4 cycles	*/
{
	cpuReg_PC+=2;
	atariMem[(dword_u.vb1+cpuReg_Y)&0xFF] = cpuReg_A&cpuReg_X;
	return 4;
}
int opcode_0x98(void)	/* 0x98 - TYA				2 cycles	*/
{
	cpuReg_PC++;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = cpuReg_Y;
	return 2;
}
int opcode_0x99(void)	/* 0x99 - STA ABS,Y			5 cycles	*/
{
	cpuReg_PC+=3;
	cpuWorkAddress = dword_u.valW + ((WORD)cpuReg_Y);
	cpuNewVal = cpuReg_A;
	doWrite = 1;
	return 5;
}
int opcode_0x9A(void)	/* 0x9A - TXS				2 cycles	*/
{
	cpuReg_PC++;
	cpuReg_S = cpuReg_X;
	return 2;
}
int opcode_0x9B(void)	/* 0x9B - ????							*/
{
	return 20;
}
int opcode_0x9C(void)	/* 0x9C - ????							*/
{
	return 20;
}
int opcode_0x9D(void)	/* 0x9D - STA ABS,X			5 cycles	*/
{
	cpuReg_PC+=3;
	cpuWorkAddress = dword_u.valW + ((WORD)cpuReg_X);
	cpuNewVal = cpuReg_A;
	doWrite = 1;
	return 5;
}
int opcode_0x9E(void)	/* 0x9E - ????							*/
{
	return 20;
}
int opcode_0x9F(void)	/* 0x9F - ????							*/
{
	return 20;
}
int opcode_0xA0(void)	/* 0xA0 - LDY #				2 cycles	*/
{
	cpuReg_PC+=2;
	cpuFlag_N = cpuFlag_Z = cpuReg_Y = dword_u.vb1;
	return 2;
}
int opcode_0xA1(void)	/* 0xA1 - LDA (,X)			6 cycles	*/
{
WORD wA; BYTE cB;
	cpuReg_PC+=2;
	wA = (dword_u.vb1+cpuReg_X)&0xFF;
	cB = freddieReadByte( ((WORD)atariMem[wA]) + ((WORD)atariMem[(wA+1)&0xFF])*256 );
	cpuFlag_N = cpuFlag_Z = cpuReg_A = cB;
	return 6;
}
int opcode_0xA2(void)	/* 0xA2 - LDX #				2 cycles	*/
{
	cpuReg_PC+=2;
	cpuFlag_N = cpuFlag_Z = cpuReg_X = dword_u.vb1;
	return 2;
}
int opcode_0xA3(void)	/* 0xA3 - LDA:TAX (,X)		6 cycles	*/
{
WORD wA; BYTE cB;
	cpuReg_PC+=2;
	wA = (dword_u.vb1+cpuReg_X)&0xFF;
	cB = freddieReadByte( ((WORD)atariMem[wA]) + ((WORD)atariMem[(wA+1)&0xFF])*256 );
	cpuFlag_N = cpuFlag_Z = cpuReg_A = cpuReg_X = cB;
	return 6;
}
int opcode_0xA4(void)	/* 0xA4 - LDY ZP				3 cycles	*/
{
	cpuReg_PC+=2;
	cpuFlag_N = cpuFlag_Z = cpuReg_Y = atariMem[dword_u.vb1];
	return 3;
}
int opcode_0xA5(void)	/* 0xA5 - LDA ZP				3 cycles	*/
{
	cpuReg_PC+=2;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = atariMem[dword_u.vb1];
	return 3;
}
int opcode_0xA6(void)	/* 0xA6 - LDX ZP				3 cycles	*/
{
	cpuReg_PC+=2;
	cpuFlag_N = cpuFlag_Z = cpuReg_X = atariMem[dword_u.vb1];
	return 3;
}
int opcode_0xA7(void)	/* 0xA7 - LDA:TAX ZP			3 cycles	*/
{
	cpuReg_PC+=2;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = cpuReg_X = atariMem[dword_u.vb1];
	return 3;
}
int opcode_0xA8(void)	/* 0xA8 - TAY				2 cycles	*/
{
	cpuReg_PC++;
	cpuFlag_N = cpuFlag_Z = cpuReg_Y = cpuReg_A;
	return 2;
}
int opcode_0xA9(void)	/* 0xA9 - LDA #				2 cycles	*/
{
	cpuReg_PC+=2;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = dword_u.vb1;
	return 2;
}
int opcode_0xAA(void)	/* 0xAA - TAX				2 cycles	*/
{
	cpuReg_PC++;
	cpuFlag_N = cpuFlag_Z = cpuReg_X = cpuReg_A;
	return 2;
}
int opcode_0xAB(void)	/* 0xAB - AND #:TAX			2 cycles	*/
{
	cpuReg_PC+=2;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = cpuReg_X = cpuReg_A & dword_u.vb1;
	return 2;
}
int opcode_0xAC(void)	/* 0xAC - LDY ABS			4 cycles	*/
{
	cpuReg_PC+=3;
	cpuFlag_N = cpuFlag_Z = cpuReg_Y = freddieReadByte( dword_u.valW );
	return 4;
}
int opcode_0xAD(void)	/* 0xAD - LDA ABS			4 cycles	*/
{
	cpuReg_PC+=3;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = freddieReadByte( dword_u.valW );
	return 4;
}
int opcode_0xAE(void)	/* 0xAE - LDX ABS			4 cycles	*/
{
	cpuReg_PC+=3;
	cpuFlag_N = cpuFlag_Z = cpuReg_X = freddieReadByte( dword_u.valW );
	return 4;
}
int opcode_0xAF(void)	/* 0xAF - LDA:TAX ABS		4 cycles	*/
{
	cpuReg_PC+=3;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = cpuReg_X = freddieReadByte( dword_u.valW );
	return 4;
}
int opcode_0xB0(void)	/* 0xB0 - BCS				2-4 cycles	*/
{
WORD oldPC;
	cpuReg_PC+=2;
	oldPC = cpuReg_PC;
	cpuReg_PC = cpuReg_PC+(WORD)(signed short int)(signed char)((((cpuFlag_C&1)^1)-1)&dword_u.vb1);
	oldPC = oldPC ^ cpuReg_PC;
	return 2+((oldPC>>8)&1)+((cpuFlag_C&1));
}
int opcode_0xB1(void)	/* 0xB1 - LDA ( ),Y			5,6 cycles	*/
{
WORD wA;
	cpuReg_PC+=2;
	wA = ((WORD)atariMem[ dword_u.vb1 ]) + ((WORD)cpuReg_Y);
	cpuFlag_N = cpuFlag_Z = cpuReg_A = freddieReadByte( ((WORD)atariMem[ (dword_u.vb1+1)&0xFF ])*256 + wA );
	return 5+(wA>>8);
}
int opcode_0xB2(void)	/* 0xB2 - ...				hang		*/
{
	return 20;
}
int opcode_0xB3(void)	/* 0xB3 - LDA:TAX ( ),Y		5,6 cycles	*/
{
WORD wA;
	cpuReg_PC+=2;
	wA = ((WORD)atariMem[ dword_u.vb1 ]) + ((WORD)cpuReg_Y);
	cpuFlag_N = cpuFlag_Z = cpuReg_A = cpuReg_X = freddieReadByte( ((WORD)atariMem[ (dword_u.vb1+1)&0xFF ])*256 + wA );
	return 5+(wA>>8);
}
int opcode_0xB4(void)	/* 0xB4 - LDY ZP,X			4 cycles	*/
{
	cpuReg_PC+=2;
	cpuFlag_N = cpuFlag_Z = cpuReg_Y = atariMem[(dword_u.vb1+cpuReg_X)&0xFF];
	return 4;
}
int opcode_0xB5(void)	/* 0xB5 - LDA ZP,X			4 cycles	*/
{
	cpuReg_PC+=2;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = atariMem[(dword_u.vb1+cpuReg_X)&0xFF];
	return 4;
}
int opcode_0xB6(void)	/* 0xB6 - LDX ZP,Y			4 cycles	*/
{
	cpuReg_PC+=2;
	cpuFlag_N = cpuFlag_Z = cpuReg_X = atariMem[(dword_u.vb1+cpuReg_Y)&0xFF];
	return 4;
}
int opcode_0xB7(void)	/* 0xB7 - LDA:TAX ZP,Y		4 cycles	*/
{
	cpuReg_PC+=2;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = cpuReg_X = atariMem[(dword_u.vb1+cpuReg_Y)&0xFF];
	return 4;
}
int opcode_0xB8(void)	/* 0xB8 - CLV				2 cycles	*/
{
	cpuReg_PC++;
	cpuFlag_V = 0;
	return 2;
}
int opcode_0xB9(void)	/* 0xB9 - LDA ABS,Y			4,5 cycles	*/
{
WORD wA;
	cpuReg_PC+=3;
	wA = ((WORD)dword_u.vb1)+((WORD)cpuReg_Y);
	cpuFlag_N = cpuFlag_Z = cpuReg_A = freddieReadByte( ((WORD)dword_u.vb2)*256 + wA );
	return 4+(wA>>8);
}
int opcode_0xBA(void)	/* 0xBA - TSX				2 cycles	*/
{
	cpuReg_PC++;
	cpuFlag_N = cpuFlag_Z = cpuReg_X = cpuReg_S;
	return 2;
}
int opcode_0xBB(void)	/* 0xBB - ????							*/
{
	return 20;
}
int opcode_0xBC(void)	/* 0xBC - LDY ABS,X			4,5 cycles	*/
{
WORD wA;
	cpuReg_PC+=3;
	wA = ((WORD)dword_u.vb1)+((WORD)cpuReg_X);
	cpuFlag_N = cpuFlag_Z = cpuReg_Y = freddieReadByte( ((WORD)dword_u.vb2)*256 + wA );
	return 4;
}
int opcode_0xBD(void)	/* 0xBD - LDA ABS,X			4,5 cycles	*/
{
WORD wA;
	cpuReg_PC+=3;
	wA = ((WORD)dword_u.vb1)+((WORD)cpuReg_X);
	cpuFlag_N = cpuFlag_Z = cpuReg_A = freddieReadByte( ((WORD)dword_u.vb2)*256 + wA );
	return 4+(wA>>8);
}
int opcode_0xBE(void)	/* 0xBE - LDX ABS,Y			4,5 cycles	*/
{
WORD wA;
	cpuReg_PC+=3;
	wA = ((WORD)dword_u.vb1)+((WORD)cpuReg_Y);
	cpuFlag_N = cpuFlag_Z = cpuReg_X = freddieReadByte( ((WORD)dword_u.vb2)*256 + wA );
	return 4+(wA>>8);
}
int opcode_0xBF(void)	/* 0xBF - LDA:TAX ABS,Y		4,5 cycles	*/
{
WORD wA;
	cpuReg_PC+=3;
	wA = ((WORD)dword_u.vb1)+((WORD)cpuReg_Y);
	cpuFlag_N = cpuFlag_Z = cpuReg_X = cpuReg_A = freddieReadByte( ((WORD)dword_u.vb2)*256 + wA );
	return 4+(wA>>8);
}
int opcode_0xC0(void)	/* 0xC0 - CPY #				2 cycles	*/
{
	cpuReg_PC+=2;
	cpuVal = dword_u.vb1 ^ 255;
	{ int cpuIntValue2;
	cpuIntValue2 = ((int)cpuReg_Y) + ((int)cpuVal) + 1;
	cpuFlag_N = cpuFlag_Z = (BYTE)cpuIntValue2; cpuFlag_C = (BYTE)(cpuIntValue2>>8);
	cpuFlag_V = (( ((cpuReg_Y^cpuVal)^0x80) & (cpuReg_Y^cpuIntValue2) & 0x80))&0x80 ? 1:0;
	return 2; }
}
int opcode_0xC1(void)	/* 0xC1 - CMP (,X)			6 cycles	*/
{
WORD wA;
	cpuReg_PC+=2;
	wA = (dword_u.vb1+cpuReg_X)&0xFF;
	cpuVal = freddieReadByte( ((WORD)atariMem[wA]) + ((WORD)atariMem[(wA+1)&0xFF])*256 );
	cpuVal^=255;
	{ int cpuIntValue2;
	cpuIntValue2 = ((int)cpuReg_A) + ((int)cpuVal) + 1;
	cpuFlag_N = cpuFlag_Z = (BYTE)cpuIntValue2; cpuFlag_C = (BYTE)(cpuIntValue2>>8);
	cpuFlag_V = (( ((cpuReg_A^cpuVal)^0x80) & (cpuReg_A^cpuIntValue2) & 0x80))&0x80 ? 1:0;
	return 6; }
}
int opcode_0xC2(void)	/* 0xC2 - NOP2				2 cycles	*/
{
	cpuReg_PC+=2;
	return 2;
}
int opcode_0xC3(void)	/* 0xC3 - DEC:CMP (,X)		8 cycles	*/
{
WORD wA;
	cpuReg_PC+=2;
	wA = (dword_u.vb1+cpuReg_X)&0xFF;
	cpuWorkAddress = ((WORD)atariMem[wA]) + ((WORD)atariMem[(wA+1)&0xFF])*256;
	cpuVal = freddieReadByte( cpuWorkAddress );
	cpuNewVal = cpuVal-1;
	{ int cpuIntValue2;
	cpuIntValue2 = ((int)cpuReg_A) + ((int)(cpuNewVal^255)) + 1;
	cpuFlag_N = cpuFlag_Z = (BYTE)cpuIntValue2; cpuFlag_C = (BYTE)(cpuIntValue2>>8);
	cpuFlag_V = (( ((cpuReg_A^cpuNewVal^255)^0x80) & (cpuReg_A^cpuIntValue2) & 0x80))&0x80 ? 1:0;
	doWrite = 2;
	return 8; }
}
int opcode_0xC4(void)	/* 0xC4 - CPY ZP				3 cycles	*/
{
	cpuReg_PC+=2;
	cpuVal = atariMem[dword_u.vb1] ^ 255;
	{ int cpuIntValue2;
	cpuIntValue2 = ((int)cpuReg_Y) + ((int)cpuVal) + 1;
	cpuFlag_N = cpuFlag_Z = (BYTE)cpuIntValue2; cpuFlag_C = (BYTE)(cpuIntValue2>>8);
	cpuFlag_V = (( ((cpuReg_Y^cpuVal)^0x80) & (cpuReg_Y^cpuIntValue2) & 0x80))&0x80 ? 1:0;
	return 3; }
}
int opcode_0xC5(void)	/* 0xC5 - CMP ZP				3 cycles	*/
{
	cpuReg_PC+=2;
	cpuVal = atariMem[dword_u.vb1] ^ 255;
	{ int cpuIntValue2;
	cpuIntValue2 = ((int)cpuReg_A) + ((int)cpuVal) + 1;
	cpuFlag_N = cpuFlag_Z = (BYTE)cpuIntValue2; cpuFlag_C = (BYTE)(cpuIntValue2>>8);
	cpuFlag_V = (( ((cpuReg_A^cpuVal)^0x80) & (cpuReg_A^cpuIntValue2) & 0x80))&0x80 ? 1:0;
	return 3; }
}
int opcode_0xC6(void)	/* 0xC6 - DEC ZP				5 cycles	*/
{
	cpuReg_PC+=2;
	cpuVal = atariMem[dword_u.vb1]-1;
	atariMem[dword_u.vb1] = cpuVal;
	cpuFlag_N = cpuFlag_Z = cpuVal;
	return 5;
}
int opcode_0xC7(void)	/* 0xC7 - DEC:CMP ZP			5 cycles	*/
{
	cpuReg_PC+=2;
	cpuVal = atariMem[dword_u.vb1]-1;
	atariMem[dword_u.vb1] = cpuVal;
	{ int cpuIntValue2;
	cpuIntValue2 = ((int)cpuReg_A) + ((int)(cpuVal^255)) + 1;
	cpuFlag_N = cpuFlag_Z = (BYTE)cpuIntValue2; cpuFlag_C = (BYTE)(cpuIntValue2>>8);
	cpuFlag_V = (( ((cpuReg_A^cpuVal^255)^0x80) & (cpuReg_A^cpuIntValue2) & 0x80))&0x80 ? 1:0;
	return 8; }
}
int opcode_0xC8(void)	/* 0xC8 - INY				2 cycles	*/
{
	cpuReg_PC++;
	cpuFlag_N = cpuFlag_Z = cpuReg_Y = cpuReg_Y+1;
	return 2;
}
int opcode_0xC9(void)	/* 0xC9 - CMP #				2 cycles	*/
{
	cpuReg_PC+=2;
	cpuVal = dword_u.vb1 ^ 255;
	{ int cpuIntValue2;
	cpuIntValue2 = ((int)cpuReg_A) + ((int)cpuVal) + 1;
	cpuFlag_N = cpuFlag_Z = (BYTE)cpuIntValue2; cpuFlag_C = (BYTE)(cpuIntValue2>>8);
	cpuFlag_V = (( ((cpuReg_A^cpuVal)^0x80) & (cpuReg_A^cpuIntValue2) & 0x80))&0x80 ? 1:0;
	return 2; }
}
int opcode_0xCA(void)	/* 0xCA - DEX				2 cycles	*/
{
	cpuReg_PC++;
	cpuFlag_N = cpuFlag_Z = cpuReg_X = cpuReg_X-1;
	return 2;
}
int opcode_0xCB(void)	/* 0xCB - ????							*/
{
	return 20;
}
int opcode_0xCC(void)	/* 0xCC - CPY ABS			4 cycles	*/
{
	cpuReg_PC+=3;
	cpuVal = freddieReadByte( dword_u.valW ) ^ 255;
	{ int cpuIntValue2;
	cpuIntValue2 = ((int)cpuReg_Y) + ((int)cpuVal) + 1;
	cpuFlag_N = cpuFlag_Z = (BYTE)cpuIntValue2; cpuFlag_C = (BYTE)(cpuIntValue2>>8);
	cpuFlag_V = (( ((cpuReg_Y^cpuVal)^0x80) & (cpuReg_Y^cpuIntValue2) & 0x80))&0x80 ? 1:0;
	return 4; }
}
int opcode_0xCD(void)	/* 0xCD - CMP ABS			4 cycles	*/
{
	cpuReg_PC+=3;
	cpuVal = freddieReadByte( dword_u.valW ) ^ 255;
	{ int cpuIntValue2;
	cpuIntValue2 = ((int)cpuReg_A) + ((int)cpuVal) + 1;
	cpuFlag_N = cpuFlag_Z = (BYTE)cpuIntValue2; cpuFlag_C = (BYTE)(cpuIntValue2>>8);
	cpuFlag_V = (( ((cpuReg_A^cpuVal)^0x80) & (cpuReg_A^cpuIntValue2) & 0x80))&0x80 ? 1:0;
	return 4; }
}
int opcode_0xCE(void)	/* 0xCE - DEC ABS			6 cycles	*/
{
	cpuReg_PC+=3;
	cpuWorkAddress = dword_u.valW;
	cpuVal = freddieReadByte( dword_u.valW );
	cpuFlag_N = cpuFlag_Z = cpuNewVal = cpuVal-1;
	doWrite = 2;
	return 6;
}
int opcode_0xCF(void)	/* 0xCF - DEC:CMP ABS		6 cycles	*/
{
	cpuReg_PC+=3;
	cpuWorkAddress = dword_u.valW;
	cpuVal = freddieReadByte( dword_u.valW );
	cpuNewVal = cpuVal-1;
	doWrite = 2;
	{ int cpuIntValue2;
	cpuIntValue2 = ((int)cpuReg_A) + ((int)(cpuNewVal^255)) + 1;
	cpuFlag_N = cpuFlag_Z = (BYTE)cpuIntValue2; cpuFlag_C = (BYTE)(cpuIntValue2>>8);
	cpuFlag_V = (( ((cpuReg_A^cpuNewVal^255)^0x80) & (cpuReg_A^cpuIntValue2) & 0x80))&0x80 ? 1:0;
	return 6; }
}
int opcode_0xD0(void)	/* 0xD0 - BNE				2-4 cycles	*/
{
	cpuReg_PC+=2;
	if( cpuFlag_Z!=0 )
	{
		WORD te;
		te = (cpuReg_PC&0xFF)+(WORD)(signed short int)(signed char)dword_u.vb1;
		cpuReg_PC = (cpuReg_PC&0xFF00)+te;
		if( te<256 )
			return 3;
		return 4;
	}
	return 2;
}
int opcode_0xD1(void)	/* 0xD1 - CMP (),Y			5,6 cycles	*/
{
WORD wA;
	cpuReg_PC+=2;
	wA = ((WORD)atariMem[ dword_u.vb1 ]) + ((WORD)cpuReg_Y);
	cpuVal = freddieReadByte( ((WORD)atariMem[ (dword_u.vb1+1)&0xFF ])*256 + wA ) ^ 255;
	{ int cpuIntValue2;
	cpuIntValue2 = ((int)cpuReg_A) + ((int)cpuVal) + 1;
	cpuFlag_N = cpuFlag_Z = (BYTE)cpuIntValue2; cpuFlag_C = (BYTE)(cpuIntValue2>>8);
	cpuFlag_V = (( ((cpuReg_A^cpuVal)^0x80) & (cpuReg_A^cpuIntValue2) & 0x80))&0x80 ? 1:0;
	return 5+(wA>>8); }
}
int opcode_0xD2(void)	/* 0xD2 - ...				hang		*/
{
	return 20;
}
int opcode_0xD3(void)	/* 0xD3 - DEC:CMP (),Y			8 cycles	*/
{
	cpuReg_PC+=2;
	cpuWorkAddress = ((WORD)atariMem[ (dword_u.vb1+1)&0xFF ])*256 + ((WORD)atariMem[ dword_u.vb1 ]) + ((WORD)cpuReg_Y);
	cpuVal = freddieReadByte( cpuWorkAddress );
	cpuNewVal = cpuVal-1;
	doWrite = 2;
	{ int cpuIntValue2;
	cpuIntValue2 = ((int)cpuReg_A) + ((int)cpuNewVal^255) + 1;
	cpuFlag_N = cpuFlag_Z = (BYTE)cpuIntValue2; cpuFlag_C = (BYTE)(cpuIntValue2>>8);
	cpuFlag_V = (( ((cpuReg_A^cpuNewVal^255)^0x80) & (cpuReg_A^cpuIntValue2) & 0x80))&0x80 ? 1:0;
	return 8; }
}
int opcode_0xD4(void)	/* 0xD4 - NOP2				4 cycles	*/
{
	cpuReg_PC+=2;
	return 4;
}
int opcode_0xD5(void)	/* 0xD5 - CMP ZP,X			4 cycles	*/
{
	cpuReg_PC+=2;
	cpuVal = atariMem[(dword_u.vb1+cpuReg_X)&0xFF] ^ 255;
	{ int cpuIntValue2;
	cpuIntValue2 = ((int)cpuReg_A) + ((int)cpuVal) + 1;
	cpuFlag_N = cpuFlag_Z = (BYTE)cpuIntValue2; cpuFlag_C = (BYTE)(cpuIntValue2>>8);
	cpuFlag_V = (( ((cpuReg_A^cpuVal)^0x80) & (cpuReg_A^cpuIntValue2) & 0x80))&0x80 ? 1:0;
	return 4; }
}
int opcode_0xD6(void)	/* 0xD6 - DEC ZP,X			6 cycles	*/
{
WORD wA;
	cpuReg_PC+=2;
	wA = (dword_u.vb1+cpuReg_X)&0xFF;
	cpuVal = atariMem[wA]-1;
	atariMem[wA] = cpuVal;
	cpuFlag_N = cpuFlag_Z = cpuVal;
	return 6;
}
int opcode_0xD7(void)	/* 0xD7 - DEC:CMP ZP,X		6 cycles	*/
{
WORD wA;
	cpuReg_PC+=2;
	wA = (dword_u.vb1+cpuReg_X)&0xFF;
	cpuVal = atariMem[wA]-1;
	atariMem[wA] = cpuVal;
	cpuNewVal = cpuVal ^ 255;
	{ int cpuIntValue2;
	cpuIntValue2 = ((int)cpuReg_A) + ((int)cpuNewVal) + 1;
	cpuFlag_N = cpuFlag_Z = (BYTE)cpuIntValue2; cpuFlag_C = (BYTE)(cpuIntValue2>>8);
	cpuFlag_V = (( ((cpuReg_A^cpuNewVal)^0x80) & (cpuReg_A^cpuIntValue2) & 0x80))&0x80 ? 1:0;
	return 6; }
}
int opcode_0xD8(void)	/* 0xD8 - CLD				2 cycles	*/
{
	cpuReg_PC++;
	cpuFlag_D = 0;
	return 2;
}
int opcode_0xD9(void)	/* 0xD9 - CMP ABS,Y			4,5 cycles	*/
{			
WORD wA;
	cpuReg_PC+=3;
	wA = ((WORD)dword_u.vb1)+((WORD)cpuReg_Y);
	cpuVal = freddieReadByte( ((WORD)dword_u.vb2)*256 + wA ) ^ 255;
	{ int cpuIntValue2;
	cpuIntValue2 = ((int)cpuReg_A) + ((int)cpuVal) + 1;
	cpuFlag_N = cpuFlag_Z = (BYTE)cpuIntValue2; cpuFlag_C = (BYTE)(cpuIntValue2>>8);
	cpuFlag_V = (( ((cpuReg_A^cpuVal)^0x80) & (cpuReg_A^cpuIntValue2) & 0x80))&0x80 ? 1:0;
	return 4+(wA>>8); }
}
int opcode_0xDA(void)	/* 0xDA - NOP1				2 cycles	*/
{
	cpuReg_PC++;
	return 2;
}
int opcode_0xDB(void)	/* 0xDB - DEC:CMP ABS,Y		7 cycles	*/
{
WORD wA;
	cpuReg_PC+=3;
	wA = ((WORD)dword_u.vb1)+((WORD)cpuReg_Y);
	cpuWorkAddress = ((WORD)dword_u.vb2)*256 + wA;
	cpuVal = freddieReadByte( cpuWorkAddress );
	cpuNewVal = cpuVal-1;
	doWrite = 2;
	{ int cpuIntValue2;
	cpuIntValue2 = ((int)cpuReg_A) + ((int)cpuNewVal^255) + 1;
	cpuFlag_N = cpuFlag_Z = (BYTE)cpuIntValue2; cpuFlag_C = (BYTE)(cpuIntValue2>>8);
	cpuFlag_V = (( ((cpuReg_A^cpuNewVal^255)^0x80) & (cpuReg_A^cpuIntValue2) & 0x80))&0x80 ? 1:0;
	return 7; }
}
int opcode_0xDC(void)	/* 0xDC - NOP3				4 cycles	*/
{
	cpuReg_PC+=3;
	return 4;
}
int opcode_0xDD(void)	/* 0xDD - CMP ABS,X			4,5 cycles	*/
{
WORD wA;
	cpuReg_PC+=3;
	wA = ((WORD)dword_u.vb1)+((WORD)cpuReg_X);
	cpuVal = freddieReadByte( ((WORD)dword_u.vb2)*256 + wA ) ^ 255;
	{ int cpuIntValue2;
	cpuIntValue2 = ((int)cpuReg_A) + ((int)cpuVal) + 1;
	cpuFlag_N = cpuFlag_Z = (BYTE)cpuIntValue2; cpuFlag_C = (BYTE)(cpuIntValue2>>8);
	cpuFlag_V = (( ((cpuReg_A^cpuVal)^0x80) & (cpuReg_A^cpuIntValue2) & 0x80))&0x80 ? 1:0;
	return 4+(wA>>8); }
}
int opcode_0xDE(void)	/* 0xDE - DEC ABS,X			7 cycles	*/
{
	cpuReg_PC+=3;
	cpuWorkAddress = ((WORD)dword_u.vb2)*256 + ((WORD)dword_u.vb1)+((WORD)cpuReg_X);
	cpuVal = freddieReadByte( cpuWorkAddress );
	cpuFlag_N = cpuFlag_Z = cpuNewVal = cpuVal-1;
	doWrite = 2;
	return 7;
}
int opcode_0xDF(void)	/* 0xDF - DEC:CMP ABS,X		7 cycles	*/
{			
	cpuReg_PC+=3;
	cpuWorkAddress = ((WORD)dword_u.vb2)*256 + ((WORD)dword_u.vb1)+((WORD)cpuReg_X);
	cpuVal = freddieReadByte( cpuWorkAddress );
	cpuNewVal = cpuVal-1;
	doWrite = 2;
	{ int cpuIntValue2;
	cpuIntValue2 = ((int)cpuReg_A) + ((int)cpuNewVal^255) + 1;
	cpuFlag_N = cpuFlag_Z = (BYTE)cpuIntValue2; cpuFlag_C = (BYTE)(cpuIntValue2>>8);
	cpuFlag_V = (( ((cpuReg_A^cpuNewVal^255)^0x80) & (cpuReg_A^cpuIntValue2) & 0x80))&0x80 ? 1:0;
	return 7; }
}
int opcode_0xE0(void)	/* 0xE0 - CPX #				2 cycles	*/
{
	cpuReg_PC+=2;
	cpuVal = dword_u.vb1 ^ 255;
	{ int cpuIntValue2;
	cpuIntValue2 = ((int)cpuReg_X) + ((int)cpuVal) + 1;
	cpuFlag_N = cpuFlag_Z = (BYTE)cpuIntValue2; cpuFlag_C = (BYTE)(cpuIntValue2>>8);
	cpuFlag_V = (( ((cpuReg_X^cpuVal)^0x80) & (cpuReg_X^cpuIntValue2) & 0x80))&0x80 ? 1:0;
	return 2; }
}
int opcode_0xE1(void)	/* 0xE1 - SBC (,X)			6 cycles	*/
{
WORD wA;
	cpuReg_PC+=2;
	wA = (dword_u.vb1+cpuReg_X)&0xFF;
	cpuVal = freddieReadByte( ((WORD)atariMem[wA]) + ((WORD)atariMem[(wA+1)&0xFF])*256 );
	if( cpuFlag_D&1 )
	{
		BYTE al,ah; unsigned int tmp; tmp = (DWORD)cpuReg_A - (DWORD)cpuVal - (WORD)((cpuFlag_C&1)^1);
		al = (cpuReg_A & 0x0f) - (cpuVal & 0x0f) - ((cpuFlag_C&1)^1);
		ah = ((cpuReg_A >> 4)&0x0F) - ((cpuVal >> 4)&0x0F); if (al & 0x10) { al -= 6; ah--; } if (ah & 0x10) ah -= 6;
		cpuFlag_C = (tmp < (unsigned int)0x100) ? 1:0; cpuFlag_N = cpuFlag_Z = (BYTE)tmp;
		cpuFlag_V = (((cpuReg_A ^ tmp) & 0x80) && ((cpuReg_A ^ cpuVal) & 0x80) ) ? 1:0;
		cpuReg_A = (ah << 4) | (al & 0x0f);
		return 6;
	}
	{ WORD te;
	te = cpuReg_A + (cpuVal^255) + (cpuFlag_C&1); cpuFlag_C = (BYTE)(te>>8); cpuFlag_V = (( ((cpuReg_A^cpuVal^255)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te;
	return 6; }
}
int opcode_0xE2(void)	/* 0xE2 - NOP2				2 cycles	*/
{
	cpuReg_PC+=2;
	return 2;
}
int opcode_0xE3(void)	/* 0xE3 - INC:SBC (,X)		8 cycles	*/
{
WORD wA;
	cpuReg_PC+=2;
	wA = (dword_u.vb1+cpuReg_X)&0xFF;
	cpuWorkAddress = ((WORD)atariMem[wA]) + ((WORD)atariMem[(wA+1)&0xFF])*256;
	cpuVal = freddieReadByte( cpuWorkAddress );
	cpuNewVal = cpuVal+1;
	doWrite = 2;
	if( cpuFlag_D&1 )
	{
		BYTE al,ah; unsigned int tmp; tmp = (DWORD)cpuReg_A - (DWORD)cpuVal - (WORD)((cpuFlag_C&1)^1);
		al = (cpuReg_A & 0x0f) - (cpuVal & 0x0f) - ((cpuFlag_C&1)^1);
		ah = ((cpuReg_A >> 4)&0x0F) - ((cpuVal >> 4)&0x0F); if (al & 0x10) { al -= 6; ah--; } if (ah & 0x10) ah -= 6;
		cpuFlag_C = (tmp < (unsigned int)0x100) ? 1:0; cpuFlag_N = cpuFlag_Z = (BYTE)tmp;
		cpuFlag_V = (((cpuReg_A ^ tmp) & 0x80) && ((cpuReg_A ^ cpuVal) & 0x80) ) ? 1:0;
		cpuReg_A = (ah << 4) | (al & 0x0f);
		return 6;
	}
	{ WORD te;
	te = cpuReg_A + (cpuVal^255) + (cpuFlag_C&1); cpuFlag_C = (BYTE)(te>>8); cpuFlag_V = (( ((cpuReg_A^cpuVal^255)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te;
	return 8; }
}
int opcode_0xE4(void)	/* 0xE4 - CPX ZP				3 cycles	*/
{
	cpuReg_PC+=2;
	cpuVal = atariMem[dword_u.vb1] ^ 255;
	{ int cpuIntValue2;
	cpuIntValue2 = ((int)cpuReg_X) + ((int)cpuVal) + 1;
	cpuFlag_N = cpuFlag_Z = (BYTE)cpuIntValue2; cpuFlag_C = (BYTE)(cpuIntValue2>>8);
	cpuFlag_V = (( ((cpuReg_X^cpuVal)^0x80) & (cpuReg_X^cpuIntValue2) & 0x80))&0x80 ? 1:0;
	return 3; }
}
int opcode_0xE5(void)	/* 0xE5 - SBC ZP				3 cycles	*/
{
	cpuReg_PC+=2;
	cpuVal = atariMem[dword_u.vb1];
	if( cpuFlag_D&1 )
	{
		BYTE al,ah; unsigned int tmp; tmp = (DWORD)cpuReg_A - (DWORD)cpuVal - (WORD)((cpuFlag_C&1)^1);
		al = (cpuReg_A & 0x0f) - (cpuVal & 0x0f) - ((cpuFlag_C&1)^1);
		ah = ((cpuReg_A >> 4)&0x0F) - ((cpuVal >> 4)&0x0F); if (al & 0x10) { al -= 6; ah--; } if (ah & 0x10) ah -= 6;
		cpuFlag_C = (tmp < (unsigned int)0x100) ? 1:0; cpuFlag_N = cpuFlag_Z = (BYTE)tmp;
		cpuFlag_V = (((cpuReg_A ^ tmp) & 0x80) && ((cpuReg_A ^ cpuVal) & 0x80) ) ? 1:0;
		cpuReg_A = (ah << 4) | (al & 0x0f);
		return 3;
	}
	{ WORD te;
	te = cpuReg_A + (cpuVal^255) + (cpuFlag_C&1); cpuFlag_C = (BYTE)(te>>8); cpuFlag_V = (( ((cpuReg_A^cpuVal^255)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te;
	return 3; }
}
int opcode_0xE6(void)	/* 0xE6 - INC ZP				5 cycles	*/
{
	cpuReg_PC+=2;
	cpuVal = atariMem[dword_u.vb1]+1;
	atariMem[dword_u.vb1] = cpuVal;
	cpuFlag_N = cpuFlag_Z = cpuVal;
	return 5;
}
int opcode_0xE7(void)	/* 0xE7 - INC:SBC ZP			5 cycles	*/
{
	cpuReg_PC+=2;
	cpuVal = atariMem[dword_u.vb1]+1;
	atariMem[dword_u.vb1] = cpuVal;
	if( cpuFlag_D&1 )
	{
		BYTE al,ah; unsigned int tmp; tmp = (DWORD)cpuReg_A - (DWORD)cpuVal - (WORD)((cpuFlag_C&1)^1);
		al = (cpuReg_A & 0x0f) - (cpuVal & 0x0f) - ((cpuFlag_C&1)^1);
		ah = ((cpuReg_A >> 4)&0x0F) - ((cpuVal >> 4)&0x0F); if (al & 0x10) { al -= 6; ah--; } if (ah & 0x10) ah -= 6;
		cpuFlag_C = (tmp < (unsigned int)0x100) ? 1:0; cpuFlag_N = cpuFlag_Z = (BYTE)tmp;
		cpuFlag_V = (((cpuReg_A ^ tmp) & 0x80) && ((cpuReg_A ^ cpuVal) & 0x80) ) ? 1:0;
		cpuReg_A = (ah << 4) | (al & 0x0f);
		return 5;
	}
	{ WORD te;
	te = cpuReg_A + (cpuVal^255) + (cpuFlag_C&1); cpuFlag_C = (BYTE)(te>>8); cpuFlag_V = (( ((cpuReg_A^cpuVal^255)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te;
	return 5; }
}
int opcode_0xE8(void)	/* 0xE8 - INX				2 cycles	*/
{
	cpuReg_PC++;
	cpuFlag_N = cpuFlag_Z = cpuReg_X = cpuReg_X+1;
	return 2;
}
int opcode_0xE9(void)	/* 0xE9 - SBC #				2 cycles	*/
{
	cpuReg_PC+=2;
	cpuVal = dword_u.vb1;
	if( cpuFlag_D&1 )
	{
		BYTE al,ah; unsigned int tmp; tmp = (DWORD)cpuReg_A - (DWORD)cpuVal - (WORD)((cpuFlag_C&1)^1);
		al = (cpuReg_A & 0x0f) - (cpuVal & 0x0f) - ((cpuFlag_C&1)^1);
		ah = ((cpuReg_A >> 4)&0x0F) - ((cpuVal >> 4)&0x0F); if (al & 0x10) { al -= 6; ah--; } if (ah & 0x10) ah -= 6;
		cpuFlag_C = (tmp < (unsigned int)0x100) ? 1:0; cpuFlag_N = cpuFlag_Z = (BYTE)tmp;
		cpuFlag_V = (((cpuReg_A ^ tmp) & 0x80) && ((cpuReg_A ^ cpuVal) & 0x80) ) ? 1:0;
		cpuReg_A = (ah << 4) | (al & 0x0f);
		return 2;
	}
	{ WORD te;
	te = cpuReg_A + (cpuVal^255) + (cpuFlag_C&1); cpuFlag_C = (BYTE)(te>>8); cpuFlag_V = (( ((cpuReg_A^cpuVal^255)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te;
	return 2; }
}
int opcode_0xEA(void)	/* 0xEA - NOP				2 cycles	*/
{
	cpuReg_PC++;
	return 2;
}
int opcode_0xEB(void)	/* 0xEB - ????							*/
{
	return 20;
}
int opcode_0xEC(void)	/* 0xEC - CPX ABS			4 cycles	*/
{
	cpuReg_PC+=3;
	cpuVal = freddieReadByte( dword_u.valW ) ^ 255;
	{ int cpuIntValue2;
	cpuIntValue2 = ((int)cpuReg_X) + ((int)cpuVal) + 1;
	cpuFlag_N = cpuFlag_Z = (BYTE)cpuIntValue2; cpuFlag_C = (BYTE)(cpuIntValue2>>8);
	cpuFlag_V = (( ((cpuReg_X^cpuVal)^0x80) & (cpuReg_X^cpuIntValue2) & 0x80))&0x80 ? 1:0;
	return 4; }
}
int opcode_0xED(void)	/* 0xED - SBC ABS			4 cycles	*/
{
	cpuReg_PC+=3;
	cpuVal = freddieReadByte( dword_u.valW );
	if( cpuFlag_D&1 )
	{
		BYTE al,ah; unsigned int tmp; tmp = (DWORD)cpuReg_A - (DWORD)cpuVal - (WORD)((cpuFlag_C&1)^1);
		al = (cpuReg_A & 0x0f) - (cpuVal & 0x0f) - ((cpuFlag_C&1)^1);
		ah = ((cpuReg_A >> 4)&0x0F) - ((cpuVal >> 4)&0x0F); if (al & 0x10) { al -= 6; ah--; } if (ah & 0x10) ah -= 6;
		cpuFlag_C = (tmp < (unsigned int)0x100) ? 1:0; cpuFlag_N = cpuFlag_Z = (BYTE)tmp;
		cpuFlag_V = (((cpuReg_A ^ tmp) & 0x80) && ((cpuReg_A ^ cpuVal) & 0x80) ) ? 1:0;
		cpuReg_A = (ah << 4) | (al & 0x0f);
		return 4;
	}
	{ WORD te;
	te = cpuReg_A + (cpuVal^255) + (cpuFlag_C&1); cpuFlag_C = (BYTE)(te>>8); cpuFlag_V = (( ((cpuReg_A^cpuVal^255)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te;
	return 4; }
}
int opcode_0xEE(void)	/* 0xEE - INC ABS			6 cycles	*/
{
	cpuReg_PC+=3;
	cpuWorkAddress = dword_u.valW;
	cpuVal = freddieReadByte( dword_u.valW );
	cpuFlag_N = cpuFlag_Z = cpuNewVal = cpuVal+1;
	doWrite = 2;
	return 6;
}
int opcode_0xEF(void)	/* 0xEF - INC:SBC ABS		6 cycles	*/
{
	cpuReg_PC+=3;
	cpuWorkAddress = dword_u.valW;
	cpuVal = freddieReadByte( dword_u.valW );
	cpuNewVal = cpuVal-1;
	doWrite = 2;
	if( cpuFlag_D&1 )
	{
		BYTE al,ah; unsigned int tmp; tmp = (DWORD)cpuReg_A - (DWORD)cpuVal - (WORD)((cpuFlag_C&1)^1);
		al = (cpuReg_A & 0x0f) - (cpuVal & 0x0f) - ((cpuFlag_C&1)^1);
		ah = ((cpuReg_A >> 4)&0x0F) - ((cpuVal >> 4)&0x0F); if (al & 0x10) { al -= 6; ah--; } if (ah & 0x10) ah -= 6;
		cpuFlag_C = (tmp < (unsigned int)0x100) ? 1:0; cpuFlag_N = cpuFlag_Z = (BYTE)tmp;
		cpuFlag_V = (((cpuReg_A ^ tmp) & 0x80) && ((cpuReg_A ^ cpuVal) & 0x80) ) ? 1:0;
		cpuReg_A = (ah << 4) | (al & 0x0f);
		return 6;
	}
	{ WORD te;
	te = cpuReg_A + (cpuVal^255) + (cpuFlag_C&1); cpuFlag_C = (BYTE)(te>>8); cpuFlag_V = (( ((cpuReg_A^cpuVal^255)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te;
	return 6; }
}
int opcode_0xF0(void)	/* 0xF0 - BEQ				2-4 cycles	*/
{
	cpuReg_PC+=2;
	if( cpuFlag_Z==0 )
	{
		WORD te;
		te = (cpuReg_PC&0xFF)+(WORD)(signed short int)(signed char)dword_u.vb1;
		cpuReg_PC = (cpuReg_PC&0xFF00)+te;
		if( te<256 )
			return 3;
		return 4;
	}
	return 2;
}
int opcode_0xF1(void)	/* 0xF1 - SBC (),Y			5,6 cycles	*/
{
WORD wA;
	cpuReg_PC+=2;
	wA = ((WORD)atariMem[ dword_u.vb1 ]) + ((WORD)cpuReg_Y);
	cpuVal = freddieReadByte( ((WORD)atariMem[ (dword_u.vb1+1)&0xFF ])*256 + wA );
	if( cpuFlag_D&1 )
	{
		BYTE al,ah; unsigned int tmp; tmp = (DWORD)cpuReg_A - (DWORD)cpuVal - (WORD)((cpuFlag_C&1)^1);
		al = (cpuReg_A & 0x0f) - (cpuVal & 0x0f) - ((cpuFlag_C&1)^1);
		ah = ((cpuReg_A >> 4)&0x0F) - ((cpuVal >> 4)&0x0F); if (al & 0x10) { al -= 6; ah--; } if (ah & 0x10) ah -= 6;
		cpuFlag_C = (tmp < (unsigned int)0x100) ? 1:0; cpuFlag_N = cpuFlag_Z = (BYTE)tmp;
		cpuFlag_V = (((cpuReg_A ^ tmp) & 0x80) && ((cpuReg_A ^ cpuVal) & 0x80) ) ? 1:0;
		cpuReg_A = (ah << 4) | (al & 0x0f);
		return 5+(wA>>8);
	}
	{ WORD te;
	te = cpuReg_A + (cpuVal^255) + (cpuFlag_C&1); cpuFlag_C = (BYTE)(te>>8); cpuFlag_V = (( ((cpuReg_A^cpuVal^255)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te;
	return 5+(wA>>8); }
}
int opcode_0xF2(void)	/* 0xF2 - ...				hang		*/
{
	return 20;
}
int opcode_0xF3(void)	/* 0xF3 - INC:SBC (),Y			8 cycles	*/
{
	cpuReg_PC+=2;
	cpuWorkAddress = ((WORD)atariMem[ (dword_u.vb1+1)&0xFF ])*256 + ((WORD)atariMem[ dword_u.vb1 ]) + ((WORD)cpuReg_Y);
	cpuVal = freddieReadByte( cpuWorkAddress );
	cpuNewVal = cpuVal-1;
	doWrite = 2;
	if( cpuFlag_D&1 )
	{
		BYTE al,ah; unsigned int tmp; tmp = (DWORD)cpuReg_A - (DWORD)cpuVal - (WORD)((cpuFlag_C&1)^1);
		al = (cpuReg_A & 0x0f) - (cpuVal & 0x0f) - ((cpuFlag_C&1)^1);
		ah = ((cpuReg_A >> 4)&0x0F) - ((cpuVal >> 4)&0x0F); if (al & 0x10) { al -= 6; ah--; } if (ah & 0x10) ah -= 6;
		cpuFlag_C = (tmp < (unsigned int)0x100) ? 1:0; cpuFlag_N = cpuFlag_Z = (BYTE)tmp;
		cpuFlag_V = (((cpuReg_A ^ tmp) & 0x80) && ((cpuReg_A ^ cpuVal) & 0x80) ) ? 1:0;
		cpuReg_A = (ah << 4) | (al & 0x0f);
		return 8;
	}
	{ WORD te;
	te = cpuReg_A + (cpuVal^255) + (cpuFlag_C&1); cpuFlag_C = (BYTE)(te>>8); cpuFlag_V = (( ((cpuReg_A^cpuVal^255)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te;
	return 8; }
}
int opcode_0xF4(void)	/* 0xF4 - NOP2				4 cycles	*/
{
	cpuReg_PC+=2;
	return 4;
}
int opcode_0xF5(void)	/* 0xF5 - SBC ZP,X			4 cycles	*/
{
	cpuReg_PC+=2;
	cpuVal = atariMem[(dword_u.vb1+cpuReg_X)&0xFF];
	if( cpuFlag_D&1 )
	{
		BYTE al,ah; unsigned int tmp; tmp = (DWORD)cpuReg_A - (DWORD)cpuVal - (WORD)((cpuFlag_C&1)^1);
		al = (cpuReg_A & 0x0f) - (cpuVal & 0x0f) - ((cpuFlag_C&1)^1);
		ah = ((cpuReg_A >> 4)&0x0F) - ((cpuVal >> 4)&0x0F); if (al & 0x10) { al -= 6; ah--; } if (ah & 0x10) ah -= 6;
		cpuFlag_C = (tmp < (unsigned int)0x100) ? 1:0; cpuFlag_N = cpuFlag_Z = (BYTE)tmp;
		cpuFlag_V = (((cpuReg_A ^ tmp) & 0x80) && ((cpuReg_A ^ cpuVal) & 0x80) ) ? 1:0;
		cpuReg_A = (ah << 4) | (al & 0x0f);
		return 4;
	}
	{ WORD te;
	te = cpuReg_A + (cpuVal^255) + (cpuFlag_C&1); cpuFlag_C = (BYTE)(te>>8); cpuFlag_V = (( ((cpuReg_A^cpuVal^255)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te;
	return 4; }
}
int opcode_0xF6(void)	/* 0xF6 - INC ZP,X			6 cycles	*/
{
WORD wA;
	cpuReg_PC+=2;
	wA = (dword_u.vb1+cpuReg_X)&0xFF;
	cpuVal = atariMem[wA]+1;
	atariMem[wA] = cpuVal;
	cpuFlag_N = cpuFlag_Z = cpuVal;
	return 6;
}
int opcode_0xF7(void)	/* 0xF7 - INC:SBC ZP,X		6 cycles	*/
{
WORD wA;
	cpuReg_PC+=2;
	wA = (dword_u.vb1+cpuReg_X)&0xFF;
	cpuVal = atariMem[wA]+1;
	atariMem[wA] = cpuVal;
	if( cpuFlag_D&1 )
	{
		BYTE al,ah; unsigned int tmp; tmp = (DWORD)cpuReg_A - (DWORD)cpuVal - (WORD)((cpuFlag_C&1)^1);
		al = (cpuReg_A & 0x0f) - (cpuVal & 0x0f) - ((cpuFlag_C&1)^1);
		ah = ((cpuReg_A >> 4)&0x0F) - ((cpuVal >> 4)&0x0F); if (al & 0x10) { al -= 6; ah--; } if (ah & 0x10) ah -= 6;
		cpuFlag_C = (tmp < (unsigned int)0x100) ? 1:0; cpuFlag_N = cpuFlag_Z = (BYTE)tmp;
		cpuFlag_V = (((cpuReg_A ^ tmp) & 0x80) && ((cpuReg_A ^ cpuVal) & 0x80) ) ? 1:0;
		cpuReg_A = (ah << 4) | (al & 0x0f);
		return 6;
	}
	{ WORD te;
	te = cpuReg_A + (cpuVal^255) + (cpuFlag_C&1); cpuFlag_C = (BYTE)(te>>8); cpuFlag_V = (( ((cpuReg_A^cpuVal^255)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te;
	return 6; }
}
int opcode_0xF8(void)	/* 0xF8 - SED				2 cycles	*/
{
	cpuReg_PC++;
	cpuFlag_D = 1;
	return 2;
}
int opcode_0xF9(void)	/* 0xF9 - SBC ABS,Y			4,5 cycles	*/
{
WORD wA;
	cpuReg_PC+=3;
	wA = ((WORD)dword_u.vb1)+((WORD)cpuReg_Y);
	cpuVal = freddieReadByte( ((WORD)dword_u.vb2)*256 + wA );
	if( cpuFlag_D&1 )
	{
		BYTE al,ah; unsigned int tmp; tmp = (DWORD)cpuReg_A - (DWORD)cpuVal - (WORD)((cpuFlag_C&1)^1);
		al = (cpuReg_A & 0x0f) - (cpuVal & 0x0f) - ((cpuFlag_C&1)^1);
		ah = ((cpuReg_A >> 4)&0x0F) - ((cpuVal >> 4)&0x0F); if (al & 0x10) { al -= 6; ah--; } if (ah & 0x10) ah -= 6;
		cpuFlag_C = (tmp < (unsigned int)0x100) ? 1:0; cpuFlag_N = cpuFlag_Z = (BYTE)tmp;
		cpuFlag_V = (((cpuReg_A ^ tmp) & 0x80) && ((cpuReg_A ^ cpuVal) & 0x80) ) ? 1:0;
		cpuReg_A = (ah << 4) | (al & 0x0f);
		return 4+(wA>>8);
	}
	{ WORD te;
	te = cpuReg_A + (cpuVal^255) + (cpuFlag_C&1); cpuFlag_C = (BYTE)(te>>8); cpuFlag_V = (( ((cpuReg_A^cpuVal^255)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te;
	return 4+(wA>>8); }
}
int opcode_0xFA(void)	/* 0xFA - NOP1				2 cycles	*/
{
	cpuReg_PC++;
	return 2;
}
int opcode_0xFB(void)	/* 0xFB - INC:SBC ABS,Y		7 cycles	*/
{
WORD wA;
	cpuReg_PC+=3;
	wA = ((WORD)dword_u.vb1)+((WORD)cpuReg_Y);
	cpuWorkAddress = ((WORD)dword_u.vb2)*256 + wA;
	cpuVal = freddieReadByte( cpuWorkAddress );
	cpuNewVal = cpuVal+1;
	doWrite = 2;
	if( cpuFlag_D&1 )
	{
		BYTE al,ah; unsigned int tmp; tmp = (DWORD)cpuReg_A - (DWORD)cpuNewVal - (WORD)((cpuFlag_C&1)^1);
		al = (cpuReg_A & 0x0f) - (cpuVal & 0x0f) - ((cpuFlag_C&1)^1);
		ah = ((cpuReg_A >> 4)&0x0F) - ((cpuNewVal >> 4)&0x0F); if (al & 0x10) { al -= 6; ah--; } if (ah & 0x10) ah -= 6;
		cpuFlag_C = (tmp < (unsigned int)0x100) ? 1:0; cpuFlag_N = cpuFlag_Z = (BYTE)tmp;
		cpuFlag_V = (((cpuReg_A ^ tmp) & 0x80) && ((cpuReg_A ^ cpuNewVal) & 0x80) ) ? 1:0;
		cpuReg_A = (ah << 4) | (al & 0x0f);
		return 7;
	}
	{ WORD te;
	te = cpuReg_A + (cpuNewVal^255) + (cpuFlag_C&1); cpuFlag_C = (BYTE)(te>>8); cpuFlag_V = (( ((cpuReg_A^cpuNewVal^255)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te;
	return 7; }
}
int opcode_0xFC(void)	/* 0xDC - NOP3				4 cycles	*/
{
	cpuReg_PC+=3;
	return 4;
}
int opcode_0xFD(void)	/* 0xFD - SBC ABS,X			4,5 cycles	*/
{
WORD wA;
	cpuReg_PC+=3;
	wA = ((WORD)dword_u.vb1)+((WORD)cpuReg_X);
	cpuVal = freddieReadByte( ((WORD)dword_u.vb2)*256 + wA );
	if( cpuFlag_D&1 )
	{
		BYTE al,ah; unsigned int tmp; tmp = (DWORD)cpuReg_A - (DWORD)cpuVal - (WORD)((cpuFlag_C&1)^1);
		al = (cpuReg_A & 0x0f) - (cpuVal & 0x0f) - ((cpuFlag_C&1)^1);
		ah = ((cpuReg_A >> 4)&0x0F) - ((cpuVal >> 4)&0x0F); if (al & 0x10) { al -= 6; ah--; } if (ah & 0x10) ah -= 6;
		cpuFlag_C = (tmp < (unsigned int)0x100) ? 1:0; cpuFlag_N = cpuFlag_Z = (BYTE)tmp;
		cpuFlag_V = (((cpuReg_A ^ tmp) & 0x80) && ((cpuReg_A ^ cpuVal) & 0x80) ) ? 1:0;
		cpuReg_A = (ah << 4) | (al & 0x0f);
		return 4+(wA>>8);
	}
	{ WORD te;
	te = cpuReg_A + (cpuVal^255) + (cpuFlag_C&1); cpuFlag_C = (BYTE)(te>>8); cpuFlag_V = (( ((cpuReg_A^cpuVal^255)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te;
	return 4+(wA>>8); }
}
int opcode_0xFE(void)	/* 0xFE - INC ABS,X			7 cycles	*/
{
	cpuReg_PC+=3;
	cpuWorkAddress = ((WORD)dword_u.vb2)*256 + ((WORD)dword_u.vb1)+((WORD)cpuReg_X);
	cpuVal = freddieReadByte( cpuWorkAddress );
	cpuFlag_N = cpuFlag_Z = cpuNewVal = cpuVal+1;
	doWrite = 2;
	return 7;
}
int opcode_0xFF(void)	/* 0xDF - INC:SBC ABS,X		7 cycles	*/
{
	cpuReg_PC+=3;
	cpuWorkAddress = ((WORD)dword_u.vb2)*256 + ((WORD)dword_u.vb1)+((WORD)cpuReg_X);
	cpuVal = freddieReadByte( cpuWorkAddress );
	cpuNewVal = cpuVal+1;
	doWrite = 2;
	if( cpuFlag_D&1 )
	{
		BYTE al,ah; unsigned int tmp; tmp = (DWORD)cpuReg_A - (DWORD)cpuNewVal - (WORD)((cpuFlag_C&1)^1);
		al = (cpuReg_A & 0x0f) - (cpuVal & 0x0f) - ((cpuFlag_C&1)^1);
		ah = ((cpuReg_A >> 4)&0x0F) - ((cpuVal >> 4)&0x0F); if (al & 0x10) { al -= 6; ah--; } if (ah & 0x10) ah -= 6;
		cpuFlag_C = (tmp < (unsigned int)0x100) ? 1:0; cpuFlag_N = cpuFlag_Z = (BYTE)tmp;
		cpuFlag_V = (((cpuReg_A ^ tmp) & 0x80) && ((cpuReg_A ^ cpuNewVal) & 0x80) ) ? 1:0;
		cpuReg_A = (ah << 4) | (al & 0x0f);
		return 7;
	}
	{ WORD te;
	te = cpuReg_A + (cpuNewVal^255) + (cpuFlag_C&1); cpuFlag_C = (BYTE)(te>>8); cpuFlag_V = (( ((cpuReg_A^cpuNewVal^255)^0x80) & (cpuReg_A^te) & 0x80)) ? 1:0;
	cpuFlag_N = cpuFlag_Z = cpuReg_A = (BYTE)te;
	return 7; }
}

opcodeFunc opcodes_0x00_0xFF[256]={
	&opcode_0x00, &opcode_0x01, &opcode_0x02, &opcode_0x03, &opcode_0x04, &opcode_0x05, &opcode_0x06, &opcode_0x07,
	&opcode_0x08, &opcode_0x09, &opcode_0x0A, &opcode_0x0B, &opcode_0x0C, &opcode_0x0D, &opcode_0x0E, &opcode_0x0F,
	&opcode_0x10, &opcode_0x11, &opcode_0x12, &opcode_0x13, &opcode_0x14, &opcode_0x15, &opcode_0x16, &opcode_0x17,
	&opcode_0x18, &opcode_0x19, &opcode_0x1A, &opcode_0x1B, &opcode_0x1C, &opcode_0x1D, &opcode_0x1E, &opcode_0x1F,
	&opcode_0x20, &opcode_0x21, &opcode_0x22, &opcode_0x23, &opcode_0x24, &opcode_0x25, &opcode_0x26, &opcode_0x27,
	&opcode_0x28, &opcode_0x29, &opcode_0x2A, &opcode_0x2B, &opcode_0x2C, &opcode_0x2D, &opcode_0x2E, &opcode_0x2F,
	&opcode_0x30, &opcode_0x31, &opcode_0x32, &opcode_0x33, &opcode_0x34, &opcode_0x35, &opcode_0x36, &opcode_0x37,
	&opcode_0x38, &opcode_0x39, &opcode_0x3A, &opcode_0x2B, &opcode_0x3C, &opcode_0x3D, &opcode_0x3E, &opcode_0x3F,
	&opcode_0x40, &opcode_0x41, &opcode_0x42, &opcode_0x43, &opcode_0x44, &opcode_0x45, &opcode_0x46, &opcode_0x47,
	&opcode_0x48, &opcode_0x49, &opcode_0x4A, &opcode_0x4B, &opcode_0x4C, &opcode_0x4D, &opcode_0x4E, &opcode_0x4F,
	&opcode_0x50, &opcode_0x51, &opcode_0x52, &opcode_0x53, &opcode_0x54, &opcode_0x55, &opcode_0x56, &opcode_0x57,
	&opcode_0x58, &opcode_0x59, &opcode_0x5A, &opcode_0x5B, &opcode_0x5C, &opcode_0x5D, &opcode_0x5E, &opcode_0x5F,
	&opcode_0x60, &opcode_0x61, &opcode_0x62, &opcode_0x63, &opcode_0x64, &opcode_0x65, &opcode_0x66, &opcode_0x67,
	&opcode_0x68, &opcode_0x69, &opcode_0x6A, &opcode_0x6B, &opcode_0x6C, &opcode_0x6D, &opcode_0x6E, &opcode_0x6F,
	&opcode_0x70, &opcode_0x71, &opcode_0x72, &opcode_0x73, &opcode_0x74, &opcode_0x75, &opcode_0x76, &opcode_0x77,
	&opcode_0x78, &opcode_0x79, &opcode_0x7A, &opcode_0x7B, &opcode_0x7C, &opcode_0x7D, &opcode_0x7E, &opcode_0x7F,
	&opcode_0x80, &opcode_0x81, &opcode_0x82, &opcode_0x83, &opcode_0x84, &opcode_0x85, &opcode_0x86, &opcode_0x87,
	&opcode_0x88, &opcode_0x89, &opcode_0x8A, &opcode_0x8B, &opcode_0x8C, &opcode_0x8D, &opcode_0x8E, &opcode_0x8F,
	&opcode_0x90, &opcode_0x91, &opcode_0x92, &opcode_0x93, &opcode_0x94, &opcode_0x95, &opcode_0x96, &opcode_0x97,
	&opcode_0x98, &opcode_0x99, &opcode_0x9A, &opcode_0x9B, &opcode_0x9C, &opcode_0x9D, &opcode_0x9E, &opcode_0x9F,
	&opcode_0xA0, &opcode_0xA1, &opcode_0xA2, &opcode_0xA3, &opcode_0xA4, &opcode_0xA5, &opcode_0xA6, &opcode_0xA7,
	&opcode_0xA8, &opcode_0xA9, &opcode_0xAA, &opcode_0xAB, &opcode_0xAC, &opcode_0xAD, &opcode_0xAE, &opcode_0xAF,
	&opcode_0xB0, &opcode_0xB1, &opcode_0xB2, &opcode_0xB3, &opcode_0xB4, &opcode_0xB5, &opcode_0xB6, &opcode_0xB7,
	&opcode_0xB8, &opcode_0xB9, &opcode_0xBA, &opcode_0xBB, &opcode_0xBC, &opcode_0xBD, &opcode_0xBE, &opcode_0xBF,
	&opcode_0xC0, &opcode_0xC1, &opcode_0xC2, &opcode_0xC3, &opcode_0xC4, &opcode_0xC5, &opcode_0xC6, &opcode_0xC7,
	&opcode_0xC8, &opcode_0xC9, &opcode_0xCA, &opcode_0xCB, &opcode_0xCC, &opcode_0xCD, &opcode_0xCE, &opcode_0xCF,
	&opcode_0xD0, &opcode_0xD1, &opcode_0xD2, &opcode_0xD3, &opcode_0xD4, &opcode_0xD5, &opcode_0xD6, &opcode_0xD7,
	&opcode_0xD8, &opcode_0xD9, &opcode_0xDA, &opcode_0xDB, &opcode_0xDC, &opcode_0xDD, &opcode_0xDE, &opcode_0xDF,
	&opcode_0xE0, &opcode_0xE1, &opcode_0xE2, &opcode_0xE3, &opcode_0xE4, &opcode_0xE5, &opcode_0xE6, &opcode_0xE7,
	&opcode_0xE8, &opcode_0xE9, &opcode_0xEA, &opcode_0xEB, &opcode_0xEC, &opcode_0xED, &opcode_0xEE, &opcode_0xEF,
	&opcode_0xF0, &opcode_0xF1, &opcode_0xF2, &opcode_0xF3, &opcode_0xF4, &opcode_0xF5, &opcode_0xF6, &opcode_0xF7,
	&opcode_0xF8, &opcode_0xF9, &opcode_0xFA, &opcode_0xFB, &opcode_0xFC, &opcode_0xFD, &opcode_0xFE, &opcode_0xFF,
};

int cpuExecuteOneOpcode( void )
{
	dword_u.dw = ((DWORD*)&atariMem[ cpuReg_PC ])[0];
	return opcodes_0x00_0xFF[dword_u.opcode]();
}

