Procedure WriteBmp24(fname1,fname:string);
var
 f : file;
 infile : file;
 tmp : array[1..256] of byte;
 rgb : record
         r,g,b : byte;
       end;
 idx : byte;
 xpos,ypos : integer;
 drawy : boolean;
 a : longint;
 xstep,ystep : real;
 txp,typ : real;
 buffer : array[1..16384] of byte;
 bpos : integer;
 ll : word;
 x,y : integer;
Procedure addbuf(v:byte);
Begin
  inc(bpos);
  if (bpos>16384) then
   Begin
     blockwrite(f,buffer[1],16384);
     bpos := 1;
   end;
  buffer[bpos] := v;
end;

Procedure flushbuf;
Begin
  if bpos>1 then blockwrite(f,buffer[1],bpos);
end;

var
 data : array[0..1279] of byte;
 rgbline : array[0..1279] of Record
                               r,g,b:byte;
                             end;
 modeinfo : array[0..128] of word;
 modetest : array[0..255] of char;

{Procedure checkvesa;
var
 r : registers;
Begin
 r.ax := $4f00;
 r.es := seg(modetest);
 r.di := ofs(modetest);
 intr($10,r);
end;

Procedure getvesainfo;
var
 r : registers;
Begin
 r.ax := $4f01;
 r.cx := vm;
 r.es := seg(modeinfo);
 r.di := ofs(modeinfo);
 intr($10,r);
end;
}
{var
 curbank : word;
 bytesperline : word;
}
{Procedure setvesamode(video_mode:integer);
var
 r : registers;
Begin
 if video_mode=vm then exit;
 vm := video_mode;
 r.ax := $4F02;
 r.bx := video_mode;
 intr($10,r);
 if video_mode=$101 then bytesperline := 640 else bytesperline := 1024;
 lastmode := video_mode;
end;
}

{Procedure SetBank(bnum:integer);
var
 r : registers;
 w : word;
Begin
 r.ax := $4F05;
 r.bh := 0;
 r.bl := 0;
 r.dx := bnum;
 intr($10,r);
 curbank := bnum;
end;

Procedure SetPixel640(xpos,ypos:word;color:byte);assembler;
asm
   mov ax,ypos
   sub ax,1
   mov bx,xpos
   mov cx,640
   mul cx
   add bx,ax
   adc dx,0
   mov ax,$0a000
   mov es,ax
   mov cx,curbank
   cmp cx,dx
   je @drawit
 @bankswitch:
   push bx
   xor bx,bx
   mov ax,$4f05
   int $10
   pop bx
   mov curbank,dx
 @drawit:
   mov al,color
   mov es:[bx],al
end;

Procedure SetPixel1024(xpos,ypos:word;color:byte);assembler;
asm
   mov ax,ypos
   sub ax,1
   mov bx,xpos
   mov cx,1024
   mul cx
   add bx,ax
   adc dx,0
   mov ax,$0a000
   mov es,ax
   mov cx,curbank
   cmp cx,dx
   je @drawit
 @bankswitch:
   push bx
   xor bx,bx
   mov ax,$4f05
   int $10
   pop bx
   mov curbank,dx
 @drawit:
   mov al,color
   mov es:[bx],al
end;
}
Begin
 curbank := 0;
 checkvesa;
 getvesainfo;
 bpos := 0;
 assign(infile,fname1);
 reset(infile,1);
 blockread(infile,tmp,sizeof(win)-1024);
 while length(fname)>12 do delete(fname,2,1);
 assign(f,fname);
 rewrite(f,1);
 move(bmppal,win.bmicolors,1024);
 win.bibitcount := 8;
 win.biclrused := 256;
 win.biclrimportant := 256;
 win.biplanes := 1;
 win.bfsize := 1024+(win.biheight*win.biwidth);
 win.bfoffbits := 1078;
 blockwrite(f,win,sizeof(win));

 xpos := 0;
 ypos := win.biheight;

 txp := xpos;
 typ := ypos;

if (win.biheight<=480) and (win.biwidth<=640) then setvesamode($101) else setvesamode($105);
setpalettedac(pal);

for a := 1 to win.biheight do
  Begin
    blockread(infile,rgbline,win.biwidth*3);
    for x := 0 to win.biwidth-1 do
    Begin
      if (rgbline[x].b=0) and (rgbline[x].g=0) and (rgbline[x].r=0) then
      idx := 0 else
      idx := newindex2(rgbline[x].b,rgbline[x].g,rgbline[x].r);
      addbuf(idx);
      pixel(xpos,ypos,idx);
      inc(xpos);
   end;
   xpos := 0;
   dec(ypos);
  end;
 flushbuf;
 close(f);
 close(infile);

 blockwrite(outfile,win.biheight,sizeof(win.biheight));
 blockwrite(outfile,win.biwidth,sizeof(win.biwidth));

 for y := win.biheight-1 downto 0 do
  Begin
   for x := 0 to win.biwidth-1 do data[x] := getpixel(x,y);
   blockwrite(outfile,data,win.biwidth);
  end;
end;
