Unit Input;

Interface

Uses DOS;

{$I Input.Inc}

Var
  Keystroke : Array[0..255] of boolean;

Function  KeyPress:Boolean;
Procedure Enable09Int;
Procedure Disable09Int;
Function  ConvertCHAR(c:char):byte;

Implementation

Var
  OldExitProc,SaveInt09:pointer;
  p:byte;

Procedure JumpOldISR(OldIsr:pointer);
 inline($5B/$58/$87/$5E/$0E/$87/$46/$10/$89/
        $EC/$5D/$07/$1F/$5F/$5E/$5A/$59/$CB);

Procedure Disable09Int;
begin
 SetIntVec(9,SaveInt09);
 ExitProc := OldExitProc;
end;

{$F+}
Procedure Key_ISR(Flags,CS,IP,AX,BX,CX,DX,SI,DI,DS,ES,BP:word);interrupt;
var
 d:byte;
begin
 p := Port[$60];
 If lo(p)>$80 then
   begin
    d := lo(p) and 127;
    Keystroke[d] := false
   end else
    Keystroke[p] := true;
  Inline($E4/$61/$8A/$E0/$0C/$80/$E6/$61/
        $86/$E0/$E6/$61/$B0/$20/$E6/$20);
 JumpOldISR(Saveint09);
end;
{$F-}

Procedure Int09ExitProc;
begin
 ExitProc := OldExitProc;
 SetIntVec(9,SaveInt09);
end;

Procedure Enable09Int;
Begin
 Fillchar(keystroke,sizeof(keystroke),0);
 OldExitProc := ExitProc;
 ExitProc := @Int09ExitProc;
 GetIntVec(9,Saveint09);
 SetIntVec(9,@Key_ISR);
end;

Function Keypress:boolean;
var
 x : integer;
 bu1,bu2 : byte;
begin
 keypress := false;
 for x := 1 to 88 do
  if keystroke[x]=true then keypress := true;
end;

Function  ConvertCHAR(c:char):byte;
Begin
  case upcase(c) of
  'A' : ConvertCHAR := Akey;
  'B' : ConvertCHAR := Bkey;
  'C' : ConvertCHAR := Ckey;
  'D' : ConvertCHAR := Dkey;
  'E' : ConvertCHAR := Ekey;
  'F' : ConvertCHAR := Fkey;
  'G' : ConvertCHAR := Gkey;
  'H' : ConvertCHAR := Hkey;
  'I' : ConvertCHAR := Ikey;
  'J' : ConvertCHAR := Jkey;
  'K' : ConvertCHAR := Kkey;
  'L' : ConvertCHAR := Lkey;
  'M' : ConvertCHAR := Mkey;
  'N' : ConvertCHAR := Nkey;
  'O' : ConvertCHAR := Okey;
  'P' : ConvertCHAR := Pkey;
  'Q' : ConvertCHAR := Qkey;
  'R' : ConvertCHAR := Rkey;
  'S' : ConvertCHAR := Skey;
  'T' : ConvertCHAR := Tkey;
  'U' : ConvertCHAR := Ukey;
  'V' : ConvertCHAR := Vkey;
  'W' : ConvertCHAR := Wkey;
  'X' : ConvertCHAR := Xkey;
  'Y' : ConvertCHAR := Ykey;
  'Z' : ConvertCHAR := Zkey;
  '0' : ConvertCHAR := _0;
  '1' : ConvertCHAR := _1;
  '2' : ConvertCHAR := _2;
  '3' : ConvertCHAR := _3;
  '4' : ConvertCHAR := _4;
  '5' : ConvertCHAR := _5;
  '6' : ConvertCHAR := _6;
  '7' : ConvertCHAR := _7;
  '8' : ConvertCHAR := _8;
  '9' : ConvertCHAR := _9;
  '-' : ConvertCHAR := Minus;
  '+' : ConvertCHAR := Plus;
  else ConvertCHAR := 0;
 end;
end;

begin
 Fillchar(Keystroke,Sizeof(Keystroke),false);
end.




