{$O+}{$G+}
Unit skeld;

Interface

Uses Crt,Dos,global,windows;

Const
  Backspace = #08;
  Enter = #13;
  CTRL_Y = #25;
  Ins = #82;
  Del = #83;
  Uparr = #72;
  Downarr = #80;
  LeftArr = #75;
  RightArr = #77;
  HomePos = #71;
  EndPos = #79;
  Esc = #27;
  F10 = #68;
  F1 = #59;
Type
  filtertype = set of char;
  String8 = string[10];

  FieldPtr = ^Field;

  FN = String[40];

  Texttype = Array[1..50] of Record
               xpos,ypos : byte;
               s : string;
             end;

  Field = Record
            display : boolean;
            fieldinfo : string; {keeps track of what is typed in!}
            xpos : byte;
            ypos : byte;
            fxpos : byte;
            fypos : byte;
            fheight : byte;
            fieldlength : byte;
            fieldwidth  : byte;
            fieldname : fn;
            fieldtype : char;
            fielddecimal : byte;
            action : pointer;
            db4name : string8;
            cp : byte;
            Prev,Next : FieldPtr;
          end;

Var
  tt : texttype;
  nt : byte;
  strfilter : filtertype;
  filter : filtertype;
  Curdbs : string;
  FirstField : FieldPtr;  {Keeps track of 1st field in list}
  LastField  : FieldPtr;  {Keeps track of last field in list}
  CurField   : FieldPtr;  {Keeps track of current field}
  Numfields  : Integer;
  Curfieldnum : Integer;
  Save_status : byte; {0 - abort, 1 - save}

Function  Token(var s:string):string;
Function  sstr(v:integer):string;
Procedure Read_DBS(f:string);
Procedure Deinit_DBS;
Procedure DBS_GO(cdbs:string;p:pointer);
Function Strip(s:string;c:char):string;
Procedure InitSkeld;

Implementation

Function stoi(s:string):integer;
var
 x,e : integer;
Begin
 val(s,x,e);
 stoi := x;
end;

Function itos(s:longint):string;
var
 t : string;
Begin
 str(s,t);
 itos := t;
end;


Function stor(s:string):real;
var
 r : real;
 e : integer;
Procedure strip(var s:string;c:char);
begin
  while pos(c,s)>0 do delete(s,pos(c,s),1);
end;
Begin
  strip(s,' ');
{  strip(s,'.');}
  strip(s,'$');
  val(s,r,e);
  stor := r;
end;

Function rtos(r:real;l,d:byte):string;
var
  s : string;
Begin
  str(r:l:d,s);
  rtos := s;
end;

Function Token(var s:string):string;
var
 x,y : integer;
 ts : string;
Begin
 ts := '';
 x := pos(' ',s);
 if (x=0) then
  Begin
    token := s;
    s := '';
  end else
  Begin
    for y := 1 to x do
     ts := ts + s[y];
    delete(s,1,x);
    token := ts;
  end;
end;

Function strip(s:string;c:char):string;
var
 x : integer;
 lp : integer;
 s2 : string;
begin
  s2 := '';
  lp := 0;
  for x := 1 to length(s) do
    if s[x]<>' ' then lp := x;
  for x := 1 to lp do
   s2 := s2 + s[x];
  strip := s2;
end;

Function sstr(v:integer):string;
var
 s : string;
Begin
 str(v,s);
 sstr := s;
end;


Function lint(s:string):Longint;
var
 e : integer;
 v : longint;
Begin
 val(s,v,e);
 lint := v;
end;


Function Lpad(s:string;x:integer):string;
begin
 while length(s)<x do
   s := s + ' ';
lpad := s;
end;

Function Rpad(s:string;x:integer):string;
begin
 while length(s)<x do
   s := ' '+s;
rpad := s;
end;

Function Cpad(s:string;x:integer):string;
var
 sstart : integer;
 y : integer;
 s2 : string;
begin
 if length(s)>x then delete(s,x+1,length(s)-x);

 sstart := (x shr 1)-(length(s) shr 1)-1;

 s2 := '';

 for y := 1 to sstart do
 s2 := ' '+s2;

 s2 := s2 + s;
 while length(s2)<x do
   s2 := s2+' ';

cpad := s2;
end;

Procedure DBS_SETUP(cdbs:string;p:pointer);
Begin
  curdbs := cdbs;
end;

Procedure Deinit_DBS;
Begin
 curfield := lastfield;
 if (curfield=nil) then exit;
   while curfield^.prev<>nil do
     Begin
      curfield := curfield^.prev;
      dispose(curfield^.next);
      curfield ^.next := nil;
     end;
 dispose(curfield);
 firstfield := nil;
 lastfield := nil;
 curfield := nil;
end;


Procedure GetInteger(s:string;
                     b:byte;
                     Var Newval:byte);
var
 t,x,e : integer;
 token : string;
Begin
 token := '';
 t := 0;
 if (b>1) then
 for x := 1 to b-1 do
   Begin
     t := pos(',',s);
     s[t] := #178; {Take out token identifier}
   end;
 x := t+1;

 while ( (s[x]<>',') and (x<=length(s))) do
   Begin
     token := token + s[x];
     inc(x);
   end;
 val(token,newval,e);
end;

Procedure GetString(s:string;
                    b:byte;
                    Var Newval:fn);
var
 t,x,e : integer;
 token : string;
Begin
 token := '';
 if (b>1) then
 for x := 1 to b-1 do
   Begin
     t := pos(',',s);
     s[t] := #178; {Take out token identifier}
   end;
 x := t+1;
 while ( (s[x]<>',') and (x<=length(s))) do
   Begin
     token := token + s[x];
     inc(x);
   end;
 newval := token;
end;

Procedure GetStringA(s:string;
                    b:byte;
                    Var Newval:string);
var
 t,x,e : integer;
 token : string;
Begin
 token := '';
 if (b>1) then
 for x := 1 to b-1 do
   Begin
     t := pos(',',s);
     s[t] := #178; {Take out token identifier}
   end;
 x := t+1;
 while ( (s[x]<>',') and (x<=length(s))) do
   Begin
     token := token + s[x];
     inc(x);
   end;
 newval := token;
end;

Procedure GetString8(s:string;
                    b:byte;
                    Var Newval:string8);
var
 t,x,e : integer;
 token : string;
Begin
 token := '';
 if (b>1) then
 for x := 1 to b-1 do
   Begin
     t := pos(',',s);
     s[t] := #178; {Take out token identifier}
   end;
 x := t+1;
 while ( (s[x]<>',') and (x<=length(s))) do
   Begin
     token := token + s[x];
     inc(x);
   end;
 newval := token;
end;

Procedure GetChar(s:string;
                    b:byte;
                    Var Newval:char);
var
 t,x,e : integer;
 token : string;
Begin
 token := '';
 if (b>1) then
 for x := 1 to b-1 do
   Begin
     t := pos(',',s);
     s[t] := #178; {Take out token identifier}
   end;
 x := t+1;
 while ( (s[x]<>',') and (x<=length(s))) do
   Begin
     token := token + s[x];
     inc(x);
   end;
 newval := token[1];
end;

Procedure ProcessLine(s:string); {Gets tokens and converts to db interpreter}
var
 x : integer;
 newfield : fieldptr;
Begin
  if (length(s)=0) then exit;
  if (s[1]=';') then exit;

  if (s[1]='#') then
       Begin
         delete(s,1,1);
         inc(nt);
         GetInteger(s,1,tt[nt].xpos);
         GetInteger(s,2,tt[nt].ypos);
         GetStringa(s,3,tt[nt].s);
         exit;
       end;

  new(newfield);
  newfield^.prev := lastfield;
  if (lastfield<>nil) then lastfield^.next := newfield;
  newfield^.next := nil;

  if (firstfield=nil) then firstfield := newfield; {reassign 1st and current}
  if (curfield=nil) then curfield := firstfield;
  lastfield := newfield;

  for x := 1 to length(s) do
    s[x] := upcase(s[x]);

  with newfield^ do
    Begin
      GetInteger(s,1,xpos);
      GetInteger(s,2,ypos);
      GetInteger(s,3,fieldlength);
      GetInteger(s,4,fieldwidth);
      GetString(s,5,fieldname);
      GetChar(s,6,fieldtype);
      GetInteger(s,7,fielddecimal);
      GetString8(s,8,db4name);
      display := not(fieldname=db4name);
      fxpos := xpos+length(fieldname)+1;
      fypos := ypos;
      fheight := (fieldlength div fieldwidth);
      fieldinfo := '';
      cp := 0;
    end;
 inc(numfields);
end;

Procedure Read_DBS(f:string);
var
 t : text;
 l : string;
 sex : byte;
Begin
 nt := 0;
 numfields := 0;
 fillchar(tt,sizeof(tt),0);
 {$I-}
 assign(t,f);
 reset(t);
 sex := IORESULT;
 if (sex=5) then read_dbs(f) else
 while not eof(t) do
   Begin
     readln(t,l);
     processline(l);
   end;
 close(t);
 curfield := firstfield;
end;

Procedure DBS_GO(cdbs:string;p:pointer);
Begin
  {$IFDEF DEBUG} debug('DBS_GO '+curdbs); {$ENDIF}
  DBS_SETUP(cdbs,p);   {setup DBS Script File, and pointer to variable struct}
  Read_DBS(curdbs);    {process the DBS file}
end;

Procedure InitSkeld;
Begin
  strfilter := [#32..#126];
  FirstField := NIL;
  LastField := NIL;
  CurField := NIL;
end;

Begin
  Initskeld;
end.