{$DEFINE LOG}
{DEFINE DEBUG}
{DEFINE SHOWCHAR}
{$DEFINE PPP}

Unit TCP;

Interface

USES {$IFDEF PPP}PPP,{$ENDIF}IP,DNS;

Const
  Max_WINDOW_SIZE = 16384;
  Max_Data_size = 16384;  {Maximum Buffer Size Allocated each time a new
                           socket is opened.}
  TCP_Protocol = 6;
  PORT = 0;
  ID = 1;
  PORTID = 2;

  URG = 32;  {TCP FLAGS}
  ACK = 16;
  PSH = 8;
  RST = 4;
  SYN = 2;
  FIN = 1;

  S_DNS_LOOKUP   = 1;
  S_SEND_REQUEST = 2;
  S_WAITING_ACK1 = 3;
  S_WAITING_ACK2 = 4;
  S_SOCKET_OPEN  = 5;
  S_SOCKET_CLOSED = 6;

  Socket_Overflow = 1;
  Socket_Not_Open = 2;
  Socket_Invalid  = 6;
  Socket_Empty    = 3;
  Socket_Overrun  = 4;
Type
  pData = ^data;
  data  = Record
            data_size : word;
            data : pbyte;
          end;

  pSocket = ^Socket_Record;
  Socket_Record = Record
                    Domain : string;
                    IP     : IPType;
                    Status : Byte;
                    DNS_RESULT : pDNS;

                    OKTOCLOSE : boolean;

                    lasterror : byte;

                    SourcePort,DestPort : word;

                    Sequence_Number  : longint;
                    Acknowledgement  : longint;
                    Receive_Sequence : longint;

                    Header_Length : byte;
                    URG,ACK,PSH,RST,SYN,FIN : byte;
                    Window_Size  : integer;
                    Send_Window_Size : integer;
                    sws : integer;
                    cd : byte;
                    sendlock : boolean;
                    TCP_Checksum : word;
                    Urgent_Pointer : word;
                    Options : longint;
                    Datain,
                    Dataout : pbyte; {Storage of input and output}
                    Datainp,Dataoutp : pbyte; {pointers into datain and dataout}
                    Datainsize,Dataoutsize : longint; {size of info stored in pointers}
                    prev,next : pSocket;
                  end;

   pTCP = ^TCP_Record;
   TCP_Record = Record
                  ID : word;
                  SourceIP,DestIP     : IPType;

                  SourcePort,DestPort : word;
                  Sequence_Number     : longint;
                  Acknowledgement     : longint;
                  Header_Length       : byte;
                  URG,ACK,PSH,RST,SYN,FIN : byte;
                  Window_Size         : word;
                  Checksum            : word;
                  Urgent_Pointer      : word;

                  data_ptr : pbyte;
                  Data : pbyte;
                  Datasize : word;

                  prev,next : pTCP;
                end;

   TCP_Object = Object
                 Private
                    First_TCP,
                    Last_TCP,
                    Cur_TCP : pTCP;

                 Public
                    Function  B(var frame:pbyte):byte;
                    Function  GetByte(var frame:pbyte):byte;
                    Procedure AddByte(var frame:pbyte;bte:byte);

                    Procedure AddTCPFrame(frame:pIP);
                    Procedure DisposeTCPFrame(frame:pTCP);

                    Function  GetTCPFrame(portorid:byte;data,data2:word):pTCP;

                    Procedure SendTCP(ID:longint;
                                      DestIP:iptype;
                                      SourcePort,
                                      DestPort:word;
                                      Sequence_number:longint;
                                      Acknowledgement:longint;
                                      flags : byte;
                                      window_size : word;
                                      urgent_pointer : word;
                                      datalength:word;
                                      Data:pbyte);
                    Private
                       Constructor Init;
                       Destructor  Done;
                end;

Function  Open_Socket(domain:string; sourceport,destport:word):pSocket;
Function  Close_Socket(var socket:psocket):boolean;
Function  Write_Socket(var socket:psocket;datalength:word;data:pbyte):byte;
Procedure Read_Socket(var socket:psocket;
                      var datasize:word;
                      var data:pbyte);
Procedure Handle_Sockets;
Function  str2pbyte(s:string):pbyte;
Function  getsocket:word;

var
  {$IFDEF LOG} lf:text;{$ENDIF}
  oTCP : TCP_Object;
  First_Socket,
  Last_Socket : pSocket;
  cursocket : word;
  TCPDropped : longint;
  drop_bad_ports : boolean;

Implementation

Uses Checksum;

{ Open socket creates records to hold info for socket,
  Creates a DOMAIN NAME lookup if necessary or sets status to
    S_SEND_REQUEST - to open a TCP connection
  Returns a pointer to socket for future use
}

Function Open_Socket(domain:string; sourceport,destport:word):pSocket;
var
 socket : psocket;
Begin
  Open_Socket := nil;
  new(socket);

  socket^.domain := '';
  fillchar(socket^.ip,4,0);
  if oPPP.validip(domain) then oPPP.stoip(domain,socket^.ip)
     else socket^.domain := domain;

  {If we have to resolve DNS name...}
  if length(socket^.domain)>0 then
    Begin
      socket^.DNS_RESULT := gethostbyname(socket^.domain);
      socket^.status := S_DNS_LOOKUP;
    end else
    Begin
      socket^.DNS_RESULT := nil;
      socket^.status := S_SEND_REQUEST;
    end;

  getmem(socket^.datain,max_data_size);
  socket^.datainp := socket^.datain;

  getmem(socket^.dataout,max_data_size);
  socket^.dataoutp := socket^.dataout;

  socket^.lasterror := 0;
  socket^.Sequence_Number := 0{random(65535)*random(65535)}; {Starting Sequence #}
  socket^.Receive_Sequence := 0;
  socket^.Acknowledgement := 0;
  socket^.Header_Length := 0;
  socket^.URG := 0;
  socket^.ACK := 0;
  socket^.PSH := 0;
  socket^.RST := 0;
  socket^.SYN := 0;
  socket^.FIN := 0;
  socket^.Window_Size  := MAX_WINDOW_SIZE; {Default Window Size...}
  socket^.TCP_Checksum := 0;
  socket^.Urgent_Pointer := 0;
  socket^.Options := 0;

  socket^.sourceport  := sourceport;
  socket^.destport    := destport;
  socket^.oktoclose   := true;
  socket^.datainsize  := 0;
  socket^.dataoutsize := 0;

  socket^.prev := last_socket;
  last_socket := socket;
  socket^.next := nil;
  if first_socket=nil then first_socket:= socket;
  if socket^.prev<>nil then socket^.prev^.next := socket;
  Open_Socket := socket;
end;

Function Close_Socket(var socket:psocket):boolean;
var
 done : boolean;
 tcp : pTCP;
Begin
  Close_Socket := false;
  if socket=nil then exit;

  if not(socket^.oktoclose) then
    Begin
      oTCP.SendTCP(random(65535),
                   socket^.ip,
                   socket^.sourceport,
                   socket^.destport,
                   socket^.acknowledgement,
                   socket^.receive_sequence,FIN,socket^.window_size,0,0,nil);
      exit;
    end;

  freemem(socket^.datain,max_data_size);
  freemem(socket^.dataout,max_data_size);
  if socket^.DNS_RESULT<>nil then DNS_DONE(socket^.dns_result);

  done := false;
  repeat
    tcp := oTCP.GetTCPFrame(port,socket^.sourceport,0);
    if tcp<>nil then oTCP.DisposeTCPFrame(tcp) else done := true;
  until done;

  if socket=first_Socket then first_Socket := first_Socket^.next;
  if socket=last_Socket then last_Socket := last_Socket^.prev;
  if socket^.prev<>nil then socket^.prev^.next := socket^.next;
  if socket^.next<>nil then socket^.next^.prev := socket^.prev;

  dispose(socket);
  socket := nil;
  close_socket := true;
end;

Function Write_Socket(var socket:psocket;datalength:word;data:pbyte):byte;
var
 x : word;
 d : pbyte;
Begin
  Write_Socket := Socket_Invalid;
  if socket=nil then exit;
  d := data;
  if not(socket^.status=S_SOCKET_OPEN) then
    Begin
      write_socket := Socket_Not_open;
      exit;
    end;

  if (datalength+socket^.dataoutsize)>MAX_DATA_SIZE then
    Begin
      write_socket := Socket_Overflow;
      exit;
    end;

  {$IFDEF PPP}
  {if not(oPPP.canwrite) then
    Begin
      write_socket := Socket_Overrun;
      exit;
    end;}
  {$ENDIF}

  write_socket := 0;

  if datalength=0 then exit;

  inc(socket^.dataoutsize,datalength);

  for x := 1 to datalength do
    Begin
      oTCP.Addbyte(socket^.dataoutp,d^);
      inc(d);
    end;
end;

Function Socket_Exists(port:word):boolean;
var
 this : psocket;
Begin
 this := First_Socket;
 while this<>nil do
   Begin
     if this^.sourceport = port then
       Begin
         Socket_Exists := True;
         exit;
       end;
     this := this^.next;
   end;
 Socket_Exists := False;
end;

Procedure Read_Socket(var socket:psocket;
                      var datasize:word;
                      var data:pbyte);
var
 pb : pbyte;
 pbp : pbyte;
Begin
  datasize := 0;
  data := nil;
  if (socket=nil) then exit;
  if (socket^.datainsize=0) then exit;
  getmem(pb,socket^.datainsize);
  pbp := pb;
  datasize := socket^.datainsize;
  socket^.datainp := socket^.datain;
  move(socket^.datain^,pbp^,socket^.datainsize);
  socket^.datainsize := 0;
  data := pb;
end;

Procedure Process_Socket(socket:pSocket);
var
 tcp : pTCP;
 done : boolean;
 pb,pbt : pbyte;
 pbl : word;
 x : word;
 frame_received:boolean;
 frames : word;
Begin
  case (socket^.status) of
    S_SEND_REQUEST : Begin    {Request a TCP connection}
                       {$IFDEF DEBUG} writeln('Sending Request'); {$ENDIF}
                       oTCP.SendTCP(random(65535),
                                    socket^.ip,
                                    socket^.sourceport,
                                    socket^.destport,
                                    socket^.sequence_number,
                                    0,SYN,socket^.window_size,0,0,nil);
                       socket^.status := S_WAITING_ACK1;
                     end;
    S_WAITING_ACK1 : Begin
                       tcp := oTCP.GetTCPFrame(port,socket^.sourceport,0);
                       if tcp<>nil then
                         Begin
                           if (tcp^.rst=RST) then
                             Begin
                               socket^.status := S_SOCKET_CLOSED;
                               oTCP.DisposeTCPFrame(tcp);
                               exit;
                             end;
                         if (tcp^.syn=SYN) and (tcp^.ack=ACK) then
                           Begin
                             socket^.sequence_number := tcp^.sequence_number+1;
                             socket^.acknowledgement := tcp^.acknowledgement;
                             {$IFDEF DEBUG}
                             writeln('Sequence        : ',tcp^.sequence_number);
                             writeln('Acknowledgement : ',socket^.sequence_number);
                             {$ENDIF}
                             oTCP.SendTCP(random(65535),
                                          socket^.ip,
                                          socket^.sourceport,
                                          socket^.destport,
                                          socket^.acknowledgement,
                                          socket^.sequence_number,ACK,socket^.window_size,0,0,nil);
                             socket^.send_Window_size := tcp^.window_size;
                             socket^.sws := tcp^.window_size;
                             socket^.sendlock := false;
                             socket^.status := S_SOCKET_OPEN;
                             socket^.cd := 3;
                             socket^.sequence_number := tcp^.acknowledgement;
                           end;{ else socket^.status := S_SEND_REQUEST;}
                           oTCP.disposeTCPFrame(tcp);
                         end;
                       end;
    S_SOCKET_OPEN : Begin
                     done := false;
                     frames := 0;
                     Repeat
                       tcp := oTCP.GetTCPFrame(port,socket^.sourceport,0);
                         if tcp<>nil then
                         Begin
                             {$IFDEF LOG} writeln(lf,'[Recv TCP Frame] Seq :',tcp^.sequence_number:15,' Ack :',
                                          tcp^.acknowledgement:15);{$ENDIF}
                             inc(frames);
                             {$IFDEF DEBUG} writeln('Receiving Info'); {$ENDIF}
                             if (tcp^.fin=FIN) then socket^.oktoclose := true;
                             if (tcp^.ack=ACK) then socket^.acknowledgement := tcp^.acknowledgement;
                             socket^.send_window_size := tcp^.window_size;
                             if socket^.send_window_size<socket^.sws then socket^.sendlock := true
                                    else socket^.sendlock := false;
                             {if tcp^.datasize=0 then socket^.receive_sequence := tcp^.sequence_number+1 else}
                             socket^.receive_sequence := tcp^.sequence_number+tcp^.datasize;
                             {if tcp^.datasize=0 then inc(tcp^.acknowledgement);}
                             if tcp^.datasize>0 then
                               if (tcp^.datasize+socket^.datainsize>MAX_DATA_SIZE) then
                                 Begin
                                   socket^.lasterror := socket_overflow;
                                   {message_box('Socket','Socket OVERFLOW!',OK,4,0);}
                                   done := true;
                                 end else
                               Begin
                                 dec(socket^.window_size,tcp^.datasize);
                                 if (socket^.window_size<0) then socket^.window_size := 0;
                                 inc(socket^.datainsize,tcp^.datasize);
                                  for x := 1 to tcp^.datasize do
                                  Begin
                                    oTCP.Addbyte(socket^.datainp,tcp^.data_ptr^);
                                    inc(tcp^.data_ptr);
                                    {inc(socket^.acknowledgement);}
                                  end;
                               end;
                         if (socket^.dataoutsize>0) and (socket^.send_window_size>=536) then
                          Begin
                            {$IFDEF DEBUG} writeln('Sending Info'); {$ENDIF}
                            getmem(pb,536);
                            if (socket^.dataoutsize>536) then pbl := 536 else pbl := socket^.dataoutsize;
                            move(socket^.dataout^,pb^,pbl);

                            pbt := socket^.dataout;
                            inc(pbt,pbl);
                            move(pbt^,socket^.dataout^,MAX_DATA_SIZE-pbl);

                            dec(socket^.dataoutsize,pbl);
                            dec(socket^.dataoutp,pbl);
                            {socket^.dataoutp := socket^.dataout;}
                            {inc(socket^.dataout,socket^.dataoutsize);}
                            {socket^.dataoutp := pbt;}
                            inc(socket^.window_size,tcp^.datasize);
                            if socket^.window_size>MAX_WINDOW_SIZE then
                               socket^.window_size := MAX_WINDOW_SIZE;
                             oTCP.SendTCP(random(65535),
                                         socket^.ip,
                                         socket^.sourceport,
                                         socket^.destport,
                                         socket^.sequence_number,
                                         socket^.receive_sequence,ACK,socket^.window_size,0,pbl,pb);
                            dec(socket^.send_window_size,pbl);
                            inc(socket^.sequence_number,pbl);
                            freemem(pb,536);
                          end else
                          if (tcp^.datasize>0) then
                           Begin
                             {inc(socket^.receive_sequence);}
                             {inc(socket^.sequence_number);}
                             oTCP.SendTCP(random(65535),
                                          socket^.ip,
                                          socket^.sourceport,
                                          socket^.destport,
                                          socket^.sequence_number,
                                          socket^.receive_sequence,ACK,socket^.window_size,0,0,nil);
                             {inc(socket^.sequence_number);}
                             inc(socket^.window_size,tcp^.datasize);
                             if socket^.window_size>MAX_WINDOW_SIZE then
                               socket^.window_size := MAX_WINDOW_SIZE;
                           end;
                           if socket^.lasterror<>SOCKET_OVERFLOW then oTCP.disposeTCPFrame(tcp);
                         end else done := true;
                       done := true;
                     until done;

                    if not(socket^.sendlock) then
                    if (frames=0) and (socket^.dataoutsize>0) then
                     {if (socket^.send_window_size=socket^.sws) then}
                    Begin
                      {$IFDEF DEBUG} writeln('Sending Info'); {$ENDIF}
                      getmem(pb,536);
                      if (socket^.dataoutsize>socket^.send_window_size) then pbl := socket^.send_window_size
                        else pbl := socket^.dataoutsize;
                      if pbl>536 then pbl := 536;
                      if pbl>0 then
                      Begin
                        move(socket^.dataout^,pb^,pbl);
                        pbt := socket^.dataout;
                        inc(pbt,pbl);
                        move(pbt^,socket^.dataout^,MAX_DATA_SIZE-pbl);
                        dec(socket^.dataoutsize,pbl);
                        dec(socket^.dataoutp,pbl);
                        {inc(socket^.acknowledgement,1);}
                        {socket^.dataoutp := pbt;}
                        oTCP.SendTCP(random(65535),
                                     socket^.ip,
                                     socket^.sourceport,
                                     socket^.destport,
                                     socket^.sequence_number,
                                     socket^.receive_sequence,ACK,socket^.window_size,0,pbl,pb);
                       dec(socket^.send_window_size,pbl);
                       inc(socket^.sequence_number,pbl);
                      end;
                      freemem(pb,536);
                    end;
                  end;
    S_DNS_LOOKUP : if socket^.DNS_RESULT^.complete then
                    Begin
                      socket^.IP := socket^.DNS_RESULT^.IP;
                      socket^.status := S_SEND_REQUEST;
                      DNS_DONE(socket^.DNS_RESULT);
                    end;
  end;
end;

Procedure Handle_Sockets;
var
 this : pSocket;
Begin
 this := First_Socket;
 while (this<>nil) do
   Begin
     Process_Socket(this);
     this := this^.next;
   end;
end;

Constructor TCP_Object.Init; {Nada}
Begin
  First_TCP := nil;
  Last_TCP := nil;
  Cur_TCP := nil;
end;

Destructor TCP_Object.Done; {Nada}
Begin
  while first_TCP<>nil do disposeTCPframe(first_TCP);
end;

Function TCP_Object.B(var frame:pbyte):byte;
Begin
  if frame<>nil then
  Begin
    b := frame^;
    inc(frame);
  end else b := 255;
end;

Function TCP_Object.GetByte(var frame:pbyte):byte;
Begin
  GetByte := b(frame);
end;

Procedure TCP_Object.AddByte(var frame:pbyte;bte:byte);
Begin
  frame^ := bte; inc(frame);
end;

Procedure TCP_Object.SendTCP(ID:longint;
                                      DestIP:iptype;
                                      SourcePort,
                                      DestPort:word;
                                      Sequence_number:longint;
                                      Acknowledgement:longint;
                                      flags : byte;
                                      window_size : word;
                                      urgent_pointer : word;
                                      datalength:word;
                                      Data:pbyte);

var
 fdata : pbyte;
 fdp : pbyte;
 csumptr : pbyte;
 x : word;
 csum : word;
 pip : pbyte;
 hiword,loword : longint;
Begin
  getmem(fdata,20+datalength);
  fdp := fdata;

  pip := oIP.PseudoIP(oPPP.IPaddr,DestIP,TCP_Protocol,datalength+20);

  Addbyte(fdp,sourceport shr 8);
  Addbyte(fdp,sourceport and $00ff);

  Addbyte(fdp,destport shr 8);
  Addbyte(fdp,destport and $00ff);

  Hiword := sequence_number shr 16;
  loword := sequence_number and $0000ffff;

  Addbyte(fdp,hiword shr 8);
  Addbyte(fdp,hiword and $00ff);
  Addbyte(fdp,loword shr 8);
  Addbyte(fdp,loword and $00ff);

  hiword := acknowledgement shr 16;
  loword := acknowledgement and $0000ffff;

  Addbyte(fdp,hiword shr 8);
  Addbyte(fdp,hiword and $00ff);
  Addbyte(fdp,loword shr 8);
  Addbyte(fdp,loword and $00ff);

  Addbyte(fdp,80); {Header Length = 5 in Upper 4-bits}
  Addbyte(fdp,flags);

  Addbyte(fdp,Window_size shr 8);
  Addbyte(fdp,Window_size and $00ff);

  csumptr := fdp;

  Addbyte(fdp,0);
  Addbyte(fdp,0);

  Addbyte(fdp,Urgent_pointer shr 8);
  Addbyte(fdp,Urgent_pointer and $00ff);

  {$IFDEF LOG} writeln(lf,'[Send TCP Frame] Seq :',sequence_number:15,' Ack :',acknowledgement:15);{$ENDIF}
  if datalength>0 then
  for x := 1 to datalength do
    Begin
      Addbyte(fdp,data^);
      inc(data);
    end;

 csum := not cksum(pip,fdata,datalength+20);

 csumptr^ := csum shr 8; inc(csumptr);
 csumptr^ := csum and $00ff; dec(csumptr);

 fdp := fdata;

 oIP.SendIP_Datagram(ID,oPPP.IPaddr,DestIP,TCP_Protocol,datalength+20,fdp);
 freemem(fdata,20+datalength);
 freemem(pip,12);
end;

Procedure TCP_Object.AddTCPFrame(frame:pIP);
var
 lframe : pTCP;
 tmp : word;
 x : byte;
 csum : word;
 tofs : pbyte;
 ph : pbyte;
 dummy : byte;
 pip : pbyte;
Begin
  frame^.data_ptr := frame^.data;
  new(lframe);

  lframe^.id := frame^.id;
  lframe^.sourceip := frame^.sourceip;
  lframe^.destip := frame^.destip;

  lframe^.sourceport := getbyte(frame^.data_ptr) shl 8;
  inc(lframe^.sourceport,getbyte(frame^.data_ptr));

  lframe^.destport := getbyte(frame^.data_ptr) shl 8;
  inc(lframe^.destport,getbyte(frame^.data_ptr));

  if drop_bad_ports then
  if not socket_exists(lframe^.destport) then
    Begin
      inc(TCPDropped);
      dispose(lframe);
      exit;
    end;

  lframe^.sequence_number := longint(getbyte(frame^.data_ptr)) shl 24;
  lframe^.sequence_number := lframe^.sequence_number+ (longint(getbyte(frame^.data_ptr)) shl 16);
  lframe^.sequence_number := lframe^.sequence_number+ (longint(getbyte(frame^.data_ptr)) shl 8);
  lframe^.sequence_number := lframe^.sequence_number+ (longint(getbyte(frame^.data_ptr)));

  lframe^.acknowledgement := longint(getbyte(frame^.data_ptr)) shl 24;
  lframe^.acknowledgement := lframe^.acknowledgement+ (longint(getbyte(frame^.data_ptr)) shl 16);
  lframe^.acknowledgement := lframe^.acknowledgement+ (longint(getbyte(frame^.data_ptr)) shl 8);
  lframe^.acknowledgement := lframe^.acknowledgement+ (longint(getbyte(frame^.data_ptr)));

  dummy := getbyte(frame^.data_ptr);
  lframe^.header_length := (dummy shr 4) shl 2; {1st 4 bits*4 = # of bytes in header}

  dummy := getbyte(frame^.data_ptr);
  lframe^.urg := dummy and URG;
  lframe^.ack := dummy and ACK;
  lframe^.psh := dummy and PSH;
  lframe^.rst := dummy and RST;
  lframe^.syn := dummy and SYN;
  lframe^.fin := dummy and FIN;

  lframe^.window_size := getbyte(frame^.data_ptr) shl 8;
  inc(lframe^.window_size,getbyte(frame^.data_ptr));

  lframe^.checksum := getbyte(frame^.data_ptr) shl 8;
  inc(lframe^.checksum,getbyte(frame^.data_ptr));

  lframe^.urgent_pointer := getbyte(frame^.data_ptr) shl 8;
  inc(lframe^.urgent_pointer,getbyte(frame^.data_ptr));

  if lframe^.header_length>20 then          {bypass options field for now}
    for x := 21 to lframe^.header_length do
      dummy := getbyte(frame^.data_ptr);


  if (frame^.datasize-lframe^.header_length>0) then
    Begin
      lframe^.datasize := frame^.datasize-lframe^.header_length;
      getmem(lframe^.data,lframe^.datasize);
      move(frame^.data_ptr^,lframe^.data^,lframe^.datasize);
      lframe^.data_ptr := lframe^.data;
    end else
    Begin
      lframe^.datasize := 0;
      lframe^.data := nil;
    end;

  lframe^.data_ptr := lframe^.data;

  pip := oIP.PseudoIP(Frame^.sourceIP,frame^.destIP,TCP_Protocol,frame^.datasize);

  csum := cksum(pip,frame^.data_ptr,frame^.datasize);
  freemem(pip,12);

  {$IFDEF DEBUG} writeln('CHECKSUM : ',csum); {$ENDIF}
  if (csum<65535) then
    Begin
      {if (lframe^.datasize>0) then freemem(lframe^.data,lframe^.datasize);
      dispose(lframe);}
      {$IFDEF DEBUG} {writeln('INVALID CRC IN IP FRAME!');} {$ENDIF}
      {exit;}
    end;

  lframe^.data_ptr := lframe^.data;

  lframe^.prev := last_TCP;
  last_TCP := lframe;
  cur_TCP := lframe;
  lframe^.next := nil;
  if first_TCP=nil then first_TCP := lframe;
  if lframe^.prev<>nil then lframe^.prev^.next := lframe;
  cur_TCP:= lframe;
end;

Procedure TCP_Object.DisposeTCPFrame(frame:pTCP);
Begin
  if frame=nil then exit;

  if frame=first_TCP then first_TCP := first_TCP^.next;
  if frame=last_TCP then last_TCP := last_TCP^.prev;
  if frame=cur_TCP then cur_TCP := cur_TCP^.next;

  if frame^.prev<>nil then frame^.prev^.next := frame^.next;
  if frame^.next<>nil then frame^.next^.prev := frame^.prev;

  if frame^.datasize>0 then freemem(frame^.data,frame^.datasize);
  dispose(frame);
end;

Function  TCP_Object.GetTCPFrame(portorid:byte;data,data2:word):pTCP;
var
 this : pTCP;
Begin
  GetTCPFrame := nil;
  this := first_TCP;
  while (this<>nil) do
   Begin
     case portorid of
       PORT : if (this^.destport=data) then
                 Begin
                   GetTCPFrame := This;
                   exit;
                 end;
       ID   : if (this^.id=data) then
                 Begin
                   GetTCPFrame := This;
                   exit;
                 end;
       PORTID : if (this^.destport=data) and (this^.id=data2) then
                 Begin
                   GetTCPFrame := This;
                   exit;
                 end;
     end;
     this := this^.next;
   end;
end;

Function str2pbyte(s:string):pbyte;
var
 pb,pbp : pbyte;
 x : byte;
Begin
 str2pbyte := nil;
 if length(s)=0 then exit;
 getmem(pb,length(s));
 pbp := pb;
 for x := 1 to length(s) do oTcp.Addbyte(pbp,byte(s[x]));
 str2pbyte := pb;
end;

Function Getsocket:word;
Begin
  getsocket := cursocket;
  inc(cursocket);
end;

Begin
  oTCP.Init;
  First_Socket := Nil;
  Last_Socket  := Nil;
  cursocket := 33000;
  tcpdropped := 0;
  drop_bad_ports := true;
  {$IFDEF LOG} assign(lf,'TCP.LOG'); rewrite(lf); {$ENDIF}
end.

