/*
* From: standijl@expert.cc.purdue.edu (Morpheus Nosferatu)
* Newsgroups: rec.games.frp
* Subject: AD&D 1st ed. character party generator (LONG)
* Date: 10 Nov 91 17:44:35 GMT
* Organization: Netherworld Dreamscape
* 
* What follows is a long (1500+ lines) source code file for an NPC party
* generator I posted earlier this semester.
* 
* This version has some minor bugs fixed (thanks to those who pointed out
* the bugs), some minor changes, comments, and some general streamlining
* of the code so it looks better and runs better.
* 
* ------------------------------------------------------------------------
*/

/*	program by Jeff Standish
 *	primary version written May, 1991
 *
 *	(it may be possible to reach me at standish@mentor.cc.purdue.edu,
 *	depending upon which semesters the account is active, no promises)
 *
 *	Second version, with spell book generation,
 *        written May, 1992, by Ken Jenks, 
 *        kjenks@gothamcity.jsc.nasa.gov
 *        Look for lines like:"Begin/End additions for spell book rolling"-- KCJ
 *
 *	This program generates AD&D characters.  Compile it and run it,
 *	the 'usage' statement should be sufficiently coherent enough to
 *	tell you what to enter to get it to do what you want it to.
 *
 *	Any suggestions are welcome.
 *
 *	Note that the settings for monks are for either the monks out of
 *	the Players Handbook, or for the ones from Dragon Magazine (Best
 *	of, Vol III).
 *
 */

#include <ctype.h>
#include <math.h>
#include <stdio.h>
#define Strength	0
#define Intelligence	1
#define Wisdom		2
#define Dexterity	3
#define Constitution	4
#define Charisma	5
#define Comeliness	6
#define Excep_Str	7
#define Hit_Points	8
#define Race		9
#define DemiPercent    20   /* % of NPC's who are demi-humans, should be 20 */
#define MonkLevel      17   /* max level for monks, 17 normal or 21 Dragon */
#define MonkHitDice	4   /* hit dice for monks, 4 normal or 6 Dragon Mgz */

	/* random character level for given level of dungeon */
static int donjon[16][20] = {
{ 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3 },  /* 1 */
{ 1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,4,5 },
{ 1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,4,5 },
{ 1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,3,4,4,5,6 },
{ 1,1,1,2,2,2,3,3,3,3,3,3,4,4,4,4,5,5,6,7 },  /* 5 */
{ 1,1,2,2,3,3,4,4,4,4,4,4,5,5,5,5,6,6,7,8 },
{ 1,2,2,3,3,4,4,4,4,4,5,5,5,5,6,6,7,7,8,9 },
{ 1,2,3,3,4,4,4,5,5,5,6,6,6,6,7,7,8,8,9,10 },
{ 1,2,3,4,4,5,5,5,6,6,6,6,7,7,7,8,8,9,9,10 },
{ 1,2,3,4,5,5,6,6,6,7,7,7,8,8,8,9,9,9,9,10 },  /* 10 */
{ 1,2,3,4,5,5,6,6,6,7,7,7,8,8,8,9,9,9,9,10 },
{ 1,2,3,4,5,6,6,7,7,8,8,8,9,9,9,9,9,9,10,10 },
{ 1,2,3,4,5,6,6,7,7,8,8,8,9,9,9,9,9,9,10,10 },
{ 1,2,3,4,5,6,7,7,8,8,8,9,9,9,9,9,9,10,10,10 },
{ 1,2,3,4,5,6,7,7,8,8,8,9,9,9,9,9,9,10,10,10 }, /* 15 */
{ 1,2,3,4,5,6,7,8,8,8,9,9,9,9,9,9,10,10,10,10 }
};

	/* comeliness bonues due to charisma */
static int come_bonus[19] = {-5,-5,-5,-5,-3,-3,-1,-1,-1,0,0,0,0,1,1,1,2,2,3};

	/* size of die to roll for hit points */
static int hit_dice[12] = {8,8,10,12,10,10,8,4,4,6,6,MonkHitDice};

	/* bonus hit points gained per level when reach title level */
static int hit_bonus[12] = {2,2,3,4,3,3,2,1,1,2,1,1};

	/* minimum number of hit points rolled on the dice */
static int min_hit[12] = {3,3,4,4,4,4,3,2,2,3,3,3};

	/* level at which reach max number of hit dice */
static int max_hit_dice[12] = {9,14,9,8,10,9,11,11,10,10,15,MonkLevel};

	/* hit point bonus from constitution */
static int con_bonus[20] = {-3,-2,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,1,2,3,4,5};

	/* maximum level character class can achieve */
static int max_level[12] = {0,23,0,0,0,0,0,0,0,0,15,MonkLevel};

	/* numbers of single classes for multi-classed characters, for
	   purposes of rolling hit points */
static int multi_hd[11][2] = {
{ 0,10 }, { 0,2 }, { 0,7 }, { 0,6 }, { 0,9 }, { 2,10 }, { 2,8 }, { 2,7 },
{ 2,9 },  { 8,9 }, { 7,9 }
};

	/* mimimum ability scores for classes, does not include comeliness */
static int min_ability[23][6] = {
{ 5,5,9,3,5,5 },     { 5,5,12,5,5,15 },    { 9,3,5,5,7,5 },
{ 15,3,5,14,15,5 },  { 15,10,10,15,15,5 }, { 12,9,13,5,9,17 },
{ 13,13,14,5,14,5 }, { 3,9,5,6,5,5 },	   { 5,15,5,16,3,5 },
{ 5,5,3,9,5,5 },     { 12,11,5,12,5,3 },   { 15,5,15,15,11,5 },
{ 12,11,9,12,5,5 },  { 9,5,9,5,7,5 },	   { 5,9,9,6,5,5 },
{ 13,13,14,5,14,5 }, { 5,5,9,9,5,5 },	   { 12,11,5,12,7,5 },
{ 9,15,5,16,7,5 },   { 9,9,5,6,7,5 },	   { 9,5,5,9,7,5 },
{ 5,15,5,16,5,5 },   { 5,9,5,9,5,5 }
};

	/* maximum exeptional strength by race */
static int max_x_str[7] = { 99,75,50,90,0,99,100 };

	/* names of races */
static char *races[7] = {
"Dwarf", "Elf", "Gnome", "Half-Elf", "Halfling", "Half-Orc", "Human" };

	/* abbreviated names of races */
static char *race_abrev[7] = {
"D ", "E ", "G ", "HE", "Hl", "HO", "Hu" };

	/* minimum racial ability scores, not including comeliness */
static int race_min[7][6] = {
{ 8,3,3,3,12,3 },  { 3,8,3,7,6,8 },   { 6,7,3,3,8,3 },
{ 3,4,3,6,6,3 },   { 6,6,3,8,10,3 },  { 6,3,3,3,13,3 },
{ 3,3,3,3,3,3 }
};

	/* maximum racial ability scores, not including comeliness */
static int race_max[7][6] = {
{ 18,18,18,17,19,16 },	{ 18,18,18,19,18,18 },	{ 18,18,18,18,18,18 },
{ 18,18,18,18,18,18 },	{ 17,18,17,18,19,18 },	{ 18,17,14,17,19,12 },
{ 18,18,18,18,18,18 }
};

	/* racial ability bonuses/penalties, includes comeliness */
static int race_bonus[7][7] = {
{ 0,0,0,0,1,-1,-1 },  { 0,0,0,1,-1,0,2 },  { 0,0,0,0,0,0,-1 },
{ 0,0,0,0,0,0,1 },    { -1,0,0,1,0,0,0 },  { 1,0,0,0,1,-2,-3 },
{ 0,0,0,0,0,0,0 }
};

	/* names of character classes */
static char *class_name[23] = {
"Cleric", "Druid", "Fighter", "Barbarian", "Cavalier", "Paladin", "Ranger",
"Magic-user", "Illusionist", "Thief", "Assassin", "Martial artist (Monk)",
"Cleric/Assassin", "Cleric/Fighter", "Cleric/Magic-User", "Cleric/Ranger",
"Cleric/Thief", "Fighter/Assassin", "Fighter/Illusionist",
"Fighter/Magic-User", "Fighter/Thief", "Illusionist/Thief",
"Magic-User/Thief" };

	/* abbreviations for character classes */
static char *class_abrev[23] = {
"Clrc", "Drid", "Fght", "Brbn", "Cvlr", "Pldn", "Rngr", "Mage", "Ilsn",
"Thif", "Assn", "Monk", "C/A ", "C/F ", "C/MU", "C/R ", "C/T ", "F/A ",
"F/I ", "F/MU", "F/T ", "I/T ", "MU/T" };

	/* list of true/false values for whether or not characters of a
	   given class can have exceptional strength */
static int is_exp_str[23] = {
0,0,1,1,1,1,1,0,0,0,0,0,0,1,0,1,0,1,1,1,1,0,0 };

/* Begin additions for spell book rolling -- KCJ */

	/* Spell books start at level 1 for MU, Ilsn; level 9 for Rngr */
static int when_gets_spells[23] = {
0,0,0,0,0,0,9,1,1,0,0,0,0,0,1,0,0,0,1,1,0,1,1 };

	/* Global array used to determine if char already has a spell */
static int already_in_book[9][30];

	/* Which spell book table does character use?  -1=none,0=MU,1=Illus */
static int which_spell_book[23] = {
-1,-1,-1,-1,-1,-1,0,0,1,-1,-1,-1,-1,-1,0,-1,-1,-1,1,0,-1,1,0 };
/* Note: I didn't use the usual "null == none" convention here
 * so I could have which_spell_book[clas] be the first index to
 * the next table.... */

#define MU	0
#define ILSN	1

/* Note to future developers: If you change the spell_list table, you'll
 * need to change the initial_mu_spells table, too. */

static char *spell_list[2][9][30] = {{

	/* 0=MU Spell Book Table */
{"Affect Normal Fires",	/* 1 */
"Burning Hands",	/* 2 */
"Charm Person",	/* 3 */
"Comprehend Languages",	/* 4 */
"Dancing Lights",	/* 5 */
"Detect Magic",	/* 6 */
"Enlarge",	/* 7 */
"Erase",	/* 8 */
"Feather Fall",	/* 9 */
"Find Familiar",	/* 10 */
"Friends",	/* 11 */
"Hold Portal",	/* 12 */
"Identify",	/* 13 */
"Jump",	/* 14 */
"Light",	/* 15 */
"Magic Missile",	/* 16 */
"Mending",	/* 17 */
"Message",	/* 18 */
"Nystul's Magic Aura",	/* 19 */
"Protection from Evil",	/* 20 */
"Push",	/* 21 */
"Read Magic",	/* 22: Read Magic is a special case; all MU's have it */

#define ReadMagic 22

"Shield",	/* 23 */
"Shocking Grasp",	/* 24 */
"Sleep",	/* 25 */
"Spider Climb",	/* 26 */
"Tenser's Floating Disc",	/* 27 */
"Unseen Servant",	/* 28 */
"Ventriloquism",	/* 29 */
"Write"},	/* 30 */

/* MU Level 2 */
{"Audible Glamer",	/* 1 */
"Continual Light",	/* 2 */
"Darkness, 15' Radius",	/* 3 */
"Detect Evil",		/* 4 */
"Detect Invisibility",	/* 5 */
"ESP",	/* 6 */
"Fool's Gold",	/* 7 */
"Forget",	/* 8 */
"Invisibility",	/* 9 */
"Knock",	/* 10 */
"Leomund's Trap",	/* 11 */
"Levitate",	/* 12 */
"Locate Object",	/* 13 */
"Magic Mouth",	/* 14 */
"Mirror Image",	/* 15 */
"Pyrotechnics",	/* 16 */
"Ray of Enfeeblement",	/* 17 */
"Rope Trick",	/* 18 */
"Scare",	/* 19 */
"Shatter",	/* 20 */
"Stinking Cloud",	/* 21 */
"Strength",	/* 22 */
"Web",	/* 23 */
"Wizard Lock",	/* 24 */
"",	/* 25 */
"",	/* 26 */
"",	/* 27 */
"",	/* 28 */
"",	/* 29 */
""},	/* 30 */

/* MU Level 3 */
{"Blink",	/* 1 */
"Clairaudience",	/* 2 */
"Clairvoyance",	/* 3 */
"Dispel Magic",	/* 4 */
"Explosive Runes",	/* 5 */
"Feign Death",	/* 6 */
"Fireball",	/* 7 */
"Flame Arrow",	/* 8 */
"Fly",	/* 9 */
"Gust of Wind",	/* 10 */
"Haste",	/* 11 */
"Hold Person",	/* 12 */
"Infravision",	/* 13 */
"Invisibility 10' Radius",	/* 14 */
"Leomund's Tiny Hut",	/* 15 */
"Lightning Bolt",	/* 16 */
"Monster Summoning I",	/* 17 */
"Phantasmal Force",	/* 18 */
"Protection from Evil 10' Radius",	/* 19 */
"Protection from Normal Missiles",	/* 20 */
"Slow",	/* 21 */
"Suggestion",	/* 22 */
"Tongues",	/* 23 */
"Water Breathing",	/* 24 */
"",	/* 25 */
"",	/* 26 */
"",	/* 27 */
"",	/* 28 */
"",	/* 29 */
""},	/* 30 */

/* MU Level 4 */
{"Charm Monster",	/* 1 */
"Confusion",	/* 2 */
"Dig",	/* 3 */
"Dimension Door",	/* 4 */
"Enchanted Weapon",	/* 5 */
"Extension I",	/* 6 */
"Fear",	/* 7 */
"Fire Charm",	/* 8 */
"Fire Shield",	/* 9 */
"Fire Trap",	/* 10 */
"Fumble",	/* 11 */
"Hallucinatory Terrain",	/* 12 */
"Ice Storm",	/* 13 */
"Massmorph",	/* 14 */
"Minor Globe of Invulnerability",	/* 15 */
"Monster Summoning II",	/* 16 */
"Plant Growth",	/* 17 */
"Polymorph Other",	/* 18 */
"Polymorph Self",	/* 19 */
"Rary's Mnemonic Enhancer",	/* 20 */
"Remove Curse",	/* 21 */
"Wall of Fire",	/* 22 */
"Wall of Ice",	/* 23 */
"Wizard Eye",	/* 24 */
"",	/* 25 */
"",	/* 26 */
"",	/* 27 */
"",	/* 28 */
"",	/* 29 */
""},	/* 30 */

/* MU Level 5 */
{"Airy Water",	/* 1 */
"Animal Growth",	/* 2 */
"Animate Dead",	/* 3 */
"Bigby's Interposing Hand",	/* 4 */
"Cloudkill",	/* 5 */
"Conjure Elemental",	/* 6 */
"Cone of Cold",	/* 7 */
"Contact Other Plane",	/* 8 */
"Distance Distortion",	/* 9 */
"Extension III",	/* 10 */
"Feeblemind",	/* 11 */
"Hold Monster",	/* 12 */
"Leomund's Secret Chest",	/* 13 */
"Magic Jar",	/* 14 */
"Monster Summoning II",	/* 15 */
"Modenkainen's Faithful Hound",	/* 16 */
"Passwall",	/* 17 */
"Stone Shape",	/* 18 */
"Telekinesis",	/* 19 */
"Teleport",	/* 20 */
"Transmute Rock to Mud",	/* 21 */
"Wall of Force",	/* 22 */
"Wall of Iron",	/* 23 */
"Wall of Stone",	/* 24 */
"",	/* 25 */
"",	/* 26 */
"",	/* 27 */
"",	/* 28 */
"",	/* 29 */
""},	/* 30 */

/* MU Level 6 */
{"Anti-Magic Shell",	/* 1 */
"Bigby's Forceful Hand",	/* 2 */
"Control Weather",	/* 3 */
"Death Spell",	/* 4 */
"Disintigrate",	/* 5 */
"Enchant an Item",	/* 6 */
"Extension III",	/* 7 */
"Geas",	/* 8 */
"Glassee",	/* 9 */
"Globe of Invulnerability",	/* 10 */
"Guards and Wards",	/* 11 */
"Invisible Stalker",	/* 12 */
"Legend Lore",	/* 13 */
"Lower Water",	/* 14 */
"Monster Summoning IV",	/* 15 */
"Move Earth",	/* 16 */
"Otiluke's Freezing Sphere",	/* 17 */
"Part Water",	/* 18 */
"Project Image",	/* 19 */
"Reincarate",	/* 20 */
"Repulsion",	/* 21 */
"Spiritwrack",	/* 22 */
"Stone to Flesh",	/* 23 */
"Tenser's Transformation",	/* 24 */
"",	/* 25 */
"",	/* 26 */
"",	/* 27 */
"",	/* 28 */
"",	/* 29 */
""},	/* 30 */

/* MU Level 7 */
{"Bigby's Grasing Hand",	/* 1 */
"Cacodemon",	/* 2 */
"Charm Plants",	/* 3 */
"Delayed Blast Fireball",	/* 4 */
"Drawmij's Instant Summons",	/* 5 */
"Duo-Dimension",	/* 6 */
"Limited Wish",	/* 7 */
"Mass Invisibility",	/* 8 */
"Monster Summoning V",	/* 9 */
"Mordenkainen's Sword",	/* 10 */
"Phase Door",	/* 11 */
"Power Word, Stun",	/* 12 */
"Reverse Gravity",	/* 13 */
"Similicrum",	/* 14 */
"Statue",	/* 15 */
"Vanish",	/* 16 */
"",	/* 17 */
"",	/* 18 */
"",	/* 19 */
"",	/* 20 */
"",	/* 21 */
"",	/* 22 */
"",	/* 23 */
"",	/* 24 */
"",	/* 25 */
"",	/* 26 */
"",	/* 27 */
"",	/* 28 */
"",	/* 29 */
""},	/* 30 */

/* MU Level 8 */
{"Antipathy/Sympathy",	/* 1 */
"Bigby's Clenched Fist",	/* 2 */
"Clone",	/* 3 */
"Glassteel",	/* 4 */
"Incendiary Cloud",	/* 5 */
"Mass Charm",	/* 6 */
"Maze",	/* 7 */
"Mind Blank",	/* 8 */
"Monster Summoning VI",	/* 9 */
"Otto's Irresistable Dance",	/* 10 */
"Permanency",	/* 11 */
"Polymorph Any Object",	/* 12 */
"Power Word, Blind",	/* 13 */
"Serten's Spell Immunity",	/* 14 */
"Symbol",	/* 15 */
"Trap The Soul",	/* 16 */
"",	/* 17 */
"",	/* 18 */
"",	/* 19 */
"",	/* 20 */
"",	/* 21 */
"",	/* 22 */
"",	/* 23 */
"",	/* 24 */
"",	/* 25 */
"",	/* 26 */
"",	/* 27 */
"",	/* 28 */
"",	/* 29 */
""},	/* 30 */

/* MU Level 9 */
{"Astral Spell",	/* 1 */
"Bigby's Crushing Hand",	/* 2 */
"Gate",	/* 3 */
"Imprisonment",	/* 4 */
"Meteor Swarm",	/* 5 */
"Monster Summoning VII",	/* 6 */
"Power Word, Kill",	/* 7 */
"Prismatic Sphere",	/* 8 */
"Shape Change",	/* 9 */
"Temporal Stasis",	/* 10 */
"Time Stop",	/* 11 */
"Wish",	/* 12 */
"",	/* 13 */
"",	/* 14 */
"",	/* 15 */
"",	/* 16 */
"",	/* 17 */
"",	/* 18 */
"",	/* 19 */
"",	/* 20 */
"",	/* 21 */
"",	/* 22 */
"",	/* 23 */
"",	/* 24 */
"",	/* 25 */
"",	/* 26 */
"",	/* 27 */
"",	/* 28 */
"",	/* 29 */
""},	/* 30 */

}, /* end MU Spell Book Table */

{
	/* 1=Illusionist Spell Book Table */

/* Illusionist Level 1 */
{"Audible Glamer",	/* 1 */
"Change Self",	/* 2 */
"Color Spray",	/* 3 */
"Dancing Lights",		/* 4 */
"Darkness",	/* 5 */
"Detect Illusion",	/* 6 */
"Detect Invisibility",	/* 7 */
"Gaze Reflection",	/* 8 */
"Hypnotism",	/* 9 */
"Light",	/* 10 */
"Phantasmal Force",	/* 11 */
"Wall of Fog",	/* 12 */
"",	/* 13 */
"",	/* 14 */
"",	/* 15 */
"",	/* 16 */
"",	/* 17 */
"",	/* 18 */
"",	/* 19 */
"",	/* 20 */
"",	/* 21 */
"",	/* 22 */
"",	/* 23 */
"",	/* 24 */
"",	/* 25 */
"",	/* 26 */
"",	/* 27 */
"",	/* 28 */
"",	/* 29 */
""},	/* 30 */

/* Illusionist Level 2 */
{"Blindness",	/* 1 */
"Blur",	/* 2 */
"Deafness",	/* 3 */
"Detect Magic",	/* 4 */
"Fog Cloud",	/* 5 */
"Hypnotic Pattern",	/* 6 */
"Improved Phantasmal Force",	/* 7 */
"Invisibility",	/* 8 */
"Magic Mouth",	/* 9 */
"Mirror Image",	/* 10 */
"Misdirection",	/* 11 */
"Ventriloquism",	/* 12 */
"",	/* 13 */
"",	/* 14 */
"",	/* 15 */
"",	/* 16 */
"",	/* 17 */
"",	/* 18 */
"",	/* 19 */
"",	/* 20 */
"",	/* 21 */
"",	/* 22 */
"",	/* 23 */
"",	/* 24 */
"",	/* 25 */
"",	/* 26 */
"",	/* 27 */
"",	/* 28 */
"",	/* 29 */
""},	/* 30 */

/* Illusionist Level 3 */
{"Continual Darkness",	/* 1 */
"Continual Light",	/* 2 */
"Dispel Illusion",	/* 3 */
"Fear",	/* 4 */
"Hallucinatory Terrain",	/* 5 */
"Illusionary Script",	/* 6 */
"Invisibility 10' Radius",	/* 7 */
"Non-detection",	/* 8 */
"Paralyzation",	/* 9 */
"Rope Trick",	/* 10 */
"Spectral Force",	/* 11 */
"Suggestion",	/* 12 */
"",	/* 13 */
"",	/* 14 */
"",	/* 15 */
"",	/* 16 */
"",	/* 17 */
"",	/* 18 */
"",	/* 19 */
"",	/* 20 */
"",	/* 21 */
"",	/* 22 */
"",	/* 23 */
"",	/* 24 */
"",	/* 25 */
"",	/* 26 */
"",	/* 27 */
"",	/* 28 */
"",	/* 29 */
""},	/* 30 */

/* Illusionist Level 4 */
{"Confusion",	/* 1 */
"Dispel Exhaustion",	/* 2 */
"Emotion",	/* 3 */
"Improved Invisibility",	/* 4 */
"Massmorph",	/* 5 */
"Minor Creation",	/* 6 */
"Phantasmal Killer",	/* 7 */
"Shadow Monsters",	/* 8 */
"",	/* 9 */
"",	/* 10 */
"",	/* 11 */
"",	/* 12 */
"",	/* 13 */
"",	/* 14 */
"",	/* 15 */
"",	/* 16 */
"",	/* 17 */
"",	/* 18 */
"",	/* 19 */
"",	/* 20 */
"",	/* 21 */
"",	/* 22 */
"",	/* 23 */
"",	/* 24 */
"",	/* 25 */
"",	/* 26 */
"",	/* 27 */
"",	/* 28 */
"",	/* 29 */
""},	/* 30 */

/* Illusionist Level 5 */
{"Chaos",	/* 1 */
"Demi-Shadow Monsters",	/* 2 */
"Major Creation",	/* 3 */
"Maze",	/* 4 */
"Projected Image",	/* 5 */
"Shadow Door",	/* 6 */
"Shadow Magic",	/* 7 */
"Summon Shadow",	/* 8 */
"",	/* 9 */
"",	/* 10 */
"",	/* 11 */
"",	/* 12 */
"",	/* 13 */
"",	/* 14 */
"",	/* 15 */
"",	/* 16 */
"",	/* 17 */
"",	/* 18 */
"",	/* 19 */
"",	/* 20 */
"",	/* 21 */
"",	/* 22 */
"",	/* 23 */
"",	/* 24 */
"",	/* 25 */
"",	/* 26 */
"",	/* 27 */
"",	/* 28 */
"",	/* 29 */
""},	/* 30 */

/* Illusionist Level 6 */
{"Conjure Animals",	/* 1 */
"Demi-Shadow Magic",	/* 2 */
"Mass Suggestion",	/* 3 */
"Permanent Illusion",	/* 4 */
"Programmed Illusion",	/* 5 */
"Shades",	/* 6 */
"True Sight",	/* 7 */
"Veil",	/* 8 */
"",	/* 9 */
"",	/* 10 */
"",	/* 11 */
"",	/* 12 */
"",	/* 13 */
"",	/* 14 */
"",	/* 15 */
"",	/* 16 */
"",	/* 17 */
"",	/* 18 */
"",	/* 19 */
"",	/* 20 */
"",	/* 21 */
"",	/* 22 */
"",	/* 23 */
"",	/* 24 */
"",	/* 25 */
"",	/* 26 */
"",	/* 27 */
"",	/* 28 */
"",	/* 29 */
""},	/* 30 */

/* Illusionist Level 7 */
{"Alter Reality",	/* 1 */
"Astral Spell",	/* 2 */
"Prismatic Spray",	/* 3 */
"Prismatic Wall",	/* 4 */
"Vision",	/* 5 */
"First Level Magic-User Spells",	/* 6 */
"",	/* 7 */
"",	/* 8 */
"",	/* 9 */
"",	/* 10 */
"",	/* 11 */
"",	/* 12 */
"",	/* 13 */
"",	/* 14 */
"",	/* 15 */
"",	/* 16 */
"",	/* 17 */
"",	/* 18 */
"",	/* 19 */
"",	/* 20 */
"",	/* 21 */
"",	/* 22 */
"",	/* 23 */
"",	/* 24 */
"",	/* 25 */
"",	/* 26 */
"",	/* 27 */
"",	/* 28 */
"",	/* 29 */
""},	/* 30 */

/* Illusionist Level 8 */
{"",	/* 1 */
"",	/* 2 */
"",	/* 3 */
"",	/* 4 */
"",	/* 5 */
"",	/* 6 */
"",	/* 7 */
"",	/* 8 */
"",	/* 9 */
"",	/* 10 */
"",	/* 11 */
"",	/* 12 */
"",	/* 13 */
"",	/* 14 */
"",	/* 15 */
"",	/* 16 */
"",	/* 17 */
"",	/* 18 */
"",	/* 19 */
"",	/* 20 */
"",	/* 21 */
"",	/* 22 */
"",	/* 23 */
"",	/* 24 */
"",	/* 25 */
"",	/* 26 */
"",	/* 27 */
"",	/* 28 */
"",	/* 29 */
""},	/* 30 */

/* Illusionist Level 9 */
{"",	/* 1 */
"",	/* 2 */
"",	/* 3 */
"",	/* 4 */
"",	/* 5 */
"",	/* 6 */
"",	/* 7 */
"",	/* 8 */
"",	/* 9 */
"",	/* 10 */
"",	/* 11 */
"",	/* 12 */
"",	/* 13 */
"",	/* 14 */
"",	/* 15 */
"",	/* 16 */
"",	/* 17 */
"",	/* 18 */
"",	/* 19 */
"",	/* 20 */
"",	/* 21 */
"",	/* 22 */
"",	/* 23 */
"",	/* 24 */
"",	/* 25 */
"",	/* 26 */
"",	/* 27 */
"",	/* 28 */
"",	/* 29 */
""},	/* 30 */

}  /* end Illusionist Spell List */
}; /* end Spell List */

	/* Classes have differing chances of finding spells for spell books */
static int chance_to_find_spells[23] = {
0,0,0,0,0,0,7,15,10,0,0,0,0,0,20,0,0,0,7,10,0,7,10 };

	/* chance to learn spells, indexed by INT */
static int chance_to_learn_spells[25] = {
        0,0,0,0,0,0,0,0,35,45,45,45,55,55,65,65,75,85,95,96,97,98,99,100,100};
/* INT: 1,2,3,4,5,6,7,8, 9,10,11,12,13,14,15,16,17,18,19,20,21,22,23, 24, 25 */

	/* max number of spells per spell level, indexed by INT-1 */
static int max_spells[25] = {
        0,0,0,0,0,0,0,0,6, 7, 7, 7, 9, 9,11,11,14,18,99,99,99,99,99,99,99};
/* INT: 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25 */

	/* min number of spells per spell level, indexed by INT-1 */
        /* THIS IS NOT USED IN THE CURRENT VERSION OF THE PROGRAM. */
static int min_spells[25] = {
        0,0,0,0,0,0,0,0,4, 5, 5, 5, 6, 6, 7, 7, 8, 9,10,11,12,13,15,16,17};
/* INT: 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25 */

	/* maximum spell level, indexed by character level (18 max) */
static int max_spell_level[2][18] = {
/* Level      1  2  3  4  5  6  7  8  9 10 11 12 13 14 15 16 17 18+ */
/* MU    */ { 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7, 7, 8, 8, 9}, 
/* ILSN  */ { 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7, 7, 8, 8, 9}};

	/* initial MU spells: 0=offensive, 1=defensive, 2=misc */
static int initial_mu_spells[3][10] = {
/* Off   */ { 2, 3, 7,11,15,16,21,24,25,25}, /* Kludge: (choice)=Sleep */
/* Def   */ { 1, 5, 9,12,14,20,23,26,29,23}, /* Kludge: (choice)=Shield */
/* Misc  */ { 4, 6, 8,10,13,17,18,28,30, 2}};/* Kludge: (choice)=Det Magic */

/* Note to future developers: If you change the spell_list table, you'll
 * need to change the initial_mu_spells table, too. */

/* Kludge justification: These are (arguably) the best spells of the
 * categories.  It seems logical that characters would choose these. 
 * See table, page 39 DMG. */

/* End additions for spell book rolling -- KCJ */

	/* which random magic item table does character class roll on? */
static int class_magic[23] = {
0,0,1,1,1,1,1,2,2,3,3,4,0,1,2,1,0,1,2,2,1,2,2 };

	/* number of dice to roll for a abilites scores, by class */
static int die_num[23][7] = {
{ 7,4,9,5,8,6,3 }, { 7,4,8,5,6,9,3 }, { 9,3,5,7,8,6,4 },
{ 9,3,5,7,8,6,4 }, { 8,6,4,7,9,3,5 }, { 7,5,8,3,6,9,4 },
{ 7,6,8,5,9,4,3 }, { 4,9,7,8,6,5,3 }, { 3,8,7,9,5,6,4 },
{ 6,5,3,9,7,4,8 }, { 6,7,4,9,8,3,5 }, { 7,5,9,8,6,4,3 },
{ 6,5,7,8,9,4,3 }, { 9,4,7,6,8,5,3 }, { 5,7,9,6,8,4,3 },
{ 7,5,8,6,9,4,3 }, { 7,3,6,8,9,5,4 }, { 7,6,5,9,8,4,3 },
{ 7,5,6,9,8,4,3 }, { 7,6,5,9,8,4,3 }, { 8,4,3,9,7,6,5 },
{ 3,8,5,9,7,4,6 }, { 6,8,5,9,7,3,4 }
};

	/* for each demi-human race, which single-class classes can a
	   character have? */
static int demisingle[6][12] = {
{ 1,0,1,0,0,0,0,0,0,1,1,0 },
{ 1,1,1,0,1,0,1,1,0,1,1,0 },
{ 1,0,1,0,0,0,0,0,1,1,1,0 },
{ 1,1,1,0,1,1,1,1,0,1,1,0 },
{ 1,1,1,0,0,0,0,0,0,1,0,0 },
{ 1,0,1,0,0,0,0,0,0,1,1,0 }
};

	/* listing of multi-class classes that demi-human can have,
	   first number is chance of being multi-classed,
	   second number is number of possible classes, and
	   following numbers are numbers of multi-class classes can be */
static int demiclass[6][8] = {
{ 15, 2,12,20 },
{ 85, 3,19,20,22 },
{ 25, 3,18,20,21 },
{ 85, 6,13,14,15,19,20,22 },
{ 10, 1,20 },
{ 50, 5,12,13,16,17,20 }
};

	/* by level, grouped in four pairs, the first number of the pair
	   if the chance of having an item from that group, and the second
	   number is the number of items that will have from the group */
static int items_level[13][8] = {
{  10,1,   0,0,   0,0,   0,0 },
{  20,2,   0,0,   0,0,   0,0 },
{  30,2,  10,1,   0,0,   0,0 },
{  40,2,  20,1,   0,0,   0,0 },
{  50,2,  30,1,   0,0,   0,0 },
{  60,3,  40,2,   0,0,   0,0 },
{  70,3,  50,2,  10,1,   0,0 },
{  80,3,  60,2,  20,1,   0,0 },
{  90,3,  70,2,  30,1,   0,0 },
{ 100,3,  80,2,  40,1,   0,0 },
{ 100,3,  90,2,  50,1,  10,1 },
{ 100,3, 100,2,  60,1,  20,1 },
{ 100,3, 100,2, 100,1,  60,1 }
};

	/* random magic items for clerics, first number is number of items
	   that are possible, and the following numbers are the numbers of
	   the items on the lists of magic items below */
static int cleric_magic[4][21] = {
{ 14, 1, 2, 3, 4, 6, 8, 9,10,11,12,13,14,15,20 },
{ 14, 1, 2, 3, 4, 6, 7, 8, 9,10,11,13,14,15,16 },
{ 14, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,15 },
{  8, 1, 2, 3, 5, 7, 8, 9,10 }
};

static int fighter_magic[4][21] = {
{ 18, 1, 2, 3, 4, 5, 6, 7,10,11,12,13,14,15,16,17,18,19,20 },
{ 13, 2, 3, 6, 7, 8, 9,10,11,12,13,14,15,16 },
{ 15, 1, 2, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16 },
{  8, 1, 2, 3, 5, 7,10,11,12 }
};

static int mage_magic[4][21] = {
{ 11, 1, 2, 3, 4, 6, 8, 9,10,11,12,18 },
{ 11, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11 },
{ 10, 1, 2, 3, 4, 5, 6, 7, 9,10,11 },
{  7, 1, 2, 4, 5, 6, 7, 8 }
};

static int thief_magic[4][21] = {
{ 14, 1, 2, 3, 4, 6, 8, 9,10,11,12,13,15,16,18 },
{  9, 2, 3, 6, 7, 8, 9,10,11,15 },
{ 11, 1, 2, 4, 5, 6, 7, 8, 9,10,11,14 },
{  6, 1, 2, 5, 7,11,12 }
};

static int monk_magic[4][21] = {
{ 12, 1, 2, 3, 4, 6,10,11,12,15,17,18,19 },
{ 10, 2, 3, 6, 7, 8, 9,10,11,12,15 },
{ 12, 1, 2, 4, 5, 6, 7, 8, 9,10,11,14,16 },
{  5, 1, 2, 5, 7,11 }
};

	/* first group of magic items */
static char *magic_I[20] = {
"2 potions: climbing, flying",
"2 potions: extra-healing, polymorph (self)",
"2 potions: fire resistance, speed",
"2 potions: healing, giant strength",
"2 potions: heroism, invulnerability",
"2 potions: human control, levitation",
"2 potions: super-heroism, animal control",
"1 scroll: 1 spell, level 1-6",
"1 scroll: 2 spells, level 1-4",
"1 scroll: protection from magic",
"ring of mammal control",
"ring of protection +1",
"leather armor +1",
"shield +1",
"sword +1",
"10 arrows +1",
"4 bolts +2",
"dagger +1",
"javelin +2",
"mace +1"
};

	/* second group of magic items */
static char *magic_II[16] = {
"1 scroll: 3 spells, level 2-9 or 2-7",
"2 rings: fire resistance, invisibility",
"ring of protection +3",
"staff of striking",
"wand of illusion",
"wand of negation",
"bracers of defense, armor class 4",
"broach of shielding",
"cloak of elvenkind",
"dust of disappearance",
"1 figurine of wondrous power: serpentine owl",
"3 javelins of lightning",
"chainmail +1, shield +2",
"splint mail +3",
"sword +3",
"crossbow of speed, hammer +2"
};

	/* third group of magic items */
static char *magic_III[16] = {
"ring of spell storing",
"rod of cancellation",
"staff of the serpent -- python or adder",
"bag of tricks",
"boots of speed",
"boots of striding and leaping",
"cloak of displacement",
"gauntlets of ogre power",
"pipe of sewers",
"robe of blending",
"2 ropes: climbing, entanglement",
"plate mail +2, shield +2",
"shield +4",
"sword +4 (25% special type)",
"mace +3",
"spear +3"
};

	/* fourth group of magic items */
static char *magic_IV[12] = {
"ring of djinni summoning",
"ring of spell turning",
"rod of smiting",
"wand of fire",
"cube of force",
"eyes of charming",
"horn of Valhalla",
"robe of scintillating colors",
"talisman of ultimate evil or pure good",
"plate mail +4, shield +3",
"sword (special type)",
"1 arrow of slaying"
};

	/* grouping of some messages to cut out bunch of printf statements */
static char *messages[22] = {
"Random AD&D NPC generator, by Jeff Standish",
"",
"This program produces a file called \"npcs\" which contains several",
"randomly generated NPC's.  It will create a random NPC party for a",
"given level of a dungeon, or it will roll up a number of random NPC's.",
"",
"Here are the currently existing character classes and chances of occurring.",
"  a)  17%  Cleric",
"  b)   3%  Druid",
"  c)  27%  Fighter",
"  d)   2%  Barbarian",
"  e)   4%  Cavalier",
"  f)   1%  Paladin",
"  g)   7%  Ranger",
"  h)  14%  Magic-User",
"  i)   6%  Illusionist",
"  j)  16%  Thief",
"  k)   2%  Assassin",
"  l)   1%  Martial Artist (Monk)",
"",
"Race is limited to Humans.  Enter the letters of the desired character",
"classes to be used in the generation, and hit <return> when done."
};


/************************************************************************
************************************************************************/

main (argc, argv)
int  argc;
char *argv[];
{
    int  i;
    FILE *fopen(), *outfile;
 
	/* seed random generator, may require system dependant command if
	   time(0) does not work, or might need to use a scanf to get seed */
    srand(time(0));

	/* print out header message */
    for (i = 0; i < 6; ++i)
	printf("%s\n", messages[i]);

	/* if not enough arguments, print usage statement */
    if (argc < 2)
	usage(argv);
    else {
	    /* open output file and call corrent function for generation */
	outfile = fopen("npcs", "w");
	if ((!strcmp(argv[1], "R")) || (!strcmp(argv[1], "r")))
	    rand_npc(outfile, atoi(argv[2]), atoi(argv[3]));
	else if ((!strcmp(argv[1], "P")) || (!strcmp(argv[1], "p")))
	    npc_party(outfile, atoi(argv[2]));
	else
	    usage(argv);
	fclose(outfile);
    }
}


/************************************************************************
* usage() - prints the usage statement
************************************************************************/

usage(argv)
char *argv[];
{
    printf("Usage: %s [r l n] or [p l]\n", argv[0]);
    printf("  r indicates random generate of NPC's, where 'l' is their\n");
    printf("    level (0 results in random levels), and 'n' is the number\n");
    printf("    of NPC's to generate\n");
    printf("  p indicates NPC party, appearing on dungeon level 'l'\n");
}


/************************************************************************
* rand_npc() - generate a given number of characters
*
* lvl - level of all characters, zero results in random levels
* num - number of characters to generate
************************************************************************/

rand_npc(outfile, lvl, num)
FILE *outfile;
int  lvl, num;
{
    int  char_lvl, i, j, clas, abilities[10], classes[12], human=0;
    char c, stg[100];

	/* check to see if want to use all character classes */
    printf("Use all available character classes [Y/n]? ");

	/* in order to get a char, will need to get a string and check
	   its first character, since some systems will not pick up a char
	   with getchar until hit <return>, which messes up input stream
	   when have to bother with considering it a return follows */
    gets(stg);
    c = stg[0];

	/* if don't want to use all classes, indicate that only using
	   humans and go and read in all of the classes desired */
    if ((c == 'n') || (c == 'N')) {
	human = 1;
	read_classes(classes);
    }
	/* otherwise just indicate that all single classes are valid */
    else for (i = 0; i < 12; ++i)
	classes[i] = 1;

	/* reset number of characters if is too huge to allow for
	   possible constraints on the size of the output file */
    if (num > 1000)
	num = 1000;

	/* if negative level, reset it as zero to default to random levels */
    if (lvl < 0)
	lvl = 0;
    fprintf(outfile, "Class Lvl Race  HP   Str   Int Wis Dex Con Chr Com\n");
    fprintf(outfile, "--------------------------------------------------\n");

	/* main loop for individual character generation */
    for (i = 0; i < num; ++i) {

	    /* if level is non-zero, set the character's level to level */
	if (lvl)
	    char_lvl = lvl;

	    /* else randomly generate a level in range 1-16 */
	else {
	    j = die_roll(10);

		/* weighted probability of low level characters */
	    if (j < 6)
		char_lvl = die_roll(5);
	    else if (j < 9)
		char_lvl = die_roll(5) + 5;
	    else
		char_lvl = die_roll(6) + 10;
	}

	    /* if explicitly human, make character human, else go and
	       randomly select a race */
	if (human)
	    abilities[Race] = 6;
	else
	    abilities[Race] = set_race();

	    /* randomly select a class by given list of possible classes
	       and individual character's race */
	clas = set_class(abilities[Race], classes);

	    /* is single-classed, allow for maximum level of certain classes */
	if (clas < 12)
	    if ((char_lvl > max_level[clas]) && (max_level[clas] != 0))
		char_lvl = max_level[clas];

	   /* roll the character's ability scores and then print him out */
	roll_ability(abilities, clas, char_lvl);
	show_npc(abilities, clas, char_lvl, outfile);
    }
}


/************************************************************************
* read_classes() - read in the classes to include in character generation
*		   when user decides to not use all possible classes
************************************************************************/

read_classes(classes)
int classes[];
{
    int  i, j, done;
    char c, claz[100];

	/* initialize array of classes to false */
    for (i = 0; i < 12; ++i)
	classes[i] = 0;

	/* print instructions */
    for (i = 6; i < 22; ++i)
	printf("%s\n", messages[i]);

	/* repeat until get a valid list of characters to use */
    do {
	    /* read in a string of letters */
	gets(claz);
	done = 0;

	    /* go trough the letters and for valid letter of a class,
	       add that class to the list of possible classes to use */
	for (i = 0; i < strlen(claz); ++i) {

		/* get the letter, make sure is lower case, and add the
		   class to the list of desired classes, or error if bad */
	    c = claz[i];
	    if (isupper(c))
		c = c + 32;
	    if ((c >= 'a') && (c <= 'l')) {
		j = c - 'a';
		classes[j] = 1;
		printf("Class %s added to list.\n", class_name[j]);
		++done;
	    }
	    else
		printf("Class \"%c\" unknown.\n", c);
	}
	    /* done = number of selected classes, error if zero */
	if (done == 0)
	    printf("Must choose at least one class.\n");
    } while (done == 0);
}


/* Begin additions for spell book rolling -- KCJ */

/* Spell book rolling logic:
 *
 * A spell book starts off with an initial list of first-level spells.
 * For MU's (including multi-class and Rangers), this list is determined
 * by a table in the DMG (p. 39).  For Illusionists, this initial list is
 * determined by three random first-level spells (no duplication).  After
 * the initial list of spells is determined the spell caster receives a
 * new spell from his mentor every time he trains up to the next level.
 * In addition to this automatic spell gain (which does not require an
 * intelligence check), this program assumes that the spell caster has a
 * chance to find extra spells while adventuring.  (This is checked each
 * level.)  If he finds a spell, he has a like chance to find another
 * spell.  This repeats until he either blows his chance for this
 * character level or he finds all the spells of this spell level.
 * 
 * Confused yet?  Just wait. */

/************************************************************************
* all_known() - yes or no: does he know all spells of this level?
*
************************************************************************/

int
all_known(mu_or_ilsn, intel, sp_lvl)
int mu_or_ilsn; /* 0=MU, 1=ILSN */
int intel;
int sp_lvl;
{
  int there_are_blanks,count,i;

  there_are_blanks = count = 0;

  /* Logic: If all spells are either known or beyond end of spell list...*/

  for(i=0; i<30; i++)
    if(strlen(spell_list[mu_or_ilsn][sp_lvl-1][i]) == 0) /* If null spell name */
      break;
    else
      if(already_in_book[sp_lvl-1][i] == 0)
        there_are_blanks++;
      else
        if(already_in_book[sp_lvl-1][i] == 1)
          count++;
        /* Don't count missed spells (already_in_book == 2) */

  if((!there_are_blanks) || (count >= max_spells[intel-1]))
    return(1);
  else
    return(0);
}; /* end proc all_known */

/************************************************************************
* add_spell_proc() - This proc is invoked through add_a_spell macro.
*                    return(0) on success, (1) on failure to add to book.
*                    Can fail if spell already known or if spell beyond
*                    end of spell_list for this spell level.
************************************************************************/

#define add_a_spell(lz,sz) add_spell_proc(mu_or_ilsn,intel,lz,sz,outfile)
#define MIN(a,b) ((a<b) ? a : b)

int
add_spell_proc(mu_or_ilsn, intel, sp_lvl, sp, outfile)
int mu_or_ilsn; /* 0=MU, 1=ILSN */
int intel, sp_lvl, sp;
FILE *outfile;
{
#ifdef DEBUG
  fprintf(stderr,"Attempting to add %s...\n",spell_list[mu_or_ilsn][sp_lvl-1][sp-1]);
#endif
  if(all_known(mu_or_ilsn, intel, sp_lvl))
    return(0); /* pretend we were successful */
  else
    if(already_in_book[sp_lvl-1][sp-1]) 
      return(1); /* failed to add */
    else
      if(strlen(spell_list[mu_or_ilsn][sp_lvl-1][sp-1]) == 0)
        return(1); /* failed to add */
      else {

#ifdef DEBUG
        fprintf(stderr," Success!\n");
#endif
        already_in_book[sp_lvl-1][sp-1] = 1;
        return(0); /* Success! */
      }

}; /* end proc add_spell_proc */

/************************************************************************
* spell_book() - print out character's spell book
*
************************************************************************/

void
spell_book(intel, mu_or_ilsn, lvl, outfile)
int intel, mu_or_ilsn, lvl;
FILE *outfile;
{
  int i,j;
  int l;
  int find_another;
  int sp_lvl, sp;
  int first_this_level;

  for (i=0; i<9; i++)
    for (j=0; j<30; j++)
      already_in_book[i][j] = 0;

  /* Initial spell book calculation */

  switch(mu_or_ilsn) {
    case MU:   add_a_spell( 1, ReadMagic);
               for(i=0; i<3; i++)
                 add_a_spell( 1, initial_mu_spells[i][die_roll(10)-1]);
                 /* Ignore return value; must always succeed. */
               break;

    case ILSN: for(i=0; i<3; i++)
                 while(add_a_spell( 1, die_roll(12)));
                 /* repeat until we get a spell we don't already know */
               break;
  } /* end switch */;

   /* And now, for each character level beyond first... */

  for (l=2; l<=lvl; l++) {

    /* Spells learned from mentor... */

#ifdef DEBUG
    fprintf(stderr,"Spell learned from mentor at level %i...\n",l);
#endif

    while(add_a_spell(max_spell_level[mu_or_ilsn][MIN(l,18)-1],die_roll(30)))
      ;

    /*  Spells found while adventuring... */

#ifdef DEBUG
    fprintf(stderr,"Spells learned while adventuring at level %i...\n",l);
#endif

    find_another = 1;
    while(find_another)
      if(chance_to_find_spells[mu_or_ilsn] < die_roll(100)) 
        find_another = 0;
      else {
        /* Determine level of spell found */
        sp_lvl = die_roll(max_spell_level[mu_or_ilsn]
                                         [MIN(lvl,18)-1]);

#ifdef DEBUG
        fprintf(stderr,"Found a level %i spell: ",sp_lvl);
#endif

        if(all_known(mu_or_ilsn, intel, sp_lvl)) {
          find_another = 0;
#ifdef DEBUG
          fprintf(stderr,"BUT we already know all of those!\n\n");
#endif
          }
        else {
          while(already_in_book[sp_lvl-1][(sp=die_roll(30))-1] || 
                (strlen(spell_list[mu_or_ilsn][sp_lvl-1][sp-1]) == 0))
            ; /* (null statement) keep rolling 'til we get a good one */

#ifdef DEBUG
          fprintf(stderr,"%s\n",spell_list[mu_or_ilsn][sp_lvl-1][sp-1]);
#endif

          if(chance_to_learn_spells[intel-1] < die_roll(100)) {
            already_in_book[sp_lvl-1][sp-1] = 2;

#ifdef DEBUG
            fprintf(stderr,",  but blew intelligence role.\n\n");
#endif

            }
            /* Note: This is a little screwy.  If he blows his Int roll,
             * we set the already_in_book array to indicate this char
             * can't know that spell.  If I stuck exactly by the PHB
             * rules, I'd have to go figure the MINIMUM spells/level,
             * based on Int.  For ease of programming, I'm ignoring this.
             * Ignoring the minimums can hurt high level Illusionists. */
          else 
            add_a_spell(sp_lvl,sp); 
            /* ignore return value, since we already know we have a winner */

        } /* end if all_known... */
      } /* end if chance_to_find... */

  } /* end for each level above first */

  /* Now, print spell book */

#ifdef DEBUG
  fprintf(stderr,"\nPrinting spell book...\n\n");
#endif

  for (sp_lvl=1; sp_lvl<= 9; sp_lvl++) {
    first_this_level = 1;

    for(sp=1; sp <= 30; sp++) {
      if(already_in_book[sp_lvl-1][sp-1]) {
        if(first_this_level)
          fprintf(outfile," %i: ",sp_lvl); /* no newline */
        else
          fprintf(outfile,"    "); /* no newline */
        first_this_level = 0;

        if(already_in_book[sp_lvl-1][sp-1] == 2)
          fprintf(outfile," Missed: "); /* no newline */

        fprintf(outfile," %s\n",spell_list[mu_or_ilsn][sp_lvl-1][sp-1]);
        } /* end if already_in_book */
      } /* end for sp */
    } /* end for sp_lvl */
  fprintf(outfile,"\n");

}; /* end proc spell_book */

/* End additions for spell book rolling -- KCJ */


/************************************************************************
* npc_party() - generate a random dungeon adventuring party
*
* dungeon_lvl - level of dungeon upon which the party is encountered
************************************************************************/

npc_party(outfile, dungeon_lvl)
FILE *outfile;
int  dungeon_lvl;
{
    int char_lvl, abilities[10], clas, num_of_chars, i, classes[12];

	/* indicate that all possible single-classes are to be considered */
    for (i = 0; i < 12; ++i)
	classes[i] = 1;

	/* make sure is valid dungeon level */
    if (dungeon_lvl < 1)
	dungeon_lvl = 1;

	/* characters on the first five levels have a level = dungeon level */
    if (dungeon_lvl <= 5) {
	char_lvl = find_level(dungeon_lvl);
	if (dungeon_lvl > char_lvl)
	    char_lvl = dungeon_lvl;
    }
	/* else randomly select a high level, and adjust it */
    else {
	char_lvl = die_roll(6) + 6;
	if (char_lvl > dungeon_lvl)
	    --char_lvl;
	else if (char_lvl < dungeon_lvl)
	    ++char_lvl;
    }

	/* determine number of characters in the party */
    num_of_chars = die_roll(4) + 1;

	/* print out header message to output file */
    fprintf(outfile, "Random NPC party for dungeon level %d\n", dungeon_lvl);

	/* generate all of the characters in the party */
    for (i = 0; i < num_of_chars; ++i) {
	fprintf(outfile, "\n");

	    /* select a race, select a class, make sure character does not
	       exceed maximum level for certain classes */
	abilities[Race] = set_race();
	clas = set_class(abilities[Race], classes);
	if (clas < 12)
	    if ((char_lvl > max_level[clas]) && (max_level[clas] != 0))
		char_lvl = max_level[clas];

	    /* generate abilites and print out the character */
	roll_ability(abilities, clas, char_lvl);
	show_abilities(abilities, clas, char_lvl, outfile);
/* Begin additions for spell book rolling -- KCJ */

	/* if an MU or Illusionist, determine his spell book */
    if (which_spell_book[clas] != -1)
        spell_book(abilities[Intelligence],which_spell_book[clas],char_lvl,
                   outfile);

/* End additions for spell book rolling -- KCJ */
    }
}


/************************************************************************
* find_level() - given the level of the dungeon, generate the level of
*		 the character party encountered on the level
************************************************************************/

int find_level(dungeon_level)
int dungeon_level;
{
	/* if level of dungeon is too large for look-up table, use the
	   deepest level listed */
    if (dungeon_level > 16)
	dungeon_level = 16;

	/* randomly determine the level of the party and return it */
    return (donjon[dungeon_level - 1][die_roll(20) - 1]);
}


/************************************************************************
* die_roll() - simple function to roll one die of the given size
************************************************************************/

int die_roll(size)
int size;
{
   return ((rand() % size) + 1);
}


/************************************************************************
* set_race() - randomly select the race of a character
************************************************************************/

int set_race()
{
    int i, rac;

    rac = 6;

	/* the chance of the NPC being a demi-human */
    if (die_roll(100) <= DemiPercent) {
	i = die_roll(100);
	if (i <= 25) rac = 0;
	else if (i <= 50) rac = 1;
	else if (i <= 60) rac = 2;
	else if (i <= 85) rac = 3;
	else if (i <= 95) rac = 4;
	else rac = 5;
    }
    return(rac);
}


/************************************************************************
* set_class() - randomly select the class of a character
*
* rac	  - the race of the character
* classes - array of boolean values for if a given single-class is used
************************************************************************/

int set_class(rac, classes)
int rac, classes[];
{
    int  clas, i;

	/* if human, then must select a single-class class */
    if (rac == 6)
	clas = single_class(classes);

	/* else, could be multi-classed */
    else {

	    /* roll against the chance for a given demi-human to be
		a multi-classed character */
	if (die_roll(100) <= demiclass[rac][0]) {
	    i = die_roll(demiclass[rac][1]);
	    clas = demiclass[rac][i+1];
	}

	    /* else is single-classed, so randomly select single-classes
		until find one suitable for a character of the given race */
	else {
	    do {
		clas = single_class(classes);
	    } while (!demisingle[rac][clas]);
	}
    }
    return(clas);
}


/************************************************************************
* single_classes() - randomly select a single-class class
*
* classes - array of boolean values for if a given single-class is used
************************************************************************/

int single_class(classes)
int classes[];
{
    int rol, clas;

    do {
	rol = die_roll(100);

		/* select a single-class */
	if (rol <= 17) clas = 0;
	else if (rol <= 20) clas = 1;
	else if (rol <= 47) clas = 2;
	else if (rol <= 49) clas = 3;
	else if (rol <= 53) clas = 4;
	else if (rol <= 54) clas = 5;
	else if (rol <= 61) clas = 6;
	else if (rol <= 75) clas = 7;
	else if (rol <= 81) clas = 8;
	else if (rol <= 97) clas = 9;
	else if (rol <= 99) clas = 10;
	else clas = 11;

	/* repeat loop until reach an acceptable single-class */
    } while (!classes[clas]);
    return(clas);
}

/************************************************************************
* roll_ability() - roll the ability scores for a character of the
*		   given class, adjusting for race and such
*
* abilities - array containing ability scores
* clas	    - clas of the character
* lvl       - level of the character
************************************************************************/

roll_ability(abilities, clas, lvl)
int abilities[], clas, lvl;
{
    int i, j, k, l, rolz[9];

	/* randomly generate all seven abilities */
    for (i = 0; i < 7; ++i) {

	    /* initialize an array to contain all of the die rolls */
	for (j = 0; j < 9; ++j)
	    rolz[j] = 0;

	    /* roll as many dice as required for the ability */
	for (j = 0; j < die_num[clas][i]; ++j)
	    rolz[j] = die_roll(6);

	    /* do a bubble sort so that three highest die rolls are the
		first three values in the rolz array */
	for (j = 8; j >= 0; --j) for (k = 0; k < j; ++k)
	    if (rolz[k] < rolz[k+1]) {
		l = rolz[k];
		rolz[k] = rolz[k+1];
		rolz[k+1] = l;
	    }

	    /* set the ability score equal to the sum of the three highest
		die rolls, plus the racial ability bonus */
	abilities[i] = rolz[0]+rolz[1]+rolz[2]+race_bonus[abilities[Race]][i];

	   /* for the first six abilities (not comeliness), check to make
		sure that ability score is the mimimum for the given
		class, and is not out the range for the given race */
	if (i < 6) {
	    if (abilities[i] < min_ability[clas][i])
		abilities[i] = min_ability[clas][i];
	    if (abilities[i] < race_min[abilities[Race]][i])
		abilities[i] = race_min[abilities[Race]][i];
	    if (abilities[i] > race_max[abilities[Race]][i])
		abilities[i] = race_max[abilities[Race]][i];
	}
    }

	/* add in the comeliness bonus due to charisma */
    abilities[Comeliness] += come_bonus[abilities[Charisma]];

	/* reset the exceptional strength score to zero */
    abilities[Excep_Str] = 0;

	/* if have an 18 strength and are of a class which can have
	   an exceptional strength score, then generate the excp. str. */
    if ((is_exp_str[clas]) && (abilities[Strength] == 18)) {
	abilities[Excep_Str] = die_roll(100);

	    /* if the exceptional strength score exceeds the limit for the
		given race, then reduce the score to the maximum allowed */
	if (abilities[Excep_Str] > max_x_str[abilities[Race]])
	    abilities[Excep_Str] = max_x_str[abilities[Race]];
    }

	/* generate the character's hit points */
    if (clas < 12)
	abilities[Hit_Points] = hit_pts(clas, lvl, abilities);

	/* else is multi-classed, so roll the hit points for both classes
	   and average them together */
    else {
	i = hit_pts(multi_hd[clas-12][0], lvl, abilities);
	i += hit_pts(multi_hd[clas-12][1], lvl, abilities);
	abilities[Hit_Points] = (i + 1) / 2;
    }
}


/************************************************************************
* hit_points() - roll the hits points for the given class at given level
************************************************************************/

int hit_pts(clas, lvl, abilities)
int clas, lvl, abilities[];
{
    int i, j, hp;

	/* hp = bonus hit points for higher levels */
	/* i = number of levels to roll hit points for */
    if (lvl > max_hit_dice[clas]) {
	i = max_hit_dice[clas];
	hp = (lvl - max_hit_dice[clas]) * hit_bonus[clas];
    }
    else {
	i = lvl;
	hp = 0;
    }

	/* add an extra die for rangers and monks */
    if ((clas == 6) || (clas == 11))
	hp += roll_hits(clas, abilities);

	/* call roll_hits the necessary number of times to generate HP's */
    for (j = 1; j <= i; ++j) {
	hp += roll_hits(clas, abilities);

	    /* add in the extra bonus for barbarians */
	if (clas == 3)
	    hp += con_bonus[abilities[Constitution]];
    }
    return(hp);
}


/************************************************************************
* roll_hits() - roll the hit points for one level of given class
************************************************************************/

int roll_hits(clas, abilities)
int clas, abilities[];
{
    int hp, i;

	/* roll the hit die */
    hp = die_roll(hit_dice[clas]);

	/* if the roll is too low, make it equal to minimum score */
    if (hp < min_hit[clas])
	hp = min_hit[clas];

	/* get the constitution bonus */
    i = con_bonus[abilities[Constitution]];

	/* if character is not a fighter and bonus is > 2, reset it to 2 */
    if ((i > 2) && ((clas < 2) || (clas > 6)))
	i = 2;

	/* add in the corrected constitution bonus */
    hp += i;

    return(hp);
}


/************************************************************************
* show_abilities() - prints out a character in the extended format for
*		     a dungeon party, and includes any magic items
************************************************************************/

show_abilities(abilities, clas, lvl, outfile)
int abilities[], clas, lvl;
FILE *outfile;
{

	/* print out race, class, and level */
    fprintf(outfile, "%s %s, ", races[abilities[Race]], class_name[clas]);
    fprintf(outfile, "Level: %d", lvl);

	/* if multiclassed, include level of second class, even though
	   it is assumed to bethe same as the first level */
    if (clas > 11)
	fprintf(outfile, "/%d", lvl);

	/* print out hit points and strength */
    fprintf(outfile, "\nHit Points: %d\n", abilities[Hit_Points]);
    fprintf(outfile, "Str: %d", abilities[Strength]);

	/* print out exceptional strength if there is any, and print it
	   in the 01-00 format */
    if (abilities[Excep_Str] > 0) {
	fprintf(outfile, "/");
	if (abilities[Excep_Str] == 100)
	    abilities[Excep_Str] = 0;
	if (abilities[Excep_Str] < 10)
	    fprintf(outfile, "0");
	fprintf(outfile, "%d", abilities[Excep_Str]);
    }

	/* print out the rest of the ability scores */
    fprintf(outfile, "   Int: %d", abilities[Intelligence]);
    fprintf(outfile, "   Wis: %d", abilities[Wisdom]);
    fprintf(outfile, "   Dex: %d", abilities[Dexterity]);
    fprintf(outfile, "   Con: %d", abilities[Constitution]);
    fprintf(outfile, "   Chr: %d", abilities[Charisma]);
    fprintf(outfile, "   Com: %d\n", abilities[Comeliness]);


	/* select and print out some magic items, but don't give any to
	   the barbarians! (they don't need them anyway) */
    if (clas != 3) {

		/* convert level into index for look-up table */
	if (lvl > 13)
	    lvl = 12;
	else
	    --lvl;

		/* check to see if have any magical items and print them */
	if (die_roll(100) <= items_level[lvl][0])
	    select_magic(0, items_level[lvl][1], clas, outfile);
	if (die_roll(100) <= items_level[lvl][2])
	    select_magic(1, items_level[lvl][3], clas, outfile);
	if (die_roll(100) <= items_level[lvl][4])
	    select_magic(2, items_level[lvl][5], clas, outfile);
	if (die_roll(100) <= items_level[lvl][6])
	    select_magic(3, items_level[lvl][7], clas, outfile);
    }
}


/************************************************************************
* show_npc() - prints out a character in the condensed, mass-listing
*	       format, a brief list of significant magic, and the
*              character's spell book (if MU- or Illusionist-type)
************************************************************************/

show_npc(abilities, clas, lvl, outfile)
int abilities[], clas, lvl;
FILE *outfile;
{
    int i;

	/* print out class and level */
    fprintf(outfile, "%s", class_abrev[clas]);
    print_abil(lvl, outfile);

	/* print out race and hit points */
    fprintf(outfile, "   %s", race_abrev[abilities[Race]]);
    if (abilities[Hit_Points] < 100)
	fprintf(outfile, " ");
    print_abil(abilities[Hit_Points], outfile);
    fprintf(outfile, " ");

	/* print strength and include expectional strength if exists */
    print_abil(abilities[Strength], outfile);
    if (abilities[Excep_Str]) {
	fprintf(outfile,"/");
	if (abilities[Excep_Str] == 100)
	    abilities[Excep_Str] = 0;
	if (abilities[Excep_Str] < 10)
	    fprintf(outfile, "0");
	fprintf(outfile, "%d", abilities[Excep_Str]);
    }
    else
	fprintf(outfile, "   ");

	/* print out the rest of the abilities */
    for (i = Intelligence; i < Excep_Str; ++i)
	print_abil(abilities[i], outfile);

	/* if not a barbarian, try to pick some magic items */
    if (clas != 3)
	random_magic(lvl, clas, outfile);
    fprintf(outfile, "\n");

/* Begin additions for spell book rolling -- KCJ */

	/* if an MU or Illusionist, determine his spell book */
    if (which_spell_book[clas] != -1)
        spell_book(abilities[Intelligence],which_spell_book[clas],lvl,outfile);

/* End additions for spell book rolling -- KCJ */
}


/************************************************************************
* print_abil() - print out ability score right-justified
************************************************************************/

print_abil(num, outfile)
int  num;
FILE *outfile;
{
    if (num < 10)
	fprintf(outfile, " ");
    fprintf(outfile, "  %d", num);
}


/************************************************************************
* random_magic() - randomly select some basic magic items
************************************************************************/

random_magic(lvl, clas, outfile)
int  lvl, clas;
FILE *outfile;
{
    int i, j=0;

	/* set i = level * 8%, as the chance of having a magic item */
    i = lvl * 8;

	/* roll to see if have a weapon */
    if (die_roll(100) <= i) {
	j = item_bonus(lvl);
	fprintf(outfile, "    weapon +%d", j);
    }

	/* roll to see if have a protective device */
    if (die_roll(100) <= i) {
	if (j)
	    fprintf(outfile, ", ");
	else
	    fprintf(outfile, "    ");
	j = item_bonus(lvl);
	i = die_roll(5);
	if ((i==1) && !((clas==7) || (clas==8) || (clas==9) || (clas==11)))
	    fprintf(outfile, "shield +%d", j);
	else if ((i < 3) && !((clas==7) || (clas==8) || (clas==11)))
	    fprintf(outfile, "armor +%d", j);
	else if (i < 4)
	    fprintf(outfile, "bracers AC %d", (7-j));
	else if (i < 5)
	    fprintf(outfile, "ring +%d", j);
	else
	    fprintf(outfile, "cloak +%d", j);
    }
}


/************************************************************************
* item_bonus() - calculate the bonus of a magical item, maximum bonus is
*		 equal to half of character's level, to a max of 5
************************************************************************/

int item_bonus(lvl)
int lvl;
{
  lvl = die_roll((lvl + 1) / 2);
  if (lvl > 5)
    lvl = 5;
  return(lvl);
}


/************************************************************************
* select_magic() - selects some magic items from generic tables
*
* lst   - the number of the table to look at
* items - the number of items to generate
* clas  - the character's class, assumed fighter, cleric, theif, mage, monk
************************************************************************/

select_magic(lst, items, clas, outfile)
int  lst, items, clas;
FILE *outfile;
{
    int i, j;

	/* generate the indicated number of items */
    for (i = 0; i < items; ++i) {
	if (class_magic[clas] == 0) {
	    j = die_roll(cleric_magic[lst][0]);
	    j = cleric_magic[lst][j] - 1;
	}
	else if (class_magic[clas] == 1) {
	    j = die_roll(fighter_magic[lst][0]);
	    j = fighter_magic[lst][j] - 1;
	}
	else if (class_magic[clas] == 2) {
	    j = die_roll(mage_magic[lst][0]);
	    j = mage_magic[lst][j] - 1;
	}
	else if (class_magic[clas] == 3) {
	    j = die_roll(thief_magic[lst][0]);
	    j = thief_magic[lst][j] - 1;
	}
	else {
	    j = die_roll(monk_magic[lst][0]);
	    j = monk_magic[lst][j] - 1;
	}
	show_magic(lst, j, outfile);
    }
}


/************************************************************************
* show_magic() - print out a magic item from indicated table
*
* lst - table to look at
* num - number of item in that table
************************************************************************/

show_magic(lst, num, outfile)
int  lst, num;
FILE *outfile;
{
  if (lst == 3)
    fprintf(outfile, "%s\n", magic_IV[num]);
  else if (lst == 2)
    fprintf(outfile, "%s\n", magic_III[num]);
  else if (lst == 1)
    fprintf(outfile, "%s\n", magic_II[num]);
  else
    fprintf(outfile, "%s\n", magic_I[num]);
}
