/*
** DumpCtl.h
** Segment dump control used to display a buffer in hexadecimal and in ASCII/ATASCII.
*/

#define   WM_DUMP_BASE             (WM_USER + 1234)

/*
** messages to set or get sprite control parameters
*/
typedef enum
          {
          WM_DUMP_SET_BUFFER = WM_DUMP_BASE,      /* wParam = buffer size, lParam = buffer addr */
          WM_DUMP_SET_TYPE_BUFFER,                /* wParam = start address, lParam = type buffer addr */
          WM_DUMP_SET_SCROLL,                     /* wParam = first line to display */
          WM_DUMP_GET_SCROLL,                     /* return first line displayed */
          WM_DUMP_SET_INTERNAL,                   /* wParam = TRUE if internal display */
          WM_DUMP_GET_INTERNAL,                   /* return TRUE if internal display */
          WM_DUMP_SET_BEGIN_SELECTION,            /* wParam = first byte selected */
          WM_DUMP_GET_BEGIN_SELECTION,            /* return first byte selected */
          WM_DUMP_SET_END_SELECTION,              /* wParam = last byte selected */
          WM_DUMP_GET_END_SELECTION,              /* return last byte selected */
          WM_DUMP_SEEK_SELECTION,                 /* set first line to begining of selection */
          WM_DUMP_REFRESH,                        /* redraw dump control */
          } DUMP_MSG;

/*
** number of bytes displayed per line (this can not be modified)
*/
#define   DUMP_NB_BYTES_PER_LINE   8

/*
** WM_DUMP_SET_BEGIN_SELECTION, WM_DUMP_SET_END_SELECTION, WM_DUMP_GET_BEGIN_SELECTION and
** WM_DUMP_GET_END_SELECTION messages can use this define for no selection. 
*/
#define   DUMP_NO_SELECTION        0xFFFF

/*
** notifications found in HIWORD(lParam) in WM_COMMAND message
*/
typedef enum
          {
          DUMP_SCROLL_CHANGED,                    /* user has scrolled the window */
          DUMP_SELECTION_CHANGED,                 /* user has changed the selection */
          DUMP_RBUTTONDOWN                        /* user has right clicked in the window */
          } DUMP_NOTIFICATION;

/*
** type of bytes found in Type buffer that qualifies the dump buffer.
** DUMP_TYPE_LOBYTE and DUMP_TYPE_HIBYTE are followed by a byte that
** represent the missing part of the address. For example, if we have
** $A9 $04 in the source (and it sould be disasembled as LDA # >L0480),
** we will have DUMP_TYPE_HIBYTE followed by $80 in the type buffer to
** say that we have a HIBYTE ($04) in the dump buffer and the LOBYTE is
** $80.
*/
typedef enum
          {
          DUMP_TYPE_CODE = 0,
          DUMP_TYPE_LOBYTE,
          DUMP_TYPE_HIBYTE,
          DUMP_TYPE_BYTE,
          DUMP_TYPE_WORD,
          DUMP_TYPE_LABEL,
          DUMP_TYPE_STRING,
          DUMP_TYPE_SBYTE,
          DUMP_TYPE_DLIST,
          DUMP_TYPE_STORE,

          /*
          ** this is a marker to know how many byte types there are.
          */
          DUMP_TYPE_NUMBER
          } DUMP_TYPE;

/*
** register control class
*/
BOOL CALLBACK __export DumpInit(HINSTANCE hInst);
