/*
** Tools.c
*/

#include "dis6502.h"

void Error(HWND hWnd, WORD wStringID, char *szDefault, ...)
{
static char szFormat[250];
va_list marker;

     va_start(marker, szDefault);
     if (LoadString(hInst, wStringID, szFormat, sizeof(szFormat)) == 0)
          strcpy(szFormat, szDefault);
     wvsprintf(szErr, szFormat, marker);
     MessageBox(hWnd, szErr, szTitleApp, MB_OK | MB_ICONEXCLAMATION);
     va_end(marker);
}

BYTE *MemoryAlloc(WORD wSize)
{
     return GlobalAllocPtr(GHND, (DWORD) wSize);
}

BYTE *MemoryRealloc(BYTE *lpBuf, WORD wSize)
{
     return GlobalReAllocPtr(lpBuf, (DWORD) wSize, GMEM_MOVEABLE);
}

void MemoryFree(BYTE *lpBuf)
{
     GlobalFreePtr(lpBuf);
}

/*
** GetFileName is used to open a standard dialog box to choose a file.
** It accepts a filename, some flags, the dialog title resource and the filters.
**
** This function returns TRUE if the user has selected a file. Otherwise,
** it returns FALSE.
*/
BOOL GetFileName(HWND hDlg, LPSTR lpszFileName, DWORD dwFlags, UINT uTitleRsc, LPSTR lpszFilter)
{
OPENFILENAME of;
char szTitle[80]; 
char szFile[_MAX_PATH];
char szFileTitle[_MAX_PATH]; 
char szBuffer[_MAX_PATH];
LPSTR pSlash;

     /*
     ** the dialog title is loaded from the resource.
     */     
     *szFile = *szFileTitle = '\0';
     if (LoadString(hInst, uTitleRsc, szTitle, sizeof(szTitle)) == 0)
          strcpy(szTitle, "Open file");

     /*
     ** we find the initial directory from the file given in
     ** parameter.
     */
     pSlash = _fstrrchr(lpszFileName, '\\');
     if (pSlash)
          {
          *pSlash++ = '\0';       
          lstrcpy(szBuffer, lpszFileName);
          lstrcpy(szFile, pSlash); 
          }
     else {
          GetWindowsDirectory(szBuffer, sizeof(szBuffer));
          lstrcpy(szFile, lpszFileName);
          }

     /*
     ** the structure is filled.
     */          
     _fmemset(&of, 0, sizeof(OPENFILENAME));
     of.lStructSize       = sizeof(OPENFILENAME);
     of.hwndOwner         = hDlg;
     of.hInstance         = hInst;
     of.lpstrFilter       = lpszFilter;
     of.lpstrCustomFilter = (LPSTR) NULL;
     of.nMaxCustFilter    = 0L;
     of.nFilterIndex      = 1L;
     of.lpstrFile         = szFile;
     of.nMaxFile          = (DWORD) sizeof(szFile);
     of.lpstrFileTitle    = szFileTitle;
     of.nMaxFileTitle     = sizeof(szFileTitle);
     of.lpstrInitialDir   = szBuffer;
     of.lpstrTitle        = (LPSTR) szTitle;
     of.Flags             = dwFlags;
     of.nFileOffset       = 0;
     of.nFileExtension    = 0;
     of.lpstrDefExt       = (LPSTR) NULL;
     of.lCustData         = 0L;
     of.lpfnHook          =  NULL;
     of.lpTemplateName    = (LPSTR) NULL;
     
     /*
     ** the dialog box is opened. If it returns TRUE, it means that
     ** the user has choosen a file and we put into the caller buffer.
     */
     *lpszFileName = 0;
     if (GetOpenFileName(&of))
          {
          lstrcpy(lpszFileName, of.lpstrFile);
          return TRUE;
          }
     return FALSE;
}

/*
** SaveFileName is used to open a standard dialog box to choose a file for saving.
** It accepts a filename, some flags, the dialog title resource and the filters.
**
** This function returns TRUE if the user has selected a file. Otherwise,
** it returns FALSE.
*/
BOOL SaveFileName(HWND hDlg, LPSTR lpszFileName, DWORD dwFlags, UINT uTitleRsc, LPSTR lpszFilter)
{
OPENFILENAME of;
char szTitle[80]; 
char szFile[_MAX_PATH];
char szFileTitle[_MAX_PATH]; 
char szBuffer[_MAX_PATH];
LPSTR pSlash;

     /*
     ** the dialog title is loaded from the resource.
     */     
     *szFile = *szFileTitle = '\0';
     if (LoadString(hInst, uTitleRsc, szTitle, sizeof(szTitle)) == 0)
          strcpy(szTitle, "Open file");

     /*
     ** we find the initial directory from the file given in
     ** parameter.
     */
     pSlash = _fstrrchr(lpszFileName, '\\');
     if (pSlash)
          {
          *pSlash++ = '\0';       
          lstrcpy(szBuffer, lpszFileName);
          lstrcpy(szFile, pSlash); 
          }
     else {
          GetWindowsDirectory(szBuffer, sizeof(szBuffer));
          lstrcpy(szFile, lpszFileName);
          }

     /*
     ** the structure is filled.
     */          
     _fmemset(&of, 0, sizeof(OPENFILENAME));
     of.lStructSize       = sizeof(OPENFILENAME);
     of.hwndOwner         = hDlg;
     of.hInstance         = hInst;
     of.lpstrFilter       = lpszFilter;
     of.lpstrCustomFilter = (LPSTR) NULL;
     of.nMaxCustFilter    = 0L;
     of.nFilterIndex      = 1L;
     of.lpstrFile         = szFile;
     of.nMaxFile          = (DWORD) sizeof(szFile);
     of.lpstrFileTitle    = szFileTitle;
     of.nMaxFileTitle     = sizeof(szFileTitle);
     of.lpstrInitialDir   = szBuffer;
     of.lpstrTitle        = (LPSTR) szTitle;
     of.Flags             = dwFlags;
     of.nFileOffset       = 0;
     of.nFileExtension    = 0;
     of.lpstrDefExt       = (LPSTR) NULL;
     of.lCustData         = 0L;
     of.lpfnHook          =  NULL;
     of.lpTemplateName    = (LPSTR) NULL;
     
     /*
     ** the dialog box is opened. If it returns TRUE, it means that
     ** the user has choosen a file and we put into the caller buffer.
     */
     *lpszFileName = 0;
     if (GetSaveFileName(&of))
          {
          lstrcpy(lpszFileName, of.lpstrFile);
          return TRUE;
          }
     return FALSE;
}
