#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define __MAIN_DECLARATIONS__
#include "sapGlobals.h"

#ifdef _MSC_EXTENSIONS
#pragma pack(push)
#pragma pack(1)
#endif
typedef struct {
	int		numOfSongs;
	int		defSong; // zero based index (0....numOfSongs-1)
	char	*commentBuffer;
} sapMUSICstrc;
#ifdef _MSC_EXTENSIONS
#pragma pack(pop)
#endif

sapMUSICstrc *sapLoadMusicFile( char *fname );
void sapPlaySong( int numOfSong );
void sapRenderBuffer( short int *buffer, int number_of_samples );

namespace _SAP_internals_ {

void playerCallSubroutine( WORD address );
void playerProcessOneFrame( void );

volatile int prSbp;
volatile int musicAddress,playerAddress,playerInit,playerType,defSong,fastPlay;
volatile BOOL fileLoadStatus=FALSE;

char inputBuffer[65536];
char commentBuffer[65536];

sapMUSICstrc currentMusic;

BYTE emulEmptyLine[]={
	1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,	0,  0,	0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  1,  0,  0,
	0,  1,  0,  0,  0,  1,  0,  0,  0,  1,  0,  0,  0,  1,  0,  0,	0,  1,  0,  0,  0,  1,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,
	0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 	0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	0,  0,	0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 	0,  0 
};

}

using namespace _SAP_internals_;

sapMUSICstrc *sapLoadMusicFile( char *fname )
{
BOOL formatKnown,binaryFile; int i;
int numOfSongs;

	fileLoadStatus = FALSE;
	if( fname==NULL )
		return NULL;

	cpuInit( );
	pokeyInit( );
	pokeyReset( );
	prSbp = 0;
	commentBuffer[0] = 0;
	memset( atariMem, 0, sizeof(atariMem) );
	atariMem[0xFFFF] = 0xFF; // CMC bug.
	atariMem[0x0000] = 0xFF; // CMC bug.
	atariMem[0xFEFF] = 0xFF; // CMC bug.
	atariMem[0xFFFE] = 0xFF; // CMC bug.

	formatKnown = FALSE; binaryFile = FALSE;
	musicAddress = playerAddress = playerType = numOfSongs = defSong = fastPlay = -1;
	FILE *inpf;
	inpf = fopen( fname, "rb" );
	if( inpf!=NULL )
	{
		BYTE blkHead[4]; WORD blkBegin,blkEnd; int blk;

		blk = 0; i = 0;
		while( 1 )
		{
			int val; val = fgetc( inpf );
			if( formatKnown==FALSE )
			{
				if( (val==EOF) || (i>=4) )
				{
					// error
					break;
				}
				if( (val==0x0A) || (val==0x0D) )
				{
					inputBuffer[i] = 0;
					if( strcmp( inputBuffer, "SAP" )!=0 )
					{
						// error
						break;
					}
					// headerID is OK
					i = 0;
					formatKnown = TRUE;
					continue;;
				}
				inputBuffer[i++] = (char)val;
			}
			else if( binaryFile==FALSE )
			{
				if( val==EOF )
				{
					// error
					break;
				}
				if( val==0xFF )
				{
					if( i!=0 )
					{
						// error. There wasn't EOL in this line
						break;
					}
					// so this is the end of header
					binaryFile = TRUE;
					blkHead[blk++] = (BYTE)val;
					continue;
				}
				if( (val==0x0A) || (val==0x0D) )
				{
					if( i==0 )
						continue;
					inputBuffer[i++] = 0;
					char *codes[]={ "PLAYER", "MUSIC", "INIT", "TYPE", "SONGS", "DEFSONG", "FASTPLAY" };
					int j,k,a;
					for( j=0; j<7; j++ )
					{
						k = 0;
						while( 1 )
						{
							if( k>=i )
							{
								// not this code
								i = 0;
								break;
							}
							if( (codes[j][k]==0) && (inputBuffer[k]==' ') )
							{
								// found
								switch( j )
								{
									case 0: // player address
										a = strtol( &inputBuffer[k], NULL, 16 );
										if( (a==0) || (a>0xFFFF) )
										{
											// error
											i = 0;
											goto cont;
										}
										playerAddress = a;
										i = 0;
										goto cont;
										break;
									case 1: // music address
										a = strtol( &inputBuffer[k], NULL, 16 );
										if( (a==0) || (a>0xFFFF) )
										{
											// error
											i = 0;
											goto cont;
										}
										musicAddress = a;
										i = 0;
										goto cont;
										break;
									case 2: // binary player init
										a = strtol( &inputBuffer[k], NULL, 16 );
										if( (a==0) || (a>0xFFFF) )
										{
											// error
											i = 0;
											goto cont;
										}
										playerInit = a;
										i = 0;
										goto cont;
										break;
									case 3: // player type
										while( inputBuffer[k]!=0 )
										{
											if( (inputBuffer[k]=='B') || (inputBuffer[k]=='b') )
											{
												playerType = 'b';
												break;
											}
											if( (inputBuffer[k]=='C') || (inputBuffer[k]=='c') )
											{
												playerType = 'c';
												break;
											}
											if( (inputBuffer[k]=='D') || (inputBuffer[k]=='d') )
											{
												playerType = 'd';
												break;
											}
											if( (inputBuffer[k]=='S') || (inputBuffer[k]=='s') )
											{
												playerType = 's';
												break;
											}
											if( !isspace(inputBuffer[k]) )
											{
												i = 0;
												goto cont;
											}
											k++;
										}
										i = 0;
										goto cont;
										break;
									case 4: // num of songs
										a = strtol( &inputBuffer[k], NULL, 10 );
										if( (a==0) || (a>0xFFFF) )
										{
											// error
											i = 0;
											goto cont;
										}
										numOfSongs = a;
										sprintf( &commentBuffer[ strlen(commentBuffer) ], "Number of songs = %d\n", numOfSongs );
										i = 0;
										goto cont;
										break;
									case 5: // default songs
										a = strtol( &inputBuffer[k], NULL, 10 );
										if( (a==0) || (a>0xFFFF) )
										{
											// error
											i = 0;
											goto cont;
										}
										defSong = a;
										i = 0;
										goto cont;
										break;
									case 6: // fastPlay
										a = strtol( &inputBuffer[k], NULL, 10 );
										if( (a==0) || (a>0xFFFF) )
										{
											// error
											i = 0;
											goto cont;
										}
										fastPlay = a;
										i = 0;
										goto cont;
										break;

								}
								i = 0;
								goto cont;
							}
							if( codes[j][k]==0 )
								break; // not this code
							if( codes[j][k]!=inputBuffer[k] )
								break; // not this code
							k++;
						}
					}
					sprintf( &commentBuffer[ strlen(commentBuffer) ], "%s\n", inputBuffer );
					// not found
					i = 0;
					continue;
				}
				inputBuffer[i++] = (char)val;
			}
			else if( binaryFile==TRUE )
			{
				if( val==EOF )
				{
					if( blk==0 )
					{
						fileLoadStatus = TRUE;
						break; // OK
					}
					// error
					break;
				}
				if( blk<4 )
				{
					blkHead[blk++] = (BYTE)val;
					if( blk==2 )
					{
						if( (blkHead[0]&blkHead[1])==255 )
							blk = 0;
					}
					if( blk==4 )
					{
						blkBegin = ((WORD)blkHead[0]) + ((WORD)blkHead[1])*256;
						blkEnd = ((WORD)blkHead[2]) + ((WORD)blkHead[3])*256;
					}
				}
				else
				{
					atariMem[blkBegin] = (BYTE)val;
					if( blkBegin==blkEnd )
					{
						blk = 0;
					}
					blkBegin++;
				}
			}
			cont:;

		}
		fclose( inpf );

	}
	if( playerType==-1 )
		return NULL;
	fileLoadStatus = TRUE;
	currentMusic.defSong = defSong;
	currentMusic.numOfSongs = numOfSongs;
	currentMusic.commentBuffer = &commentBuffer[0];

	sapPlaySong( defSong );
	return &currentMusic;
}


void sapPlaySong( int numOfSong )
{
	if( fileLoadStatus==FALSE )
		return;

	if( numOfSong==-1 )
		numOfSong = 0;
	numOfSong &= 0xFF;
	numOfSong = numOfSong % currentMusic.numOfSongs;

	sndBufPtr = prSbp = 0;
	switch( playerType )
	{
		case 'c':
			if( (playerAddress==-1) || (musicAddress==-1) )
			{
				fileLoadStatus = FALSE;
				break;
			}
			cpuReg_S = 0xFF;
			cpuReg_A = 0x70;
			cpuReg_X = (musicAddress&0xFF);
			cpuReg_Y = (musicAddress>>8)&0xFF;
			playerCallSubroutine( playerAddress+3 );
			cpuReg_S = 0xFF;
			cpuReg_A = 0x00;
			cpuReg_X = numOfSong;
			playerCallSubroutine( playerAddress+3 );
			break;
		case 'b':
		case 'm':
			if( (playerInit==-1) || (playerAddress==-1) )
			{
				fileLoadStatus = FALSE;
				break;
			}
			cpuReg_S = 0xFF;
			cpuReg_A = numOfSong;
			playerCallSubroutine( playerInit );
			break;
		case 'd':
			if( (playerInit==-1) || (playerAddress==-1) )
			{
				fileLoadStatus = FALSE;
				break;
			}
			cpuReg_S = 0xFF;
			cpuReg_PC = 0xFFFF;
			cpuReg_PC--;
			atariMem[0x100 + cpuReg_S] = (cpuReg_PC>>8)&0xFF; cpuReg_S--;
			atariMem[0x100 + cpuReg_S] = cpuReg_PC&0xFF; cpuReg_S--;
			cpuReg_PC = playerInit;
			cpuReg_A = numOfSong;
			cpuReg_X = 0;
			cpuReg_Y = 0;
			cpuSetFlags( 0x20 );
			break;
		case 's':
			if( (playerInit==-1) || (playerAddress==-1) )
			{
				fileLoadStatus = FALSE;
				break;
			}
			cpuReg_S = 0xFF;
			cpuReg_PC = playerInit;
			cpuReg_A = 0;
			cpuReg_X = 0;
			cpuReg_Y = 0;
			cpuSetFlags( 0x20 );
			break;
	}
}


void _SAP_internals_::playerCallSubroutine( WORD address )
{
int i,k;

	cpuReg_PC = 0xFFFF;
	cpuReg_PC--;
	atariMem[0x100 + cpuReg_S] = (cpuReg_PC>>8)&0xFF; cpuReg_S--;
	atariMem[0x100 + cpuReg_S] = cpuReg_PC&0xFF; cpuReg_S--;
	cpuReg_PC = address;
	k = 0;
	while(k<1000000)
	{
		doWrite = 0;
		i = cpuExecuteOneOpcode( );
		k+=i;
		if( i>10 )
			return;
		if( doWrite )
			freddieWriteByte( cpuWorkAddress, cpuNewVal );
		if( cpuReg_PC==0xFFFF )
			break;
	}
}

void _SAP_internals_::playerProcessOneFrame( void )
{
int ilp;
BYTE oldFlags,oldA,oldX,oldY,oldS;
WORD oldPC;
BOOL notRestored;
char holded;

	if( playerType=='d' )
	{
		oldFlags = cpuGetFlags();
		oldA = cpuReg_A;
		oldX = cpuReg_X;
		oldY = cpuReg_Y;
		oldPC = cpuReg_PC;
		oldS = cpuReg_S;
		notRestored = TRUE;
	}
	if( playerType=='s' )
	{

	}

	if( playerType!='s' )
	{
		cpuReg_S = 0x8F;
		cpuReg_PC = 0xFFFF;
		cpuReg_PC--;
		atariMem[0x100 + cpuReg_S] = (cpuReg_PC>>8)&0xFF; cpuReg_S--;
		atariMem[0x100 + cpuReg_S] = cpuReg_PC&0xFF; cpuReg_S--;
	}

	switch( playerType )
	{
		case 'c':
			cpuReg_PC = playerAddress+6;
			break;
		case 'b':
		case 'd':
		case 'm':
			cpuReg_PC = playerAddress;
			break;
	}
	cycleInLine = 0;
	if( fastPlay!=-1 )
		lineInFrame = 0;
	else if( playerType=='s' )
		lineInFrame = 0;
	else
		lineInFrame = 248;
	holded = 0;
	doWrite = 0;
	pokeyUpdateSoundCounters();

	while(1)
	{
		if( cpuReg_PC!=0xFFFF )
		{
			ilp = cpuExecuteOneOpcode( );
			if( ilp>10 )
				return; // not supported instruction has been executed
			if( doWrite )
			{
				doWrite = 0;
				if( cpuWorkAddress==0xD40A )
					holded = 1;
				else
					freddieWriteByte( cpuWorkAddress, cpuNewVal );
			}
		}
		else
		{
			if( playerType=='d' )
			{
				if( notRestored==TRUE )
				{
					notRestored = FALSE;
					cpuReg_PC = oldPC;
					cpuReg_A = oldA;
					cpuReg_X = oldX;
					cpuReg_Y = oldY;
					cpuSetFlags( oldFlags );
					cpuReg_S = oldS;
				}
			}
			else
				ilp = 300;
		}
	again:
		for(;ilp>0;ilp--)
		{
			ilp+=emulEmptyLine[cycleInLine];
			if( cycleInLine==103 )
			{
				if( holded == 1 )
				{
					ilp = 0;
					holded = 0;
				}
			}
			if( cycleInLine==113 )
			{
				pokeyUpdateSound(114);
				cycleInLine = -1;
				lineInFrame++;
				if( fastPlay!=-1 )
				{
					if( lineInFrame==fastPlay )
					{
						pokeyUpdateSoundCounters();
						goto bre;
					}
				}
				else if( playerType=='s' )
				{
					if( lineInFrame==78 )
					{
						pokeyUpdateSoundCounters();
						atariMem[0x45]--;
						if( atariMem[0x45]==0 )
							atariMem[0xB07B]++;
						goto bre;
					}
				}
				else
				{
					if( lineInFrame==248 )
					{
						pokeyUpdateSoundCounters();
						goto bre;
					}
					if( lineInFrame==312 )
					{
						lineInFrame=0;
						pokeyUpdateSoundCounters();
					}
				}
				ANTIC_VCOUNT_D40B = (BYTE)(lineInFrame / 2);
			}
			cycleInLine++;
		}
		if( holded==1 )
		{
			ilp=114;
			goto again;
		}
	}
	bre:;
}


void sapRenderBuffer( BYTE *buffer, int number_of_samples )
{
int i;
	
	if( fileLoadStatus==FALSE )
		return;

	i = 0;
	while( i<number_of_samples )
	{
		if( prSbp==sndBufPtr )
			playerProcessOneFrame();
		for( ;prSbp!=sndBufPtr; prSbp=(prSbp+1)&8191 )
		{
			buffer[i] = sndBuf[prSbp&8191];
			if( i>=number_of_samples )
				break;
			i++;
		}
	}
}


