
#ifdef _MSC_EXTENSIONS
#pragma pack(push)
#pragma pack(1)
#endif
typedef struct {
	int		numOfSongs;
	int		defSong; // zero based index (0....numOfSongs-1)
	char	*commentBuffer;
} sapMUSICstrc;
#ifdef _MSC_EXTENSIONS
#pragma pack(pop)
#endif

sapMUSICstrc *sapLoadMusicFile( char *fname );
void sapPlaySong( int numOfSong );
void sapRenderBuffer( unsigned char *buffer, int number_of_samples );



// don't delete sapMUSICstrc returned via sapLoadMusicFile!!!
// don't modify or delete commentBuffer pointed by this structure!!!
// if error occurs, then sapLoadMusicFile returns NULL.
// sapRenderBuffer, fills given buffer with n=(number_of_samples) mono
// 8bit unsigned samples at 44100Hz.
// example:
//
// sapMUSICstrc *currentFile;
// unsigned char playBuffer[2000];
// int currentSong;
//
// currentFile = sapLoadMusicFile( "music.sap" );
// currentSong = currentFile->defSong;
// again:
// while(key)
// {
//	sapRenderBuffer( &playBuffer, 2000 );
//	__play_buffer( );
// }
// if( key==next_song )
// {
//     currentSong = (currentSong+1) % currentFile->numOfSongs;
//     sapPlaySong( current_song );
//     goto again;
// }
// No data need to be deleted, bcoz SAP is using only static data
// and is able to play only one song at time

