#include <ctype.h>
#ifdef _MSC_EXTENSIONS
#include <excpt.h>
#endif
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "sapGlobals.h"


#define MAKESAMPLE\
	{\
		BYTE pomb; DWORD pomd;\
		pomd = ((((sj3qs[0]&sj3qsA[0]) ^ sso[0]) & frse[0])| acld[0]) & acl2[0];\
		pomd = pomd + (pomd>>16);\
		pomb = (BYTE)((pomd&255) + ((pomd>>8)&255));\
		sndBuf[sndBufPtr&8191] = pomb<<2;\
		sndBufPtr = (sndBufPtr+1)&8191;\
	}


namespace POKEY_NAMESPACE {

int sndBufPtrUpp;

int divideByN[4];
int divideByN_Latch[4];
int divideByN_Latch2[4];

const int samplerRate = 0x2836D6; // (1773447 / 44100) * 65536;

BYTE AUDCTL;
int pcc1564;
int pokeyClockCounter64k;

DWORD pokeyClockCounter;
DWORD poly4Counter,poly5Counter;

BYTE switch_J2_signal_Q[4];
BYTE signal_state_out[4];
BYTE switch_J3_Q_state[4];
BYTE switch_J3_Q_stateAND[4];
BYTE audioControl_Latch[4];
BYTE audioControl_Latch2[4];
BYTE audioControl_Latch_Digi[4];
BYTE freq_sequre[4];

const DWORD *sj3qs = (DWORD*)&switch_J3_Q_state[0];
const DWORD *sj3qsA = (DWORD*)&switch_J3_Q_stateAND[0];
const DWORD *sso = (DWORD*)&signal_state_out[0];
const DWORD *acld = (DWORD*)&audioControl_Latch_Digi[0];
const DWORD *acl2 = (DWORD*)&audioControl_Latch2[0];
const DWORD *frse = (DWORD*)&freq_sequre[0];


// poly4 has 15 values repeated 17 times
BYTE poly4[15] = {
15, 15, 15, 15, 0, 0, 0, 15, 0, 0, 15, 15, 0, 15, 0
};

BYTE poly5[31] = {
15, 15, 15, 15, 0, 15, 15, 0, 15, 0, 0, 15, 15, 0, 0, 0, 0, 0, 15, 15, 15, 0, 0, 15, 0, 0, 0, 15, 0, 15, 0
};

BYTE poly17[0x20000];
BYTE poly5_17[0x20000];

BYTE poly4_b[36000]; // minimum size is 312*114+15
BYTE poly5_b[36000]; // minimum size is 312*114+31


void (*Channel0Distortion)(void);
void (*Channel1Distortion)(void);
void (*Channel2Distortion)(void);
void (*Channel3Distortion)(void);

//---
void channel0_0( void )
{
	if( poly5_b[ poly5Counter + pokeyClockCounter ]!=0 )
		signal_state_out[0] = poly17[ pokeyClockCounter & 0x1FFFF ];
}
void channel0_2( void )
{
	signal_state_out[0] = signal_state_out[0] ^ poly5_b[ poly5Counter + pokeyClockCounter ];
}
void channel0_4( void )
{
	if( poly5_b[ poly5Counter + pokeyClockCounter ]!=0 )
		signal_state_out[0] = poly4_b[ pokeyClockCounter + poly4Counter ];
}
void channel0_8( void )
{
	signal_state_out[0] = poly17[ pokeyClockCounter & 0x1FFFF ];
}
void channel0_A( void )
{
	signal_state_out[0] = signal_state_out[0] ^ 15;
}
void channel0_C( void )
{
	signal_state_out[0] = poly4_b[ pokeyClockCounter + poly4Counter ];
}
//---
void channel1_0( void )
{
	if( poly5_b[ poly5Counter + pokeyClockCounter ]!=0 )
		signal_state_out[1] = poly17[ pokeyClockCounter & 0x1FFFF ];
}
void channel1_2( void )
{
	signal_state_out[1] = signal_state_out[1] ^ poly5_b[ poly5Counter + pokeyClockCounter ];
}
void channel1_4( void )
{
	if( poly5_b[ poly5Counter + pokeyClockCounter ]!=0 )
		signal_state_out[1] = poly4_b[ pokeyClockCounter + poly4Counter ];
}
void channel1_8( void )
{
	signal_state_out[1] = poly17[ pokeyClockCounter & 0x1FFFF ];
}
void channel1_A( void )
{
	signal_state_out[1] = signal_state_out[1] ^ 15;
}
void channel1_C( void )
{
	signal_state_out[1] = poly4_b[ pokeyClockCounter + poly4Counter ];
}
//---
void channel2_0( void )
{
	if( poly5_b[ poly5Counter + pokeyClockCounter ]!=0 )
		signal_state_out[2] = poly17[ pokeyClockCounter & 0x1FFFF ];
}
void channel2_2( void )
{
	signal_state_out[2] = signal_state_out[2] ^ poly5_b[ poly5Counter + pokeyClockCounter ];
}
void channel2_4( void )
{
	if( poly5_b[ poly5Counter + pokeyClockCounter ]!=0 )
		signal_state_out[2] = poly4_b[ pokeyClockCounter + poly4Counter ];
}
void channel2_8( void )
{
	signal_state_out[2] = poly17[ pokeyClockCounter & 0x1FFFF ];
}
void channel2_A( void )
{
	signal_state_out[2] = signal_state_out[2] ^ 15;
}
void channel2_C( void )
{
	signal_state_out[2] = poly4_b[ pokeyClockCounter + poly4Counter ];
}
//---
void channel3_0( void )
{
	if( poly5_b[ poly5Counter + pokeyClockCounter ]!=0 )
		signal_state_out[3] = poly17[ pokeyClockCounter & 0x1FFFF ];
}
void channel3_2( void )
{
	signal_state_out[3] = signal_state_out[3] ^ poly5_b[ poly5Counter + pokeyClockCounter ];
}
void channel3_4( void )
{
	if( poly5_b[ poly5Counter + pokeyClockCounter ]!=0 )
		signal_state_out[3] = poly4_b[ pokeyClockCounter + poly4Counter ];
}
void channel3_8( void )
{
	signal_state_out[3] = poly17[ pokeyClockCounter & 0x1FFFF ];
}
void channel3_A( void )
{
	signal_state_out[3] = signal_state_out[3] ^ 15;
}
void channel3_C( void )
{
	signal_state_out[3] = poly4_b[ pokeyClockCounter + poly4Counter ];
}

typedef void (*funcPoint)(void);
funcPoint channelsDistorionTable[4][8]={
	{ &channel0_0, &channel0_2, &channel0_4, &channel0_2, &channel0_8, &channel0_A, &channel0_C, &channel0_A },
	{ &channel1_0, &channel1_2, &channel1_4, &channel1_2, &channel1_8, &channel1_A, &channel1_C, &channel1_A },
	{ &channel2_0, &channel2_2, &channel2_4, &channel2_2, &channel2_8, &channel2_A, &channel2_C, &channel2_A },
	{ &channel3_0, &channel3_2, &channel3_4, &channel3_2, &channel3_8, &channel3_A, &channel3_C, &channel3_A },
};


void pus_8( int n );
void pus_108( int n );
void pus_20( int n );
void pus_40( int n );
void pus_4020( int n );
void pus_50( int n );
void pus_28( int n );
void pus_5028( int n );
void pus_Normal( int n );

void pus_50( int n )
{
int i,ch;
	i = n;

	do
	{
		pokeyClockCounter++;
		pokeyClockCounter64k++;

		ch = 1;
		{
			divideByN[ch]--;
			if( divideByN[ch]==0 )
			{
				divideByN[ch] = divideByN_Latch2[ch];
				Channel1Distortion();
			}
		}

		if( pokeyClockCounter64k>=pcc1564 )
		{
			pokeyClockCounter64k = 0;
			ch = 2;
			{
				divideByN[ch]--;
				if( divideByN[ch]==0 )
				{
					divideByN[ch] = divideByN_Latch2[ch];
					Channel2Distortion();
					switch_J3_Q_state[0] = signal_state_out[0];
				}
			}
			ch = 3;
			{
				divideByN[ch]--;
				if( divideByN[ch]==0 )
				{
					divideByN[ch] = divideByN_Latch2[ch];
					Channel3Distortion();
					switch_J3_Q_state[1] = signal_state_out[1];
				}
			}
		}

		sndBufPtrUpp+=0x10000;
		if( sndBufPtrUpp>=samplerRate )
		{
			sndBufPtrUpp -= samplerRate;
			MAKESAMPLE
		}

	} while(--i);

}

void pus_28( int n )
{
int i,ch;
	i = n;

	do
	{
		pokeyClockCounter++;
		pokeyClockCounter64k++;

		if( pokeyClockCounter64k>=pcc1564 )
		{
			pokeyClockCounter64k = 0;
			ch = 0;
			{
				divideByN[ch]--;
				if( divideByN[ch]==0 )
				{
					divideByN[ch] = divideByN_Latch2[ch];
					Channel0Distortion();
				}
			}
			ch = 1;
			{
				divideByN[ch]--;
				if( divideByN[ch]==0 )
				{
					divideByN[ch] = divideByN_Latch2[ch];
					Channel1Distortion();
				}
			}
		}

		ch = 3;
		{
			divideByN[ch]--;
			if( divideByN[ch]==0 )
			{
				divideByN[ch] = divideByN_Latch2[ch];
				Channel3Distortion();
				switch_J3_Q_state[1] = signal_state_out[1];
			}
		}

		sndBufPtrUpp+=0x10000;
		if( sndBufPtrUpp>=samplerRate )
		{
			sndBufPtrUpp -= samplerRate;
			MAKESAMPLE
		}

	} while(--i);

}

void pus_5028( int n )
{
int i,ch;
	i = n;

	do
	{
		pokeyClockCounter++;

		ch = 1;
		{
			divideByN[ch]--;
			if( divideByN[ch]==0 )
			{
				divideByN[ch] = divideByN_Latch2[ch];
				Channel1Distortion();
			}
		}
		ch = 3;
		{
			divideByN[ch]--;
			if( divideByN[ch]==0 )
			{
				divideByN[ch] = divideByN_Latch2[ch];
				Channel3Distortion();
			}
		}

		sndBufPtrUpp+=0x10000;
		if( sndBufPtrUpp>=samplerRate )
		{
			sndBufPtrUpp -= samplerRate;
			MAKESAMPLE
		}

	} while(--i);

}


void pus_Normal( int n )
{
DWORD i,ch;

	i = n;
	do
	{
		pokeyClockCounter++;
		pokeyClockCounter64k ++;
		if( pokeyClockCounter64k>=pcc1564 )
		{
			pokeyClockCounter64k = 0;

			ch = 0;
			{
				divideByN[ch]--;
				if( divideByN[ch]==0 )
				{
					divideByN[ch] = divideByN_Latch2[ch];
					Channel0Distortion();
				}
			}
			ch = 1;
			{
				divideByN[ch]--;
				if( divideByN[ch]==0 )
				{
					divideByN[ch] = divideByN_Latch2[ch];
					Channel1Distortion();
				}
			}
			ch = 2;
			{
				divideByN[ch]--;
				if( divideByN[ch]==0 )
				{
					divideByN[ch] = divideByN_Latch2[ch];
					Channel2Distortion();
					switch_J3_Q_state[0] = signal_state_out[0];
				}
			}
			ch = 3;
			{
				divideByN[ch]--;
				if( divideByN[ch]==0 )
				{
					divideByN[ch] = divideByN_Latch2[ch];
					Channel3Distortion();
					switch_J3_Q_state[1] = signal_state_out[1];
				}
			}
		}

		sndBufPtrUpp+=0x10000;
		if( sndBufPtrUpp>=samplerRate )
		{
			sndBufPtrUpp -= samplerRate;
			MAKESAMPLE
		}
	} while(--i);

}

void pus_40( int n )
{
int i,ch;

	i = n;

	do
	{
		pokeyClockCounter64k++;
		pokeyClockCounter++;

		ch = 0;
		{
			divideByN[ch]--;
			if( divideByN[ch]==0 )
			{
				divideByN[ch] = divideByN_Latch2[ch];
				Channel0Distortion();
			}
		}

		if( pokeyClockCounter64k>=pcc1564 )
		{
			pokeyClockCounter64k = 0;

			ch = 1;
			{
				divideByN[ch]--;
				if( divideByN[ch]==0 )
				{
					divideByN[ch] = divideByN_Latch2[ch];
					Channel1Distortion();
				}
			}
			ch = 2;
			{
				divideByN[ch]--;
				if( divideByN[ch]==0 )
				{
					divideByN[ch] = divideByN_Latch2[ch];
					Channel2Distortion();
					switch_J3_Q_state[0] = signal_state_out[0];
				}
			}
			ch = 3;
			{
				divideByN[ch]--;
				if( divideByN[ch]==0 )
				{
					divideByN[ch] = divideByN_Latch2[ch];
					Channel3Distortion();
					switch_J3_Q_state[1] = signal_state_out[1];
				}
			}
		}

		sndBufPtrUpp+=0x10000;
		if( sndBufPtrUpp>=samplerRate )
		{
			sndBufPtrUpp -= samplerRate;
			MAKESAMPLE
		}

	} while(--i);

}


void pus_20( int n )
{
int i,ch;

	i = n;

	do
	{
		pokeyClockCounter64k++;
		pokeyClockCounter++;

		if( pokeyClockCounter64k>=pcc1564 )
		{
			pokeyClockCounter64k = 0;

			ch = 0;
			{
				divideByN[ch]--;
				if( divideByN[ch]==0 )
				{
					divideByN[ch] = divideByN_Latch2[ch];
					Channel0Distortion();
				}
			}

			ch = 1;
			{
				divideByN[ch]--;
				if( divideByN[ch]==0 )
				{
					divideByN[ch] = divideByN_Latch2[ch];
					Channel1Distortion();
				}
			}
			ch = 3;
			{
				divideByN[ch]--;
				if( divideByN[ch]==0 )
				{
					divideByN[ch] = divideByN_Latch2[ch];
					Channel3Distortion();
					switch_J3_Q_state[1] = signal_state_out[1];
				}
			}
		}
		ch = 2;
		{
			divideByN[ch]--;
			if( divideByN[ch]==0 )
			{
				divideByN[ch] = divideByN_Latch2[ch];
				Channel2Distortion();
				switch_J3_Q_state[0] = signal_state_out[0];
			}
		}

		sndBufPtrUpp+=0x10000;
		if( sndBufPtrUpp>=samplerRate )
		{
			sndBufPtrUpp -= samplerRate;
			MAKESAMPLE
		}

	} while(--i);

}

void pus_4020( int n )
{
int i,ch;

	i = n;
	do
	{
		pokeyClockCounter64k++;
		pokeyClockCounter++;

		ch = 0;
		{
			divideByN[ch]--;
			if( divideByN[ch]==0 )
			{
				divideByN[ch] = divideByN_Latch2[ch];
				Channel0Distortion();
			}
		}

		if( pokeyClockCounter64k>=pcc1564 )
		{
			pokeyClockCounter64k = 0;

			ch = 1;
			{
				divideByN[ch]--;
				if( divideByN[ch]==0 )
				{
					divideByN[ch] = divideByN_Latch2[ch];
					Channel1Distortion();
				}
			}
			ch = 3;
			{
				divideByN[ch]--;
				if( divideByN[ch]==0 )
				{
					divideByN[ch] = divideByN_Latch2[ch];
					Channel3Distortion();
					switch_J3_Q_state[1] = signal_state_out[1];
				}
			}
		}
		ch = 2;
		{
			divideByN[ch]--;
			if( divideByN[ch]==0 )
			{
				divideByN[ch] = divideByN_Latch2[ch];
				Channel2Distortion();
				switch_J3_Q_state[0] = signal_state_out[0];
			}
		}

		sndBufPtrUpp+=0x10000;
		if( sndBufPtrUpp>=samplerRate )
		{
			sndBufPtrUpp -= samplerRate;
			MAKESAMPLE
		}

	} while(--i);

}

#ifdef _EXCEPTION_
BYTE wasNoExc;
#endif
}; // end of namespace POKEY_NAMESPACE

using namespace POKEY_NAMESPACE;

void pokeyInit( void )
{
int i;
DWORD pol;

	pol = 0x1FFFF;
	for( i=0; i<0x20000; i++ )
	{
		poly17[i] = (BYTE)(pol&1 ? 15:0);
		pol = pol | (((pol&1) ^ ((pol>>5)&1)) << 17);
		pol>>=1;
	}

	for( i=0; i<sizeof(poly4_b); i++ )
		poly4_b[i] = poly4[i % 15];

	for( i=0; i<sizeof(poly5_b); i++ )
		poly5_b[i] = poly5[i % 31];

}


void pokeyReset( void )
{
int i;

	poly4Counter = 0;
	poly5Counter = 0;
	pokeyClockCounter = 0;
	pokeyClockCounter64k = 0;
	pcc1564 = 28;

	for( i=0; i<4; i++ )
	{
		divideByN[i] = 1;
		divideByN_Latch[i] = 0;
		divideByN_Latch2[i] = 0;
		switch_J2_signal_Q[i] = 0;
		signal_state_out[i] = 0;
		switch_J3_Q_state[i] = 0;
		switch_J3_Q_stateAND[i] = 0;
		audioControl_Latch[i] = 0;
		audioControl_Latch2[i] = 0;
		audioControl_Latch_Digi[i] = 0;
		freq_sequre[i] = 0;
	}

	for( i=0; i<16; i++ )
		pokeyWriteByte( 0xD200+i, 0 );
	AUDCTL = 0;

	sndBufPtrUpp = 0;
	sndBufPtr = 0;
#ifdef _EXCEPTION_
	wasNoExc = 1;
#endif

}

void pokeyUpdateSound( int n )
{
#ifdef _EXCEPTION_
EXCEPTION_POINTERS *ep;
	__try
	{
#endif
		if( (AUDCTL&0x50)==0x50 )
		{
			if( (AUDCTL&0x28)==0x28 )
				pus_5028(n);
			else
				pus_50(n);
		}
		else if( (AUDCTL&0x28)==0x28 )
		{
			pus_28(n);
		}
		else if( AUDCTL&0x40 )
		{
			if( AUDCTL&0x20 )
				pus_4020(n);
			else
				pus_40(n);
		}
		else if( AUDCTL&0x20 )
		{
			pus_20(n);
		}
		else
		{
			pus_Normal(n);
		}
#ifdef _EXCEPTION_
	}
	__except( ep = GetExceptionInformation(), 1 )
	{
		if( wasNoExc )
		{
			// now we should just stop playing
		}
		wasNoExc = 0;
	}
#endif
}


void pokeyUpdateSoundCounters( void )
{

	pokeyClockCounter = pokeyClockCounter & 0x7FFFFFFF;
	poly4Counter = (int)(((DWORD)(poly4Counter+pokeyClockCounter)) % 15) - pokeyClockCounter;
	poly5Counter = (int)(((DWORD)(poly5Counter+pokeyClockCounter)) % 31) - pokeyClockCounter;

}

BYTE pokeyReadByte( short unsigned int address)
{
BYTE retVal;

	switch( address&0x0F )
	{
		case 0x09:
			return 0xFF;
		case 0x0A:
			retVal = (BYTE)((255*rand())/RAND_MAX);
			return retVal;
		case 0x0E:
			return 0xFF;
		case 0x0F:
			return 0xFF;
	}
	return 0xFF;
}


void pokeyWriteByte( short unsigned int address, BYTE value )
{
	address&=0x0F;

	switch( address )
	{
		case 0x00:
			divideByN_Latch[0] = value;
			switch( AUDCTL&0x50 )
			{
				case 0x00:
					divideByN_Latch2[0] = divideByN_Latch[0]+1;
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[0]<3) )
						freq_sequre[0] = 0;
					else
						freq_sequre[0] = 15;
					divideByN_Latch2[1] = divideByN_Latch[1]+1;
					if( ((audioControl_Latch[1]&0xA0)==0xA0) && (divideByN_Latch2[1]<3) )
						freq_sequre[1] = 0;
					else
						freq_sequre[1] = 15;
					break;
				case 0x10:
					divideByN_Latch2[0] = divideByN_Latch[0]+1;
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[0]<3) )
						freq_sequre[0] = 0;
					else
						freq_sequre[0] = 15;
					divideByN_Latch2[1] = divideByN_Latch[1]*256+divideByN_Latch2[0];
					if( ((audioControl_Latch[1]&0xA0)==0xA0) && (divideByN_Latch2[1]<3) )
						freq_sequre[1] = 0;
					else
						freq_sequre[1] = 15;
					break;
				case 0x40:
					divideByN_Latch2[0] = divideByN_Latch[0]+4;
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[0]<0x60) )
						freq_sequre[0] = 0;
					else
						freq_sequre[0] = 15;
					divideByN_Latch2[1] = divideByN_Latch[1]+1;
					if( ((audioControl_Latch[1]&0xA0)==0xA0) && (divideByN_Latch2[1]<3) )
						freq_sequre[1] = 0;
					else
						freq_sequre[1] = 15;
					break;
				case 0x50:
					divideByN_Latch2[0] = divideByN_Latch[0]+7;
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[0]<0x60) )
						freq_sequre[0] = 0;
					else
						freq_sequre[0] = 15;
					divideByN_Latch2[1] = divideByN_Latch[1]*256+divideByN_Latch2[0];
					if( ((audioControl_Latch[1]&0xA0)==0xA0) && (divideByN_Latch2[1]<0x60) )
						freq_sequre[1] = 0;
					else
						freq_sequre[1] = 15;
					break;
			}
			break;
		case 0x01:
			audioControl_Latch[0] = value;
			audioControl_Latch2[0] = value&15;
			audioControl_Latch_Digi[0] = (value>>4)&1 ? 15:0;

			Channel0Distortion = channelsDistorionTable[0][ (value>>5)&7 ];
			switch( AUDCTL&0x50 )
			{
				case 0x00:
					divideByN_Latch2[0] = divideByN_Latch[0]+1;
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[0]<3) )
						freq_sequre[0] = 0;
					else
						freq_sequre[0] = 15;
					divideByN_Latch2[1] = divideByN_Latch[1]+1;
					if( ((audioControl_Latch[1]&0xA0)==0xA0) && (divideByN_Latch2[1]<3) )
						freq_sequre[1] = 0;
					else
						freq_sequre[1] = 15;
					break;
				case 0x10:
					divideByN_Latch2[0] = divideByN_Latch[0]+1;
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[0]<3) )
						freq_sequre[0] = 0;
					else
						freq_sequre[0] = 15;
					divideByN_Latch2[1] = divideByN_Latch[1]*256+divideByN_Latch2[0];
					if( ((audioControl_Latch[1]&0xA0)==0xA0) && (divideByN_Latch2[1]<3) )
						freq_sequre[1] = 0;
					else
						freq_sequre[1] = 15;
					break;
				case 0x40:
					divideByN_Latch2[0] = divideByN_Latch[0]+4;
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[0]<0x60) )
						freq_sequre[0] = 0;
					else
						freq_sequre[0] = 15;
					divideByN_Latch2[1] = divideByN_Latch[1]+1;
					if( ((audioControl_Latch[1]&0xA0)==0xA0) && (divideByN_Latch2[1]<3) )
						freq_sequre[1] = 0;
					else
						freq_sequre[1] = 15;
					break;
				case 0x50:
					divideByN_Latch2[0] = divideByN_Latch[0]+7;
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[0]<0x60) )
						freq_sequre[0] = 0;
					else
						freq_sequre[0] = 15;
					divideByN_Latch2[1] = divideByN_Latch[1]*256+divideByN_Latch2[0];
					if( ((audioControl_Latch[1]&0xA0)==0xA0) && (divideByN_Latch2[1]<0x60) )
						freq_sequre[1] = 0;
					else
						freq_sequre[1] = 15;
					break;
			}
			break;
		case 0x02:
			divideByN_Latch[1] = value;
			switch( AUDCTL&0x50 )
			{
				case 0x00:
					divideByN_Latch2[0] = divideByN_Latch[0]+1;
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[0]<3) )
						freq_sequre[0] = 0;
					else
						freq_sequre[0] = 15;
					divideByN_Latch2[1] = divideByN_Latch[1]+1;
					if( ((audioControl_Latch[1]&0xA0)==0xA0) && (divideByN_Latch2[1]<3) )
						freq_sequre[1] = 0;
					else
						freq_sequre[1] = 15;
					break;
				case 0x10:
					divideByN_Latch2[0] = divideByN_Latch[0]+1;
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[0]<3) )
						freq_sequre[0] = 0;
					else
						freq_sequre[0] = 15;
					divideByN_Latch2[1] = divideByN_Latch[1]*256+divideByN_Latch2[0];
					if( ((audioControl_Latch[1]&0xA0)==0xA0) && (divideByN_Latch2[1]<3) )
						freq_sequre[1] = 0;
					else
						freq_sequre[1] = 15;
					break;
				case 0x40:
					divideByN_Latch2[0] = divideByN_Latch[0]+4;
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[0]<0x60) )
						freq_sequre[0] = 0;
					else
						freq_sequre[0] = 15;
					divideByN_Latch2[1] = divideByN_Latch[1]+1;
					if( ((audioControl_Latch[1]&0xA0)==0xA0) && (divideByN_Latch2[1]<3) )
						freq_sequre[1] = 0;
					else
						freq_sequre[1] = 15;
					break;
				case 0x50:
					divideByN_Latch2[0] = divideByN_Latch[0]+7;
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[0]<0x60) )
						freq_sequre[0] = 0;
					else
						freq_sequre[0] = 15;
					divideByN_Latch2[1] = divideByN_Latch[1]*256+divideByN_Latch2[0];
					if( ((audioControl_Latch[1]&0xA0)==0xA0) && (divideByN_Latch2[1]<0x60) )
						freq_sequre[1] = 0;
					else
						freq_sequre[1] = 15;
					break;
			}
			break;
		case 0x03:
			audioControl_Latch[1] = value;
			audioControl_Latch2[1] = value&15;
			audioControl_Latch_Digi[1] = (value>>4)&1 ? 15:0;

			Channel1Distortion = channelsDistorionTable[1][ (value>>5)&7 ];
			switch( AUDCTL&0x50 )
			{
				case 0x00:
					divideByN_Latch2[0] = divideByN_Latch[0]+1;
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[0]<3) )
						freq_sequre[0] = 0;
					else
						freq_sequre[0] = 15;
					divideByN_Latch2[1] = divideByN_Latch[1]+1;
					if( ((audioControl_Latch[1]&0xA0)==0xA0) && (divideByN_Latch2[1]<3) )
						freq_sequre[1] = 0;
					else
						freq_sequre[1] = 15;
					break;
				case 0x10:
					divideByN_Latch2[0] = divideByN_Latch[0]+1;
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[0]<3) )
						freq_sequre[0] = 0;
					else
						freq_sequre[0] = 15;
					divideByN_Latch2[1] = divideByN_Latch[1]*256+divideByN_Latch2[0];
					if( ((audioControl_Latch[1]&0xA0)==0xA0) && (divideByN_Latch2[1]<3) )
						freq_sequre[1] = 0;
					else
						freq_sequre[1] = 15;
					break;
				case 0x40:
					divideByN_Latch2[0] = divideByN_Latch[0]+4;
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[0]<0x60) )
						freq_sequre[0] = 0;
					else
						freq_sequre[0] = 15;
					divideByN_Latch2[1] = divideByN_Latch[1]+1;
					if( ((audioControl_Latch[1]&0xA0)==0xA0) && (divideByN_Latch2[1]<3) )
						freq_sequre[1] = 0;
					else
						freq_sequre[1] = 15;
					break;
				case 0x50:
					divideByN_Latch2[0] = divideByN_Latch[0]+7;
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[0]<0x60) )
						freq_sequre[0] = 0;
					else
						freq_sequre[0] = 15;
					divideByN_Latch2[1] = divideByN_Latch[1]*256+divideByN_Latch2[0];
					if( ((audioControl_Latch[1]&0xA0)==0xA0) && (divideByN_Latch2[1]<0x60) )
						freq_sequre[1] = 0;
					else
						freq_sequre[1] = 15;
					break;
			}
			break;
		case 0x04:
			divideByN_Latch[2] = value;
			switch( AUDCTL&0x28 )
			{
				case 0x00:
					divideByN_Latch2[2] = divideByN_Latch[2]+1;
					if( ((audioControl_Latch[2]&0xA0)==0xA0) && (divideByN_Latch2[2]<3) )
						freq_sequre[2] = 0;
					else
						freq_sequre[2] = 15;
					divideByN_Latch2[3] = divideByN_Latch[3]+1;
					if( ((audioControl_Latch[3]&0xA0)==0xA0) && (divideByN_Latch2[3]<3) )
						freq_sequre[3] = 0;
					else
						freq_sequre[3] = 15;
					break;
				case 0x08:
					divideByN_Latch2[2] = divideByN_Latch[2]+1;
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[2]<3) )
						freq_sequre[2] = 0;
					else
						freq_sequre[2] = 15;
					divideByN_Latch2[3] = divideByN_Latch[3]*256+divideByN_Latch2[2];
					if( ((audioControl_Latch[3]&0xA0)==0xA0) && (divideByN_Latch2[3]<3) )
						freq_sequre[3] = 0;
					else
						freq_sequre[3] = 15;
					break;
				case 0x20:
					divideByN_Latch2[2] = divideByN_Latch[2]+4;
					if( ((audioControl_Latch[2]&0xA0)==0xA0) && (divideByN_Latch2[2]<0x60) )
						freq_sequre[2] = 0;
					else
						freq_sequre[2] = 15;
					divideByN_Latch2[3] = divideByN_Latch[3]+1;
					if( ((audioControl_Latch[3]&0xA0)==0xA0) && (divideByN_Latch2[3]<3) )
						freq_sequre[3] = 0;
					else
						freq_sequre[3] = 15;
					break;
				case 0x28:
					divideByN_Latch2[2] = divideByN_Latch[2]+7;
					if( ((audioControl_Latch[2]&0xA0)==0xA0) && (divideByN_Latch2[2]<0x60) )
						freq_sequre[2] = 0;
					else
						freq_sequre[2] = 15;
					divideByN_Latch2[3] = divideByN_Latch[3]*256+divideByN_Latch2[2];
					if( ((audioControl_Latch[3]&0xA0)==0xA0) && (divideByN_Latch2[3]<0x60) )
						freq_sequre[3] = 0;
					else
						freq_sequre[3] = 15;
					break;
			}
			break;
		case 0x05:
			audioControl_Latch[2] = value;
			audioControl_Latch2[2] = value&15;
			audioControl_Latch_Digi[2] = (value>>4)&1 ? 15:0;

			Channel2Distortion = channelsDistorionTable[2][ (value>>5)&7 ];
			switch( AUDCTL&0x28 )
			{
				case 0x00:
					divideByN_Latch2[2] = divideByN_Latch[2]+1;
					if( ((audioControl_Latch[2]&0xA0)==0xA0) && (divideByN_Latch2[2]<3) )
						freq_sequre[2] = 0;
					else
						freq_sequre[2] = 15;
					divideByN_Latch2[3] = divideByN_Latch[3]+1;
					if( ((audioControl_Latch[3]&0xA0)==0xA0) && (divideByN_Latch2[3]<3) )
						freq_sequre[3] = 0;
					else
						freq_sequre[3] = 15;
					break;
				case 0x08:
					divideByN_Latch2[2] = divideByN_Latch[2]+1;
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[2]<3) )
						freq_sequre[2] = 0;
					else
						freq_sequre[2] = 15;
					divideByN_Latch2[3] = divideByN_Latch[3]*256+divideByN_Latch2[2];
					if( ((audioControl_Latch[3]&0xA0)==0xA0) && (divideByN_Latch2[3]<3) )
						freq_sequre[3] = 0;
					else
						freq_sequre[3] = 15;
					break;
				case 0x20:
					divideByN_Latch2[2] = divideByN_Latch[2]+4;
					if( ((audioControl_Latch[2]&0xA0)==0xA0) && (divideByN_Latch2[2]<0x60) )
						freq_sequre[2] = 0;
					else
						freq_sequre[2] = 15;
					divideByN_Latch2[3] = divideByN_Latch[3]+1;
					if( ((audioControl_Latch[3]&0xA0)==0xA0) && (divideByN_Latch2[3]<3) )
						freq_sequre[3] = 0;
					else
						freq_sequre[3] = 15;
					break;
				case 0x28:
					divideByN_Latch2[2] = divideByN_Latch[2]+7;
					if( ((audioControl_Latch[2]&0xA0)==0xA0) && (divideByN_Latch2[2]<0x60) )
						freq_sequre[2] = 0;
					else
						freq_sequre[2] = 15;
					divideByN_Latch2[3] = divideByN_Latch[3]*256+divideByN_Latch2[2];
					if( ((audioControl_Latch[3]&0xA0)==0xA0) && (divideByN_Latch2[3]<0x60) )
						freq_sequre[3] = 0;
					else
						freq_sequre[3] = 15;
					break;
			}
			break;
		case 0x06:
			divideByN_Latch[3] = value;
			switch( AUDCTL&0x28 )
			{
				case 0x00:
					divideByN_Latch2[2] = divideByN_Latch[2]+1;
					if( ((audioControl_Latch[2]&0xA0)==0xA0) && (divideByN_Latch2[2]<3) )
						freq_sequre[2] = 0;
					else
						freq_sequre[2] = 15;
					divideByN_Latch2[3] = divideByN_Latch[3]+1;
					if( ((audioControl_Latch[3]&0xA0)==0xA0) && (divideByN_Latch2[3]<3) )
						freq_sequre[3] = 0;
					else
						freq_sequre[3] = 15;
					break;
				case 0x08:
					divideByN_Latch2[2] = divideByN_Latch[2]+1;
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[2]<3) )
						freq_sequre[2] = 0;
					else
						freq_sequre[2] = 15;
					divideByN_Latch2[3] = divideByN_Latch[3]*256+divideByN_Latch2[2];
					if( ((audioControl_Latch[3]&0xA0)==0xA0) && (divideByN_Latch2[3]<3) )
						freq_sequre[3] = 0;
					else
						freq_sequre[3] = 15;
					break;
				case 0x20:
					divideByN_Latch2[2] = divideByN_Latch[2]+4;
					if( ((audioControl_Latch[2]&0xA0)==0xA0) && (divideByN_Latch2[2]<0x60) )
						freq_sequre[2] = 0;
					else
						freq_sequre[2] = 15;
					divideByN_Latch2[3] = divideByN_Latch[3]+1;
					if( ((audioControl_Latch[3]&0xA0)==0xA0) && (divideByN_Latch2[3]<3) )
						freq_sequre[3] = 0;
					else
						freq_sequre[3] = 15;
					break;
				case 0x28:
					divideByN_Latch2[2] = divideByN_Latch[2]+7;
					if( ((audioControl_Latch[2]&0xA0)==0xA0) && (divideByN_Latch2[2]<0x60) )
						freq_sequre[2] = 0;
					else
						freq_sequre[2] = 15;
					divideByN_Latch2[3] = divideByN_Latch[3]*256+divideByN_Latch2[2];
					if( ((audioControl_Latch[3]&0xA0)==0xA0) && (divideByN_Latch2[3]<0x60) )
						freq_sequre[3] = 0;
					else
						freq_sequre[3] = 15;
					break;
			}
			break;
		case 0x07:
			audioControl_Latch[3] = value;
			audioControl_Latch2[3] = value&15;
			audioControl_Latch_Digi[3] = (value>>4)&1 ? 15:0;

			Channel3Distortion = channelsDistorionTable[3][ (value>>5)&7 ];
			switch( AUDCTL&0x28 )
			{
				case 0x00:
					divideByN_Latch2[2] = divideByN_Latch[2]+1;
					if( ((audioControl_Latch[2]&0xA0)==0xA0) && (divideByN_Latch2[2]<3) )
						freq_sequre[2] = 0;
					else
						freq_sequre[2] = 15;
					divideByN_Latch2[3] = divideByN_Latch[3]+1;
					if( ((audioControl_Latch[3]&0xA0)==0xA0) && (divideByN_Latch2[3]<3) )
						freq_sequre[3] = 0;
					else
						freq_sequre[3] = 15;
					break;
				case 0x08:
					divideByN_Latch2[2] = divideByN_Latch[2]+1;
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[2]<3) )
						freq_sequre[2] = 0;
					else
						freq_sequre[2] = 15;
					divideByN_Latch2[3] = divideByN_Latch[3]*256+divideByN_Latch2[2];
					if( ((audioControl_Latch[3]&0xA0)==0xA0) && (divideByN_Latch2[3]<3) )
						freq_sequre[3] = 0;
					else
						freq_sequre[3] = 15;
					break;
				case 0x20:
					divideByN_Latch2[2] = divideByN_Latch[2]+4;
					if( ((audioControl_Latch[2]&0xA0)==0xA0) && (divideByN_Latch2[2]<0x60) )
						freq_sequre[2] = 0;
					else
						freq_sequre[2] = 15;
					divideByN_Latch2[3] = divideByN_Latch[3]+1;
					if( ((audioControl_Latch[3]&0xA0)==0xA0) && (divideByN_Latch2[3]<3) )
						freq_sequre[3] = 0;
					else
						freq_sequre[3] = 15;
					break;
				case 0x28:
					divideByN_Latch2[2] = divideByN_Latch[2]+7;
					if( ((audioControl_Latch[2]&0xA0)==0xA0) && (divideByN_Latch2[2]<0x60) )
						freq_sequre[2] = 0;
					else
						freq_sequre[2] = 15;
					divideByN_Latch2[3] = divideByN_Latch[3]*256+divideByN_Latch2[2];
					if( ((audioControl_Latch[3]&0xA0)==0xA0) && (divideByN_Latch2[3]<0x60) )
						freq_sequre[3] = 0;
					else
						freq_sequre[3] = 15;
					break;
			}
			break;
		case 0x08:
		{
			BYTE prevAUDCTL;
			prevAUDCTL = AUDCTL;
			AUDCTL = value;
			pcc1564 = value & 1 ? 112:28;

			switch_J3_Q_stateAND[0] = AUDCTL&4 ? 15:0;
			switch_J3_Q_stateAND[1] = AUDCTL&2 ? 15:0;

			switch( AUDCTL&0x50 )
			{
				case 0x00:
					divideByN_Latch2[0] = divideByN_Latch[0]+1;
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[0]<3) )
						freq_sequre[0] = 0;
					else
						freq_sequre[0] = 15;
					divideByN_Latch2[1] = divideByN_Latch[1]+1;
					if( ((audioControl_Latch[1]&0xA0)==0xA0) && (divideByN_Latch2[1]<3) )
						freq_sequre[1] = 0;
					else
						freq_sequre[1] = 15;
					break;
				case 0x10:
					divideByN_Latch2[0] = divideByN_Latch[0]+1;
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[0]<3) )
						freq_sequre[0] = 0;
					else
						freq_sequre[0] = 15;
					divideByN_Latch2[1] = divideByN_Latch[1]*256+divideByN_Latch2[0];
					if( ((audioControl_Latch[1]&0xA0)==0xA0) && (divideByN_Latch2[1]<3) )
						freq_sequre[1] = 0;
					else
						freq_sequre[1] = 15;
					break;
				case 0x40:
					divideByN_Latch2[0] = divideByN_Latch[0]+4;
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[0]<0x60) )
						freq_sequre[0] = 0;
					else
						freq_sequre[0] = 15;
					divideByN_Latch2[1] = divideByN_Latch[1]+1;
					if( ((audioControl_Latch[1]&0xA0)==0xA0) && (divideByN_Latch2[1]<3) )
						freq_sequre[1] = 0;
					else
						freq_sequre[1] = 15;
					break;
				case 0x50:
					divideByN_Latch2[0] = divideByN_Latch[0]+7;
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[0]<0x60) )
						freq_sequre[0] = 0;
					else
						freq_sequre[0] = 15;
					divideByN_Latch2[1] = divideByN_Latch[1]*256+divideByN_Latch2[0];
					if( ((audioControl_Latch[1]&0xA0)==0xA0) && (divideByN_Latch2[1]<0x60) )
						freq_sequre[1] = 0;
					else
						freq_sequre[1] = 15;
					break;
			}

			switch( AUDCTL&0x28 )
			{
				case 0x00:
					divideByN_Latch2[2] = divideByN_Latch[2]+1;
					if( ((audioControl_Latch[2]&0xA0)==0xA0) && (divideByN_Latch2[2]<3) )
						freq_sequre[2] = 0;
					else
						freq_sequre[2] = 15;
					divideByN_Latch2[3] = divideByN_Latch[3]+1;
					if( ((audioControl_Latch[3]&0xA0)==0xA0) && (divideByN_Latch2[3]<3) )
						freq_sequre[3] = 0;
					else
						freq_sequre[3] = 15;
					break;
				case 0x08:
					divideByN_Latch2[2] = divideByN_Latch[2]+1;
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[2]<3) )
						freq_sequre[2] = 0;
					else
						freq_sequre[2] = 15;
					divideByN_Latch2[3] = divideByN_Latch[3]*256+divideByN_Latch2[2];
					if( ((audioControl_Latch[3]&0xA0)==0xA0) && (divideByN_Latch2[3]<3) )
						freq_sequre[3] = 0;
					else
						freq_sequre[3] = 15;
					break;
				case 0x20:
					divideByN_Latch2[2] = divideByN_Latch[2]+4;
					if( ((audioControl_Latch[2]&0xA0)==0xA0) && (divideByN_Latch2[2]<0x60) )
						freq_sequre[2] = 0;
					else
						freq_sequre[2] = 15;
					divideByN_Latch2[3] = divideByN_Latch[3]+1;
					if( ((audioControl_Latch[3]&0xA0)==0xA0) && (divideByN_Latch2[3]<3) )
						freq_sequre[3] = 0;
					else
						freq_sequre[3] = 15;
					break;
				case 0x28:
					divideByN_Latch2[2] = divideByN_Latch[2]+7;
					if( ((audioControl_Latch[2]&0xA0)==0xA0) && (divideByN_Latch2[2]<0x60) )
						freq_sequre[2] = 0;
					else
						freq_sequre[2] = 15;
					divideByN_Latch2[3] = divideByN_Latch[3]*256+divideByN_Latch2[2];
					if( ((audioControl_Latch[3]&0xA0)==0xA0) && (divideByN_Latch2[3]<0x60) )
						freq_sequre[3] = 0;
					else
						freq_sequre[3] = 15;
					break;
			}

			if( (prevAUDCTL^AUDCTL)&0x10 )
				divideByN[1] = 2;
			if( (prevAUDCTL^AUDCTL)&0x8 )
				divideByN[3] = 2;

			break;
		}
		case 0x0D:
			break;
		case 0x0E:
			break;
		case 0x0F:
			break;
	}
}


