{Alle Routinen fr den Bildschirm und die Tastatur-Hardware in HEXEDIT}

{$A+,B-,D-,E+,F-,G+,I-,L-,N+,O-,P+,Q-,R-,S-,T-,V-,X+}

UNIT CodeSys;

INTERFACE

CONST
HexChars: ARRAY[0..$F] OF CHAR = '0123456789ABCDEF';
StartCursor: WORD = $0607;
FUNCTION TestMFII : BOOLEAN;
FUNCTION GetMFII : WORD;
FUNCTION AltPressed : BOOLEAN;
FUNCTION ShiftPressed : BOOLEAN;
FUNCTION CtrlPressed : BOOLEAN;
PROCEDURE SetCursor(CursorShape: WORD);
PROCEDURE HideCursor;
PROCEDURE BlockCursor;
FUNCTION Byte2Hex(B : BYTE): STRING;
FUNCTION Long2Hex(L : LONGINT; Zero : BOOLEAN): STRING;
PROCEDURE SaveScreen;
PROCEDURE RestoreScreen;
PROCEDURE OpenWindow(X1, Y1, X2, Y2, Color : BYTE);
PROCEDURE FoldOffWindow(Title : STRING; X1, Y1, X2, Y2, Color1, Color2, Time : BYTE);
PROCEDURE InitMainScreen;
PROCEDURE UpDateView;
PROCEDURE StatusBar(Msg : STRING);
PROCEDURE InfoBar(Msg : STRING);
PROCEDURE UpDatePosition;
PROCEDURE UpDateSize(Size : LONGINT);
PROCEDURE ShowCursor;
PROCEDURE InsertFile;
PROCEDURE CheckUpperRange;
PROCEDURE CheckLowerRange;
PROCEDURE DoLeft;
PROCEDURE DoRight;
PROCEDURE DoUp;
PROCEDURE DoDown;
PROCEDURE DoPageUp;
PROCEDURE DoPageDown;
PROCEDURE DoHome;
PROCEDURE DoEnd;
PROCEDURE GotoSOF;
PROCEDURE GotoMOF;
PROCEDURE GotoEOF;
PROCEDURE ChangeWindow;
PROCEDURE DoReduce;
PROCEDURE ChangeMode;
PROCEDURE DoGoto;
PROCEDURE DoJmpSector;
PROCEDURE DoSearch;
PROCEDURE DoCalculator;
PROCEDURE ShowClipboard;
PROCEDURE DoPrint;
PROCEDURE PrintFile;

IMPLEMENTATION

USES Crt, MainSys, Drucker;

{$I KEYS.INC}
{$I SREACTS.INC}

FUNCTION TestMFII: BOOLEAN;

VAR
Got : BYTE;

BEGIN
TestMFII := FALSE;
ASM
MOV  AX, 1200H
INT  16H
CMP  AX, 1200H
JE   @None
MOV  Got, 1
JMP  @Ready
@None:
MOV Got, 0
JMP @Ready
@Ready:
END;
IF Got = 1 THEN
TestMFII := TRUE;
END;

FUNCTION GetMFII : WORD;

VAR
Res : WORD;

BEGIN
ASM
MOV AH, 10H
INT 16H
MOV Res, AX
END;
GetMFII := Res;
END;

FUNCTION AltPressed : BOOLEAN;

BEGIN
AltPressed := (BYTE(Ptr(Seg0040, $17)^) AND $08 = $08);
END;

FUNCTION ShiftPressed: BOOLEAN;

FUNCTION ShiftLeftPressed: BOOLEAN;

BEGIN
ShiftLeftPressed := BYTE(Ptr(Seg0040, $17)^) AND $02 = $02;
END;

FUNCTION ShiftRightPressed: BOOLEAN;

BEGIN
ShiftRightPressed := BYTE(Ptr(Seg0040, $17)^) AND $01 = $01;
END;

BEGIN
IF ShiftRightPressed OR ShiftLeftPressed THEN
ShiftPressed := TRUE
ELSE
ShiftPressed := FALSE;
END;

FUNCTION CtrlPressed : BOOLEAN;

BEGIN
CtrlPressed := BYTE(Ptr(Seg0040, $17)^) AND $04 = $04;
END;

PROCEDURE SetCursor(CursorShape: WORD); ASSEMBLER;

ASM
MOV CX, CursorShape
MOV AH, 01h
INT 10h
END;

PROCEDURE HideCursor;

BEGIN
SetCursor($1500);
END;

PROCEDURE BlockCursor;

BEGIN
SetCursor($0015);
END;

FUNCTION Byte2Hex(B : BYTE): STRING;

BEGIN
Byte2Hex[0] := #2;
Byte2Hex[1] := HexChars[B SHR  4];
Byte2Hex[2] := HexChars[B AND $F];
END;

FUNCTION Long2Hex(L : LONGINT; Zero : BOOLEAN): STRING;

VAR
S : STRING;
I, J : BYTE;

BEGIN
S := '';
REPEAT
IF L MOD $10 < 10 THEN
S := Chr(L MOD $10 + 48) + S
ELSE
S := Chr(L MOD $10 + 55) + S;
L := L DIV $10;
UNTIL L = 0;
IF Zero THEN
BEGIN
J := BYTE(S[0]);
IF J < 10 THEN
FOR I := J TO 10 DO
S := Concat('0', S);
END;
Long2Hex := S;
END;

PROCEDURE SaveScreen;

BEGIN
FOR Y := 1 TO 25 DO
FOR X := 1 TO 80 DO
Screen[Y, X] := VRAM[Y, X];
END;

PROCEDURE RestoreScreen;

BEGIN
FOR Y := 1 TO 25 DO
FOR X := 1 TO 80 DO
VRAM[Y, X] := Screen[Y, X];
END;

PROCEDURE OpenWindow(X1, Y1, X2, Y2, Color : BYTE);

BEGIN
TextBackground(Color);
FOR X := X1 TO X2 DO
FOR Y := Y1 TO Y2 DO
BEGIN
GotoXY(X, Y);
Write(' ');
END;
END;

PROCEDURE FoldOffWindow(Title : STRING; X1, Y1, X2, Y2, Color1, Color2, Time : BYTE);

VAR
MX : BYTE;

PROCEDURE DrawLines;

BEGIN
TextColor(Black);
FOR X := X1 TO X2 DO
BEGIN
GotoXY(X, Y1);
Write(#205);
GotoXY(X, Y2);
Write(#205);
END;
FOR Y := Y1 TO Y2 DO
BEGIN
GotoXY(X1, Y);
Write(#186);
GotoXY(X2, Y);
Write(#186);
END;
GotoXY(X1, Y1);
Write(#201);
GotoXY(X1, Y2);
Write(#200);
GotoXY(X2, Y1);
Write(#187);
GotoXY(X2, Y2);
Write(#188);
END;

BEGIN
MX := (X2-X1) DIV 2 + X1;
TextBackground(Color1);
FOR Y := Y1 TO Y2 DO
FOR X := 0 TO ((X2-X1) DIV 2)-1 DO
BEGIN
GotoXY(MX-X, Y);
Write(' ');
GotoXY(MX+X, Y);
Write(' ');
Delay(Time);
END;
DrawLines;
X := (((X2-X1) - Length(Title)) DIV 2) + X1;
GotoXY(X, Y1);
TextColor(Color2);
Write(Title);
END;

PROCEDURE InitMainScreen;

PROCEDURE StatusLine;

BEGIN
TextColor(Red);
TextBackground(LightGray);
GotoXY(2, 25);
Write('                                                                              ');
GotoXY(9, 25);
Write('ESC');
GotoXY(20, 25);
Write('F1');
GotoXY(38, 25);
Write('F2');
GotoXY(47, 25);
Write('F3');
GotoXY(56, 25);
Write('F4');
GotoXY(65, 25);
Write('F10');
TextColor(Black);
GotoXY(12, 25);
Write('-Quits');
GotoXY(22, 25);
Write('-Switch Window');
GotoXY(40, 25);
Write('-Save');
GotoXY(49, 25);
Write('-Open');
GotoXY(58, 25);
Write('-Goto');
GotoXY(68, 25);
Write('-Help');
END;

BEGIN
HideCursor;
TextBackground(Blue);
ClrScr;
OpenWindow(6, 7, 52, 22, Black);
OpenWindow(59, 7, 74, 22, Black);
TextBackGround(Blue);
TextColor(LightGray);
GotoXY(6, 6);
Write('00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F      0123456789ABCDEF');
GotoXY(6, 23);
Write('00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F      0123456789ABCDEF');
FOR Y := 7 TO 22 DO
BEGIN
GotoXY(3, Y);
Write(Byte2Hex(Y-7));
GotoXY(55, Y);
Write(Byte2Hex(Y-7));
GotoXY(76, Y);
Write(Byte2Hex(Y-7));
END;
TextColor(LightRed);
GotoXY(2, 1);
Write('Status: ');
GotoXY(2, 24);
Write('Filename: ');
GotoXY(58, 1);
Write('Position: ');
GotoXY(58, 3);
Write('Filesize: ');
FoldOffWindow('', 1, 2, 56, 5, Blue, Black, 0);
StatusLine;
END;

PROCEDURE UpDateView;

BEGIN
SaveScreen;
Move(FileArea[CurPos], PageArea, SizeOf(PageArea));
Runs := 0;
EndMarker := FALSE;
FOR Y := 7 TO 22 DO
FOR X := 59 TO 74 DO
BEGIN
IF NOT OldM OR (((LONGINT(Blocks)*LONGINT(15104)+CurPos+Runs) < MarkStart) OR
((LONGINT(Blocks)*LONGINT(15104)+CurPos+Runs) > MarkEnd)) THEN
BEGIN
Screen[Y, X] := (Yellow SHL 8) OR PageArea[Runs];
IF (PageArea[Runs] IN [0, 255]) THEN
Screen[Y, X] := (Red SHL 8) OR 46;
IF Reduce AND (PageArea[Runs] IN [0..31, 127..255]) THEN
Screen[Y, X] := (Red SHL 8) OR 46;
END;
IF OldM AND (((LONGINT(Blocks)*LONGINT(15104)+CurPos+Runs) >= MarkStart) AND
((LONGINT(Blocks)*LONGINT(15104)+CurPos+Runs) <= MarkEnd)) THEN
BEGIN
Screen[Y, X] := (((Red SHL 4) OR White) SHL 8) OR PageArea[Runs];
IF (PageArea[Runs] IN [0, 255]) THEN
Screen[Y, X] := (((Red SHL 4) OR Yellow) SHL 8) OR 46;
IF Reduce AND (PageArea[Runs] IN [0..31, 127..255]) THEN
Screen[Y, X] := (((Red SHL 4) OR Yellow) SHL 8) OR 46;
END;
Inc(Runs);
IF ((Runs+CurPos) = (EndPos+1)) THEN
BEGIN
CountMSG :=  ' << END OF FILE ';
FillChar(PageArea, 256, 32);
Move(CountMSG, PageArea[Runs], SizeOf(CountMSG));
FOR I := X+1 TO 74 DO
Screen[Y, I] := (White SHL 8) OR 32;
X := 74;
END;
IF (((Runs+CurPos) > (EndPos+1)) AND (EndPos <> -1)) OR EndMarker THEN
BEGIN
Screen[Y, X] := (White SHL 8) OR PageArea[Runs];
EndMarker := TRUE;
END;
END;
EndMarker := FALSE;
Runs := 0;
OldMarked := 6;
Move(FileArea[CurPos], PageArea, SizeOf(PageArea));
FOR Y := 7 TO 22 DO
BEGIN
FOR X := 0 TO 15 DO
BEGIN
IF ((Runs+CurPos) < (EndPos+1)) OR (EndPos = -1) THEN
BEGIN
Temp := Byte2Hex(PageArea[Runs]);
IF OldM AND (((LONGINT(Blocks)*LONGINT(15104)+CurPos+Runs) >= MarkStart) AND
((LONGINT(Blocks)*LONGINT(15104)+CurPos+Runs) <= MarkEnd)) THEN
BEGIN
Screen[Y, OldMarked] := (((Red SHL 4) OR White) SHL 8) OR Ord(Temp[1]);
Screen[Y, OldMarked+1] := (((Red SHL 4) OR White) SHL 8) OR Ord(Temp[2]);
END;
IF NOT OldM OR (((LONGINT(Blocks)*LONGINT(15104)+CurPos+Runs) < MarkStart) OR
((LONGINT(Blocks)*LONGINT(15104)+CurPos+Runs) > MarkEnd)) THEN
BEGIN
Screen[Y, OldMarked] := (Yellow SHL 8) OR Ord(Temp[1]);
Screen[Y, OldMarked+1] := (Yellow SHL 8) OR Ord(Temp[2]);
END;
END;
Inc(Runs);
IF ((Runs+CurPos) = (EndPos+1)) AND (EndPos <> -1) THEN
BEGIN
FillChar(PageArea, SizeOf(PageArea), 32);
IF Runs = 255 THEN
Dec(Runs);
PageArea[Runs+1] := Ord('<');
FOR I := OldMarked+2 TO 52 DO
Screen[Y, I] := (White SHL 8) OR 32;
END;
IF (((Runs+CurPos) > (EndPos+1)) AND (EndPos <> -1)) OR EndMarker THEN
BEGIN
Screen[Y, OldMarked] := (White SHL 8) OR PageArea[Runs];
Screen[Y, OldMarked+1] := (White SHL 8) OR PageArea[Runs];
EndMarker := TRUE;
END;
IF X < 15 THEN
Screen[Y, OldMarked+2] := (Yellow SHL 8) OR 32;
IF (OldM AND (((LONGINT(Blocks)*LONGINT(15104)+CurPos+Runs) >= MarkStart) AND
((LONGINT(Blocks)*LONGINT(15104)+CurPos+Runs) <= MarkEnd))) AND (X < 15) AND (((CurPos+Runs) <= EndPos) OR (EndPos = -1)) THEN
Screen[Y, OldMarked+2] := (((Red SHL 4) OR White) SHL 8) OR 32;
Inc(OldMarked, 3);
END;
OldMarked := 6;
END;
Move(FileArea[CurPos], PageArea, SizeOf(PageArea));
RestoreScreen;
END;

PROCEDURE StatusBar(Msg : STRING);

BEGIN
GotoXY(10, 1);
TextBackground(Blue);
TextColor(LightGreen);
Write('                                            ');
GotoXY(10, 1);
Write(Msg);
END;

PROCEDURE InfoBar(Msg : STRING);

BEGIN
TextBackground(Blue);
TextColor(White);
GotoXY(2, 3);
Write('                                                      ');
GotoXY(2, 4);
Write('                                                      ');
GotoXY(3, 3);
Write(Msg);
GotoXY(1, 4);
TextColor(Black);
Write(#186);
END;

PROCEDURE UpDatePosition;

BEGIN
TextBackground(Blue);
TextColor(Black);
GotoXY(79, 1);
Write('h');
GotoXY(79, 2);
Write('d');
TextColor(LightGreen);
GotoXY(68, 2);
Write('           ');
GotoXY(68, 2);
Write(Position);
GotoXY(68, 1);
Write(Long2Hex(Position, TRUE));
END;

PROCEDURE UpDateSize(Size : LONGINT);

BEGIN
TextBackground(Blue);
TextColor(White);
GotoXY(68, 3);
Write('            ');
GotoXY(68, 3);
Write(Long2Hex(Size, TRUE));
GotoXY(68, 4);
Write('            ');
GotoXY(68, 4);
Write(Size);
TextColor(Black);
GotoXY(79, 3);
Write('h');
GotoXY(79, 4);
Write('d');
END;

PROCEDURE ShowCursor;

BEGIN
Y := CursorPOS DIV 16 + 7;
X := CursorPOS MOD 16 + 59;
GotoXY(X, Y);
IF NOT FileWindow THEN
BEGIN
Dec(X, 59);
X := X*3+6;
IF NOT First THEN
Inc(X);
First := NOT First;
GotoXY(X, WhereY);
END;
IF UpDateCur THEN
BEGIN
X := WhereX;
Y := WhereY;
CurMarked := PageArea[CursorPos];
Str(CurMarked, Temp);
Str(MaxBlocks, Dir);
Str(Blocks+1, CountMSG);
FOR I := 0 TO 7 DO
BEGIN
FileInfo.Name := Chr((CurMarked MOD 2)+48) + FileInfo.Name;
CurMarked := CurMarked DIV 2;
END;
FileInfo.Name[0] := #8;
IF Temp[0] = #1 THEN
Temp := '  '+Temp;
IF Temp[0] = #2 THEN
Temp := ' '+Temp;
Dir := CountMsg + '/' + Dir;
CASE Insert OF
TRUE :
CountMsg := '  INSERT';
ELSE
CountMsg := 'OVERTYPE';
END;
CurMarked := 53-Length(Dir)-45;
FOR I := 1 TO CurMarked DO
Dir := Dir + ' ';
Dir := Dir + 'Marked Block: ';
TempS := '-';
IF OldM THEN
BEGIN
Str(MarkEnd-MarkStart+1, TempS);
IF Length(TempS) < 4 THEN
REPEAT
TempS := ' ' + TempS;
UNTIL Length(TempS) = 4;
TempS := TempS + ' Byte';
END;
InfoBar(' ASCII-Code of the char: '+Temp+'d'+' - '+FileInfo.Name+'b   '+ CountMSG+
#10#13#32#32#32+'Current Sector: '+Dir+TempS);
GotoXY(59, 24);
TextBackGround(Blue);
TextColor(LightGreen);
IF FileState = Changed THEN
Write('CHANGED  ')
ELSE
Write('UNCHANGED');
GotoXY(X, Y);
SetCursor(StartCursor);
END;
END;

PROCEDURE InsertFile;

VAR
Temp, Drive : LONGINT;

BEGIN
IF Index > 0 THEN
BEGIN
Seek(WorkFile, FileSize(WorkFile));
BlockWrite(WorkFile, FileArea, Index, Counts);
IF Counts <> Index THEN
BEGIN
SaveScreen;
FoldOffWindow(' Note ',21, 9, 63, 16, LightCyan, Black+Blink, 1);
TextBackground(LightCyan);
TextColor(LightRed);
GotoXY(26, 11);
Write('Cannot write file, disk''s full...');
IF ((NOT BackUp) OR ((FileSize(WorkFile)-Counts) < Index)) THEN BEGIN
InfoBar(MSG4);
TextBackground(LightCyan);
TextColor(Black);
GotoXY(26, 14);
Write('Press a key to exit...');
ReadKey;
EndUp('');
END
ELSE
BEGIN
InfoBar(MSG3);
TextBackground(LightCyan);
TextColor(Black);
GotoXY(23, 13);
Write('Continue without Backup/Undo Functions?');
GotoXY(39, 14);
Write('[Y/N]:');
BlockCursor;
REPEAT
C := ReadKey;
UNTIL C IN ['N', 'n', 'Y', 'y'];
IF C IN ['N', 'n'] THEN
EndUp('');
Erase(BackUpFile);
IF IOResult <> 0 THEN
EndUp('Error: Could not locate Backup-File...');
BackUp := FALSE;
Seek(WorkFile, FileSize(WorkFile));
BlockWrite(WorkFile, FileArea, Index-Counts, Counts);
RestoreScreen;
END;
END;
FOR I := MaxBlocks-1 DOWNTO (Blocks+1) DO
BEGIN
Seek(WorkFile, LONGINT(I)*LONGINT(15104));
Drive := 15104;
IF I = (MaxBlocks-1) THEN
Drive := FileSize(WorkFile)-(LONGINT(I)*LONGINT(15104))-LONGINT(Index);
IF Drive > 15360 THEN
Drive := FileSize(WorkFile)-(LONGINT(I)*LONGINT(15360))-LONGINT(Index);
BlockRead(WorkFile, TempArea, WORD(Drive), Counts);
Seek(WorkFile, (LONGINT(I)*LONGINT(15104))+LONGINT(Index));
BlockWrite(WorkFile, TempArea, Counts);
END;
Seek(WorkFile, LONGINT(Blocks)*LONGINT(15104));
IF Blocks < (MaxBlocks-1) THEN
IF Blocks = 0 THEN
BlockWrite(WorkFile, FileArea, 15360+Index, Counts)
ELSE
BlockWrite(WorkFile, FileArea, 15104+Index, Counts)
ELSE
BlockWrite(WorkFile, FileArea, EndPos+Index, Counts);
END;
IF Index < 0 THEN
BEGIN
FOR I := (Blocks+1) TO (MaxBlocks-1) DO
BEGIN
Seek(WorkFile, LONGINT(I)*LONGINT(15104));
BlockRead(WorkFile, TempArea, 15360, Counts);
Seek(WorkFile, (LONGINT(I)*LONGINT(15104))+LONGINT(Index));
BlockWrite(WorkFile, TempArea, Counts);
END;
Seek(WorkFile, LONGINT(Blocks*15104));
IF Blocks = 0 THEN
BlockWrite(WorkFile, FileArea, 15360+Index, Counts)
ELSE
BlockWrite(WorkFile, FileArea, 15104+Index, Counts);
Seek(WorkFile, FileSize(WorkFile)+LONGINT(Index));
Truncate(WorkFile);
END;
MaxBlocks := 1;
Inc(MaxBlocks, (FileSize(WorkFile)-15360) DIV 15104);
IF ((FileSize(WorkFile)-15360) MOD 15104) <> 0 THEN
Inc(MaxBlocks);
Index := 0;
END;

PROCEDURE CheckUpperRange;

BEGIN
IF (CurPos = 0) AND (Position <> 0) THEN
BEGIN
IF Index = 0 THEN
BEGIN
Seek(WorkFile, LONGINT(Blocks)*(LONGINT(15360)-LONGINT(256)));
IF EndPos = 0 THEN
I := 0
ELSE
IF EndPos <> -1 THEN
I := EndPos+1
ELSE
I := 15360;
BlockWrite(WorkFile, FileArea, I, Counts);
IF ((LONGINT(Blocks)*(LONGINT(15360)-LONGINT(256))+LONGINT(EndPos)) < FileSize(WorkFile)) AND (EndPos <> -1) THEN
Truncate(WorkFile);
END
ELSE
BEGIN
OldPos := 0;
InsertFile;
END;
Dec(Blocks);
Seek(WorkFile, LONGINT(Blocks)*(LONGINT(15360)-LONGINT(256)));
 BlockRead(WorkFile, FileArea, 15360, I);
CurPos := 15360-256;
EndPos := -1;
IF I <> 15360 THEN
EndPos := I-1;
END;
END;

PROCEDURE CheckLowerRange;

BEGIN
IF ((CurPos+CursorPos) >= 15343) AND ((CurPos+CursorPos) <= 15359) AND ((Blocks <= MaxBlocks-1) OR (Index <> 0)) THEN
BEGIN
OldPos := FilePos(WorkFile);
IF (Index = 0) OR (Blocks = MaxBlocks-1) THEN
BEGIN
IF Blocks = 0 THEN
Seek(WorkFile, 0)
ELSE
Seek(WorkFile, LONGINT(Blocks)*(LONGINT(15360)-LONGINT(256)));
BlockWrite(WorkFile, FileArea, 15360, Counts);
IF Index > 0 THEN
BEGIN
Inc(MaxBlocks);
OldPos := (Blocks+1)*15360;
Index := 0;
END;
END
ELSE
InsertFile;
IF EndPos <> -1 THEN
OldPos := (Blocks+1)*LONGINT(15360);
Seek(WorkFile, OldPos-LONGINT(256));
BlockRead(WorkFile, FileArea, 15360, Counts);
IF Counts < 15360 THEN
EndPos := INTEGER(Counts-1)
ELSE
EndPos := -1;
IF Counts = 0 THEN
EndPos := 0;
CurPos := 0;
Inc(Blocks);
END;
END;

END.
