{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}

Unit WritePro;
INTERFACE
Uses StrType;
Procedure WriteByte (w:byte);
Procedure WriteSocket(s:Word);
FUNCTION HexToDec(HexStr : tStr4 ) : Word;


IMPLEMENTATION

Procedure WriteByte (w:byte);
const hex:array[0..15] of char='0123456789ABCDEF';
begin
  Write(hex[(w shr 4) and $F]);
  Write(hex[w and $F]);
end;

Procedure WriteSocket(s:Word);
begin
  writeByte(lo(s));writeByte(hi(s));
end;

FUNCTION HexToDec(HexStr : tStr4 ) : Word;

VAR
  Len     : Byte;                                     { String-Lnge HexStr }
  Count   : Word;                                              { ein Zhler }
  Fail    : Boolean;  { TRUE, wenn ein Zeichen in dem Hex-String falsch ist }
  Mult    : LongInt;                                        { Multiplikator }
  Ch      : Char;                    { Zeichen, das gerade umgewandelt wird }
  Decimal : Word;                                             { Dezimalwert }

BEGIN
  HexToDec := 0;
  IF HexStr <> '' THEN                             { Hex-String nicht leer? }
    BEGIN                                        { nein, Umwandlung starten }
      Len := Length(HexStr);                   { Lnge von HexStr ermitteln }
      Count := Len;                                         { Zhler setzen }
      Fail := FALSE;                                      { noch alles o.k. }
      Mult := 1;                               { Multiplikator auf 1 setzen }
      Decimal := 0;                           { Dezimalwert ist am Anfang 0 }
      REPEAT                                              { Schleifenanfang }
        Ch := UpCase(HexStr[Count]);                    { Zeichen bestimmen }
        CASE Ch OF                     { die eigentliche Umwandlung beginnt }
          '0'..'9' :
            Inc(Decimal, Mult*(Byte(Ch)-48));
          'A'..'F' :
            Inc(Decimal, Mult*(Byte(Ch)-55));
        ELSE                           { ein falsches Zeichen im Hex-String }
          Fail := TRUE;                              { Umwandlung abbrechen }
        END;
        Dec(Count);                                    { Zhler erniedrigen }
        Mult := 16*Mult;                             { Multiplikator mal 16 }
      UNTIL (Count = 0) OR Fail;                            { Schleifenende }
      IF NOT Fail THEN      { wenn alles o.k., dann Dezimalwert zurckgeben }
        HexToDec := Decimal
      ELSE                                     { ein Fehler ist aufgetreten }
        HexToDec := 0;
    END;
END;


End.