{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
Unit Screens;
INTERFACE
{$X+,O+,F+}
{ Diese Unit stellt die Funktionen zum Modifizieren von Variabelen bereit,
  die per UNI-Look geschieht. }
Uses      Dos,  { Die Dos-Unit einbinden, um z.B. die "Register"-Variabelen zu benutzen }
         CRT,  { Fr Keypressed und Readkey }
    String_P,  { String-Funktionen und Prozeduren }
     StrType,
       Video,
    MiscProc;

Const
 pro_JESNO = 1;
 pro_ONOFF = 2;

Procedure PaintBox( X1, Y1, X2, Y2 : Byte );
{ Zeichnet einen Kasten mit den Eckpunkten X1, X2, Y1, Y2 }

Procedure MessageBox(X1, Y1, L, H : Byte; MessageText : String);


Procedure ModifyBoolean( Var InBool : Boolean; PromptText : Byte );
{ ndert eine Boolsche Variabele }
Procedure ModifyString( Var InString : tStr50 );
{ ndert einen String (VIEL STACK NTIG !!!!!) }
Procedure ModifyWord( Var InNum : Word );

Procedure ColorHi;
Procedure ColorLo;

Procedure EditSmallText( Var InText : pTextString );

Function AskBoolean(X1, Y1, L, H : Byte;  MessageText :  String ) : Boolean;

Procedure PaintBoxShadow( X1, Y1, X2, Y2 : Byte );


Procedure Bar100( X, Y : Word ; MaxNum, CurrNum : LongInt; Shadow : Boolean; Title : String );
IMPLEMENTATION

Procedure PaintBox( X1, Y1, X2, Y2 : Byte );
{ Zeichnet einen Kasten mit den Eckpunkten X1, X2, Y1, Y2 }
Var
 Lauf1, Lauf2 : Word;
Begin
 GotoXY(X1,Y1);
 Write('');
 For Lauf1 := X1 + 1 to X2 - 1 do Write('');
 Writeln('');

 For Lauf1 := Y1 + 1 to Y2 - 1 do
  Begin
   GotoXY(X1,lauf1 );
   Write('');
   For Lauf2 := X1 + 1 to X2 - 1 do Write(' ');
   Write('');
  End;
 GotoXY(X1,Y2 );
 Write(''); For Lauf1 := X1 + 1 to X2 - 1 do Write(''); Write('');
End;


Procedure PaintBoxShadow( X1, Y1, X2, Y2 : Byte );
Var
 Lauf1, Lauf2 : Word;
Begin
 TextBackGround(Black);
 TextColor(DarkGray);
 For Lauf1 := X1 + 1 to X2 + 1 do
  Begin
   GotoXY(Lauf1,Y2+1);
   Write('');
  End;
 For Lauf1 := Y1 + 1 to Y2 + 1 do
  Begin
   GotoXY(X2+1,Lauf1);
   Write('');
  End;

 ColorLo;

 PaintBox(X1,Y1,X2,Y2);
End;

Procedure MessageBox(X1, Y1, L, H : Byte; MessageText : String );
Var
 Lauf1, Lauf2 : Word;
  OSptr : Pointer;
Begin
 oSptr := Sptr;
 SaveScreen;
 CurSoroff;
 ColorLo;

 GotoXY(X1+1,Y1+1);
 TextBackGround(Black);
 TextColor(DarkGray);
 For Lauf2 := Y1+1 to Y1 + 2 + H do
  For Lauf1 := X1+1 to X1 + L + 3 do
   Begin
    GotoXY(Lauf1,Lauf2);
    Write('');
   End;
 ColorLo;
 PaintBox(X1,Y1,X1 + 2 + L, Y1 + 1 + H);
 GotoXY(((X1 + X1 + 2 + L) div 2) - (Length(MessageText) div 2),Y1+1);
 Write(MessageText);
 Readkey;
 RestoreScreen;
 Sptr := osptr;
End;

Procedure ColorHi;
Begin
 TextColor(Blue);
 TextBackGround(LightGray);
End;

Procedure ColorLo;
Begin
 TextColor(Yellow);
 TextBackGround(Blue);
End;

Procedure ModifyBoolean( Var InBool : Boolean; PromptText : Byte );
Var
 Selected : Boolean;
          Eingabe : Char;
         EndeMenu : Boolean;
     Lauf1, Lauf2 : Word;
     YesText, NoText : tStr19;
Begin
 If PromptText = 1 then
  Begin
   YesText := '        JA         ';
    NoText := '       NEIN        ';
  End
 Else
  Begin
   YesText := '        AN         ';
   NoText := '        AUS        ';
  End;
 SaveScreen;
 PaintBoxShadow(30,10,50,13);
 EndeMenu := FALSE;
 Selected := InBool;
 Repeat
  If Selected then ColorHI else ColorLo;
  GotoXY(31,11); Write(YesText);
  If Not(Selected) then ColorHI else ColorLo;
  GotoXY(31,12); Write(NoText);

  Eingabe := Readkey;
  Case Eingabe of
   #0, #224 : Begin
         Eingabe := READKEY;
         Case Eingabe of
       #80,#72 : Selected := Not(Selected); { Rauf }
         End;
        End;
  #27 : EndeMenu := TRUE; { Bei ESC die EIngangsdaten nicht ndern }
  #13 : Begin
         InBool := Selected;
         EndeMenu := TRUE;
        End;
  End;
 Until EndeMenu;
 RestoreScreen;
End;


Procedure ModifyString( Var InString : tStr50 );
Var
 OSptr : Pointer;
Begin
 Osptr := Sptr;
 SaveScreen;
 PaintBoxShadow(8,10,70,12);
 GotoXY(10,11);
 ColorLo;
 CurSorOn;
 ReadStr(InString,51,TRUE);
 CurSorOff;
 RestoreScreen;
 Sptr := Osptr;
End;

Procedure ModifyWord( Var InNum : Word );
Begin
 SaveScreen;
 PaintBoxShadow(28,10,52,12);
 GotoXY(29,11);
 CurSorOn;
 InNum := ReadInteger(InNum,0,65535);
 CurSorOff;
 RestoreScreen;
End;


Function AskBoolean(X1, Y1, L, H : Byte;  MessageText :  String ) : Boolean;
Var
       InBool : Boolean;
 Lauf1, Lauf2 : Word;
     EndeMenu : Boolean;
     Selected : Boolean;
      Eingabe : Char;
        OSptr : Pointer;
Begin
 InBool := FALSE;
 OSptr := Sptr;
 SaveScreen;
 CurSoroff;
 ColorLo;

 GotoXY(X1+1,Y1+1);
 TextBackGround(Black);
 TextColor(DarkGray);
 For Lauf2 := Y1+1 to Y1 + 2 + H do
  For Lauf1 := X1+1 to X1 + L + 3 do
   Begin
    GotoXY(Lauf1,Lauf2);
    Write('');
   End;
 ColorLo;
 PaintBox(X1,Y1,X1 + 2 + L, Y1 + 1 + H);
 GotoXY(((X1 + X1 + 2 + L) div 2) - (Length(MessageText) div 2),Y1+1);
 Write(MessageText);
 TextBackGround(Black);
 TextColor(DarkGray);

 For Lauf2 := 11 to 14 do
  For Lauf1 := 31 to 51 do
   Begin
    GotoXY(Lauf1,Lauf2);
    Write('');
   End;
 ColorLo;

 PaintBox(30,10,50,13);

 EndeMenu := FALSE;
 Selected := InBool;
 Repeat
  If Selected then ColorHI else ColorLo;
  GotoXY(31,11); Write('        JA         ');
  If Not(Selected) then ColorHI else ColorLo;
  GotoXY(31,12); Write('       NEIN        ');
  Eingabe := Readkey;
  Case Eingabe of
   #0, #224 : Begin
         Eingabe := READKEY;
         Case Eingabe of
       #80,#72 : Selected := Not(Selected); { Rauf }
         End;
        End;
  #27 : Begin              { Bei ESC die EIngangsdaten nicht ndern }
         EndeMenu := TRUE;
        End;
  #13 : Begin
         InBool := Selected;
         EndeMenu := TRUE;
        End;
  End;
 Until EndeMenu;
 RestoreScreen;
 Sptr := OSptr;
 AskBoolean := InBool;
End;


Procedure EditSmallText( Var InText : pTextString );
Const
 MaxCol = 70;

 INS_OVER = TRUE;
 INS_INS = FALSE;
Var
             OSptr : Pointer;
            OSptr2 : Pointer;
            EndeOk : Boolean;
           Eingabe : Char;
            MyText : pTextString;
  CurPosX, CurPosY : Word;
             Lauf1 : Word;
          InsertSw : Boolean;

  Procedure WrapTextBack;
  Var
   Lauf1 : Word;
  Begin
   For Lauf1 := CurPosY + 1 to MaxLines - 1 do
    Begin
     MyText^[Lauf1-1][MaxCol] := MyText^[Lauf1][1];
     Delete(MyText^[Lauf1],1,1);
    End;
   For Lauf1 := 1 to MaxLines do
    MyText^[Lauf1][0] := Chr(MaxCol);
  End;

  Procedure WrapTextForward;
  Var
   Lauf1 : Word;
   Temp,temp2 : Char;
   temps2 : String[1];
  Begin
   Temps2 := ' ';
   Temp := MyText^[CurPosY][MaxCol];
   Delete(MyText^[CurPosY],MaxCol,1);
   Insert(Temps2,MyText^[CurPosY],CurPosX);

   For Lauf1 := CurPosY + 1 to MaxLines - 1 do
    Begin
     Temp2 := MyText^[Lauf1][MaxCol];
     Delete(MyText^[Lauf1],MaxCol,1);
     Temps2 := Temp;
     Insert(Temps2,MyText^[Lauf1],1);
     Temp := Temp2;
    End;

   For Lauf1 := 1 to MaxLines do
    MyText^[Lauf1][0] := Chr(MaxCol);
  End;
  Procedure MGotoXY( X, Y : Byte );
  Begin
   GotoXY(4+X,2+Y);
  End;

  Procedure PrintINfo;
  Begin
   GotoXY(11,5); Write('ESC = Beenden ohne Sichern');
   GotoXY(12,6); Write('F1 = Tastenbelegung');
   GotoXY(11,7); Write('F10 = Sichern & Beenden');

   GotoXY(10,9); Write('PGUP = erste Zeile');
   GotoXY(10,10); Write('PGDN = letzte Zeile');
   GotoXY(10,11); Write('POS1 = erste Spalte');
   GotoXY(10,12); Write('ENDE = letze Spalte');

   GotoXY(11,13); Write('INS = Einfgen/berschreiben');

   GotoXY(10,15); Write('BKSP = Zeichen vor dem Cursor lschen');
   GotoXY(11,16); Write('DEL = Zeichen unter dem Cursor lschen');
  ENd;


Begin
 MyText := NIL;
 InsertSw := INS_OVER;
 OSptr := Sptr;
 SaveScreen;

 PaintBoxShadow(3,2,76,3+ MaxLines);
 GotoXY(5,3+MaxLines);
 Write('<F1=TASTEN>');
 GotoXY(47,3+MaxLines);
 Write('<ESC=ENDE><F10=SICHERN+ENDE>');
 EndeOK := FALSE;
 getMem(MyText,SizeOf(tTextString));
 FillChar(MyText^,SizeOf(tTextString),0);
 If InText <> NIL then
  Begin
   Move(InText^,MyText^,SizeOf(tTextString));
  End;

 For Lauf1 := 1 to MaxLines do
  Begin
   MyText^[Lauf1][0] := Chr(70);
  End;

 CurPosX := 1;
 CurPosY := 1;
 MGotoXY(1,1);
 For Lauf1 := 1 to MaxLines do
  Begin
   MGotoXY(1,Lauf1);
   Write(MyText^[Lauf1]);
  End;
 Repeat
  CurSorOff;
  MGotoXY(1,CurPOsY); Write(MyText^[CurPosY]);
  If CurPOsY > 1 then
   Begin
      MGotoXY(1,CurPOsY-1); Write(MyText^[CurPosY-1]);
   End;
  If CurPOsY < MaxLines then
   Begin
      MGotoXY(1,CurPOsY+1); Write(MyText^[CurPOsY+1]);
   End;

  CurSorOn;

  MGotoXY(CurPosX,CurPosY);

  Eingabe := Readkey;
  Case Eingabe Of
     #0, #224 : Begin
           Eingabe := Readkey;
           Case Eingabe of
             #71 : CurPosX := 1;      { Home }
             #79 : CurPosX := MaxCol; { End }
             #73 : CurPosY := 1; { PgUp }
             #81 : CurPosY := MaxLines; { PgDown }
             #72 : If CurPosY > 1 then { Rauf }
                    Begin
                     Dec(CurPosY);
                    End;
             #80 : If CurPosY < MaxLines then { Runter }
                    Begin
                     Inc(CurPosY);
                    End;
             #75 : If CurPosX > 1 then
                    Begin
                     Dec(CurPOsX);
                    End;
             #77 : If CurPosX < MaxCol then
                    Begin
                     Inc(CurPosX);
                    End;
             #59 : Begin
                    OSptr2 := Sptr;
                    SaveScreen;
                    CurSorOff;
                    PaintBoxShadow(6,3,77,23);
                    GotoXY(35,3);
                    Write('< TASTENBELEGUNG >');
                    PrintInfo;
                    If (ReadKey = #0) or (Readkey = #224) then Readkey;
                    CurSorOn;
                    RestoreScreen;
                    Sptr := OSptr2;
                   End;
             #68 : Begin { F10 }
                    EndeOk := TRUE;
                    If InText <> NIL then FreeMem(InText,SizeOf(tTextString));
                    InText := MyText;

                   End;
             #83 : Begin { Del }
                    Delete(MyText^[CurPosY],CurPosX,1);
                    WrapTextBack;
                   End;
          #82 : InsertSw:= not(InsertSw); {toggle insert}


           End;
          End;
    #13 : Begin
           If CurPosY < MaxLines then
            Begin
             Inc(CurPosY);
             CurPosX := 1;
            End;
          End;
    #27 : Begin { ESC }
           EndeOk := TRUE;
           FreeMem(MyText,SizeOf(tTextString));
          End;

 #32..#126,#128..#255 :
          Begin
           If InsertSw = INS_OVER then
            BEgin
             MyText^[CurPOsY][CurPosX] := Eingabe;
             If CurPosX < MaxCol then
              Begin
               Inc(CurPosX);
              End
             Else If CurPosY < MaxLines then
              Begin
               CurPOsX := 1;
               Inc(CurPosY);
              End;
             End
            Else
             Begin
              WrapTextForward;
              MyText^[CurPOsY][CurPosX] := Eingabe;
              If CurPosX < MaxCol then
               Begin
                Inc(CurPosX);
               End
              Else If CurPosY < MaxLines then
               Begin
                CurPOsX := 1;
                Inc(CurPosY);
               End;
             End;
          End;

     #8 : Begin { Backspace }
           If CurPosX > 1 then
            Begin
             Delete(MyText^[CurPosY],CurPosX-1,1);
             Dec(CurPosX);
             WrapTextBack;
            End
           Else If CurPOsY > 1 then
            Begin
             Delete(MyText^[CurPosY-1],MaxCol,1);
             CurPOsX := MaxCol;
             Dec(CurPosY);
             WrapTextBack;
            End;
          End;

  End;
 Until EndeOk;

 RestoreScreen;
 Sptr := OSptr;
 CurSorOff;
End;

Procedure Bar100( X, Y : Word; MaxNum, CurrNum : LongInt; Shadow : Boolean; Title : String );
{ ************************************************************************** }
{ ***    Aufgabe : Zeichnen eines "Fllstands"-Balkens mit 0-100%        *** }
{ ***    Einagbe : X, Y : Koordinaten der linken, oberen Ecke.           *** }
{ ***              MaxNum : (Maximaler Stand), CurrNum (Aktueller Stand) *** }
{ ***              Shadow : Mit Schatten ?                               *** }
{ ***    Ausgabe : Der Balken !                                          *** }
{ *** nderungen :                                                       *** }
{ ***    23.11.96 -> Diese Proc angelegt                                 *** }
{ ************************************************************************** }
Const
 BOX_WIDTH = 56;
 BOX_HEIGHT = 4;

Var
 TempLong1, TempLong2 : LongInt;
                Lauf1 : Word;

Begin
 If CurrNum = 0 then
  Begin
   If Shadow then PaintBoxShadow(X,Y,X+BOX_WIDTH,Y+BOX_HEIGHT) else
                  PaintBox(X,Y,X+BOX_WIDTH,Y+BOX_HEIGHT);
   GotoXY(X+3,Y); Write('< ',Title,' >');
  End;
 Inc(X); Inc(Y);                                 { Die Orginal-X/Y Werte werden nicht mehr bentigt. }

 If CurrNum = 0 then
  Begin
   GotoXY(X+2,Y+1);                     Write('0%');  { Die Przent-Angaben an der Achse anbringen }
   GotoXY(X+BOX_WIDTH-6,Y+1);           Write('100%');
  End;
 { Normalerweise ist X1/X2 * 100 die Prozentangebe. Da ich aber mit Integer-Werten rechne ist X1*100 /  X2 richtig. }

 TempLong1 := CurrNum * 100;
 TempLong2 := TempLong1 div MAxNum;

 GotoXY(X+(BOX_WIDTH div 2)- ( 4 { Lnge des Strings } ),Y+2);
 Write('(',TempLong2:3,'%)');

 ColorLo;
 GotoXY(X+2,Y);
 For Lauf1 := 1 to 50 do
  Begin
   If Lauf1 <= (TempLong2 div 2) then ColorHi else ColorLo;
   If Lauf1 = 1  then Write('') else
   If Lauf1 = 50 then Write('') else
   If Lauf1 mod 5 = 0 then
    Begin
     If Lauf1 mod 10 = 0 then
      Begin
       GotoXY(WhereX,WhereY + 1);
       ColorLo;
       Write(Lauf1 * 2,'%');
       If Lauf1 <= (TempLong2 div 2) then ColorHi;
       GotoXY(WhereX-3,WhereY -1);
      End;

     Write('')
    End else  Write('');  {}
{   If Lauf1 = 1  then Write('') else
   If Lauf1 = 50 then Write('') else
   If Lauf1 mod 5 = 0 then Write('') else  Write(''); {}
{   If Lauf1 = 1  then Write('') else
   If Lauf1 = 50 then Write('') else
   If Lauf1 mod 5 = 0 then Write('') else  Write(''); {}

  End;


End;


End.
