{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
UNit string_p;
interface
{$X+,O+,F+}

Uses dos,crt,StrType;


Var
      err_code : shortInt;
procedure Readstr(var InString: tStr50;PermittedChars: integer;insert_switch: boolean);


FUNCTION LString(s:tStr50;n:INTEGER):tStr50;
FUNCTION RString(s:tStr50;n:INTEGER):tStr50;
FUNCTION MString(s : tStr50; N,P : INTEGER) : tStr50;
FUNCTION PadLeft(s:tStr50;n:INTEGER):tStr50;
FUNCTION PadRight(s:tStr50;n:INTEGER):tStr50;
FUNCTION StripLeft(s:tStr50) : tStr50;
FUNCTION StripRight(s:tStr50) : tStr50;
FUNCTION StripBoth(s:tStr50) : tStr50;
FUNCTION Upper( S:tStr50) : tStr50;
FUNCTION Lower( S : tStr50 ) : tStr50;
FUNCTION LoCase( InChar : Char ) : Char;
FUNCTION Center( S : tStr50; Size : integer) : tStr50;
FUNCTION Words(S : tStr50 ): integer;
FUNCTION WordN( S : tStr50; Which: integer): tStr50;
FUNCTION DelWord(S: tStr50; Which: integer): tStr50;
FUNCTION Compare(Str1,Str2: tStr50): integer;
FUNCTION Find(S1,S2: tStr50): integer;
FUNCTION Reverse(S : tStr50): tStr50;
FUNCTION Replace( Target,OldStr,NewStr : tStr50 ) : tStr50;
FUNCTION Fill(N : integer; Chars : Char) : tStr50;
FUNCTION hex_str(hex: INTEGER) : tStr50;
FUNCTION hex_val(hex: tStr50) : INTEGER;
FUNCTION bin_str(bin: INTEGER) : tStr50;
FUNCTION SetBlanks(S : tStr50 ): tStr50;
Function FuncStr( X : Word ) : String;
Procedure ReadTimeHHMM( Var T1, T2 : Word );
Function ReadInteger( InNum, MinInt, MaxInt : Word ) : Word;
Function ReadByte( InNum, MinInt, MaxInt : Byte ) : Byte;

Function An( X, Y : Integer ) : Char;



{
 LString    : Liefert die N Zeichen, die am Linken Rand des Strings S stehen.
 RString    : Siehe LString, fr den Rechnten Rand.
 MString    : Gibt N Zeichen von der Position P an im String S zurck.

 PadLeft    : N Leerzeichen werden an die Linke Seite des Strings gehngt.
 PadRight   : Siehe PadLeft, nur an der rechten Seite.

 StripLeft  : Entfernt die jeweiligen Leerzeichen vom String S.
 StripRight : Entfernt die jeweiligen Leerzeichen vom String S.
 StripBoth  : Entfernt die jeweiligen Leerzeichen vom String S.

 Upper      : Setzt alle Zeichen in einem String als Grobuchstabe.

 Center     : Zentriert dem mit S bergegenen String fr eine Lnge mit Size

              zeichen.

 SetBlanks  : Lscht alle Zeichen die vor und hinter dem String kommen und
              entfernt alle Leerzeichen in dem String so, das die Wrter
              immer durch ein Zeichen getrennt sind.

 Words      : Zhlt alle Wrter in dem String.
 WordN      : Gibt das Nte Wort innerhalb des Strings zurck.
 DelWord    : Lscht das Nte Wort innerhalb des Strings.

 Compare    : Vergleicht zwei Strings miteinander und gibt das erste Zeichen
              an, bei dem die Mismatch aufgetreten ist. Wenn beide gleich
              sind, dann wird 0 zurckgegeben.

 Find       : Sucht S2 nach dem ersten Wort in S1 ab. Wenn erfolgreich, dann
              wird die Nummer des Wortes zurckgegeben. Wenn es nicht gefunden
              wurde, dann wird 0 zurckgegeben.

 Replace    : Ersetzt im String Target den OldStr mit NewStr und gibt
              des Ergebnis als Funktionsergebnis zurck.

 Hex_Str    : Gibt den Hexadezimalen Wert als Sting aus, der als Dezimalzahl
              als Argument bergeben wird.

 Hex_Val    : Gegenteil des Vorherigen.

 Bin_Str    : Gibt einen als INteger bergebenen Wert als Strin aus, in dem
              die Binrstruktur angezeigt wird.

 ReadStr : Liest einen String in den mit InputStr bergenene Variabele ein.
 ReadInteger : Liest eine Integer-Zahl zwischen MinInt und Maxint ein und gibt diese
                als Funktionsergebnis zurck.

 }



implementation


FUNCTION LString(s:tStr50;n:INTEGER):tStr50;
BEGIN
 LString := COPY(s,1,n)
END;

FUNCTION RString(s:tStr50;n:INTEGER):tStr50;
BEGIN
 RString := COPY(s,LENGTH(s)-PRED(n),n)
END;

FUNCTION MString(s : tStr50; N,P : INTEGER) : tStr50;
begin
 MString := Copy(S,P,N);
end;

FUNCTION PadLeft(s:tStr50;n:INTEGER):tStr50;
BEGIN
 WHILE LENGTH(s) < n DO
 s := ' ' + s;
 PadLeft := s
END;

FUNCTION PadRight(s:tStr50;n: INTEGER):tStr50;
BEGIN
 WHILE LENGTH(s) < n DO
   S := S + ' ';
   PadRight := s
END;



FUNCTION Strip(S : tStr50; How: char): tStr50;
var
   i : integer;
begin
   case How of
      'L': begin
              while S[1]=' ' do Delete(S,1,1);
           end;
      'T': begin
              i:=length(S);
              while S[i]=' ' do begin
                 Delete(S,i,1); i:=Pred(i);
              end;
           end;
      'B': begin
              while S[1]=' ' do Delete(S,1,1);
              if length(S)=0 then begin
                 Strip:=''; Exit;
              end;
              i:=length(S);
              while S[i]=' ' do begin
                 Delete(S,i,1); i:=Pred(i);
              end;
           end;
      else S:='';
   end; {case}
   Strip:=S;
end; {Strip}


FUNCTION StripLeft(s:tStr50) : tStr50;
begin
 StripLeft := Strip(S,'L');
end;

FUNCTION StripRight(s:tStr50) : tStr50;
begin
 StripRight := Strip(S,'R');
end;

FUNCTION StripBoth(s:tStr50) : tStr50;
begin
 StripBoth := Strip(S,'B');
end;



FUNCTION Upper( S : tStr50) : tStr50;
var
   i    : integer;
   temp : tStr50;
begin
   temp:='';
   for i:=1 to length(S) do
    begin
     IF S[I] = '' then S[i] := '';
     IF S[I] = '' then S[i] := '';
     IF S[I] = '' then S[i] := '';
     Temp := Temp + UpCase(S[i]);
    end;
   Upper:=temp;
end;

FUNCTION LoCase( InChar : Char ) : Char;
begin
   if InChar IN ['A'..'Z'] then
      LoCase := Chr(Ord(Inchar)+32)
   else
      LoCase := InChar;
end;


FUNCTION Lower( S : tStr50 ) : tStr50;
var i : integer;
begin
   for i := 1 to Length(S) do Lower[i] := LoCase(S[i]);
   Lower := S;
end;



FUNCTION CENTER( S : tStr50; Size : integer) : tStr50;
var i,j: integer;
begin
   S:=StripBoth(S);
   i:=Size div 2;
   if length(S)<=1 then j:=length(S)
   else j:=Length(S) div 2;
   i:=i-j;
   Center := PadLeft(S,I);
end; 



FUNCTION SetBlanks(S : tStr50 ): tStr50;
var
   i : integer;
begin
   S := Strip(S,'B');
   for i := 1 to length(S) do begin
     if S[i] = ' ' then while S[i+1] = ' ' do
       delete(S,i+1,1);
   end;
   SetBlanks := S;
end;



FUNCTION Words(S : tStr50 ): integer;
var i,
    num : integer;
begin
   S :=SetBlanks(S);
   if S = '' then begin
      Words:=0; Exit;
   end;
   S :=' '+ S ; num:=0;
   for i:=1 to length(S) do begin
      if S[i]=' ' then num:=Succ(num);
   end;
   Words:=num;
end;



FUNCTION WordN( S : tStr50; Which: integer): tStr50;
var
   i, j, num, Start, Finish : integer;
   temp : tStr50;
begin
   if S ='' then begin
      WordN:=''; Exit;
   end;
   num:=Words(S);
   if num=0 then begin
      WordN:=''; Exit;
   end;
   if (Which=0) or (Which>num) then begin
      WordN:=''; Exit;
   end;
   S := SetBlanks(S);
   S:=' '+S+' ';
   for i:=1 to Which do begin
      Start:=Pos(' ',S);
      Delete(S,Start,1);
      Finish:=Pos(' ',S);
   end;
   temp:='';
   for i:=Start to Finish-1 do temp:=temp+S[i];
   WordN:=temp;
end; 



FUNCTION DelWord(S: tStr50; Which: Integer): tStr50;
var
   i, num, Start, Finish  : integer;
   temp    : tStr50;
begin
   if S='' then begin
      DelWord:=S; Exit;
   end;
   num:=Words(S);
   if num=0 then begin
      DelWord:=S; Exit;
   end;
   Start := Pos(WordN(s,Which),s);
   Delete(s,Start,Length(WordN(S,Which)));
   DelWord := S;
end;


FUNCTION Compare(Str1,Str2: tStr50): integer;
var i : integer;
begin
   Compare:=0; i:=0;
   if Str1=Str2 then Exit
   else repeat
      i:=Succ(i);
   until Str1[i]<>Str2[i];
   Compare:=i;
end;


FUNCTION Find(S1,S2: tStr50): integer;
var i,j,k: integer;
begin
   Find:=0;
   if (S1='') or (S2='') then Exit;
   S1:=Strip(S1,'B'); S2:=Strip(S2,'B');
   S2:=' '+S2;
   i:=Pos(S1,S2);
   if i=0 then Exit;
   k:=0;
   repeat
      j:=Pos(' ',S2);
      if j=0 then Exit;
      k:=Succ(k); S2[j]:='#';
   until j=i-1;
   Find:=k;
end; {Find}


FUNCTION Reverse(S : tStr50): tStr50;
var i: integer;
   Temp: tStr50;
begin
   S:=Strip(S,'B'); temp:='';
   if S='' then Reverse:=S
   else for i:=length(S) downto 1 do Temp:=Temp+S[i];
   Reverse:=Temp;
end; 


FUNCTION Replace( Target,OldStr,NewStr : tStr50 ) : tStr50;

var
  TarLen,OldLen,IncLen,Indx : Integer;
  Trans : tStr50;
begin
  Trans := Target;
  TarLen := Length(TRANS);
  OldLen := Length(OldStr);
  IncLen := Length(NewStr) - OldLen;
  Indx := Pos(OldStr,TRANS);
  while Indx > 0 do begin
    if TarLen + IncLen <= 255 then begin
      Delete(TRANS,Indx,OldLen);
      Insert(NewStr,TRANS,Indx);
      TarLen := TarLen + IncLen;
      Indx := Pos(OldStr,TRANS)
    end
    else Indx := 0
  end;
 Replace := Trans;
end;

FUNCTION Fill(N : integer; Chars : Char) : tStr50;
var i : integer;
begin
  for i := 1 to n do
  fill[i] := Chars;
end;


FUNCTION hex_str(hex: INTEGER) : tStr50;
VAR
  hex_out: tStr50;
  hex_temp: INTEGER;
  hex_mas: tStr50;
BEGIN
  hex_mas := '0123456789ABCDEF';
  hex_out := '';
  WHILE hex > 0 DO begin
    hex_temp := hex AND 15;
    hex_out := hex_mas[hex_temp+1] + hex_out;
    hex := hex DIV 16;
  END;
  FOR hex_temp := 1 to 2 DO begin
    IF length(hex_out) < 2 then hex_out := '0' + hex_out;
  END;
  hex_str := hex_out;
END;

FUNCTION hex_val(hex: tStr50) : INTEGER;
VAR
  hex_out: INTEGER;
  hex_temp: INTEGER;
  hex_mas: tStr50;
BEGIN
  hex_mas := '0123456789ABCDEF';
  hex_out := 0;
  WHILE length(hex) > 0 DO begin
    hex_temp := Pos(hex[1],hex_mas);
    hex_out := hex_out * 16 + (hex_temp)-1;
    hex := copy(hex,2,255);
  END;
  hex_val := hex_out;
END;

FUNCTION bin_str(bin: INTEGER) : tStr50;
VAR
  bin_out: tStr50;
  bin_temp: INTEGER;
BEGIN
  bin_out := '';
  WHILE bin <> 0 DO begin
    bin_temp := bin AND 1;
    IF bin_temp = 1 THEN
       bin_out := '1' + bin_out
    ELSE
       bin_out := '0' + bin_out;

    bin := bin shr 1;
  END;
  bin_str := bin_out;
END;
Procedure Readstr(var InString: tStr50; PermittedChars:integer; insert_switch: boolean);
{ Mehr auf diese Proc aufpassen ! }
const
 RETURN=#13;
var
 NumberCharsInput : integer; {how many letters so far}
 CursorPosition    : byte; {where cursor is starting with 1}
 startx,starty      : Byte; {screen position of first letter
                                  in InString}
 Eingabe          : char; {input Eingabe}
 tempx      : Byte;
 SaveStr : tStr50;
begin
 If PermittedChars > Sizeof(InString) - 1 then PermittedChars := Sizeof(InString)-1;

 NumberCharsInput := Length(InString);

 CursorPosition:=1;
 Startx:=WhereX;
 Starty:=WhereY;
 SaveStr := InString;
 Write(InString);
 GotoXY(StartX,StartY);

 Repeat
  Eingabe:=Readkey; {input Eingabe}
  Case Eingabe of
   #0 : begin
         Eingabe:=Readkey;
         Case  Eingabe of
          #79 : Begin
                 CursorPosition := NumberCharsInput + 1;
                 GotoXY(StartX+CursorPosition-1,Starty);
                End;
          #75 : If (CursorPosition > 1) then
                 Begin     {cursor_left}
                  GotoXY(WhereX-1,WhereY);
                  Dec(CursorPosition);
                 end;
          #77 : If ((CursorPosition <= NumberCharsInput) and (CursorPosition < PermittedChars)) then
                 begin {cursor_right}
                  GotoXY(WhereX+1,WhereY);
                  Inc(CursorPosition);
                 end;
          #82 : insert_switch:= not(insert_switch); {toggle insert}
          #83 : If ((CursorPosition <= NumberCharsInput)and (InString<>'')) then
                 begin { delete}
                  Dec(NumberCharsInput);
                  Delete(InString,CurSorPosition,1);
                  Tempx:=Wherex;
                  Gotoxy(startx,starty);
                  Write(InString);
                  Write(' ');
                  Gotoxy(Tempx,Wherey);
                 end;

         end;
        end;
  #27 : begin
         Eingabe := RETURN;
         InString := SaveStr;
        End;
   #8 : If CursorPosition>1 then
         begin
          Tempx:=Wherex;
          Gotoxy(startx,starty);

          Delete(InString,CurSorPosition-1,1);
          Dec(CurSorPOsition);
          Dec(NumberCharsInput);

          Write(InString);
          Write(' ');
          GotoXY(TempX-1,WhereY);
         End;
#32..'~',#128..#165:
         Begin
          If (not(insert_switch)) then
           begin
            If (Cursorposition < PermittedChars) then
             Begin
              TempX := WhereX;
              GotoXY(StartX,StartY);
              InSert(Eingabe,InString,CurSorPosition);
              Write(InString);
              Inc(CurSorPosition);
              Inc(NumberCharsInput);
              GotoXY(TempX+1,WhereY);
             End;
           end
          Else if (insert_switch) and (CursorPosition < PermittedChars) then
           begin { Overwrite }
            If Cursorposition < NumberCharsInput then
             Begin
              InString[CurSorPosition] := Eingabe;
              Inc(CurSorPosition);
              TempX := WhereX;
              GotoXY(StartX,StartY);
              Write(InString);
              GotoXY(TempX+1,WhereY);
             End
            Else
             Begin
              InString := InString + Eingabe;
              Inc(NumberCharsInput);
              Inc(CursorPosition);
              TempX := WhereX;
              GotoXY(StartX,StartY);
              Write(InString);
              GotoXY(TempX+1,WhereY);
             End;
           End;
         End;

       end{case Eingabe};
  until Eingabe=RETURN;
 If Eingabe = Return then err_code := 0;
end;



Procedure InvokeCursor(StartScan,StopScan:integer);
Const
  VideoIO     = $10;
  CursorShape =   1;
Var
  Regs : Registers;
begin
  With Regs do
    begin
      CH:=StartScan;
      CL:=StopScan;
      AH:=CursorShape;
      Intr(VideoIO,Regs);
    end;
end;



Procedure ReadTimeHHMM( Var T1, T2 : Word );
Var
      SaveX, SaveY : Word;
           InputOk : Boolean;
            TmpStr : tStr50;
      Lauf1, Lauf2 : Word;
  HString, MString : String[2];
Begin
 InputOk := FALSE;
 SaveX := WhereX; SaveY := WhereY;
 Repeat
  ReadStr(TmpStr,6,TRUE);
  If (Length(TmpStr) = 5) and (TmpStr[3] = ':') then
   Begin
    HString := Copy(TmpStr,1,2);
    MString := Copy(TmpStr,4,2);
    Val(HString,T1,Lauf1);
    Val(MString,T2,Lauf2);
    If (Lauf2 = 0) and (Lauf1 = 0) and (T1 >= 0) and (T1 <= 23) and (T2 >= 0) and (T2 <= 59) then InputOK := TRUE;
   End;

  If InputOk = FALSE then
   Begin
    GotoXY(SaveX,SaveY);
    For Lauf1 := 1 to Length(TmpStr) do Write(' ');
    GotoXY(SaveX,SaveY);
   End;
 Until InputOk;
End;

Function An( X, Y : Integer ) : Char;
Begin
 GotoXY(X-1,Y);
 An := #0;
End;

Function ReadInteger( InNum, MinInt, MaxInt : Word ) : Word;
Var
       TmpStr : tStr50;
         Code : Word;
      InputOk : Boolean;
 SaveX, SaveY : Word;
        Lauf1 : Word;
Begin
 SaveX := WhereX; SaveY := WhereY;
 InputOk := FALSE;
 TmpStr := '';

 Repeat
  GotoXY(SaveX,SaveY);
  For Lauf1 := 1 to 8 do Write(' ');
  GotoXY(SaveX,SaveY);
  Str(InNum,TmpStr);
  ReadStr(TmpStr,Length(FuncStr(MaxInt))+1,TRUE);
  Val(TmpStr,Lauf1,Code);
  If (Code = 0) and (Lauf1 >= MinInt) and (Lauf1 <= MaxInt) then InputOK := TRUE else
   Begin
    Sound(220);
    Delay(100);
    NoSOund;
   End;
 Until InputOk;
 ReadInteger := Lauf1;
End;


Function ReadByte( InNum, MinInt, MaxInt : Byte ) : Byte;
Var
       TmpStr : tStr50;
         Code : Word;
      InputOk : Boolean;
 SaveX, SaveY : Word;
        Lauf1 : Word;
Begin
 SaveX := WhereX; SaveY := WhereY;
 InputOk := FALSE;
 TmpStr := '';

 Repeat
  GotoXY(SaveX,SaveY);
  For Lauf1 := 1 to 8 do Write(' ');
  GotoXY(SaveX,SaveY);
  Str(InNum,TmpStr);
  ReadStr(TmpStr,Length(FuncStr(MaxInt))+1,TRUE);
  Val(TmpStr,Lauf1,Code);
  If (Code = 0) and (Lauf1 >= MinInt) and (Lauf1 <= MaxInt) then InputOK := TRUE else
   Begin
    Sound(220);
    Delay(100);
    NoSOund;
   End;
 Until InputOk;
 ReadByte := Lauf1;
End;

Function FuncStr( X : Word ) : String;
Var
 TmpStr : string;
Begin
 Str(X,TmpStr);
 FuncStr := TmpStr;
End;



end.
