{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
{ **************************************************************************
  Diese Unit beinhaltet die Funktionen und Porzeduren, die vom
  Hauptprogramm fr das Belegen von Speicher verwendet werden .
  (Ich knnte es auch in eine Unit verwandeln)
  ************************************************************************** }
Unit MemUse;
INTERFACE
Uses Memory;

Type
 pMemData = ^tMemData;
 tMemData = Record
           pNext : pMemData;
            Size : Word;
        DataType : Word;
             Case MemType : Byte of
                MEMPAS : ( PasPointer : Pointer ); { Bei Speicher auf dem Pascal-Heap ist es genauso }
                MEMXMS : (  XMSHandle : Word    ); { Beim XMS wird ein Handle vergeben. }
                MEMEMS : (  EMSHANDLE : Word    ); { So auch bei EMS. }
                 FALSE : ( HandleForBoth : Word ); { Das Handle fr XMS und EMS }
                { Es ist wichtig das das XMS und das EMS-Handle an der gleichen Stelle
                  wie das "HandleForBoth" stehen. }
            End;

Const
        SavedVideoInMem : pMemData = NIL;        { Enthlt Informationen ber das Video-Bild im Speicher }


Function AppendMemItem( Data : pMemData ) : pMemData; { Diese Funktion legt einen neuen Speicherverwaltungsblock an. }
Procedure KillMemBlocks( Var DataPointer : pMemData );{ Diese Funktion vernichtet alle Speicherverwaltungsblcke }


IMPLEMENTATION

Function AppendMemItem( Data : pMemData ) : pMemData;
Begin
 While (Data <> NIL) and (Data^.pNext <> NIL) do Data := Data^.pNext;

 If Data <> NIL then
  Begin
   GetMem(Data^.pNext,SizeOf(tMemData));
   FillChar(Data^.pNext^,SizeOf(tMemData),0);
   AppendMemItem := Data^.pNext;
  End
 Else
  Begin
   GetMem(Data,SizeOf(tMemData));
   FillChar(Data^,SizeOf(tMemData),0);
   AppendMemItem := Data;
  End;
End;

Procedure KillMemBlocks( Var DataPointer : pMemData );
Var
 Tmppt : pMemData;
Begin
 While DataPointer <> Nil do
  Begin
   Tmppt := DataPointer^.pNext;

   With DataPointer^ do
    If Size <> 0 then FreeUpperMEM[MemType](HandleForBoth);

   FreeMem(DataPointer,SizeOf(tMemData));
   DataPointer := Tmppt;
  End;
End;

End.