{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
; Gendert : "Indos" auch ins Turbo-DS
; Auf passives TSR umgestellt

DATA   segment word public        ;Turbo-Datensegment


DATA       ends                   ;Ende des Datensegments

;== Konstanten =========================================================

I2F_FKT_0  equ 0AAh               ;Code fr INT 2F, Funktion 0 Inst-Check
I2F_FKT_1  equ 0BBh               ;Code fr INT 2F, Funktion 1
I2F_FKT_2 equ 0CCh

TIME_OUT   equ 9                 ;Time-Out fr Aktivierung in Ticks
MYINSTCODE equ 3                 ; Code 3 For Ethernet II

;== Programm ===========================================================

CODE       segment byte public    ;das Turbo-Codesegment

           assume cs:CODE, ds:DATA

;-- Public-Deklarationen interner Funktionen ---------------------------

public     tsrinit                ;ermglicht Aufruf aus Turbo-Programm
public     TsrIsInst
public     TSRUNinst
public     TsrCanuninst
public     TsrSetPtr
public     tsrcall


tsraktiv db 0
;-- Variablen fr die Interrupt-Handler --------------------------------
;-- (nur ber das Codesegment zugnglich) ------------------------------

call_ptr   equ this dword
call_ofs   dw 0                   ;Offsetadresse fr TSRCall
call_seg   dw 0                   ;Segmentadresse noch nicht initial.


ds_save    dw 0                   ;Sichern von DS whrend TSR-Call
rptr_save  equ this dword         ;FAR-Pointer fr Rckehr aus TSR-CALL
rip_save   dw 0                   ;Sichern der Rcksprungadresse bei
rcs_save   dw 0                   ;TSR-Call
ret_ax     dw 0                   ;Sichern des Funktionsergebnisses bei
ret_dx     dw 0                   ;TsrCall

;-- Variablen, die zur Aktivierung des Turbo-Prg. bentigt werden ------
                                                                        
t_ss       dw 0                   ;Turbo-Stacksegment
t_sp       dw 0                   ;Turbo-Stackpointer
t_ds       dw 0                   ;Turbo-Datensegment
t_es       dw 0                   ;Turbo-Extrasegment

t_psp      dw 0                   ;Segmentadresse des PSP des Turbo-Prg.

;-- Variablen, zum Test auf die Bettigung des Hotkey ------------------

i2F_code   db 0                   ;Funktionsnummer fr INT 2F

;-- Variablen fr die TSR-Aktivierung ----------------------------------

;-- die folgenden Variablen nehmen die alten Adressen der Interrupt- ---
;-- Handler auf, die durch neue Interrupt-Handler ersetzt wurden     ---

int2F_ptr  equ this dword         ;alter Interrupt-Vektor 2Fh
int2F_ofs  dw 0                   ;Offsetadresse des alten Handlers
int2F_seg  dw 0                   ;Segmentadresse des alten Handlers

;-- Variablen, die Informationen ber das unterbrochene Programm -------
;-- aufnehmen                                                    -------

uprg_ss    dw 0                   ;SS und SP des unterbrochenen Prg.
uprg_sp    dw 0

;-----------------------------------------------------------------------
;-- tsrinit: beendet das Turbo-Programm und aktiviert die neuen  -------
;--          Interrupt-Handler
;-- Aufruf von Turbo: procdure tsrinit( PrzPtr   : word; PrzPtr2 : Word
;--                                     ResPara  : word );

tsrinit    proc    near

sframe0    struc                  ;Struktur zum Zugriff auf den Stack
bp0        dw ?                   ;nimmt BP auf
ret_adr0   dw ?                   ;Rcksprungadresse
respara0   dw ?                   ;Anzahl zu reservierender Paragraphen
przptr0    dd ?                   ;Offset der Turbo-TSR-Prozedur
sframe0    ends                   ;Ende der Struktur

frame      equ [ bp - bp0 ]

           push bp                ;BP auf dem Stack sichern
           mov  bp,sp             ;SP nach BP bertragen
           push es                ;ES auf dem Stack sichern

           ;-- die Turbo-Segmentregister sichern -----------------------

           mov  t_ss,ss           ;die Register in den entsprechenden
           mov  t_sp,sp           ;Variablen merken
           mov  t_es,es
           mov  t_ds,ds


           mov  bx,cs             ;CS nach BX trasferieren
           sub  bx,10h            ;10h Paragraphen = 256 Byte abziehen
           mov  t_psp,bx          ;Segmentadresse merken
           ;-- Adresse des INDOS-Flags ermitteln -----------------------
           mov ax, word ptr przptr0
           mov bx, word ptr przptr0 + 2;
;           mov word ptr pasProc, ax
;           mov word ptr PasProc+2, bx


           mov  ah,34h            ;Fkt.nr.: Adresse INDOS-Flag holen
           int  21h               ;DOS-Interrupt aufrufen
           push ds
           mov ds, t_ds
           pop ds
                                                                        
           ;-- die Adressen der umzuleitenden Interrupt-Handler holen --
                                                                        
           mov  ax,352Fh          ;Interrupt-Vektor 2Fh holen
           int  21h               ;DOS-Interrupt aufrufen
           mov  int2F_ofs,bx      ;Adresse des Handlers in den ent-
           mov  int2F_seg,es      ;sprechenden Variablen merken


           ;-- die neuen Interrupt-Handler installieren ----------------

           push ds                ;Datensegment merken
           mov  ax,cs             ;CS nach AX und dann nach DS laden
           mov  ds,ax
                                                                        
           mov  ax,252Fh          ;Fkt.nr.: Interrupt 2Fh setzen
           mov  dx,offset int2F   ;DS:DX nimmt Adresse des Handler auf
           int  21h               ;DOS-Interrupt aufrufen

           pop  ds                ;DS wieder vom Stack kholen
                                                                        
           ;-- Programm resident beenden -------------------------------
                                                                        
           mov  ax,3100h          ;Fkt.nr.: Programm resident beenden
           mov  dx,frame.respara0 ;Anzahl der reservierten Para. holen
           int  21h               ;DOS-Interrupt aufrufen und damit das
                                  ;Programm beenden
                                                                        
tsrinit  endp
                                                                        
;-----------------------------------------------------------------------
;-- TsrIsInst: stellt fest, ob das Programm bereits installiert ist ----
;-- Aufruf von Turbo: function TsrIsInst( i2f_fktnr : byte ) : boolean;
;-- Return-Wert : TRUE, wenn das Programm bereits installiert war,
;--               sonst FALSE

TsrIsInst  proc    near
                                                                        
sframe2    struc                  ;Struktur zum Zugriff auf den Stack
bp2        dw ?                   ;nimmt BP auf
ret_adr2   dw ?                   ;Rcksprungadresse
i2F_code2  dw ?                   ;Funktionsnummer fr INT 2F
sframe2    ends                   ;Ende der Struktur

frame      equ [ bp - bp2 ]

           push bp                ;BP auf dem Stack sichern
           mov  bp,sp             ;SP nach BP bertragen

           mov  ah,byte ptr frame.i2F_code2 ;Fktnr. fr INT 2F
           mov  i2F_code,ah                 ;und sichern
           mov  al,I2F_FKT_0                ;Unterfktnr.
           mov bx, MYINSTCODE
           int  2Fh
           cmp bx, 0FFh
           mov ax, 0
           jne isi_end

           ;-- Segmentadresse der bereits installierten Kopie ermitteln
           mov  ah,i2f_code       ;Nein, Segmentadresse ber INT 2Fh
           mov  al,I2F_FKT_1      ;Unterfunktion 01h laden
           mov bx, MYINSTCODE
           int  2Fh
           mov  call_seg,ax       ;und in Variablen merken
           mov  ax,-1             ;ist installiert

isi_end:   pop  bp                ;BP wieder vom Stack
           ret  2                 ;zurck und Argumente vom Stack

TsrIsInst  endp                   ;Ende der Prozedur

;-----------------------------------------------------------------------
;-- TSRCANUNIST: Feststellen, ob installierte Kopie des TSR wieder -----
;--              Deinstalliert werden kann
;-- Aufruf von Turbo : function TsrCanuninst : boolean;
;-- Ausgabe          : TRUE, wenn Reinstallation mglich, sonst FALSE
;-- Info             : Das Programm kann nur Deinstalliert werden, wenn
;--                    keiner der Interrupt-Vektoren des Programms in
;--                    der Zwischenzeit auf ein anderes Programm um-
;--                    geleitet wurde.

tsrlist    db  2Fh,00h ;Liste der umgeleiteten INT
                                   ;00h markiert Ende
TsrCanuninst  proc  near

           mov  dx,call_seg         ;Segment der install. Kopie laden
           mov  di,offset tsrlist-1 ;DI auf Liste

tcu_1:     inc  di                ;DI auf die nchste Intr-Nummer
           mov  al,cs:[di]        ;nchste Intr-Nummer nach AL
           or   al,al             ;Ende der Liste erreicht?
           je   tcu_ok            ;Ja, alle Vektoren ok

           mov  ah,35h            ;Fktnr. fr "Get Interrupt"
           int  21h               ;DOS-Interrupt aufrufen
           mov  cx,es             ;ES zum Vergleich nach CX
           cmp  dx,cx             ;noch im gleichen Segment?
           je   tcu_1             ;Ja, keine Reinstallation mglich

           xor  ax,ax             ;Nein, keine Reinstallation mglich
           ret

tcu_ok:    mov  ax,-1
           ret

TsrCanuninst endp

;-----------------------------------------------------------------------
;-- TSRUNinst: Deinstalliert das TSR-Programm und gibt den allokierten -
;--            Speicher wieder frei.
;-- Aufruf von Turbo : procedure TSRUNinst;
;-- Info             : Diese Routine darf nur nach einem vorhergehenen
;--                    und erfolgreichen Aufruf von TsrCanuninst()
;--                    aufgerufen werden

TSRUNinst  proc  near

           push ds
           mov  es,call_seg       ;Segment des installierten TSR laden


           ;-- die Interrupt-Handler der TSR-Programm wieder -----------
           ;-- reinstallieren                                -----------

           cli                    ;keine Interrupts mehr zulassen

           mov  ax,252Fh          ;Fkt.nr: Handler fr INT 2F setzen
           mov  ds,es:int2F_seg   ;Segmentadresse des alten Handler
           mov  dx,es:int2F_ofs   ;Offsetadresse des alten Handler
           int  21h               ;den alten Handler wieder installieren

           ;-- Speicher wieder freigeben -------------------------------

           sti                    ;Interrupts wieder erlauben
           mov  es,es:t_psp       ;Segadr. des PSP des TSR-Programm
           mov  cx,es             ;in CX merken
           mov  es,es:[ 02ch ]    ;Segadr. des Environment aus PSP holen
           mov  ah,49h            ;Fkt.nr.: allok. Speicher freigeben
           int  21h               ;DOS-Interrupt aufrufen

           mov  es,cx             ;ES aus CX zurckholen
           mov  ah,49h            ;Fkt.nr.: allok. Speicher freigeben
           int  21h               ;DOS-Interrupt aufrufen

           pop  ds                ;DS und BP wieder vom Stack holen
           ret                    ;zurck zum Aufrufer

TSRUNinst  endp                   ;Ende der Prozedur
                                                                        
;-----------------------------------------------------------------------
;-- TsrSetPtr: Speichert die Adresse der Routine, die bei einem nach- --
;--            folgenden Aufruf von TSRCALL aufgerufen werden soll
;-- Aufruf von Turbo: procedure TsrSetPtr( offset : word );

TsrSetPtr  proc    near

sframe3    struc                  ;Struktur zum Zugriff auf den Stack
bp3        dw ?                   ;nimmt BP auf
ret_adr3   dw ?                   ;Rcksprungadresse
offset3    dw ?                   ;Offset der aufzurufenden Routine
sframe3    ends                   ;Ende der Struktur

frame      equ [ bp - bp3 ]

           push bp                ;BP auf dem Stack sichern
           mov  bp,sp             ;SP nach BP bertragen

           mov  ax,frame.offset3  ;Offsetadresse nach AX
           mov  call_ofs,ax       ;und speichern

           pop  bp                ;BP wieder vom Stack
           ret  2                 ;zurck und Argumente vom Stack

TsrSetPtr  endp                   ;Ende der Prozedur

;-----------------------------------------------------------------------
;-- TSRCALL: Ruft eine Routine in der zuvor installierten Kopie des ----
;--          TSR-Programms auf.
;-- Aufruf von Turbo : procedure TsrCall;
;-- Achtung          : - Der Stack wird in dieser Routine ganz bewut
;--                      nicht verndert, damit Parameter an die auf-
;--                      zurufenden Prozedur oder Funktion bergeben
;--                      werden knnen.
;--                    - Diese Prozedur mu FAR sein, weil sie von Turbo
;--                      aus ber einen Prozedur-Zeiger aufgerufen wird.

tsrcall    proc far

           ;-- Kontextwechsel zum Turbo-Programm durchfhren und die ---
           ;-- angegebene Prozedur aufrufen
                                                                        
           pop  rip_save          ;Rcksprungadresse vom Stack und
           pop  rcs_save          ;merken
           mov  ds_save,ds        ;DS merken

           mov  es,call_seg       ;Segmentadresse des installierten TSR
                                  ;nach ES
           mov  ds,es:t_ds        ;Segment-Register fr das Turbo-
           mov  es,es:t_es        ;Programm setzen
                                                                        
           call [call_ptr]        ;die Turbo-Prozedur aufrufen
           mov  cs:ret_ax,ax      ;Funktionsergebnis merken
           mov  cs:ret_dx,dx
                                                                        
           ;-- Kontextwechsel zurck zum Turbo-Programm  ---------------
                                                                        
           mov  es,call_seg       ;ES und DS zurckholen
           mov  ds,ds_save        ;zurckholen

           mov  ax,cs:ret_ax      ;Funktionsergebnis zurckholen
           mov  dx,cs:ret_dx
           jmp  [rptr_save]       ;zurck zum Aufrufer

tsrcall    endp                   ;Ende der Prozedur
                                                                        


;-- der neue Interrupt 2Fh-Handler (Multiplexer) -----------------------

int2F      proc far

           cmp  ah,i2F_code       ;Aufruf fr dieses TSR?
           jne  i2F_end           ;Nein, zum alten Handler

           cmp  al,I2F_FKT_0      ;Ja, ist es Unterfunktion 00h?
           je   i2F_0             ;Ja, ausfhren

           cmp  al,I2F_FKT_1      ;Vielleicht Unterfunktion 01h?
           je   i2F_1             ;Ja, ausfhren

           cmp  al,I2F_FKT_2      ;Vielleicht Unterfunktion 01h?
           je   i2F_2             ;Ja, ausfhren

           iret                   ;Nein, Aufruf ignorieren

i2F_end:   ;-- TSR ist nicht gemeint, Aufruf weiterleiten --------------

           jmp  [int2F_ptr]       ;zum alten Handler

i2F_0:     ;-- Unterfunktion 00: Installations-Check -------------------

           cmp bx, MYINSTCODE
           Jne @AltenHandler
           mov bx, 0FFh
           iret                   ;zurck zum Aufrufer
           @AltenHandler:
           jmp [int2F_ptr]

i2F_1:     ;-- Unterfunktion 01: Segmentadresse zurckliefern ----------
           cmp bx, MYINSTCODE
           jne @altenhandler2
           mov  ax,cs             ;Segmentadresse nach AX
           mov  bx,t_ds
           iret                   ;zurck zum Aufrufer
           @altenhandler2:
           jmp [int2F_ptr]

i2F_2:
           jmp [int2F_ptr]

int2F      endp



;-----------------------------------------------------------------------

CODE       ends                   ;Ende des Codesegments
           end                    ;Ende des Programms

