{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
Unit ProgVars;
INTERFACE
Uses StrType,Dos,NetTypes;
Type

 pVideoProcess = ^tVideoProcess;
 tVideoProcess = Record
         ReturnBytes : Word;                     { Gibt die Anzahl der Bytes an, die }
             VIOMode : Word;                     { Der Video-Modus }
         Transmitted : LongInt;                  { Die lfd. Addresse dees letzten behandelten Bytes }
                 End;
{$I TypeCons}
{$I Commands}
{ **************************************************************************
  In dieser Unit werden wichtige Variabelen fr das Programm deklariert.
  Falls das Programm fertig sein sollte, sollte man der Sicherheit und des
  Umfangs wegen diese Unit auflsen.
  ************************************************************************** }

Const
 ERR_COULDNOTCREATESWAPDIR = 217;      { Swap-File-Verzeichnis konnte nicht angelegt werden }
       ERR_NODRIVERMANAGER = 218;      { Konnte keinen Treiber-Manager finden. }
     ERR_COULDNOTDEINSTALL = 219;      { Konnte das TSR-Programm nicht De-Installieren }
           Err_WrongBaseIO = 220;      { Falsche Basis-I/O-Addresse der SB-Karte }


                 DRV_NONE = 0;
           NOTINCLASSROOM = 0;
{ **************************************************************************
 Das Kommando fr meinen Int 2Fh-Handler das die Addresse der Dispatcher-Proc
 des Treiber/Daten-Managers zurckgibt.
  ************************************************************************** }
      CMD_GetProcAddress = $CC;

{$I CO_KEYS}
              WaitingTime = 3000;

    StandardClassRoomText = 'Undefiniert';

              BIOSDATASEG = $0040;               { Bios-Datensegment }
             FIRSTKBDBYTE = $1A;                 { Erstes Tastaturzeichen }
              LASTKBDBYTE = $1C;                 { Letztes Tastaturzeichen }
                KBDBUFFER = $1E;                 { Der Tastaturpuffer }

                   KB_MAX = 20;                  { Anzahl der Zeichen in dem Tastaturpuffer }


 TSR_NONEACTIVE           = 0;                   { Tsr ist nicht aktiv }
 TSR_MENUACTIVE           = 1;                   { Das Tsr-Men ist aktiv }
 TSR_INTERRUPT08ACTIVE    = 3;                   { Int 08 Handler wird abgearbeitet }

 PartsWithElapsing        = 2;                   { Anzahl der Elemente, die nicht bei jedem Zyklus bertragen werden sollen }
 Elapse_Palette           = 1;                   { Die Palette soll nicht bei jedem mal bertragen werden }
 Elapse_CharSet           = 2;

 SAVEDATAFOR_INTERRUPTED  = 1;                   { Die Bildschirmdaten fr das Capture sichern }
 SAVEDATAFOR_MENU         = 2;                   { Die Bildschirmdaten fr das Men sichern }

 LIS_NONE                 = 0;                   { Ich hre nicht zu }
 LIS_TEACHER              = 1;                   { Ich hre einem Teacher zu }
 LIS_STUDENT              = 2;                   { Ich hre einem Student zu }

 LIS_TEACHER_INIT         = 10;
 LIS_TEACHER_DEINIT       = 11;
 LIS_STUDENT_INIT         = 20;
 LIS_STUDENT_DEINIT       = 21;

 SEND_NONE                = 0;                   { Nichts zu senden ... }
 SEND_BROADCAST           = 1;                   { Ich Broadcaste ... }
 SEND_TOTEACHER           = 2;                   { Ich schicke Student-Pakete an einen Teacher der mir zuschaut}


 SENDPHASE_INITIALIZE     = 0;
 SENDPHASE_SYNCHRONIZE    = 1;                   { Die aktuelle Phase ist das Synchronisieren (Startzyklus-Paket)}
 SENDPHASE_STARTSCREEN    = 2;                   { Nun wird der Bilschirmheader bertragen }
 SENDPHASE_SCREENDATA     = 3;                   { Die Bildschirmdaten }
 SENDPHASE_PALETTEDATA    = 6;                   { und hier sind die Daten ! }
 SENDPHASE_CURSORDATA     = 9;                   { Und nun kommen die Cursor-Daten ber den Schirm }
 SENDPHASE_STOPMOUSE      = 12;                  { und das waren die Mausdaten ! }
 SENDPHASE_CHARSET        = 14;                  { Zeichensatz (so gendert) bertragen ... }
 SENDPHASE_DEINITALIZE    = 65534;               { Aufhren mit dem Senden ! }


Type UmschaltT = record
                   Name : string[6];             { Der Text im Parameter fr die jeweilige Umschalttaste }
                   Wert : word;                  { Der Scan-Wert dieser Taste }
                 end;



Const
     MaxUmschalt = 9;
{  UmschaltTasten : array[ 1..9 ] of UmschaltT =  { Das vordefinierte Array }
{                 ( ( Name: 'LSHIFT'; Wert : LSHIFT ),
                   ( Name: 'RSHIFT'; Wert : RSHIFT ),
                   ( Name: 'CTRL';   Wert : CTRL   ),
                   ( Name: 'ALT';    Wert : ALT    ),
                   ( Name: 'SYSREQ'; Wert : SYSREQ ),
                   ( Name: 'BREAK';  Wert : BREAK  ),
                   ( Name: 'NUM';    Wert : NUM    ),
                   ( Name: 'CAPS';   Wert : CAPS   ),
                   ( Name: 'INSERT'; Wert : INSERT )
                  ); }

 BIT_0  = 1;
 BIT_1  = 2;
 BIT_2  = 4;
 BIT_3  = 8;
 BIT_4  = 16;
 BIT_5  = 32;
 BIT_6  = 64;
 BIT_7  = 128;
 BIT_8  = 256;
 BIT_9  = 512;
 BIT_10 = 1024;
 BIT_11 = 2048;
 BIT_12 = 4096;
 BIT_13 = 8192;
 BIT_14 = 16384;
 BIT_15 = 32768;



 DATATYPE_MISC            = 255;
 DATATYPE_VIDEO           = 1;
 DATATYPE_CHARSET         = 2;
 DATATYPE_PALETTE         = 3;

 NOMODE                   = 0;
 MODE1                    = 1;
 MODE2                    = 2;


Const

{ ************************************************************************** }
{ *** Systemnahe Variabelen                                              *** }
{ ************************************************************************** }
          OldInterrupts : pInterruptInfoStruct = NIL;     { Ein Zeiger auf eine Interrupt-Informations-Struktur }

{ ************************************************************************** }
{ *** Variablen fr das Pop-Up-Men und das TSR-Programm                 *** }
{ ************************************************************************** }

             ChangerKey : Byte = 0 or ALT;       { Welche Umschalt-Taste ? }
              EscapeKey : Byte = SC_ESC;         { Welche Taste mu zum Umschalter gedrckt werden, um raus aus dem Modus 2 ?}
               TsrAktiv : Byte = 0;              { Ist das Men des TSR-Programms gerade aktiv ? }

{ ************************************************************************** }
{ *** Variabelen, die zur Sicherung des Status des Rechners da sind      *** }
{ ************************************************************************** }

   MachieneAccessEnable : Boolean = FALSE;       { Wird TRUE wenn Manipulieren des anderen Rechners mglich ist. }
        DataSavedToDisk : Boolean = FALSE;
             SavingData : Boolean = FALSE;
          VideoIsToSave : Boolean = FALSE;       { Wird gesetzt, wenn der BildschirmInhalt noch gesichert werden mu }
           TransferMode : Byte = 0;

{ ************************************************************************** }
{ *** Variabelen, die den Benutzer der Maschiene definieren.             *** }
{ ************************************************************************** }
               UserName : tStr50 = 'Kein Name'; { Der selbstgewhlte Benutzername }

{ ************************************************************************** }
{ *** Variabelen, die Dateinamen beschreiben                             *** }
{ ************************************************************************** }
         TempMenFileName : ComStr = 'TEMPFILE.MEN'; { Die Datei mit dem gesicherten Bildschirm vor der Aktivierungs des Casts}
        TempScrnFileName : ComStr = 'TEMPFILE.SCR'; { Die Datei mit dem gesicherten Bildschirm vor der Aktivierungs des Mens}
            MenuFileName : ComStr = 'MENUDATA.DAT'; { Die Datei mit den Mendaten }
            MenuFileHelp : ComStr = 'MENUHELP.DAT'; { Die Datei mit den Menhilfedaten }
             OvrFileName : ComStr = 'LANTSR.OVR';   { Die Datei mit den Overlay-Daten }


{ ************************************************************************** }
{ *** Variabelen, die Aktionen beschreiben                               *** }
{ ************************************************************************** }
                 ListeningForPersons : Boolean = FALSE;
              ListeningForClassRooms : Boolean = FALSE;
  ListeningForEnterWorkGroupResponse : Boolean = FALSE;
          ListenForSpeechLabResponse : Boolean = FALSE;

{ ************************************************************************** }
{ *** Variabelen, die fr alle Transfer-Modi da sind                     *** }
{ ************************************************************************** }
            SendingData : Byte = 0;              { Enthlt den Status des Sendens (siehe SEND_*)}
       ListeningForData : Byte = 0;              { Enthlt den Status des Empfangens (siehe LIS_*) }

             TimeoutMax = 100;                   { Der Standard-Time-Out (maximal) }
         StationTimeOut : Word = 100;            { Enthlt die Zeit in 18.2 Ticks, die noch verstreichen darf bevor die }
                                                 { Verbindung automatisch abgebrochen wird ... }




{ ************************************************************************** }
{ *** Variabelen, die fr den Modus 1 (Teacher Broadcastet) da sind     **** }
{ ************************************************************************** }
       SendingTeacherID : pAddressChain = NIL;

{ ************************************************************************** }
{ *** Variabelen, die fr den Modus 2 (Teacher belauscht Student) da sind*** }
{ ************************************************************************** }
    ListeningTeacherID : pAddressChain = NIL;   { Enthlt die Netzwerkaddresse des zuhrenden Lehrers bzw. des }
                                                 { Schlers, der belauscht werden soll. }
     StudentComputerID : pAddressChain = NIL;

{ ************************************************************************** }
{ *** Variabelen fr die Classroom (Workgroup) - Verwaltung              *** }
{ ************************************************************************** }

      ManagerWorkGroup : pteacherClassRoom = NIL; { Standardmssig kein Klassenraum }
           MyWorkGroup : Word = NOTINCLASSROOM;   { Die WorkGroup, in der ich bin }

{ ************************************************************************** }

            HelpMeText : pTextString = NIL;
{              DataText : pTextString = NIL; }

          DataRecieved : Boolean = FALSE;

{ ************************************************************************** }
{ *** Systemnahe Variabelen                                              *** }
{ ************************************************************************** }

Var
           FirstKeyChar : Word absolute BIOSDATASEG:FIRSTKBDBYTE;
            LastKeyChar : Word absolute BIOSDATASEG:LASTKBDBYTE;

{ ************************************************************************** }
{ *** VESA - Variabelen                                                  *** }
{ ************************************************************************** }

          VesaSupported : Byte;
     VesaSupportedModes : Array[$100..$11B] of Boolean;

            BufModeAttr : Word;                  { Die Modus Informationen. Bitfeldcodiert. Siehe C't Juni 95 }
      BufWinGranularity : Word;                  { Die KB-Schrittweite von einem Fenster }
             BufWinSize : Word;                  { Die Grsse der Fenster }
          BufWinFuncPtr : Pointer;               { Der Zeiger auf die Fenster-Setz-Proc }
    BufBytesPerScanLine : Word;                  { Die Bytes pro Scan-Zeile }
          LastVideoMode : Word;                  { Der Letzte Video-Modus, der von dem Programm beobachtet wurde (Vorsicht !) }
        BufBitsPerPixel : Byte;
            BufBankSize : Byte;


Const
            WINDOW_READ = TRUE;
           WINDOW_WRITE = FALSE;

    SelectedWriteWindow : byte = 0;              { Die Nummer des Fensters (0/1), das zum Lesen / Schreiben ausgewhlt wurde }
     SelectedReadWindow : Byte = 0;
   SelectedWriteSegment : Word = 0;              { Das Segment des Fensters, das zum Lesen /Schreiben ausgewhlt wurde. }
    SelectedReadSegment : Word = 0;

       VesaModeInBuffer : Word = 0;              { Der Vesa-Modus, dessen Informationen im Puffer stehen }


{ ************************************************************************** }
{ *** Die Variablen zur Protokollverwaltung                              *** }
{ ************************************************************************** }

              MaxProtocol = 3;                   { Die Maximale anzahl an eingebundenen Protokollen }
          PrimaryProtocol : Byte = 1;            { Das Haupt-Protokoll, dem Vorrang gewhrt wird vor anderen Protokolltypen }
            ManagerLoaded : Boolean = FALSE;     { Ist der Protokoll-Manager geladen ? }
            DriversLoaded : Byte = 0;            { Die Anzahl an tatschlich geladenen Treibern }
                 UseProcs : Array[1..MaxProtocol] of Boolean =        { Soll das Protokoll berhaupt verwendet werden ? }
                            (FALSE,FALSE,FALSE);
                 DriverID : Array[1..MaxProtoCol] of Byte =           { Die geammelten Treiber-IDs }
                            (DRV_NONE,DRV_NONE,DRV_NONE);

Var

                  Drivers : Array[1..MaxProtoCol] of pRegisterDriver;

        DriverManagerProc : CallProc;            { Die Addresse des Treibermanagers }

{ ************************************************************************** }
{ *** Sound-Variablen                                                    *** }
{ ************************************************************************** }
               TimerCount : Word;                { Wird auf 0 heruntergezhlt um den alten Timer zu aktivieren }
           TimerCountFrom : Word;                { Die Zahl, die immer auf 0 herabgezhlt wird }

Const
              InSpeechLab : Boolean = FALSE;     { Bin ich im Sprachlabor-Moddus ? }
        SpeechLabListener : pAddressChain = NIL; { Sollen die Sprachlabor-Daten "kopiert" werden (+Sender) ? }

Var
              MyNetWorkID : tCompleteNetworkIDStruct; { Die eigenen Netzweraddressen zum schnellen Zugriff darauf }


Type
 { Die Informationstruktur fr einen einzelnen VESA-Modus }
 pVesaModeInfo = ^tVesaModeInfo;
 tVesaModeInfo = Record
                  ModeAttr : Word;
                   WinAttr : Array[1..2] of Byte;
            WinGranularity : Word;
                   WinSize : Word;
               WinSegments : Array[1..2] of Word;
                WinFuncPtr : Pointer;
          BytesPerScanLine : Word;
                XRes, YRes : Word;
      XCharSize, YCharSize : Byte;
            NumberOfPlanes : Byte;
              BitsPerPixel : Byte;
             NumberOfBanks : Byte;
               MemoryModel : Byte;
                  BankSize : Byte;
        NumberOfImagePages : Byte;
                 Reserved1 : Byte;
               RedMaskSize : Byte;
          RedFieldPosition : Byte;
              GeenMaskSize : Byte;
        GreenFieldPosition : Byte;
              BlueMaskSize : Byte;
         BlueFieldPosition : Byte;
              RsvdMaskSize : Byte;
         RsvdFieldPosition : Byte;
       DirectColorModeInfo : Byte;
                 Reserved2 : Array[1..216] of BYte;
                 End;

    pVesaInfo = ^tVesaInfo;
    tVesaInfo = Record
              VESASign : Array[0..3] of Char;
           VesaVersion : Word;
          OEMStringPtr : PChar;
          Capabilities : LongInt;
          VideoModePtr : Pointer;
           TotalMemory : Word;
              Reserved : Array[1..242] of Byte;
                End;



IMPLEMENTATION

End.