{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
UNIT SBDSP;
INTERFACE
{Uses ProgVars; }
{$I BITCONST}
VAR
  {-------------------------------------------------------------------------}
  { Basis-I/O-Adresse, Interrupt-Nummer und Nummer des DMA-Kanals aus der   }
  { BLASTER-Umgebungsvariablen in der AUTOEXEC.BAT-Datei                    }
  {-------------------------------------------------------------------------}
  SB_BaseAddress : Word;
       SB_Addr0A : Word;
       SB_Addr0C : Word;
       SB_Addr0E : Word;


Var
 CHIPTIMEOUT : Word;
Const
 ESTIMATINGTIME = 1000;
  {-------------------------------------------------------------------------}
  { DSP-Kommandos                                                           }
  {-------------------------------------------------------------------------}

  { direkte Ausgabe ungepackter Daten }

  dsp_WriteDirectUnpack = $10;

  { DMA-Ausgabe ungepackter Daten mit Referenzbyte }

  dsp_WriteDMAUnpackRef = $14;

  { DMA-Ausgabe 2-Bits-gepackter Daten ohne Referenzbyte }

  dsp_WriteDMA2BitPackNoRef = $16;

  { DMA-Ausgabe 2-Bits-gepackter Daten mit Referenzbyte }

  dsp_WriteDMA2BitPackRef = $17;

  { DMA-Ausgabe 4-Bits-gepackter Daten ohne Referenzbyte }

  dsp_WriteDMA4BitPackNoRef = $74;

  { DMA-Ausgabe 4-Bits-gepackter Daten mit Referenzbyte }

  dsp_WriteDMA4BitPackRef = $75;

  { DMA-Ausgabe 2,6-Bits-gepackter Daten ohne Referenzbyte }

  dsp_WriteDMA26BitPackNoRef = $76;

  { DMA-Ausgabe 2,6-Bits-gepackter Daten mit Referenzbyte }

  dsp_WriteDMA26BitPackRef = $77;

  { direkte Eingabe ungepackter Daten }

  dsp_ReadDirectUnpack = $20;

  { DMA-Eingabe ungepackter Daten }

  dsp_ReadDMAUnpack = $24;

  { Setzen der sog. Zeitkonstante (TC = TIME CONSTANT), }
  { wodurch die Sample-Frequenz bestimmt wird           }

  dsp_SetTC = $40;

  { Programmieren einer Ruheperiode }

  dsp_SetSilence = $80;

  { Unterbrechung der DMA-bertragung }

  dsp_HaltDMATransfer = $D0;

  { Einschalten des Lautsprechers }

  dsp_SpeakerOn = $D1;

  { Ausschalten des Lautsprechers }

  dsp_SpeakerOff = $D3;

  { Lesen des Lautsprecher-Status    }
  { 00h = Lautsprecher ausgeschaltet }
  { FFh = Lautsprecher eingeschaltet }

  dsp_SpeakerStatus = $D8;

  { Fortsetzung der DMA-bertragung }

  dsp_ContinueDMATransfer = $D4;

  { Programmierung der Sound Blaster Pro Erweiterungen }
  { (sehr schnelle Soundausgabe und -eingabe)          }

  dsp_SBProExtensions = $48;

  { sehr schnelle 8-Bits-Soundausgabe (nur SB Pro) }

  dps_HighSpeedDMAWrite = $91;

  { sehr schnelle 8-Bits-Soundeingabe (nur SB Pro) }

  dsp_HighSpeedDMARead = $99;


Function SoundInstalled : Boolean;
{===========================================================================}
{ Prozedur InitDSP: Initialisiert den DSP durch den Aufruf der Routine      }
{                   CheckBaseAddress aus SBDrv.                             }
{===========================================================================}
{ Eingabe: keine                                                            }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}

PROCEDURE InitDSP;

{===========================================================================}
{ Prozedur SetTimerFreq: Stellt eine Frequenz fr den Timer ein. Der Werte- }
{                        bereich liegt zwischen 19 und 50000 Hz.            }
{===========================================================================}
{ Eingabe: Freq = Timer-Frequenz in Hz (19..50000)                          }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}

PROCEDURE SetTimerFreq(Freq : Word);
{ Die Timer-Fequenz direkt setzten. }


{===========================================================================}
{ Prozedur SetOrigFreq: Stellt die Original-Frequenz des Timer von 18,2 Hz  }
{                       ein.                                                }
{===========================================================================}
{ Eingabe: keine                                                            }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}
Function ReadDirect : Byte;
PROCEDURE SetOrigFreq;

{===========================================================================}
{ Prozedur WriteDSP: Sendet einen Bytewert an den Soundprozessor. Ist die-  }
{                    ser mit seiner letzten Aktion beschftigt, mu beim    }
{                    Senden des Bytewertes gewartet werden, bis diese Ak-   }
{                    tion ordungsgem beendet ist.                         }
{===========================================================================}
{ Eingabe: Value = Bytewert                                                 }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}

PROCEDURE WriteDSP(Value : Byte);

{===========================================================================}
{ Prozedur WriteDirect: Veranlat den DSP zur Ausgabe von ungepackten       }
{                       Sounddaten im Direktmodus.                          }
{                                                                           }
{                       HINWEIS: Um eine gute VOICE-Ausgabe mit Hilfe die-  }
{                                ser Prozedur zu erreichen, kann man den    }
{                                Timer-Interrupt verwenden. Dabei mu man   }
{                                aber beachten, da dieser umprogrammiert   }
{                                werden mu, um eine hhere Ausgabe-Freq.   }
{                                als 18,2 mal in der Sekunde zu erreichen.  }
{===========================================================================}
{ Eingabe: Value = Bytewert                                                 }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}

PROCEDURE WriteDirect(Value : Byte);

{===========================================================================}
{ Prozedur Speaker_On: Schaltet den Lautsprecher an.                        }
{===========================================================================}
{ Eingabe: keine                                                            }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}

PROCEDURE Speaker_On;

{===========================================================================}
{ Prozedur Speaker_Off: Schaltet den Lautsprecher aus.                      }
{===========================================================================}
{ Eingabe: keine                                                            }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}

PROCEDURE Speaker_Off;

FUNCTION ReadDSP : Byte;

PROCEDURE CheckBaseAddress;

Function MyReadDirect : Byte;

Procedure MyWriteDirect( abc : Byte );

IMPLEMENTATION
USES CRT, DOS, WritePro;                                { CRT- und DOS-Unit einbinden }

Var
 OldTimerValue : Word;
 OldInt : Pointer;
 StatusByte : Byte;


{---------------------------------------------------------------------------}
{ Implementation von modulexternen Routinen                                 }
{---------------------------------------------------------------------------}

PROCEDURE InitDSP;

BEGIN
 CheckBaseAddress;
END;

var
 test1,test2,test3, test4 : Word;

 MittelWertMessung1 : LongINt;
    MittelWertDauer : Word;


PROCEDURE SetTimerWord( TimeWord : Word);
BEGIN
  Port[$43] := $36;                                          { Steuerbefehl }
  Port[$40] := Lo(TimeWord);              { Low-Byte fr den Timer-Wert setzen }
  Port[$40] := Hi(TimeWord);             { High-Byte fr den Timer-Wert setzen }
END;



Procedure MyInt; Interrupt;
Begin
 Asm  { Dies hier in ASM codieren, da es auf Geschwindigkeit = Przise ankommt. }
  Mov Al, 11010010b
         {Binr = >11<>01<>0010<  (7,8) =   11 -> Read-Back fr Timer
                                  (5,4) =   01 -> Timer-Wert lesen
                              (0,1,2,3) = 0010 -> Kanal 0 lesen. }
  Out $43, Al                          { $43 -> Control-Port }
  In Al, $40
  Mov Dl, Al
  In Al, $40
  Mov Dh, Al                                     { Messung 1 ist nun in DX gesichert. }
  { Messung 2. }
  Mov Al, 11010010b
  Out $43, Al                                    { $43 -> Control-Port }
  In Al, $40                                     { Es wird erst Lo, dann Hi gelesen. Darum Al nach AH und }
  Mov Cl, Al                                     { die Werte das swappen }
  In Al, $40
  Mov Ch, Al                                     { Messung 2 ist nun in CX gesichert. }
  Mov Al, 11010010b
  Out $43, Al                                    { $43 -> Control-Port }
  In Al, $40                                     { Es wird erst Lo, dann Hi gelesen. Darum Al nach AH und }
  Mov Bl, Al                                     { die Werte das swappen }
  In Al, $40
  Mov Bh, Al                                     { Messung 3 ist nun in CX gesichert. }

  Mov Al, 11010010b
  Out $43, Al                                    { $43 -> Control-Port }
  In Al, $40                                     { Es wird erst Lo, dann Hi gelesen. Darum Al nach AH und }
  Mov Ah, Al                                     { die Werte das swappen }
  In Al, $40
  Xchg Al, Ah                                    { und die beiden Tauschen. }

  Mov Test1, Dx
  Mov Test2, Cx
  Mov Test3, Bx
  Mov Test4, Ax
 End;
 If MittelWertMessung1 = 0 then
       MittelWertMessung1 := Test1 Else
       MittelWertMessung1 := (MittelWertMessung1 + Test1) shr 1;

 If MittelWertDauer = 0 then
   MittelWertDauer := Test1 - Test2 Else
   MittelWertDauer := (MittelWertDauer + (Test1 - Test2)) shr 1;

 MittelWertDauer := (MittelWertDauer + (Test2 - Test3)) shr 1;
 MittelWertDauer := (MittelWertDauer + (Test3 - Test4)) shr 1;

 Asm
  pushf
  call [oldint]
 End;
End;

Function EstimateTimerValue : Word;
Begin
 Port[$43] := 226;
 { 226 in Binr = >11<>10<>0010<  (7,8) =   11 -> Read-Back fr Timer
                                  (5,4) =   10 -> Status lesen
                              (0,1,2,3) = 0010 -> Kanal 0 lesen. }
 StatusByte := Port[$40];

 If statusByte AND BIT_0 <> 0 then
  Begin
   EstimateTimerValue := 0;                      { Timer-Wert kann nicht ermittelt werden, da im BCD-Modus }
   Exit;
  End;

 GetIntVec($08,OldInt);                          { Alles klar ? Dann los ! }
 SetIntVec($08,@MyInt);

 Delay(ESTIMATINGTIME);

 SetIntVec($08,OldInt);                          { Alles klar ? Dann los ! }

 EstimateTimerValue := MittelWertDauer + MittelWertMessung1;
End;

PROCEDURE SetTimerFreq(Freq : Word);

VAR
  Timer : LongInt;                          { interner Wert fr Timer-Frequenz }

BEGIN

  { Prfen, ob die angegebene Frequenz im Wertebereich zwischen }
  { 19 und 50000 Hz liegt. Falls nicht, korrigieren.            }
  OldTimerValue := EstimateTimerValue;

  IF Freq < 19 THEN
    Freq := 19;
  IF Freq > 50000 THEN
    Freq := 50000;

  Port[$43] := $36;                                          { Steuerbefehl }
  Timer := 1193180;
  Timer := Timer DIV Freq;   { internen Wert fr Timer-Frequenz berechnen }
  Port[$40] := Lo(Timer);              { Low-Byte fr den Timer-Wert setzen }
  Port[$40] := Hi(Timer);             { High-Byte fr den Timer-Wert setzen }
END;

PROCEDURE SetOrigFreq;
VAR
  Timer : Word;                          { interner Wert fr Timer-Frequenz }
BEGIN
  Port[$43] := $36;                                          { Steuerbefehl }
  Port[$40] := Lo(OldTimerValue);              { Low-Byte fr den Timer-Wert setzen }
  Port[$40] := Hi(OldTimerValue);             { High-Byte fr den Timer-Wert setzen }
END;
(*

PROCEDURE SetOrigFreq;
{VAR
  Timer : Word;                          { interner Wert fr Timer-Frequenz }
BEGIN
  Port[$43] := $36;                                          { Steuerbefehl }
{  Port[$40] := Lo(OldTimerValue);              { Low-Byte fr den Timer-Wert setzen }
{  Port[$40] := Hi(OldTimerValue);             { High-Byte fr den Timer-Wert setzen }
 Port[$40] := $FF;
 Port[$40] := $FF;
END;
*)
FUNCTION ReadDSP : Byte; Assembler;
{ ************************************************************************** }
{ ***    Einagbe :  ---                                                  *** }
{ ***    Ausgabe :  Das vom DSP gelesene Byte                            *** }
{ ***    Aufgabe :  Lesen eines Bytes aus dem SB-DSP                     *** }
{ *** nderungen :                                                       *** }
{ ***    22.11.96 -> Vollstndig in Assembler Codiert                    *** }
{ ************************************************************************** }
Asm
 Mov Bx, 0                                       { Bx -> Count }
 Mov Dx, Sb_Addr0E                               { SB_Addr + 0E -> Data Avail }

 @Anfang:
 Inc Bx
 In  Ax, Dx
 Cmp Ax, 127

 JA @ENDE

 Cmp Bx, 100
{ Jb @Anfang }

 @ENDE:


 Mov Dx, Sb_Addr0A
 In  Al, Dx
End;

PROCEDURE WriteDSP(Value : Byte);

VAR
  Count   : Word;                                              { ein Zhler }
  Writing : Boolean;       { TRUE, wenn der DSP zum Datenempfang bereit ist }

BEGIN
  Count := 0;
  Writing := FALSE;
  WHILE NOT Writing DO  { wiederholen, solange der DSP nicht empfangsbereit }
    BEGIN
      Inc(Count);                                          { Zhler erhhen }
      Writing :=                                      { DPS empfangsbereit? }
        (Port[SB_BaseAddress+$0C] AND $80) = $00;
      IF Count = 10000 THEN      { Hat der Zhler den Stand 10000 erreicht? }
        BEGIN             { ja, DSP kann nicht beschrieben werden -> Fehler }
         Writing := TRUE;
        END;
    END;
  Port[SB_BaseAddress+$0C] := Value;                    { schreiben zum DSP }
END;


PROCEDURE WriteDirect(Value : Byte);
BEGIN
  WriteDSP(dsp_WriteDirectUnpack);                    { DSP-Kommando senden }
  WriteDSP(Value);                                    { Wert zum DSP senden }
END;

Function ReadDirect : Byte;
BEGIN
  WriteDSP(dsp_ReadDirectUnpack);
  ReadDirect := ReadDSP;                                    { Wert zum DSP senden }
END;

PROCEDURE Speaker_On;

BEGIN
  WriteDSP(dsp_SpeakerOn);
END;

PROCEDURE Speaker_Off;

BEGIN
  WriteDSP(dsp_SpeakerOff);
END;

{---------------------------------------------------------------------------}
{ Startcode der Unit                                                        }
{---------------------------------------------------------------------------}
FUNCTION GetBaseAddress(BlasterEnv : String) : Word;

VAR
  AddrPos  : Byte;  { Position der Basis-Adresse in der Umgebungsvariablen }
  AddrStr  : String;                        { Basis-Adresse als Hex-String }

BEGIN
  GetBaseAddress := 0;

  { Die Basis-I/O-Adresse wird in der BLASTER-Umgebungsvariablen gefolgt }
  { von dem Zeichen "A" eingetragen.                                     }

  AddrPos := Pos('A', BlasterEnv)+1;

  { Ermittlung der Basis-Adresse }

  IF AddrPos > 1 THEN
    BEGIN
      AddrStr := Copy(BlasterEnv, AddrPos, 3);
      GetBaseAddress := HexToDec(AddrStr);
    END;
END;

PROCEDURE CheckBaseAddress;

VAR
  Count   : Word;                                              { ein Zhler }
  Reading : Boolean;    { TRUE, wenn der Bytewert AAh gelesen werden konnte }

BEGIN
  Count := 0;
  Reading := FALSE;
  Port[SB_BaseAddress+$06] := $01;     { Port Basis+06h mit 01h beschreiben }
  Delay(1);                                      { eine Millisekunde warten }
  Port[SB_BaseAddress+$06] := $00;     { Port Basis+06h mit 00h beschreiben }
  WHILE NOT Reading DO          { solange wiederholen, bis Wert AAh gelesen }
    BEGIN
      Inc(Count);                                          { Zhler erhhen }
      Reading := (ReadDSP = $AA);                       { Wert AAh gelesen? }
{      IF Count = 1000 THEN   { 1000 Mikrosekunden (1 Millisek.) abgelaufen? }
 {      RunError(1); }
    END;
END;

{---------------------------------------------------------------------------}
{ Startcode der Unit                                                        }
{---------------------------------------------------------------------------}

Procedure MyWriteDirect( abc : Byte );
Begin
 Asm
  Mov ChipTImeOut, 0
  @Schleife1Anfang:
  Inc ChipTImeOut
  Mov Dx, Sb_Addr0C                          { Dx -> SB Read-Reg }
  In Al, Dx                                  { Und rein mit dem Byte ... }
  Cmp Al, 128                                { grer 127 -> Bit 8 gesetzt ! }
  JB @Schleife1Ende                          { Jb -> Wenn below }
  { Hmm. Immer noch nix da. }
  Cmp ChipTImeOut, 100
  Jne @Schleife1Anfang
  @Schleife1Ende:

  Mov Dx, Sb_Addr0C
  Mov Al, dsp_WriteDirectUnpack
  Out Dx, Al


  Mov ChipTImeOut, 0
  @Schleife2Anfang:
  Inc ChipTImeOut
  Mov Dx, Sb_Addr0C                          { Dx -> SB Read-Reg }
  In Al, Dx                                  { Und rein mit dem Byte ... }
  Cmp Al, 128                                { grer 127 -> Bit 8 gesetzt ! }
  JB @Schleife2Ende                          { Jb -> Wenn below }
  { Hmm. Immer noch nix da. }
  Cmp ChipTImeOut, 100
  Jne @Schleife2Anfang
  @Schleife2Ende:

  Mov Dx, Sb_Addr0C
  Mov Al, abc
  Out Dx, Al
 End;
End;

Function MyReadDirect : Byte;
Begin
 Asm
  Mov ChipTImeOut, 0
  @Schleife1Anfang:
  Inc ChipTImeOut
  Mov Dx, Sb_Addr0C                          { Dx -> SB Read-Reg }
  In Al, Dx                                  { Und rein mit dem Byte ... }
  Cmp Al, 128                                { grer 127 -> Bit 8 gesetzt ! }
  JB @Schleife1Ende                          { Jb -> Wenn below }
  { Hmm. Immer noch nix da. }
  Cmp ChipTImeOut, 100
  Jne @Schleife1Anfang
  @Schleife1Ende:

  Mov Dx, Sb_Addr0C
  Mov Al, dsp_ReadDirectUnpack
  Out Dx, Al

{ Nun fngt die Schleife an, in der der Wert gelesen wird }
{ Anm. Solange warten, bis gelesen werden kann (BIT 8 von Port Sb_Base + 0E gesetzt) }
  Mov ChipTImeOut, 0
  @Schleife2Anfang:
  Inc ChipTImeOut
  Mov Dx, Sb_Addr0E                          { Dx -> SB Read-Reg }
  In Al, Dx                                  { Und rein mit dem Byte ... }
  Cmp Al, 128                                { grer oder gleich 127 -> Bit 8 gesetzt ! }
  JAE @Schleife2Ende                         { Ja -> Wenn above }
  { Hmm. Immer noch nix da. }
  Cmp ChipTImeOut, 100
  Jne @Schleife2Anfang
  @Schleife2Ende:
 End;
 MyReadDirect := Port[SB_Addr0A];   { DSP o.k., Bytewert zurckliefern }
End;



Function SoundInstalled : Boolean;
Begin
 SoundINstalled := Sb_BaseAddress <> 0; { ndern. }
End;

Begin
 SB_BaseAddress := GetBaseAddress(GetEnv('BLASTER'));
 If SB_BaseAddress <> 0 then { zurckndern. }
  Begin
{$IFDEF COMPILE_ENGLISH}
   Writeln('Soundblaster found !');
{$ELSE}
   Writeln('Soundblaster gefunden !');
{$ENDIF}

   SB_Addr0A := SB_BaseAddress + $0A;
   SB_Addr0C := SB_BaseAddress + $0C;
   SB_Addr0E := SB_BaseAddress + $0E;
  End
 Else
  Begin
{$IFDEF COMPILE_ENGLISH}
  Writeln('"BLASTER"-environment variable was not set. Sound deactivated.');
{$ELSE}
   Writeln('"BLASTER"-Umgebungsvariable nicht gesetzt. Sound-Funktionen sind deaktiviert.');
{$ENDIF}

  End;
END.
