{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
{ *** Die Script-File-Funktionen *** }
Type
       tScriptCommand = Record
                     Command : Word;
                       Param : LongInt;
                          Ok : Boolean;
                        End;


Var
        SpeechFileName : tStr50;
            ScriptFile : Text;                   { Die Datei mit dem Script }
            AwnserFile : Text;                   { Die Datei mit den Schler-Antworten }

          CurrentInput : tStr50;                 { Die Aktuelle Eingabe }

        CurrentCommand : tScriptCommand;



      OutWinX, OutWinY : Word;                   { Die Position in meinem Ausgabefenster }
             OldX,OldY : Word;
{   OldWinMin,OldWinMax : Word; }

Const
                      CMD_NONE = 0;              { Nichts machen. }

             CMD_SETSPEECHFILE = 1;
                      CMD_SYNC = 2;              { Mit Sprachausgabe synchronisieren. }
              CMD_DISPLAYStart = 3;
                CMD_DisplayEnd = 4;
              CMD_ClearDisplay = 5;
              CMD_OpenTextFile = 6;
             Cmd_CloseTextFile = 7;
               CMD_WriteAwnser = 8;

                      CMD_WAIT = 1;              { "Param"-Timer-Ticks warten }

                   MaxCommands = 8;
 CommandNames : Array[1..MaxCommands] of tStr20 =
                ('SetSpeechFile=',               { Sprachdatei setzen }
                 'SyncSpeech=',                  { Script mit Sprache synchronisieren }
                 'DisplayNextLines',             { Die folgenden Zeilen darstellen, bis }
                 'EndDisplayNextLines',          { kommt. }
                 'ClearDisplay',                 { Lscht das Ausgabefenster }
                 'OpenTextFile=',                { ffnet die Antworten-Datei }
                 'CloseTextFile',                { Schliet die Antworten-Datei }
                 'WriteAwnser=');                { Schreibt eine Antwort in die Datei }



const
 RETURN=#13;
var
            NumberCharsInput : integer; {how many letters so far}
           CursorPosition    : byte; {where cursor is starting with 1}
          startx,starty      : Byte; {screen position of first letter
                                      in CurrentInput}
                       tempx : Byte;

Function GetEntry( EntryName : tStr50 ) : tStr50;
Var
 TempString : tStr50;
 Found : Boolean;
Begin
 If ScriptOk then
  Begin
   Found := False;
   Reset(ScriptFile);
   EntryName := '' + Upper(StripBoth(EntryName));
   While Not(Eof(ScriptFile)) And Not(Found) do
    Begin
     Readln(ScriptFile,TempString);
     TempString := Upper(StripBoth(tempString));
     If TempString[1] <> '#' then
      Begin
       If Pos(EntryName,TempString) = 1 then
        Begin
         Found := True;
         Delete(TempString,1,Length(EntryName)+1);
         GetEntry := TempString;
        End Else TempString := '';
      End;
    End;
  End;
End;

Procedure SetWriteDisplay;
Begin
 Window(OutWin_X+1,OutWin_Y+1,OutWin_X2+OutWin_X-1,OutWin_Y2+OutWin_Y-1);
 GotoXY(OutWinX,OutWinY);
 CurSorOn;
End;

Procedure SetNormalDisplay;
Begin
{ CurSorOff; }
 OutWinX := WhereX;
 OutWinY := WhereY;
 Window(1,1,80,25);
 GotoXY(OutWin_X+OutWinX,OutWin_Y+OutWinY);
 If CurrentCommand.Command <> CMD_WriteAwnser then CurSorOff;
End;


Procedure NextCommand;
{ ************************************************************************** }
{ ***    Aufgabe : Einlesen und ausfhren des aktuellen Kommandos.       *** }
{ ***              Danach einlesen des nchsten.                         *** }
{ ***    Einagbe :  ---                                                  *** }
{ ***    Ausgabe :  ---                                                  *** }
{ *** nderungen :  ---                                                  *** }
{ ***    22.11.96 ->                                                     *** }
{ ************************************************************************** }


Var
            Lauf1 : Word;
            Lauf2 : Word;
 WriteFollowLines : Boolean;
        CommandOK : Boolean;
       TempString : tStr50;

Begin
 If ScriptOK then
  Begin
   If CurrentCommand.Command = CMD_NONE then
    Begin
     CommandOK := FALSE;
     WriteFollowLines := FALSE;
      While Not(Eof(ScriptFile)) and Not(CommandOk) do
       Begin
        Readln(ScriptFile,TempString);
         If Not(WriteFollowLines) then
          Begin
           TempString := Upper(StripBoth(tempString));
         If TempString[1] = '' then
          Begin { Aha ! Ein Kommando ! }
           Delete(TempString,1,1);                   { Das Kommando-Escape lschen. }
           For Lauf1 := 1 to MaxCommands do          { Herausfinden, welches Kommando gemeint ist. }
            If Pos(Upper(CommandNames[Lauf1]),TempString) = 1 then
             Begin
              Delete(TempString,1,Length(CommandNames[Lauf1]));
              Case Lauf1 of
    CMD_SETSPEECHFILE : Begin
                         SpeechFileName := TempString;
                         Assign(CurrentPlyLabFile,SpeechFileName);
                         Reset(CurrentPlyLabFile,1);
                         CommandOK := True;
                        End;
             CMD_SYNC : Begin
                         CurrentCommand.Command := CMD_SYNC;
                         Val(TempString,Currentcommand.Param,Lauf2);
                         CommandOK := True;
                        End;
     CMD_DISPLAYStart : Begin
                         WriteFollowLines := TRUE;
                         SetWriteDisplay;
                        End;
    CMD_ClearDisplay :  Begin                    { Schirm lschen }
                         SetWriteDisplay;
                         ClrScr;
                         SetNormalDisplay;
                         CommandOK := true;
                        End;
     CMD_OPenTextFile : Begin
                         Assign(AwnserFile,TempString);
                         Rewrite(AwnserFile);
                        End;
    CMD_CloseTextFile : Begin
                         Close(AwnserFile);
                        End;
      Cmd_WriteAwnser : Begin
                         CurrentCommand.Command := Cmd_WriteAwnser;
                         Val(TempString,Currentcommand.Param,Lauf2);
                         CurrentInput := '';
                         CurrentCommand.Ok := FALSE;
                         CommandOK := True;
                         SetWriteDisplay;
                          NumberCharsInput := 0;

                         CursorPosition:=1;
                         Startx:=WhereX;
                         Starty:=WhereY;
                         GotoXY(StartX,StartY);

                         SetNormalDisplay;

                        End;
             End;
            If CommandOK then Lauf1 := MaxCommands;
           End
         End Else
          Begin
          End;
        End
       Else
        begin
         if StripBoth(Upper(TempString)) <> Upper('EndDisplayNextLines') then
          Begin
           GotoXY(OutWinX, OutWinY);
           Writeln(TempString);
           OutWinX := WhereX;
           OutWinY := WhereY;
          End
         Else
          Begin
           WriteFollowLines := FALSE;
           SetNormalDisplay;
          End;
        End;
      End;

     If Eof(ScriptFile) then
      Begin { Das Script ist zuende ! }
      End;
    End
   Else
    Begin
     Case CurrentCommand.Command of
        CMD_SYNC : If CurrentFilePosition >= CurrentCommand.Param then
                    Begin
                     CurrentCommand.Command := Cmd_None;
                    End;
  Cmd_WriteAwnser : Begin
                     If CurrentCommand.OK = True then
                      Begin { Die Antwort schreiben }
                       Writeln(AwnserFile,CurrentInPut);
                       CurrentCommand.Command := CMD_nOne;
                       CurSorOff;
                      End;
                    End;

     End;
    End;
  End;
End;

Const
 SYNC_BACK = TRUE;
 SYNC_AHED = FALSE;

Procedure SyncronizeFileToPosition( Position : LongInt; Back : Boolean );
{ ************************************************************************** }
{ 2***    Aufgabe : Neusynchronisation der Script-Datei mit der           *** }
{ ***              aktiven Sprachdatei.                                  *** }
{ ***    Einagbe :  ---                                                  *** }
{ ***    Ausgabe :  ---                                                  *** }
{ *** nderungen :  ---                                                  *** }
{ ***    22.11.96 ->                                                     *** }
{ ************************************************************************** }
Var
         TempString : String;
          CommandOK : Boolean;
  LinesReadfromLast : Word;
       LinesReadMax : Word;
              Lauf1 : Word;

Begin
 If ScriptOk then
  Begin
   If Back = SYNC_Back then
    Begin { Nach hinten synchronisieren }
     Reset(ScriptFile);                            { Das Scriptfile resetten. }
     CommandOk := FALSE;
     LinesReadFromLast := 0;
     LinesReadMax := 0;
     { Erstmal feststellen, wo ich hinsyncen mu ! }
     While Not(Eof(ScriptFile)) and Not(CommandOk) do
      Begin
       Inc(LinesReadFromLast);
       Readln(ScriptFile,TempString);
       TempString := Upper(StripBoth(tempString));
       If TempString[1] = '' then
        Begin
         If Pos(Upper(CommandNames[CMD_SYNC]),TempString) = 1 then
          Begin
           Delete(TempString,1,Length(CommandNames[CMD_SYNC]));
           Val(TempString,Currentcommand.Param,Lauf2);
           If CurrentCommand.Param <= CurrentFilePosition then
            Begin
             CommandOK := True;
            End
           Else
            Begin
             LinesReadMax := LinesReadMax + LinesReadFromLast;
             LinesReadFromLast := 0;
            End;
          End;
        End;
      End;
     Reset(ScriptFile);
     For Lauf1 := 1 to LinesReadMax do Readln(ScriptFile,TempString);
     { *** Die Zeile, wo ich nun bin msste eigentlich die gesuchte Sync-Zeile sein ... *** }
     If TempString[1] = '' then
      Begin
       If Pos(Upper(CommandNames[CMD_SYNC]),TempString) = 1 then
        Begin
         Delete(TempString,1,Length(CommandNames[CMD_SYNC]));
         Val(TempString,Currentcommand.Param,Lauf2);
         If CurrentCommand.Param >= CurrentFilePosition then
          Begin
           CurrentCommand.Command := Cmd_SYNC; { Neusynchronisation erfolgreich ! }
           CommandOK := True;
          End;
        End;
      End;
    End
   Else   { Nach vorne Synchronisieren }
    Begin
     CommandOK := True;
     While Not(Eof(ScriptFile)) and Not(CommandOk) do
      Begin
       Readln(ScriptFile,TempString);
       TempString := Upper(StripBoth(tempString));
       If TempString[1] = '' then
        Begin
         If Pos(Upper(CommandNames[CMD_SYNC]),TempString) = 1 then
          Begin
           Delete(TempString,1,Length(CommandNames[CMD_SYNC]));
           Val(TempString,Currentcommand.Param,Lauf2);
           If CurrentCommand.Param >= CurrentFilePosition then
            Begin
             CurrentCommand.Command := Cmd_SYNC; { Neusynchronisation erfolgreich ! }
             CommandOK := True;
            End;
          End;
        End;
      End;
    End;
  End;
End;


Procedure ReadInputForAwnser( Eingabe : Char ) ;
Begin
 If ScriptOK then
  Begin
   Writeln('Guten Tag !');
   SetWriteDisplay;
   Case Eingabe of
     #0 : begin
           Eingabe:=Readkey;
           Case  Eingabe of
            #75 : If (CursorPosition > 1) then
                   Begin     {cursor_left}
                    GotoXY(WhereX-1,WhereY);
                    Dec(CursorPosition);
                   end;
            #77 : If ((CursorPosition <= NumberCharsInput) and (CursorPosition < 50)) then
                   begin {cursor_right}
                    GotoXY(WhereX+1,WhereY);
                    Inc(CursorPosition);
                   end;
            #83 : If ((CursorPosition <= NumberCharsInput)and (CurrentInput<>'')) then
                   begin { delete}
                    Dec(NumberCharsInput);
                    Delete(CurrentInput,CurSorPosition,1);
                    Tempx:=Wherex;
                    Gotoxy(startx,starty);
                    Write(CurrentInput);
                    Write(' ');
                    Gotoxy(Tempx,Wherey);
                   end;

           end;
          end;
    #13 : Begin
           CurrentCommand.Ok := True;
          End;
    #27 : begin
           CurrentCommand.Ok := True;
          End;
     #8 : If CursorPosition>1 then
           begin
            Tempx:=Wherex;
            Gotoxy(startx,starty);
            Delete(CurrentInput,CurSorPosition-1,1);
            Dec(CurSorPOsition);
            Dec(NumberCharsInput);
            Write(CurrentInput);
            Write(' ');
            GotoXY(TempX-1,WhereY);
           End;
  #32..'~',#128..#165:
           Begin
            If (Cursorposition < 50) then
             Begin
              TempX := WhereX;
              GotoXY(StartX,StartY);
              System.Insert(Eingabe,CurrentInput,CurSorPosition);
              Write(CurrentInput);
              Inc(CurSorPosition);
              Inc(NumberCharsInput);
              GotoXY(TempX+1,WhereY);
             End;
           End;
         end{case Eingabe};
   SetNormalDisplay;
  End;
End;

Procedure InitScript;
Begin
 Assign(ScriptFile,'LABDATA.SRP');
 Reset(ScriptFile);
 If IoResult = 0 then
  Begin
   ScriptOk := TRUE;
   CurrentCommand.Command := 0;
   OutWinX := 1;
   OutWinY := 1;
   SetWriteDisplay;
   Writeln('Scriptinit erfolgreich.');
   Writeln('Master-Datei nach Scriptangabe : ',GetEntry('SetSpeechFile'));
   Assign(CurrentPlyLabFile,GetEntry('SetSpeechFile'));
   SetNormalDisplay;
  End
 else
  BEgin
   ScriptOK := FALSE;
   SetWriteDisplay;
   Writeln('Scriptinit nicht erfolgreich (Kein Script) ...');
   Writeln('Verwende Standard-Master-Datei (MASTER.MAS) ...');
   SetNormalDisplay;
   Assign(CurrentPlyLabFile,'MASTER.MAS');
  End;

 Reset(CurrentPlyLabFile,1);

 If IOResult <> 0 then
  Begin
   FatalError := TRUE;
   SetWriteDisplay;
   Writeln('Die Master-Datei konnte nicht gefunden werden (o..) ...');
   Writeln('Das Sprachlabor kann nicht fortgesetzt werden. ');
   ReadKey;
   SetNormalDisplay;
  End
 Else
  Begin
   FatalError := FALSE;
  ENd;
End;


