{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
; Gendert : "Indos" auch ins Turbo-DS

DATA   segment word public        ;Turbo-Datensegment

extrn In_Bios : Byte
extrn Dos_ptr : Dword
;extrn


DATA       ends                   ;Ende des Datensegments
                                                                        
;== Konstanten =========================================================
                                                                        
I2F_FKT_0  equ 0AAh               ;Code fr INT 2F, Funktion 0 Inst-Check
I2F_FKT_1  equ 0BBh               ;Code fr INT 2F, Funktion 1
I2F_FKT_2  equ 002h               ;Code fr INT 2F, Funktion 2 Setzen des Vectors fr Int 08
I2F_FKT_3  equ 003h               ;Code fr INT 2F, Funktion 3 Erlangen des Vektors fr Int 08
I2F_FKT_4  equ 004h               ; Code fr INT 2F, Funktion 4, Ist in Bios ?

TIME_OUT   equ 9                 ;Time-Out fr Aktivierung in Ticks
                                                                        
;== Programm ===========================================================
                                                                        
CODE       segment byte public    ;das Turbo-Codesegment
                                                                        
           assume cs:CODE, ds:DATA
                                                                        
;-- Public-Deklarationen interner Funktionen ---------------------------
                                                                        
public     tsrinit                ;ermglicht Aufruf aus Turbo-Programm
public     TsrIsInst
public     TSRUNinst
public     TsrCanuninst
public     TsrSetPtr
public     tsrcall
public     tsrsethotkey


tsraktiv db 0
;-- Variablen fr die Interrupt-Handler --------------------------------
;-- (nur ber das Codesegment zugnglich) ------------------------------
                                                                        
call_ptr   equ this dword
call_ofs   dw 0                   ;Offsetadresse fr TSRCall
call_seg   dw 0                   ;Segmentadresse noch nicht initial.

ds_save    dw 0                   ;Sichern von DS whrend TSR-Call
rptr_save  equ this dword         ;FAR-Pointer fr Rckehr aus TSR-CALL
rip_save   dw 0                   ;Sichern der Rcksprungadresse bei
rcs_save   dw 0                   ;TSR-Call
ret_ax     dw 0                   ;Sichern des Funktionsergebnisses bei
ret_dx     dw 0                   ;TsrCall

;-- Variablen, die zur Aktivierung des Turbo-Prg. bentigt werden ------
                                                                        
t_ss       dw 0                   ;Turbo-Stacksegment
t_sp       dw 0                   ;Turbo-Stackpointer
t_ds       dw 0                   ;Turbo-Datensegment
t_es       dw 0                   ;Turbo-Extrasegment
                                                                        
t_dta_ofs  dw 0                   ;DTA-Adresse des Turbo-Programms
t_dta_seg  dw 0
                                                                        
t_psp      dw 0                   ;Segmentadresse des PSP des Turbo-Prg.
prz_adr    dd 0                   ;Addresse der Turbo-TSR-Prozedur

;-- Variablen, zum Test auf die Bettigung des Hotkey ------------------
                                                                        
key_mask   dw 3                   ;Hotkey-Maske fr BIOS-Tastaturflag
                                  ;Default: Shift links + Shift Rechts
sc_code    db 128                 ;Scan-Code des Hotkeys
                                  ;Default: keine Taste
i2F_code   db 0                   ;Funktionsnummer fr INT 2F

;-- Variablen fr die TSR-Aktivierung ----------------------------------

tsrnow     db 0                   ;wartet TSR auf Aktivierung?


;-- die folgenden Variablen nehmen die alten Adressen der Interrupt- ---
;-- Handler auf, die durch neue Interrupt-Handler ersetzt wurden     ---

int8_ptr   equ this dword         ;alter Interrupt-Vektor 8h
int8_ofs   dw 0                   ;Offsetadresse des alten Handlers
int8_seg   dw 0                   ;Segmentadresse des alten Handlers

int9_ptr   equ this dword         ;alter Interrupt-Vektor 9h
int9_ofs   dw 0                   ;Offsetadresse des alten Handlers
int9_seg   dw 0                   ;Segmentadresse des alten Handlers
                                                                        
int13_ptr  equ this dword         ;alter Interrupt-Vektor 13h
int13_ofs  dw 0                   ;Offsetadresse des alten Handlers
int13_seg  dw 0                   ;Segmentadresse des alten Handlers
                                                                        
int28_ptr  equ this dword         ;alter Interrupt-Vektor 28h
int28_ofs  dw 0                   ;Offsetadresse des alten Handlers
int28_seg  dw 0                   ;Segmentadresse des alten Handlers
                                                                        
int2F_ptr  equ this dword         ;alter Interrupt-Vektor 2Fh
int2F_ofs  dw 0                   ;Offsetadresse des alten Handlers
int2F_seg  dw 0                   ;Segmentadresse des alten Handlers

;-- Variablen, die Informationen ber das unterbrochene Programm -------
;-- aufnehmen                                                    -------

u_dta_ofs  dw 0                   ;DTA-Adresse des unterbrochenen Prg.
u_dta_seg  dw 0
                                                                        
u_psp      dw 0                   ;Segmentadresse des PSP des unt. Prg.
                                                                        
uprg_ss    dw 0                   ;SS und SP des unterbrochenen Prg.
uprg_sp    dw 0

;-----------------------------------------------------------------------
;-- tsrinit: beendet das Turbo-Programm und aktiviert die neuen  -------
;--          Interrupt-Handler
;-- Aufruf von Turbo: procdure tsrinit( PrzPtr   : word; PrzPtr2 : Word
;--                                     ResPara  : word );

tsrinit    proc    near
                                                                        
sframe0    struc                  ;Struktur zum Zugriff auf den Stack
bp0        dw ?                   ;nimmt BP auf
ret_adr0   dw ?                   ;Rcksprungadresse
respara0   dw ?                   ;Anzahl zu reservierender Paragraphen
przptr0    dd ?                   ;Offset der Turbo-TSR-Prozedur
sframe0    ends                   ;Ende der Struktur
                                                                        
frame      equ [ bp - bp0 ]
                                                                        
           push bp                ;BP auf dem Stack sichern
           mov  bp,sp             ;SP nach BP bertragen
           push es                ;ES auf dem Stack sichern
                                                                        
           ;-- die Turbo-Segmentregister sichern -----------------------
                                                                        
           mov  t_ss,ss           ;die Register in den entsprechenden
           mov  t_sp,sp           ;Variablen merken
           mov  t_es,es
           mov  t_ds,ds
                                                                        
           ;-- PSP des Turbo-Programms ermitteln -----------------------

           mov  bx,cs             ;CS nach BX trasferieren
           sub  bx,10h            ;10h Paragraphen = 256 Byte abziehen
           mov  t_psp,bx          ;Segmentadresse merken
                                                                        
           ;-- die bergebenen Parameter speichern ---------------------

           mov  ax , word ptr frame.przptr0  ;Pointer auf TSR-Prozedur holen
           mov  word ptr prz_adr ,ax        ;und merken
           mov  ax, word ptr frame.przptr0 + 2
           mov word ptr prz_adr + 2, ax

           ;-- DTA-Adresse des Turbo-Programms ermitteln ---------------
                                                                        
           mov  ah,2fh            ;Fkt.nr.: DTA-Adresse holen
           int  21h               ;DOS-Interrupt aufrufen
           mov  t_dta_ofs,bx      ;Adresse in den entsprechenden
           mov  t_dta_seg,es      ;Variablen merken
                                                                        
           ;-- Adresse des INDOS-Flags ermitteln -----------------------
                                                                        
           mov  ah,34h            ;Fkt.nr.: Adresse INDOS-Flag holen
           int  21h               ;DOS-Interrupt aufrufen
           push ds
           mov ds, t_ds
           mov  word ptr Dos_ptr,bx      ;Adresse in den entsprechenden
           mov  word ptr Dos_ptr + 2,es      ;Variablen merken
           pop ds
                                                                        
           ;-- die Adressen der umzuleitenden Interrupt-Handler holen --
                                                                        
           mov  ax,3508h          ;Interrupt-Vektor 8h holen
           int  21h               ;DOS-Interrupt aufrufen
           mov  int8_ofs,bx       ;Adresse des Handlers in den ent-
           mov  int8_seg,es       ;sprechenen Variablen merken

           mov  ax,3509h          ;Interrupt-Vektor 9h holen
           int  21h               ;DOS-Interrupt aufrufen
           mov  int9_ofs,bx       ;Adresse des Handlers in den ent-
           mov  int9_seg,es       ;sprechenen Variablen merken
                                                                        
           mov  ax,3513h          ;Interrupt-Vektor 13h holen
           int  21h               ;DOS-Interrupt aufrufen
           mov  int13_ofs,bx      ;Adresse des Handlers in den ent-
           mov  int13_seg,es      ;sprechenden Variablen merken
                                                                        
           mov  ax,3528h          ;Interrupt-Vektor 28h holen
           int  21h               ;DOS-Interrupt aufrufen
           mov  int28_ofs,bx      ;Adresse des Handlers in den ent-
           mov  int28_seg,es      ;sprechenden Variablen merken
                                                                        
           mov  ax,352Fh          ;Interrupt-Vektor 2Fh holen
           int  21h               ;DOS-Interrupt aufrufen
           mov  int2F_ofs,bx      ;Adresse des Handlers in den ent-
           mov  int2F_seg,es      ;sprechenden Variablen merken


           ;-- die neuen Interrupt-Handler installieren ----------------

           push ds                ;Datensegment merken
           mov  ax,cs             ;CS nach AX und dann nach DS laden
           mov  ds,ax
                                                                        
           mov  ax,2508h          ;Fkt.nr.: Interrupt 8h setzen
           mov  dx,offset int08   ;DS:DX nimmt Adresse des Handler auf
           int  21h               ;DOS-Interrupt aufrufen
                                                                        
           mov  ax,2509h          ;Fkt.nr.: Interrupt 9h setzen
           mov  dx,offset int09   ;DS:DX nimmt Adresse des Handler auf
           int  21h               ;DOS-Interrupt aufrufen
                                                                        
           mov  ax,2513h          ;Fkt.nr.: Interrupt 13h setzen
           mov  dx,offset int13   ;DS:DX nimmt Adresse des Handler auf
           int  21h               ;DOS-Interrupt aufrufen
                                                                        
           mov  ax,2528h          ;Fkt.nr. Interrupt 28h setzen
           mov  dx,offset int28   ;DS:DX nimmt Adresse des Handler auf
           int  21h               ;DOS-Interrupt aufrufen
                                                                        
           mov  ax,252Fh          ;Fkt.nr.: Interrupt 2Fh setzen
           mov  dx,offset int2F   ;DS:DX nimmt Adresse des Handler auf
           int  21h               ;DOS-Interrupt aufrufen

           pop  ds                ;DS wieder vom Stack kholen
                                                                        
           ;-- Programm resident beenden -------------------------------
                                                                        
           mov  ax,3100h          ;Fkt.nr.: Programm resident beenden
           mov  dx,frame.respara0 ;Anzahl der reservierten Para. holen
           int  21h               ;DOS-Interrupt aufrufen und damit das
                                  ;Programm beenden
                                                                        
tsrinit  endp
                                                                        
;-----------------------------------------------------------------------
;-- TSRSETHOTKEY: Stellt den Hotkey des Programms ein
;-- Aufruf von Turbo: procdure TsrSetHotKey( KeyMask  : word;
;--                                          ScanCode : byte );
;-- Info            : Diese Prozedur ist FAR, damit sie auch in einem
;--                   bereits installierten TSR aufgerufen werden kann.
;--

tsrsethotkey  proc far
                                                                        
sframe1    struc                  ;Struktur zum Zugriff auf den Stack
bp1        dw ?                   ;nimmt BP auf
ret_adr1   dd ?                   ;Rcksprungadresse
sc_code1   dw ?                   ;Scan-Code des Hotkey
keymask1   dw ?                   ;Maske fr Hotkey
sframe1    ends                   ;Ende der Struktur

frame      equ [ bp - bp1 ]

           push bp                ;BP auf dem Stack sichern
           mov  bp,sp             ;SP nach BP bertragen

           ;-- die bergebenen Parameter speichern ---------------------
                                                                        
           mov  ax,frame.keymask1 ;Maske fr Hotkey holen und merken
           mov  key_mask,ax       ;und sichern
           mov  al,byte ptr frame.sc_code1 ;Scan-Code des Hotkey holen
           mov  sc_code,al                 ;und sichern

           pop  bp                ;BP wieder vom Stack
           ret  4                 ;zurck und Argumente vom Stack

tsrsethotkey  endp

;-----------------------------------------------------------------------
;-- TsrIsInst: stellt fest, ob das Programm bereits installiert ist ----
;-- Aufruf von Turbo: function TsrIsInst( i2f_fktnr : byte ) : boolean;
;-- Return-Wert : TRUE, wenn das Programm bereits installiert war,
;--               sonst FALSE

TsrIsInst  proc    near
                                                                        
sframe2    struc                  ;Struktur zum Zugriff auf den Stack
bp2        dw ?                   ;nimmt BP auf
ret_adr2   dw ?                   ;Rcksprungadresse
i2F_code2  dw ?                   ;Funktionsnummer fr INT 2F
sframe2    ends                   ;Ende der Struktur

frame      equ [ bp - bp2 ]

           push bp                ;BP auf dem Stack sichern
           mov  bp,sp             ;SP nach BP bertragen

           mov  ah,byte ptr frame.i2F_code2 ;Fktnr. fr INT 2F
           mov  i2F_code,ah                 ;und sichern
           mov  al,I2F_FKT_0                ;Unterfktnr.
           mov  bx,ax                       ;beide Nummern merken
           int  2Fh
           xchg bh,bl                       ;Nummern verdrehen
           cmp  ax,bx                       ;mit Rckgabe vergleichen
           mov  ax,0                        ;nicht von Install. ausgehen
           jne  isi_end                     ;ungleich --> nicht install.

           ;-- Segmentadresse der bereits installierten Kopie ermitteln

           mov  ah,i2f_code       ;Nein, Segmentadresse ber INT 2Fh
           mov  al,I2F_FKT_1      ;Unterfunktion 01h laden
           int  2Fh
           mov  call_seg,ax       ;und in Variablen merken
           mov  ax,-1             ;ist installiert

isi_end:   pop  bp                ;BP wieder vom Stack
           ret  2                 ;zurck und Argumente vom Stack

TsrIsInst  endp                   ;Ende der Prozedur
                                                                        
;-----------------------------------------------------------------------
;-- TSRCANUNIST: Feststellen, ob installierte Kopie des TSR wieder -----
;--              Deinstalliert werden kann
;-- Aufruf von Turbo : function TsrCanuninst : boolean;
;-- Ausgabe          : TRUE, wenn Reinstallation mglich, sonst FALSE
;-- Info             : Das Programm kann nur Deinstalliert werden, wenn
;--                    keiner der Interrupt-Vektoren des Programms in
;--                    der Zwischenzeit auf ein anderes Programm um-
;--                    geleitet wurde.

tsrlist    db  08h,09h,13h,28h,2Fh,00h ;Liste der umgeleiteten INT
                                       ;00h markiert Ende
TsrCanuninst  proc  near

           mov  dx,call_seg         ;Segment der install. Kopie laden
           mov  di,offset tsrlist-1 ;DI auf Liste

tcu_1:     inc  di                ;DI auf die nchste Intr-Nummer
           mov  al,cs:[di]        ;nchste Intr-Nummer nach AL
           or   al,al             ;Ende der Liste erreicht?
           je   tcu_ok            ;Ja, alle Vektoren ok

           mov  ah,35h            ;Fktnr. fr "Get Interrupt"
           int  21h               ;DOS-Interrupt aufrufen
           mov  cx,es             ;ES zum Vergleich nach CX
           cmp  dx,cx             ;noch im gleichen Segment?
           je   tcu_1             ;Ja, keine Reinstallation mglich

           xor  ax,ax             ;Nein, keine Reinstallation mglich
           ret

tcu_ok:    mov  ax,-1
           ret

TsrCanuninst endp

;-----------------------------------------------------------------------
;-- TSRUNinst: Deinstalliert das TSR-Programm und gibt den allokierten -
;--            Speicher wieder frei.
;-- Aufruf von Turbo : procedure TSRUNinst;
;-- Info             : Diese Routine darf nur nach einem vorhergehenen
;--                    und erfolgreichen Aufruf von TsrCanuninst()
;--                    aufgerufen werden

TSRUNinst  proc  near

           push ds
           mov  es,call_seg       ;Segment des installierten TSR laden


           ;-- die Interrupt-Handler der TSR-Programm wieder -----------
           ;-- reinstallieren                                -----------

           cli                    ;keine Interrupts mehr zulassen
           mov  ax,2508h          ;Fkt.nr: Handler fr INT 8 setzen
           mov  ds,es:int8_seg    ;Segmentadresse des alten Handler
           mov  dx,es:int8_ofs    ;Offsetadresse des alten Handler
           int  21h               ;den alten Handler wieder installieren

           mov  ax,2509h          ;Fkt.nr: Handler fr INT 9 setzen
           mov  ds,es:int9_seg    ;Segmentadresse des alten Handler
           mov  dx,es:int9_ofs    ;Offsetadresse des alten Handler
           int  21h               ;den alten Handler wieder installieren
                                                                        
           mov  ax,2513h          ;Fkt.nr: Handler fr INT 13 setzen
           mov  ds,es:int13_seg   ;Segmentadresse des alten Handler
           mov  dx,es:int13_ofs   ;Offsetadresse des alten Handler
           int  21h               ;den alten Handler wieder installieren
                                                                        
           mov  ax,2528h          ;Fkt.nr: Handler fr INT 28 setzen
           mov  ds,es:int28_seg   ;Segmentadresse des alten Handler
           mov  dx,es:int28_ofs   ;Offsetadresse des alten Handler
           int  21h               ;den alten Handler wieder installieren
                                                                        
           mov  ax,252Fh          ;Fkt.nr: Handler fr INT 2F setzen
           mov  ds,es:int2F_seg   ;Segmentadresse des alten Handler
           mov  dx,es:int2F_ofs   ;Offsetadresse des alten Handler
           int  21h               ;den alten Handler wieder installieren

           ;-- Speicher wieder freigeben -------------------------------

           sti                    ;Interrupts wieder erlauben
                                                                        
           mov  es,es:t_psp       ;Segadr. des PSP des TSR-Programm
           mov  cx,es             ;in CX merken
           mov  es,es:[ 02ch ]    ;Segadr. des Environment aus PSP holen
           mov  ah,49h            ;Fkt.nr.: allok. Speicher freigeben
           int  21h               ;DOS-Interrupt aufrufen
                                                                        
           mov  es,cx             ;ES aus CX zurckholen
           mov  ah,49h            ;Fkt.nr.: allok. Speicher freigeben
           int  21h               ;DOS-Interrupt aufrufen
                                                                        
           pop  ds                ;DS und BP wieder vom Stack holen
           ret                    ;zurck zum Aufrufer

TSRUNinst  endp                   ;Ende der Prozedur
                                                                        
;-----------------------------------------------------------------------
;-- TsrSetPtr: Speichert die Adresse der Routine, die bei einem nach- --
;--            folgenden Aufruf von TSRCALL aufgerufen werden soll
;-- Aufruf von Turbo: procedure TsrSetPtr( offset : word );

TsrSetPtr  proc    near

sframe3    struc                  ;Struktur zum Zugriff auf den Stack
bp3        dw ?                   ;nimmt BP auf
ret_adr3   dw ?                   ;Rcksprungadresse
offset3    dw ?                   ;Offset der aufzurufenden Routine
sframe3    ends                   ;Ende der Struktur

frame      equ [ bp - bp3 ]

           push bp                ;BP auf dem Stack sichern
           mov  bp,sp             ;SP nach BP bertragen

           mov  ax,frame.offset3  ;Offsetadresse nach AX
           mov  call_ofs,ax       ;und speichern

           pop  bp                ;BP wieder vom Stack
           ret  2                 ;zurck und Argumente vom Stack

TsrSetPtr  endp                   ;Ende der Prozedur

;-----------------------------------------------------------------------
;-- TSRCALL: Ruft eine Routine in der zuvor installierten Kopie des ----
;--          TSR-Programms auf.
;-- Aufruf von Turbo : procedure TsrCall;
;-- Achtung          : - Der Stack wird in dieser Routine ganz bewut
;--                      nicht verndert, damit Parameter an die auf-
;--                      zurufenden Prozedur oder Funktion bergeben
;--                      werden knnen.
;--                    - Diese Prozedur mu FAR sein, weil sie von Turbo
;--                      aus ber einen Prozedur-Zeiger aufgerufen wird.

tsrcall    proc far

           ;-- Kontextwechsel zum Turbo-Programm durchfhren und die ---
           ;-- angegebene Prozedur aufrufen
                                                                        
           pop  rip_save          ;Rcksprungadresse vom Stack und
           pop  rcs_save          ;merken
           mov  ds_save,ds        ;DS merken

           mov  ah,2fh            ;Fkt.nr.: DTA-Adresse holen
           int  21h               ;DOS-Interrupt aufrufen
           mov  u_dta_ofs,bx      ;Adresse der DTA des unterbrochenen
           mov  u_dta_seg,es      ;Programms sichern

           mov  es,call_seg       ;Segmentadresse des installierten TSR
                                  ;nach ES
           mov  ah,50h            ;Fkt.nr.: Adresse des PSP setzen
           mov  bx,es:t_psp       ;Segmentadresse des PSP holen
           int  21h               ;DOS-Interrupt aufrufen
                                                                        
           mov  ah,1ah            ;Fkt.nr.: DTA-Adresse setzen
           mov  dx,es:t_dta_ofs   ;Offsetadresse der neuen DTA und
           mov  ds,es:t_dta_seg   ;Segmentadresse der neuen DTA holen
           int  21h               ;DOS-Interrupt aufrufen
                                                                        
           mov  ds,es:t_ds        ;Segment-Register fr das Turbo-
           mov  es,es:t_es        ;Programm setzen
                                                                        
           call [call_ptr]        ;die Turbo-Prozedur aufrufen
           mov  cs:ret_ax,ax      ;Funktionsergebnis merken
           mov  cs:ret_dx,dx
                                                                        
           ;-- Kontextwechsel zurck zum Turbo-Programm  ---------------
                                                                        
           mov  ah,1ah            ;Fkt.nr.: DTA-Adresse setzen
           mov  dx,u_dta_ofs      ;Offset- und Segmentadresse der DTA
           mov  ds,u_dta_seg      ;des unterbrochenen Programms laden
           int  21h               ;DOS-Interrupt aufrufen
                                                                        
           mov  es,call_seg       ;ES und DS zurckholen
           mov  ds,ds_save        ;zurckholen

           mov  ah,50h            ;Fkt.nr.: Adresse des PSP setzen
           mov  bx,cs             ;CS nach BX holen
           sub  bx,10h            ;Segmentadresse des PSP berechnen
           int  21h               ;DOS-Interrupt aufrufen
                                                                        
           mov  ax,cs:ret_ax      ;Funktionsergebnis zurckholen
           mov  dx,cs:ret_dx
           jmp  [rptr_save]       ;zurck zum Aufrufer

tsrcall    endp                   ;Ende der Prozedur
                                                                        
;-----------------------------------------------------------------------
;-- DOSAKTIV: Stellt anhand des DOS-INDOS-Flags fest, ob DOS derzeit
;--           unterbrochen werden darf.
;-- Eingabe:  keine
;-- Ausgabe:  Zero-Flag = 1 : DOS darf unterbrochen werden

dosaktiv   proc near

           push ds                ;DS und BX auf dem Stack merken
           push bx
           mov ds, t_ds
           lds  bx,Dos_ptr          ;DS:BX zeigen jetzt auf das INDOS-Flag
           cmp  byte ptr [bx],0   ;DOS-Funktion aktiv?
           pop  bx                ;BX und DS wieder vom Stack holen
           pop  ds

           ret                    ;zurck zum Aufrufer

dosaktiv   endp

;-----------------------------------------------------------------------
;-- es folgen die neuen Interrupt-Handler ------------------------------
;-----------------------------------------------------------------------
                                                                        
;-- der neue Interrupt 08h-Handler (Timer) -----------------------------

int08      proc far

           cmp  tsrnow,0          ;soll TSR aktiviert werden?
           je   i8_end            ;Nein, weiter zum alten Handler

           dec  tsrnow            ;Ja, Aktivierungs-Flag dekrementieren

           ;-- TSR soll aktiviert werden, aber ist das mglich? --------


           push ds
           mov ds, t_ds
           cmp  in_bios2, 0        ;BIOS-Disk-Interrupt gerade aktiv?
           pop ds

           jne  i8_end            ;JA --> keine Aktivierung mglich

           call dosaktiv          ;darf DOS unterbrochen werden?
           je   i8_tsr            ;Ja, TSR aufrufen


i8_end:


           jmp  [int8_ptr]        ;zum alten Handler springen

           ;-- TSR aktivieren ------------------------------------------

i8_tsr:    mov  tsrnow,0          ;TSR wartet nicht mehr auf Aktivierung
           mov  tsraktiv,1        ;TSR ist gleich aktiv
           pushf                  ;Aufruf des alten Handler ber den
           call [int8_ptr]        ;Befehl INT 8h simulieren
           call start_tsr         ;das TSR-Programm starten
           iret                   ;zurck zum unterbrochenen Programm

int08      endp

;-- der neue Interrupt 09h-Handler (Tastatur) --------------------------

int09      proc far

           push ax
           in   al,60h            ;Tastatur-Port auslesen

           cmp  tsraktiv,0        ;ist das TSR-Programm bereits aktiv?
           jne  i9_end            ;JA: alten Handler aufr, dann zurck

           cmp  tsrnow,0          ;wartet TSR auf seine Aktivierung?
           jne  i9_end            ;JA: alten Handler aufr, dann zurck

           ;-- Auf Hotkey testen ---------------------------------------

           cmp  sc_code,128       ;gibt es berhaupt einen Scan-Code?
           je   i9_ks             ;Nein, nur Umschalttasten berprfen

           cmp  al,128            ;Doch, ist Release-Code?
           jae  i9_end            ;Ja, ist nicht Hotkey

           cmp  sc_code,al        ;Make-Code, mit Taste vergleichen
           jne  i9_end            ;stimmt nicht, keine Aktivierung

i9_ks:     ;-- Status der Umschalttasten prfen ------------------------

           push ds
           mov  ax,040h              ;DS auf das Variablen-Segment des
           mov  ds,ax                ;ROM-BIOS
           mov  ax,word ptr ds:[17h] ;BIOS-Tastatur-Flag holen
           and  ax,key_mask          ;die nicht-Hotkey-Bits ausblenden
           cmp  ax,key_mask          ;nur noch die Hotkey-Bits brig?
           pop  ds                
           jne  i9_end            ;Hotkey entdeckt? NEIN --> zurck

           push ds
           mov ds, t_ds
           cmp  in_bios, 0        ;BIOS-Disk-Interrupt gerade aktiv?
           pop ds

           jne  i9_e1             ;JA --> keine Aktivierung mglich

           call dosaktiv          ;darf DOS unterbrochen werden?
           je   i9_tsr            ;Ja, TSR starten

i9_e1:     mov  tsrnow,TIME_OUT   ;TSR wartet auf Aktivierung

i9_end:    pop   ax               ;AX wieder zurckholen
           jmp   [int9_ptr]       ;zum alten Handler springen

i9_tsr:    mov   tsraktiv,1       ;TSR ist jetzt (gleich) aktiv
           mov   tsrnow,0         ;kein verzgerter Start gewnscht
           pushf
           call  [int9_ptr]       ;alten Handler aufrufen
           pop   ax               ;AX wieder zurckholen
           call  start_tsr        ;das TSR-Programm starten

           iret                   ;zurck zum unterbrochenen Programm

int09      endp

;-- der neue Interrupt 13h-Handler (Diskette/Festplatte) ---------------

int13      proc far


           push ds
           mov ds, t_ds
           inc  in_bios           ;BIOS-Disk-Flag inkrementieren
           pop ds

           pushf                  ;Aufruf der alten Interrupt-Handler
           call [int13_ptr]       ;ber INT 13h simulieren

           push ds
           mov ds, t_ds
           dec  in_bios           ;BIOS-Disk-Flag wieder zurcksetzen
           pop ds


           sti                    ;Interrupts wieder erlauben
           ret  2                 ;zurck zum Aufrufer, aber das Flag
                                  ;Register zuvor nicht vom Stack holen
int13      endp
                                                                        
;-- der neue Interrupt 28h-Handler (DOS-idle) --------------------------

int28      proc far

           cmp  tsrnow,0          ;wartet TSR auf Aktivierung?
           je   i28_end           ;Nein, zurck zum Aufrufer

           push ds
           mov ds, t_ds
           cmp  in_bios, 0        ;Ja, aber ist Disk-Intr gerade aktiv?
           pop ds
           je   i28_tsr           ;Ja, also nicht aktivieren

i28_end:   jmp  [int28_ptr]       ;zum alten Handler

           ;-- TSR starten ---------------------------------------------

i28_tsr:   mov  tsrnow,0          ;TSR wartet nicht mehr auf Aktivierung
           mov  tsraktiv,1        ;TSR ist (gleich) aktiv
           pushf                  ;Aufruf des alten Interrupt-Handler
           call [int28_ptr]       ;ber INT 28h simulieren
           call start_tsr         ;das TSR-Programm starten
           iret                   ;zurck zum Aufrufer

int28      endp

;-- der neue Interrupt 2Fh-Handler (Multiplexer) -----------------------

int2F      proc far

           cmp  ah,i2F_code       ;Aufruf fr dieses TSR?
           jne  i2F_end           ;Nein, zum alten Handler

           cmp  al,I2F_FKT_0      ;Ja, ist es Unterfunktion 00h?
           je   i2F_0             ;Ja, ausfhren

           cmp  al,I2F_FKT_1      ;Vielleicht Unterfunktion 01h?
           je   i2F_1             ;Ja, ausfhren

           cmp al, I2F_FKT_4      ; Velleicht Unterfunktion 04h ? (INBIOS)
           je i2F_4

           iret                   ;Nein, Aufruf ignorieren

i2F_end:   ;-- TSR ist nicht gemeint, Aufruf weiterleiten --------------

           jmp  [int2F_ptr]       ;zum alten Handler

i2F_0:     ;-- Unterfunktion 00: Installations-Check -------------------

           xchg ah,al             ;Funktions- und Unterfkt-nummer aust.
           iret                   ;zurck zum Aufrufer

i2F_1:     ;-- Unterfunktion 01: Segmentadresse zurckliefern ----------

           mov  ax,cs             ;Segmentadresse nach AX
           mov  bx,t_ds
           iret                   ;zurck zum Aufrufer

I2F_4:      ; Unterfunktion 04 : Bios Flag
           push ds
           mov ds, t_ds
           mov al, In_Bios
           pop ds
           mov ah, TsrAktiv
           iret



int2F      endp

;-- START_TSR: das TSR-Programm aktivieren -----------------------------

start_tsr  proc near
           ;-- Kontextwechsel zum Turbo-Programm durchfhren -----------
           cli                    ;keine Interrupts zulassen
           mov  uprg_ss,ss        ;aktuelles Stacksegment und Stack-
           mov  uprg_sp,sp        ;zeiger merken
                                                                        
           mov  ss,t_ss           ;den Stack des Turbo-Programms
           mov  sp,t_sp           ;aktivieren
           sti                    ;Interrupts wieder erlauben

           push ax                ;die Prozessorregister auf dem Turbo-
           push bx                ;Stack sichern
           push cx
           push dx
           push bp
           push si
           push di
           push ds
           push es
                                                                        
           ;-- 64 Words vom DOS-Stack sichern --------------------------

           mov  cx,64             ;Schleifenzhler
           mov  ds,uprg_ss        ;DS:SI auf Ende des DOS-Stack setzen
           mov  si,uprg_sp
                                                                        
tsrs1:     push word ptr [si]     ;Word aus dem DOS-Stack auf TP-Stack
           inc  si                ;sichern und SI auf das nchste Stack-
           inc  si                ;Word setzen
           loop tsrs1             ;alle 64 Words abarbeiten
                                                                        
           mov  ah,51h            ;Fkt.nr.: Adresse des PSP ermitteln
           int  21h               ;DOS-Interrupt aufrufen
           mov  u_psp,bx          ;Segmentadresse des PSP merken
                                                                        
           mov  ah,2fh            ;Fkt.nr.: DTA-Adresse holen
           int  21h               ;DOS-Interrupt aufrufen
           mov  u_dta_ofs,bx      ;Adresse der DTA des unterbrochenen
           mov  u_dta_seg,es      ;Programms sichern
                                                                        
           mov  ah,50h            ;Fkt.nr.: Adresse des PSP setzen
           mov  bx,t_psp          ;Segadr. PSP des Turbo-Programm holen
           int  21h               ;DOS-Interrupt aufrufen
                                                                        
           mov  ah,1ah            ;Fkt.nr.: DTA-Adresse setzen
           mov  dx,t_dta_ofs      ;Offsetadresse der neuen DTA und
           mov  ds,t_dta_seg      ;Segmentadresse der neuen DTA holen
           int  21h               ;DOS-Interrupt aufrufen
                                                                        
           mov  ds,t_ds           ;Segment-Register fr das Turbo-
           mov  es,t_es           ;Programm setzen

           call [prz_adr]         ;die Startfunktion aufrufen


           ;-- Kontextwechsel zum unterbrochenen Programm durchfhren --
                                                                        
           mov  ah,1ah            ;Fkt.nr.: DTA-Adresse setzen
           mov  dx,u_dta_ofs      ;Offset- und Segmentadresse der DTA
           mov  ds,u_dta_seg      ;des unterbrochenen Programms laden
           int  21h               ;DOS-Interrupt aufrufen
                                                                        
           mov  ah,50h            ;Fkt.nr.: Adresse des PSP setzen
           mov  bx,u_psp          ;Segadr. PSP des untebrochenen Prg.
           int  21h               ;DOS-Interrupt aufrufen
                                                                        
           ;-- DOS-Stack wieder restaurieren ---------------------------

           mov  cx,64             ;Schleifenzhler
           mov  ds,uprg_ss        ;DS:SI mit Endadresse des DOS-Stack
           mov  si,uprg_sp        ;laden
           add  si,128            ;SI auf Anfang des DOS-Stack setzen
tsrs2:     dec  si                ;SI auf vorhergehendes Stack-Word
           dec  si
           pop  word ptr [si]     ;Word vom Turbo-Stack auf DOS-Stack
           loop tsrs2             ;alle 64 Words abarbeiten
                                                                        
           pop  es                ;die gesicherten Register wieder vom
           pop  ds                ;Turbo-Stack zurckholen
           pop  di
           pop  si
           pop  bp
           pop  dx
           pop  cx
           pop  bx
           pop  ax
                                                                        
           cli                    ;keine Interrupts mehr zulassen
           mov  ss,uprg_ss        ;Stackzeiger und Stacksegment des un-
           mov  sp,uprg_sp        ;terbrochenen Programms wieder setzen
                                                                        

           mov  tsraktiv,0        ;TSR ist nicht mehr aktiv
           sti                    ;Interruptaufrufe wieder erlauben

           ret                    ;zurck zum Aufrufer
                                                                        
start_tsr  endp


;-----------------------------------------------------------------------

CODE       ends                   ;Ende des Codesegments
           end                    ;Ende des Programms

