{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
Procedure SaveRegsChar( Var  SavePlaneRead,SaveMemMode,SaveGraphMode,SaveGCMisc,SavedWritePLane,SaveSC,SaveGC : Byte );
Begin
 SaveSC := Port[SC_INDEX];
 SaveGC := Port[GC_INDEX];
                                                 { Read-Plane setzen }
                                                 { Das Memory-Mode Register "anwhlen" }
 SavePlaneRead := GetReadPlane;
 SavedWritePlane := GetWritePLane;

 SetReadPlane(2);
 SetWritePlane(2);

 Port[GC_INDEX] := GC_MISC;
 SaveGCMisc := Port[GC_INDEX+1];
 Port[GC_INDEX+1] := BIT_2;

 Port[SC_INDEX] := SC_MEM_MODE;
 SaveMemMode := Port[SC_INDEX+1];
 Port[SC_INDEX+1] := 7;                           {}

 Port[GC_INDEX] := GC_GRAPH_MODE;
 SaveGraphMode := Port[GC_INDEX+1];
 Port[GC_INDEX+1] := SaveGraphMode and Not(BIT_4); {}
End;


Procedure RestoreRegsChar( Var  SavePlaneRead,SaveMemMode,SaveGraphMode,SaveGCMisc,SavedWritePLane,SaveSC,SaveGC : Byte );
Begin
 SetReadPLane(SavePlaneRead);
 SetWritePlaneDirect(SavedWritePLane);

 Port[SC_INDEX] := SC_MEM_MODE;
 Port[SC_INDEX+1] := SaveMemMode;

 Port[GC_INDEX] := GC_GRAPH_MODE;
 Port[GC_INDEX+1] := SaveGraphMode;
 Port[GC_INDEX] := GC_MISC;
 Port[GC_INDEX+1] := SaveGCMisc;  {}

 Port[SC_INDEX] := SaveSC;
 Port[GC_INDEX] := SaveGC;
End;

Function GetCharsetData( ProcessData : pVideoProcess; DataBuffer : pByte; Var WriteByte : Word) : Word;
Var
   SavePlaneRead : Byte;
     SaveMemMode : Byte;
   SaveGraphMode : Byte;
      SaveGCMisc : Byte;
 SavedWritePLane : Byte;
    VideoSegment : Word;
   SaveSC,SaveGC : Byte;

Begin
 SaveRegsChar(SavePlaneRead,SaveMemMode,SaveGraphMode,SaveGCMisc,SavedWritePLane,SaveSC,SaveGC);

                                                  { 4 = 00000100 -> Text, lin. Addressen, V-Ram 64k bei $A000 }
                                                  { Bit 4 lschen (Trennung Gerade/Ungerade Addressem aufheben)}
 VideoSegment := $A000;

 With ProcessData^ do
  Begin
   If (65536 - TransMitted < ReturnBytes) then
    Begin
     FastCopy(MEM[VideoSegment:Transmitted],DataBuffer^,65536 - TransMitted);
     GetCharsetData := 0;
     WriteByte := 65536 - TransMitted;
    End
   Else
    Begin
     FastCopy(MEM[VideoSegment:TransMitted],DataBuffer^,ProcessData^.ReturnBytes);
     Inc(TransMitted,ReturnBytes);
     If TransMitted = 65536 then GetCharsetData := 0 else
     GetCharSetData := ReturnBytes;
     WriteByte := ReturnBytes;
    End;
  End;
                                                 { Das Memory-Mode Register "anwhlen" }
                                                 { Den aktuellen Modus auslesen }
 RestoreRegsChar(SavePlaneRead,SaveMemMode,SaveGraphMode,SaveGCMisc,SavedWritePLane,SaveSC,SaveGC);
End;

Function PutCharsetData( ProcessData : pVideoProcess; DataBuffer : pByte) : Word;
Var
   SavePlaneRead : Byte;
     SaveMemMode : Byte;
   SaveGraphMode : Byte;
      SaveGCMisc : Byte;
 SavedWritePLane : Byte;
    VideoSegment : Word;
   SaveSC,SaveGC : Byte;

Begin
 SaveRegsChar(SavePlaneRead,SaveMemMode,SaveGraphMode,SaveGCMisc,SavedWritePLane,SaveSC,SaveGC);
 VideoSegment := $A000;

 With ProcessData^ do
  Begin
   If (65536 - TransMitted < ReturnBytes) then
    Begin
     FastCopy(DataBuffer^,MEM[VideoSegment:Transmitted],65536 - TransMitted);
     PutCharsetData := 0;
    End
   Else
    Begin
     FastCopy(DataBuffer^,MEM[VideoSegment:TransMitted],ProcessData^.ReturnBytes);
     Inc(TransMitted,ReturnBytes);
     If TransMitted = 65536 then PutCharsetData := 0 else
     PutCharsetData := ReturnBytes;
    End;
  End;
 RestoreRegsChar(SavePlaneRead,SaveMemMode,SaveGraphMode,SaveGCMisc,SavedWritePLane,SaveSC,SaveGC);
End;

Function TransferCharset : Boolean;
Begin
 TransFerCharSet := ISTextMode;
End;

Function Get8Pointflag : Boolean;
{ Gibt TRUE zurck, wenn 9 Punkte por Zyklus erzeugt werden }
Var
 TempByte : Byte;
Begin
 TempByte := Port[$3C4];                         { Sequencer-Controller sichern }
 Port[$3C4] := $1;                               { Und das erste Register whlen }
 If Port[$3C5] and 1 = 1 then Get8PointFlag := TRUE else
                              Get8PointFlag := FALSE;
 Port[$3C4] := tempByte;                         { Das alte Register wider anwhlen }
End;
