{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
{ ************************************************************************** }
{ ***  CURSOR-Funktionen                                      (VI_CURSO) *** }
{ ***                                                                    *** }
{ ***  GetStartScanLine -> Gibt die Start-Scanzeile des blinkenden       *** }
{ ***                      Cursors zurck.                               *** }
{ ***  GetStopScanLine  -> Wie "GetStartScanLine", nur das die Endzeile  *** }
{ ***                      zurckgegeben wird.                           *** }
{ ***  CurSorOff        -> Dekativiert den Cursor                        *** }
{ ***  CurSorOn         -> Aktiviert den Cursor                          *** }
{ ***  ModifyCursor     -> ndert die Start- und die Stop-Scanzeile des  *** }
{ ***                      Cursors.                                      *** }
{ ***  GetCursorPos     -> Gibt die Cursor-Position als Word zurck      *** }
{ ***  SetCursorPos     -> Setzt die Cursor-Position, die mit GetC.Pos   *** }
{ ***                      ausgelesen wurde.                             *** }
{ ************************************************************************** }

Procedure ModifyCursor(StartScan,StopScan :Byte);
Begin
 WriteReg(REG_CRT,$0A,StartScan );
 WriteReg(REG_CRT,$0B,StopScan);
end;

Procedure CursorOff;
begin
 ModifyCursor(32,0);
end;

Procedure CursorOn;
begin
 ModifyCursor(8,31);   (* default scanning for color adapter set by DOS *)
end;

Function GetStartScanLine : Byte;
Begin
 GetStartScanLine := GetReg(REG_CRT,$0A);
End;

Function GetStopScanLine : Byte;
Begin
 GetStopScanLine := GetReg(REG_CRT,$0B);
End;

Function GetCurSorPos : Word;
Begin
 GetCurSorPos := Word(CursorPositions[MEM[BIOSDATASEG:BIO_CURRVIDPAGE]]);
End;

Procedure SetCurSorPos( CurWord : Word );
Begin
 GotoXY(Lo(CurWord)+1,Hi(CurWord)+1);
End;
