{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
{ **************************************************************************
  Diese Datei enthlt Routinen, die etwas mit VESA zu tun haben.

  Procedure SetWindow( BankNum : Byte; WinNum : Byte );
  -> Setzt das VESA-Zugriffsfenster

  Function GetWindow( WinNum : Byte ) : Word;
  -> Liefert die Position des VESA-Zugriffsfensters zurck

  Procedure FillModeInfoBuffer( Mode : Word );
  -> Fllt den temporren VESA-Informationspuffer.

  ************************************************************************** }

Procedure SetWindow( BankNum : Byte; WinNum : Byte ); {Assembler;
Asm
 Mov Dx, BankNum
 Mov Ax, 64
 Div BufWinGranularity
 Mov Ah, 0
 Mul BankNum
 Mov Dx, Ax                                      { DX = BankNum * ( 64 div BufWinGranularity ); }
{ Mov Ah, $4F
 Mov Al, 05
 Mov Bh, 00
 Mov Bl, WinNum

End;
{ Setzt das VESA-Zugriffsfenster. }
Var
 Regs : Registers;
Begin
 Regs.Ah := $4F;
 Regs.Al := 05;
 Regs.Bh := 00;
 Regs.Bl := WinNum;
 Regs.Dx := BankNum * ( 64 div BufWinGranularity );
 Intr($10,Regs);
End;

Function GetWindow( WinNum : Byte ) : Word;
{ Setzt das VESA-Zugriffsfenster. }
Var
 Regs : Registers;
Begin
 Regs.Ah := $4F;
 Regs.Al := 05;
 Regs.Bh := 01;
 Regs.Bl := WinNum;
 Intr($10,Regs);
 GetWindow := Regs.Dx;
End;


Procedure FillModeInfoBuffer( Mode : Word );
{ Fllt den Puffer mit Informationen ber den vorgegeben Modus }
Var
  Tmppt : Pointer;
   Regs : Registers;
  Lauf1 : Word;
Begin
 GetMem(Tmppt,SizeOf(tVesaModeInfo));
 With pVesaModeInfo(Tmppt)^ do
  Begin
   Regs.Ah := $4F;
   Regs.Al := $01;
   Regs.Cx := Mode;
   Regs.Es := Seg(pVesaModeInfo(Tmppt)^);
   Regs.Di := Ofs(pVesaModeInfo(Tmppt)^);
   Intr($10,Regs);

   VesaModeInBuffer := Mode;

   For Lauf1 := 1 to 2 do
    Begin
     If (WinAttr[Lauf1] and BIT_0) <> 0 then { Wenn das Fenster vorhanden ist ... }
      Begin
       If (WinAttr[Lauf1] and BIT_1) <> 0 then { Das Fenster ist lesbar !}
        Begin
         SelectedReadSegment := WinSegments[Lauf1];
         SelectedReadWindow := Lauf1 - 1;
        End;
       If (WinAttr[Lauf1] and BIT_2) <> 0 then { Das Fenster ist lesbar !}
        Begin
         SelectedWriteSegment := WinSegments[Lauf1];
         SelectedWriteWindow := Lauf1 - 1;
        End;
      End;
    End;
   BufModeAttr := ModeAttr;
   BufWinGranularity := WinGranularity;
   BufWinSize := WinSize;
   BufWinFuncPtr := WinFuncPtr;
   BufBytesPerScanLine := BufBytesPerScanLine;
   BufBitsPerPixel := BitsPerPixel;
   BufBankSize := BankSize;
  End;
 FreeMem(Tmppt,SizeOf(tVesaModeInfo));
End;

