{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
Unit Video;
INTERFACE
Uses Dos,Crt,ProgVars,FastCop;
{ **************************************************************************
 Modifikationen :
 24.04.1996 : Ich habe diese Unit stark erweitert.
 27.04.1996 : Interressant. Beim Erweitern der Bildschirmodi habe ich
              festgestellt, das fr den Modus $13 nur die Grsse des Speichers
              sowie die Erweiterung der Bedingung fr den Modus $2 und $3 auf
              $13 und dort eine Anpassung der Bildschirmbasisaddresse beim
              Modus $13 ntig war. Eine generelle Neuentwicklung der Routinen
              war nicht ntig !
 05.05.1996 : Endlich. Die Routinen fr den Modus $13 mit den vier Bildschirmseiten
              scheinen zu funktionieren. Ich werde sie nun ein wenig optimieren und
              eine Abfrage beim bertragen des Bildschirmes einbauen, welcher
              der beieden $13 Modi aktiv ist.
 20.05.1996 : Ich habe einen Fehler gefunden. Dieser usserte sich darin, das
              Spiele wie "DOOM" eine fehlerhafte Bildschirmdarstellung hatten.
              Die Ursache des Fehlers war das Verndern des aktuellen Registers
              in dem Controller, der die Write-Map verwaltet, um festzustellen ob
              der modifizierte Modus $13 aktiv ist. Dadurch waren Spiele, die bei
              jedem ndern der aktuellen Plane nicht vorher das Write-Map-Register
              setzten (um Zeit zu sparen) sehr "irritiert", da die Plane-Daten nun
              in einem anderen Register des Sequencer-Controllers landeten. Ein
              auslesen des aktiven Registers des SC und ein Zurckschrieben nach dem
              Ende der Operation schaffte Abhilfe.

 Ideen und Verbesserungsvorschlge :
  - Man mu beim fertigen Programm die Abfrage der Start und der Stop-Scanzeile
    der Cursors neu gestalten. (Die jetztige Funktion ist nur in Textmodi gltig.
  - Man sollte bei Mehr-Seiten-Modi die bertragung velleicht ein bisschen
    intelligenter gestalten indem man immer erst eine Bildschirmseite komplett
    bertrgt, um dann erst die Umschaltung zur neuen, aktuellen Seite durchzufhren.
    (Es ist aber infragezustellen, ob man dadurch eine Verbesserung der Situation erreicht)

  ************************************************************************** }


Type
        pVram = ^VRAm;
         VRam = Array[1..80,1..25] of Word;

Var
       CBuf   : Byte absolute $B800:0000;           { der color Video-RAM }
         Sptr : pVRam;

Const
   NotClear = TRUE;                              { Beim Videomodussetzen den Bildschirm nicht lschen }
      Clear = FALSE;                             { Beim Videomodussetzen den Bildschirm lschen }

{ ************************************************************************** }
{ *** Graphic-Controller                                                 *** }
{ ************************************************************************** }
Const
 GC_INDEX       = $3ce;             {Indexregister des Graphics-Ctrl.         }
 GC_MISC        = 6;               { Nummer des Miscellaneous-Registers des GC }
 GC_GRAPH_MODE  = 5;
 GC_READ_MAP    = 4   ;             {Nummer des Read-Map-Registers           }
 GC_MISCELL     = 6  ;             {Nummer des Miscellaneous-Registers }

{ ************************************************************************** }
{ *** CRT-Controller                                                     *** }
{ ************************************************************************** }
              REG_CRT = $3D4;                    { Das Indexregister des CRT-Controllers }
{ Die Bedeutung der einzelnen Register bitte aus PC-INTERN o.. entnehmen }
      SUBREG_HORTOTAL = $0;
       SUBREG_HORDISP = $1;
      SUBREG_VERTOTAL = $06;
      SUBREG_OVERFLOW = $07;
   SUBREG_MAXSCANLINE = $09;
   SUBREG_STARTADDRHI = $0D;
   SUBREG_STARTADDRLO = $0D;

SUBREG_VERTRETRACEEND = $11;



     REG_MISCOUTWRITE = $3C2;
      REG_MISCOUTREAD = $3CC;

{ ************************************************************************** }
{ *** Sequencer-Controller                                               *** }
{ ************************************************************************** }
       REG_SEQCONTROL = $3C4;
  SUBREG_CLOCKINGMODE = $1;
       SUBREG_CHARMAP = $3;
       SUBREG_MEMMODE = $4;
 SC_INDEX       = $3c4;            {Indexregister des Sequencer-Ctrl.  }
 SC_MAP_MASK    = 2   ;            {Nummer des Map-Mask-Registers     }
 SC_MEM_MODE    = 4;               { Nummer des Memory-Mode - Registers }
 SC_RESET       = 0;


{ ************************************************************************** }
{ *** Attribute-Controller                                               *** }
{ ************************************************************************** }
 REG_ATTRCONTROLWRITE = $3C0;
 REG_ATTRCONTROLREAD  = $3C1;

 SUBREG_HORPELPANNING = $13;
   SUBREG_MODECONTROL = $10;


CRTC_INDEX     = $3d4;     {        ;Indexregistes des CRT-Controllers }
CC_MAX_SCAN    = 9   ;     {        ;Nummer des Maximum-Scan-Line-Reg. }
CC_START_HI    = $0C ;     {        ;Nummer des Hi-Start-Registers     }
CC_UNDERLINE   = $14 ;     {        ;Nummer des Underline-Registers     }
CC_MODE_CTRL   = $17  ;    {        ;Nummer des Mode-Control-Registers }


           SCREENSIZE = $4C;                     { Die Bios-Speicherstelle fr den Umfang einer Schirmseite im BIOS-Datenseg}
    BIO_CURSSTARTSCAN = $60;
     BIO_CURSSTOPSCAN = $61;
      BIO_CURRVIDPAGE = $62;

Type
 tGetVideoDataProc = Function(  ProcessData : pVideoProcess; DataBuffer : pByte; Var WriteByte : Word) : Word;
 tPutVideoDataProc = Function( ProcessData : pVideoProcess; DataBuffer : pByte) : Word;

Var
      CurrentVideoPage : Byte absolute $0040:$62;
       CursorPositions : Array[0..7] of WordRec absolute $0040:$50;

        XLastVideoMode : Word;

{ ************************************************************************** }
{ ***  CURSOR-Funktionen                                      (VI_CURSO) *** }
{ ***                                                                    *** }
{ ***  GetStartScanLine -> Gibt die Start-Scanzeile des blinkenden       *** }
{ ***                      Cursors zurck.                               *** }
{ ***  GetStopScanLine  -> Wie "GetStartScanLine", nur das die Endzeile  *** }
{ ***                      zurckgegeben wird.                           *** }
{ ***  CurSorOff        -> Dekativiert den Cursor                        *** }
{ ***  CurSorOn         -> Aktiviert den Cursor                          *** }
{ ***  ModifyCursor     -> ndert die Start- und die Stop-Scanzeile des  *** }
{ ***                      Cursors.                                      *** }
{ ***  GetCursorPos     -> Gibt die Cursor-Position als Word zurck      *** }
{ ***  SetCursorPos     -> Setzt die Cursor-Position, die mit GetC.Pos   *** }
{ ***                      ausgelesen wurde.                             *** }
{ ************************************************************************** }
Function GetStopScanLine : Byte;
Function GetStartScanLine : Byte;
Function GetCurSorPos : Word;
Procedure CursorOff;
Procedure CursorOn;
Procedure ModifyCursor(StartScan,StopScan :Byte);
Procedure SetCurSorPos( CurWord : Word );

{ ************************************************************************** }
{ ***  MODUS-Funktionen                                                  *** }
{ ***                                                                    *** }
{ *** GetVideoMode      -> Gibt den Videomodus zurck, der in der        *** }
{ ***                      Variablen gespeichert ist, die mit jedem      *** }
{ ***                      Modus-Wechsel aktualisiert wird.              *** }
{ *** GetRealVideoMode  -> Liest den Videomodus per Interruptaufruf aus  *** }
{ *** SetVideoMode      -> Setzt den mit "Mode" angegebenen Modus,       *** }
{ ***                      mit gesetztem "ClearVideo"-Flag wird der      *** }
{ ***                      Bildschirminhalt gelscht, ansonsten wird der *** }
{ ***                      Inhalt gesichert.                             *** }
{ *** IsTextMode        -> True, wenn der Modus als Textmodus behandelt  *** }
{ ***                      wird.                                         *** }
{ ************************************************************************** }
Function GetVideoMode : Word;
Function GetRealVideoMode : Word;
Procedure SetVideoMode( Mode : Word; ClearVideo : Boolean );
Function IsTextMode : Boolean;








{ Ermittelt den Speicherbedarf in Bytes fr den aktuellen Videomodus }

Function GetVideoData( ProcessData : pVideoProcess; DataBuffer : pByte; Var WriteByte : Word) : Word;
{ Gibt soviel Daten in "DataBuffer" zurck, wie in Processdata angegeben. Dabei
  werden die Daten ab dem in Processdata abgelegtem Byte weiter ermittelt. Die
  Anzahl an tatschlich gelesenen Bytes wird in "WriteByte" zurckgegeben. }
Function PutVideoData( ProcessData : pVideoProcess; DataBuffer : pByte) : Word;

{ ************************************************************************** }
{ *** Erlangen Palettendaten                                             *** }
{ ************************************************************************** }
Function PutPaletteData( ProcessData : pVideoProcess; DataBuffer : pByte) : Word;
Function GetPaletteData( ProcessData : pVideoProcess; DataBuffer : pByte; Var WriteByte : Word ) : Word;


Procedure SetWritePlane( Plane : Byte );
Procedure SetReadPlane( Plane : Byte );

Procedure SaveScreen;
Procedure RestoreScreen;

Function PutCharsetData( ProcessData : pVideoProcess; DataBuffer : pByte) : Word;
Function GetCharsetData( ProcessData : pVideoProcess; DataBuffer : pByte; Var WriteByte : Word) : Word;


Function TransferCharset : Boolean;

Procedure WriteAttributeReg( Reg : Byte; Num : Byte );
Function ReadAttributeReg( Reg : Byte ) : Byte;

Function GetMaxtransmitSize( VioMode : Word ) : LongInt;
Procedure SetMaxTransmitSizeForMode( VioMode : Word );


Procedure SetVGARegistersForTextMode(
 Var ModeControl, MiscOutReg,ClockingModeReg,HorizontalPelPanning : Byte; Var CrtBytes : tCrtByteArray );
Procedure GetVGARegistersForTextMode(
 Var ModeControl, MiscOutReg,ClockingModeReg,HorizontalPelPanning : Byte; Var CrtBytes : tCrtByteArray );

Function GetReg( Reg, SubReg : Word ) : Byte;
Procedure WriteReg( Reg, SubReg : Word; Data : Byte );


{ ************************************************************************** }
{ *** VESA-Routinen                                                      *** }
{ ************************************************************************** }
Procedure SetWindow( BankNum : Byte; WinNum : Byte );
{ *** Setzt das VESA-Zugriffsfenster WinNum auf Bank BankNum *** }

Function GetWindow( WinNum : Byte ) : Word;
{ *** Liefert die aktuelle Bank vom Fenster Winnum zurck *** }

Function IsVesaMode( Mode : Word ) : Boolean;
{ *** Gibt zurck, ob Mode ein VESA-Modus ist. *** }

Procedure SetModifyedMode13;
Function IsModifyedMode13 : Boolean;

Const
 MinMode = 0;                                    { Der "kleinste" aktivierte Modus }
 MaxMode = $13;                                  { Der "grsste" aktivierte Modus }

{$I VI_CONST}

{ *** Prozeduren - Arrays mit den Prozeduren zum sichern und herstellen  *** }
{ *** Des jeweiligen Bildschirmkontextes.                                *** }
   PutProc_Video = 1;
 PutProc_Palette = 2;
 PutProc_Charset = 3;

   GetProc_Video = 1;
 GetProc_Palette = 2;
 GetProc_Charset = 3;

 PutProcs : Array[1..3] of tPutVideoDataProc =
             (PutVideoData,PutPaletteData,PutCharsetData);

 GetProcs : Array[1..3] of tGetVideoDataProc =
            (GetVideoData,GetPaletteData,GetCharsetData);



IMPLEMENTATION

Const
{ Hier kommen die Bit-wertigkeiten }
 BIT_0  = 1;
 BIT_1  = 2;
 BIT_2  = 4;
 BIT_3  = 8;
 BIT_4  = 16;
 BIT_5  = 32;
 BIT_6  = 64;
 BIT_7  = 128;
 BIT_8  = 256;
 BIT_9  = 512;
 BIT_10 = 1024;
 BIT_11 = 2048;
 BIT_12 = 4096;
 BIT_13 = 8192;
 BIT_14 = 16384;
 BIT_15 = 32768;

{$I VI_VESA}
{$I VI_MODES}
{$I VI_PORTS}

Procedure SetWritePlaneDirect( Plane : Byte );
Begin
 WriteReg(SC_INDEX,SC_MAP_MASK,PLane);
End;

Procedure SetWritePlane( Plane : Byte );
Begin
 SetWritePlaneDirect(1 shl PLane);
End;


Function GetWritePlane : Byte;
Const
 SC_INDEX       = $3c4;            {Indexregister des Sequencer-Ctrl.  }
 SC_MAP_MASK    = 2   ;            {Nummer des Map-Mask-Registers     }

Begin
 Port[SC_INDEX] := SC_MAP_MASK;
  GetWritePlane := Port[SC_INDEX+1]
End;

Function GetReadPlane : Byte;
Begin
 GetReadPlane := GetReg(GC_INDEX,GC_READ_MAP);
End;

Procedure SetReadPlane( Plane : Byte );
Begin
 WriteReg(GC_INDEX,GC_READ_MAP,Plane);
End;

Function IsModifyedMode13 : Boolean;
{ Gibt True zurck, wenn der 4 Bilschirmseiten Modus Nrr. 13 aktiv ist. }
Var
 Register4 : Byte;
Begin
 If GetReg(REG_SEQCONTROL,SUBREG_MEMMODE) and (BIT_3 + BIT_2) = BIT_2 then
    IsModifyedMode13 := TRUE else                { Dann ist "Tweaked-Mode 13" aktiv }
    IsModifyedMode13 := FALSE;                   { Ansonsten nicht ! }
End;

Procedure SetModifyedMode13; Assembler;
asm
 mov   dx,GC_INDEX
 mov   al,GC_GRAPH_MODE
 out   dx,al
 inc   dx
 in    al,dx
 and   al,11101111b
 out   dx,al
 dec   dx

 mov   al,GC_MISCELL
 out   dx,al
 inc   dx
 in    al,dx
 and   al,11111101b
 out   dx,al

 mov   dx,SC_INDEX
 mov   al,SC_MEM_MODE
 out   dx,al
 inc   dx
 in    al,dx
 and   al,11110111b
 or    al,4
 out   dx,al

 mov   dx,CRTC_INDEX
 mov   al,CC_UNDERLINE
 out   dx,al
 inc   dx
 in    al,dx
 and   al,10111111b
 out   dx,al
 dec   dx

 mov   al,CC_MODE_CTRL
 out   dx,al
 inc   dx
 in    al,dx
 or    al,01000000b
 out   dx,al

End;

{$I VI_CURSO}

Procedure SaveScreen;
Begin
 GetMem(Sptr,SizeOf(VRam));
 FastCopy(Cbuf,Sptr^,4000);
End;

Procedure RestoreScreen;
Begin
 FastCopy(Sptr^,CBuf,4000);
 FreeMem(Sptr,SizeOf(VRam));
End;

Function GetMaxtransmitSize( VioMode : Word ) : LongInt;
BEgin
 If ((VioMode >= 0) and (VioMode < $14)) then GetMaxTransmitSize := Max_Transmit[VioMode] else
 If ((VioMode > $100) and (VioMode < $11B)) then GetMaxTransmitSize := VesaTransmit[VioMode] else
  GetMaxTransmitSize := 0;
End;

Procedure SetMaxTransmitSizeForMode( VioMode : Word );
Var
 Lauf1,Lauf2,Lauf3 : Word;
Begin
 Lauf1 := GetReg(REG_CRT,SUBREG_HORDISP);
 Lauf3 := Port[REG_MISCOUTREAD];
 Lauf3 := Lauf3 and (BIT_6 + BIT_7 );

 Case Lauf3 of
    0 : Lauf3 := 0;   { RESET ?!? }
   64 : Lauf3 := 350; { BITS 01 -> 350 Pkt. zeilen }
  128 : Lauf3 := 400; { BITS 10 -> 400 Pkt. zeilen }
  192 : Lauf3 := 480; { BITS 11 -> 480 Pkt. zeilen }
 End;

 { Jetzt steht in dem WordRec Lauf3 die Anzahl an Punktzeilen. }
 { Jetzt muss ich noch die Hhe der einzelnen Zeichen erlangen, um }
 { daraus die Anzahl an Zeilen zu erlangen. }

 Lauf2 := GetReg(REG_CRT,SUBREG_MAXSCANLINE);
 Lauf2 := Lauf2 and Not( BIT_5 + BIT_6 + BIT_7 ); { Und die Bits ausblenden, die } { unntig sind. }
 Lauf2 := Lauf3 div Lauf2; { Die Anzahl der Zeilen ermitteln. }
 Lauf2 := Lauf2 * Lauf1 * 2;

 If MemW[BIOSDATASEG:SCREENSIZE] >= Lauf2 then { Kontrollieren, ob velleicht nicht }
 MAX_TRANSMIT[VioMode] := MemW[BIOSDATASEG:SCREENSIZE] else
 MAX_TRANSMIT[VioMode] := Lauf2; { normalerweise mehr transferriert werden }
                                                                     { sollte. In diesem Falle den Standard transferrieren. }
End;

{$I VI_VIDEO}
{$I VI_PALET}
{$I VI_CHARS}

Procedure SetVGARegistersForTextMode(
 Var ModeControl, MiscOutReg,ClockingModeReg,HorizontalPelPanning : Byte; Var CrtBytes : tCrtByteArray );
Var
 Lauf1,Lauf2 : Word;

Begin
 Port[REG_MiscOutWrite] := MiscOutReg;

 Lauf1 := ReadAttributeReg(SUBREG_HORPELPANNING);
 { Das alte Register einlesen und die Bits ausblenden. Dann die neuen Bits setzen}
 Lauf1 := Lauf1 and Not( BIT_0 + BIT_1 + BIT_2 + BIT_3 );
 Lauf1 := HorizontalPelPanning or Lauf1;
 WriteAttributeReg(SUBREG_HORPELPANNING,Lauf1);

 Lauf1 := ReadAttributeReg(SUBREG_MODECONTROL);
 { Das alte Register einlesen und die Bits ausblenden. Dann die neuen Bits setzen}
 Lauf1 := Lauf1 and Not( BIT_3 );
 Lauf1 := ModeControl or Lauf1;
 WriteAttributeReg(SUBREG_MODECONTROL,Lauf1);

 Lauf1 := GetReg(REG_SeqControl,SUBREG_CLOCKINGMODE);
 Lauf1 := Lauf1 and not( BIT_0 );
 Lauf1 := Lauf1 or ClockingModeReg;
 WriteReg(REG_SEQControl,SUBREG_CLOCKINGMODE,Lauf1);


 Lauf1 := GetReg(REG_CRT,SUBREG_VERTRETRACEEND);
 WriteReg(REG_CRT,SUBREG_VERTRETRACEEND,Lauf1 and Not(BIT_7));

 For Lauf1 := 6 to $16 do
  Begin
   If (Lauf1 = 6) or (Lauf1 = $10) or (Lauf1 = $12) or
      (Lauf1 = 7) or (Lauf1 = $15) or (Lauf1 = $16) then
    Begin
     WriteReg(REG_CRT,Lauf1,CrtBytes[Lauf1]);
    End;
  End;
End;

Procedure GetVGARegistersForTextMode(
 Var ModeControl, MiscOutReg,ClockingModeReg,HorizontalPelPanning : Byte; Var CrtBytes : tCrtByteArray );
Var
 Lauf1 : Word;
Begin
 HorizontalPelPanning := ReadAttributeReg(SUBREG_HORPELPANNING);
 HorizontalPelPanning := HorizontalPelPanning and ( BIT_0 + BIT_1 + BIT_2 + BIT_3 );

 ModeControl := ReadAttributeReg(SUBREG_MODECONTROL);
 ModeControl := ModeControl and BIT_3;

 MiscOutReg := POrt[REG_MISCOUTRead];

 ClockingModeReg := GetReg(REG_SeqControl,SUBREG_CLOCKINGMODE);
 ClockingModeReg := ClockingModeReg and BIT_0;

 Lauf1 := GetReg(REG_CRT,SUBREG_VERTRETRACEEND);
 Lauf1 := Lauf1 or BIT_7;

 WriteReg(REG_CRT,SUBREG_VERTRETRACEEND,Lauf1);

 For Lauf1 := 6 to $16 do
  Begin
   If (Lauf1 = 6) or (Lauf1 = $10) or (Lauf1 = $12) or
      (Lauf1 = 7) or (Lauf1 = $15) or (Lauf1 = $16) then
    Begin
     CrtBytes[Lauf1] := GetReg(REG_CRT,Lauf1);
    End;
  End;
End;

End.