{Die Routinen des Direct-Drive-Access Dialogs von HEXEDIT}

FUNCTION GetLabel(Drive: BYTE): STRING;

VAR
SR : SearchRec;
SearchDrive: PathStr;
DriveLabel : STRING[12];

BEGIN
IF Drive = 0 THEN
GetDir(0, SearchDrive)
ELSE
SearchDrive := Chr(Drive + 64);
SearchDrive := SearchDrive[1];
FindFirst(SearchDrive + ':\*.*', VolumeID, SR);
IF DosError = 0 THEN
BEGIN
DriveLabel := SR.Name;
IF Pos('.', DriveLabel) > 0 THEN
Delete(DriveLabel, Pos('.', DriveLabel), 1);
END
ELSE
DriveLabel := '';
GetLabel := DriveLabel;
END;

FUNCTION IOGeneric(Drive: BYTE; What: BYTE; VAR Struct): INTEGER;

VAR
Regs : Registers;

BEGIN
WITH Regs DO BEGIN
AH := $44;
AL := $0D;
BL := Drive;
CH := $08;
CL := What;
DS := Seg(Struct);
DX := Ofs(Struct);
Intr($21, Regs);
IF Odd(Flags) THEN
IOGeneric := AX
ELSE
IOGeneric := 0;
END;
END;

FUNCTION DiskRead(Drive: BYTE; Head, Cyl, First, Num: WORD; VAR Buffer): INTEGER;

VAR
RW : RWBlock;

BEGIN
RW.SpecialFunctions := 0;
RW.Head := Head;
RW.Cylinder := Cyl;
RW.FirstSector := First - 1;
RW.NumberOfSectors := Num;
RW.TransferAddress := @Buffer;
DiskRead := IOGeneric(Drive, $61, RW);
END;

FUNCTION DiskWrite(Drive: BYTE; Head, Cyl, First, Num : WORD; VAR Buffer): INTEGER;

VAR
RW : RWBlock;

BEGIN
RW.SpecialFunctions := 0;
RW.Head := Head;
RW.Cylinder := Cyl;
RW.FirstSector := First - 1;
RW.NumberOfSectors := Num;
RW.TransferAddress := @Buffer;
DiskWrite := IOGeneric(Drive, $41, RW);
END;

FUNCTION ReadBootSector(Drive: BYTE; VAR Buffer; Partition : BOOLEAN): INTEGER;

VAR
R : INTEGER;

BEGIN
IF Drive < 3 THEN
R := DiskRead(Drive, 0, 0, 1, 1, Buffer)
ELSE
BEGIN
IF Partition THEN
R := DiskRead(Drive, 0, 0, 1, 1, Buffer)
ELSE
R := DiskRead(Drive, 1, 0, 1, 1, Buffer);
END;
ReadBootSector := R;
END;

FUNCTION WriteBootSector(Drive: BYTE; VAR Buffer; Partition : BOOLEAN): INTEGER;

VAR
R : INTEGER;

BEGIN
IF Drive < 3 THEN
R := DiskWrite(Drive, 0, 0, 1, 1, Buffer)
ELSE
BEGIN
R := DiskWrite(Drive, 1, 0, 1, 1, Buffer);
IF Partition THEN
R := DiskWrite(Drive, 0, 0, 1, 1, Buffer);
END;
WriteBootSector := R;
END;

PROCEDURE DoBootSector;

VAR
Action, CurDrive : BYTE;
Free, Full, Comma1, Comma2 : LONGINT;

BEGIN
SaveScreen;
HideCursor;
Action := 1;
FoldOffWindow(' Open Drive ', 24, 7, 50, 13, Cyan, Yellow, 1);
InfoBar(Drive1);
StatusBar('WAITING...');
TextColor(Black);
TextBackGround(LightCyan);
GotoXY(26, 10);
Write('2) Read Boot System');
GotoXY(26, 11);
Write('3) Write Boot System (!)');
GotoXY(26, 9);
TextColor(White);
TextBackGround(Blue);
Write('1) Drive Info           ');
REPEAT
REPEAT
C := ReadKey;
IF C = #0 THEN
C := ReadKey;
UNTIL C IN [#27, #13, #80, #72, '1', '2', '3', '4', '5'];
IF C IN ['1', '2', '3'] THEN
Action := Ord(C)-48;
IF (C = #72) AND (Action > 1) THEN
Dec(Action);
IF (C = #80) AND (Action < 3) THEN
Inc(Action);
CASE Action OF
1 :
BEGIN
TextColor(White);
TextBackground(Blue);
GotoXY(25, 9);
Write(' 1) Drive Info           ');
TextColor(Black);
TextBackground(LightCyan);
GotoXY(25, 10);
Write(' 2) Read Boot System     ');
GotoXY(25, 11);
Write(' 3) Write Boot System (!)');
END;
2 :
BEGIN
TextColor(White);
TextBackground(Blue);
GotoXY(25, 10);
Write(' 2) Read Boot System     ');
TextColor(Black);
TextBackground(LightCyan);
GotoXY(25, 9);
Write(' 1) Drive Info           ');
GotoXY(25, 11);
Write(' 3) Write Boot System (!)');
END;
3 :
BEGIN
TextColor(White);
TextBackground(Blue);
GotoXY(25, 11);
Write(' 3) Write Boot System (!)');
TextColor(Black);
TextBackground(LightCyan);
GotoXY(25, 9);
Write(' 1) Drive Info           ');
GotoXY(25, 10);
Write(' 2) Read Boot System     ');
END;
END;
UNTIL C IN [#27, #13];
IF C = #13 THEN
BEGIN
RestoreScreen;
CurDrive := 3;
InfoBar(Drive2);
StatusBar('WAITING...');
FoldOffWindow(' Open Drive ', 24, 7, 50, 11, Cyan, Yellow, 1);
GotoXY(26, 9);
TextBackground(LightCyan);
TextColor(Black);
Write('Drive: ');
TextColor(Blue);
Write('-');
REPEAT
REPEAT
REPEAT
C := ReadKey;
REPEAT
IF C = #0 THEN
BEGIN
C := ReadKey;
C := ReadKey;
END;
UNTIL C <> #0;
UNTIL C IN [#27, #13, 'A'..'Z', 'a'..'z'];
IF C IN ['A'..'Z', 'a'..'z'] THEN
BEGIN
GotoXY(33, 9);
Write(UpCase(C)+':');
CurDrive := Ord(UpCase(C))-64;
END;
UNTIL C IN [#27, #13];
IF C = #13 THEN
BEGIN
StatusBar('EXAMAINING DRIVE...');
GetDir(0, Dir);
ChDir(Chr(CurDrive + 64) + ':\');
IF IOResult <> 0 THEN
BEGIN
InfoBar(UpCase(C)+': doesn''t exist/is not ready.'+#10#13#32#32+'Press any key to get back to the File-Open Dialog...');
FoldOffWindow(' Note ', 24, 11, 52, 14, Red, Yellow+Blink, 3);
TextBackground(Red);
TextColor(White);
GotoXY(31, 12);
Write('Drive not ready!');
GotoXY(26, 13);
Write('Press a key to continue...');
ReadKey;
RestoreScreen;
CurDrive := 3;
InfoBar(Drive2);
FoldOffWindow(' Open Drive ', 24, 7, 50, 13, Cyan, Yellow, 1);
GotoXY(26, 9);
TextBackground(LightCyan);
TextColor(Black);
Write('Drive: ');
TextColor(Blue);
Write('-');
CurDrive := 0;
ChDir(Dir);
END;
ChDir(Dir);
END;
UNTIL CurDrive <> 0;
END;
RestoreScreen;
IF (Action = 1) AND (C = #13) THEN
BEGIN
FoldOffWindow(' Info - '+Chr(CurDrive+64)+': ', 24, 7, 56, 13, Cyan, Yellow, 1);
InfoBar(Drive3);
StatusBar('WAITING...');
Free := DiskSize(CurDrive);
Full := DiskFree(CurDrive);
Comma1 := Free MOD (1024*1024);
Str(Comma1, Temp);
Temp[0] := #2;
Comma2 := Full MOD (1024*1024);
Str(Comma2, TempS);
TempS[0] := #2;
Free := Free DIV (1024*1024);
Full := Full DIV (1024*1024);
TextBackGround(LightCyan);
TextColor(Black);
GotoXY(26, 9);
Write('Capacity of Drive: ', Free, '.' + Temp + ' MB');
GotoXY(26, 10);
Write('Free capacity:     ', Full, '.'+ TempS + ' MB');
GotoXY(26, 12);
TempS := GetLabel(CurDrive);
IF TempS = '' THEN
TempS := '-- --';
Write('Drive - Label: ' + TempS);
ReadKey;
RestoreScreen;
END;
IF (Action IN [2, 3]) AND (C = #13) THEN
IF (Action = 3) OR (DoSaveAs) THEN
BEGIN
HideCursor;
IF (Lo(DosVersion) >= 20) OR (DosVersion <= $31E)  THEN
BEGIN
IF (Lo(DosVersion) > 9) THEN
InfoBar('This feature doesn''t work with OS/2'+#10#13#32#32+'Press any key to get back to the File-Open Dialog...')
ELSE
InfoBar('Your DOS-Version must be higher than 3.30'+#10#13#32#32+'Press any key to get back to the File-Open Dialog...');
FoldOffWindow(' Note ', 24, 11, 52, 14, Red, Yellow+Blink, 3);
TextBackground(Red);
TextColor(White);
GotoXY(26, 12);
Write('Wrong operating System!');
GotoXY(26, 13);
Write('Press a key to continue...');
ReadKey;
RestoreScreen;
DoOpen;
IF FileName = '' THEN
EndUp('');
END
ELSE
BEGIN
ChDir(Chr(CurDrive + 64) + ':\');
IF Action = 2 THEN
BEGIN
StatusBar('READING BOOT-SYSTEM...');
IF CurDrive < 3 THEN
BEGIN
Free := ReadBootSector(CurDrive, FileArea, FALSE);
IF Free <> 0 THEN
EndUp('Error reading Boot-Sector - Stopped!');
EndPos := 511;
END
ELSE
BEGIN
Free := ReadBootSector(CurDrive, FileArea, FALSE);
IF Free <> 0 THEN
EndUp('Error reading Boot-Sector - Stopped!');
Free := ReadBootSector(CurDrive, FileArea[512], TRUE);
EndPos := 1023;
END;
FileName := Chr(CurDrive+64)+'.BSF';
IF Free <> 0 THEN
EndUp('Error reading Drive - Stopped...');
Assign(WorkFile, FileName);
SetFAttr(WorkFile, Archive);
ReWrite(WorkFile, 1);
IF IOResult <> 0 THEN
EndUp('Cannot create File - Stopped...');
FileType := New;
FileState := UnChanged;
BackUp := FALSE;
BackUpName := '';
CurPos := 0;
CursorPos := 0;
Position := 0;
MaxBlocks := 1;
Blocks := 0;
Index := 0;
FSize := EndPos+1;
FileAttr := Archive + ReadOnly + Hidden;
BlockWrite(WorkFile, FileArea, FSize, I);
IF I <> FSize THEN
EndUp('Not enough space to create File...');
TextBackground(Blue);
TextColor(White);
GotoXY(12, 24);
WriteLn('            ');
GotoXY(12, 24);
FSplit(FileName, TempS, Temp, BackUpName);
Temp := Temp+BackUpName;
WriteLn(Temp);
UpDatePosition;
UpDateSize(FSize);
UpDateView;
END
ELSE
BEGIN
StatusBar('WRITING BOOT-SYSTEM...');
IF CurDrive < 3 THEN
Free := 512
ELSE
Free := 1024;
IF FileSize(WorkFile) <> Free THEN
BEGIN
InfoBar('Boot-System can not be written!'+#10#13#32#32+'Press any key to get back to the File-Open Dialog...');
FoldOffWindow(' Note ', 24, 11, 52, 14, Red, Yellow+Blink, 3);
TextBackground(Red);
TextColor(White);
GotoXY(26, 12);
Write('Wrong Filesize!');
GotoXY(26, 13);
Write('Press a key to continue...');
ReadKey;
RestoreScreen;
END
ELSE
BEGIN
InfoBar('Please confirm your choice by pressing ''y'' or'+#10#13#32#32+'press ''n'' to get back to the File-Open Dialog!');
FoldOffWindow(' Note ', 24, 11, 52, 14, Red, Yellow+Blink, 3);
TextBackground(Red);
TextColor(White);
GotoXY(26, 12);
Write('Write Boot-System!');
GotoXY(26, 13);
Write('Are you sure [Y/N]: ');
BlockCursor;
REPEAT
C := ReadKey;
UNTIL C IN ['Y', 'y', 'N', 'n', #27];
HideCursor;
IF C IN ['Y', 'y'] THEN
BEGIN
Free := WriteBootSector(CurDrive, FileArea, FALSE);
IF Free <> 0 THEN
EndUp('Error writing Boot-Sector - Stopped!');
IF CurDrive >= 3 THEN
Free := WriteBootSector(CurDrive, FileArea[512], TRUE);
IF Free <> 0 THEN
EndUp('Error writing Boot-Sector - Stopped!');
InfoBar('Press any key to get to the File-Open Dialog!');
FoldOffWindow(' Note ', 24, 11, 52, 14, Blue, Yellow+Blink, 3);
TextBackground(Blue);
TextColor(White);
GotoXY(26, 12);
Write('Finished successfully!');
GotoXY(26, 13);
Write('Press a key... ');
ReadKey;
END;
END;
RestoreScreen;
DoOpen;
IF FileName = '' THEN
EndUp('');
END;
END;
END;
Reduce := NOT Reduce;
DoReduce;
SetCursor(StartCursor);
ShowCursor;
END;

